
/******************************  LICENSE  *******************************

 * (C) Copyright 1996-2017 ECMWF.
 *
 * This software is licensed under the terms of the Apache Licence Version 2.0
 * which can be obtained at http://www.apache.org/licenses/LICENSE-2.0.
 * In applying this licence, ECMWF does not waive the privileges and immunities
 * granted to it by virtue of its status as an intergovernmental organisation nor
 * does it submit to any jurisdiction.

 *******************************  LICENSE  *******************************/

/*! \\file InputDataAttributes.h
    \\brief Definition of InputData Attributes class.

    This file is automatically generated.
    Do Not Edit!
*/

#include "InputDataAttributes.h"
#include "MagicsParameter.h"
#include "ParameterSettings.h"

using namespace magics;

InputDataAttributes::InputDataAttributes():
	type_(ParameterManager::getString("input_type")),
	x_type_(ParameterManager::getString("input_x_type")),
	y_type_(ParameterManager::getString("input_y_type")),
	x_(ParameterManager::getDoubleArray("input_x_values")),
	y_(ParameterManager::getDoubleArray("input_y_values")),
	date_x_(ParameterManager::getStringArray("input_date_x_values")),
	date_y_(ParameterManager::getStringArray("input_date_y_values")),
	x2_(ParameterManager::getDoubleArray("input_x2_values")),
	y2_(ParameterManager::getDoubleArray("input_y2_values")),
	date_x2_(ParameterManager::getStringArray("input_date_x2_values")),
	date_y2_(ParameterManager::getStringArray("input_date_y2_values")),
	x_missing_(ParameterManager::getDouble("input_x_missing_value")),
	y_missing_(ParameterManager::getDouble("input_y_missing_value")),
	values_(ParameterManager::getDoubleArray("input_values")),
	latitudes_(ParameterManager::getDoubleArray("input_latitude_values")),
	longitudes_(ParameterManager::getDoubleArray("input_longitude_values")),
	x_component_(ParameterManager::getDoubleArray("input_x_component_values")),
	y_component_(ParameterManager::getDoubleArray("input_y_component_values")),
	input_automatic_(ParameterManager::getBool("input_automatic"))
	,
	input_binning_(MagTranslator<string, BinningObject>().magics("input_binning"))
	
{
}


InputDataAttributes::~InputDataAttributes()
{

}


void InputDataAttributes::set(const std::map<string, string>& params)
{
	vector<string> prefix(1);
	int i = 0;
	prefix[i++] = "";
	
	setAttribute(prefix, "input_type", type_, params);
	setAttribute(prefix, "input_x_type", x_type_, params);
	setAttribute(prefix, "input_y_type", y_type_, params);
	setAttribute(prefix, "input_x_values", x_, params);
	setAttribute(prefix, "input_y_values", y_, params);
	setAttribute(prefix, "input_date_x_values", date_x_, params);
	setAttribute(prefix, "input_date_y_values", date_y_, params);
	setAttribute(prefix, "input_x2_values", x2_, params);
	setAttribute(prefix, "input_y2_values", y2_, params);
	setAttribute(prefix, "input_date_x2_values", date_x2_, params);
	setAttribute(prefix, "input_date_y2_values", date_y2_, params);
	setAttribute(prefix, "input_x_missing_value", x_missing_, params);
	setAttribute(prefix, "input_y_missing_value", y_missing_, params);
	setAttribute(prefix, "input_values", values_, params);
	setAttribute(prefix, "input_latitude_values", latitudes_, params);
	setAttribute(prefix, "input_longitude_values", longitudes_, params);
	setAttribute(prefix, "input_x_component_values", x_component_, params);
	setAttribute(prefix, "input_y_component_values", y_component_, params);
	setAttribute(prefix, "input_automatic", input_automatic_, params);
	
	setMember(prefix, "input_binning", input_binning_, params);
	
}

void InputDataAttributes::copy(const InputDataAttributes& other)
{
	type_ = other.type_;
	x_type_ = other.x_type_;
	y_type_ = other.y_type_;
	x_ = other.x_;
	y_ = other.y_;
	date_x_ = other.date_x_;
	date_y_ = other.date_y_;
	x2_ = other.x2_;
	y2_ = other.y2_;
	date_x2_ = other.date_x2_;
	date_y2_ = other.date_y2_;
	x_missing_ = other.x_missing_;
	y_missing_ = other.y_missing_;
	values_ = other.values_;
	latitudes_ = other.latitudes_;
	longitudes_ = other.longitudes_;
	x_component_ = other.x_component_;
	y_component_ = other.y_component_;
	input_automatic_ = other.input_automatic_;
	input_binning_ = unique_ptr<BinningObject>(other.input_binning_->clone());
	
}


bool InputDataAttributes::accept(const string& node)
{

	if ( magCompare(node, "input")  )
		return true;
	if ( acceptNode(node, input_binning_) )
		return true;
	
	return false;
}

void InputDataAttributes::set(const XmlNode& node)
{
	bool apply = false;

	if ( this->accept(node.name()) == false )
		return;

	if ( magCompare(node.name(), "input")  )
		apply = true;
	

	if ( apply )
		set(node.attributes());
	else {
		setMember(node.name(), input_binning_, node);
		
	}
	for (auto &elt : node.elements())
	{
		setMember(elt->name(), input_binning_, *elt);
		
	}
}

void InputDataAttributes::print(ostream& out)  const
{
	out << "Attributes[";
	out << " type = " <<  type_;
	out << " x_type = " <<  x_type_;
	out << " y_type = " <<  y_type_;
	out << " x = " <<  x_;
	out << " y = " <<  y_;
	out << " date_x = " <<  date_x_;
	out << " date_y = " <<  date_y_;
	out << " x2 = " <<  x2_;
	out << " y2 = " <<  y2_;
	out << " date_x2 = " <<  date_x2_;
	out << " date_y2 = " <<  date_y2_;
	out << " x_missing = " <<  x_missing_;
	out << " y_missing = " <<  y_missing_;
	out << " values = " <<  values_;
	out << " latitudes = " <<  latitudes_;
	out << " longitudes = " <<  longitudes_;
	out << " x_component = " <<  x_component_;
	out << " y_component = " <<  y_component_;
	out << " input_automatic = " <<  input_automatic_;
	out << " input_binning = " <<  *input_binning_;
	
	out << "]" << "\n";
}

void InputDataAttributes::toxml(ostream& out)  const
{
	out <<  "\"input\"";
	out << ", \"input_type\":";
	niceprint(out,type_);
	out << ", \"input_x_type\":";
	niceprint(out,x_type_);
	out << ", \"input_y_type\":";
	niceprint(out,y_type_);
	out << ", \"input_x_values\":";
	niceprint(out,x_);
	out << ", \"input_y_values\":";
	niceprint(out,y_);
	out << ", \"input_date_x_values\":";
	niceprint(out,date_x_);
	out << ", \"input_date_y_values\":";
	niceprint(out,date_y_);
	out << ", \"input_x2_values\":";
	niceprint(out,x2_);
	out << ", \"input_y2_values\":";
	niceprint(out,y2_);
	out << ", \"input_date_x2_values\":";
	niceprint(out,date_x2_);
	out << ", \"input_date_y2_values\":";
	niceprint(out,date_y2_);
	out << ", \"input_x_missing_value\":";
	niceprint(out,x_missing_);
	out << ", \"input_y_missing_value\":";
	niceprint(out,y_missing_);
	out << ", \"input_values\":";
	niceprint(out,values_);
	out << ", \"input_latitude_values\":";
	niceprint(out,latitudes_);
	out << ", \"input_longitude_values\":";
	niceprint(out,longitudes_);
	out << ", \"input_x_component_values\":";
	niceprint(out,x_component_);
	out << ", \"input_y_component_values\":";
	niceprint(out,y_component_);
	out << ", \"input_automatic\":";
	niceprint(out,input_automatic_);
	out << ", \"input_binning\":";
	input_binning_->toxml(out);
	
}

static MagicsParameter<string> input_type("input_type", "cartesian");
static MagicsParameter<string> input_x_type("input_x_type", "number");
static MagicsParameter<string> input_y_type("input_y_type", "number");
static MagicsParameter<doublearray> input_x_values("input_x_values", floatarray());
static MagicsParameter<doublearray> input_y_values("input_y_values", floatarray());
static MagicsParameter<stringarray> input_date_x_values("input_date_x_values", stringarray());
static MagicsParameter<stringarray> input_date_y_values("input_date_y_values", stringarray());
static MagicsParameter<doublearray> input_x2_values("input_x2_values", floatarray());
static MagicsParameter<doublearray> input_y2_values("input_y2_values", floatarray());
static MagicsParameter<stringarray> input_date_x2_values("input_date_x2_values", stringarray());
static MagicsParameter<stringarray> input_date_y2_values("input_date_y2_values", stringarray());
static MagicsParameter<double> input_x_missing_value("input_x_missing_value", -21.e6);
static MagicsParameter<double> input_y_missing_value("input_y_missing_value", -21.e6);
static MagicsParameter<doublearray> input_values("input_values", floatarray());
static MagicsParameter<doublearray> input_latitude_values("input_latitude_values", floatarray());
static MagicsParameter<doublearray> input_longitude_values("input_longitude_values", floatarray());
static MagicsParameter<doublearray> input_x_component_values("input_x_component_values", floatarray());
static MagicsParameter<doublearray> input_y_component_values("input_y_component_values", floatarray());
static MagicsParameter<string> input_automatic("input_automatic", "on");
static MagicsParameter<string> input_binning("input_binning", "on");
#include "BinningObject.h"
static SimpleObjectMaker<NoBinningObject , BinningObject> nobinning_NoBinningObject("nobinning");
static SimpleObjectMaker<NoBinningObject , BinningObject> off_NoBinningObject("off");
static SimpleObjectMaker<BinningObject , BinningObject> binning_BinningObject("binning");
static SimpleObjectMaker<BinningObject , BinningObject> on_BinningObject("on");
