#!/usr/bin/python
# Copyright (C) 2005-2010 Canonical Ltd
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA

"""Demo Test

This is a basic test to verify that mago-ng is working as expected and can
be run with various testing framework

To run it with:
$ mago-ng <path_to_this_file>

You can code ldtp directly in there or an external module
The only mandatory element is 'launcher' (and window_name for now)

set setupOnce to False to launch/close the app for each test

The purpose of this example is to demo the use of a configuration file and
the comparison of files

"""

from mago import TestCase, utils
import unittest
import ldtp
import os

class TestSaveDocument(TestCase):
    """Test Class"""
    launcher = 'gedit'
    launcher_args = []
    window_name = 'frm*gedit'
    setupOnce = True

    def test_save(self):
        """Save a document and compare to an oracle

        The text and the path to the oracle are loaded from a configuration
        file.
        The name of the configuration file must be the same as the test file
        with the extention .ini

        In this example the test file is 'test_savedocument.py' and the
        configuration file is 'test_savedocument.ini'
        """

        ldtp.settextvalue(self.window_name, 'txt1',
                          self.testConfig.get('data', 'text'))
        ldtp.wait(2)

        # Load the destination directory and the oracle file name from the
        # configuration file
        destfile = os.path.join( self.testConfig.get('data', 'destdir'),
                                "%s.txt" % __name__)
        oracle = os.path.join( os.path.dirname(__file__),
                                  self.testConfig.get('data', 'oracle'))

        # Assert that the files saves correctly
        # If you set replace to False and the destination file already exists
        # the assertion will fail
        self.assertTrue(self.application.saveDocument(destfile, replace = True))

        # Assert that the saved file and the oracle are the same
        self.assertTrue(utils.file_compare(destfile, oracle))

if __name__ == "__main__":
    unittest.main()
