package org.mathpiper.ui.gui;


/*This code was obtained from http://www.discoverteenergy.com/files/ScreenImage.java
  There was no license associated with the code. */

import java.awt.*;
import java.awt.event.*;
import java.awt.image.*;
import java.io.*;
import javax.imageio.*;
import javax.swing.*;

public class ScreenCapture
{
	/*
	 *  Create a BufferedImage for Swing components.
	 *  The entire component will be captured to an image.
	 *
	 *  @param	 component Swing component to create image from
	 *  @param	 fileName name of file to be created or null
	 *  @return	image the image for the given region
	 *  @exception IOException if an error occurs during writing
	*/
	public static BufferedImage createImage(JComponent component, String fileName)
		throws IOException
	{
		Dimension d = component.getSize();

		if (d.width == 0)
		{
			d = component.getPreferredSize();
			component.setSize( d );
		}

		Rectangle region = new Rectangle(0, 0, d.width, d.height);
		return ScreenCapture.createImage(component, region, fileName);
	}

	/*
	 *  Create a BufferedImage for Swing components.
	 *  All or part of the component can be captured to an image.
	 *
	 *  @param	 component Swing component to create image from
	 *  @param	 region The region of the component to be captured to an image
	 *  @param	 fileName name of file to be created or null
	 *  @return	image the image for the given region
	 *  @exception IOException if an error occurs during writing
	*/
	public static BufferedImage createImage(JComponent component, Rectangle region, String fileName)
		throws IOException
	{
		boolean opaqueValue = component.isOpaque();
		component.setOpaque( true );
		BufferedImage image = new BufferedImage(region.width, region.height, BufferedImage.TYPE_INT_RGB);
		Graphics2D g2d = image.createGraphics();
		g2d.setClip( region );
		component.paint( g2d );
		g2d.dispose();
		component.setOpaque( opaqueValue );
		ScreenCapture.writeImage(image, fileName);
		return image;
	}

	/*
	 *  Create a BufferedImage for AWT components.
	 *
	 *  @param	 component AWT component to create image from
	 *  @param	 fileName name of file to be created or null
	 *  @return	image the image for the given region
	 *  @exception AWTException see Robot class constructors
	 *  @exception IOException if an error occurs during writing
	*/
	public static BufferedImage createImage(Component component, String fileName)
		throws AWTException, IOException
	{
		Point p = new Point(0, 0);
		SwingUtilities.convertPointToScreen(p, component);
		Rectangle region = component.getBounds();
		region.x = p.x;
		region.y = p.y;
		return ScreenCapture.createImage(region, fileName);
	}

	/**
	 *  Convenience method to create a BufferedImage of the desktop
	 *
	 *  @param	 fileName name of file to be created or null
	 *  @return	image the image for the given region
	 *  @exception AWTException see Robot class constructors
	 *  @exception IOException if an error occurs during writing
	 */
	public static BufferedImage createDesktopImage(String fileName)
		throws AWTException, IOException
	{
		Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
		Rectangle region = new Rectangle(0, 0, d.width, d.height);
		return ScreenCapture.createImage(region, fileName);
	}

	/**
	 *  Create a BufferedImage from a rectangular region on the screen.
	 *
	 *  @param	 region region on the screen to create image from
	 *  @param	 fileName name of file to be created or null
	 *  @return	image the image for the given region
	 *  @exception AWTException see Robot class constructors
	 *  @exception IOException if an error occurs during writing
	 */
	public static BufferedImage createImage(Rectangle region, String fileName)
		throws AWTException, IOException
	{
		BufferedImage image = new Robot().createScreenCapture( region );
		ScreenCapture.writeImage(image, fileName);
		return image;
	}

	/**
	 *  Write a BufferedImage to a File.
	 *
	 *  @param	 image image to be written
	 *  @param	 fileName name of file to be created
	 *  @exception IOException if an error occurs during writing
	*/
	public static void writeImage(BufferedImage image, String fileName)
		throws IOException
	{
		if (fileName == null) return;

		int offset = fileName.lastIndexOf( "." );
		String type = offset == -1 ? "png" : fileName.substring(offset + 1);

		ImageIO.write(image, type, new File( fileName ));
	}

	public static void main(String args[])
		throws Exception
	{
		final JFrame frame = new JFrame();
		final JTextArea textArea = new JTextArea(30, 60);
		final JScrollPane scrollPane = new JScrollPane( textArea );
		frame.getContentPane().add( scrollPane );

		JMenuBar menuBar = new JMenuBar();
		frame.setJMenuBar( menuBar );
		JMenu menu = new JMenu( "File" );
		ScreenCapture.createImage(menu, "menu.jpg");
		menuBar.add( menu );
		JMenuItem menuItem = new JMenuItem( "Frame Image" );
		menu.add( menuItem );
		menuItem.addActionListener( new ActionListener()
		{
			public void actionPerformed(ActionEvent e)
			{
				//  Let the menu close and repaint itself before taking the image

				new Thread()
				{
					public void run()
					{
						try
						{
							Thread.sleep(50);
							System.out.println("Creating frame.jpg");
							frame.repaint();
							ScreenCapture.createImage(frame, "frame.jpg");
						}
						catch(Exception exc) { System.out.println(exc); }
					}
				}.start();
			};
		});

		final JButton button = new JButton("Create Images");
		button.addActionListener( new ActionListener()
		{
			public void actionPerformed(ActionEvent e)
			{
				try
				{
					System.out.println("Creating desktop.jpg");
					ScreenCapture.createDesktopImage( "desktop.jpg" );
					System.out.println("Creating frame.jpg");
					ScreenCapture.createImage(frame, "frame.jpg");
					System.out.println("Creating scrollpane.jpg");
					ScreenCapture.createImage(scrollPane, "scrollpane.jpg");
					System.out.println("Creating textarea.jpg");
					ScreenCapture.createImage(textArea, "textarea.jpg");
					System.out.println("Creating button.jpg");
					ScreenCapture.createImage(button, "button.jpg");
					button.setText("button refreshed");
					button.paintImmediately(button.getBounds());
					System.out.println("Creating refresh.jpg");
					ScreenCapture.createImage(button, "refresh.jpg");
					System.out.println("Creating region.jpg");
					Rectangle r = new Rectangle(0, 0, 100, 16);
					ScreenCapture.createImage(textArea, r, "region.png");
				}
				catch(Exception exc) { System.out.println(exc); }
			}
		});
		frame.getContentPane().add(button, BorderLayout.SOUTH);

		try
		{
			FileReader fr = new FileReader( "ScreenCapture.java" );
			BufferedReader br = new BufferedReader(fr);
			textArea.read( br, null );
			br.close();
		}
		catch(Exception e) {}

		frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
		frame.pack();
		frame.setLocationRelativeTo( null );
		frame.setVisible(true);
	}
}
