/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

#ifndef XMText_H
#include "XMText.h"
#endif

#ifndef VariableEditor_H
#include "VariableEditor.h"
#endif

#ifndef EditorFactory_H
#include "EditorFactory.h"
#endif

#ifndef IconObject_H
#include "IconObject.h"
#endif

#ifndef Log_H
#include "Log.h"
#endif

#ifndef IconClass_H
#include "IconClass.h"
#endif
#ifndef IconFactory_H
#include "IconFactory.h"
#endif

#ifndef RequestPanelLine_H
#include "RequestPanelLine.h"
#endif


#ifndef VariableTask_H
#include "VariableTask.h"
#endif


VariableEditor::VariableEditor(const IconClass& name,const string& kind):
	XEditor<UIVariableEditor_c>(name,kind),
	fixPanel_(name, topPanel_),
	variablePanel_(0)
{
}

VariableEditor::~VariableEditor()
{
	delete variablePanel_;
}


IconObject* VariableEditor::copy(const string& name) 
{	
	IconObject* o = IconFactory::create(name, class_);

	o->request(currentRequest());

	return o;
}

void VariableEditor::apply()
{
	current_->request(currentRequest());
}


void VariableEditor::reset()
{	

	if(temp_) {
		temp_->destroy();
		temp_ = 0;
	}

	if(task_)
	{
		task_->stop();
		task_ = 0;
	}


	fixPanel_.reset(current_);


	int error;

	Request r("ODB_EDITOR");
	Request p = fixPanel_.request();
	r.merge(p);

    task_ = new VariableTask(*this,"ODB",r);
    task_->start();

	delete variablePanel_;
	variablePanel_ = new RequestPanel(IconClass::find("NOTE"), bottomPanel_, 0);
	variablePanel_->reset(current_);

}

void VariableEditor::close()
{
	   delete variablePanel_;
	   variablePanel_ = 0;
}

Request VariableEditor::currentRequest()
{
	fixPanel_.apply();
	variablePanel_->apply(); 

	Request r1  = fixPanel_.request();
	Request r2 = variablePanel_->request();

	r1.merge(r2);

	return r1;
}

void VariableEditor::replace(IconObject* o)
{
   	fixPanel_.replace(o);
}

void  VariableEditor::merge(IconObject* o)
{
	fixPanel_.merge(o);
}

void VariableEditor::reply(IconClass& c)
{
	delete variablePanel_;
	variablePanel_ = new RequestPanel(c, bottomPanel_, 0);
	variablePanel_->reset(current_);
}

void VariableEditor::fail()
{
}

static EditorMaker<VariableEditor> editorMaker("VariableEditor");
static EditorMaker<VariableEditor> editorODBMaker("ODBEditor");

