#!/bin/sh

if [ $# -ne 1 ]
then
    echo "usage: $0 prefix"
    echo
    echo "where prefix is the directory under which to install (eg. /usr, /usr/local)"
    echo 
    exit
fi

PREFIX="$1"
BINDIR="$PREFIX/bin"
MANDIR="$PREFIX/share/man/man1"
LOCALEDIR="$PREFIX/share/locale"

umask 022

echo "Installing program files"

mkdir -m 755 -p "$BINDIR" || exit 1
mkdir -m 755 -p "$MANDIR" || exit 1

cp mi2svg.pl "$BINDIR/mi2svg" || exit 1

chmod 755 "$BINDIR/mi2svg"

cp mi2svg.man "$MANDIR/mi2svg.1" || exit 1


echo "Checking for msgfmt"

if which msgfmt > /dev/null; then
    echo "msgfmt found, installing translations"

    for a in po/*.po; do
	LANG="`basename $a .po`"
	echo "- Language $a"
	mkdir -m 755 -p "$LOCALEDIR/$LANG/LC_MESSAGES"
	msgfmt -o "$LOCALEDIR/$LANG/LC_MESSAGES/mi2svg.mo" "$a" || exit 1
    done
else
    echo "msgfmt not found; translations not installed"
fi

echo "Done."

