# Artist: Bob Marley & The Wailers
# Album: Survival
# Song: One Drop

# Based on the bass tab by Andre Torrez

@head {
	$tempo 122
	$time_sig 4/4
	$key a
	$title "Bob Marley & The Wailers - One Drop"
}

@body {

	@channel 1 "bass" {
		$patch bass_fg
		$volume 120

		%repeat 32 {
			/l6/r  /l12/a2 /l6/a  /l12/a  /l6/c+3 /l12/c+ /l6/e  /l12/r  # A
			/l4/b2 /l6/r   /l12/b /l6/d+3 /l12/d+ /l6/f+  /l12/r         # B
			/l6/r  /l12/d3 /l6/d  /l12/d  /l6/f+  /l12/f+ /l6/a  /l12/r  # D
			/l4/e  /l6/r   /l12/e /l6/g+  /l12/e  /l6/b2  /l12/r         # E
		}
	}

	%define major { ( a3 c+4 e4 a4 ) } # A major chord
	%define minor { ( a3 c4 e4 a4 ) }  # A minor chord

	@channel 2 "rhythm guitar" {
		$patch guitar_muted
		$volume 64
		$reverb 32
		$length 32

		%repeat 32 {
			%repeat 2 { /r8/r ~major     /r7/r }    # A
			%repeat 2 { /r8/r ~minor/-3/ /r7/r }    # F#m
			%repeat 2 { /r8/r ~minor/2/  /r7/r }    # Bm
			%repeat 2 { /r8/r ~major/-5/ /r7/r }    # E
		}
	}

	@channel 3 "organ" {
		$patch organ_perc
		$volume 48
		$chorus 48
		$length 32

		%repeat 32 {
			%repeat 2 { /r8/r ~major/-12/ /r7/r }    # A
			%repeat 2 { /r8/r ~minor/-15/ /r7/r }    # F#m
			%repeat 2 { /r8/r ~minor/-10/  /r7/r }   # Bm
			%repeat 2 { /r8/r ~major/-17/ /r7/r }    # E
		}
	}

	@channel 10 "hats" {
		%repeat 32 {
			/l4r16/hh_c

		}
	}

	@channel 10 "kick" {
		%repeat 32 {
			%repeat 4 { /l4r2/r bd r }
		}
	}
}
