
;;; file: pao_smaller.scm


(display"

Begin of pao_smaller.scm

")




;;; Basic Definitions




;; Predicate/Relation LESS

(begin

(add-program-constant
 "SMALLER"
 (mk-arrow (py "ord") (py "ord") (py "boole"))
 1 'const 2
)

(add-token
 "≺"
 'rel-op
 (lambda (x y)
   (mk-term-in-app-form
    (make-term-in-const-form (pconst-name-to-pconst "SMALLER")) x y)))

(add-display
 (py "boole")
 (lambda (x)
   (let* ((op (term-in-app-form-to-final-op x))
	  (args (term-in-app-form-to-args x)))
     (if (and (term-in-const-form? op)
	      (string=? "SMALLER"
		(const-to-name (term-in-const-form-to-const op)))
	      (= 2 (length args)))
	 (list 'rel-op "≺"
	       (term-to-token-tree (car args))
	       (term-to-token-tree (cadr args)))
	 #f))))


; Computation Rules For SMALLER

(add-computation-rule (pt "ord ≺ ø")(pt "F"))
(add-computation-rule (pt "ø ≺ (OP ord0 ord1)")(pt "T"))
(add-computation-rule (pt "(OP ord0 ord1) ≺ (OP ord2 ord3)")
 (pt "[if (ord0≺ord2) (ord1 ≺(OP ord2 ord3))
                      ([if (ord2≺ord0) ((OP ord0 ord1) ≺ ord3)
                                        (ord1 ≺ ord3)])
      ]"
 )
)

(display-program-constants "SMALLER")

(define (smallersimp)
  (simp
   (pf "all ord0,ord1,ord2,ord3.([if (ord0≺ord2) (ord1≺OP ord2 ord3) [if (ord2≺ord0) (OP ord0 ord1≺ord3) (ord1≺ord3)]])=(OP ord0 ord1≺OP ord2 ord3)")))


)



; Predicate LE : ≼

; α≼β :≡ ¬(β≺α)

(begin

(add-program-constant
 "LE"
 (mk-arrow (py "ord") (py "ord") (py "boole")) 1 'const 2)

(add-token
 "≼"
 'rel-op
 (lambda (x y)
   (mk-term-in-app-form
    (make-term-in-const-form (pconst-name-to-pconst "LE")) x y)))



(add-display
 (py "boole")
 (lambda (x)
   (cond ((term-in-app-form? x)
	  (let* ((op (term-in-app-form-to-final-op x))
		 (args (term-in-app-form-to-args x)))
	    (if (and (term-in-const-form? op)
		     (string=? "LE"
			       (const-to-name (term-in-const-form-to-const op)))
		     (= 2 (length args)))
		(list 'rel-op "≼"
		      (term-to-token-tree (car args))
		      (term-to-token-tree (cadr args)))
		#f)))
	 ((and (term-in-if-form? x)
	       (equal? (term-in-if-form-to-alts x)(list(pt"F") (pt"T")))
	       (term-in-app-form? (term-in-if-form-to-test x))
	       (term-in-app-form? (term-in-app-form-to-op(term-in-if-form-to-test x))))
	  (let* ((test     (term-in-if-form-to-test x))
		 (testop   (term-in-app-form-to-op(term-in-app-form-to-op test)))
		 (testargs (term-in-app-form-to-args test)))
	    (if (and (term-in-const-form? testop)
		     (string=? "SMALLER"
			       (const-to-name (term-in-const-form-to-const testop)))
		     (= 2 (length testargs)))
		(list 'rel-op "≼"
		      (term-to-token-tree (cadr testargs))
		      (term-to-token-tree (car  testargs)))
		#f)))
	 (else #f))))


; Computation Rules for LE

(add-computation-rule (pt "ord1≼ord2")(pt "¬(ord2≺ord1)"))

(display-program-constants "LE")

)

(display "

RW-rules for SMALLER ≺ and LE ≼

")


; (hide-output)


(set! COMMENT-FLAG #f)



(begin

; 0 ≠ α  ⇔  0 ≺ α

(sg "(ø ≺ ord) = ¬(ord = ø)")
(cases)
(auto)

; Proof finished.

(add-rewrite-rule (pt"ø ≺ ord") (pt"¬(ord = ø)"))



; α≺1 -> α=0

(set-goal(pf"(ord0 ≺ ①) =(ord0 = ø)"))
(cases)
(auto)

; Proof finished.

(add-rewrite-rule (pt"ord0 ≺ ①") (pt"ord0 = ø"))


; SMALLERirreflexsive : α ≮ α

(sg "¬(ord ≺ ord)")
(ind)
     (search)
(assume "ord0" "ord1" "IH0")
(ng)
(simp "IH0")
(search)

; Proof finished.

(add-rewrite-rule (pt "ord ≺ ord") (pt "F"))


(display
"ord≼ord   ")
(pnt "ord≼ord")



; α ≺ β  ⇔ ω^α ≺ ω^β

(sg "((ω^ ord1)≺(ω^ ord2))=(ord1≺ord2)")
(auto)

; Proof finished.

(add-rewrite-rule (pt "(ω^ ord0)≺(ω^ ord1)")(pt "ord0 ≺ ord1"))



; β ≺ γ  ⇔  ω^α+β ≺ ω^α+γ

(sg "(OP ord ord1 ≺ OP ord ord2) = (ord1≺ord2)")
(auto)

; Proof finished.

(add-rewrite-rule (pt "(OP ord ord1)≺(OP ord ord2)")(pt "ord1≺ord2"))



; α≺β ⇔ 1+α ≺ 1+β

(sg "(OP ø ord1 ≺ OP ø ord2) = (ord1≺ord2)")
(auto)

; Proof finished.

(add-rewrite-rule (pt"OP ø ord1 ≺ OP ø ord2") (pt"ord1 ≺ ord2"))



; α ≺ ω  ⇔  a ≺ 1+α

(sg "(ord ≺ OP ø ord) = (ord ≺ ω)")
(ind)
  (search)
(assume "ord1" "ord2")
(ng)
(cds "ord1= ø" "1=0")
(auto)

; Proof finished.

(add-rewrite-rule (pt"ord ≺ OP ø ord")(pt"ord ≺ ω"))




(sg "(OP ord1 ord2 ≺ OP ø (OP ord1 ord2)) = ((ord1 = ø) and (ord2 ≺ ω))")
(cases)
(auto)

; Proof finished.

(add-rewrite-rule (pt"OP ord1 ord2 ≺ OP ø (OP ord1 ord2)")(pt"(ord1 = ø) and (ord2 ≺ ω)"))




; α ≺ ω  ⇔  1+α ≺ 2+α

(sg "(OP ø ord ≺ OP ø (OP ø ord)) = (ord ≺ ω)")
(auto)

; Proof finished.

(add-rewrite-rule (pt"ord ≺ OP ø (OP ø ord)")(pt"ord ≺ ω"))



; ¬(1+α ≺ α)

(sg "¬(OP ø ord ≺ ord)")
(ind)
      (search)
(assume "ord1" "ord2")
(ng)
(cds "ord1= ø" "1= ø")
(auto)

; Proof finished.

(add-rewrite-rule (pt"OP ø ord ≺ ord")(pt"F"))





(display"
α<2 = α=ø ∨ α=1
")
(sg "(ord≺ ②) = (ord= ø | ord= ①)")
(cases)
  (auto)
(assume "ord1" "ord2")
(ng)
(cd "ord1= ø" "1=0")
(ng)
(cd "ord2= ø" "2=0")
(auto)

; Proof finished.

(add-rewrite-rule (pt"ord≺ ②")(pt"ord= ø | ord= ①"))


;

(sg "(ord1 ≺OP ø (ω^ ord2)) = [if (ord2 = ø) (ord1≺ ②) (ord1 ≺(ω^ ord2))]")
(cases)
   (auto)
(assume "ord11" "ord12")
(ng)
(cds "ord11= ø" "11=0")
  (ng)
  (cases)
    (search)
  (search)
(assume "11≠0")
(ng)
(cases)
(auto)

; Proof finished.

(add-rewrite-rule (pt"ord2 ≺OP ø (ω^ ord1)")
		  (pt"[if (ord1 = ø) ([if (ord2= ø)(T)(ord1= ①)]) (ord2 ≺(ω^ ord1))]"))



(sg "(OP ø (OP ord1 ord2) ≼ OP ord1 ord2)=[if (ord1 = ø)(ω ≼ ord2)(T)]")
(cases)
(auto)

; Proof finished.

(add-rewrite-rule (pt"OP ø (OP ord1 ord2) ≼ OP ord1 ord2")(pt"[if (ord1 = ø)(ω ≼ ord2)(T)]"))



; 1 < α  =  α≠0 & α≠1

(sg "(① ≺ord)=(¬(ord= ø)  and ¬(ord= ①))")
(cases)
(auto)
(assume "ord1" "ord2")
(ng #t)
(cases(pt"ord1 = ø"))
(auto)

; Proof finished.

(add-rewrite-rule(pt"① ≺ord")(pt"¬(ord= ø)  and ¬(ord= ①)"))



(display"

RW rules's end

")

)

(display-program-constants "SMALLER")

(display-program-constants "LE")



(display "

SMALLER antisym
α≺β -> β⊀α

PROOF:
")

(begin

(sg "(ord1≺ord2  and  ord2≺ord1) =F")
(ind)
   (search)
(assume "ord11" "ord12" "IH11" "IH12")
(ind)
    (search)
(assume "ord21" "ord22" "IH21" "IH22")
(ng #t)
(cd "ord11 ≺ ord21" "11<21")
(ng #t)
(simp (pf"¬(ord21≺ord11)"))
(use "IH12")
(simp "<-" (pf"(ord11≺ord21 and ord21≺ord11) =F"))
(simp "11<21")
(auto)
(assume "11≮21")
(ng #t)
(cases (pt"ord21≺ord11"))
(auto)

; Proof finished.

(add-rewrite-rule (pt"ord1≺ord2 and ord2≺ord1") (pt"F"))

)


(display"
Often used form of SMALLERantisym:
")

(begin

(sg "ord2≺ord1 -> (ord1≺ord2)=F")
(assume "ord2" "ord1")
(cd "ord2≺ord1" "2<1")
(assume "T")
(simp (pf"F=(ord1≺ord2 and ord2≺ord1)"))
(simp "2<1")
(auto)
(strip 1)
(use "Efq-Atom")

; Proof finished.

(save "SMALLERantisym")
(display-theorems "SMALLERantisym")

)




(display-program-constants "SMALLER")

(display "
 SMALLEREQUtrans

 ( α ≤ β  ->  β ≺ γ  ->  α ≺ γ )
 ( γ ≤ α  ->  α ≺ β  ->  γ ≺ β )
 ( β ≤ γ  ->  γ ≺ α  ->  β ≺ α )
 ( α ≺ β  ->  β ≤ γ  ->  α ≺ γ )
 ( γ ≺ α  ->  α ≤ β  ->  γ ≺ β )
 ( β ≺ γ  ->  γ ≤ α  ->  β ≺ α )


PROOF:
(takes a while !)

")

(sg "all ord0,ord1,ord2.
         ((ord0 ≼ ord1 and ord1 ≺ ord2) → ord0 ≺ ord2)
     and ((ord2 ≼ ord0 and ord0 ≺ ord1) → ord2 ≺ ord1)
     and ((ord1 ≼ ord2 and ord2 ≺ ord0) → ord1 ≺ ord0)
     and ((ord0 ≺ ord1 and ord1 ≼ ord2) → ord0 ≺ ord2)
     and ((ord2 ≺ ord0 and ord0 ≼ ord1) → ord2 ≺ ord1)
     and ((ord1 ≺ ord2 and ord2 ≼ ord0) → ord1 ≺ ord0)")
(newline)

(time(begin
(ind); on ord0

; ord0 = 0
(ind); on ord1
    (strip)
    (ng #t)
    (cd "ord2= ø" "2=0")
    (search)
    (search)
(assume "ord5" "ord6")
(strip 2)
(ind)
     (search)
(assume "ord7" "ord8")
(strip)
(use "Truth-Axiom")

; END of ord0 = ø


(assume "ord3" "ord4")
(strip 2)

(ind); on ord1
    (strip)
    (use "Truth-Axiom")
(assume "ord5" "ord6")
(strip 2)
(ind); on ord2
    (use "Truth-Axiom")
(assume "ord7" "ord8")
(strip)
(drop '3 5)
(cd "ord3≺ord5" "3<5")
(drop 4)
(ng #t)
(simp "3<5")
(cas "¬(ord5≺ord3)" "3≤5")
(ng #t)
(cd "ord3≺ord7" "3<7")
(simp (pf"¬(ord7≺ord3)"))
(ng #t)
(use-with 2 (pt"OP ord5 ord6") (pt"OP ord7 ord8"))
(use "SMALLERantisym")
(use "3<7")

; ?_37: (ord3≺ord7 -> F) ->...

(assume "7≤3")
(ng #t)
(cas "ord7≺ord5" "7<5")
(simp(pf"¬(ord5≺ord7)"))
(ng #t)
(cd "ord7≺ord3" "7<3")
(drop '1 2)
(ng #t)
(simp(pf"(OP ord5 ord6≺ord4) = (OP ord5 ord6≺OP ord3 ord4)"))
(simp(pf"(ord4≺OP ord5 ord6) = (OP ord3 ord4≺OP ord5 ord6)"))
(use 6)
(drop 6)
(ng)
(simp "3<5")
(auto)
(drop 6)
(ng)
(simp "3≤5")
(simp "3<5")
(auto)
(use "SMALLERantisym")
(use "7<5")
(drop '2 '6)
(cut(pf"(ord7≼ord3 and ord3≺ord5) → ord7≺ord5"))
(drop 1)
(simp "3<5")
(ng #t)
(simp "7≤3")
(ng #t)
(simp "BooleStab")
(auto)
(cut(pf"(ord3≼ord5 and ord5≺ord7 and (ord3≺ord7)=F)=F
    and (ord7≼ord3 and ord3≺ord5 and (ord7≺ord5)=F)=F
    and (ord5≼ord7 and ord7≺ord3 and (ord5≺ord3)=F)=F
    and (ord3≺ord5 and ord5≼ord7 and (ord3≺ord7)=F)=F
    and (ord7≺ord3 and ord3≼ord5 and (ord7≺ord5)=F)=F
    and (ord5≺ord7 and ord7≼ord3 and (ord5≺ord3)=F)=F"))
(drop 1)
(cases(pt"ord7≼ord3 and ord3≺ord5 and (ord7≺ord5)=F"))
(auto)
(drop '1 2 6)
(use "SMALLERantisym")
(use "3<5")


; ?_45: (ord3≺ ord5 -> F) ->...

(assume "5≤3")
(ng #t)
(simp "5≤3")
(ng #t)
(cd "ord5≺ord3" "5<3")
(ng #t)
(cd "ord5≺ord7" "5<7")
(drop '1 '2 '6)
(simp (pf"¬(ord7≺ ord5)"))
(ng #t)
(use-with 4 (pt"OP ord7 ord8"))
(drop 4)
(use "SMALLERantisym")
(use "5<7")

; ?_117: (ord5≺ord7 -> F) ->...

(assume "7≤5")
(cas "ord7≺ord3" "7<3")
(simp (pf"¬(ord3≺ord7)"))
(ng #t)
(cd "ord7≺ ord5" "7<5")
(simp(pf"(ord6≺OP ord3 ord4) = (OP ord5 ord6≺OP ord3 ord4)"))
(simp(pf"(OP ord3 ord4≺ord6) = (OP ord3 ord4≺OP ord5 ord6)"))
(use 6)
(drop 6)
(ng #t)
(simp "5≤3")
(simp "5<3")
(auto)
(drop 6)
(ng #t)
(simp "5≤3")
(simp "5<3")
(auto)
(drop '1 '2 '4 '6)
(use "SMALLERantisym")
(use "7<3")
(drop '2 '4 '6)
(cut(pf"(ord7≼ord5 and ord5≺ord3) → ord7≺ord3"))
(ng #t)
(simp "5<3")
(simp "7≤5")
(ng #t)
(simp "BooleStab")
(auto)
(cut(pf"(ord3≼ord7 and ord7≺ord5 and (ord3≺ord5)=F)=F
    and (ord5≼ord3 and ord3≺ord7 and (ord5≺ord7)=F)=F
    and (ord7≼ord5 and ord5≺ord3 and (ord7≺ord3)=F)=F
    and (ord3≺ord7 and ord7≼ord5 and (ord3≺ord5)=F)=F
    and (ord5≺ord3 and ord3≼ord7 and (ord5≺ord7)=F)=F
    and (ord7≺ord5 and ord5≼ord3 and (ord7≺ord3)=F)=F"))
(drop 1)
(cases (pt"ord7≼ord5 and ord5≺ord3 and (ord7≺ord3)=F"))
(auto)
(ng #t)

; ?_144: (ord5≺ord3 -> F) ->...

(assume "3≤5")
(cd "ord5≺ord7" "5<7")
(simp (pf"¬(ord7≺ ord5)"))
(ng #t)
(cas "ord3≺ord7" "3<7")
(simp (pf"¬(ord7≺ord3)"))
(ng #t)
(use 2)
(drop '1 2 3 4 6)
(use "SMALLERantisym")
(use "3<7")
(drop '2 3 4 6)
(cut(pf"(ord3≼ord5 and ord5≺ord7) → ord3≺ord7"))
(drop 1)
(ng #t)
(simp "3≤5")
(simp "5<7")
(ng #t)
(simp "BooleStab")
(auto)
(cut(pf"(ord3≼ord5 and ord5≺ord7 and (ord3≺ord7)=F)=F
    and (ord7≼ord3 and ord3≺ord5 and (ord7≺ord5)=F)=F
    and (ord5≼ord7 and ord7≺ord3 and (ord5≺ord3)=F)=F
    and (ord3≺ord5 and ord5≼ord7 and (ord3≺ord7)=F)=F
    and (ord7≺ord3 and ord3≼ord5 and (ord7≺ord5)=F)=F
    and (ord5≺ord7 and ord7≼ord3 and (ord5≺ord3)=F)=F"))
(drop 1)
(cases (pt"ord3≼ord5 and ord5≺ord7 and (ord3≺ord7)=F"))
(auto)
(drop '1 2 3 4 6)
(use "SMALLERantisym")
(use "5<7")

; ?_146: (ord5≺ord7 -> F) ->...

(assume "7≤5")
(ng #t)
(cd "ord7≺ ord5" "7<5")
(cas "ord7≺ord3" "7<3")
(simp (pf"¬(ord3≺ord7)"))
(ng #t)
(drop '1 2 3 4 5)
(simp(pf"(ord6≺ord4)=(OP ord5 ord6≺OP ord3 ord4)"))
(simp(pf"(ord4≺ord6)=(OP ord3 ord4≺OP ord5 ord6)"))
(use 6)
(drop 6)
(ng #t)
(simp "3≤5")
(simp "5≤3")
(auto)
(ng #t)
(simp "3≤5")
(simp "5≤3")
(auto)
(drop '1 '2 '3 '4 '5 '6)
(use "SMALLERantisym")
(use "7<3")
(drop '2 '3 '4 '5 '6)
(cut(pf"(ord7≺ord5 and ord5≼ord3) → ord7≺ord3"))
(drop 1)
(ng #t)
(simp "5≤3")
(simp "7<5")
(ng #t)
(simp "BooleStab")
(auto)
(cut(pf"(ord3≼ord7 and ord7≺ord5 and (ord3≺ord5)=F)=F
    and (ord5≼ord3 and ord3≺ord7 and (ord5≺ord7)=F)=F
    and (ord7≼ord5 and ord5≺ord3 and (ord7≺ord3)=F)=F
    and (ord3≺ord7 and ord7≼ord5 and (ord3≺ord5)=F)=F
    and (ord5≺ord3 and ord3≼ord7 and (ord5≺ord7)=F)=F
    and (ord7≺ord5 and ord5≼ord3 and (ord7≺ord3)=F)=F"))
(drop 1)
(cases (pt"ord7≺ord5 and ord5≼ord3 and (ord7≺ord3)=F"))
(auto)

; ?_179: (ord7≺ ord5 -> F) ->...

(assume "5≤7")
(ng #t)
(simp(pf"¬(ord3≺ord7)"))
(simp(pf"¬(ord7≺ord3)"))
(ng #t)
(use 2)
(drop '2 3 4 5 6)
(simp "<-" (pf"(ord7≺ord3 and ord3≼ord5 and (ord7≺ord5)=F)=F"))
(drop 1)
(ng #t)
(simp "3≤5")
(simp "5≤7")
(use "Truth-Axiom")
(cut(pf"(ord3≼ord5 and ord5≺ord7 and (ord3≺ord7)=F)=F
    and (ord7≼ord3 and ord3≺ord5 and (ord7≺ord5)=F)=F
    and (ord5≼ord7 and ord7≺ord3 and (ord5≺ord3)=F)=F
    and (ord3≺ord5 and ord5≼ord7 and (ord3≺ord7)=F)=F
    and (ord7≺ord3 and ord3≼ord5 and (ord7≺ord5)=F)=F
    and (ord5≺ord7 and ord7≼ord3 and (ord5≺ord3)=F)=F"))
(drop 1)
(cases (pt"ord7≺ord3 and ord3≼ord5 and (ord7≺ord5)=F"))
(auto)
(drop '2 3 4 5 6)
(simp "<-" (pf"(ord5≼ord3 and ord3≺ord7 and (ord5≺ord7)=F)=F"))
(drop 1)
(ng #t)
(simp "5≤3")
(simp "7≤5")
(use "Truth-Axiom")
(cut(pf"(ord3≼ord7 and ord7≺ord5 and (ord3≺ord5)=F)=F
    and (ord5≼ord3 and ord3≺ord7 and (ord5≺ord7)=F)=F
    and (ord7≼ord5 and ord5≺ord3 and (ord7≺ord3)=F)=F
    and (ord3≺ord7 and ord7≼ord5 and (ord3≺ord5)=F)=F
    and (ord5≺ord3 and ord3≼ord7 and (ord5≺ord7)=F)=F
    and (ord7≺ord5 and ord5≼ord3 and (ord7≺ord3)=F)=F"))
(drop 1)
(cases (pt"ord5≼ord3 and ord3≺ord7 and (ord5≺ord7)=F"))
(auto)

; Proof finished.

(save "SMALLEREQUtrans")

(nrw "(¬(ord1≺ord0) and ord1≺ord2) → ord0 ≺ ord2")
(nrw "(ord0≺ord1 and ¬(ord2≺ord1)) → ord0 ≺ ord2")
(nrw "ord122≺OP ord21ø → ord122≺OP ord21 ord22")
(nrw "(ord1≺ ω and ¬(ord2= ø)) → ord1≺OP ord2 ø")

(display-program-constants "AndConst")
(display"
")
(display-theorems "SMALLEREQUtrans")
(display"
")

))




;; Easy Corollaries of SMALLEREQUtrans

; uses also SMALLERantisym
; (beside implictly inside SMALLEREQUtrans)



(display "\n SMALLERtrans: (α ≺ β  ∧  β ≺ γ)  →  α ≺ γ \n")

(begin
(sg "(ord0≺ord1 and ord1≺ord2) → (ord0≺ord2)")
(assume "ord0" "ord1" "ord2")
(cases (pt"ord0≺ord2"))
(auto)
(assume"2≤0")
(ng)
(cases (pt"ord1≺ord2"))
(assume "1<2")
(ng)
(use "SMALLERantisym")
(cut(pf"¬¬(ord1 ≺ ord0)"))
(cases(pt" ord1≺ord0"))
(auto)
(cut(pf"((ord1≺ord0)=F)=(ord1≺ord2 and (ord0≺ord2)=F and (ord1≺ord0)=F)"))
(simp "<-" (pf"(ord1≺ord2 and (ord0≺ord2)=F) → ord1 ≺ ord0"))
(auto)
(simp "2≤0")
(simp "1<2")
(cases(pt" ord1≺ord0"))
(auto)
)
; Proof finished.

(nrw "(ord0≺ord1 and ord1≺ord2) → (ord0≺ord2)")





(display "
An often used form of SMALLERtrans:
α ≺ β  ->  β ≺ γ ->  α ≺ γ

PROOF:
")

(begin
(sg "ord0≺ord1 -> ord1≺ord2 -> ord0≺ord2")
(assume "ord0" "ord1" "ord2")
(use "BooleImp2")
(use "Truth-Axiom")

; Proof finished.

(save "SMALLERtrans")
(display-theorems "SMALLERtrans")

)




(display"

α≤β  ->  β ≺ γ  ->  α ≤ γ

PROOF:
")

(begin

(sg "(ord0≼ord1 and ord1≺ord2) → ord0≼ord2")
(assume "ord0" "ord1" "ord2")
(ng #t)
(simp(pf"(((ord2≺ord0)=F)=F)=(ord2≺ord0)"))
(simp(pf"((ord1≺ord0)=F and ord1≺ord2 and ord2≺ord0)=(ord1≺ord2 and ord2≺ord0 and (ord1≺ord0)=F)"))
(use "Truth-Axiom")
(cases(pt"ord1≺ord0"))
(auto)
(use "BooleStab")
)
;  Proof finished.

(nrw "((ord1≺ord0)=F and ord1≺ord2) → (ord2≺ord0)=F")








(display"

(α≺β and  β ≤ γ)  →  α ≤ γ


PROOF:
")

(begin

(sg "(ord0 ≺ ord1 and ord1≼ord2) → (ord0≼ord2)")
(assume "ord0" "ord1" "ord2")
(ng #t)
(simp(pf"(((ord2≺ord0)=F)=F)=(ord2≺ord0)"))
(simp(pf"(ord0≺ord1 and (ord2≺ord1)=F and ord2≺ord0)=(ord2≺ord0 and ord0≺ord1 and (ord2≺ord1)=F)"))
(use "Truth-Axiom")
(cases(pt"ord2≺ord0"))
(auto)
(use "BooleStab")
)
;  Proof finished.

(nrw "(ord0≺ord1 and (ord2≺ord1)=F) → ((ord2≺ord0)=F)")








(display"

α≤β  ->  β ≤ γ  ->  α ≤ γ

PROOF:
")

(begin

(sg "(ord0≼ord1 and ord1≼ord2) → ord0≼ord2")
(assume "ord0" "ord1" "ord2")
(ng #t)
(simp(pf"(((ord2≺ord0)=F)=F)=(ord2≺ord0)"))
(simp(pf"((ord1≺ord0)=F and (ord2≺ord1)=F and ord2≺ord0) = (ord2≺ord0 and (ord1≺ord0)=F and (ord2≺ord1)=F)"))
(use "Truth-Axiom")
(cases(pt"ord2≺ord0"))
(auto)
(use "BooleStab")
)
; Proof finished.

(nrw "((ord1≺ord0)=F and (ord2≺ord1)=F) → ((ord2≺ord0)=F)")





(display "
LEtrans
α ≼ β  ->  β ≼ γ ->  α ≼ γ

PROOF:
")

(begin
(sg "ord0≼ord1 -> ord1≼ord2 -> ord0≼ord2")
(assume "ord0" "ord1" "ord2")
(use "BooleImp2")
(use "Truth-Axiom")

; Proof finished.

(save "LEtrans")
(display-theorems "LEtrans")
)





(begin
 
;;;;;;;;SMALLER is partial order ;;;;;;;

(display "

≺ is strict partial order:

")
(display "ord≺ord                                   ")(pnt"ord≺ord")
(display "ord1≺ord2 and ord2≺ord1                   ")(pnt"ord1≺ord2 and ord2≺ord1")
(display "(ord1≺ord2 and ord2≺ord3) → (ord1≺ord3)  ")(pnt"(ord1≺ord2 and ord2≺ord3) → (ord1≺ord3)")

(display "≼
")
(display "ord≼ord                                   ")(pnt"ord≼ord")
(display "(ord1≼ord2 and ord2≼ord3) → (ord1≼ord3)  ")(pnt"(ord1≼ord2 and ord2≼ord3) → (ord1≼ord3)")


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

)






(display"

 α ≺ ω^α + β  &  α ≤ ω^β + α

PROOF:
")

(sg "all ord1,ord2.ord1 ≺OP ord1 ord2 and ¬(OP ord2 ord1 ≺ ord1)")
(begin
(ind); ord1
    (search)
(assume "ord11" "ord12" "IH11" "IH12")
(ca "all ord2.¬(OP ord2 ord12≺ord12)" "IH12r")
(ca "all ord2.ord12≺OP ord12 ord2" "IH12l")
(ca "ord12≺OP (OP ord11 ord12) ø" "12<(11 12)0")
(drop "IH12")
(ng #t)
(cas "ord11≺OP ord11 ord12" "11≺11 12")
(ng #t)
(ind); ord2
    (ng #t)
    (simp "12<(11 12)0")
    (cds "ord11= ø" "11=0")
    (search)
    (search)
(assume "ord21" "ord22" "IH21" "IH22")
(drop  "IH21" "IH22")
(cd "OP ord21 ord22≺ord11" "(21 22)<11")
(ng #t)
(use "SMALLERtrans" (pt"OP(OP ord11 ord12)ø"))
(auto)
(assume "11≤21 22")
(ng #t)
(simp "IH12r")
(simp(pf"¬(OP(OP ord21 ord22)(OP ord11 ord12)≺ord12)"))
(use "SMALLERtrans" (pt"OP(OP ord11 ord12)ø"))
(auto)
(use "LEtrans" (pt"OP (OP ord21 ord22) ord12"))
(auto)
(use-with "IH11" (pt"ord12") 'left)
(cases(pt "ord12≺OP(OP ord11 ord12)ø"))
(auto)
(assume "(11 12)0≤12")
(simp "<-" (pf"(ord12≺OP ord12 ø and OP ord12 ø ≼ OP(OP ord11 ord12)ø) → ord12≺OP(OP ord11 ord12)ø"))
(simp "(11 12)0≤12")
(simp "IH12l")
(auto)
(simp(pf"all ord1,ord2,ord3.(ord1≺ord2 and ord2≼ord3)→ (ord1≺ord3)"))
(auto)
(assume "ord2")
(use-with "IH12" (pt"ord2") 'left)
(assume "ord2")
(use-with "IH12" (pt"ord2") 'right)
)
; Proof finished.

(add-rewrite-rule (pt"ord1 ≺OP ord1 ord2")  (pt"T"))
(add-rewrite-rule (pt"OP ord2 ord1 ≺ ord1") (pt"F"))



(display"

Some more rw-rules

")

(begin
(display"

(ω⋆ord ≺ ω)=(ord= ø)
")

(sg "(ω⋆ord ≺ ω)=(ord= ø)")
(cases)
(auto)

 ; Proof finished.

(add-rewrite-rule (pt"ω⋆ord ≺ ω") (pt"ord= ø"))



;  ω^α+β ⊀ α

(sg"¬(OP ord1 ord2≺ord1)")
(assume "ord1" "ord2")
(cd "OP ord1 ord2≺ord1" "(1 2)<1")
(simp"<-" (pf"¬(ord1≺OP ord1 ord2)"))
(use "Truth-Axiom")
(use "SMALLERantisym")
(auto)

; Proof finished.

(nrw "¬(OP ord1 ord2≺ord1)")

(display"

End of ≺'s additional RW-rules

")
)

(display-program-constants "SMALLER")



(display"
EXPmonotone:
β≤α → ω^β+γ ≤ ω^α+γ
")

(begin

(sg"(ord2 ≼ ord1) → (OP ord2 ord3 ≼ OP ord1 ord3)")
(assume "ord2" "ord1" "ord3")
(ng #t)
(cases(pt"ord1≺ord2"))
(auto)
)
; Proof finished.

(nrw "(ord2 ≼ ord1) → (OP ord2 ord3 ≼ OP ord1 ord3)")

; (show-output)


(set! COMMENT-FLAG #t)


(display "

End of pao_smaller.scm
")

;EOF
(time
(pp (pt "
        ((ord0 ≼ ord1 and ord1 ≺ ord2) → ord0 ≺ ord2)
     and ((ord2 ≼ ord0 and ord0 ≺ ord1) → ord2 ≺ ord1)
     and ((ord1 ≼ ord2 and ord2 ≺ ord0) → ord1 ≺ ord0)
     and ((ord0 ≺ ord1 and ord1 ≼ ord2) → ord0 ≺ ord2)
     and ((ord2 ≺ ord0 and ord0 ≼ ord1) → ord2 ≺ ord1)
     and ((ord1 ≺ ord2 and ord2 ≼ ord0) → ord1 ≺ ord0)")))