/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.util;

import org.apache.commons.logging.Log;

public abstract class QueueProcessingStatistics {
    State state = State.BEGIN_COLLECTING;
    long startTimeCurrentCycle;
    long startTime;
    long processDuration;
    long clockDuration;
    long workItemCount;
    int cycleCount;
    String queueName;
    String workItemsName;
    Log LOG;

    public QueueProcessingStatistics(String queueName, String workItemsName, Log logObject) {
        this.queueName = queueName;
        this.workItemsName = workItemsName;
        this.LOG = logObject;
    }

    public void startCycle(int maxWorkToProcess) {
        if (this.state == State.DONE_COLLECTING) {
            return;
        }
        this.startTimeCurrentCycle = QueueProcessingStatistics.now();
        boolean preDetectLastCycle = this.preCheckIsLastCycle(maxWorkToProcess);
        switch (this.state) {
            case BEGIN_COLLECTING: {
                this.startTime = this.startTimeCurrentCycle;
                this.state = preDetectLastCycle ? State.IN_SOLE_CYCLE : State.IN_FIRST_CYCLE;
                break;
            }
            default: {
                if (!preDetectLastCycle) break;
                this.state = State.IN_LAST_CYCLE;
            }
        }
    }

    public void endCycle(int workFound) {
        if (this.state == State.DONE_COLLECTING) {
            return;
        }
        long endTimeCurrentCycle = QueueProcessingStatistics.now();
        this.processDuration += endTimeCurrentCycle - this.startTimeCurrentCycle;
        this.clockDuration = endTimeCurrentCycle - this.startTime;
        this.workItemCount += (long)workFound;
        ++this.cycleCount;
        boolean postDetectLastCycle = this.postCheckIsLastCycle(workFound);
        switch (this.state) {
            case BEGIN_COLLECTING: {
                this.logError("endCycle() called before startCycle(), exiting stats collection");
                this.state = State.DONE_COLLECTING;
                break;
            }
            case IN_FIRST_CYCLE: {
                if (postDetectLastCycle) {
                    this.state = State.IN_SOLE_CYCLE;
                } else {
                    this.logEndFirstCycle();
                    this.state = State.DONE_FIRST_CYCLE;
                    break;
                }
            }
            case IN_SOLE_CYCLE: {
                this.logEndFirstCycle();
                this.logEndLastCycle();
                this.state = State.DONE_COLLECTING;
                break;
            }
            case DONE_FIRST_CYCLE: {
                if (!postDetectLastCycle) break;
                this.state = State.IN_LAST_CYCLE;
            }
            case IN_LAST_CYCLE: {
                this.logEndLastCycle();
                this.state = State.DONE_COLLECTING;
                break;
            }
            default: {
                this.logError("unallowed state reached, exiting stats collection");
                this.state = State.DONE_COLLECTING;
            }
        }
    }

    public void checkRestart() {
        switch (this.state) {
            case BEGIN_COLLECTING: {
                return;
            }
            case DONE_COLLECTING: {
                this.logError("Restarted stats collection after completion of first queue flush.");
                this.initialize();
                break;
            }
            default: {
                this.logErrorWithStats("Restarted stats collection before completion of first queue flush.");
                this.initialize();
            }
        }
    }

    void initialize() {
        this.state = State.BEGIN_COLLECTING;
        this.startTimeCurrentCycle = 0L;
        this.startTime = 0L;
        this.processDuration = 0L;
        this.clockDuration = 0L;
        this.workItemCount = 0L;
        this.cycleCount = 0;
    }

    public abstract boolean preCheckIsLastCycle(int var1);

    public abstract boolean postCheckIsLastCycle(int var1);

    String msgEndFirstCycle() {
        return this.queueName + " QueueProcessingStatistics: First cycle completed " + this.workItemCount + " " + this.workItemsName + " in " + this.processDuration + " msec";
    }

    void logEndFirstCycle() {
        this.LOG.info((Object)this.msgEndFirstCycle());
    }

    String msgEndLastCycle() {
        return this.queueName + " QueueProcessingStatistics: Queue flush completed " + this.workItemCount + " " + this.workItemsName + " in " + this.processDuration + " msec processing time, " + this.clockDuration + " msec clock time, " + this.cycleCount + " cycles";
    }

    void logEndLastCycle() {
        this.LOG.info((Object)this.msgEndLastCycle());
    }

    String msgError(String msg) {
        return this.queueName + " QueueProcessingStatistics - Error: " + msg;
    }

    void logError(String msg) {
        this.LOG.error((Object)this.msgError(msg));
    }

    String msgErrorWithStats(String msg) {
        return this.queueName + " QueueProcessingStatistics - Error: " + msg + " Completed " + this.workItemCount + " " + this.workItemsName + " in " + this.processDuration + " msec processing time, " + this.clockDuration + " msec clock time, " + this.cycleCount + " cycles";
    }

    void logErrorWithStats(String msg) {
        this.LOG.error((Object)this.msgErrorWithStats(msg));
    }

    static long now() {
        return System.currentTimeMillis();
    }

    public static enum State {
        BEGIN_COLLECTING,
        IN_FIRST_CYCLE,
        IN_SOLE_CYCLE,
        DONE_FIRST_CYCLE,
        IN_LAST_CYCLE,
        DONE_COLLECTING;

    }
}

