/*
 * Decompiled with CFR 0.152.
 */
package sharpen.core;

import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import sharpen.core.AbstractNestedClassBuilder;
import sharpen.core.CSharpBuilder;
import sharpen.core.csharp.ast.CSBaseExpression;
import sharpen.core.csharp.ast.CSClass;
import sharpen.core.csharp.ast.CSClassModifier;
import sharpen.core.csharp.ast.CSConstructor;
import sharpen.core.csharp.ast.CSConstructorInvocationExpression;
import sharpen.core.csharp.ast.CSExpression;
import sharpen.core.csharp.ast.CSField;
import sharpen.core.csharp.ast.CSReferenceExpression;
import sharpen.core.csharp.ast.CSThisExpression;
import sharpen.core.csharp.ast.CSTypeDeclaration;
import sharpen.core.csharp.ast.CSTypeParameter;
import sharpen.core.csharp.ast.CSTypeReference;
import sharpen.core.csharp.ast.CSTypeReferenceExpression;
import sharpen.core.csharp.ast.CSVisibility;
import sharpen.core.csharp.ast.CSharpCode;

public class CSAnonymousClassBuilder
extends AbstractNestedClassBuilder {
    private AnonymousClassDeclaration _node;
    private CSClass _type;
    private CSConstructor _constructor;
    private Set<IVariableBinding> _capturedVariables = new LinkedHashSet<IVariableBinding>();
    private CSharpBuilder _parent;
    private Set<VariableDeclarationFragment> _fieldInitializers = new LinkedHashSet<VariableDeclarationFragment>();

    public CSAnonymousClassBuilder(CSharpBuilder builder, AnonymousClassDeclaration node) {
        super(builder);
        this._parent = builder;
        this._node = node;
        this.run();
    }

    public CSClass type() {
        return this._type;
    }

    public Set<IVariableBinding> capturedVariables() {
        return this._capturedVariables;
    }

    public CSExpression createConstructorInvocation() {
        CSConstructorInvocationExpression invocation = new CSConstructorInvocationExpression(new CSReferenceExpression(this._type.name()));
        if (this.isEnclosingReferenceRequired()) {
            invocation.addArgument(new CSThisExpression());
        }
        this.addCapturedVariables(invocation);
        this.addBaseConstructorArguments(invocation);
        return invocation;
    }

    private void addCapturedVariables(CSConstructorInvocationExpression invocation) {
        for (IVariableBinding variable : this._capturedVariables) {
            invocation.addArgument(new CSReferenceExpression(this.identifier(variable.getName())));
        }
    }

    private void addBaseConstructorArguments(CSConstructorInvocationExpression invocation) {
        List arguments = this.classInstanceCreationArguments();
        if (arguments.isEmpty()) {
            return;
        }
        ITypeBinding[] ctorParameterTypes = this.classInstanceCreation().resolveConstructorBinding().getParameterTypes();
        if (this._constructor.chainedConstructorInvocation() == null) {
            this._constructor.chainedConstructorInvocation(new CSConstructorInvocationExpression(new CSBaseExpression()));
        }
        int i = 0;
        while (i < ctorParameterTypes.length) {
            ITypeBinding parameterType = ctorParameterTypes[i];
            Expression argument = (Expression)arguments.get(i);
            String parameterName = "baseArg" + (i + 1);
            this._constructor.addParameter(parameterName, this.mappedTypeReference(parameterType));
            this._constructor.chainedConstructorInvocation().addArgument(new CSReferenceExpression(parameterName));
            invocation.addArgument(this._parent.mapExpression(argument));
            ++i;
        }
    }

    private List classInstanceCreationArguments() {
        return this.classInstanceCreation().arguments();
    }

    private ClassInstanceCreation classInstanceCreation() {
        return (ClassInstanceCreation)this._node.getParent();
    }

    @Override
    public void run() {
        this.captureExternalLocalVariables();
        this.setUpAnonymousType();
        this.setUpConstructor();
        this.processAnonymousBody();
        int capturedVariableCount = this.flushCapturedVariables();
        this.flushFieldInitializers();
        this.flushInstanceInitializers(this._type, capturedVariableCount);
    }

    private void flushFieldInitializers() {
        for (VariableDeclarationFragment field : this._fieldInitializers) {
            this.addToConstructor(this.createFieldAssignment(this.fieldName(field), this.mapExpression(field.getInitializer())));
        }
    }

    @Override
    protected CSExpression mapFieldInitializer(VariableDeclarationFragment fragment) {
        if (fragment.getInitializer() != null) {
            this._fieldInitializers.add(fragment);
        }
        return null;
    }

    private void processAnonymousBody() {
        CSTypeDeclaration saved = this._currentType;
        this._currentType = this._type;
        this.visit(this._node.bodyDeclarations());
        this._currentType = saved;
    }

    @Override
    public boolean visit(AnonymousClassDeclaration node) {
        CSAnonymousClassBuilder builder = new CSAnonymousClassBuilder(this, node);
        if (builder.isEnclosingReferenceRequired()) {
            this.requireEnclosingReference();
        }
        this.captureNeededVariables(builder);
        this.pushExpression(builder.createConstructorInvocation());
        this._currentType.addMember(builder.type());
        return false;
    }

    private void captureNeededVariables(CSAnonymousClassBuilder builder) {
        IMethodBinding currentMethod = this.currentMethodDeclarationBinding();
        for (IVariableBinding variable : builder.capturedVariables()) {
            IMethodBinding method = variable.getDeclaringMethod();
            if (method == currentMethod) continue;
            this._capturedVariables.add(variable);
        }
    }

    private IMethodBinding currentMethodDeclarationBinding() {
        return this._currentBodyDeclaration instanceof MethodDeclaration ? ((MethodDeclaration)this._currentBodyDeclaration).resolveBinding() : null;
    }

    private void addFieldParameter(String name, CSTypeReferenceExpression type) {
        this.addFieldParameter(CSharpCode.newPrivateReadonlyField(name, type));
    }

    private void addFieldParameter(CSField field) {
        this._type.addMember(field);
        String parameterName = field.name();
        this._constructor.addParameter(parameterName, field.type());
        this.addToConstructor(this.createFieldAssignment(field.name(), parameterName));
    }

    private void addToConstructor(CSExpression expression) {
        this._constructor.body().addStatement(expression);
    }

    private String anonymousBaseTypeName() {
        return this.mappedTypeName(this.anonymousBaseType());
    }

    public ITypeBinding anonymousBaseType() {
        ITypeBinding binding = this.nestedTypeBinding();
        return binding.getInterfaces().length > 0 ? binding.getInterfaces()[0] : binding.getSuperclass();
    }

    @Override
    protected ITypeBinding nestedTypeBinding() {
        return this._node.resolveBinding();
    }

    private String anonymousInnerClassName() {
        return "_" + this.simpleName(this.anonymousBaseTypeName()) + "_" + this.lineNumber((ASTNode)this._node);
    }

    private String simpleName(String typeName) {
        int index = typeName.lastIndexOf(46);
        if (index < 0) {
            return typeName;
        }
        return typeName.substring(index + 1);
    }

    private void setUpAnonymousType() {
        this._type = this.classForAnonymousType();
    }

    private CSClass classForAnonymousType() {
        CSClass type = new CSClass(this.anonymousInnerClassName(), CSClassModifier.Sealed);
        type.visibility(CSVisibility.Private);
        ITypeBinding bt = this.anonymousBaseType();
        CSTypeReference tref = new CSTypeReference(this.anonymousBaseTypeName());
        type.addBaseType(tref);
        ITypeBinding[] iTypeBindingArray = bt.getTypeArguments();
        int n = iTypeBindingArray.length;
        int n2 = 0;
        while (n2 < n) {
            ITypeBinding arg = iTypeBindingArray[n2];
            tref.addTypeArgument(this.mappedTypeReference(arg));
            ++n2;
        }
        ITypeBinding tt = this.anonymousBaseType();
        ITypeBinding[] iTypeBindingArray2 = tt.getTypeParameters();
        int n3 = iTypeBindingArray2.length;
        n = 0;
        while (n < n3) {
            ITypeBinding tp = iTypeBindingArray2[n];
            type.addTypeParameter(new CSTypeParameter(this.identifier(tp.getName())));
            ++n;
        }
        return type;
    }

    private void setUpConstructor() {
        this._constructor = new CSConstructor();
        this._constructor.visibility(CSVisibility.Public);
        this._type.addMember(this._constructor);
    }

    private int flushCapturedVariables() {
        int capturedVariableCount = 0;
        if (this.isEnclosingReferenceRequired()) {
            ++capturedVariableCount;
            CSField ef = this.createEnclosingField();
            this.addFieldParameter(ef);
            ITypeBinding bt = this.anonymousBaseType();
            if (bt != null && this.isNonStaticNestedType(bt)) {
                if (this._constructor.chainedConstructorInvocation() == null) {
                    this._constructor.chainedConstructorInvocation(new CSConstructorInvocationExpression(new CSBaseExpression()));
                }
                this._constructor.chainedConstructorInvocation().addArgument(new CSReferenceExpression(ef.name()));
            }
        }
        for (IVariableBinding variable : this._capturedVariables) {
            ++capturedVariableCount;
            this.addFieldParameter(this.identifier(variable.getName()), this.mappedTypeReference(variable.getType()));
        }
        return capturedVariableCount;
    }

    private void captureExternalLocalVariables() {
        this._node.accept(new ASTVisitor(){
            IMethodBinding _currentMethodBinding;

            public boolean visit(MethodDeclaration node) {
                IMethodBinding saved = this._currentMethodBinding;
                this._currentMethodBinding = node.resolveBinding();
                node.getBody().accept((ASTVisitor)this);
                this._currentMethodBinding = saved;
                return false;
            }

            public boolean visit(AnonymousClassDeclaration node) {
                return node == CSAnonymousClassBuilder.this._node;
            }

            public boolean visit(SimpleName node) {
                IBinding binding = node.resolveBinding();
                if (this.isExternalLocal(binding)) {
                    CSAnonymousClassBuilder.this._capturedVariables.add((IVariableBinding)binding);
                }
                return false;
            }

            boolean isExternalLocal(IBinding binding) {
                IVariableBinding variable;
                if (binding instanceof IVariableBinding && !(variable = (IVariableBinding)binding).isField()) {
                    return variable.getDeclaringMethod() != this._currentMethodBinding;
                }
                return false;
            }
        });
    }
}

