
type change = 
  | DELETE of string
  | RENAME of string * string
  | ADD_DIR of string
  | ADD_FILE of string * string
  | PATCH of string * string * string
  | ATTR_CLEAR of string * string
  | ATTR_SET of string * string * string

type edge = {
    old_revision : string ;
    change_set : change list ;
  }

type t = string * edge list


type tok = Basic_io_lexer.v =
  | ID of string
  | STRING of string
  | MULT of string list
  | NONE


let rec _star acc p = parser
  | [< v = p ; nxt >] -> _star (v :: acc) p nxt
  | [<>] -> acc


let format = parser
  | [< ' [ "format_version", STRING "1" ] >] ->
      ()
let new_manifest = parser
  | [< ' [ "new_manifest", ID id ] >] ->
      id

let delete = parser
  | [< ' [ "delete", STRING p ] >] -> 
      DELETE p
let rename = parser
  | [< ' [ "rename", STRING p ; 
	   "to", STRING np ] >] -> 
      RENAME (p, np)
let add_dir = parser
  | [< ' [ "add_dir", STRING p ] >] -> 
      ADD_DIR p
let add_file = parser
  | [< ' [ "add_file", STRING p ;
	   "content", ID id ] >] -> 
      ADD_FILE (p, id)
let patch = parser
  | [< ' [ "patch", STRING p ; 
	   "from", ID id1 ;
	   "to", ID id2 ] >] ->
      PATCH (p, id1, id2)
let clear = parser
  | [< ' [ "clear", STRING p ;
	   "attr", STRING a ] >] ->
      ATTR_CLEAR (p, a)
let set = parser
  | [< ' [ "set", STRING p ;
	   "attr", STRING a ;
	   "value", STRING v ] >] ->
      ATTR_SET (p, a, v)
let change_set = parser
  | [< cs = _star [] delete ;
       cs = _star cs rename ;
       cs = _star cs add_dir ;
       cs = _star cs add_file ;
       cs = _star cs patch ;
       cs = _star cs clear ;
       cs = _star cs set >] -> List.rev cs
    
let edge = parser
  | [< ' [ "old_revision", ID id ] ; cs = change_set >] ->
      { old_revision = id ; change_set = cs }


let revision = parser
  | [< () = format ;
       manifest = new_manifest ;
       edges = _star [] edge >] ->
      manifest, List.rev edges


let revision_set lb =
  let strm = 
    Stream.from
      (fun _ -> Basic_io_lexer.get_stanza lb) in
  revision strm
