# API Status

All of the [Node's `fs` API](https://nodejs.org/api/fs.html) is implemented.
Some error messages may be inaccurate. File permissions are currently not
implemented (you have access to any file), basically `fs.access()` is a no-op.

  - [x] Promises
  - [x] Constants
  - [x] `FSWatcher`
  - [x] `ReadStream`
  - [x] `WriteStream`
  - [x] `Stats`
  - [x] `Dirent`
  - [x] `access(path[, mode], callback)`
    - Does not check permissions
  - [x] `accessSync(path[, mode])`
    - Does not check permissions
  - [x] `appendFile(file, data[, options], callback)`
  - [x] `appendFileSync(file, data[, options])`
  - [x] `chmod(path, mode, callback)`
  - [x] `chmodSync(path, mode)`
  - [x] `chown(path, uid, gid, callback)`
  - [x] `chownSync(path, uid, gid)`
  - [x] `fs.copyFile(src, dest[, flags], callback)`
  - [x] `fs.copyFileSync(src, dest[, flags])`
     - Honors `COPYFILE_EXCL`
     - Ignores `COPYFILE_FICLONE` *copy-on-write* &mdash; always creates a copy.
     - If `COPYFILE_FICLONE_FORCE` flag specified, will always fail with `ENOSYS`.
  - [x] `close(fd, callback)`
  - [x] `closeSync(fd)`
  - [x] `createReadStream(path[, options])`
  - [x] `createWriteStream(path[, options])`
  - [x] `exists(path, callback)`
  - [x] `existsSync(path)`
  - [x] `fchmod(fd, mode, callback)`
  - [x] `fchmodSync(fd, mode)`
  - [x] `fchown(fd, uid, gid, callback)`
  - [x] `fchownSync(fd, uid, gid)`
  - [x] `fdatasync(fd, callback)`
  - [x] `fdatasyncSync(fd)`
  - [x] `fstat(fd, callback)`
  - [x] `fstatSync(fd)`
  - [x] `fsync(fd, callback)`
  - [x] `fsyncSync(fd)`
  - [x] `ftruncate(fd[, len], callback)`
  - [x] `ftruncateSync(fd[, len])`
  - [x] `futimes(fd, atime, mtime, callback)`
  - [x] `futimesSync(fd, atime, mtime)`
  - [x] `lchmod(path, mode, callback)`
  - [x] `lchmodSync(path, mode)`
  - [x] `lchown(path, uid, gid, callback)`
  - [x] `lchownSync(path, uid, gid)`
  - [x] `link(existingPath, newPath, callback)`
  - [x] `linkSync(existingPath, newPath)`
  - [x] `lstat(path, callback)`
  - [x] `lstatSync(path)`
  - [x] `mkdir(path[, options], callback)`
  - [x] `mkdirSync(path[, options])`
  - [x] `mkdtemp(prefix[, options], callback)`
  - [x] `mkdtempSync(prefix[, options])`
  - [x] `open(path, flags[, mode], callback)`
  - [x] `openSync(path, flags[, mode])`
  - [x] `read(fd, buffer, offset, length, position, callback)`
  - [x] `readSync(fd, buffer, offset, length, position)`
  - [x] `readdir(path[, options], callback)`
  - [x] `readdirSync(path[, options])`
  - [x] `readFile(path[, options], callback)`
  - [x] `readFileSync(path[, options])`
  - [x] `readlink(path[, options], callback)`
  - [x] `readlinkSync(path[, options])`
  - [x] `realpath(path[, options], callback)`
  - [x] `realpathSync(path[, options])`
    - Caching not implemented
  - [x] `rename(oldPath, newPath, callback)`
  - [x] `renameSync(oldPath, newPath)`
  - [x] `rmdir(path, callback)`
  - [x] `rmdirSync(path)`
  - [x] `stat(path, callback)`
  - [x] `statSync(path)`
  - [x] `symlink(target, path[, type], callback)`
  - [x] `symlinkSync(target, path[, type])`
  - [x] `truncate(path[, len], callback)`
  - [x] `truncateSync(path[, len])`
  - [x] `unlink(path, callback)`
  - [x] `unlinkSync(path)`
  - [x] `utimes(path, atime, mtime, callback)`
  - [x] `utimesSync(path, atime, mtime)`
  - [x] `watch(filename[, options][, listener])`
  - [x] `watchFile(filename[, options], listener)`
  - [x] `unwatchFile(filename[, listener])`
  - [x] `write(fd, buffer[, offset[, length[, position]]], callback)`
  - [x] `write(fd, string[, position[, encoding]], callback)`
  - [x] `writeFile(file, data[, options], callback)`
  - [x] `writeFileSync(file, data[, options])`
  - [x] `writeSync(fd, buffer[, offset[, length[, position]]])`
  - [x] `writeSync(fd, string[, position[, encoding]])`
