#if HAVE_CONFIG_H
#   include "config.h"
#endif

#ifdef WIN32
   static double msec;             /* reference for timer */
#  include <windows.h>
#else
#if HAVE_SYS_TYPES_H
#  include <sys/types.h>
#endif
#if HAVE SYS_TIME_H
#  include <sys/time.h>
#endif
   static unsigned firstsec=0;     /* Reference for timer */
   static unsigned firstusec=0;    /* Reference for timer */
#endif
static int first_call=1;

double armci_timer()
{
#ifdef WIN32
    double t0 = (double)GetCurrentTime();
    if(first_call){
        first_call=0; msec=t0; return 0.0;
    }
    t0 -=msec;
    if(t0<0.0)t0 += (double)0xffffffff;
    return 0.01*t0;
#else
    double low, high;
    struct timeval tp;
    struct timezone tzp;
    (void) gettimeofday(&tp,&tzp);

    if (first_call) {
         firstsec = tp.tv_sec;
         firstusec = tp.tv_usec;
         first_call = 0;
    }
    low = (double)(tp.tv_usec>>1) - (double) (firstusec>>1);
    high = (double) (tp.tv_sec - firstsec);
    return high + 1.0e-6*(low+low);
#endif
}

