###
### SMS outgoing plugin for ObexTool
###
### (c) Gerhard Reithofer, Techn. EDV Reithofer - 2003-05
### gerhard.reithofer@tech-edv.co.at http://www.tech-edv.co.at
###
### See COPYING for further details
###

namespace eval ::SMO {

  source $OBEXDIR/plugins/siemplug.tcl
  
  load_Messages siemplug [getObexCfg config language] $version

  proc add_flag_data { tf } {
    global SMS_FLAG PDU_TYPE
    variable header_data

    set sa_data [pdu2phone $SMS_FLAG(SCA)]
    set ts_data [get_vp_value $SMS_FLAG(VP) $PDU_TYPE(VPF)]
    set rc_data [pdu2phone $SMS_FLAG(DA)]
    set hd_data $header_data

    set sa_lbl [get_text "Service center address:" siemplug]
    set ts_lbl [get_text "Validy period:"          siemplug]
    set rc_lbl [get_text "Receiver address:"       siemplug]
    set hd_lbl [get_text "Undocumented header:"    siemplug]
    
    foreach key [list sa ts rc hd] {
      eval "label_entry $tf.$key $${key}_lbl $${key}_data"
    }
  }

  proc default_handler { args } {
    debug_out "[namespace current]::default_handler $args" 5
    global global_msg

    set path [lindex $args 0]
    set len [init_plugin $path]
    if {$len < 0} return
    set title [get_text "Outgoing SMS file: %s" siemplug]

    set stext [pdu2txt $global_msg $len]
    sms_dialog [format $title $path] $stext
  }

}

return $::SMO::version
