//                                               -*- C++ -*-
/**
 *  @brief The external header file of OpenTURNS for subdir OrthogonalBasis
 *
 *  Copyright 2005-2024 Airbus-EDF-IMACS-ONERA-Phimeca
 *
 *  This library is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with this library.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#ifndef OPENTURNS_OTORTHOGONALBASIS_HXX
#define OPENTURNS_OTORTHOGONALBASIS_HXX

#include "openturns/AdaptiveStieltjesAlgorithm.hxx"
#include "openturns/OrthogonalUniVariatePolynomial.hxx"
#include "openturns/CharlierFactory.hxx"
#include "openturns/ChebychevFactory.hxx"
#include "openturns/HermiteFactory.hxx"
#include "openturns/HistogramPolynomialFactory.hxx"
#include "openturns/JacobiFactory.hxx"
#include "openturns/KrawtchoukFactory.hxx"
#include "openturns/LaguerreFactory.hxx"
#include "openturns/LegendreFactory.hxx"
#include "openturns/MeixnerFactory.hxx"
#include "openturns/OrthogonalBasis.hxx"
#include "openturns/OrthogonalFunctionFactory.hxx"
#include "openturns/OrthogonalProductPolynomialFactory.hxx"
#include "openturns/OrthogonalUniVariatePolynomialFactory.hxx"
#include "openturns/OrthogonalUniVariatePolynomialFamily.hxx"
#include "openturns/OrthonormalizationAlgorithm.hxx"
#include "openturns/OrthonormalizationAlgorithmImplementation.hxx"
#include "openturns/StandardDistributionPolynomialFactory.hxx"
#include "openturns/OrthogonalUniVariateFunctionFamily.hxx"
#include "openturns/OrthogonalUniVariateFunctionFactory.hxx"
#include "openturns/OrthogonalUniVariatePolynomialFunctionFactory.hxx"
#include "openturns/FourierSeriesFactory.hxx"
#include "openturns/HaarWaveletFactory.hxx"
#include "openturns/OrthogonalProductFunctionFactory.hxx"
#include "openturns/SoizeGhanemFactory.hxx"

#endif /* OPENTURNS_OTORTHOGONALBASIS_HXX */
