###############################################################################
# OpenVAS Vulnerability Test
# $Id: apache_tomcat_multiple_vulnerabilities_jan_10.nasl 8097 2010-06-21 13:15:26Z mime $
#
# Apache Tomcat Multiple Vulnerabilities January 2010
#
# Authors:
# Michael Meyer
#
# Copyright:
# Copyright (c) 2010 Greenbone Networks GmbH
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if (description)
{
 script_id(100474);
 script_bugtraq_id(37945,37942,37944);
 script_cve_id("CVE-2009-2901","CVE-2009-2902","CVE-2009-2693");
 script_version ("1.0-$Revision: 8097 $");
 script_tag(name:"cvss_base", value:"5.8");
 script_tag(name:"risk_factor", value:"High");

 script_name("Apache Tomcat Multiple Vulnerabilities January 2010");

desc = "Overview:
Apache Tomcat is prone to a directory-traversal vulnerability and to
an authentication-bypass vulnerability.

Exploiting this issue allows attackers to delete arbitrary files
within the context of the current working directory or gain
unauthorized access to files and directories..

The following versions are affected:

Tomcat 5.5.0 through 5.5.28 
Tomcat 6.0.0 through 6.0.20

Solution:
The vendor has released updates. Please see the references for
details.

References:
http://www.securityfocus.com/bid/37945
http://www.securityfocus.com/bid/37944
http://www.securityfocus.com/bid/37942
http://tomcat.apache.org/
http://svn.apache.org/viewvc?view=revision&revision=892815
http://svn.apache.org/viewvc?view=revision&revision=902650

Risk factor : Medium";

 script_description(desc);
 script_summary("Determine if Apache Tomcat version is vulnerable");
 script_category(ACT_GATHER_INFO);
 script_family("Web Servers");
 script_copyright("This script is Copyright (C) 2010 Greenbone Networks GmbH");
 script_dependencies("gb_apache_tomcat_detect.nasl");
 script_require_ports("Services/www", 8080);
 exit(0);
}

include("http_func.inc");
include("version_func.inc");

tomPort = get_http_port(default:8080);
if(tomPort == NULL){
    exit(0);
}

tomcatVer = get_kb_item("www/" + tomPort + "/ApacheTomcat");

if(tomcatVer == NULL){
    exit(0);
}

if(version_in_range(version:tomcatVer, test_version:"5.5", test_version2:"5.5.28") ||
   version_in_range(version:tomcatVer, test_version:"6.0", test_version2:"6.0.20")){
   security_warning(tomPort);
   exit(0);
}

exit(0);
     

