# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 068-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(53818);
 script_version ("$");
 script_tag(name:"risk_factor", value:"High");
 name = "Debian Security Advisory DSA 068-1 (openldap)";
 script_name(name);

 desc = "The remote host is missing an update to openldap
announced via advisory DSA 068-1.

CERT released their advisory CA-2001-18 which lists a number of
vulnerabilities in various LDAP implementations. based on the
results of the PROTOS LDAPv3 test suite. These tests found one
problem in OpenLDAP, a free LDAP implementation that is shipped
as part of Debian GNU/Linux 2.2.

The problem is that slapd did not handle packets with an invalid
BER length of length fields and would crash if it received those.
An attacked can use this to mount a denial of service attack
remotely.

This problem has been fixed in version 1.2.11-1, and we recommend
that you upgrade your slapd package immediately.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20068-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 068-1 (openldap)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"ldap-rfc", ver:"1.2.12-1", rls:"DEB2.2")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libopenldap-runtime", ver:"1.2.12-1", rls:"DEB2.2")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libopenldap-dev", ver:"1.2.12-1", rls:"DEB2.2")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libopenldap1", ver:"1.2.12-1", rls:"DEB2.2")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"openldap-gateways", ver:"1.2.12-1", rls:"DEB2.2")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"openldap-utils", ver:"1.2.12-1", rls:"DEB2.2")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"openldapd", ver:"1.2.12-1", rls:"DEB2.2")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
