# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1104-2
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(57071);
 script_cve_id("CVE-2006-3117");
 script_version ("$");
 script_tag(name:"cvss_base", value:"7.6");
 script_tag(name:"risk_factor", value:"High");
 name = "Debian Security Advisory DSA 1104-2 (openoffice.org)";
 script_name(name);

 desc = "The remote host is missing an update to openoffice.org
announced via advisory DSA 1104-2.

Loading malformed XML documents can cause buffer overflows in
OpenOffice.org, a free office suite, and cause a denial of service or
execute arbitrary code.  It turned out that the correction in DSA
1104-1 was not sufficient, hence, another update.

The old stable distribution (woody) does not contain OpenOffice.org
packages.

For the stable distribution (sarge) this problem has been fixed in
version 1.1.3-9sarge3.

For the unstable distribution (sid) this problem has been fixed in
version 2.0.3-1.

We recommend that you upgrade your OpenOffice.org packages.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201104-2

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 1104-2 (openoffice.org)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2006 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"openoffice.org-l10n-af", ver:"1.1.3-9sarge3", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"openoffice.org-l10n-ar", ver:"1.1.3-9sarge3", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"openoffice.org-l10n-ca", ver:"1.1.3-9sarge3", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"openoffice.org-l10n-cs", ver:"1.1.3-9sarge3", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"openoffice.org-l10n-cy", ver:"1.1.3-9sarge3", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"openoffice.org-l10n-da", ver:"1.1.3-9sarge3", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"openoffice.org-l10n-de", ver:"1.1.3-9sarge3", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"openoffice.org-l10n-el", ver:"1.1.3-9sarge3", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"openoffice.org-l10n-en", ver:"1.1.3-9sarge3", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"openoffice.org-l10n-es", ver:"1.1.3-9sarge3", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"openoffice.org-l10n-et", ver:"1.1.3-9sarge3", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"openoffice.org-l10n-eu", ver:"1.1.3-9sarge3", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"openoffice.org-l10n-fi", ver:"1.1.3-9sarge3", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"openoffice.org-l10n-fr", ver:"1.1.3-9sarge3", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"openoffice.org-l10n-gl", ver:"1.1.3-9sarge3", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"openoffice.org-l10n-he", ver:"1.1.3-9sarge3", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"openoffice.org-l10n-hi", ver:"1.1.3-9sarge3", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"openoffice.org-l10n-hu", ver:"1.1.3-9sarge3", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"openoffice.org-l10n-it", ver:"1.1.3-9sarge3", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"openoffice.org-l10n-ja", ver:"1.1.3-9sarge3", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"openoffice.org-l10n-kn", ver:"1.1.3-9sarge3", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"openoffice.org-l10n-ko", ver:"1.1.3-9sarge3", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"openoffice.org-l10n-lt", ver:"1.1.3-9sarge3", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"openoffice.org-l10n-nb", ver:"1.1.3-9sarge3", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"openoffice.org-l10n-nl", ver:"1.1.3-9sarge3", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"openoffice.org-l10n-nn", ver:"1.1.3-9sarge3", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"openoffice.org-l10n-ns", ver:"1.1.3-9sarge3", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"openoffice.org-l10n-pl", ver:"1.1.3-9sarge3", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"openoffice.org-l10n-pt-br", ver:"1.1.3-9sarge3", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"openoffice.org-l10n-pt", ver:"1.1.3-9sarge3", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"openoffice.org-l10n-ru", ver:"1.1.3-9sarge3", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"openoffice.org-l10n-sk", ver:"1.1.3-9sarge3", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"openoffice.org-l10n-sl", ver:"1.1.3-9sarge3", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"openoffice.org-l10n-sv", ver:"1.1.3-9sarge3", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"openoffice.org-l10n-th", ver:"1.1.3-9sarge3", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"openoffice.org-l10n-tn", ver:"1.1.3-9sarge3", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"openoffice.org-l10n-tr", ver:"1.1.3-9sarge3", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"openoffice.org-l10n-zh-cn", ver:"1.1.3-9sarge3", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"openoffice.org-l10n-zh-tw", ver:"1.1.3-9sarge3", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"openoffice.org-l10n-zu", ver:"1.1.3-9sarge3", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"openoffice.org-mimelnk", ver:"1.1.3-9sarge3", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"openoffice.org-thesaurus-en-us", ver:"1.1.3-9sarge3", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"openoffice.org", ver:"1.1.3-9sarge3", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"ttf-opensymbol", ver:"1.1.3-9sarge3", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"openoffice.org-bin", ver:"1.1.3-9sarge3", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"openoffice.org-dev", ver:"1.1.3-9sarge3", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"openoffice.org-evolution", ver:"1.1.3-9sarge3", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"openoffice.org-gtk-gnome", ver:"1.1.3-9sarge3", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"openoffice.org-kde", ver:"1.1.3-9sarge3", rls:"DEB3.1")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
