# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 675-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(53503);
 script_bugtraq_id(12518);
 script_cve_id("CVE-2005-0019");
 script_version ("$");
 script_tag(name:"cvss_base", value:"4.6");
 script_tag(name:"risk_factor", value:"Medium");
 name = "Debian Security Advisory DSA 675-1 (hztty)";
 script_name(name);

 desc = "The remote host is missing an update to hztty
announced via advisory DSA 675-1.

Erik Sjlund discovered that hztty, a converter for GB, Big5 and zW/HZ
Chinese encodings in a tty session, can be triggered to execute
arbitrary commands with group utmp privileges.

For the stable distribution (woody) this problem has been fixed in
version 2.0-5.2woody2.

For the unstable distribution (sid) this problem has been fixed in
version 2.0-6.1.

We recommend that you upgrade your hztty package.


Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20675-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 675-1 (hztty)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"hztty", ver:"2.0-5.2woody2", rls:"DEB3.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
