###############################################################################
# OpenVAS Vulnerability Test
#
# Ubuntu Update for Firefox 3.5 and Xulrunner 1.9.1 vulnerabilities USN-896-1
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2010 Greenbone Networks GmbH, http://www.greenbone.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(840388);
  script_version("$Revision: 8167 $: 1.0");
  script_tag(name:"cvss_base", value:"10.0");
  script_tag(name:"risk_factor", value:"Critical");
  script_xref(name: "USN", value: "896-1");
  script_cve_id("CVE-2009-1571", "CVE-2009-3988", "CVE-2010-0159", "CVE-2010-0160", "CVE-2010-0162");
  script_name("Ubuntu Update for Firefox 3.5 and Xulrunner 1.9.1 vulnerabilities USN-896-1");
  desc = "

  Vulnerability Insight:

  Several flaws were discovered in the browser engine of Firefox. If a user
  were tricked into viewing a malicious website, a remote attacker could
  cause a denial of service or possibly execute arbitrary code with the
  privileges of the user invoking the program. (CVE-2010-0159)
  
  Orlando Barrera II discovered a flaw in the Web Workers implementation of
  Firefox. If a user were tricked into posting to a malicious website, an
  attacker could cause a denial of service or possibly execute arbitrary code
  with the privileges of the user invoking the program. (CVE-2010-0160)
  
  Alin Rad Pop discovered that Firefox's HTML parser would incorrectly free
  memory under certain circumstances. If the browser could be made to access
  these freed memory objects, an attacker could exploit this to execute
  arbitrary code with the privileges of the user invoking the program.
  (CVE-2009-1571)
  
  Hidetake Jo discovered that the showModalDialog in Firefox did not always
  honor the same-origin policy. An attacker could exploit this to run
  untrusted JavaScript from other domains. (CVE-2009-3988)
  
  Georgi Guninski discovered that the same-origin check in Firefox could be
  bypassed by utilizing a crafted SVG image. If a user were tricked into
  viewing a malicious website, an attacker could exploit this to read data
  from other domains. (CVE-2010-0162)

  Affected Software/OS:
  Firefox 3.5 and Xulrunner 1.9.1 vulnerabilities on Ubuntu 9.10

  Fix: Please Install the Updated Packages.

  References:
  https://lists.ubuntu.com/archives/ubuntu-security-announce/2010-February/001048.html

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of Firefox 3.5 and Xulrunner 1.9.1 vulnerabilities");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (c) 2010 Greenbone Networks GmbH");
  script_family("Ubuntu Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-deb.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "UBUNTU9.10")
{

  if(isdpkgvuln(pkg:"abrowser-3.5-branding", ver:"3.5.8+build1+nobinonly-0ubuntu0.9.10.1", rls:"UBUNTU9.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"firefox-3.5-branding", ver:"3.5.8+build1+nobinonly-0ubuntu0.9.10.1", rls:"UBUNTU9.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"firefox-3.5-dbg", ver:"3.5.8+build1+nobinonly-0ubuntu0.9.10.1", rls:"UBUNTU9.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"firefox-3.5-dev", ver:"3.5.8+build1+nobinonly-0ubuntu0.9.10.1", rls:"UBUNTU9.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"firefox-3.5-gnome-support", ver:"3.5.8+build1+nobinonly-0ubuntu0.9.10.1", rls:"UBUNTU9.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"firefox-3.5", ver:"3.5.8+build1+nobinonly-0ubuntu0.9.10.1", rls:"UBUNTU9.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"xulrunner-1.9.1-dbg", ver:"1.9.1.8+build1+nobinonly-0ubuntu0.9.10.1", rls:"UBUNTU9.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"xulrunner-1.9.1-dev", ver:"1.9.1.8+build1+nobinonly-0ubuntu0.9.10.1", rls:"UBUNTU9.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"xulrunner-1.9.1-gnome-support", ver:"1.9.1.8+build1+nobinonly-0ubuntu0.9.10.1", rls:"UBUNTU9.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"xulrunner-1.9.1-testsuite-dev", ver:"1.9.1.8+build1+nobinonly-0ubuntu0.9.10.1", rls:"UBUNTU9.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"xulrunner-1.9.1", ver:"1.9.1.8+build1+nobinonly-0ubuntu0.9.10.1", rls:"UBUNTU9.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"xulrunner-dev", ver:"1.9.1.8+build1+nobinonly-0ubuntu0.9.10.1", rls:"UBUNTU9.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"xulrunner-1.9.1-testsuite", ver:"1.9.1.8+build1+nobinonly-0ubuntu0.9.10.1", rls:"UBUNTU9.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"abrowser", ver:"3.5.8+build1+nobinonly-0ubuntu0.9.10.1", rls:"UBUNTU9.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"firefox-3.0-dev", ver:"3.5.8+build1+nobinonly-0ubuntu0.9.10.1", rls:"UBUNTU9.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"firefox-3.1-dbg", ver:"3.5.8+build1+nobinonly-0ubuntu0.9.10.1", rls:"UBUNTU9.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"firefox-3.1-dev", ver:"3.5.8+build1+nobinonly-0ubuntu0.9.10.1", rls:"UBUNTU9.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"firefox-gnome-support", ver:"3.5.8+build1+nobinonly-0ubuntu0.9.10.1", rls:"UBUNTU9.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"firefox", ver:"3.5.8+build1+nobinonly-0ubuntu0.9.10.1", rls:"UBUNTU9.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"abrowser-3.0-branding", ver:"3.5.8+build1+nobinonly-0ubuntu0.9.10.1", rls:"UBUNTU9.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"abrowser-3.0", ver:"3.5.8+build1+nobinonly-0ubuntu0.9.10.1", rls:"UBUNTU9.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"abrowser-3.1-branding", ver:"3.5.8+build1+nobinonly-0ubuntu0.9.10.1", rls:"UBUNTU9.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"abrowser-3.1", ver:"3.5.8+build1+nobinonly-0ubuntu0.9.10.1", rls:"UBUNTU9.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"abrowser-3.5", ver:"3.5.8+build1+nobinonly-0ubuntu0.9.10.1", rls:"UBUNTU9.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"firefox-3.0-branding", ver:"3.5.8+build1+nobinonly-0ubuntu0.9.10.1", rls:"UBUNTU9.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"firefox-3.0-dom-inspector", ver:"3.5.8+build1+nobinonly-0ubuntu0.9.10.1", rls:"UBUNTU9.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"firefox-3.0-gnome-support", ver:"3.5.8+build1+nobinonly-0ubuntu0.9.10.1", rls:"UBUNTU9.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"firefox-3.0-venkman", ver:"3.5.8+build1+nobinonly-0ubuntu0.9.10.1", rls:"UBUNTU9.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"firefox-3.0", ver:"3.5.8+build1+nobinonly-0ubuntu0.9.10.1", rls:"UBUNTU9.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"firefox-3.1-branding", ver:"3.5.8+build1+nobinonly-0ubuntu0.9.10.1", rls:"UBUNTU9.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"firefox-3.1-gnome-support", ver:"3.5.8+build1+nobinonly-0ubuntu0.9.10.1", rls:"UBUNTU9.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"firefox-3.1", ver:"3.5.8+build1+nobinonly-0ubuntu0.9.10.1", rls:"UBUNTU9.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"firefox-dom-inspector", ver:"3.5.8+build1+nobinonly-0ubuntu0.9.10.1", rls:"UBUNTU9.10"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}