###############################################################################
#
#  This script was written by David Maciejak <david dot maciejak at kyxar dot fr>
#  based on work from
# (C) Tenable Network Security
#
# Ref: GreyMagic <http://www.greymagic.com/> and Tom Gilder
#
# Updated: 03/12/2009 Antu Sanadi <santu@secpod.com>
#
# This script is released under the GNU GPLv2
#
###############################################################################

if(description)
{
  script_id(14245);
  script_cve_id("CVE-2004-0537");
  script_bugtraq_id(10452);
  script_version("$Revision: 8096 $");
  script_tag(name:"cvss_base", value:"2.0");
  script_tag(name:"risk_factor", value:"Low");
  script_name("Opera web browser address bar spoofing weakness (2)");
  desc = "
  Synopsis :

  The remote host contains a web browser that is vulnerable to
  address bar spoofing attacks.

  Description :
  The remote host is using Opera, an alternative web browser.
  This version of Opera is vulnerable to a security weakness that may
  permit malicious web pages to spoof address bar information.  It is
  reported that the 'favicon' feature can be used to spoof the domain of
  a malicious web page.  An attacker can create an icon that includes
  the text of the desired site and is similar to the way Opera displays
  information in the address bar.  The attacker can then obfuscate the
  real address with spaces.

  This issue can be used to spoof information in the address bar, page
  bar and page/window cycler.

  See also :

  http://www.greymagic.com/security/advisories/gm007-op/
  http://www.opera.com/windows/changelogs/751/

  Solution :
  Install to Opera 7.51 or newer.

  Risk factor :
  Low / CVSS Base Score : 2
  (AV:R/AC:L/Au:NR/C:N/A:N/I:P/B:N)";

  script_description(desc);
  script_summary("Determines the version of Opera.exe");
  script_category(ACT_GATHER_INFO);
  script_copyright("This script is Copyright (C) 2004 David Maciejak");
  script_family("Windows");
  script_dependencies("secpod_opera_detection_win_900036.nasl");
  script_require_keys("Opera/Win/Version");
  exit(0);
}


include("version_func.inc");

OperaVer = get_kb_item("Opera/Win/Version");
if(!OperaVer){
  exit(0);
}

if(version_is_less_equal(version:OperaVer, test_version:"7.50")){
  security_hole(0);
}
