###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_ms_ie_html_form_dos_vuln.nasl 922 2009-02-02 19:21:24Z jan $
#
# Microsoft Internet Explorer HTML Form Value DoS Vulnerability
#
# Authors:
# Sharath S <sharaths@secpod.com>
#
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900303);
  script_version("$Revision: 1.0 $");
  script_tag(name:"cvss_base", value:"9.3");
  script_tag(name:"risk_factor", value:"Critical");
  script_cve_id("CVE-2009-0341");
  script_bugtraq_id(33494);
  script_name("Microsoft Internet Explorer HTML Form Value DoS Vulnerability");
  desc = "

  Overview: This host is installed Internet Explorer and is prone to Denial
  of Service vulnerability.

  Vulnerability Insight:
  Browser fails to validate user supplied data via a long VALUE attribute in
  an INPUT element.

  Impact:
  Successful exploitation could allow remote attackers to crash the browser.

  Impact Level: Application

  Affected Software/OS:
  Microsoft Internet Explorer version 7.0 and prior on Windows.

  Fix: No solution or patch is available as on 03rd February, 2009. Information
  regarding this issue will be updated once the solution details are available.
  For updates refer,
  http://www.microsoft.com/windows/internet-explorer/download-ie.aspx

  References:
  http://jplopezy.fortunecity.es/ietest.html
  http://www.securityfocus.com/archive/1/archive/1/500472/100/0/threaded

  CVSS Score:
    CVSS Base Score     : 9.3 (AV:N/AC:M/Au:NR/C:C/I:C/A:C)
    CVSS Temporal Score : 8.4
  Risk factor: Critical";

  script_description(desc);
  script_summary("Check for the Version of Internet Explorer");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 SecPod");
  script_family("Denial of Service");
  script_dependencies("gb_ms_ie_detect.nasl");
  script_require_keys("MS/IE/Version");
  script_require_ports(139, 445);
  exit(0);
}


ieVer = get_kb_item("MS/IE/Version");
if(!ieVer){
  exit(0);
}

# Check for Internet Explorer version 7.0 and prior
if(ieVer =~ "^[5-7]\..*"){
  security_hole(0);
}
