///////////////////////////////////////////////////////////////////////////////
// 
//  Copyright (2008) Alexander Stukowski
//
//  This file is part of OVITO (Open Visualization Tool).
//
//  OVITO is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  OVITO is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program.  If not, see <http://www.gnu.org/licenses/>.
//
///////////////////////////////////////////////////////////////////////////////

#ifndef __OVITO_INT_CONTROLLER_UI_H
#define __OVITO_INT_CONTROLLER_UI_H

#include <core/Core.h>
#include "NumericalControllerUI.h"

namespace Core {

/******************************************************************************
* A parameter UI for parameters controlled by an IntegerController object.
******************************************************************************/
class CORE_DLLEXPORT IntegerControllerUI : public NumericalControllerUI
{
public:
	/// Constructor.
	IntegerControllerUI(PropertiesEditor* parentEditor, const PropertyFieldDescriptor& refField);

	/// Gets the minimum value to be entered.
	/// This value is in native controller units.
	int minValue() const;

	/// Sets the minimum value to be entered.
	/// This value must be specified in native controller units.
	void setMinValue(int minValue);

	/// Gets the maximum value to be entered.
	/// This value is in native controller units.
	int maxValue() const;

	/// Sets the maximum value to be entered.
	/// This value must be specified in native controller units.
	void setMaxValue(int maxValue);

	/// This method updates the displayed value of the parameter UI.
	virtual void updateUI();
	
	/// Takes the value entered by the user and stores it in the parameter object
	/// this parameter UI is bound to. 
	virtual void updateParameterValue();
	
public:
	
	Q_PROPERTY(int minValue READ minValue WRITE setMinValue)	
	Q_PROPERTY(int maxValue READ maxValue WRITE setMaxValue)	
	
private:

	Q_OBJECT
	DECLARE_ABSTRACT_PLUGIN_CLASS(IntegerControllerUI)
};

};

#endif // __OVITO_INT_CONTROLLER_UI_H
