///////////////////////////////////////////////////////////////////////////////
//
//  Copyright (2008) Alexander Stukowski
//
//  This file is part of OVITO (Open Visualization Tool).
//
//  OVITO is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  OVITO is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program.  If not, see <http://www.gnu.org/licenses/>.
//
///////////////////////////////////////////////////////////////////////////////

#include <scripting/Scripting.h>
#include <core/reference/RefMaker.h>
#include <core/reference/RefTarget.h>

namespace Scripting {

using namespace boost::python;

static intrusive_ptr<RefTarget> CreateRefTargetClone(RefTarget* target, bool deepCopy)
{
	CloneHelper cloneHelper;
	return cloneHelper.cloneObject(target, deepCopy);
}

class RefTargetWrapper : public RefTarget, public wrapper<RefTarget> {
public:
	RefTargetWrapper(bool isLoading) : RefTarget(isLoading) {}
	virtual QString schematicTitle() {
		if(override o = get_override("SchematicTitle")) return o();
		return RefTarget::schematicTitle();
	}
	virtual QString default_schematicTitle() { return RefTarget::schematicTitle(); }
};

void ExportReference()
{
	class_<RefMaker, bases<PluginClass>, noncopyable>("RefMaker", no_init)
	;

	class_<RefTargetWrapper, bases<RefMaker>, intrusive_ptr<RefTargetWrapper>, noncopyable>("RefTarget", no_init)
		.def("SchematicTitle", &RefTarget::schematicTitle, &RefTargetWrapper::default_schematicTitle)
		.def("Clone", &CreateRefTargetClone)
	;
}

};
