//=======================================================================
// pkgwindow.h
//-----------------------------------------------------------------------
// This file is part of the package paco
// Copyright (C) 2004-2009 David Rosal
// For more information visit http://paco.sourceforge.net
//=======================================================================

#ifndef GPACO_PKG_WINDOW_H
#define GPACO_PKG_WINDOW_H

#include <gtkmm/window.h>
#include <gtkmm/box.h>
#include <gtkmm/notebook.h>


namespace Gpaco
{

class Pkg;
class FilesTab;
class InfoTab;
class RemoveTab;
class PackageTab;

class PkgWindow : public Gtk::Window 
{
	public:

	PkgWindow(Pkg&);
	~PkgWindow();

	FilesTab* filesTab()	{ return mpFilesTab; }

	virtual bool on_delete_event(GdkEventAny*);
	void presentTab(int const&);

	private:

	Pkg&			mPkg;
	FilesTab*		mpFilesTab;
	InfoTab*		mpInfoTab;
	RemoveTab*		mpRemoveTab;
	PackageTab*		mpPackageTab;
	Gtk::Notebook	mNotebook;

	class TabLabel : public Gtk::HBox
	{
		public:
		TabLabel(Glib::ustring const& title, Gtk::StockID id);
		TabLabel(Glib::ustring const& title, Glib::ustring const& file);
		~TabLabel();
	};
};

} // namespace Gpaco


#endif  // GPACO_PKG_WINDOW_H
