/*
 *  Player - One Hell of a Robot Server
 *  Copyright (C) Andrew Howard 2003
 *
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
/***************************************************************************
 * Desc: Tests for the power device
 * Author: Andrew Howard
 * Date: 26 May 2002
 # CVS: $Id: test_power.c 8106 2009-07-23 19:14:37Z thjc $
 **************************************************************************/

#include "test.h"
#include "playerc.h"


// Basic test for power device.
int test_power(playerc_client_t *client, int index)
{
  int t;
  void *rdevice;
  playerc_power_t *device;

  printf("device [power] index [%d]\n", index);

  device = playerc_power_create(client, index);

  TEST("subscribing (read)");
  if (playerc_power_subscribe(device, PLAYER_OPEN_MODE) != 0)
  {
    FAIL();
    return -1;
  }
  PASS();

  for (t = 0; t < 3; t++)
  {
    TEST1("reading data (attempt %d)", t);

    do
      rdevice = playerc_client_read(client);
    while (rdevice == client);

    if (rdevice == device)
    {
      PASS();
      printf("power: [%6.1f] [%6.1f%% full]\n",
             device->charge, device->percent);
    }
    else
      FAIL();
  }
  
  TEST("unsubscribing");
  if (playerc_power_unsubscribe(device) != 0)
  {
    FAIL();
    return -1;
  }
  PASS();
  
  playerc_power_destroy(device);
  
  return 0;
}

