# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.service_client import SDKClient
from msrest import Configuration, Serializer, Deserializer
from .version import VERSION
from .operations.image_moderation_operations import ImageModerationOperations
from .operations.text_moderation_operations import TextModerationOperations
from .operations.list_management_image_lists_operations import ListManagementImageListsOperations
from .operations.list_management_term_lists_operations import ListManagementTermListsOperations
from .operations.list_management_image_operations import ListManagementImageOperations
from .operations.list_management_term_operations import ListManagementTermOperations
from .operations.reviews_operations import ReviewsOperations
from . import models


class ContentModeratorClientConfiguration(Configuration):
    """Configuration for ContentModeratorClient
    Note that all parameters used to create this instance are saved as instance
    attributes.

    :param endpoint: Supported Cognitive Services endpoints (protocol and
     hostname, for example: https://westus.api.cognitive.microsoft.com).
    :type endpoint: str
    :param credentials: Subscription credentials which uniquely identify
     client subscription.
    :type credentials: None
    """

    def __init__(
            self, endpoint, credentials):

        if endpoint is None:
            raise ValueError("Parameter 'endpoint' must not be None.")
        if credentials is None:
            raise ValueError("Parameter 'credentials' must not be None.")
        base_url = '{Endpoint}'

        super(ContentModeratorClientConfiguration, self).__init__(base_url)

        self.add_user_agent('azure-cognitiveservices-vision-contentmoderator/{}'.format(VERSION))

        self.endpoint = endpoint
        self.credentials = credentials


class ContentModeratorClient(SDKClient):
    """You use the API to scan your content as it is generated. Content Moderator then processes your content and sends the results along with relevant information either back to your systems or to the built-in review tool. You can use this information to take decisions e.g. take it down, send to human judge, etc.
    When using the API, images need to have a minimum of 128 pixels and a maximum file size of 4MB.
    Text can be at most 1024 characters long.
    If the content passed to the text API or the image API exceeds the size limits, the API will return an error code that informs about the issue.

    :ivar config: Configuration for client.
    :vartype config: ContentModeratorClientConfiguration

    :ivar image_moderation: ImageModeration operations
    :vartype image_moderation: azure.cognitiveservices.vision.contentmoderator.operations.ImageModerationOperations
    :ivar text_moderation: TextModeration operations
    :vartype text_moderation: azure.cognitiveservices.vision.contentmoderator.operations.TextModerationOperations
    :ivar list_management_image_lists: ListManagementImageLists operations
    :vartype list_management_image_lists: azure.cognitiveservices.vision.contentmoderator.operations.ListManagementImageListsOperations
    :ivar list_management_term_lists: ListManagementTermLists operations
    :vartype list_management_term_lists: azure.cognitiveservices.vision.contentmoderator.operations.ListManagementTermListsOperations
    :ivar list_management_image: ListManagementImage operations
    :vartype list_management_image: azure.cognitiveservices.vision.contentmoderator.operations.ListManagementImageOperations
    :ivar list_management_term: ListManagementTerm operations
    :vartype list_management_term: azure.cognitiveservices.vision.contentmoderator.operations.ListManagementTermOperations
    :ivar reviews: Reviews operations
    :vartype reviews: azure.cognitiveservices.vision.contentmoderator.operations.ReviewsOperations

    :param endpoint: Supported Cognitive Services endpoints (protocol and
     hostname, for example: https://westus.api.cognitive.microsoft.com).
    :type endpoint: str
    :param credentials: Subscription credentials which uniquely identify
     client subscription.
    :type credentials: None
    """

    def __init__(
            self, endpoint, credentials):

        self.config = ContentModeratorClientConfiguration(endpoint, credentials)
        super(ContentModeratorClient, self).__init__(self.config.credentials, self.config)

        client_models = {k: v for k, v in models.__dict__.items() if isinstance(v, type)}
        self.api_version = '1.0'
        self._serialize = Serializer(client_models)
        self._deserialize = Deserializer(client_models)

        self.image_moderation = ImageModerationOperations(
            self._client, self.config, self._serialize, self._deserialize)
        self.text_moderation = TextModerationOperations(
            self._client, self.config, self._serialize, self._deserialize)
        self.list_management_image_lists = ListManagementImageListsOperations(
            self._client, self.config, self._serialize, self._deserialize)
        self.list_management_term_lists = ListManagementTermListsOperations(
            self._client, self.config, self._serialize, self._deserialize)
        self.list_management_image = ListManagementImageOperations(
            self._client, self.config, self._serialize, self._deserialize)
        self.list_management_term = ListManagementTermOperations(
            self._client, self.config, self._serialize, self._deserialize)
        self.reviews = ReviewsOperations(
            self._client, self.config, self._serialize, self._deserialize)
