# coding=utf-8
# pylint: disable=too-many-lines
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import datetime
import sys
from typing import Any, Dict, List, Optional, TYPE_CHECKING, Union

from ... import _serialization

if sys.version_info >= (3, 9):
    from collections.abc import MutableMapping
else:
    from typing import MutableMapping  # type: ignore  # pylint: disable=ungrouped-imports

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    from .. import models as _models
JSON = MutableMapping[str, Any]  # pylint: disable=unsubscriptable-object


class EnvironmentData(_serialization.Model):
    """The security connector environment data.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    AwsEnvironmentData, AzureDevOpsScopeEnvironmentData, GcpProjectEnvironmentData,
    GithubScopeEnvironmentData, GitlabScopeEnvironmentData

    All required parameters must be populated in order to send to server.

    :ivar environment_type: The type of the environment data. Required. Known values are:
     "AwsAccount", "GcpProject", "GithubScope", "AzureDevOpsScope", and "GitlabScope".
    :vartype environment_type: str or
     ~azure.mgmt.security.v2023_10_01_preview.models.EnvironmentType
    """

    _validation = {
        "environment_type": {"required": True},
    }

    _attribute_map = {
        "environment_type": {"key": "environmentType", "type": "str"},
    }

    _subtype_map = {
        "environment_type": {
            "AwsAccount": "AwsEnvironmentData",
            "AzureDevOpsScope": "AzureDevOpsScopeEnvironmentData",
            "GcpProject": "GcpProjectEnvironmentData",
            "GithubScope": "GithubScopeEnvironmentData",
            "GitlabScope": "GitlabScopeEnvironmentData",
        }
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.environment_type: Optional[str] = None


class AwsEnvironmentData(EnvironmentData):
    """The AWS connector environment data.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar environment_type: The type of the environment data. Required. Known values are:
     "AwsAccount", "GcpProject", "GithubScope", "AzureDevOpsScope", and "GitlabScope".
    :vartype environment_type: str or
     ~azure.mgmt.security.v2023_10_01_preview.models.EnvironmentType
    :ivar organizational_data: The AWS account's organizational data.
    :vartype organizational_data:
     ~azure.mgmt.security.v2023_10_01_preview.models.AwsOrganizationalData
    :ivar regions: list of regions to scan.
    :vartype regions: list[str]
    :ivar account_name: The AWS account name.
    :vartype account_name: str
    :ivar scan_interval: Scan interval in hours (value should be between 1-hour to 24-hours).
    :vartype scan_interval: int
    """

    _validation = {
        "environment_type": {"required": True},
        "account_name": {"readonly": True},
    }

    _attribute_map = {
        "environment_type": {"key": "environmentType", "type": "str"},
        "organizational_data": {"key": "organizationalData", "type": "AwsOrganizationalData"},
        "regions": {"key": "regions", "type": "[str]"},
        "account_name": {"key": "accountName", "type": "str"},
        "scan_interval": {"key": "scanInterval", "type": "int"},
    }

    def __init__(
        self,
        *,
        organizational_data: Optional["_models.AwsOrganizationalData"] = None,
        regions: Optional[List[str]] = None,
        scan_interval: Optional[int] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword organizational_data: The AWS account's organizational data.
        :paramtype organizational_data:
         ~azure.mgmt.security.v2023_10_01_preview.models.AwsOrganizationalData
        :keyword regions: list of regions to scan.
        :paramtype regions: list[str]
        :keyword scan_interval: Scan interval in hours (value should be between 1-hour to 24-hours).
        :paramtype scan_interval: int
        """
        super().__init__(**kwargs)
        self.environment_type: str = "AwsAccount"
        self.organizational_data = organizational_data
        self.regions = regions
        self.account_name = None
        self.scan_interval = scan_interval


class AwsOrganizationalData(_serialization.Model):
    """The AWS organization data.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    AwsOrganizationalDataMember, AwsOrganizationalDataMaster

    All required parameters must be populated in order to send to server.

    :ivar organization_membership_type: The multi cloud account's membership type in the
     organization. Required. Known values are: "Member" and "Organization".
    :vartype organization_membership_type: str or
     ~azure.mgmt.security.v2023_10_01_preview.models.OrganizationMembershipType
    """

    _validation = {
        "organization_membership_type": {"required": True},
    }

    _attribute_map = {
        "organization_membership_type": {"key": "organizationMembershipType", "type": "str"},
    }

    _subtype_map = {
        "organization_membership_type": {
            "Member": "AwsOrganizationalDataMember",
            "Organization": "AwsOrganizationalDataMaster",
        }
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.organization_membership_type: Optional[str] = None


class AwsOrganizationalDataMaster(AwsOrganizationalData):
    """The AWS organization data for the master account.

    All required parameters must be populated in order to send to server.

    :ivar organization_membership_type: The multi cloud account's membership type in the
     organization. Required. Known values are: "Member" and "Organization".
    :vartype organization_membership_type: str or
     ~azure.mgmt.security.v2023_10_01_preview.models.OrganizationMembershipType
    :ivar stackset_name: If the multi cloud account is of membership type organization, this will
     be the name of the onboarding stackset.
    :vartype stackset_name: str
    :ivar excluded_account_ids: If the multi cloud account is of membership type organization, list
     of accounts excluded from offering.
    :vartype excluded_account_ids: list[str]
    """

    _validation = {
        "organization_membership_type": {"required": True},
    }

    _attribute_map = {
        "organization_membership_type": {"key": "organizationMembershipType", "type": "str"},
        "stackset_name": {"key": "stacksetName", "type": "str"},
        "excluded_account_ids": {"key": "excludedAccountIds", "type": "[str]"},
    }

    def __init__(
        self, *, stackset_name: Optional[str] = None, excluded_account_ids: Optional[List[str]] = None, **kwargs: Any
    ) -> None:
        """
        :keyword stackset_name: If the multi cloud account is of membership type organization, this
         will be the name of the onboarding stackset.
        :paramtype stackset_name: str
        :keyword excluded_account_ids: If the multi cloud account is of membership type organization,
         list of accounts excluded from offering.
        :paramtype excluded_account_ids: list[str]
        """
        super().__init__(**kwargs)
        self.organization_membership_type: str = "Organization"
        self.stackset_name = stackset_name
        self.excluded_account_ids = excluded_account_ids


class AwsOrganizationalDataMember(AwsOrganizationalData):
    """The AWS organization data for the member account.

    All required parameters must be populated in order to send to server.

    :ivar organization_membership_type: The multi cloud account's membership type in the
     organization. Required. Known values are: "Member" and "Organization".
    :vartype organization_membership_type: str or
     ~azure.mgmt.security.v2023_10_01_preview.models.OrganizationMembershipType
    :ivar parent_hierarchy_id: If the multi cloud account is not of membership type organization,
     this will be the ID of the account's parent.
    :vartype parent_hierarchy_id: str
    """

    _validation = {
        "organization_membership_type": {"required": True},
    }

    _attribute_map = {
        "organization_membership_type": {"key": "organizationMembershipType", "type": "str"},
        "parent_hierarchy_id": {"key": "parentHierarchyId", "type": "str"},
    }

    def __init__(self, *, parent_hierarchy_id: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword parent_hierarchy_id: If the multi cloud account is not of membership type
         organization, this will be the ID of the account's parent.
        :paramtype parent_hierarchy_id: str
        """
        super().__init__(**kwargs)
        self.organization_membership_type: str = "Member"
        self.parent_hierarchy_id = parent_hierarchy_id


class AzureDevOpsScopeEnvironmentData(EnvironmentData):
    """The AzureDevOps scope connector's environment data.

    All required parameters must be populated in order to send to server.

    :ivar environment_type: The type of the environment data. Required. Known values are:
     "AwsAccount", "GcpProject", "GithubScope", "AzureDevOpsScope", and "GitlabScope".
    :vartype environment_type: str or
     ~azure.mgmt.security.v2023_10_01_preview.models.EnvironmentType
    """

    _validation = {
        "environment_type": {"required": True},
    }

    _attribute_map = {
        "environment_type": {"key": "environmentType", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.environment_type: str = "AzureDevOpsScope"


class AzureTrackedResourceLocation(_serialization.Model):
    """Describes an Azure resource with location.

    :ivar location: Location where the resource is stored.
    :vartype location: str
    """

    _attribute_map = {
        "location": {"key": "location", "type": "str"},
    }

    def __init__(self, *, location: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword location: Location where the resource is stored.
        :paramtype location: str
        """
        super().__init__(**kwargs)
        self.location = location


class CloudErrorBody(_serialization.Model):
    """The error detail.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: The error code.
    :vartype code: str
    :ivar message: The error message.
    :vartype message: str
    :ivar target: The error target.
    :vartype target: str
    :ivar details: The error details.
    :vartype details: list[~azure.mgmt.security.v2023_10_01_preview.models.CloudErrorBody]
    :ivar additional_info: The error additional info.
    :vartype additional_info:
     list[~azure.mgmt.security.v2023_10_01_preview.models.ErrorAdditionalInfo]
    """

    _validation = {
        "code": {"readonly": True},
        "message": {"readonly": True},
        "target": {"readonly": True},
        "details": {"readonly": True},
        "additional_info": {"readonly": True},
    }

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "message": {"key": "message", "type": "str"},
        "target": {"key": "target", "type": "str"},
        "details": {"key": "details", "type": "[CloudErrorBody]"},
        "additional_info": {"key": "additionalInfo", "type": "[ErrorAdditionalInfo]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.code = None
        self.message = None
        self.target = None
        self.details = None
        self.additional_info = None


class CloudOffering(_serialization.Model):
    """The security offering details.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    CspmMonitorAwsOffering, CspmMonitorAzureDevOpsOffering, CspmMonitorGcpOffering,
    CspmMonitorGitLabOffering, CspmMonitorGithubOffering, DefenderCspmAwsOffering,
    DefenderCspmGcpOffering, DefenderForContainersAwsOffering, DefenderForContainersGcpOffering,
    DefenderFoDatabasesAwsOffering, DefenderForDatabasesGcpOffering,
    DefenderForDevOpsAzureDevOpsOffering, DefenderForDevOpsGitLabOffering,
    DefenderForDevOpsGithubOffering, DefenderForServersAwsOffering, DefenderForServersGcpOffering,
    InformationProtectionAwsOffering

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar offering_type: The type of the security offering. Required. Known values are:
     "CspmMonitorAws", "DefenderForContainersAws", "DefenderForServersAws",
     "DefenderForDatabasesAws", "InformationProtectionAws", "CspmMonitorGcp", "CspmMonitorGithub",
     "CspmMonitorAzureDevOps", "DefenderForServersGcp", "DefenderForContainersGcp",
     "DefenderForDatabasesGcp", "DefenderCspmAws", "DefenderCspmGcp", "DefenderForDevOpsGithub",
     "DefenderForDevOpsAzureDevOps", "CspmMonitorGitLab", and "DefenderForDevOpsGitLab".
    :vartype offering_type: str or ~azure.mgmt.security.v2023_10_01_preview.models.OfferingType
    :ivar description: The offering description.
    :vartype description: str
    """

    _validation = {
        "offering_type": {"required": True},
        "description": {"readonly": True},
    }

    _attribute_map = {
        "offering_type": {"key": "offeringType", "type": "str"},
        "description": {"key": "description", "type": "str"},
    }

    _subtype_map = {
        "offering_type": {
            "CspmMonitorAws": "CspmMonitorAwsOffering",
            "CspmMonitorAzureDevOps": "CspmMonitorAzureDevOpsOffering",
            "CspmMonitorGcp": "CspmMonitorGcpOffering",
            "CspmMonitorGitLab": "CspmMonitorGitLabOffering",
            "CspmMonitorGithub": "CspmMonitorGithubOffering",
            "DefenderCspmAws": "DefenderCspmAwsOffering",
            "DefenderCspmGcp": "DefenderCspmGcpOffering",
            "DefenderForContainersAws": "DefenderForContainersAwsOffering",
            "DefenderForContainersGcp": "DefenderForContainersGcpOffering",
            "DefenderForDatabasesAws": "DefenderFoDatabasesAwsOffering",
            "DefenderForDatabasesGcp": "DefenderForDatabasesGcpOffering",
            "DefenderForDevOpsAzureDevOps": "DefenderForDevOpsAzureDevOpsOffering",
            "DefenderForDevOpsGitLab": "DefenderForDevOpsGitLabOffering",
            "DefenderForDevOpsGithub": "DefenderForDevOpsGithubOffering",
            "DefenderForServersAws": "DefenderForServersAwsOffering",
            "DefenderForServersGcp": "DefenderForServersGcpOffering",
            "InformationProtectionAws": "InformationProtectionAwsOffering",
        }
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.offering_type: Optional[str] = None
        self.description = None


class CspmMonitorAwsOffering(CloudOffering):
    """The CSPM monitoring for AWS offering.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar offering_type: The type of the security offering. Required. Known values are:
     "CspmMonitorAws", "DefenderForContainersAws", "DefenderForServersAws",
     "DefenderForDatabasesAws", "InformationProtectionAws", "CspmMonitorGcp", "CspmMonitorGithub",
     "CspmMonitorAzureDevOps", "DefenderForServersGcp", "DefenderForContainersGcp",
     "DefenderForDatabasesGcp", "DefenderCspmAws", "DefenderCspmGcp", "DefenderForDevOpsGithub",
     "DefenderForDevOpsAzureDevOps", "CspmMonitorGitLab", and "DefenderForDevOpsGitLab".
    :vartype offering_type: str or ~azure.mgmt.security.v2023_10_01_preview.models.OfferingType
    :ivar description: The offering description.
    :vartype description: str
    :ivar native_cloud_connection: The native cloud connection configuration.
    :vartype native_cloud_connection:
     ~azure.mgmt.security.v2023_10_01_preview.models.CspmMonitorAwsOfferingNativeCloudConnection
    """

    _validation = {
        "offering_type": {"required": True},
        "description": {"readonly": True},
    }

    _attribute_map = {
        "offering_type": {"key": "offeringType", "type": "str"},
        "description": {"key": "description", "type": "str"},
        "native_cloud_connection": {
            "key": "nativeCloudConnection",
            "type": "CspmMonitorAwsOfferingNativeCloudConnection",
        },
    }

    def __init__(
        self,
        *,
        native_cloud_connection: Optional["_models.CspmMonitorAwsOfferingNativeCloudConnection"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword native_cloud_connection: The native cloud connection configuration.
        :paramtype native_cloud_connection:
         ~azure.mgmt.security.v2023_10_01_preview.models.CspmMonitorAwsOfferingNativeCloudConnection
        """
        super().__init__(**kwargs)
        self.offering_type: str = "CspmMonitorAws"
        self.native_cloud_connection = native_cloud_connection


class CspmMonitorAwsOfferingNativeCloudConnection(_serialization.Model):  # pylint: disable=name-too-long
    """The native cloud connection configuration.

    :ivar cloud_role_arn: The cloud role ARN in AWS for this feature.
    :vartype cloud_role_arn: str
    """

    _attribute_map = {
        "cloud_role_arn": {"key": "cloudRoleArn", "type": "str"},
    }

    def __init__(self, *, cloud_role_arn: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword cloud_role_arn: The cloud role ARN in AWS for this feature.
        :paramtype cloud_role_arn: str
        """
        super().__init__(**kwargs)
        self.cloud_role_arn = cloud_role_arn


class CspmMonitorAzureDevOpsOffering(CloudOffering):
    """The CSPM monitoring for AzureDevOps offering.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar offering_type: The type of the security offering. Required. Known values are:
     "CspmMonitorAws", "DefenderForContainersAws", "DefenderForServersAws",
     "DefenderForDatabasesAws", "InformationProtectionAws", "CspmMonitorGcp", "CspmMonitorGithub",
     "CspmMonitorAzureDevOps", "DefenderForServersGcp", "DefenderForContainersGcp",
     "DefenderForDatabasesGcp", "DefenderCspmAws", "DefenderCspmGcp", "DefenderForDevOpsGithub",
     "DefenderForDevOpsAzureDevOps", "CspmMonitorGitLab", and "DefenderForDevOpsGitLab".
    :vartype offering_type: str or ~azure.mgmt.security.v2023_10_01_preview.models.OfferingType
    :ivar description: The offering description.
    :vartype description: str
    """

    _validation = {
        "offering_type": {"required": True},
        "description": {"readonly": True},
    }

    _attribute_map = {
        "offering_type": {"key": "offeringType", "type": "str"},
        "description": {"key": "description", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.offering_type: str = "CspmMonitorAzureDevOps"


class CspmMonitorGcpOffering(CloudOffering):
    """The CSPM monitoring for GCP offering.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar offering_type: The type of the security offering. Required. Known values are:
     "CspmMonitorAws", "DefenderForContainersAws", "DefenderForServersAws",
     "DefenderForDatabasesAws", "InformationProtectionAws", "CspmMonitorGcp", "CspmMonitorGithub",
     "CspmMonitorAzureDevOps", "DefenderForServersGcp", "DefenderForContainersGcp",
     "DefenderForDatabasesGcp", "DefenderCspmAws", "DefenderCspmGcp", "DefenderForDevOpsGithub",
     "DefenderForDevOpsAzureDevOps", "CspmMonitorGitLab", and "DefenderForDevOpsGitLab".
    :vartype offering_type: str or ~azure.mgmt.security.v2023_10_01_preview.models.OfferingType
    :ivar description: The offering description.
    :vartype description: str
    :ivar native_cloud_connection: The native cloud connection configuration.
    :vartype native_cloud_connection:
     ~azure.mgmt.security.v2023_10_01_preview.models.CspmMonitorGcpOfferingNativeCloudConnection
    """

    _validation = {
        "offering_type": {"required": True},
        "description": {"readonly": True},
    }

    _attribute_map = {
        "offering_type": {"key": "offeringType", "type": "str"},
        "description": {"key": "description", "type": "str"},
        "native_cloud_connection": {
            "key": "nativeCloudConnection",
            "type": "CspmMonitorGcpOfferingNativeCloudConnection",
        },
    }

    def __init__(
        self,
        *,
        native_cloud_connection: Optional["_models.CspmMonitorGcpOfferingNativeCloudConnection"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword native_cloud_connection: The native cloud connection configuration.
        :paramtype native_cloud_connection:
         ~azure.mgmt.security.v2023_10_01_preview.models.CspmMonitorGcpOfferingNativeCloudConnection
        """
        super().__init__(**kwargs)
        self.offering_type: str = "CspmMonitorGcp"
        self.native_cloud_connection = native_cloud_connection


class CspmMonitorGcpOfferingNativeCloudConnection(_serialization.Model):  # pylint: disable=name-too-long
    """The native cloud connection configuration.

    :ivar workload_identity_provider_id: The GCP workload identity provider id for the offering.
    :vartype workload_identity_provider_id: str
    :ivar service_account_email_address: The service account email address in GCP for this
     offering.
    :vartype service_account_email_address: str
    """

    _attribute_map = {
        "workload_identity_provider_id": {"key": "workloadIdentityProviderId", "type": "str"},
        "service_account_email_address": {"key": "serviceAccountEmailAddress", "type": "str"},
    }

    def __init__(
        self,
        *,
        workload_identity_provider_id: Optional[str] = None,
        service_account_email_address: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword workload_identity_provider_id: The GCP workload identity provider id for the offering.
        :paramtype workload_identity_provider_id: str
        :keyword service_account_email_address: The service account email address in GCP for this
         offering.
        :paramtype service_account_email_address: str
        """
        super().__init__(**kwargs)
        self.workload_identity_provider_id = workload_identity_provider_id
        self.service_account_email_address = service_account_email_address


class CspmMonitorGithubOffering(CloudOffering):
    """The CSPM monitoring for github offering.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar offering_type: The type of the security offering. Required. Known values are:
     "CspmMonitorAws", "DefenderForContainersAws", "DefenderForServersAws",
     "DefenderForDatabasesAws", "InformationProtectionAws", "CspmMonitorGcp", "CspmMonitorGithub",
     "CspmMonitorAzureDevOps", "DefenderForServersGcp", "DefenderForContainersGcp",
     "DefenderForDatabasesGcp", "DefenderCspmAws", "DefenderCspmGcp", "DefenderForDevOpsGithub",
     "DefenderForDevOpsAzureDevOps", "CspmMonitorGitLab", and "DefenderForDevOpsGitLab".
    :vartype offering_type: str or ~azure.mgmt.security.v2023_10_01_preview.models.OfferingType
    :ivar description: The offering description.
    :vartype description: str
    """

    _validation = {
        "offering_type": {"required": True},
        "description": {"readonly": True},
    }

    _attribute_map = {
        "offering_type": {"key": "offeringType", "type": "str"},
        "description": {"key": "description", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.offering_type: str = "CspmMonitorGithub"


class CspmMonitorGitLabOffering(CloudOffering):
    """The CSPM (Cloud security posture management) monitoring for gitlab offering.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar offering_type: The type of the security offering. Required. Known values are:
     "CspmMonitorAws", "DefenderForContainersAws", "DefenderForServersAws",
     "DefenderForDatabasesAws", "InformationProtectionAws", "CspmMonitorGcp", "CspmMonitorGithub",
     "CspmMonitorAzureDevOps", "DefenderForServersGcp", "DefenderForContainersGcp",
     "DefenderForDatabasesGcp", "DefenderCspmAws", "DefenderCspmGcp", "DefenderForDevOpsGithub",
     "DefenderForDevOpsAzureDevOps", "CspmMonitorGitLab", and "DefenderForDevOpsGitLab".
    :vartype offering_type: str or ~azure.mgmt.security.v2023_10_01_preview.models.OfferingType
    :ivar description: The offering description.
    :vartype description: str
    """

    _validation = {
        "offering_type": {"required": True},
        "description": {"readonly": True},
    }

    _attribute_map = {
        "offering_type": {"key": "offeringType", "type": "str"},
        "description": {"key": "description", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.offering_type: str = "CspmMonitorGitLab"


class DefenderCspmAwsOffering(CloudOffering):
    """The CSPM P1 for AWS offering.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar offering_type: The type of the security offering. Required. Known values are:
     "CspmMonitorAws", "DefenderForContainersAws", "DefenderForServersAws",
     "DefenderForDatabasesAws", "InformationProtectionAws", "CspmMonitorGcp", "CspmMonitorGithub",
     "CspmMonitorAzureDevOps", "DefenderForServersGcp", "DefenderForContainersGcp",
     "DefenderForDatabasesGcp", "DefenderCspmAws", "DefenderCspmGcp", "DefenderForDevOpsGithub",
     "DefenderForDevOpsAzureDevOps", "CspmMonitorGitLab", and "DefenderForDevOpsGitLab".
    :vartype offering_type: str or ~azure.mgmt.security.v2023_10_01_preview.models.OfferingType
    :ivar description: The offering description.
    :vartype description: str
    :ivar vm_scanners: The Microsoft Defender for Server VM scanning configuration.
    :vartype vm_scanners:
     ~azure.mgmt.security.v2023_10_01_preview.models.DefenderCspmAwsOfferingVmScanners
    :ivar data_sensitivity_discovery: The Microsoft Defender Data Sensitivity discovery
     configuration.
    :vartype data_sensitivity_discovery:
     ~azure.mgmt.security.v2023_10_01_preview.models.DefenderCspmAwsOfferingDataSensitivityDiscovery
    :ivar databases_dspm: The databases DSPM configuration.
    :vartype databases_dspm:
     ~azure.mgmt.security.v2023_10_01_preview.models.DefenderCspmAwsOfferingDatabasesDspm
    :ivar ciem: Defenders CSPM Cloud infrastructure entitlement management (CIEM) offering
     configurations.
    :vartype ciem: ~azure.mgmt.security.v2023_10_01_preview.models.DefenderCspmAwsOfferingCiem
    :ivar mdc_containers_image_assessment: The Microsoft Defender container image assessment
     configuration.
    :vartype mdc_containers_image_assessment:
     ~azure.mgmt.security.v2023_10_01_preview.models.DefenderCspmAwsOfferingMdcContainersImageAssessment
    :ivar mdc_containers_agentless_discovery_k8_s: The Microsoft Defender container agentless
     discovery K8s configuration.
    :vartype mdc_containers_agentless_discovery_k8_s:
     ~azure.mgmt.security.v2023_10_01_preview.models.DefenderCspmAwsOfferingMdcContainersAgentlessDiscoveryK8S
    """

    _validation = {
        "offering_type": {"required": True},
        "description": {"readonly": True},
    }

    _attribute_map = {
        "offering_type": {"key": "offeringType", "type": "str"},
        "description": {"key": "description", "type": "str"},
        "vm_scanners": {"key": "vmScanners", "type": "DefenderCspmAwsOfferingVmScanners"},
        "data_sensitivity_discovery": {
            "key": "dataSensitivityDiscovery",
            "type": "DefenderCspmAwsOfferingDataSensitivityDiscovery",
        },
        "databases_dspm": {"key": "databasesDspm", "type": "DefenderCspmAwsOfferingDatabasesDspm"},
        "ciem": {"key": "ciem", "type": "DefenderCspmAwsOfferingCiem"},
        "mdc_containers_image_assessment": {
            "key": "mdcContainersImageAssessment",
            "type": "DefenderCspmAwsOfferingMdcContainersImageAssessment",
        },
        "mdc_containers_agentless_discovery_k8_s": {
            "key": "mdcContainersAgentlessDiscoveryK8s",
            "type": "DefenderCspmAwsOfferingMdcContainersAgentlessDiscoveryK8S",
        },
    }

    def __init__(
        self,
        *,
        vm_scanners: Optional["_models.DefenderCspmAwsOfferingVmScanners"] = None,
        data_sensitivity_discovery: Optional["_models.DefenderCspmAwsOfferingDataSensitivityDiscovery"] = None,
        databases_dspm: Optional["_models.DefenderCspmAwsOfferingDatabasesDspm"] = None,
        ciem: Optional["_models.DefenderCspmAwsOfferingCiem"] = None,
        mdc_containers_image_assessment: Optional["_models.DefenderCspmAwsOfferingMdcContainersImageAssessment"] = None,
        mdc_containers_agentless_discovery_k8_s: Optional[
            "_models.DefenderCspmAwsOfferingMdcContainersAgentlessDiscoveryK8S"
        ] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword vm_scanners: The Microsoft Defender for Server VM scanning configuration.
        :paramtype vm_scanners:
         ~azure.mgmt.security.v2023_10_01_preview.models.DefenderCspmAwsOfferingVmScanners
        :keyword data_sensitivity_discovery: The Microsoft Defender Data Sensitivity discovery
         configuration.
        :paramtype data_sensitivity_discovery:
         ~azure.mgmt.security.v2023_10_01_preview.models.DefenderCspmAwsOfferingDataSensitivityDiscovery
        :keyword databases_dspm: The databases DSPM configuration.
        :paramtype databases_dspm:
         ~azure.mgmt.security.v2023_10_01_preview.models.DefenderCspmAwsOfferingDatabasesDspm
        :keyword ciem: Defenders CSPM Cloud infrastructure entitlement management (CIEM) offering
         configurations.
        :paramtype ciem: ~azure.mgmt.security.v2023_10_01_preview.models.DefenderCspmAwsOfferingCiem
        :keyword mdc_containers_image_assessment: The Microsoft Defender container image assessment
         configuration.
        :paramtype mdc_containers_image_assessment:
         ~azure.mgmt.security.v2023_10_01_preview.models.DefenderCspmAwsOfferingMdcContainersImageAssessment
        :keyword mdc_containers_agentless_discovery_k8_s: The Microsoft Defender container agentless
         discovery K8s configuration.
        :paramtype mdc_containers_agentless_discovery_k8_s:
         ~azure.mgmt.security.v2023_10_01_preview.models.DefenderCspmAwsOfferingMdcContainersAgentlessDiscoveryK8S
        """
        super().__init__(**kwargs)
        self.offering_type: str = "DefenderCspmAws"
        self.vm_scanners = vm_scanners
        self.data_sensitivity_discovery = data_sensitivity_discovery
        self.databases_dspm = databases_dspm
        self.ciem = ciem
        self.mdc_containers_image_assessment = mdc_containers_image_assessment
        self.mdc_containers_agentless_discovery_k8_s = mdc_containers_agentless_discovery_k8_s


class DefenderCspmAwsOfferingCiem(_serialization.Model):
    """Defenders CSPM Cloud infrastructure entitlement management (CIEM) offering configurations.

    :ivar ciem_discovery: Defender CSPM CIEM discovery configuration.
    :vartype ciem_discovery:
     ~azure.mgmt.security.v2023_10_01_preview.models.DefenderCspmAwsOfferingCiemDiscovery
    :ivar ciem_oidc: Defender CSPM CIEM AWS OIDC (open id connect) configuration.
    :vartype ciem_oidc:
     ~azure.mgmt.security.v2023_10_01_preview.models.DefenderCspmAwsOfferingCiemOidc
    """

    _attribute_map = {
        "ciem_discovery": {"key": "ciemDiscovery", "type": "DefenderCspmAwsOfferingCiemDiscovery"},
        "ciem_oidc": {"key": "ciemOidc", "type": "DefenderCspmAwsOfferingCiemOidc"},
    }

    def __init__(
        self,
        *,
        ciem_discovery: Optional["_models.DefenderCspmAwsOfferingCiemDiscovery"] = None,
        ciem_oidc: Optional["_models.DefenderCspmAwsOfferingCiemOidc"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword ciem_discovery: Defender CSPM CIEM discovery configuration.
        :paramtype ciem_discovery:
         ~azure.mgmt.security.v2023_10_01_preview.models.DefenderCspmAwsOfferingCiemDiscovery
        :keyword ciem_oidc: Defender CSPM CIEM AWS OIDC (open id connect) configuration.
        :paramtype ciem_oidc:
         ~azure.mgmt.security.v2023_10_01_preview.models.DefenderCspmAwsOfferingCiemOidc
        """
        super().__init__(**kwargs)
        self.ciem_discovery = ciem_discovery
        self.ciem_oidc = ciem_oidc


class DefenderCspmAwsOfferingCiemDiscovery(_serialization.Model):
    """Defender CSPM CIEM discovery configuration.

    :ivar cloud_role_arn: The cloud role ARN in AWS for CIEM discovery.
    :vartype cloud_role_arn: str
    """

    _attribute_map = {
        "cloud_role_arn": {"key": "cloudRoleArn", "type": "str"},
    }

    def __init__(self, *, cloud_role_arn: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword cloud_role_arn: The cloud role ARN in AWS for CIEM discovery.
        :paramtype cloud_role_arn: str
        """
        super().__init__(**kwargs)
        self.cloud_role_arn = cloud_role_arn


class DefenderCspmAwsOfferingCiemOidc(_serialization.Model):
    """Defender CSPM CIEM AWS OIDC (open id connect) configuration.

    :ivar cloud_role_arn: The cloud role ARN in AWS for CIEM oidc connection.
    :vartype cloud_role_arn: str
    :ivar azure_active_directory_app_name: the azure active directory app name used of
     authenticating against AWS.
    :vartype azure_active_directory_app_name: str
    """

    _attribute_map = {
        "cloud_role_arn": {"key": "cloudRoleArn", "type": "str"},
        "azure_active_directory_app_name": {"key": "azureActiveDirectoryAppName", "type": "str"},
    }

    def __init__(
        self,
        *,
        cloud_role_arn: Optional[str] = None,
        azure_active_directory_app_name: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword cloud_role_arn: The cloud role ARN in AWS for CIEM oidc connection.
        :paramtype cloud_role_arn: str
        :keyword azure_active_directory_app_name: the azure active directory app name used of
         authenticating against AWS.
        :paramtype azure_active_directory_app_name: str
        """
        super().__init__(**kwargs)
        self.cloud_role_arn = cloud_role_arn
        self.azure_active_directory_app_name = azure_active_directory_app_name


class DefenderCspmAwsOfferingDatabasesDspm(_serialization.Model):
    """The databases DSPM configuration.

    :ivar enabled: Is databases DSPM protection enabled.
    :vartype enabled: bool
    :ivar cloud_role_arn: The cloud role ARN in AWS for this feature.
    :vartype cloud_role_arn: str
    """

    _attribute_map = {
        "enabled": {"key": "enabled", "type": "bool"},
        "cloud_role_arn": {"key": "cloudRoleArn", "type": "str"},
    }

    def __init__(self, *, enabled: Optional[bool] = None, cloud_role_arn: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword enabled: Is databases DSPM protection enabled.
        :paramtype enabled: bool
        :keyword cloud_role_arn: The cloud role ARN in AWS for this feature.
        :paramtype cloud_role_arn: str
        """
        super().__init__(**kwargs)
        self.enabled = enabled
        self.cloud_role_arn = cloud_role_arn


class DefenderCspmAwsOfferingDataSensitivityDiscovery(_serialization.Model):  # pylint: disable=name-too-long
    """The Microsoft Defender Data Sensitivity discovery configuration.

    :ivar enabled: Is Microsoft Defender Data Sensitivity discovery enabled.
    :vartype enabled: bool
    :ivar cloud_role_arn: The cloud role ARN in AWS for this feature.
    :vartype cloud_role_arn: str
    """

    _attribute_map = {
        "enabled": {"key": "enabled", "type": "bool"},
        "cloud_role_arn": {"key": "cloudRoleArn", "type": "str"},
    }

    def __init__(self, *, enabled: Optional[bool] = None, cloud_role_arn: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword enabled: Is Microsoft Defender Data Sensitivity discovery enabled.
        :paramtype enabled: bool
        :keyword cloud_role_arn: The cloud role ARN in AWS for this feature.
        :paramtype cloud_role_arn: str
        """
        super().__init__(**kwargs)
        self.enabled = enabled
        self.cloud_role_arn = cloud_role_arn


class DefenderCspmAwsOfferingMdcContainersAgentlessDiscoveryK8S(_serialization.Model):  # pylint: disable=name-too-long
    """The Microsoft Defender container agentless discovery K8s configuration.

    :ivar enabled: Is Microsoft Defender container agentless discovery K8s enabled.
    :vartype enabled: bool
    :ivar cloud_role_arn: The cloud role ARN in AWS for this feature.
    :vartype cloud_role_arn: str
    """

    _attribute_map = {
        "enabled": {"key": "enabled", "type": "bool"},
        "cloud_role_arn": {"key": "cloudRoleArn", "type": "str"},
    }

    def __init__(self, *, enabled: Optional[bool] = None, cloud_role_arn: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword enabled: Is Microsoft Defender container agentless discovery K8s enabled.
        :paramtype enabled: bool
        :keyword cloud_role_arn: The cloud role ARN in AWS for this feature.
        :paramtype cloud_role_arn: str
        """
        super().__init__(**kwargs)
        self.enabled = enabled
        self.cloud_role_arn = cloud_role_arn


class DefenderCspmAwsOfferingMdcContainersImageAssessment(_serialization.Model):  # pylint: disable=name-too-long
    """The Microsoft Defender container image assessment configuration.

    :ivar enabled: Is Microsoft Defender container image assessment enabled.
    :vartype enabled: bool
    :ivar cloud_role_arn: The cloud role ARN in AWS for this feature.
    :vartype cloud_role_arn: str
    """

    _attribute_map = {
        "enabled": {"key": "enabled", "type": "bool"},
        "cloud_role_arn": {"key": "cloudRoleArn", "type": "str"},
    }

    def __init__(self, *, enabled: Optional[bool] = None, cloud_role_arn: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword enabled: Is Microsoft Defender container image assessment enabled.
        :paramtype enabled: bool
        :keyword cloud_role_arn: The cloud role ARN in AWS for this feature.
        :paramtype cloud_role_arn: str
        """
        super().__init__(**kwargs)
        self.enabled = enabled
        self.cloud_role_arn = cloud_role_arn


class DefenderCspmAwsOfferingVmScanners(_serialization.Model):
    """The Microsoft Defender for Server VM scanning configuration.

    :ivar enabled: Is Microsoft Defender for Server VM scanning enabled.
    :vartype enabled: bool
    :ivar configuration: configuration for Microsoft Defender for Server VM scanning.
    :vartype configuration:
     ~azure.mgmt.security.v2023_10_01_preview.models.DefenderCspmAwsOfferingVmScannersConfiguration
    """

    _attribute_map = {
        "enabled": {"key": "enabled", "type": "bool"},
        "configuration": {"key": "configuration", "type": "DefenderCspmAwsOfferingVmScannersConfiguration"},
    }

    def __init__(
        self,
        *,
        enabled: Optional[bool] = None,
        configuration: Optional["_models.DefenderCspmAwsOfferingVmScannersConfiguration"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword enabled: Is Microsoft Defender for Server VM scanning enabled.
        :paramtype enabled: bool
        :keyword configuration: configuration for Microsoft Defender for Server VM scanning.
        :paramtype configuration:
         ~azure.mgmt.security.v2023_10_01_preview.models.DefenderCspmAwsOfferingVmScannersConfiguration
        """
        super().__init__(**kwargs)
        self.enabled = enabled
        self.configuration = configuration


class DefenderCspmAwsOfferingVmScannersConfiguration(_serialization.Model):  # pylint: disable=name-too-long
    """configuration for Microsoft Defender for Server VM scanning.

    :ivar cloud_role_arn: The cloud role ARN in AWS for this feature.
    :vartype cloud_role_arn: str
    :ivar scanning_mode: The scanning mode for the VM scan. "Default"
    :vartype scanning_mode: str or ~azure.mgmt.security.v2023_10_01_preview.models.ScanningMode
    :ivar exclusion_tags: VM tags that indicates that VM should not be scanned.
    :vartype exclusion_tags: dict[str, str]
    """

    _attribute_map = {
        "cloud_role_arn": {"key": "cloudRoleArn", "type": "str"},
        "scanning_mode": {"key": "scanningMode", "type": "str"},
        "exclusion_tags": {"key": "exclusionTags", "type": "{str}"},
    }

    def __init__(
        self,
        *,
        cloud_role_arn: Optional[str] = None,
        scanning_mode: Optional[Union[str, "_models.ScanningMode"]] = None,
        exclusion_tags: Optional[Dict[str, str]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword cloud_role_arn: The cloud role ARN in AWS for this feature.
        :paramtype cloud_role_arn: str
        :keyword scanning_mode: The scanning mode for the VM scan. "Default"
        :paramtype scanning_mode: str or ~azure.mgmt.security.v2023_10_01_preview.models.ScanningMode
        :keyword exclusion_tags: VM tags that indicates that VM should not be scanned.
        :paramtype exclusion_tags: dict[str, str]
        """
        super().__init__(**kwargs)
        self.cloud_role_arn = cloud_role_arn
        self.scanning_mode = scanning_mode
        self.exclusion_tags = exclusion_tags


class DefenderCspmGcpOffering(CloudOffering):
    """The CSPM P1 for GCP offering.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar offering_type: The type of the security offering. Required. Known values are:
     "CspmMonitorAws", "DefenderForContainersAws", "DefenderForServersAws",
     "DefenderForDatabasesAws", "InformationProtectionAws", "CspmMonitorGcp", "CspmMonitorGithub",
     "CspmMonitorAzureDevOps", "DefenderForServersGcp", "DefenderForContainersGcp",
     "DefenderForDatabasesGcp", "DefenderCspmAws", "DefenderCspmGcp", "DefenderForDevOpsGithub",
     "DefenderForDevOpsAzureDevOps", "CspmMonitorGitLab", and "DefenderForDevOpsGitLab".
    :vartype offering_type: str or ~azure.mgmt.security.v2023_10_01_preview.models.OfferingType
    :ivar description: The offering description.
    :vartype description: str
    :ivar ciem_discovery: GCP Defenders CSPM Cloud infrastructure entitlement management (CIEM)
     discovery offering configurations.
    :vartype ciem_discovery:
     ~azure.mgmt.security.v2023_10_01_preview.models.DefenderCspmGcpOfferingCiemDiscovery
    :ivar vm_scanners: The Microsoft Defender for Server VM scanning configuration.
    :vartype vm_scanners:
     ~azure.mgmt.security.v2023_10_01_preview.models.DefenderCspmGcpOfferingVmScanners
    :ivar data_sensitivity_discovery: The Microsoft Defender Data Sensitivity discovery
     configuration.
    :vartype data_sensitivity_discovery:
     ~azure.mgmt.security.v2023_10_01_preview.models.DefenderCspmGcpOfferingDataSensitivityDiscovery
    :ivar mdc_containers_image_assessment: The Microsoft Defender Container image assessment
     configuration.
    :vartype mdc_containers_image_assessment:
     ~azure.mgmt.security.v2023_10_01_preview.models.DefenderCspmGcpOfferingMdcContainersImageAssessment
    :ivar mdc_containers_agentless_discovery_k8_s: The Microsoft Defender Container agentless
     discovery configuration.
    :vartype mdc_containers_agentless_discovery_k8_s:
     ~azure.mgmt.security.v2023_10_01_preview.models.DefenderCspmGcpOfferingMdcContainersAgentlessDiscoveryK8S
    """

    _validation = {
        "offering_type": {"required": True},
        "description": {"readonly": True},
    }

    _attribute_map = {
        "offering_type": {"key": "offeringType", "type": "str"},
        "description": {"key": "description", "type": "str"},
        "ciem_discovery": {"key": "ciemDiscovery", "type": "DefenderCspmGcpOfferingCiemDiscovery"},
        "vm_scanners": {"key": "vmScanners", "type": "DefenderCspmGcpOfferingVmScanners"},
        "data_sensitivity_discovery": {
            "key": "dataSensitivityDiscovery",
            "type": "DefenderCspmGcpOfferingDataSensitivityDiscovery",
        },
        "mdc_containers_image_assessment": {
            "key": "mdcContainersImageAssessment",
            "type": "DefenderCspmGcpOfferingMdcContainersImageAssessment",
        },
        "mdc_containers_agentless_discovery_k8_s": {
            "key": "mdcContainersAgentlessDiscoveryK8s",
            "type": "DefenderCspmGcpOfferingMdcContainersAgentlessDiscoveryK8S",
        },
    }

    def __init__(
        self,
        *,
        ciem_discovery: Optional["_models.DefenderCspmGcpOfferingCiemDiscovery"] = None,
        vm_scanners: Optional["_models.DefenderCspmGcpOfferingVmScanners"] = None,
        data_sensitivity_discovery: Optional["_models.DefenderCspmGcpOfferingDataSensitivityDiscovery"] = None,
        mdc_containers_image_assessment: Optional["_models.DefenderCspmGcpOfferingMdcContainersImageAssessment"] = None,
        mdc_containers_agentless_discovery_k8_s: Optional[
            "_models.DefenderCspmGcpOfferingMdcContainersAgentlessDiscoveryK8S"
        ] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword ciem_discovery: GCP Defenders CSPM Cloud infrastructure entitlement management (CIEM)
         discovery offering configurations.
        :paramtype ciem_discovery:
         ~azure.mgmt.security.v2023_10_01_preview.models.DefenderCspmGcpOfferingCiemDiscovery
        :keyword vm_scanners: The Microsoft Defender for Server VM scanning configuration.
        :paramtype vm_scanners:
         ~azure.mgmt.security.v2023_10_01_preview.models.DefenderCspmGcpOfferingVmScanners
        :keyword data_sensitivity_discovery: The Microsoft Defender Data Sensitivity discovery
         configuration.
        :paramtype data_sensitivity_discovery:
         ~azure.mgmt.security.v2023_10_01_preview.models.DefenderCspmGcpOfferingDataSensitivityDiscovery
        :keyword mdc_containers_image_assessment: The Microsoft Defender Container image assessment
         configuration.
        :paramtype mdc_containers_image_assessment:
         ~azure.mgmt.security.v2023_10_01_preview.models.DefenderCspmGcpOfferingMdcContainersImageAssessment
        :keyword mdc_containers_agentless_discovery_k8_s: The Microsoft Defender Container agentless
         discovery configuration.
        :paramtype mdc_containers_agentless_discovery_k8_s:
         ~azure.mgmt.security.v2023_10_01_preview.models.DefenderCspmGcpOfferingMdcContainersAgentlessDiscoveryK8S
        """
        super().__init__(**kwargs)
        self.offering_type: str = "DefenderCspmGcp"
        self.ciem_discovery = ciem_discovery
        self.vm_scanners = vm_scanners
        self.data_sensitivity_discovery = data_sensitivity_discovery
        self.mdc_containers_image_assessment = mdc_containers_image_assessment
        self.mdc_containers_agentless_discovery_k8_s = mdc_containers_agentless_discovery_k8_s


class DefenderCspmGcpOfferingCiemDiscovery(_serialization.Model):
    """GCP Defenders CSPM Cloud infrastructure entitlement management (CIEM) discovery offering
    configurations.

    :ivar workload_identity_provider_id: The GCP workload identity provider id for CIEM discovery
     offering.
    :vartype workload_identity_provider_id: str
    :ivar service_account_email_address: The service account email address in GCP for CIEM
     discovery offering.
    :vartype service_account_email_address: str
    :ivar azure_active_directory_app_name: the azure active directory app name used of
     authenticating against GCP workload identity federation.
    :vartype azure_active_directory_app_name: str
    """

    _attribute_map = {
        "workload_identity_provider_id": {"key": "workloadIdentityProviderId", "type": "str"},
        "service_account_email_address": {"key": "serviceAccountEmailAddress", "type": "str"},
        "azure_active_directory_app_name": {"key": "azureActiveDirectoryAppName", "type": "str"},
    }

    def __init__(
        self,
        *,
        workload_identity_provider_id: Optional[str] = None,
        service_account_email_address: Optional[str] = None,
        azure_active_directory_app_name: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword workload_identity_provider_id: The GCP workload identity provider id for CIEM
         discovery offering.
        :paramtype workload_identity_provider_id: str
        :keyword service_account_email_address: The service account email address in GCP for CIEM
         discovery offering.
        :paramtype service_account_email_address: str
        :keyword azure_active_directory_app_name: the azure active directory app name used of
         authenticating against GCP workload identity federation.
        :paramtype azure_active_directory_app_name: str
        """
        super().__init__(**kwargs)
        self.workload_identity_provider_id = workload_identity_provider_id
        self.service_account_email_address = service_account_email_address
        self.azure_active_directory_app_name = azure_active_directory_app_name


class DefenderCspmGcpOfferingDataSensitivityDiscovery(_serialization.Model):  # pylint: disable=name-too-long
    """The Microsoft Defender Data Sensitivity discovery configuration.

    :ivar enabled: Is Microsoft Defender Data Sensitivity discovery enabled.
    :vartype enabled: bool
    :ivar workload_identity_provider_id: The workload identity provider id in GCP for this feature.
    :vartype workload_identity_provider_id: str
    :ivar service_account_email_address: The service account email address in GCP for this feature.
    :vartype service_account_email_address: str
    """

    _attribute_map = {
        "enabled": {"key": "enabled", "type": "bool"},
        "workload_identity_provider_id": {"key": "workloadIdentityProviderId", "type": "str"},
        "service_account_email_address": {"key": "serviceAccountEmailAddress", "type": "str"},
    }

    def __init__(
        self,
        *,
        enabled: Optional[bool] = None,
        workload_identity_provider_id: Optional[str] = None,
        service_account_email_address: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword enabled: Is Microsoft Defender Data Sensitivity discovery enabled.
        :paramtype enabled: bool
        :keyword workload_identity_provider_id: The workload identity provider id in GCP for this
         feature.
        :paramtype workload_identity_provider_id: str
        :keyword service_account_email_address: The service account email address in GCP for this
         feature.
        :paramtype service_account_email_address: str
        """
        super().__init__(**kwargs)
        self.enabled = enabled
        self.workload_identity_provider_id = workload_identity_provider_id
        self.service_account_email_address = service_account_email_address


class DefenderCspmGcpOfferingMdcContainersAgentlessDiscoveryK8S(_serialization.Model):  # pylint: disable=name-too-long
    """The Microsoft Defender Container agentless discovery configuration.

    :ivar enabled: Is Microsoft Defender container agentless discovery enabled.
    :vartype enabled: bool
    :ivar workload_identity_provider_id: The workload identity provider id in GCP for this feature.
    :vartype workload_identity_provider_id: str
    :ivar service_account_email_address: The service account email address in GCP for this feature.
    :vartype service_account_email_address: str
    """

    _attribute_map = {
        "enabled": {"key": "enabled", "type": "bool"},
        "workload_identity_provider_id": {"key": "workloadIdentityProviderId", "type": "str"},
        "service_account_email_address": {"key": "serviceAccountEmailAddress", "type": "str"},
    }

    def __init__(
        self,
        *,
        enabled: Optional[bool] = None,
        workload_identity_provider_id: Optional[str] = None,
        service_account_email_address: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword enabled: Is Microsoft Defender container agentless discovery enabled.
        :paramtype enabled: bool
        :keyword workload_identity_provider_id: The workload identity provider id in GCP for this
         feature.
        :paramtype workload_identity_provider_id: str
        :keyword service_account_email_address: The service account email address in GCP for this
         feature.
        :paramtype service_account_email_address: str
        """
        super().__init__(**kwargs)
        self.enabled = enabled
        self.workload_identity_provider_id = workload_identity_provider_id
        self.service_account_email_address = service_account_email_address


class DefenderCspmGcpOfferingMdcContainersImageAssessment(_serialization.Model):  # pylint: disable=name-too-long
    """The Microsoft Defender Container image assessment configuration.

    :ivar enabled: Is Microsoft Defender container image assessment enabled.
    :vartype enabled: bool
    :ivar workload_identity_provider_id: The workload identity provider id in GCP for this feature.
    :vartype workload_identity_provider_id: str
    :ivar service_account_email_address: The service account email address in GCP for this feature.
    :vartype service_account_email_address: str
    """

    _attribute_map = {
        "enabled": {"key": "enabled", "type": "bool"},
        "workload_identity_provider_id": {"key": "workloadIdentityProviderId", "type": "str"},
        "service_account_email_address": {"key": "serviceAccountEmailAddress", "type": "str"},
    }

    def __init__(
        self,
        *,
        enabled: Optional[bool] = None,
        workload_identity_provider_id: Optional[str] = None,
        service_account_email_address: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword enabled: Is Microsoft Defender container image assessment enabled.
        :paramtype enabled: bool
        :keyword workload_identity_provider_id: The workload identity provider id in GCP for this
         feature.
        :paramtype workload_identity_provider_id: str
        :keyword service_account_email_address: The service account email address in GCP for this
         feature.
        :paramtype service_account_email_address: str
        """
        super().__init__(**kwargs)
        self.enabled = enabled
        self.workload_identity_provider_id = workload_identity_provider_id
        self.service_account_email_address = service_account_email_address


class DefenderCspmGcpOfferingVmScanners(_serialization.Model):
    """The Microsoft Defender for Server VM scanning configuration.

    :ivar enabled: Is Microsoft Defender for Server VM scanning enabled.
    :vartype enabled: bool
    :ivar configuration: configuration for Microsoft Defender for Server VM scanning.
    :vartype configuration:
     ~azure.mgmt.security.v2023_10_01_preview.models.DefenderCspmGcpOfferingVmScannersConfiguration
    """

    _attribute_map = {
        "enabled": {"key": "enabled", "type": "bool"},
        "configuration": {"key": "configuration", "type": "DefenderCspmGcpOfferingVmScannersConfiguration"},
    }

    def __init__(
        self,
        *,
        enabled: Optional[bool] = None,
        configuration: Optional["_models.DefenderCspmGcpOfferingVmScannersConfiguration"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword enabled: Is Microsoft Defender for Server VM scanning enabled.
        :paramtype enabled: bool
        :keyword configuration: configuration for Microsoft Defender for Server VM scanning.
        :paramtype configuration:
         ~azure.mgmt.security.v2023_10_01_preview.models.DefenderCspmGcpOfferingVmScannersConfiguration
        """
        super().__init__(**kwargs)
        self.enabled = enabled
        self.configuration = configuration


class DefenderCspmGcpOfferingVmScannersConfiguration(_serialization.Model):  # pylint: disable=name-too-long
    """configuration for Microsoft Defender for Server VM scanning.

    :ivar scanning_mode: The scanning mode for the VM scan. "Default"
    :vartype scanning_mode: str or ~azure.mgmt.security.v2023_10_01_preview.models.ScanningMode
    :ivar exclusion_tags: VM tags that indicates that VM should not be scanned.
    :vartype exclusion_tags: dict[str, str]
    """

    _attribute_map = {
        "scanning_mode": {"key": "scanningMode", "type": "str"},
        "exclusion_tags": {"key": "exclusionTags", "type": "{str}"},
    }

    def __init__(
        self,
        *,
        scanning_mode: Optional[Union[str, "_models.ScanningMode"]] = None,
        exclusion_tags: Optional[Dict[str, str]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword scanning_mode: The scanning mode for the VM scan. "Default"
        :paramtype scanning_mode: str or ~azure.mgmt.security.v2023_10_01_preview.models.ScanningMode
        :keyword exclusion_tags: VM tags that indicates that VM should not be scanned.
        :paramtype exclusion_tags: dict[str, str]
        """
        super().__init__(**kwargs)
        self.scanning_mode = scanning_mode
        self.exclusion_tags = exclusion_tags


class DefenderFoDatabasesAwsOffering(CloudOffering):
    """The Defender for Databases AWS offering.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar offering_type: The type of the security offering. Required. Known values are:
     "CspmMonitorAws", "DefenderForContainersAws", "DefenderForServersAws",
     "DefenderForDatabasesAws", "InformationProtectionAws", "CspmMonitorGcp", "CspmMonitorGithub",
     "CspmMonitorAzureDevOps", "DefenderForServersGcp", "DefenderForContainersGcp",
     "DefenderForDatabasesGcp", "DefenderCspmAws", "DefenderCspmGcp", "DefenderForDevOpsGithub",
     "DefenderForDevOpsAzureDevOps", "CspmMonitorGitLab", and "DefenderForDevOpsGitLab".
    :vartype offering_type: str or ~azure.mgmt.security.v2023_10_01_preview.models.OfferingType
    :ivar description: The offering description.
    :vartype description: str
    :ivar arc_auto_provisioning: The ARC autoprovisioning configuration.
    :vartype arc_auto_provisioning:
     ~azure.mgmt.security.v2023_10_01_preview.models.DefenderFoDatabasesAwsOfferingArcAutoProvisioning
    :ivar rds: The RDS configuration.
    :vartype rds: ~azure.mgmt.security.v2023_10_01_preview.models.DefenderFoDatabasesAwsOfferingRds
    :ivar databases_dspm: The databases data security posture management (DSPM) configuration.
    :vartype databases_dspm:
     ~azure.mgmt.security.v2023_10_01_preview.models.DefenderFoDatabasesAwsOfferingDatabasesDspm
    """

    _validation = {
        "offering_type": {"required": True},
        "description": {"readonly": True},
    }

    _attribute_map = {
        "offering_type": {"key": "offeringType", "type": "str"},
        "description": {"key": "description", "type": "str"},
        "arc_auto_provisioning": {
            "key": "arcAutoProvisioning",
            "type": "DefenderFoDatabasesAwsOfferingArcAutoProvisioning",
        },
        "rds": {"key": "rds", "type": "DefenderFoDatabasesAwsOfferingRds"},
        "databases_dspm": {"key": "databasesDspm", "type": "DefenderFoDatabasesAwsOfferingDatabasesDspm"},
    }

    def __init__(
        self,
        *,
        arc_auto_provisioning: Optional["_models.DefenderFoDatabasesAwsOfferingArcAutoProvisioning"] = None,
        rds: Optional["_models.DefenderFoDatabasesAwsOfferingRds"] = None,
        databases_dspm: Optional["_models.DefenderFoDatabasesAwsOfferingDatabasesDspm"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword arc_auto_provisioning: The ARC autoprovisioning configuration.
        :paramtype arc_auto_provisioning:
         ~azure.mgmt.security.v2023_10_01_preview.models.DefenderFoDatabasesAwsOfferingArcAutoProvisioning
        :keyword rds: The RDS configuration.
        :paramtype rds:
         ~azure.mgmt.security.v2023_10_01_preview.models.DefenderFoDatabasesAwsOfferingRds
        :keyword databases_dspm: The databases data security posture management (DSPM) configuration.
        :paramtype databases_dspm:
         ~azure.mgmt.security.v2023_10_01_preview.models.DefenderFoDatabasesAwsOfferingDatabasesDspm
        """
        super().__init__(**kwargs)
        self.offering_type: str = "DefenderForDatabasesAws"
        self.arc_auto_provisioning = arc_auto_provisioning
        self.rds = rds
        self.databases_dspm = databases_dspm


class DefenderFoDatabasesAwsOfferingArcAutoProvisioning(_serialization.Model):  # pylint: disable=name-too-long
    """The ARC autoprovisioning configuration.

    :ivar enabled: Is arc auto provisioning enabled.
    :vartype enabled: bool
    :ivar cloud_role_arn: The cloud role ARN in AWS for this feature.
    :vartype cloud_role_arn: str
    :ivar configuration: Configuration for servers Arc auto provisioning.
    :vartype configuration:
     ~azure.mgmt.security.v2023_10_01_preview.models.DefenderFoDatabasesAwsOfferingArcAutoProvisioningConfiguration
    """

    _attribute_map = {
        "enabled": {"key": "enabled", "type": "bool"},
        "cloud_role_arn": {"key": "cloudRoleArn", "type": "str"},
        "configuration": {
            "key": "configuration",
            "type": "DefenderFoDatabasesAwsOfferingArcAutoProvisioningConfiguration",
        },
    }

    def __init__(
        self,
        *,
        enabled: Optional[bool] = None,
        cloud_role_arn: Optional[str] = None,
        configuration: Optional["_models.DefenderFoDatabasesAwsOfferingArcAutoProvisioningConfiguration"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword enabled: Is arc auto provisioning enabled.
        :paramtype enabled: bool
        :keyword cloud_role_arn: The cloud role ARN in AWS for this feature.
        :paramtype cloud_role_arn: str
        :keyword configuration: Configuration for servers Arc auto provisioning.
        :paramtype configuration:
         ~azure.mgmt.security.v2023_10_01_preview.models.DefenderFoDatabasesAwsOfferingArcAutoProvisioningConfiguration
        """
        super().__init__(**kwargs)
        self.enabled = enabled
        self.cloud_role_arn = cloud_role_arn
        self.configuration = configuration


class DefenderFoDatabasesAwsOfferingArcAutoProvisioningConfiguration(
    _serialization.Model
):  # pylint: disable=name-too-long
    """Configuration for servers Arc auto provisioning.

    :ivar proxy: Optional http proxy endpoint to use for the Arc agent.
    :vartype proxy: str
    :ivar private_link_scope: Optional Arc private link scope resource id to link the Arc agent.
    :vartype private_link_scope: str
    """

    _attribute_map = {
        "proxy": {"key": "proxy", "type": "str"},
        "private_link_scope": {"key": "privateLinkScope", "type": "str"},
    }

    def __init__(self, *, proxy: Optional[str] = None, private_link_scope: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword proxy: Optional http proxy endpoint to use for the Arc agent.
        :paramtype proxy: str
        :keyword private_link_scope: Optional Arc private link scope resource id to link the Arc agent.
        :paramtype private_link_scope: str
        """
        super().__init__(**kwargs)
        self.proxy = proxy
        self.private_link_scope = private_link_scope


class DefenderFoDatabasesAwsOfferingDatabasesDspm(_serialization.Model):  # pylint: disable=name-too-long
    """The databases data security posture management (DSPM) configuration.

    :ivar enabled: Is databases data security posture management (DSPM) protection enabled.
    :vartype enabled: bool
    :ivar cloud_role_arn: The cloud role ARN in AWS for this feature.
    :vartype cloud_role_arn: str
    """

    _attribute_map = {
        "enabled": {"key": "enabled", "type": "bool"},
        "cloud_role_arn": {"key": "cloudRoleArn", "type": "str"},
    }

    def __init__(self, *, enabled: Optional[bool] = None, cloud_role_arn: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword enabled: Is databases data security posture management (DSPM) protection enabled.
        :paramtype enabled: bool
        :keyword cloud_role_arn: The cloud role ARN in AWS for this feature.
        :paramtype cloud_role_arn: str
        """
        super().__init__(**kwargs)
        self.enabled = enabled
        self.cloud_role_arn = cloud_role_arn


class DefenderFoDatabasesAwsOfferingRds(_serialization.Model):
    """The RDS configuration.

    :ivar enabled: Is RDS protection enabled.
    :vartype enabled: bool
    :ivar cloud_role_arn: The cloud role ARN in AWS for this feature.
    :vartype cloud_role_arn: str
    """

    _attribute_map = {
        "enabled": {"key": "enabled", "type": "bool"},
        "cloud_role_arn": {"key": "cloudRoleArn", "type": "str"},
    }

    def __init__(self, *, enabled: Optional[bool] = None, cloud_role_arn: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword enabled: Is RDS protection enabled.
        :paramtype enabled: bool
        :keyword cloud_role_arn: The cloud role ARN in AWS for this feature.
        :paramtype cloud_role_arn: str
        """
        super().__init__(**kwargs)
        self.enabled = enabled
        self.cloud_role_arn = cloud_role_arn


class DefenderForContainersAwsOffering(CloudOffering):  # pylint: disable=too-many-instance-attributes
    """The Defender for Containers AWS offering.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar offering_type: The type of the security offering. Required. Known values are:
     "CspmMonitorAws", "DefenderForContainersAws", "DefenderForServersAws",
     "DefenderForDatabasesAws", "InformationProtectionAws", "CspmMonitorGcp", "CspmMonitorGithub",
     "CspmMonitorAzureDevOps", "DefenderForServersGcp", "DefenderForContainersGcp",
     "DefenderForDatabasesGcp", "DefenderCspmAws", "DefenderCspmGcp", "DefenderForDevOpsGithub",
     "DefenderForDevOpsAzureDevOps", "CspmMonitorGitLab", and "DefenderForDevOpsGitLab".
    :vartype offering_type: str or ~azure.mgmt.security.v2023_10_01_preview.models.OfferingType
    :ivar description: The offering description.
    :vartype description: str
    :ivar kubernetes_service: The kubernetes service connection configuration.
    :vartype kubernetes_service:
     ~azure.mgmt.security.v2023_10_01_preview.models.DefenderForContainersAwsOfferingKubernetesService
    :ivar kubernetes_scuba_reader: The kubernetes to scuba connection configuration.
    :vartype kubernetes_scuba_reader:
     ~azure.mgmt.security.v2023_10_01_preview.models.DefenderForContainersAwsOfferingKubernetesScubaReader
    :ivar cloud_watch_to_kinesis: The cloudwatch to kinesis connection configuration.
    :vartype cloud_watch_to_kinesis:
     ~azure.mgmt.security.v2023_10_01_preview.models.DefenderForContainersAwsOfferingCloudWatchToKinesis
    :ivar kinesis_to_s3: The kinesis to s3 connection configuration.
    :vartype kinesis_to_s3:
     ~azure.mgmt.security.v2023_10_01_preview.models.DefenderForContainersAwsOfferingKinesisToS3
    :ivar container_vulnerability_assessment: The container vulnerability assessment configuration.
    :vartype container_vulnerability_assessment:
     ~azure.mgmt.security.v2023_10_01_preview.models.DefenderForContainersAwsOfferingContainerVulnerabilityAssessment
    :ivar container_vulnerability_assessment_task: The container vulnerability assessment task
     configuration.
    :vartype container_vulnerability_assessment_task:
     ~azure.mgmt.security.v2023_10_01_preview.models.DefenderForContainersAwsOfferingContainerVulnerabilityAssessmentTask  # pylint: disable=line-too-long
    :ivar enable_container_vulnerability_assessment: Enable container vulnerability assessment
     feature.
    :vartype enable_container_vulnerability_assessment: bool
    :ivar auto_provisioning: Is audit logs pipeline auto provisioning enabled.
    :vartype auto_provisioning: bool
    :ivar kube_audit_retention_time: The retention time in days of kube audit logs set on the
     CloudWatch log group.
    :vartype kube_audit_retention_time: int
    :ivar scuba_external_id: The externalId used by the data reader to prevent the confused deputy
     attack.
    :vartype scuba_external_id: str
    :ivar mdc_containers_image_assessment: The Microsoft Defender container image assessment
     configuration.
    :vartype mdc_containers_image_assessment:
     ~azure.mgmt.security.v2023_10_01_preview.models.DefenderForContainersAwsOfferingMdcContainersImageAssessment
    :ivar mdc_containers_agentless_discovery_k8_s: The Microsoft Defender container agentless
     discovery K8s configuration.
    :vartype mdc_containers_agentless_discovery_k8_s:
     ~azure.mgmt.security.v2023_10_01_preview.models.DefenderForContainersAwsOfferingMdcContainersAgentlessDiscoveryK8S
    """

    _validation = {
        "offering_type": {"required": True},
        "description": {"readonly": True},
    }

    _attribute_map = {
        "offering_type": {"key": "offeringType", "type": "str"},
        "description": {"key": "description", "type": "str"},
        "kubernetes_service": {"key": "kubernetesService", "type": "DefenderForContainersAwsOfferingKubernetesService"},
        "kubernetes_scuba_reader": {
            "key": "kubernetesScubaReader",
            "type": "DefenderForContainersAwsOfferingKubernetesScubaReader",
        },
        "cloud_watch_to_kinesis": {
            "key": "cloudWatchToKinesis",
            "type": "DefenderForContainersAwsOfferingCloudWatchToKinesis",
        },
        "kinesis_to_s3": {"key": "kinesisToS3", "type": "DefenderForContainersAwsOfferingKinesisToS3"},
        "container_vulnerability_assessment": {
            "key": "containerVulnerabilityAssessment",
            "type": "DefenderForContainersAwsOfferingContainerVulnerabilityAssessment",
        },
        "container_vulnerability_assessment_task": {
            "key": "containerVulnerabilityAssessmentTask",
            "type": "DefenderForContainersAwsOfferingContainerVulnerabilityAssessmentTask",
        },
        "enable_container_vulnerability_assessment": {"key": "enableContainerVulnerabilityAssessment", "type": "bool"},
        "auto_provisioning": {"key": "autoProvisioning", "type": "bool"},
        "kube_audit_retention_time": {"key": "kubeAuditRetentionTime", "type": "int"},
        "scuba_external_id": {"key": "scubaExternalId", "type": "str"},
        "mdc_containers_image_assessment": {
            "key": "mdcContainersImageAssessment",
            "type": "DefenderForContainersAwsOfferingMdcContainersImageAssessment",
        },
        "mdc_containers_agentless_discovery_k8_s": {
            "key": "mdcContainersAgentlessDiscoveryK8s",
            "type": "DefenderForContainersAwsOfferingMdcContainersAgentlessDiscoveryK8S",
        },
    }

    def __init__(
        self,
        *,
        kubernetes_service: Optional["_models.DefenderForContainersAwsOfferingKubernetesService"] = None,
        kubernetes_scuba_reader: Optional["_models.DefenderForContainersAwsOfferingKubernetesScubaReader"] = None,
        cloud_watch_to_kinesis: Optional["_models.DefenderForContainersAwsOfferingCloudWatchToKinesis"] = None,
        kinesis_to_s3: Optional["_models.DefenderForContainersAwsOfferingKinesisToS3"] = None,
        container_vulnerability_assessment: Optional[
            "_models.DefenderForContainersAwsOfferingContainerVulnerabilityAssessment"
        ] = None,
        container_vulnerability_assessment_task: Optional[
            "_models.DefenderForContainersAwsOfferingContainerVulnerabilityAssessmentTask"
        ] = None,
        enable_container_vulnerability_assessment: Optional[bool] = None,
        auto_provisioning: Optional[bool] = None,
        kube_audit_retention_time: Optional[int] = None,
        scuba_external_id: Optional[str] = None,
        mdc_containers_image_assessment: Optional[
            "_models.DefenderForContainersAwsOfferingMdcContainersImageAssessment"
        ] = None,
        mdc_containers_agentless_discovery_k8_s: Optional[
            "_models.DefenderForContainersAwsOfferingMdcContainersAgentlessDiscoveryK8S"
        ] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword kubernetes_service: The kubernetes service connection configuration.
        :paramtype kubernetes_service:
         ~azure.mgmt.security.v2023_10_01_preview.models.DefenderForContainersAwsOfferingKubernetesService
        :keyword kubernetes_scuba_reader: The kubernetes to scuba connection configuration.
        :paramtype kubernetes_scuba_reader:
         ~azure.mgmt.security.v2023_10_01_preview.models.DefenderForContainersAwsOfferingKubernetesScubaReader
        :keyword cloud_watch_to_kinesis: The cloudwatch to kinesis connection configuration.
        :paramtype cloud_watch_to_kinesis:
         ~azure.mgmt.security.v2023_10_01_preview.models.DefenderForContainersAwsOfferingCloudWatchToKinesis
        :keyword kinesis_to_s3: The kinesis to s3 connection configuration.
        :paramtype kinesis_to_s3:
         ~azure.mgmt.security.v2023_10_01_preview.models.DefenderForContainersAwsOfferingKinesisToS3
        :keyword container_vulnerability_assessment: The container vulnerability assessment
         configuration.
        :paramtype container_vulnerability_assessment:
         ~azure.mgmt.security.v2023_10_01_preview.models.DefenderForContainersAwsOfferingContainerVulnerabilityAssessment  # pylint: disable=line-too-long
        :keyword container_vulnerability_assessment_task: The container vulnerability assessment task
         configuration.
        :paramtype container_vulnerability_assessment_task:
         ~azure.mgmt.security.v2023_10_01_preview.models.DefenderForContainersAwsOfferingContainerVulnerabilityAssessmentTask  # pylint: disable=line-too-long
        :keyword enable_container_vulnerability_assessment: Enable container vulnerability assessment
         feature.
        :paramtype enable_container_vulnerability_assessment: bool
        :keyword auto_provisioning: Is audit logs pipeline auto provisioning enabled.
        :paramtype auto_provisioning: bool
        :keyword kube_audit_retention_time: The retention time in days of kube audit logs set on the
         CloudWatch log group.
        :paramtype kube_audit_retention_time: int
        :keyword scuba_external_id: The externalId used by the data reader to prevent the confused
         deputy attack.
        :paramtype scuba_external_id: str
        :keyword mdc_containers_image_assessment: The Microsoft Defender container image assessment
         configuration.
        :paramtype mdc_containers_image_assessment:
         ~azure.mgmt.security.v2023_10_01_preview.models.DefenderForContainersAwsOfferingMdcContainersImageAssessment
        :keyword mdc_containers_agentless_discovery_k8_s: The Microsoft Defender container agentless
         discovery K8s configuration.
        :paramtype mdc_containers_agentless_discovery_k8_s:
         ~azure.mgmt.security.v2023_10_01_preview.models.DefenderForContainersAwsOfferingMdcContainersAgentlessDiscoveryK8S  # pylint: disable=line-too-long
        """
        super().__init__(**kwargs)
        self.offering_type: str = "DefenderForContainersAws"
        self.kubernetes_service = kubernetes_service
        self.kubernetes_scuba_reader = kubernetes_scuba_reader
        self.cloud_watch_to_kinesis = cloud_watch_to_kinesis
        self.kinesis_to_s3 = kinesis_to_s3
        self.container_vulnerability_assessment = container_vulnerability_assessment
        self.container_vulnerability_assessment_task = container_vulnerability_assessment_task
        self.enable_container_vulnerability_assessment = enable_container_vulnerability_assessment
        self.auto_provisioning = auto_provisioning
        self.kube_audit_retention_time = kube_audit_retention_time
        self.scuba_external_id = scuba_external_id
        self.mdc_containers_image_assessment = mdc_containers_image_assessment
        self.mdc_containers_agentless_discovery_k8_s = mdc_containers_agentless_discovery_k8_s


class DefenderForContainersAwsOfferingCloudWatchToKinesis(_serialization.Model):  # pylint: disable=name-too-long
    """The cloudwatch to kinesis connection configuration.

    :ivar cloud_role_arn: The cloud role ARN in AWS used by CloudWatch to transfer data into
     Kinesis.
    :vartype cloud_role_arn: str
    """

    _attribute_map = {
        "cloud_role_arn": {"key": "cloudRoleArn", "type": "str"},
    }

    def __init__(self, *, cloud_role_arn: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword cloud_role_arn: The cloud role ARN in AWS used by CloudWatch to transfer data into
         Kinesis.
        :paramtype cloud_role_arn: str
        """
        super().__init__(**kwargs)
        self.cloud_role_arn = cloud_role_arn


class DefenderForContainersAwsOfferingContainerVulnerabilityAssessment(
    _serialization.Model
):  # pylint: disable=name-too-long
    """The container vulnerability assessment configuration.

    :ivar cloud_role_arn: The cloud role ARN in AWS for this feature.
    :vartype cloud_role_arn: str
    """

    _attribute_map = {
        "cloud_role_arn": {"key": "cloudRoleArn", "type": "str"},
    }

    def __init__(self, *, cloud_role_arn: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword cloud_role_arn: The cloud role ARN in AWS for this feature.
        :paramtype cloud_role_arn: str
        """
        super().__init__(**kwargs)
        self.cloud_role_arn = cloud_role_arn


class DefenderForContainersAwsOfferingContainerVulnerabilityAssessmentTask(
    _serialization.Model
):  # pylint: disable=name-too-long
    """The container vulnerability assessment task configuration.

    :ivar cloud_role_arn: The cloud role ARN in AWS for this feature.
    :vartype cloud_role_arn: str
    """

    _attribute_map = {
        "cloud_role_arn": {"key": "cloudRoleArn", "type": "str"},
    }

    def __init__(self, *, cloud_role_arn: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword cloud_role_arn: The cloud role ARN in AWS for this feature.
        :paramtype cloud_role_arn: str
        """
        super().__init__(**kwargs)
        self.cloud_role_arn = cloud_role_arn


class DefenderForContainersAwsOfferingKinesisToS3(_serialization.Model):  # pylint: disable=name-too-long
    """The kinesis to s3 connection configuration.

    :ivar cloud_role_arn: The cloud role ARN in AWS used by Kinesis to transfer data into S3.
    :vartype cloud_role_arn: str
    """

    _attribute_map = {
        "cloud_role_arn": {"key": "cloudRoleArn", "type": "str"},
    }

    def __init__(self, *, cloud_role_arn: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword cloud_role_arn: The cloud role ARN in AWS used by Kinesis to transfer data into S3.
        :paramtype cloud_role_arn: str
        """
        super().__init__(**kwargs)
        self.cloud_role_arn = cloud_role_arn


class DefenderForContainersAwsOfferingKubernetesScubaReader(_serialization.Model):  # pylint: disable=name-too-long
    """The kubernetes to scuba connection configuration.

    :ivar cloud_role_arn: The cloud role ARN in AWS for this feature used for reading data.
    :vartype cloud_role_arn: str
    """

    _attribute_map = {
        "cloud_role_arn": {"key": "cloudRoleArn", "type": "str"},
    }

    def __init__(self, *, cloud_role_arn: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword cloud_role_arn: The cloud role ARN in AWS for this feature used for reading data.
        :paramtype cloud_role_arn: str
        """
        super().__init__(**kwargs)
        self.cloud_role_arn = cloud_role_arn


class DefenderForContainersAwsOfferingKubernetesService(_serialization.Model):  # pylint: disable=name-too-long
    """The kubernetes service connection configuration.

    :ivar cloud_role_arn: The cloud role ARN in AWS for this feature used for provisioning
     resources.
    :vartype cloud_role_arn: str
    """

    _attribute_map = {
        "cloud_role_arn": {"key": "cloudRoleArn", "type": "str"},
    }

    def __init__(self, *, cloud_role_arn: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword cloud_role_arn: The cloud role ARN in AWS for this feature used for provisioning
         resources.
        :paramtype cloud_role_arn: str
        """
        super().__init__(**kwargs)
        self.cloud_role_arn = cloud_role_arn


class DefenderForContainersAwsOfferingMdcContainersAgentlessDiscoveryK8S(
    _serialization.Model
):  # pylint: disable=name-too-long
    """The Microsoft Defender container agentless discovery K8s configuration.

    :ivar enabled: Is Microsoft Defender container agentless discovery K8s enabled.
    :vartype enabled: bool
    :ivar cloud_role_arn: The cloud role ARN in AWS for this feature.
    :vartype cloud_role_arn: str
    """

    _attribute_map = {
        "enabled": {"key": "enabled", "type": "bool"},
        "cloud_role_arn": {"key": "cloudRoleArn", "type": "str"},
    }

    def __init__(self, *, enabled: Optional[bool] = None, cloud_role_arn: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword enabled: Is Microsoft Defender container agentless discovery K8s enabled.
        :paramtype enabled: bool
        :keyword cloud_role_arn: The cloud role ARN in AWS for this feature.
        :paramtype cloud_role_arn: str
        """
        super().__init__(**kwargs)
        self.enabled = enabled
        self.cloud_role_arn = cloud_role_arn


class DefenderForContainersAwsOfferingMdcContainersImageAssessment(
    _serialization.Model
):  # pylint: disable=name-too-long
    """The Microsoft Defender container image assessment configuration.

    :ivar enabled: Is Microsoft Defender container image assessment enabled.
    :vartype enabled: bool
    :ivar cloud_role_arn: The cloud role ARN in AWS for this feature.
    :vartype cloud_role_arn: str
    """

    _attribute_map = {
        "enabled": {"key": "enabled", "type": "bool"},
        "cloud_role_arn": {"key": "cloudRoleArn", "type": "str"},
    }

    def __init__(self, *, enabled: Optional[bool] = None, cloud_role_arn: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword enabled: Is Microsoft Defender container image assessment enabled.
        :paramtype enabled: bool
        :keyword cloud_role_arn: The cloud role ARN in AWS for this feature.
        :paramtype cloud_role_arn: str
        """
        super().__init__(**kwargs)
        self.enabled = enabled
        self.cloud_role_arn = cloud_role_arn


class DefenderForContainersGcpOffering(CloudOffering):
    """The containers GCP offering.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar offering_type: The type of the security offering. Required. Known values are:
     "CspmMonitorAws", "DefenderForContainersAws", "DefenderForServersAws",
     "DefenderForDatabasesAws", "InformationProtectionAws", "CspmMonitorGcp", "CspmMonitorGithub",
     "CspmMonitorAzureDevOps", "DefenderForServersGcp", "DefenderForContainersGcp",
     "DefenderForDatabasesGcp", "DefenderCspmAws", "DefenderCspmGcp", "DefenderForDevOpsGithub",
     "DefenderForDevOpsAzureDevOps", "CspmMonitorGitLab", and "DefenderForDevOpsGitLab".
    :vartype offering_type: str or ~azure.mgmt.security.v2023_10_01_preview.models.OfferingType
    :ivar description: The offering description.
    :vartype description: str
    :ivar native_cloud_connection: The native cloud connection configuration.
    :vartype native_cloud_connection:
     ~azure.mgmt.security.v2023_10_01_preview.models.DefenderForContainersGcpOfferingNativeCloudConnection
    :ivar data_pipeline_native_cloud_connection: The native cloud connection configuration.
    :vartype data_pipeline_native_cloud_connection:
     ~azure.mgmt.security.v2023_10_01_preview.models.DefenderForContainersGcpOfferingDataPipelineNativeCloudConnection
    :ivar audit_logs_auto_provisioning_flag: Is audit logs data collection enabled.
    :vartype audit_logs_auto_provisioning_flag: bool
    :ivar defender_agent_auto_provisioning_flag: Is Microsoft Defender for Cloud Kubernetes agent
     auto provisioning enabled.
    :vartype defender_agent_auto_provisioning_flag: bool
    :ivar policy_agent_auto_provisioning_flag: Is Policy Kubernetes agent auto provisioning
     enabled.
    :vartype policy_agent_auto_provisioning_flag: bool
    :ivar mdc_containers_image_assessment: The Microsoft Defender Container image assessment
     configuration.
    :vartype mdc_containers_image_assessment:
     ~azure.mgmt.security.v2023_10_01_preview.models.DefenderForContainersGcpOfferingMdcContainersImageAssessment
    :ivar mdc_containers_agentless_discovery_k8_s: The Microsoft Defender Container agentless
     discovery configuration.
    :vartype mdc_containers_agentless_discovery_k8_s:
     ~azure.mgmt.security.v2023_10_01_preview.models.DefenderForContainersGcpOfferingMdcContainersAgentlessDiscoveryK8S
    """

    _validation = {
        "offering_type": {"required": True},
        "description": {"readonly": True},
    }

    _attribute_map = {
        "offering_type": {"key": "offeringType", "type": "str"},
        "description": {"key": "description", "type": "str"},
        "native_cloud_connection": {
            "key": "nativeCloudConnection",
            "type": "DefenderForContainersGcpOfferingNativeCloudConnection",
        },
        "data_pipeline_native_cloud_connection": {
            "key": "dataPipelineNativeCloudConnection",
            "type": "DefenderForContainersGcpOfferingDataPipelineNativeCloudConnection",
        },
        "audit_logs_auto_provisioning_flag": {"key": "auditLogsAutoProvisioningFlag", "type": "bool"},
        "defender_agent_auto_provisioning_flag": {"key": "defenderAgentAutoProvisioningFlag", "type": "bool"},
        "policy_agent_auto_provisioning_flag": {"key": "policyAgentAutoProvisioningFlag", "type": "bool"},
        "mdc_containers_image_assessment": {
            "key": "mdcContainersImageAssessment",
            "type": "DefenderForContainersGcpOfferingMdcContainersImageAssessment",
        },
        "mdc_containers_agentless_discovery_k8_s": {
            "key": "mdcContainersAgentlessDiscoveryK8s",
            "type": "DefenderForContainersGcpOfferingMdcContainersAgentlessDiscoveryK8S",
        },
    }

    def __init__(
        self,
        *,
        native_cloud_connection: Optional["_models.DefenderForContainersGcpOfferingNativeCloudConnection"] = None,
        data_pipeline_native_cloud_connection: Optional[
            "_models.DefenderForContainersGcpOfferingDataPipelineNativeCloudConnection"
        ] = None,
        audit_logs_auto_provisioning_flag: Optional[bool] = None,
        defender_agent_auto_provisioning_flag: Optional[bool] = None,
        policy_agent_auto_provisioning_flag: Optional[bool] = None,
        mdc_containers_image_assessment: Optional[
            "_models.DefenderForContainersGcpOfferingMdcContainersImageAssessment"
        ] = None,
        mdc_containers_agentless_discovery_k8_s: Optional[
            "_models.DefenderForContainersGcpOfferingMdcContainersAgentlessDiscoveryK8S"
        ] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword native_cloud_connection: The native cloud connection configuration.
        :paramtype native_cloud_connection:
         ~azure.mgmt.security.v2023_10_01_preview.models.DefenderForContainersGcpOfferingNativeCloudConnection
        :keyword data_pipeline_native_cloud_connection: The native cloud connection configuration.
        :paramtype data_pipeline_native_cloud_connection:
         ~azure.mgmt.security.v2023_10_01_preview.models.DefenderForContainersGcpOfferingDataPipelineNativeCloudConnection  # pylint: disable=line-too-long
        :keyword audit_logs_auto_provisioning_flag: Is audit logs data collection enabled.
        :paramtype audit_logs_auto_provisioning_flag: bool
        :keyword defender_agent_auto_provisioning_flag: Is Microsoft Defender for Cloud Kubernetes
         agent auto provisioning enabled.
        :paramtype defender_agent_auto_provisioning_flag: bool
        :keyword policy_agent_auto_provisioning_flag: Is Policy Kubernetes agent auto provisioning
         enabled.
        :paramtype policy_agent_auto_provisioning_flag: bool
        :keyword mdc_containers_image_assessment: The Microsoft Defender Container image assessment
         configuration.
        :paramtype mdc_containers_image_assessment:
         ~azure.mgmt.security.v2023_10_01_preview.models.DefenderForContainersGcpOfferingMdcContainersImageAssessment
        :keyword mdc_containers_agentless_discovery_k8_s: The Microsoft Defender Container agentless
         discovery configuration.
        :paramtype mdc_containers_agentless_discovery_k8_s:
         ~azure.mgmt.security.v2023_10_01_preview.models.DefenderForContainersGcpOfferingMdcContainersAgentlessDiscoveryK8S  # pylint: disable=line-too-long
        """
        super().__init__(**kwargs)
        self.offering_type: str = "DefenderForContainersGcp"
        self.native_cloud_connection = native_cloud_connection
        self.data_pipeline_native_cloud_connection = data_pipeline_native_cloud_connection
        self.audit_logs_auto_provisioning_flag = audit_logs_auto_provisioning_flag
        self.defender_agent_auto_provisioning_flag = defender_agent_auto_provisioning_flag
        self.policy_agent_auto_provisioning_flag = policy_agent_auto_provisioning_flag
        self.mdc_containers_image_assessment = mdc_containers_image_assessment
        self.mdc_containers_agentless_discovery_k8_s = mdc_containers_agentless_discovery_k8_s


class DefenderForContainersGcpOfferingDataPipelineNativeCloudConnection(
    _serialization.Model
):  # pylint: disable=name-too-long
    """The native cloud connection configuration.

    :ivar service_account_email_address: The data collection service account email address in GCP
     for this offering.
    :vartype service_account_email_address: str
    :ivar workload_identity_provider_id: The data collection GCP workload identity provider id for
     this offering.
    :vartype workload_identity_provider_id: str
    """

    _attribute_map = {
        "service_account_email_address": {"key": "serviceAccountEmailAddress", "type": "str"},
        "workload_identity_provider_id": {"key": "workloadIdentityProviderId", "type": "str"},
    }

    def __init__(
        self,
        *,
        service_account_email_address: Optional[str] = None,
        workload_identity_provider_id: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword service_account_email_address: The data collection service account email address in
         GCP for this offering.
        :paramtype service_account_email_address: str
        :keyword workload_identity_provider_id: The data collection GCP workload identity provider id
         for this offering.
        :paramtype workload_identity_provider_id: str
        """
        super().__init__(**kwargs)
        self.service_account_email_address = service_account_email_address
        self.workload_identity_provider_id = workload_identity_provider_id


class DefenderForContainersGcpOfferingMdcContainersAgentlessDiscoveryK8S(
    _serialization.Model
):  # pylint: disable=name-too-long
    """The Microsoft Defender Container agentless discovery configuration.

    :ivar enabled: Is Microsoft Defender container agentless discovery enabled.
    :vartype enabled: bool
    :ivar workload_identity_provider_id: The workload identity provider id in GCP for this feature.
    :vartype workload_identity_provider_id: str
    :ivar service_account_email_address: The service account email address in GCP for this feature.
    :vartype service_account_email_address: str
    """

    _attribute_map = {
        "enabled": {"key": "enabled", "type": "bool"},
        "workload_identity_provider_id": {"key": "workloadIdentityProviderId", "type": "str"},
        "service_account_email_address": {"key": "serviceAccountEmailAddress", "type": "str"},
    }

    def __init__(
        self,
        *,
        enabled: Optional[bool] = None,
        workload_identity_provider_id: Optional[str] = None,
        service_account_email_address: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword enabled: Is Microsoft Defender container agentless discovery enabled.
        :paramtype enabled: bool
        :keyword workload_identity_provider_id: The workload identity provider id in GCP for this
         feature.
        :paramtype workload_identity_provider_id: str
        :keyword service_account_email_address: The service account email address in GCP for this
         feature.
        :paramtype service_account_email_address: str
        """
        super().__init__(**kwargs)
        self.enabled = enabled
        self.workload_identity_provider_id = workload_identity_provider_id
        self.service_account_email_address = service_account_email_address


class DefenderForContainersGcpOfferingMdcContainersImageAssessment(
    _serialization.Model
):  # pylint: disable=name-too-long
    """The Microsoft Defender Container image assessment configuration.

    :ivar enabled: Is Microsoft Defender container image assessment enabled.
    :vartype enabled: bool
    :ivar workload_identity_provider_id: The workload identity provider id in GCP for this feature.
    :vartype workload_identity_provider_id: str
    :ivar service_account_email_address: The service account email address in GCP for this feature.
    :vartype service_account_email_address: str
    """

    _attribute_map = {
        "enabled": {"key": "enabled", "type": "bool"},
        "workload_identity_provider_id": {"key": "workloadIdentityProviderId", "type": "str"},
        "service_account_email_address": {"key": "serviceAccountEmailAddress", "type": "str"},
    }

    def __init__(
        self,
        *,
        enabled: Optional[bool] = None,
        workload_identity_provider_id: Optional[str] = None,
        service_account_email_address: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword enabled: Is Microsoft Defender container image assessment enabled.
        :paramtype enabled: bool
        :keyword workload_identity_provider_id: The workload identity provider id in GCP for this
         feature.
        :paramtype workload_identity_provider_id: str
        :keyword service_account_email_address: The service account email address in GCP for this
         feature.
        :paramtype service_account_email_address: str
        """
        super().__init__(**kwargs)
        self.enabled = enabled
        self.workload_identity_provider_id = workload_identity_provider_id
        self.service_account_email_address = service_account_email_address


class DefenderForContainersGcpOfferingNativeCloudConnection(_serialization.Model):  # pylint: disable=name-too-long
    """The native cloud connection configuration.

    :ivar service_account_email_address: The service account email address in GCP for this
     offering.
    :vartype service_account_email_address: str
    :ivar workload_identity_provider_id: The GCP workload identity provider id for this offering.
    :vartype workload_identity_provider_id: str
    """

    _attribute_map = {
        "service_account_email_address": {"key": "serviceAccountEmailAddress", "type": "str"},
        "workload_identity_provider_id": {"key": "workloadIdentityProviderId", "type": "str"},
    }

    def __init__(
        self,
        *,
        service_account_email_address: Optional[str] = None,
        workload_identity_provider_id: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword service_account_email_address: The service account email address in GCP for this
         offering.
        :paramtype service_account_email_address: str
        :keyword workload_identity_provider_id: The GCP workload identity provider id for this
         offering.
        :paramtype workload_identity_provider_id: str
        """
        super().__init__(**kwargs)
        self.service_account_email_address = service_account_email_address
        self.workload_identity_provider_id = workload_identity_provider_id


class DefenderForDatabasesGcpOffering(CloudOffering):
    """The Defender for Databases GCP offering configurations.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar offering_type: The type of the security offering. Required. Known values are:
     "CspmMonitorAws", "DefenderForContainersAws", "DefenderForServersAws",
     "DefenderForDatabasesAws", "InformationProtectionAws", "CspmMonitorGcp", "CspmMonitorGithub",
     "CspmMonitorAzureDevOps", "DefenderForServersGcp", "DefenderForContainersGcp",
     "DefenderForDatabasesGcp", "DefenderCspmAws", "DefenderCspmGcp", "DefenderForDevOpsGithub",
     "DefenderForDevOpsAzureDevOps", "CspmMonitorGitLab", and "DefenderForDevOpsGitLab".
    :vartype offering_type: str or ~azure.mgmt.security.v2023_10_01_preview.models.OfferingType
    :ivar description: The offering description.
    :vartype description: str
    :ivar arc_auto_provisioning: The ARC autoprovisioning configuration.
    :vartype arc_auto_provisioning:
     ~azure.mgmt.security.v2023_10_01_preview.models.DefenderForDatabasesGcpOfferingArcAutoProvisioning
    :ivar defender_for_databases_arc_auto_provisioning: The native cloud connection configuration.
    :vartype defender_for_databases_arc_auto_provisioning:
     ~azure.mgmt.security.v2023_10_01_preview.models.DefenderForDatabasesGcpOfferingDefenderForDatabasesArcAutoProvisioning  # pylint: disable=line-too-long
    """

    _validation = {
        "offering_type": {"required": True},
        "description": {"readonly": True},
    }

    _attribute_map = {
        "offering_type": {"key": "offeringType", "type": "str"},
        "description": {"key": "description", "type": "str"},
        "arc_auto_provisioning": {
            "key": "arcAutoProvisioning",
            "type": "DefenderForDatabasesGcpOfferingArcAutoProvisioning",
        },
        "defender_for_databases_arc_auto_provisioning": {
            "key": "defenderForDatabasesArcAutoProvisioning",
            "type": "DefenderForDatabasesGcpOfferingDefenderForDatabasesArcAutoProvisioning",
        },
    }

    def __init__(
        self,
        *,
        arc_auto_provisioning: Optional["_models.DefenderForDatabasesGcpOfferingArcAutoProvisioning"] = None,
        defender_for_databases_arc_auto_provisioning: Optional[
            "_models.DefenderForDatabasesGcpOfferingDefenderForDatabasesArcAutoProvisioning"
        ] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword arc_auto_provisioning: The ARC autoprovisioning configuration.
        :paramtype arc_auto_provisioning:
         ~azure.mgmt.security.v2023_10_01_preview.models.DefenderForDatabasesGcpOfferingArcAutoProvisioning
        :keyword defender_for_databases_arc_auto_provisioning: The native cloud connection
         configuration.
        :paramtype defender_for_databases_arc_auto_provisioning:
         ~azure.mgmt.security.v2023_10_01_preview.models.DefenderForDatabasesGcpOfferingDefenderForDatabasesArcAutoProvisioning  # pylint: disable=line-too-long
        """
        super().__init__(**kwargs)
        self.offering_type: str = "DefenderForDatabasesGcp"
        self.arc_auto_provisioning = arc_auto_provisioning
        self.defender_for_databases_arc_auto_provisioning = defender_for_databases_arc_auto_provisioning


class DefenderForDatabasesGcpOfferingArcAutoProvisioning(_serialization.Model):  # pylint: disable=name-too-long
    """The ARC autoprovisioning configuration.

    :ivar enabled: Is arc auto provisioning enabled.
    :vartype enabled: bool
    :ivar configuration: Configuration for servers Arc auto provisioning.
    :vartype configuration:
     ~azure.mgmt.security.v2023_10_01_preview.models.DefenderForDatabasesGcpOfferingArcAutoProvisioningConfiguration
    """

    _attribute_map = {
        "enabled": {"key": "enabled", "type": "bool"},
        "configuration": {
            "key": "configuration",
            "type": "DefenderForDatabasesGcpOfferingArcAutoProvisioningConfiguration",
        },
    }

    def __init__(
        self,
        *,
        enabled: Optional[bool] = None,
        configuration: Optional["_models.DefenderForDatabasesGcpOfferingArcAutoProvisioningConfiguration"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword enabled: Is arc auto provisioning enabled.
        :paramtype enabled: bool
        :keyword configuration: Configuration for servers Arc auto provisioning.
        :paramtype configuration:
         ~azure.mgmt.security.v2023_10_01_preview.models.DefenderForDatabasesGcpOfferingArcAutoProvisioningConfiguration
        """
        super().__init__(**kwargs)
        self.enabled = enabled
        self.configuration = configuration


class DefenderForDatabasesGcpOfferingArcAutoProvisioningConfiguration(
    _serialization.Model
):  # pylint: disable=name-too-long
    """Configuration for servers Arc auto provisioning.

    :ivar proxy: Optional http proxy endpoint to use for the Arc agent.
    :vartype proxy: str
    :ivar private_link_scope: Optional Arc private link scope resource id to link the Arc agent.
    :vartype private_link_scope: str
    """

    _attribute_map = {
        "proxy": {"key": "proxy", "type": "str"},
        "private_link_scope": {"key": "privateLinkScope", "type": "str"},
    }

    def __init__(self, *, proxy: Optional[str] = None, private_link_scope: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword proxy: Optional http proxy endpoint to use for the Arc agent.
        :paramtype proxy: str
        :keyword private_link_scope: Optional Arc private link scope resource id to link the Arc agent.
        :paramtype private_link_scope: str
        """
        super().__init__(**kwargs)
        self.proxy = proxy
        self.private_link_scope = private_link_scope


class DefenderForDatabasesGcpOfferingDefenderForDatabasesArcAutoProvisioning(
    _serialization.Model
):  # pylint: disable=name-too-long
    """The native cloud connection configuration.

    :ivar service_account_email_address: The service account email address in GCP for this
     offering.
    :vartype service_account_email_address: str
    :ivar workload_identity_provider_id: The GCP workload identity provider id for this offering.
    :vartype workload_identity_provider_id: str
    """

    _attribute_map = {
        "service_account_email_address": {"key": "serviceAccountEmailAddress", "type": "str"},
        "workload_identity_provider_id": {"key": "workloadIdentityProviderId", "type": "str"},
    }

    def __init__(
        self,
        *,
        service_account_email_address: Optional[str] = None,
        workload_identity_provider_id: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword service_account_email_address: The service account email address in GCP for this
         offering.
        :paramtype service_account_email_address: str
        :keyword workload_identity_provider_id: The GCP workload identity provider id for this
         offering.
        :paramtype workload_identity_provider_id: str
        """
        super().__init__(**kwargs)
        self.service_account_email_address = service_account_email_address
        self.workload_identity_provider_id = workload_identity_provider_id


class DefenderForDevOpsAzureDevOpsOffering(CloudOffering):
    """The Defender for DevOps for Azure DevOps offering.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar offering_type: The type of the security offering. Required. Known values are:
     "CspmMonitorAws", "DefenderForContainersAws", "DefenderForServersAws",
     "DefenderForDatabasesAws", "InformationProtectionAws", "CspmMonitorGcp", "CspmMonitorGithub",
     "CspmMonitorAzureDevOps", "DefenderForServersGcp", "DefenderForContainersGcp",
     "DefenderForDatabasesGcp", "DefenderCspmAws", "DefenderCspmGcp", "DefenderForDevOpsGithub",
     "DefenderForDevOpsAzureDevOps", "CspmMonitorGitLab", and "DefenderForDevOpsGitLab".
    :vartype offering_type: str or ~azure.mgmt.security.v2023_10_01_preview.models.OfferingType
    :ivar description: The offering description.
    :vartype description: str
    """

    _validation = {
        "offering_type": {"required": True},
        "description": {"readonly": True},
    }

    _attribute_map = {
        "offering_type": {"key": "offeringType", "type": "str"},
        "description": {"key": "description", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.offering_type: str = "DefenderForDevOpsAzureDevOps"


class DefenderForDevOpsGithubOffering(CloudOffering):
    """The Defender for DevOps for Github offering.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar offering_type: The type of the security offering. Required. Known values are:
     "CspmMonitorAws", "DefenderForContainersAws", "DefenderForServersAws",
     "DefenderForDatabasesAws", "InformationProtectionAws", "CspmMonitorGcp", "CspmMonitorGithub",
     "CspmMonitorAzureDevOps", "DefenderForServersGcp", "DefenderForContainersGcp",
     "DefenderForDatabasesGcp", "DefenderCspmAws", "DefenderCspmGcp", "DefenderForDevOpsGithub",
     "DefenderForDevOpsAzureDevOps", "CspmMonitorGitLab", and "DefenderForDevOpsGitLab".
    :vartype offering_type: str or ~azure.mgmt.security.v2023_10_01_preview.models.OfferingType
    :ivar description: The offering description.
    :vartype description: str
    """

    _validation = {
        "offering_type": {"required": True},
        "description": {"readonly": True},
    }

    _attribute_map = {
        "offering_type": {"key": "offeringType", "type": "str"},
        "description": {"key": "description", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.offering_type: str = "DefenderForDevOpsGithub"


class DefenderForDevOpsGitLabOffering(CloudOffering):
    """The Defender for DevOps for Gitlab offering.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar offering_type: The type of the security offering. Required. Known values are:
     "CspmMonitorAws", "DefenderForContainersAws", "DefenderForServersAws",
     "DefenderForDatabasesAws", "InformationProtectionAws", "CspmMonitorGcp", "CspmMonitorGithub",
     "CspmMonitorAzureDevOps", "DefenderForServersGcp", "DefenderForContainersGcp",
     "DefenderForDatabasesGcp", "DefenderCspmAws", "DefenderCspmGcp", "DefenderForDevOpsGithub",
     "DefenderForDevOpsAzureDevOps", "CspmMonitorGitLab", and "DefenderForDevOpsGitLab".
    :vartype offering_type: str or ~azure.mgmt.security.v2023_10_01_preview.models.OfferingType
    :ivar description: The offering description.
    :vartype description: str
    """

    _validation = {
        "offering_type": {"required": True},
        "description": {"readonly": True},
    }

    _attribute_map = {
        "offering_type": {"key": "offeringType", "type": "str"},
        "description": {"key": "description", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.offering_type: str = "DefenderForDevOpsGitLab"


class DefenderForServersAwsOffering(CloudOffering):
    """The Defender for Servers AWS offering.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar offering_type: The type of the security offering. Required. Known values are:
     "CspmMonitorAws", "DefenderForContainersAws", "DefenderForServersAws",
     "DefenderForDatabasesAws", "InformationProtectionAws", "CspmMonitorGcp", "CspmMonitorGithub",
     "CspmMonitorAzureDevOps", "DefenderForServersGcp", "DefenderForContainersGcp",
     "DefenderForDatabasesGcp", "DefenderCspmAws", "DefenderCspmGcp", "DefenderForDevOpsGithub",
     "DefenderForDevOpsAzureDevOps", "CspmMonitorGitLab", and "DefenderForDevOpsGitLab".
    :vartype offering_type: str or ~azure.mgmt.security.v2023_10_01_preview.models.OfferingType
    :ivar description: The offering description.
    :vartype description: str
    :ivar defender_for_servers: The Defender for servers connection configuration.
    :vartype defender_for_servers:
     ~azure.mgmt.security.v2023_10_01_preview.models.DefenderForServersAwsOfferingDefenderForServers
    :ivar arc_auto_provisioning: The ARC autoprovisioning configuration.
    :vartype arc_auto_provisioning:
     ~azure.mgmt.security.v2023_10_01_preview.models.DefenderForServersAwsOfferingArcAutoProvisioning
    :ivar va_auto_provisioning: The Vulnerability Assessment autoprovisioning configuration.
    :vartype va_auto_provisioning:
     ~azure.mgmt.security.v2023_10_01_preview.models.DefenderForServersAwsOfferingVaAutoProvisioning
    :ivar mde_auto_provisioning: The Microsoft Defender for Endpoint autoprovisioning
     configuration.
    :vartype mde_auto_provisioning:
     ~azure.mgmt.security.v2023_10_01_preview.models.DefenderForServersAwsOfferingMdeAutoProvisioning
    :ivar sub_plan: configuration for the servers offering subPlan.
    :vartype sub_plan:
     ~azure.mgmt.security.v2023_10_01_preview.models.DefenderForServersAwsOfferingSubPlan
    :ivar vm_scanners: The Microsoft Defender for Server VM scanning configuration.
    :vartype vm_scanners:
     ~azure.mgmt.security.v2023_10_01_preview.models.DefenderForServersAwsOfferingVmScanners
    """

    _validation = {
        "offering_type": {"required": True},
        "description": {"readonly": True},
    }

    _attribute_map = {
        "offering_type": {"key": "offeringType", "type": "str"},
        "description": {"key": "description", "type": "str"},
        "defender_for_servers": {
            "key": "defenderForServers",
            "type": "DefenderForServersAwsOfferingDefenderForServers",
        },
        "arc_auto_provisioning": {
            "key": "arcAutoProvisioning",
            "type": "DefenderForServersAwsOfferingArcAutoProvisioning",
        },
        "va_auto_provisioning": {
            "key": "vaAutoProvisioning",
            "type": "DefenderForServersAwsOfferingVaAutoProvisioning",
        },
        "mde_auto_provisioning": {
            "key": "mdeAutoProvisioning",
            "type": "DefenderForServersAwsOfferingMdeAutoProvisioning",
        },
        "sub_plan": {"key": "subPlan", "type": "DefenderForServersAwsOfferingSubPlan"},
        "vm_scanners": {"key": "vmScanners", "type": "DefenderForServersAwsOfferingVmScanners"},
    }

    def __init__(
        self,
        *,
        defender_for_servers: Optional["_models.DefenderForServersAwsOfferingDefenderForServers"] = None,
        arc_auto_provisioning: Optional["_models.DefenderForServersAwsOfferingArcAutoProvisioning"] = None,
        va_auto_provisioning: Optional["_models.DefenderForServersAwsOfferingVaAutoProvisioning"] = None,
        mde_auto_provisioning: Optional["_models.DefenderForServersAwsOfferingMdeAutoProvisioning"] = None,
        sub_plan: Optional["_models.DefenderForServersAwsOfferingSubPlan"] = None,
        vm_scanners: Optional["_models.DefenderForServersAwsOfferingVmScanners"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword defender_for_servers: The Defender for servers connection configuration.
        :paramtype defender_for_servers:
         ~azure.mgmt.security.v2023_10_01_preview.models.DefenderForServersAwsOfferingDefenderForServers
        :keyword arc_auto_provisioning: The ARC autoprovisioning configuration.
        :paramtype arc_auto_provisioning:
         ~azure.mgmt.security.v2023_10_01_preview.models.DefenderForServersAwsOfferingArcAutoProvisioning
        :keyword va_auto_provisioning: The Vulnerability Assessment autoprovisioning configuration.
        :paramtype va_auto_provisioning:
         ~azure.mgmt.security.v2023_10_01_preview.models.DefenderForServersAwsOfferingVaAutoProvisioning
        :keyword mde_auto_provisioning: The Microsoft Defender for Endpoint autoprovisioning
         configuration.
        :paramtype mde_auto_provisioning:
         ~azure.mgmt.security.v2023_10_01_preview.models.DefenderForServersAwsOfferingMdeAutoProvisioning
        :keyword sub_plan: configuration for the servers offering subPlan.
        :paramtype sub_plan:
         ~azure.mgmt.security.v2023_10_01_preview.models.DefenderForServersAwsOfferingSubPlan
        :keyword vm_scanners: The Microsoft Defender for Server VM scanning configuration.
        :paramtype vm_scanners:
         ~azure.mgmt.security.v2023_10_01_preview.models.DefenderForServersAwsOfferingVmScanners
        """
        super().__init__(**kwargs)
        self.offering_type: str = "DefenderForServersAws"
        self.defender_for_servers = defender_for_servers
        self.arc_auto_provisioning = arc_auto_provisioning
        self.va_auto_provisioning = va_auto_provisioning
        self.mde_auto_provisioning = mde_auto_provisioning
        self.sub_plan = sub_plan
        self.vm_scanners = vm_scanners


class DefenderForServersAwsOfferingArcAutoProvisioning(_serialization.Model):  # pylint: disable=name-too-long
    """The ARC autoprovisioning configuration.

    :ivar enabled: Is arc auto provisioning enabled.
    :vartype enabled: bool
    :ivar cloud_role_arn: The cloud role ARN in AWS for this feature.
    :vartype cloud_role_arn: str
    :ivar configuration: Configuration for servers Arc auto provisioning.
    :vartype configuration:
     ~azure.mgmt.security.v2023_10_01_preview.models.DefenderForServersAwsOfferingArcAutoProvisioningConfiguration
    """

    _attribute_map = {
        "enabled": {"key": "enabled", "type": "bool"},
        "cloud_role_arn": {"key": "cloudRoleArn", "type": "str"},
        "configuration": {
            "key": "configuration",
            "type": "DefenderForServersAwsOfferingArcAutoProvisioningConfiguration",
        },
    }

    def __init__(
        self,
        *,
        enabled: Optional[bool] = None,
        cloud_role_arn: Optional[str] = None,
        configuration: Optional["_models.DefenderForServersAwsOfferingArcAutoProvisioningConfiguration"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword enabled: Is arc auto provisioning enabled.
        :paramtype enabled: bool
        :keyword cloud_role_arn: The cloud role ARN in AWS for this feature.
        :paramtype cloud_role_arn: str
        :keyword configuration: Configuration for servers Arc auto provisioning.
        :paramtype configuration:
         ~azure.mgmt.security.v2023_10_01_preview.models.DefenderForServersAwsOfferingArcAutoProvisioningConfiguration
        """
        super().__init__(**kwargs)
        self.enabled = enabled
        self.cloud_role_arn = cloud_role_arn
        self.configuration = configuration


class DefenderForServersAwsOfferingArcAutoProvisioningConfiguration(
    _serialization.Model
):  # pylint: disable=name-too-long
    """Configuration for servers Arc auto provisioning.

    :ivar proxy: Optional HTTP proxy endpoint to use for the Arc agent.
    :vartype proxy: str
    :ivar private_link_scope: Optional Arc private link scope resource id to link the Arc agent.
    :vartype private_link_scope: str
    """

    _attribute_map = {
        "proxy": {"key": "proxy", "type": "str"},
        "private_link_scope": {"key": "privateLinkScope", "type": "str"},
    }

    def __init__(self, *, proxy: Optional[str] = None, private_link_scope: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword proxy: Optional HTTP proxy endpoint to use for the Arc agent.
        :paramtype proxy: str
        :keyword private_link_scope: Optional Arc private link scope resource id to link the Arc agent.
        :paramtype private_link_scope: str
        """
        super().__init__(**kwargs)
        self.proxy = proxy
        self.private_link_scope = private_link_scope


class DefenderForServersAwsOfferingDefenderForServers(_serialization.Model):  # pylint: disable=name-too-long
    """The Defender for servers connection configuration.

    :ivar cloud_role_arn: The cloud role ARN in AWS for this feature.
    :vartype cloud_role_arn: str
    """

    _attribute_map = {
        "cloud_role_arn": {"key": "cloudRoleArn", "type": "str"},
    }

    def __init__(self, *, cloud_role_arn: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword cloud_role_arn: The cloud role ARN in AWS for this feature.
        :paramtype cloud_role_arn: str
        """
        super().__init__(**kwargs)
        self.cloud_role_arn = cloud_role_arn


class DefenderForServersAwsOfferingMdeAutoProvisioning(_serialization.Model):  # pylint: disable=name-too-long
    """The Microsoft Defender for Endpoint autoprovisioning configuration.

    :ivar enabled: Is Microsoft Defender for Endpoint auto provisioning enabled.
    :vartype enabled: bool
    :ivar configuration: configuration for Microsoft Defender for Endpoint autoprovisioning.
    :vartype configuration: JSON
    """

    _attribute_map = {
        "enabled": {"key": "enabled", "type": "bool"},
        "configuration": {"key": "configuration", "type": "object"},
    }

    def __init__(self, *, enabled: Optional[bool] = None, configuration: Optional[JSON] = None, **kwargs: Any) -> None:
        """
        :keyword enabled: Is Microsoft Defender for Endpoint auto provisioning enabled.
        :paramtype enabled: bool
        :keyword configuration: configuration for Microsoft Defender for Endpoint autoprovisioning.
        :paramtype configuration: JSON
        """
        super().__init__(**kwargs)
        self.enabled = enabled
        self.configuration = configuration


class DefenderForServersAwsOfferingSubPlan(_serialization.Model):
    """configuration for the servers offering subPlan.

    :ivar type: The available sub plans. Known values are: "P1" and "P2".
    :vartype type: str or ~azure.mgmt.security.v2023_10_01_preview.models.SubPlan
    """

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
    }

    def __init__(self, *, type: Optional[Union[str, "_models.SubPlan"]] = None, **kwargs: Any) -> None:
        """
        :keyword type: The available sub plans. Known values are: "P1" and "P2".
        :paramtype type: str or ~azure.mgmt.security.v2023_10_01_preview.models.SubPlan
        """
        super().__init__(**kwargs)
        self.type = type


class DefenderForServersAwsOfferingVaAutoProvisioning(_serialization.Model):  # pylint: disable=name-too-long
    """The Vulnerability Assessment autoprovisioning configuration.

    :ivar enabled: Is Vulnerability Assessment auto provisioning enabled.
    :vartype enabled: bool
    :ivar configuration: configuration for Vulnerability Assessment autoprovisioning.
    :vartype configuration:
     ~azure.mgmt.security.v2023_10_01_preview.models.DefenderForServersAwsOfferingVaAutoProvisioningConfiguration
    """

    _attribute_map = {
        "enabled": {"key": "enabled", "type": "bool"},
        "configuration": {
            "key": "configuration",
            "type": "DefenderForServersAwsOfferingVaAutoProvisioningConfiguration",
        },
    }

    def __init__(
        self,
        *,
        enabled: Optional[bool] = None,
        configuration: Optional["_models.DefenderForServersAwsOfferingVaAutoProvisioningConfiguration"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword enabled: Is Vulnerability Assessment auto provisioning enabled.
        :paramtype enabled: bool
        :keyword configuration: configuration for Vulnerability Assessment autoprovisioning.
        :paramtype configuration:
         ~azure.mgmt.security.v2023_10_01_preview.models.DefenderForServersAwsOfferingVaAutoProvisioningConfiguration
        """
        super().__init__(**kwargs)
        self.enabled = enabled
        self.configuration = configuration


class DefenderForServersAwsOfferingVaAutoProvisioningConfiguration(
    _serialization.Model
):  # pylint: disable=name-too-long
    """configuration for Vulnerability Assessment autoprovisioning.

    :ivar type: The Vulnerability Assessment solution to be provisioned. Can be either 'TVM' or
     'Qualys'. Known values are: "Qualys" and "TVM".
    :vartype type: str or ~azure.mgmt.security.v2023_10_01_preview.models.Type
    """

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
    }

    def __init__(self, *, type: Optional[Union[str, "_models.Type"]] = None, **kwargs: Any) -> None:
        """
        :keyword type: The Vulnerability Assessment solution to be provisioned. Can be either 'TVM' or
         'Qualys'. Known values are: "Qualys" and "TVM".
        :paramtype type: str or ~azure.mgmt.security.v2023_10_01_preview.models.Type
        """
        super().__init__(**kwargs)
        self.type = type


class DefenderForServersAwsOfferingVmScanners(_serialization.Model):
    """The Microsoft Defender for Server VM scanning configuration.

    :ivar enabled: Is Microsoft Defender for Server VM scanning enabled.
    :vartype enabled: bool
    :ivar configuration: configuration for Microsoft Defender for Server VM scanning.
    :vartype configuration:
     ~azure.mgmt.security.v2023_10_01_preview.models.DefenderForServersAwsOfferingVmScannersConfiguration
    """

    _attribute_map = {
        "enabled": {"key": "enabled", "type": "bool"},
        "configuration": {"key": "configuration", "type": "DefenderForServersAwsOfferingVmScannersConfiguration"},
    }

    def __init__(
        self,
        *,
        enabled: Optional[bool] = None,
        configuration: Optional["_models.DefenderForServersAwsOfferingVmScannersConfiguration"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword enabled: Is Microsoft Defender for Server VM scanning enabled.
        :paramtype enabled: bool
        :keyword configuration: configuration for Microsoft Defender for Server VM scanning.
        :paramtype configuration:
         ~azure.mgmt.security.v2023_10_01_preview.models.DefenderForServersAwsOfferingVmScannersConfiguration
        """
        super().__init__(**kwargs)
        self.enabled = enabled
        self.configuration = configuration


class DefenderForServersAwsOfferingVmScannersConfiguration(_serialization.Model):  # pylint: disable=name-too-long
    """configuration for Microsoft Defender for Server VM scanning.

    :ivar cloud_role_arn: The cloud role ARN in AWS for this feature.
    :vartype cloud_role_arn: str
    :ivar scanning_mode: The scanning mode for the VM scan. "Default"
    :vartype scanning_mode: str or ~azure.mgmt.security.v2023_10_01_preview.models.ScanningMode
    :ivar exclusion_tags: VM tags that indicates that VM should not be scanned.
    :vartype exclusion_tags: dict[str, str]
    """

    _attribute_map = {
        "cloud_role_arn": {"key": "cloudRoleArn", "type": "str"},
        "scanning_mode": {"key": "scanningMode", "type": "str"},
        "exclusion_tags": {"key": "exclusionTags", "type": "{str}"},
    }

    def __init__(
        self,
        *,
        cloud_role_arn: Optional[str] = None,
        scanning_mode: Optional[Union[str, "_models.ScanningMode"]] = None,
        exclusion_tags: Optional[Dict[str, str]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword cloud_role_arn: The cloud role ARN in AWS for this feature.
        :paramtype cloud_role_arn: str
        :keyword scanning_mode: The scanning mode for the VM scan. "Default"
        :paramtype scanning_mode: str or ~azure.mgmt.security.v2023_10_01_preview.models.ScanningMode
        :keyword exclusion_tags: VM tags that indicates that VM should not be scanned.
        :paramtype exclusion_tags: dict[str, str]
        """
        super().__init__(**kwargs)
        self.cloud_role_arn = cloud_role_arn
        self.scanning_mode = scanning_mode
        self.exclusion_tags = exclusion_tags


class DefenderForServersGcpOffering(CloudOffering):
    """The Defender for Servers GCP offering configurations.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar offering_type: The type of the security offering. Required. Known values are:
     "CspmMonitorAws", "DefenderForContainersAws", "DefenderForServersAws",
     "DefenderForDatabasesAws", "InformationProtectionAws", "CspmMonitorGcp", "CspmMonitorGithub",
     "CspmMonitorAzureDevOps", "DefenderForServersGcp", "DefenderForContainersGcp",
     "DefenderForDatabasesGcp", "DefenderCspmAws", "DefenderCspmGcp", "DefenderForDevOpsGithub",
     "DefenderForDevOpsAzureDevOps", "CspmMonitorGitLab", and "DefenderForDevOpsGitLab".
    :vartype offering_type: str or ~azure.mgmt.security.v2023_10_01_preview.models.OfferingType
    :ivar description: The offering description.
    :vartype description: str
    :ivar defender_for_servers: The Defender for servers connection configuration.
    :vartype defender_for_servers:
     ~azure.mgmt.security.v2023_10_01_preview.models.DefenderForServersGcpOfferingDefenderForServers
    :ivar arc_auto_provisioning: The ARC autoprovisioning configuration.
    :vartype arc_auto_provisioning:
     ~azure.mgmt.security.v2023_10_01_preview.models.DefenderForServersGcpOfferingArcAutoProvisioning
    :ivar va_auto_provisioning: The Vulnerability Assessment autoprovisioning configuration.
    :vartype va_auto_provisioning:
     ~azure.mgmt.security.v2023_10_01_preview.models.DefenderForServersGcpOfferingVaAutoProvisioning
    :ivar mde_auto_provisioning: The Microsoft Defender for Endpoint autoprovisioning
     configuration.
    :vartype mde_auto_provisioning:
     ~azure.mgmt.security.v2023_10_01_preview.models.DefenderForServersGcpOfferingMdeAutoProvisioning
    :ivar sub_plan: configuration for the servers offering subPlan.
    :vartype sub_plan:
     ~azure.mgmt.security.v2023_10_01_preview.models.DefenderForServersGcpOfferingSubPlan
    :ivar vm_scanners: The Microsoft Defender for Server VM scanning configuration.
    :vartype vm_scanners:
     ~azure.mgmt.security.v2023_10_01_preview.models.DefenderForServersGcpOfferingVmScanners
    """

    _validation = {
        "offering_type": {"required": True},
        "description": {"readonly": True},
    }

    _attribute_map = {
        "offering_type": {"key": "offeringType", "type": "str"},
        "description": {"key": "description", "type": "str"},
        "defender_for_servers": {
            "key": "defenderForServers",
            "type": "DefenderForServersGcpOfferingDefenderForServers",
        },
        "arc_auto_provisioning": {
            "key": "arcAutoProvisioning",
            "type": "DefenderForServersGcpOfferingArcAutoProvisioning",
        },
        "va_auto_provisioning": {
            "key": "vaAutoProvisioning",
            "type": "DefenderForServersGcpOfferingVaAutoProvisioning",
        },
        "mde_auto_provisioning": {
            "key": "mdeAutoProvisioning",
            "type": "DefenderForServersGcpOfferingMdeAutoProvisioning",
        },
        "sub_plan": {"key": "subPlan", "type": "DefenderForServersGcpOfferingSubPlan"},
        "vm_scanners": {"key": "vmScanners", "type": "DefenderForServersGcpOfferingVmScanners"},
    }

    def __init__(
        self,
        *,
        defender_for_servers: Optional["_models.DefenderForServersGcpOfferingDefenderForServers"] = None,
        arc_auto_provisioning: Optional["_models.DefenderForServersGcpOfferingArcAutoProvisioning"] = None,
        va_auto_provisioning: Optional["_models.DefenderForServersGcpOfferingVaAutoProvisioning"] = None,
        mde_auto_provisioning: Optional["_models.DefenderForServersGcpOfferingMdeAutoProvisioning"] = None,
        sub_plan: Optional["_models.DefenderForServersGcpOfferingSubPlan"] = None,
        vm_scanners: Optional["_models.DefenderForServersGcpOfferingVmScanners"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword defender_for_servers: The Defender for servers connection configuration.
        :paramtype defender_for_servers:
         ~azure.mgmt.security.v2023_10_01_preview.models.DefenderForServersGcpOfferingDefenderForServers
        :keyword arc_auto_provisioning: The ARC autoprovisioning configuration.
        :paramtype arc_auto_provisioning:
         ~azure.mgmt.security.v2023_10_01_preview.models.DefenderForServersGcpOfferingArcAutoProvisioning
        :keyword va_auto_provisioning: The Vulnerability Assessment autoprovisioning configuration.
        :paramtype va_auto_provisioning:
         ~azure.mgmt.security.v2023_10_01_preview.models.DefenderForServersGcpOfferingVaAutoProvisioning
        :keyword mde_auto_provisioning: The Microsoft Defender for Endpoint autoprovisioning
         configuration.
        :paramtype mde_auto_provisioning:
         ~azure.mgmt.security.v2023_10_01_preview.models.DefenderForServersGcpOfferingMdeAutoProvisioning
        :keyword sub_plan: configuration for the servers offering subPlan.
        :paramtype sub_plan:
         ~azure.mgmt.security.v2023_10_01_preview.models.DefenderForServersGcpOfferingSubPlan
        :keyword vm_scanners: The Microsoft Defender for Server VM scanning configuration.
        :paramtype vm_scanners:
         ~azure.mgmt.security.v2023_10_01_preview.models.DefenderForServersGcpOfferingVmScanners
        """
        super().__init__(**kwargs)
        self.offering_type: str = "DefenderForServersGcp"
        self.defender_for_servers = defender_for_servers
        self.arc_auto_provisioning = arc_auto_provisioning
        self.va_auto_provisioning = va_auto_provisioning
        self.mde_auto_provisioning = mde_auto_provisioning
        self.sub_plan = sub_plan
        self.vm_scanners = vm_scanners


class DefenderForServersGcpOfferingArcAutoProvisioning(_serialization.Model):  # pylint: disable=name-too-long
    """The ARC autoprovisioning configuration.

    :ivar enabled: Is arc auto provisioning enabled.
    :vartype enabled: bool
    :ivar configuration: Configuration for servers Arc auto provisioning.
    :vartype configuration:
     ~azure.mgmt.security.v2023_10_01_preview.models.DefenderForServersGcpOfferingArcAutoProvisioningConfiguration
    """

    _attribute_map = {
        "enabled": {"key": "enabled", "type": "bool"},
        "configuration": {
            "key": "configuration",
            "type": "DefenderForServersGcpOfferingArcAutoProvisioningConfiguration",
        },
    }

    def __init__(
        self,
        *,
        enabled: Optional[bool] = None,
        configuration: Optional["_models.DefenderForServersGcpOfferingArcAutoProvisioningConfiguration"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword enabled: Is arc auto provisioning enabled.
        :paramtype enabled: bool
        :keyword configuration: Configuration for servers Arc auto provisioning.
        :paramtype configuration:
         ~azure.mgmt.security.v2023_10_01_preview.models.DefenderForServersGcpOfferingArcAutoProvisioningConfiguration
        """
        super().__init__(**kwargs)
        self.enabled = enabled
        self.configuration = configuration


class DefenderForServersGcpOfferingArcAutoProvisioningConfiguration(
    _serialization.Model
):  # pylint: disable=name-too-long
    """Configuration for servers Arc auto provisioning.

    :ivar proxy: Optional HTTP proxy endpoint to use for the Arc agent.
    :vartype proxy: str
    :ivar private_link_scope: Optional Arc private link scope resource id to link the Arc agent.
    :vartype private_link_scope: str
    """

    _attribute_map = {
        "proxy": {"key": "proxy", "type": "str"},
        "private_link_scope": {"key": "privateLinkScope", "type": "str"},
    }

    def __init__(self, *, proxy: Optional[str] = None, private_link_scope: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword proxy: Optional HTTP proxy endpoint to use for the Arc agent.
        :paramtype proxy: str
        :keyword private_link_scope: Optional Arc private link scope resource id to link the Arc agent.
        :paramtype private_link_scope: str
        """
        super().__init__(**kwargs)
        self.proxy = proxy
        self.private_link_scope = private_link_scope


class DefenderForServersGcpOfferingDefenderForServers(_serialization.Model):  # pylint: disable=name-too-long
    """The Defender for servers connection configuration.

    :ivar workload_identity_provider_id: The workload identity provider id in GCP for this feature.
    :vartype workload_identity_provider_id: str
    :ivar service_account_email_address: The service account email address in GCP for this feature.
    :vartype service_account_email_address: str
    """

    _attribute_map = {
        "workload_identity_provider_id": {"key": "workloadIdentityProviderId", "type": "str"},
        "service_account_email_address": {"key": "serviceAccountEmailAddress", "type": "str"},
    }

    def __init__(
        self,
        *,
        workload_identity_provider_id: Optional[str] = None,
        service_account_email_address: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword workload_identity_provider_id: The workload identity provider id in GCP for this
         feature.
        :paramtype workload_identity_provider_id: str
        :keyword service_account_email_address: The service account email address in GCP for this
         feature.
        :paramtype service_account_email_address: str
        """
        super().__init__(**kwargs)
        self.workload_identity_provider_id = workload_identity_provider_id
        self.service_account_email_address = service_account_email_address


class DefenderForServersGcpOfferingMdeAutoProvisioning(_serialization.Model):  # pylint: disable=name-too-long
    """The Microsoft Defender for Endpoint autoprovisioning configuration.

    :ivar enabled: Is Microsoft Defender for Endpoint auto provisioning enabled.
    :vartype enabled: bool
    :ivar configuration: configuration for Microsoft Defender for Endpoint autoprovisioning.
    :vartype configuration: JSON
    """

    _attribute_map = {
        "enabled": {"key": "enabled", "type": "bool"},
        "configuration": {"key": "configuration", "type": "object"},
    }

    def __init__(self, *, enabled: Optional[bool] = None, configuration: Optional[JSON] = None, **kwargs: Any) -> None:
        """
        :keyword enabled: Is Microsoft Defender for Endpoint auto provisioning enabled.
        :paramtype enabled: bool
        :keyword configuration: configuration for Microsoft Defender for Endpoint autoprovisioning.
        :paramtype configuration: JSON
        """
        super().__init__(**kwargs)
        self.enabled = enabled
        self.configuration = configuration


class DefenderForServersGcpOfferingSubPlan(_serialization.Model):
    """configuration for the servers offering subPlan.

    :ivar type: The available sub plans. Known values are: "P1" and "P2".
    :vartype type: str or ~azure.mgmt.security.v2023_10_01_preview.models.SubPlan
    """

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
    }

    def __init__(self, *, type: Optional[Union[str, "_models.SubPlan"]] = None, **kwargs: Any) -> None:
        """
        :keyword type: The available sub plans. Known values are: "P1" and "P2".
        :paramtype type: str or ~azure.mgmt.security.v2023_10_01_preview.models.SubPlan
        """
        super().__init__(**kwargs)
        self.type = type


class DefenderForServersGcpOfferingVaAutoProvisioning(_serialization.Model):  # pylint: disable=name-too-long
    """The Vulnerability Assessment autoprovisioning configuration.

    :ivar enabled: Is Vulnerability Assessment auto provisioning enabled.
    :vartype enabled: bool
    :ivar configuration: configuration for Vulnerability Assessment autoprovisioning.
    :vartype configuration:
     ~azure.mgmt.security.v2023_10_01_preview.models.DefenderForServersGcpOfferingVaAutoProvisioningConfiguration
    """

    _attribute_map = {
        "enabled": {"key": "enabled", "type": "bool"},
        "configuration": {
            "key": "configuration",
            "type": "DefenderForServersGcpOfferingVaAutoProvisioningConfiguration",
        },
    }

    def __init__(
        self,
        *,
        enabled: Optional[bool] = None,
        configuration: Optional["_models.DefenderForServersGcpOfferingVaAutoProvisioningConfiguration"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword enabled: Is Vulnerability Assessment auto provisioning enabled.
        :paramtype enabled: bool
        :keyword configuration: configuration for Vulnerability Assessment autoprovisioning.
        :paramtype configuration:
         ~azure.mgmt.security.v2023_10_01_preview.models.DefenderForServersGcpOfferingVaAutoProvisioningConfiguration
        """
        super().__init__(**kwargs)
        self.enabled = enabled
        self.configuration = configuration


class DefenderForServersGcpOfferingVaAutoProvisioningConfiguration(
    _serialization.Model
):  # pylint: disable=name-too-long
    """configuration for Vulnerability Assessment autoprovisioning.

    :ivar type: The Vulnerability Assessment solution to be provisioned. Can be either 'TVM' or
     'Qualys'. Known values are: "Qualys" and "TVM".
    :vartype type: str or ~azure.mgmt.security.v2023_10_01_preview.models.Type
    """

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
    }

    def __init__(self, *, type: Optional[Union[str, "_models.Type"]] = None, **kwargs: Any) -> None:
        """
        :keyword type: The Vulnerability Assessment solution to be provisioned. Can be either 'TVM' or
         'Qualys'. Known values are: "Qualys" and "TVM".
        :paramtype type: str or ~azure.mgmt.security.v2023_10_01_preview.models.Type
        """
        super().__init__(**kwargs)
        self.type = type


class DefenderForServersGcpOfferingVmScanners(_serialization.Model):
    """The Microsoft Defender for Server VM scanning configuration.

    :ivar enabled: Is Microsoft Defender for Server VM scanning enabled.
    :vartype enabled: bool
    :ivar configuration: configuration for Microsoft Defender for Server VM scanning.
    :vartype configuration:
     ~azure.mgmt.security.v2023_10_01_preview.models.DefenderForServersGcpOfferingVmScannersConfiguration
    """

    _attribute_map = {
        "enabled": {"key": "enabled", "type": "bool"},
        "configuration": {"key": "configuration", "type": "DefenderForServersGcpOfferingVmScannersConfiguration"},
    }

    def __init__(
        self,
        *,
        enabled: Optional[bool] = None,
        configuration: Optional["_models.DefenderForServersGcpOfferingVmScannersConfiguration"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword enabled: Is Microsoft Defender for Server VM scanning enabled.
        :paramtype enabled: bool
        :keyword configuration: configuration for Microsoft Defender for Server VM scanning.
        :paramtype configuration:
         ~azure.mgmt.security.v2023_10_01_preview.models.DefenderForServersGcpOfferingVmScannersConfiguration
        """
        super().__init__(**kwargs)
        self.enabled = enabled
        self.configuration = configuration


class DefenderForServersGcpOfferingVmScannersConfiguration(_serialization.Model):  # pylint: disable=name-too-long
    """configuration for Microsoft Defender for Server VM scanning.

    :ivar scanning_mode: The scanning mode for the VM scan. "Default"
    :vartype scanning_mode: str or ~azure.mgmt.security.v2023_10_01_preview.models.ScanningMode
    :ivar exclusion_tags: VM tags that indicate that VM should not be scanned.
    :vartype exclusion_tags: dict[str, str]
    """

    _attribute_map = {
        "scanning_mode": {"key": "scanningMode", "type": "str"},
        "exclusion_tags": {"key": "exclusionTags", "type": "{str}"},
    }

    def __init__(
        self,
        *,
        scanning_mode: Optional[Union[str, "_models.ScanningMode"]] = None,
        exclusion_tags: Optional[Dict[str, str]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword scanning_mode: The scanning mode for the VM scan. "Default"
        :paramtype scanning_mode: str or ~azure.mgmt.security.v2023_10_01_preview.models.ScanningMode
        :keyword exclusion_tags: VM tags that indicate that VM should not be scanned.
        :paramtype exclusion_tags: dict[str, str]
        """
        super().__init__(**kwargs)
        self.scanning_mode = scanning_mode
        self.exclusion_tags = exclusion_tags


class ErrorAdditionalInfo(_serialization.Model):
    """The resource management error additional info.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar type: The additional info type.
    :vartype type: str
    :ivar info: The additional info.
    :vartype info: JSON
    """

    _validation = {
        "type": {"readonly": True},
        "info": {"readonly": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "info": {"key": "info", "type": "object"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.type = None
        self.info = None


class ETag(_serialization.Model):
    """Entity tag is used for comparing two or more entities from the same requested resource.

    :ivar etag: Entity tag is used for comparing two or more entities from the same requested
     resource.
    :vartype etag: str
    """

    _attribute_map = {
        "etag": {"key": "etag", "type": "str"},
    }

    def __init__(self, *, etag: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword etag: Entity tag is used for comparing two or more entities from the same requested
         resource.
        :paramtype etag: str
        """
        super().__init__(**kwargs)
        self.etag = etag


class GcpOrganizationalData(_serialization.Model):
    """The gcpOrganization data.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    GcpOrganizationalDataMember, GcpOrganizationalDataOrganization

    All required parameters must be populated in order to send to server.

    :ivar organization_membership_type: The multi cloud account's membership type in the
     organization. Required. Known values are: "Member" and "Organization".
    :vartype organization_membership_type: str or
     ~azure.mgmt.security.v2023_10_01_preview.models.OrganizationMembershipType
    """

    _validation = {
        "organization_membership_type": {"required": True},
    }

    _attribute_map = {
        "organization_membership_type": {"key": "organizationMembershipType", "type": "str"},
    }

    _subtype_map = {
        "organization_membership_type": {
            "Member": "GcpOrganizationalDataMember",
            "Organization": "GcpOrganizationalDataOrganization",
        }
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.organization_membership_type: Optional[str] = None


class GcpOrganizationalDataMember(GcpOrganizationalData):
    """The gcpOrganization data for the member account.

    All required parameters must be populated in order to send to server.

    :ivar organization_membership_type: The multi cloud account's membership type in the
     organization. Required. Known values are: "Member" and "Organization".
    :vartype organization_membership_type: str or
     ~azure.mgmt.security.v2023_10_01_preview.models.OrganizationMembershipType
    :ivar parent_hierarchy_id: If the multi cloud account is not of membership type organization,
     this will be the ID of the project's parent.
    :vartype parent_hierarchy_id: str
    :ivar management_project_number: The GCP management project number from organizational
     onboarding.
    :vartype management_project_number: str
    """

    _validation = {
        "organization_membership_type": {"required": True},
    }

    _attribute_map = {
        "organization_membership_type": {"key": "organizationMembershipType", "type": "str"},
        "parent_hierarchy_id": {"key": "parentHierarchyId", "type": "str"},
        "management_project_number": {"key": "managementProjectNumber", "type": "str"},
    }

    def __init__(
        self,
        *,
        parent_hierarchy_id: Optional[str] = None,
        management_project_number: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword parent_hierarchy_id: If the multi cloud account is not of membership type
         organization, this will be the ID of the project's parent.
        :paramtype parent_hierarchy_id: str
        :keyword management_project_number: The GCP management project number from organizational
         onboarding.
        :paramtype management_project_number: str
        """
        super().__init__(**kwargs)
        self.organization_membership_type: str = "Member"
        self.parent_hierarchy_id = parent_hierarchy_id
        self.management_project_number = management_project_number


class GcpOrganizationalDataOrganization(GcpOrganizationalData):
    """The gcpOrganization data for the parent account.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar organization_membership_type: The multi cloud account's membership type in the
     organization. Required. Known values are: "Member" and "Organization".
    :vartype organization_membership_type: str or
     ~azure.mgmt.security.v2023_10_01_preview.models.OrganizationMembershipType
    :ivar excluded_project_numbers: If the multi cloud account is of membership type organization,
     list of accounts excluded from offering.
    :vartype excluded_project_numbers: list[str]
    :ivar service_account_email_address: The service account email address which represents the
     organization level permissions container.
    :vartype service_account_email_address: str
    :ivar workload_identity_provider_id: The GCP workload identity provider id which represents the
     permissions required to auto provision security connectors.
    :vartype workload_identity_provider_id: str
    :ivar organization_name: GCP organization name.
    :vartype organization_name: str
    """

    _validation = {
        "organization_membership_type": {"required": True},
        "organization_name": {"readonly": True},
    }

    _attribute_map = {
        "organization_membership_type": {"key": "organizationMembershipType", "type": "str"},
        "excluded_project_numbers": {"key": "excludedProjectNumbers", "type": "[str]"},
        "service_account_email_address": {"key": "serviceAccountEmailAddress", "type": "str"},
        "workload_identity_provider_id": {"key": "workloadIdentityProviderId", "type": "str"},
        "organization_name": {"key": "organizationName", "type": "str"},
    }

    def __init__(
        self,
        *,
        excluded_project_numbers: Optional[List[str]] = None,
        service_account_email_address: Optional[str] = None,
        workload_identity_provider_id: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword excluded_project_numbers: If the multi cloud account is of membership type
         organization, list of accounts excluded from offering.
        :paramtype excluded_project_numbers: list[str]
        :keyword service_account_email_address: The service account email address which represents the
         organization level permissions container.
        :paramtype service_account_email_address: str
        :keyword workload_identity_provider_id: The GCP workload identity provider id which represents
         the permissions required to auto provision security connectors.
        :paramtype workload_identity_provider_id: str
        """
        super().__init__(**kwargs)
        self.organization_membership_type: str = "Organization"
        self.excluded_project_numbers = excluded_project_numbers
        self.service_account_email_address = service_account_email_address
        self.workload_identity_provider_id = workload_identity_provider_id
        self.organization_name = None


class GcpProjectDetails(_serialization.Model):
    """The details about the project represented by the security connector.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar project_number: The unique GCP Project number.
    :vartype project_number: str
    :ivar project_id: The GCP Project id.
    :vartype project_id: str
    :ivar workload_identity_pool_id: The GCP workload identity federation pool id.
    :vartype workload_identity_pool_id: str
    :ivar project_name: GCP project name.
    :vartype project_name: str
    """

    _validation = {
        "workload_identity_pool_id": {"readonly": True},
        "project_name": {"readonly": True},
    }

    _attribute_map = {
        "project_number": {"key": "projectNumber", "type": "str"},
        "project_id": {"key": "projectId", "type": "str"},
        "workload_identity_pool_id": {"key": "workloadIdentityPoolId", "type": "str"},
        "project_name": {"key": "projectName", "type": "str"},
    }

    def __init__(
        self, *, project_number: Optional[str] = None, project_id: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword project_number: The unique GCP Project number.
        :paramtype project_number: str
        :keyword project_id: The GCP Project id.
        :paramtype project_id: str
        """
        super().__init__(**kwargs)
        self.project_number = project_number
        self.project_id = project_id
        self.workload_identity_pool_id = None
        self.project_name = None


class GcpProjectEnvironmentData(EnvironmentData):
    """The GCP project connector environment data.

    All required parameters must be populated in order to send to server.

    :ivar environment_type: The type of the environment data. Required. Known values are:
     "AwsAccount", "GcpProject", "GithubScope", "AzureDevOpsScope", and "GitlabScope".
    :vartype environment_type: str or
     ~azure.mgmt.security.v2023_10_01_preview.models.EnvironmentType
    :ivar organizational_data: The Gcp project's organizational data.
    :vartype organizational_data:
     ~azure.mgmt.security.v2023_10_01_preview.models.GcpOrganizationalData
    :ivar project_details: The Gcp project's details.
    :vartype project_details: ~azure.mgmt.security.v2023_10_01_preview.models.GcpProjectDetails
    :ivar scan_interval: Scan interval in hours (value should be between 1-hour to 24-hours).
    :vartype scan_interval: int
    """

    _validation = {
        "environment_type": {"required": True},
    }

    _attribute_map = {
        "environment_type": {"key": "environmentType", "type": "str"},
        "organizational_data": {"key": "organizationalData", "type": "GcpOrganizationalData"},
        "project_details": {"key": "projectDetails", "type": "GcpProjectDetails"},
        "scan_interval": {"key": "scanInterval", "type": "int"},
    }

    def __init__(
        self,
        *,
        organizational_data: Optional["_models.GcpOrganizationalData"] = None,
        project_details: Optional["_models.GcpProjectDetails"] = None,
        scan_interval: Optional[int] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword organizational_data: The Gcp project's organizational data.
        :paramtype organizational_data:
         ~azure.mgmt.security.v2023_10_01_preview.models.GcpOrganizationalData
        :keyword project_details: The Gcp project's details.
        :paramtype project_details: ~azure.mgmt.security.v2023_10_01_preview.models.GcpProjectDetails
        :keyword scan_interval: Scan interval in hours (value should be between 1-hour to 24-hours).
        :paramtype scan_interval: int
        """
        super().__init__(**kwargs)
        self.environment_type: str = "GcpProject"
        self.organizational_data = organizational_data
        self.project_details = project_details
        self.scan_interval = scan_interval


class GithubScopeEnvironmentData(EnvironmentData):
    """The github scope connector's environment data.

    All required parameters must be populated in order to send to server.

    :ivar environment_type: The type of the environment data. Required. Known values are:
     "AwsAccount", "GcpProject", "GithubScope", "AzureDevOpsScope", and "GitlabScope".
    :vartype environment_type: str or
     ~azure.mgmt.security.v2023_10_01_preview.models.EnvironmentType
    """

    _validation = {
        "environment_type": {"required": True},
    }

    _attribute_map = {
        "environment_type": {"key": "environmentType", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.environment_type: str = "GithubScope"


class GitlabScopeEnvironmentData(EnvironmentData):
    """The GitLab scope connector's environment data.

    All required parameters must be populated in order to send to server.

    :ivar environment_type: The type of the environment data. Required. Known values are:
     "AwsAccount", "GcpProject", "GithubScope", "AzureDevOpsScope", and "GitlabScope".
    :vartype environment_type: str or
     ~azure.mgmt.security.v2023_10_01_preview.models.EnvironmentType
    """

    _validation = {
        "environment_type": {"required": True},
    }

    _attribute_map = {
        "environment_type": {"key": "environmentType", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.environment_type: str = "GitlabScope"


class InformationProtectionAwsOffering(CloudOffering):
    """The information protection for AWS offering.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar offering_type: The type of the security offering. Required. Known values are:
     "CspmMonitorAws", "DefenderForContainersAws", "DefenderForServersAws",
     "DefenderForDatabasesAws", "InformationProtectionAws", "CspmMonitorGcp", "CspmMonitorGithub",
     "CspmMonitorAzureDevOps", "DefenderForServersGcp", "DefenderForContainersGcp",
     "DefenderForDatabasesGcp", "DefenderCspmAws", "DefenderCspmGcp", "DefenderForDevOpsGithub",
     "DefenderForDevOpsAzureDevOps", "CspmMonitorGitLab", and "DefenderForDevOpsGitLab".
    :vartype offering_type: str or ~azure.mgmt.security.v2023_10_01_preview.models.OfferingType
    :ivar description: The offering description.
    :vartype description: str
    :ivar information_protection: The native cloud connection configuration.
    :vartype information_protection:
     ~azure.mgmt.security.v2023_10_01_preview.models.InformationProtectionAwsOfferingInformationProtection
    """

    _validation = {
        "offering_type": {"required": True},
        "description": {"readonly": True},
    }

    _attribute_map = {
        "offering_type": {"key": "offeringType", "type": "str"},
        "description": {"key": "description", "type": "str"},
        "information_protection": {
            "key": "informationProtection",
            "type": "InformationProtectionAwsOfferingInformationProtection",
        },
    }

    def __init__(
        self,
        *,
        information_protection: Optional["_models.InformationProtectionAwsOfferingInformationProtection"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword information_protection: The native cloud connection configuration.
        :paramtype information_protection:
         ~azure.mgmt.security.v2023_10_01_preview.models.InformationProtectionAwsOfferingInformationProtection
        """
        super().__init__(**kwargs)
        self.offering_type: str = "InformationProtectionAws"
        self.information_protection = information_protection


class InformationProtectionAwsOfferingInformationProtection(_serialization.Model):  # pylint: disable=name-too-long
    """The native cloud connection configuration.

    :ivar cloud_role_arn: The cloud role ARN in AWS for this feature.
    :vartype cloud_role_arn: str
    """

    _attribute_map = {
        "cloud_role_arn": {"key": "cloudRoleArn", "type": "str"},
    }

    def __init__(self, *, cloud_role_arn: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword cloud_role_arn: The cloud role ARN in AWS for this feature.
        :paramtype cloud_role_arn: str
        """
        super().__init__(**kwargs)
        self.cloud_role_arn = cloud_role_arn


class Kind(_serialization.Model):
    """Describes an Azure resource with kind.

    :ivar kind: Kind of the resource.
    :vartype kind: str
    """

    _attribute_map = {
        "kind": {"key": "kind", "type": "str"},
    }

    def __init__(self, *, kind: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword kind: Kind of the resource.
        :paramtype kind: str
        """
        super().__init__(**kwargs)
        self.kind = kind


class Resource(_serialization.Model):
    """Describes an Azure resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None


class Tags(_serialization.Model):
    """A list of key value pairs that describe the resource.

    :ivar tags: A list of key value pairs that describe the resource.
    :vartype tags: dict[str, str]
    """

    _attribute_map = {
        "tags": {"key": "tags", "type": "{str}"},
    }

    def __init__(self, *, tags: Optional[Dict[str, str]] = None, **kwargs: Any) -> None:
        """
        :keyword tags: A list of key value pairs that describe the resource.
        :paramtype tags: dict[str, str]
        """
        super().__init__(**kwargs)
        self.tags = tags


class TrackedResource(Resource, AzureTrackedResourceLocation, Kind, ETag, Tags):
    """Describes an Azure tracked resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar tags: A list of key value pairs that describe the resource.
    :vartype tags: dict[str, str]
    :ivar etag: Entity tag is used for comparing two or more entities from the same requested
     resource.
    :vartype etag: str
    :ivar kind: Kind of the resource.
    :vartype kind: str
    :ivar location: Location where the resource is stored.
    :vartype location: str
    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "tags": {"key": "tags", "type": "{str}"},
        "etag": {"key": "etag", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        etag: Optional[str] = None,
        kind: Optional[str] = None,
        location: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tags: A list of key value pairs that describe the resource.
        :paramtype tags: dict[str, str]
        :keyword etag: Entity tag is used for comparing two or more entities from the same requested
         resource.
        :paramtype etag: str
        :keyword kind: Kind of the resource.
        :paramtype kind: str
        :keyword location: Location where the resource is stored.
        :paramtype location: str
        """
        super().__init__(location=location, kind=kind, etag=etag, tags=tags, **kwargs)
        self.tags = tags
        self.etag = etag
        self.kind = kind
        self.location = location
        self.id = None
        self.name = None
        self.type = None


class SecurityConnector(TrackedResource):  # pylint: disable=too-many-instance-attributes
    """The security connector resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar tags: A list of key value pairs that describe the resource.
    :vartype tags: dict[str, str]
    :ivar etag: Entity tag is used for comparing two or more entities from the same requested
     resource.
    :vartype etag: str
    :ivar kind: Kind of the resource.
    :vartype kind: str
    :ivar location: Location where the resource is stored.
    :vartype location: str
    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.security.v2023_10_01_preview.models.SystemData
    :ivar hierarchy_identifier: The multi cloud resource identifier (account id in case of AWS
     connector, project number in case of GCP connector).
    :vartype hierarchy_identifier: str
    :ivar hierarchy_identifier_trial_end_date: The date on which the trial period will end, if
     applicable. Trial period exists for 30 days after upgrading to payed offerings.
    :vartype hierarchy_identifier_trial_end_date: ~datetime.datetime
    :ivar environment_name: The multi cloud resource's cloud name. Known values are: "Azure",
     "AWS", "GCP", "Github", "AzureDevOps", and "GitLab".
    :vartype environment_name: str or ~azure.mgmt.security.v2023_10_01_preview.models.CloudName
    :ivar offerings: A collection of offerings for the security connector.
    :vartype offerings: list[~azure.mgmt.security.v2023_10_01_preview.models.CloudOffering]
    :ivar environment_data: The security connector environment data.
    :vartype environment_data: ~azure.mgmt.security.v2023_10_01_preview.models.EnvironmentData
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "hierarchy_identifier_trial_end_date": {"readonly": True},
    }

    _attribute_map = {
        "tags": {"key": "tags", "type": "{str}"},
        "etag": {"key": "etag", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "hierarchy_identifier": {"key": "properties.hierarchyIdentifier", "type": "str"},
        "hierarchy_identifier_trial_end_date": {
            "key": "properties.hierarchyIdentifierTrialEndDate",
            "type": "iso-8601",
        },
        "environment_name": {"key": "properties.environmentName", "type": "str"},
        "offerings": {"key": "properties.offerings", "type": "[CloudOffering]"},
        "environment_data": {"key": "properties.environmentData", "type": "EnvironmentData"},
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        etag: Optional[str] = None,
        kind: Optional[str] = None,
        location: Optional[str] = None,
        hierarchy_identifier: Optional[str] = None,
        environment_name: Optional[Union[str, "_models.CloudName"]] = None,
        offerings: Optional[List["_models.CloudOffering"]] = None,
        environment_data: Optional["_models.EnvironmentData"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tags: A list of key value pairs that describe the resource.
        :paramtype tags: dict[str, str]
        :keyword etag: Entity tag is used for comparing two or more entities from the same requested
         resource.
        :paramtype etag: str
        :keyword kind: Kind of the resource.
        :paramtype kind: str
        :keyword location: Location where the resource is stored.
        :paramtype location: str
        :keyword hierarchy_identifier: The multi cloud resource identifier (account id in case of AWS
         connector, project number in case of GCP connector).
        :paramtype hierarchy_identifier: str
        :keyword environment_name: The multi cloud resource's cloud name. Known values are: "Azure",
         "AWS", "GCP", "Github", "AzureDevOps", and "GitLab".
        :paramtype environment_name: str or ~azure.mgmt.security.v2023_10_01_preview.models.CloudName
        :keyword offerings: A collection of offerings for the security connector.
        :paramtype offerings: list[~azure.mgmt.security.v2023_10_01_preview.models.CloudOffering]
        :keyword environment_data: The security connector environment data.
        :paramtype environment_data: ~azure.mgmt.security.v2023_10_01_preview.models.EnvironmentData
        """
        super().__init__(tags=tags, etag=etag, kind=kind, location=location, **kwargs)
        self.system_data = None
        self.hierarchy_identifier = hierarchy_identifier
        self.hierarchy_identifier_trial_end_date = None
        self.environment_name = environment_name
        self.offerings = offerings
        self.environment_data = environment_data


class SecurityConnectorsList(_serialization.Model):
    """List of security connectors response.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar value: The list of security connectors under the given scope. Required.
    :vartype value: list[~azure.mgmt.security.v2023_10_01_preview.models.SecurityConnector]
    :ivar next_link: The URI to fetch the next page.
    :vartype next_link: str
    """

    _validation = {
        "value": {"required": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[SecurityConnector]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: List["_models.SecurityConnector"], **kwargs: Any) -> None:
        """
        :keyword value: The list of security connectors under the given scope. Required.
        :paramtype value: list[~azure.mgmt.security.v2023_10_01_preview.models.SecurityConnector]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = None


class SystemData(_serialization.Model):
    """Metadata pertaining to creation and last modification of the resource.

    :ivar created_by: The identity that created the resource.
    :vartype created_by: str
    :ivar created_by_type: The type of identity that created the resource. Known values are:
     "User", "Application", "ManagedIdentity", and "Key".
    :vartype created_by_type: str or ~azure.mgmt.security.v2023_10_01_preview.models.CreatedByType
    :ivar created_at: The timestamp of resource creation (UTC).
    :vartype created_at: ~datetime.datetime
    :ivar last_modified_by: The identity that last modified the resource.
    :vartype last_modified_by: str
    :ivar last_modified_by_type: The type of identity that last modified the resource. Known values
     are: "User", "Application", "ManagedIdentity", and "Key".
    :vartype last_modified_by_type: str or
     ~azure.mgmt.security.v2023_10_01_preview.models.CreatedByType
    :ivar last_modified_at: The timestamp of resource last modification (UTC).
    :vartype last_modified_at: ~datetime.datetime
    """

    _attribute_map = {
        "created_by": {"key": "createdBy", "type": "str"},
        "created_by_type": {"key": "createdByType", "type": "str"},
        "created_at": {"key": "createdAt", "type": "iso-8601"},
        "last_modified_by": {"key": "lastModifiedBy", "type": "str"},
        "last_modified_by_type": {"key": "lastModifiedByType", "type": "str"},
        "last_modified_at": {"key": "lastModifiedAt", "type": "iso-8601"},
    }

    def __init__(
        self,
        *,
        created_by: Optional[str] = None,
        created_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        created_at: Optional[datetime.datetime] = None,
        last_modified_by: Optional[str] = None,
        last_modified_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        last_modified_at: Optional[datetime.datetime] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword created_by: The identity that created the resource.
        :paramtype created_by: str
        :keyword created_by_type: The type of identity that created the resource. Known values are:
         "User", "Application", "ManagedIdentity", and "Key".
        :paramtype created_by_type: str or
         ~azure.mgmt.security.v2023_10_01_preview.models.CreatedByType
        :keyword created_at: The timestamp of resource creation (UTC).
        :paramtype created_at: ~datetime.datetime
        :keyword last_modified_by: The identity that last modified the resource.
        :paramtype last_modified_by: str
        :keyword last_modified_by_type: The type of identity that last modified the resource. Known
         values are: "User", "Application", "ManagedIdentity", and "Key".
        :paramtype last_modified_by_type: str or
         ~azure.mgmt.security.v2023_10_01_preview.models.CreatedByType
        :keyword last_modified_at: The timestamp of resource last modification (UTC).
        :paramtype last_modified_at: ~datetime.datetime
        """
        super().__init__(**kwargs)
        self.created_by = created_by
        self.created_by_type = created_by_type
        self.created_at = created_at
        self.last_modified_by = last_modified_by
        self.last_modified_by_type = last_modified_by_type
        self.last_modified_at = last_modified_at
