"""
Lookup tables for AIS status messages
"""

NAV_STATUS = {
  0: 'under way using engine',
  1: 'at anchor',
  2: 'not under command',
  3: 'restricted maneuverability',
  4: 'constrained by draught',
  5: 'moored',
  6: 'aground',
  7: 'engaged in fishing',
  8: 'under way sailing',
  9: 'reserved for hazmat',
  10: 'reserved DG, HS, or MP',  # Dangerous goods, Harmful substances or marine polutants
  11: 'reserved',
  12: 'reserved',
  13: 'reserved',
  14: 'reserved',
  15: 'UNKNOWN',
}

TYPE_AND_CARGO = {
  20: 'Wing in ground (WIG), all ships of this type',
  21: 'Wing in ground (WIG), Hazardous cat A',
  22: 'Wing in ground (WIG), Hazardous cat B',
  23: 'Wing in ground (WIG), Hazardous cat C',
  24: 'Wing in ground (WIG), Hazardous cat D',
  25: 'Wing in ground (WIG), Reserved',
  26: 'Wing in ground (WIG), Reserved',
  27: 'Wing in ground (WIG), Reserved',
  28: 'Wing in ground (WIG), Reserved',
  29: 'Wing in ground (WIG), No info',
  30: 'fishing',
  31: 'towing',
  32: 'towing length exceeds 200m or breadth exceeds 25m',
  33: 'dredging or underwater ops',
  34: 'diving ops',
  35: 'military ops',
  36: 'sailing',
  37: 'pleasure craft',
  38: 'reserved',
  39: 'reserved',
  40: 'High speed craft (HSC), all ships of this type',
  41: 'High speed craft (HSC), Hazardous cat A',
  42: 'High speed craft (HSC), Hazardous cat B',
  43: 'High speed craft (HSC), Hazardous cat C',
  44: 'High speed craft (HSC), Hazardous cat D',
  45: 'High speed craft (HSC), Reserved',
  46: 'High speed craft (HSC), Reserved',
  47: 'High speed craft (HSC), Reserved',
  48: 'High speed craft (HSC), Reserved',
  49: 'High speed craft (HSC), No additional information',
  50: 'pilot vessel',
  51: 'search and rescue vessel',
  52: 'tug',
  53: 'port tender',
  54: 'anti-polution equipment',
  55: 'law enforcement',
  56: 'spare - local vessel',
  57: 'spare - local vessel',
  58: 'medical transport',
  59: 'ship according to RR Resolution No. 18',
  60: 'passenger, all ships of this type',
  61: 'passenger, Hazardous cat A',
  62: 'passenger, Hazardous cat B',
  63: 'passenger, Hazardous cat C',
  64: 'passenger, Hazardous cat D',
  65: 'passenger, Reserved',
  66: 'passenger, Reserved',
  67: 'passenger, Reserved',
  68: 'passenger, Reserved',
  69: 'passenger, No additional information',
  70: 'cargo, all ships of this type',
  71: 'cargo, Hazardous cat A',
  72: 'cargo, Hazardous cat B',
  73: 'cargo, Hazardous cat C',
  74: 'cargo, Hazardous cat D',
  75: 'cargo, Reserved',
  76: 'cargo, Reserved',
  77: 'cargo, Reserved',
  78: 'cargo, Reserved',
  79: 'cargo, No additional information',
  80: 'tanker, all ships of this type',
  81: 'tanker, Hazardous cat A',
  82: 'tanker, Hazardous cat B',
  83: 'tanker, Hazardous cat C',
  84: 'tanker, Hazardous cat D',
  85: 'tanker, Reserved',
  86: 'tanker, Reserved',
  87: 'tanker, Reserved',
  88: 'tanker, Reserved',
  89: 'tanker, No additional information',
  90: 'other type, all ships of this type',
  91: 'other type, Hazardous cat A',
  92: 'other type, Hazardous cat B',
  93: 'other type, Hazardous cat C',
  94: 'other type, Hazardous cat D',
  95: 'other type, Reserved',
  96: 'other type, Reserved',
  97: 'other type, Reserved',
  98: 'other type, Reserved',
  99: 'other type, No additional information',
}
