#!/usr/bin/env gnuplot

#set terminal gif transparent
#set output "benchmark.gif"

set title "Benchmarks of Various Priority-Queue Implementations"

set xlabel "Number of Insertions/Extractions"
set ylabel "CPU Time"

set xrange [*:50000]
set yrange [*:40]

set grid

plot 'benchmark.results' using 1:2 smooth csplines title 'PQueue Insertion' with lines, \
	'benchmark.results' using 1:3 smooth csplines title 'PQueue Extraction' with lines, \
	'benchmark.results' using 1:4 smooth csplines title 'PQ0 Insertion' with lines, \
	'benchmark.results' using 1:5 smooth csplines title 'PQ0 Extraction' with lines, \
	'benchmark.results' using 1:6 smooth csplines title 'pq3.PQueue Insertion' with lines, \
	'benchmark.results' using 1:7 smooth csplines title 'pq3.PQueue Extraction' with lines, \
	'benchmark.results' using 1:8 smooth csplines title 'PQEquivBig Insertion' with lines, \
	'benchmark.results' using 1:9 smooth csplines title 'PQEquivBig Extraction' with lines, \
	'benchmark.results' using 1:2 notitle with points, \
	'benchmark.results' using 1:3 notitle with points, \
	'benchmark.results' using 1:4 notitle with points, \
	'benchmark.results' using 1:5 notitle with points, \
	'benchmark.results' using 1:6 notitle with points, \
	'benchmark.results' using 1:7 notitle with points, \
	'benchmark.results' using 1:8 notitle with points, \
	'benchmark.results' using 1:9 notitle with points

pause -1 "Hit <enter> to continue."

# End.
