/***************************************************************************
 *   Copyright (C) 2007 by Anistratov Oleg                                 *
 *   ower86@gmail.com                                                      *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License version 2        *
 *   as published by the Free Software Foundation;                         *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 ***************************************************************************/
#include "textformattingwgt.h"

#include <QGridLayout>
#include <QMenuBar>

TextFormattingWgt::TextFormattingWgt(QWidget *parent)
 : QWidget(parent)
{
  QGridLayout* grid = new QGridLayout(this);


  (m_setBoldAct       = new QToolButton(this))->setCheckable(true);
  (m_setItalicAct     = new QToolButton(this))->setCheckable(true);
  (m_setUnderlinedAct = new QToolButton(this))->setCheckable(true);

  grid->addWidget(m_setBoldAct, 0, 0);
  grid->addWidget(m_setItalicAct, 0, 1);
  grid->addWidget(m_setUnderlinedAct, 0, 2);

  connect(m_setBoldAct, SIGNAL(clicked(bool)), this, SIGNAL(wantSetBold(bool)));
  connect(m_setItalicAct, SIGNAL(clicked(bool)), this, SIGNAL(wantSetItalic(bool)));
  connect(m_setUnderlinedAct, SIGNAL(clicked(bool)), this, SIGNAL(wantSetUnderlined(bool)));
}


TextFormattingWgt::~TextFormattingWgt()
{
}


