/***************************************************************************
 *   Copyright (C) 2000-2008 by Johan Maes                                 *
 *   on4qz@telenet.be                                                      *
 *   http://users.telenet.be/on4qz                                         *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
 
 
#ifndef LSOUNDCARD_H
#define LSOUNDCARD_H
#include <QThread>


#include <sys/soundcard.h>
#include <qobject.h>
#include <qstring.h>

#include <qsemaphore.h>

/** \file */
/** length in bytes of the audioBuffer */
#define AUDIOBUFFERSIZE 2048

#define BUFFER32K 0x8000

/** size of inputbuffer */
#define INPUTBUFFERLEN BUFFER32K
#define INPUTINDEXMASK (BUFFER32K-1)
/** size of outputbuffer */
#define OUTPUTBUFFERLEN BUFFER32K 
#define OUTPUTINDEXMASK (BUFFER32K-1)


enum edataSrc{SNDIN,SNDFILEIN,SNDINTOFILE};
enum edataDst{SNDOUT,SNDFILEOUT};

class wavIO;
class QTimer;

//! structure describing the interface to /dev/dsp
struct dspstruct
  {
    int fdDSP;                      //!< filedescriptor for /dev/dsp
    unsigned int speed;             //!< sampling rate
    int channels;                   //!< 1=mono, 2=stereo
    int format;                     //!< AFMT_S16_LE (16-Bits) or AFMT_U8 (8-bits samples)
    unsigned int fragSize;          //!< Size of one fragment to process
    unsigned int numFrags;          //!< number of fragments
    unsigned int buffLen;           //!< length of the buffer
    unsigned int caps;              //!< Soundcard driver capabilities
    char * pbuffer;                 //!< DMA buffer. note: caddr_t = char *
  };


/** \class  soundcard
		\brief functions for soundcard support
		\author Johan Maes
	
	Create an instance of soundcard. Call the startReceive, startTransmit() or startFullDuplex() function to initialize the soundcard in the appropriate mode. Then call the start function to start the thread.

*/
class soundcard:public QThread
//class soundcard
{

 public:
	enum esoundStatus {SND_IDLE,SND_READ,SND_WRITE,SND_READWRITE,SND_STOP,SND_DELAYED_STOP};
  soundcard(int i_samplingRate=11025);
  ~soundcard();
	virtual void run();
  void setSamplingrate(int s);
  bool startReceive(const char *s,QString &errorString);
  bool startTransmit(const char *s,QString &errorString);
  bool startFullDuplex(const char *s,QString &errorString);
  void stop();
  int waitEnd();
	/** abort the thread */
	void abort();
	uint inputDataAvailable(uint ri);
	uint outputDataFree();
	bool getData(short int *buf,uint &ri,uint len, uint &samplesRead);

  int audioBufferLen; //!< length in bytes of the audioBuffer
  int fragmentLatency; //!< latency while reading/writing to soundcard
	void setSrc(edataSrc s);
	void setDst(edataDst d);
	void setWaveFile(wavIO *wv);
	void writeSample(short int sample);
	void flush();
	esoundStatus getStatus() {return status;}

private:
	
  esoundStatus status;
  struct dspstruct dspInfo;
	bool setParam(int format, int fragsize,int channels,QString &errorString);
	short int inputBuffer[INPUTBUFFERLEN];
	short int outputBuffer[OUTPUTBUFFERLEN];
	bool abortRun;
	bool read();
	bool write();
	uint writeInputIndex;
	uint readInputIndex;
	uint readOutputIndex;
	uint writeOutputIndex;
	wavIO *wave;
	edataSrc ioSrc;
	edataDst	ioDst;
	bool endOfFile;
	QSemaphore *sndSema;
	uint wIndex; //!< short temp index for write samples
	uint localReadIndex;
	bool flushed;
	audio_buf_info info;
	int numberOfBuffers;
};

#endif










