// Copyright 2009 the Sputnik authors.  All rights reserved.
// This code is governed by the BSD license found in the LICENSE file.

/**
 * Math.exp, recommended that implementations use the approximation algorithms for IEEE 754 arithmetic contained in fdlibm
 *
 * @path ch15/15.8/15.8.2/15.8.2.8/S15.8.2.8_A6.js
 * @description Checking if Math.exp is approximately equals to its mathematical values on the set of 64 argument values; all the sample values is calculated with LibC
 */

$INCLUDE("math_precision.js");
$INCLUDE("math_isequal.js");

// CHECK#1
vnum = 64;
var x = new Array();
x[0] = -16.00000000000000000000;
x[1] = -15.49206349206349200000;
x[2] = -14.98412698412698400000;
x[3] = -14.47619047619047600000;
x[4] = -13.96825396825396800000;
x[5] = -13.46031746031746000000;
x[6] = -12.95238095238095300000;
x[7] = -12.44444444444444500000;
x[8] = -11.93650793650793700000;
x[9] = -11.42857142857142900000;
x[10] = -10.92063492063492100000;
x[11] = -10.41269841269841300000;
x[12] = -9.90476190476190510000;
x[13] = -9.39682539682539720000;
x[14] = -8.88888888888888930000;
x[15] = -8.38095238095238140000;
x[16] = -7.87301587301587350000;
x[17] = -7.36507936507936560000;
x[18] = -6.85714285714285770000;
x[19] = -6.34920634920634970000;
x[20] = -5.84126984126984180000;
x[21] = -5.33333333333333390000;
x[22] = -4.82539682539682600000;
x[23] = -4.31746031746031810000;
x[24] = -3.80952380952381020000;
x[25] = -3.30158730158730230000;
x[26] = -2.79365079365079440000;
x[27] = -2.28571428571428650000;
x[28] = -1.77777777777777860000;
x[29] = -1.26984126984127070000;
x[30] = -0.76190476190476275000;
x[31] = -0.25396825396825484000;
x[32] = 0.25396825396825307000;
x[33] = 0.76190476190476275000;
x[34] = 1.26984126984126890000;
x[35] = 1.77777777777777860000;
x[36] = 2.28571428571428470000;
x[37] = 2.79365079365079440000;
x[38] = 3.30158730158730050000;
x[39] = 3.80952380952381020000;
x[40] = 4.31746031746031630000;
x[41] = 4.82539682539682600000;
x[42] = 5.33333333333333210000;
x[43] = 5.84126984126984180000;
x[44] = 6.34920634920634800000;
x[45] = 6.85714285714285770000;
x[46] = 7.36507936507936380000;
x[47] = 7.87301587301587350000;
x[48] = 8.38095238095237960000;
x[49] = 8.88888888888888930000;
x[50] = 9.39682539682539540000;
x[51] = 9.90476190476190510000;
x[52] = 10.41269841269841100000;
x[53] = 10.92063492063492100000;
x[54] = 11.42857142857142700000;
x[55] = 11.93650793650793700000;
x[56] = 12.44444444444444300000;
x[57] = 12.95238095238095300000;
x[58] = 13.46031746031745900000;
x[59] = 13.96825396825396800000;
x[60] = 14.47619047619047400000;
x[61] = 14.98412698412698400000;
x[62] = 15.49206349206349000000;
x[63] = 16.00000000000000000000;



var y = new Array();
y[0] = 0.0000001125351747192591200;
y[1] = 0.0000001870175279627160400;
y[2] = 0.0000003107966540465112000;
y[3] = 0.0000005165000372893601900;
y[4] = 0.0000008583499373194266000;
y[5] = 0.000001426456073000250500;
y[6] = 0.000002370568039596737700;
y[7] = 0.000003939548463303105900;
y[8] = 0.000006546971795567619300;
y[9] = 0.00001088014022196331600;
y[10] = 0.00001808125266855845500;
y[11] = 0.00003004848204109428100;
y[12] = 0.00004993632297081056800;
y[13] = 0.00008298709893014922600;
y[14] = 0.0001379128093365619200;
y[15] = 0.0002291915638009238700;
y[16] = 0.0003808839307255494700;
y[17] = 0.0006329751683659501200;
y[18] = 0.001051915114939835700;
y[19] = 0.001748133993779607700;
y[20] = 0.002905151201656255000;
y[21] = 0.004827949993831437100;
y[22] = 0.008023369361859111100;
y[23] = 0.01333370395283075800;
y[24] = 0.02215872822045164600;
y[25] = 0.03682466913056056000;
y[26] = 0.06119738655956222900;
y[27] = 0.1017013923042267600;
y[28] = 0.1690133154060659600;
y[29] = 0.2808762017642814100;
y[30] = 0.4667764816516809500;
y[31] = 0.7757164275739275600;
y[32] = 1.289130878828392400;
y[33] = 2.142353009006615400;
y[34] = 3.560287392519015300;
y[35] = 5.916693590664334800;
y[36] = 9.832707078469738300;
y[37] = 16.340567076777361000;
y[38] = 27.155709029035226000;
y[39] = 45.128943775619703000;
y[40] = 74.997915323273489000;
y[41] = 124.635917268588530000;
y[42] = 207.127248889834330000;
y[43] = 344.216163148372520000;
y[44] = 572.038529974419700000;
y[45] = 950.647049174870860000;
y[46] = 1579.840805732611900000;
y[47] = 2625.471749609100700000;
y[48] = 4363.162340777078500000;
y[49] = 7250.958085841060000000;
y[50] = 12050.065767953940000000;
y[51] = 20025.503291152076000000;
y[52] = 33279.551314186152000000;
y[53] = 55305.902656783459000000;
y[54] = 91910.580157904318000000;
y[55] = 152742.371775148380000000;
y[56] = 253836.197045168550000000;
y[57] = 421839.822058054970000000;
y[58] = 701038.061338060300000000;
y[59] = 1165026.006902193900000000;
y[60] = 1936108.282291886200000000;
y[61] = 3217537.856280616000000000;
y[62] = 5347092.386973262800000000;
y[63] = 8886110.520507872100000000;



var val;
for (i = 0; i < vnum; i++)
{
	val = Math.exp(x[i]);
	if (!isEqual(val, y[i]))
	{
		$ERROR("\nx = " + x[i] + "\nlibc.exp(x) = " + y[i] + "\nMath.exp(x) = " + Math.exp(x[i]) + "\nMath.abs(libc.exp(x) - Math.exp(x)) > " + prec + "\n\n"); 
	}
}

