/****************************************************************************
**
** Copyright (C) 2010 Nokia Corporation and/or its subsidiary(-ies).
** All rights reserved.
** Contact: Nokia Corporation (qt-info@nokia.com)
**
** This file is part of the plugins of the Qt Toolkit.
**
** $QT_BEGIN_LICENSE:LGPL$
** No Commercial Usage
** This file contains pre-release code and may not be distributed.
** You may use this file in accordance with the terms and conditions
** contained in the Technology Preview License Agreement accompanying
** this package.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 2.1 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL included in the
** packaging of this file.  Please review the following information to
** ensure the GNU Lesser General Public License version 2.1 requirements
** will be met: http://www.gnu.org/licenses/old-licenses/lgpl-2.1.html.
**
** In addition, as a special exception, Nokia gives you certain additional
** rights.  These rights are described in the Nokia Qt LGPL Exception
** version 1.1, included in the file LGPL_EXCEPTION.txt in this package.
**
** If you have questions regarding the use of this file, please contact
** Nokia at qt-info@nokia.com.
**
**
**
**
**
**
**
**
** $QT_END_LICENSE$
**
****************************************************************************/

#include "uaocodec.h"

QT_BEGIN_NAMESPACE

#ifndef QT_NO_TEXTCODEC

#define InRange(c, lower, upper)  (((c) >= (lower)) && ((c) <= (upper)))
#define IsLatin(c)        ((c) < 0x80)
#define IsFirstByte(c)        (InRange((c), 0x81, 0xFE))
#define IsSecondByteRange1(c)        (InRange((c), 0x40, 0x7E))
#define IsSecondByteRange2(c)        (InRange((c), 0xA1, 0xFE))
#define IsSecondByte(c)        (IsSecondByteRange1(c) || IsSecondByteRange2(c))

#define        QValidChar(u)        ((u) ? QChar((ushort)(u)) : QChar(QChar::ReplacementCharacter))


int UAOCodec::_mibEnum()
{
    return 0;
}

QByteArray UAOCodec::_name()
{
    return "UAO";
}

/*
 * ucs4 to big5hkscs convert routing
 */

typedef struct {
    ushort index; /* index into big table */
    ushort used;  /* bitmask of used entries */
} Summary16;

static const ushort big5_to_ucs[] = 
{
19991, 20002, 20012, 20053, 20066, 20106, 20144, 20203, 20205, 20220,
20252, 20362, 20479, 20546, 20560, 20600, 20696, 20702, 20724, 20758,
20810, 20817, 20836, 20842, 20869, 20880, 20893, 20902, 20904, 20905,
20935, 20950, 20955, 20972, 20988, 21003, 21012, 21013, 21024, 21035,
21049, 21071, 21105, 21136, 21138, 21140, 21148, 21167, 21173, 21200,
21248, 21255, 21284, 21318, 21343, 21395, 21424, 21469, 21539, 21584,
21585, 21642, 21661,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0, 21667, 21684, 21712,
21795, 21823, 21836, 21843, 21853, 21868, 21918, 21929, 21996, 22005,
22051, 22096, 22140, 22154, 22164, 22176, 22191, 22232, 22272, 22361,
22373, 22399, 22405, 22409, 22433, 22444, 22452, 22464, 22472, 22483,
22511, 22596, 22636, 22674, 22682, 22706, 22712, 22757, 22779, 22786,
22795, 22800, 22808, 22811, 29836, 29837, 29849, 29851, 29860, 29876,
29881, 29896, 29900, 29904, 29907, 30018, 30037, 30062, 30093, 30110,
30172, 30252, 30287, 30289, 30323, 30324, 30373, 30425, 30478, 30479,
30552, 30578, 30583, 30584, 30586, 30587, 30616, 30639, 30654, 30659,
30661, 30667, 30685, 30694, 30708, 30750, 30781, 30786, 30788, 30795,
30801, 21782, 22775, 38964, 33883, 28948, 33398, 35158, 40236, 40206,
36527, 24674, 26214, 34510, 25785, 37772, 22107, 28485, 35532, 29001,
24012, 34633, 39464, 31658, 36107, 39255, 23597, 32331, 38938, 20518,
25458, 40568, 30783, 40633, 40634, 36046, 35715, 61305, 33931, 37284,
31331, 25776, 24061, 24214, 32865, 26965, 31466, 28710, 26812, 31095,
28060, 36841, 31074, 22178, 34687, 21093, 31108, 28300, 37271, 31622,
38956, 26717, 20397, 34222,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0, 31725, 34635,
20534, 26893, 27542, 24910, 20855, 30495, 20516, 32622, 30452, 27097,
24803, 25334, 21599, 38788, 22092, 20677, 22040, 34398, 22834, 22875,
22877, 22883, 22892, 22939, 22999, 23019, 23066, 23210, 23248, 23281,
23350, 23497, 23539, 23571, 23580, 23582, 23635, 23705, 23708, 23738,
23739, 23745, 23797, 23802, 23829, 23832, 23870, 23891, 23900, 23917,
23923, 23924, 23948, 23952, 23993, 24016, 24019, 24135, 24164, 24271,
24272, 24298, 24304, 24329, 24332, 24337, 24353, 24372, 24385, 24389,
24401, 24412, 24422, 24451, 24560, 24650, 24672, 24715, 24742, 24798,
24849, 24864, 24865, 24892, 24893, 24984, 25015, 25076, 25107, 25117,
25118, 25143, 24186, 27664, 21454, 20267, 20302, 21556, 22257, 22766,
22841, 22918, 23596, 20915, 20914, 28798, 35265, 35282, 36125, 36710,
20122, 26469, 20177, 20004, 21327, 23626, 20872, 24213, 25269, 19996,
20105, 29366, 31868, 32416, 21351, 36711, 37048, 38271, 38376, 20384,
20387, 20822, 21017, 21170, 21364, 22850, 24069, 26594, 27769, 20026,
32419, 32418, 32426, 32427, 32421, 32422, 32417, 32989, 33486, 35745,
35746, 35747, 36126, 36127, 20891,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0, 36712,
38377, 38886, 39029, 39118, 39134, 20457, 20204, 20261, 20010, 20262,
20179, 20923, 21018, 21093, 21592, 23089, 23385, 23777, 23707, 23704,
24072, 24211, 24452, 25375, 26102, 26187, 20070, 27902, 27971, 20044,
29421, 29384, 20137, 30757, 31210, 32442, 32433, 32441, 32431, 32445,
32432, 32423, 32429, 32435, 32440, 32439, 32961, 33033, 21005, 35760,
35750, 35752, 35751, 35754, 35759, 35757, 35755, 23682, 36130, 36129,
36713, 36715, 38025, 38024, 38026, 38027, 38378, 38453, 38485, 38473,
39269, 39532, 39592, 20266, 20255, 20390, 20391, 21153, 21160, 21306,
21442, 21713, 38382, 34900, 22269, 22362, 22441, 25191, 22815, 23044,
22919, 19987, 23558, 23625, 23781, 23703, 24102, 24080, 24352, 24378,
20174, 24469, 20932, 24581, 25195, 25346, 25194, 25249, 25379, 36133,
21551, 26011, 26025, 26172, 21206, 24323, 26465, 26541, 26432, 27682,
20937, 27973, 28170, 27882, 27814, 20928, 29301, 29424, 29616, 20135,
27605, 24322, 20247, 32458, 32479, 32461, 32459, 32460, 32454, 32453,
32452, 32456, 32449, 32450, 38069, 20064, 33626, 33550, 33682, 24196,
33483, 22788, 26415, 34926, 35269, 35268,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
35775, 35766, 35776, 35767, 35768, 35774, 35772, 35769, 36137, 36131,
36143, 36135, 36138, 36139, 36717, 36719, 36825, 36830, 36851, 38039,
38035, 38031, 38034, 38381, 38472, 38470, 38452, 39030, 39031, 40060,
40479, 21348, 40614, 22791, 20263, 20254, 20975, 21056, 21019, 21171,
21195, 20007, 21333, 21727, 21796, 20052, 22260, 23591, 22330, 25253,
22490, 22774, 23090, 23547, 23706, 24103, 24079, 21397, 21417, 24694,
38391, 24812, 24699, 24700, 25315, 25381, 25442, 25196, 26531, 26635,
26632, 38054, 27531, 22771, 27695, 27689, 28044, 20945, 28270, 28065,
27748, 27979, 27985, 28067, 26080, 29369, 33487, 30011, 30153, 21457,
30423, 30746, 31174, 31383, 31508, 31499, 32478, 32467, 32466, 32477,
19997, 32476, 32473, 32474, 32470, 32475, 32899, 32958, 32960, 21326,
33713, 33484, 34394, 35270, 35780, 35789, 35777, 35778, 35791, 35781,
35784, 35787, 35785, 35786, 35779, 36142, 36148, 36144, 36155, 36146,
36153, 36154, 36149, 20080, 36140, 36152, 36151, 36722, 36724, 36726,
36827, 37038, 20065, 38046, 38062, 38041, 38048, 38055, 38045, 38052,
38051, 38389, 38384, 24320, 38386, 38388, 38387,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0, 38431, 38454, 38451, 38887, 39033, 39034, 39035, 39274, 39277,
39272, 39278, 39276, 20911, 39533, 20081, 20538, 20256, 20165, 20542,
20260, 20588, 38130, 21183, 31215, 27719, 21527, 21596, 21595, 22253,
22278, 28034, 22359, 22366, 22488, 33556, 22885, 22920, 29233, 24574,
24582, 24698, 25439, 25250, 25443, 26500, 26198, 26197, 26104, 20250,
19994, 26497, 26472, 26722, 26539, 23681, 27807, 28781, 28287, 28369,
27815, 28902, 28860, 28800, 28949, 29239, 29422, 29502, 29682, 24403,
30415, 30544, 30529, 38606, 30860, 33410, 31509, 31908, 32463, 32482,
32465, 32485, 32486, 20041, 32673, 22307, 32928, 33050, 32959, 33041,
33636, 33479, 21494, 33716, 34398, 34383, 21495, 34568, 34476, 34917,
35013, 35815, 35813, 35814, 35797, 35799, 35800, 35801, 35811, 35802,
35805, 35803, 35809, 35810, 35808, 35807, 36156, 36164, 36158, 36159,
36160, 36161, 36162, 36165, 36739, 36733, 36732, 36734, 20892, 36816,
36798, 36829, 36807, 37049, 38068, 38067, 38073, 38072, 38078, 38080,
38085, 38057, 38082, 38083, 38089, 38091, 38044, 38093, 38079, 38086,
38392, 38504, 38589, 30005, 39044, 39037, 39039, 39036,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0, 39041, 39042, 39282, 39284, 39281, 39280, 39536, 39534,
39535, 40480, 20389, 20392, 21294, 21388, 23581, 21589, 21497, 21949,
21863, 21716, 22242, 22270, 23576, 22443, 22545, 23551, 26790, 22842,
22849, 22954, 23454, 23517, 23545, 23649, 23853, 23702, 24065, 24124,
24443, 24577, 24815, 24696, 24813, 24808, 25602, 25524, 25530, 30021,
33635, 26538, 28378, 28173, 27721, 28385, 28382, 28176, 28072, 28063,
27818, 28180, 28183, 28068, 33639, 23572, 33638, 29425, 29712, 29595,
30111, 30113, 30127, 30186, 23613, 30417, 30805, 31087, 31096, 31181,
31216, 27964, 31389, 31546, 31581, 32509, 32510, 32508, 32496, 32491,
32511, 32039, 32512, 32434, 32494, 32504, 32501, 32438, 32500, 32490,
32513, 32502, 32602, 38395, 33669, 30422, 33642, 33485, 34432, 35829,
35821, 35820, 35748, 35819, 35823, 35828, 35824, 35826, 35825, 35827,
35822, 23486, 36168, 36170, 36213, 36214, 36741, 36740, 36731, 36828,
36874, 36882, 38128, 38134, 38108, 38125, 38114, 38124, 38120, 38133,
38115, 38402, 38394, 38397, 38401, 38400, 38469, 39047, 39046, 39122,
39290, 39292, 39285, 39287, 39539, 32942, 39600, 40483, 40482,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0, 20964, 40784, 20159, 20202, 20215, 20396, 20393,
20461, 21095, 21016, 21073, 21053, 21385, 21792, 22068, 21719, 22040,
21943, 21880, 21501, 22687, 22367, 22368, 22549, 23092, 23157, 22953,
23047, 23046, 23485, 23457, 20889, 23618, 23956, 24092, 24223, 21416,
24217, 21422, 24191, 24377, 24198, 34385, 24551, 24578, 24751, 24814,
24868, 24579, 25370, 25169, 25438, 25320, 25376, 25242, 25528, 25599,
25932, 25968, 26242, 26165, 26679, 26729, 26530, 26631, 27004, 26728,
20048, 26526, 27431, 27527, 27572, 27974, 27900, 27905, 27975, 28291,
28070, 28071, 27988, 28909, 22870, 33721, 30126, 30353, 30385, 30424,
30830, 30721, 31377, 31351, 32532, 32451, 32428, 32516, 32517, 32521,
32534, 32536, 32447, 32526, 32531, 32525, 32514, 32520, 32519, 39554,
32610, 33014, 32932, 33714, 33643, 33931, 34430, 34583, 21355, 35850,
35845, 35848, 35846, 35806, 35831, 35832, 35838, 35839, 35844, 35843,
35841, 35770, 35812, 35847, 35837, 35840, 31446, 36180, 36175, 36171,
36145, 36134, 36172, 36132, 21334, 36176, 36136, 36179, 36341, 36745,
36742, 36749, 36744, 36743, 36718, 36750, 36747, 36746, 36866, 36801,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0, 37051, 37073, 37011, 38156, 38161, 38144,
38138, 38096, 38148, 38109, 38160, 38153, 38155, 38049, 38146, 38398,
38405, 24041, 39049, 39052, 20859, 39295, 39297, 39548, 39547, 39543,
39542, 39549, 39550, 39545, 39544, 39607, 38393, 40063, 40065, 40489,
40486, 40632, 40831, 20454, 20647, 20394, 24130, 21058, 21544, 21725,
22003, 22438, 22363, 22859, 34949, 23398, 23548, 23466, 20973, 24811,
25044, 24518, 25112, 25317, 25377, 25374, 25454, 25523, 25321, 25441,
25285, 25373, 21382, 26195, 26196, 26137, 26726, 27178, 26641, 26925,
26725, 26426, 26721, 28096, 27987, 27901, 27978, 27811, 28582, 28177,
28861, 28903, 28783, 28907, 28950, 29420, 29585, 29935, 30232, 21346,
30610, 30742, 30875, 31215, 39062, 31267, 31397, 31491, 31579, 32546,
32547, 33830, 32538, 21439, 32543, 32540, 32537, 32457, 33147, 20852,
33329, 33633, 33831, 33436, 34434, 33828, 35044, 20146, 35278, 35867,
35866, 35855, 35763, 35851, 35853, 35856, 35864, 35834, 35858, 35859,
35773, 35861, 35865, 35852, 35862, 36182, 36752, 36753, 36755, 36751,
21150, 36873, 36831, 36797, 36951, 37050, 38189, 38191, 38192, 38169,
38065,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0, 38050, 38177, 24405, 38126, 38181,
38182, 38175, 38178, 38193, 38414, 38543, 38505, 38745, 33148, 39050,
39048, 39057, 39060, 22836, 39059, 39056, 39302, 39279, 39300, 39301,
39559, 39560, 39558, 39608, 39612, 40077, 40501, 40490, 40495, 40493,
40499, 40857, 40863, 20248, 20607, 20648, 21169, 21659, 21523, 21387,
22489, 23156, 23252, 23351, 23604, 23654, 23679, 23896, 24110, 24357,
24212, 24691, 25103, 20987, 25380, 25319, 25311, 25601, 25947, 27609,
26279, 26723, 26816, 26727, 26633, 27183, 27539, 27617, 27870, 28392,
27982, 28059, 28389, 28073, 28493, 33829, 28799, 28891, 28905, 22681,
29406, 33719, 29615, 29815, 30184, 30103, 30699, 30970, 30710, 31699,
31914, 38214, 31937, 32553, 32489, 32554, 32533, 32551, 32503, 32541,
24635, 32437, 32555, 32420, 32549, 32358, 32550, 22768, 32874, 32852,
32824, 33043, 32966, 33080, 33037, 20020, 20030, 33392, 34103, 34015,
20111, 34684, 34632, 20149, 35099, 35274, 35868, 35876, 35878, 35762,
35854, 35875, 35874, 35466, 35879, 36186, 36187, 36141, 36185, 36235,
36758, 36759, 27586, 36757, 33286, 36824, 36808, 37213, 38208, 38209,
38170, 38190,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0, 38194, 38149, 38180, 38202,
38201, 38203, 38206, 38199, 38420, 38421, 38417, 38385, 38544, 38582,
34429, 38889, 39063, 39123, 39563, 39567, 40092, 40091, 40084, 40081,
40511, 40509, 28857, 25995, 19995, 22108, 22329, 22418, 23158, 25041,
25193, 25527, 25200, 25781, 25670, 25822, 25783, 26029, 27103, 26588,
27099, 26592, 27428, 24402, 27553, 27899, 28182, 28388, 28174, 28293,
27983, 28908, 28952, 29367, 29454, 29934, 30112, 30545, 30784, 31036,
31313, 31229, 31388, 31373, 31659, 31783, 31658, 31697, 31616, 31918,
32455, 32558, 32469, 32557, 32483, 32559, 32728, 32844, 32834, 33040,
33169, 26087, 33832, 34013, 33632, 34546, 34633, 35280, 35294, 35871,
35880, 35884, 35882, 36184, 36434, 36857, 36344, 36527, 36716, 36761,
36841, 21307, 37233, 38225, 38145, 38056, 38221, 38215, 38224, 38226,
38217, 38422, 38383, 38423, 38425, 26434, 21452, 38607, 40481, 39069,
39068, 39064, 39066, 39067, 39311, 39306, 39304, 39569, 39617, 40104,
40100, 40107, 40103, 40515, 40517, 40516, 22404, 22364, 23456, 24222,
24208, 24809, 24576, 25042, 25314, 26103, 27249, 26911, 27016, 27257,
28487, 28625, 27813,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0, 28626, 27896, 28865,
29261, 29322, 20861, 29549, 29626, 29756, 30068, 30250, 30861, 31095,
31283, 31614, 33575, 32462, 32499, 32472, 32599, 32564, 33211, 33402,
34222, 33647, 34433, 34631, 35014, 34948, 35889, 35782, 35885, 35890,
35749, 35887, 36192, 36190, 36343, 36762, 36735, 36766, 36793, 38236,
38237, 38238, 38142, 38231, 38232, 38230, 38233, 38197, 38210, 38143,
37694, 20851, 38471, 38590, 38654, 38892, 38901, 31867, 39072, 39125,
39314, 39313, 39579, 39575, 40120, 40115, 40109, 40119, 40529, 40521,
40522, 40524, 40527, 20029, 40628, 21149, 21657, 22052, 20005, 23453,
24748, 24527, 25318, 25600, 32999, 27015, 28572, 28491, 28809, 29649,
30719, 30778, 30718, 30782, 31398, 31454, 31609, 31726, 36779, 32548,
32487, 32578, 33002, 33328, 34108, 34106, 33446, 33529, 34164, 34461,
35124, 35273, 35302, 35758, 35793, 35893, 36194, 36193, 36280, 37322,
38047, 38105, 38152, 38416, 39128, 39286, 39269, 39582, 33150, 39578,
40131, 40133, 20826, 40835, 40836, 20458, 21995, 21869, 22179, 23646,
24807, 24913, 25668, 25658, 26003, 27185, 26639, 26818, 27516, 28866,
29306, 38262, 29838, 30302,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0, 32544, 32493,
20848, 34259, 34510, 35272, 35892, 25252, 35465, 36163, 36364, 36291,
36347, 36720, 36777, 38256, 38253, 38081, 38107, 38094, 38255, 38220,
21709, 39038, 39074, 39144, 39537, 39584, 34022, 39585, 39621, 40141,
40143, 33722, 40548, 40542, 40839, 40840, 21870, 20456, 20645, 21587,
23402, 24005, 23782, 24367, 25674, 26435, 27426, 28393, 29473, 21472,
30270, 30307, 31548, 31809, 32843, 33039, 34989, 34924, 35835, 36174,
36189, 36399, 36396, 36756, 37094, 38136, 37492, 38657, 38801, 32366,
39076, 39556, 39553, 40150, 40098, 40148, 40151, 40551, 40485, 40761,
40841, 40842, 40858, 24651, 25371, 25605, 29906, 31363, 32552, 33250,
33821, 34506, 21464, 36902, 36923, 38259, 38084, 38757, 26174, 39181,
24778, 39551, 39564, 39635, 39633, 40157, 40158, 40156, 40502, 22065,
22365, 25597, 30251, 30315, 32641, 34453, 35753, 35863, 35894, 33395,
36195, 37247, 38643, 28789, 38701, 39078, 39588, 39699, 39751, 40078,
40560, 40557, 30839, 30416, 40140, 40844, 40843, 21381, 27012, 28286,
31729, 31657, 34542, 35266, 36433, 34885, 38053, 39045, 39307, 39627,
40649, 28390, 30633, 38218, 38831,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0, 39540,
39589, 32518, 35872, 36495, 37245, 38075, 37550, 38179, 40132, 40072,
40681, 20991, 40550, 39562, 40563, 40510, 38074, 20162, 34381, 27538,
22439, 22395, 25099, 20451, 21037, 21389, 21593, 21370, 32424, 33543,
38023, 38022, 21591, 24362, 31059, 32446, 37071, 38028, 21072, 21286,
22261, 22445, 23045, 23741, 23811, 28062, 28172, 28867, 30502, 32448,
32464, 33003, 38030, 38032, 38037, 38029, 38379, 22955, 23899, 24701,
26720, 26536, 27817, 27976, 30066, 30743, 32471, 33757, 35271, 35765,
35790, 35794, 36150, 36147, 36730, 36725, 36728, 36911, 37075, 37124,
38059, 38060, 38043, 38063, 38061, 38058, 38390, 38503, 39032, 39275,
40697, 20251, 20603, 20325, 21794, 22450, 24047, 24493, 28828, 33557,
29426, 29614, 32488, 32480, 32481, 32671, 33645, 34545, 35795, 35798,
35817, 35796, 35804, 36241, 36738, 36737, 37036, 38090, 38088, 38064,
38066, 38070, 38157, 38092, 38077, 38076, 39043, 39040, 20971, 40702,
20606, 21787, 23901, 24123, 24747, 24749, 24580, 25132, 25111, 25247,
25248, 25532, 26724, 26473, 33637, 27986, 27812, 28829, 30386, 30720,
32507, 32498, 32495, 32506, 33715, 35275,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
35830, 36167, 38129, 38098, 38097, 38101, 38111, 38123, 38127, 38122,
38135, 38102, 38117, 39121, 21055, 21154, 21715, 21586, 23810, 23780,
24209, 24870, 25378, 26912, 27637, 39053, 28061, 28514, 28064, 28375,
29711, 29825, 30231, 32515, 32535, 32524, 32527, 32529, 33628, 33932,
33553, 33473, 35833, 35836, 35842, 36181, 37112, 38162, 38103, 38141,
38163, 38154, 38116, 38150, 38151, 38164, 38406, 38403, 38739, 39055,
39293, 39541, 39552, 40066, 40488, 21714, 21717, 21721, 23250, 23748,
24639, 27546, 27981, 28904, 29443, 29423, 30876, 31405, 32279, 32539,
33927, 33640, 33929, 33630, 33720, 33431, 34547, 35816, 35857, 35860,
35869, 37072, 38185, 38188, 38166, 38167, 38140, 38171, 38165, 38174,
38036, 38415, 38408, 38409, 38410, 38412, 38413, 40498, 40497, 21724,
24113, 24697, 25672, 58305, 27894, 29461, 29971, 30213, 30187, 30807,
31654, 31578, 31976, 32545, 32807, 33631, 33718, 34544, 35042, 35279,
35873, 35788, 35877, 36292, 38200, 38196, 38113, 38198, 38418, 39271,
40082, 40085, 40504, 40505, 40506, 40832, 24636, 25669, 25784, 27898,
30102, 32523, 32873, 33641, 34789, 34414, 35764,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0, 35881, 36188, 36157, 36760, 37021, 38227, 38112, 38204, 38223,
34021, 38890, 39273, 39568, 39570, 39571, 38411, 40105, 40096, 40520,
40513, 40518, 21411, 21590, 22406, 27104, 26638, 27655, 27895, 28486,
31074, 32562, 32563, 32628, 33315, 34511, 34431, 35043, 35281, 35311,
35886, 38235, 38239, 38250, 38214, 38121, 38891, 39073, 39312, 39618,
40117, 40118, 40123, 40113, 40526, 40491, 40700, 21950, 25732, 26634,
26533, 26636, 32561, 32845, 33551, 33480, 34162, 34548, 34686, 38132,
38246, 38248, 38241, 38243, 38212, 38251, 38119, 38244, 38137, 38426,
39071, 39316, 39546, 39581, 39583, 39576, 40535, 40538, 40540, 40838,
40837, 20649, 23743, 30152, 25786, 27017, 28384, 30779, 31901, 32425,
32556, 34105, 36166, 38257, 38396, 39129, 39586, 39574, 39580, 40101,
40142, 40144, 40547, 40536, 40574, 20865, 23048, 28757, 25874, 30271,
31656, 31860, 33339, 35276, 36345, 36318, 36729, 38228, 38252, 39587,
39557, 40149, 40099, 40102, 40552, 40503, 40859, 26686, 26916, 34016,
38624, 36723, 40159, 40095, 40553, 40556, 40554, 40555, 40519, 28751,
31766, 35888, 39628, 31550, 31900, 32565, 33044, 36479,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0, 38247, 40090, 36273, 36508, 37246, 35891, 39070, 39079,
39591, 40492, 25094, 38404, 40097, 40514, 31160, 25300, 36299, 29648,
23467, 25296, 27585, 20943, 31108, 21525, 28508, 34972, 37095, 20857,
25144, 25243, 25383, 25531, 25566, 25594, 25745, 25792, 25825, 25846,
25861, 25909, 25934, 25963, 25992, 26073, 26142, 26171, 26175, 26180,
26199, 26217, 26227, 26243, 26300, 26303, 26305, 26357, 26362, 26363,
26382, 26390, 26423, 26468, 26470, 26534, 26535, 26537, 26619, 26621,
26624, 26625, 26629, 26654, 26698, 26706, 26709, 26713, 26765, 26809,
26831, 20616, 38184, 40087, 26914, 26918,   220, 58591, 58592,   252,
58594, 58595,   220,   252, 26934, 26977, 33477, 33482, 33496, 33560,
33562, 33571, 33606, 33627, 33634, 33644, 33646, 33692, 33695, 33717,
33724, 33783, 33834, 33864, 33884, 33890, 33924, 33928, 34012, 34019,
34104, 34138, 34199, 34219, 34241, 34323, 34326,  8715, 34581, 34672,
34685, 34699, 34728, 34759, 34768, 34823, 34830, 34855, 34990,  8712,
34997, 35007, 35045, 35061, 35100, 35101, 35191, 35303, 35383, 35500,
35546, 35675, 35697, 35883, 35898, 35964, 35982, 36014, 36114,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0, 36169, 36173, 36209, 36360, 36410, 36464, 36505,
36528, 36529, 36549, 36550, 36558, 36579, 36620, 36721, 36727, 36775,
36847, 36878, 36921, 36965, 37001, 37086, 37141, 37334, 37339, 37342,
37345, 37349, 37366, 37372, 37417, 37420, 65287, 37465, 37495, 37613,
37690, 58701, 58702, 29227, 20866, 20886, 20023, 20843, 20799, 58709,
58710, 26409, 27706, 21378, 30098, 32896, 34916, 19974, 58718, 58719,
58720, 11927, 21241, 21269,  8225, 58725, 13316, 58727, 58728, 58729,
58730, 58731, 20981, 58733, 23662, 58735, 22231, 20128, 20907, 11904,
27079, 58741,  9550,  9688,  9689,  9794,  9654,  9668,  8597,  8252,
  182,  8704,  8616,  8596,  8962, 58755, 58756, 20124, 24746, 22311,
22258, 21307, 22769, 36920, 38560, 26628, 21942, 39365, 35585, 20870,
32257, 24540, 27431, 27572, 26716, 22885, 31311, 20206, 20385, 30011,
28784, 20250, 24724, 28023, 32117, 22730, 25040, 25313, 27579, 35226,
23398, 27005, 21917, 28167, 58794, 24059, 38501, 21223, 23515, 28450,
38306, 27475, 35251, 27671, 24112, 25135, 29344, 34384, 26087, 24613,
25312, 25369, 34394, 23777, 25375, 29421, 37111, 38911, 26241, 21220,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0, 35641, 21306, 39366, 21234, 58824, 24452,
33550, 24693, 25522, 28179, 32076, 34509, 36605, 32153, 40335, 25731,
30476, 20537, 21091, 38522, 22287, 26908, 27177, 38997, 39443, 21427,
21577, 23087, 35492, 24195, 28207, 37489, 21495, 22269, 40658, 31296,
30741, 28168, 25998, 27507, 21092, 38609, 21442, 26719, 24808, 36059,
27531, 27503, 20816, 36766, 28287, 23455, 20889, 33294, 25448, 37320,
23551, 21454, 34886, 24467, 28171, 29539, 32294, 31899, 20966, 23558,
31216, 28169, 28988, 22888, 26465, 29366, 20055, 27972, 21104, 30067,
32260, 22732, 23330, 35698, 37304, 35302, 22065, 23517, 23613, 22259,
31883, 37204, 31298, 38543, 39620, 26530, 25968, 25454, 28716, 22768,
25993, 38745, 31363, 25666, 32118, 23554, 27973, 25126, 36341, 37549,
28508, 36983, 36984, 32330, 31109, 30094, 22766, 20105, 33624, 25436,
25407, 24035, 31379, 35013, 20711, 23652, 32207, 39442, 22679, 24974,
34101, 36104, 33235, 23646, 32154, 22549, 23550, 24111, 28382, 28381,
25246, 27810, 28655, 21336, 22022, 22243, 26029, 24382, 36933, 26172,
37619, 24193, 24500, 32884, 25074, 22618, 36883, 37444, 28857, 36578,
20253,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0, 38651, 28783, 24403, 20826, 30423,
31282, 38360, 24499, 27602, 29420, 35501, 23626, 38627, 24336, 24745,
33075, 25309, 24259, 22770, 26757, 21338, 34180, 40614, 32283, 30330,
39658, 25244, 27996, 27996, 25935, 25975, 20398, 25173, 20175, 36794,
22793, 27497, 33303, 31807, 21253, 23453, 25265, 27873, 32990, 30770,
35914, 39165, 22696, 27598, 28288, 33032, 40665, 35379, 34220, 36493,
19982, 35465, 25671, 27096, 35617, 26332, 26469, 38972, 20081, 35239,
31452, 38534, 26053, 20001, 29471, 32209, 28057, 22593, 31036, 21169,
25147, 38666, 40802, 26278, 27508, 24651, 32244, 37676, 28809, 21172,
27004, 37682, 28286, 24357, 20096, 26365, 22985, 23437, 23947, 27179,
26907, 21936, 31874, 36796, 27018, 21682, 40235, 38635, 26905, 25539,
39364, 20967, 26626, 36795, 20685, 23776, 26627, 20970, 21250, 30834,
30033, 30048, 22138, 37618, 22592, 26622, 20451, 26466, 31870, 21249,
20452, 20453, 20969, 21498, 21720, 22222, 22310, 22327, 22328, 22408,
22451, 22442, 22448, 22486, 22640, 22713, 22743, 23670, 23740, 23749,
23742, 23926, 24342, 24634, 25525, 26433, 26467, 26529, 26810, 26917,
26920, 27258,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0, 26915, 26913, 27006, 27009,
27101, 27182, 27250, 27423, 27615, 28181, 29077, 29927, 29938, 29936,
29937, 29944, 29957, 30057, 30314, 30836, 31437, 31439, 31445, 31443,
31457, 31472, 31490, 31763, 31767, 31888, 31917, 31936, 31960, 32155,
32261, 32359, 32387, 32400, 33188, 33373, 33826, 34009, 34352, 34475,
34543, 34992, 35011, 35012, 35076, 59183, 36542, 36552, 36684, 36791,
36826, 36903, 36950, 37685, 37691, 37817, 38282, 38294, 38777, 38790,
38800, 39082, 39830, 39831, 39860, 39887, 39889, 39890, 39922, 39921,
39984, 40007, 40026, 40176, 40262, 40292, 40363, 20036, 21583, 25368,
39857, 40041, 40263, 40293, 39983, 40639, 20916, 21610, 26528, 39822,
37032, 20914, 13869, 25285, 21189, 26545, 21709, 24658, 21441, 28913,
22531, 21855, 37390, 30528, 29756, 29002, 28377, 21472, 29486, 35023,
30861, 32675, 32171, 36394, 37979, 25452, 24487, 23557, 32827, 23791,
14776, 29009, 36045, 38894, 22642, 23139, 32632, 23895, 24943, 27032,
32137, 31918, 32179, 28545, 23290, 22715, 29269, 30286, 36653, 37561,
40286, 40623, 32583, 40388, 36120, 20915, 34412, 21668, 21414, 21030,
26422, 20001, 21364,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0, 24313, 21177, 21647,
24312, 22956, 24625, 29248, 33047, 30267, 24333, 26187, 26280, 24932,
25423, 28895, 27940, 31911, 31945, 21465, 25933, 22338, 29647, 32966,
13649, 27445, 30849, 21452, 29483, 29482, 29641, 30026, 23033, 29124,
29966, 32220, 39393, 35241, 28662, 14935, 25834, 15341, 27809, 28284,
30055, 22633, 22633, 20996, 59338, 24967, 25658, 33263, 59342, 20917,
20945, 27769, 22815, 36857, 39153, 25911, 33033, 34996, 14890, 36525,
32663, 39440, 32037, 27336, 20876, 21031, 59360, 33050, 21408, 21410,
27738, 27703, 33304, 21894, 24315, 20937, 30897, 37474, 21357, 20931,
59374, 33905, 35207, 38765, 35728, 38563, 24316, 38583, 20814, 39952,
26160, 37461, 30728, 37701, 37491, 37737, 59390, 59391, 59392, 59393,
37343, 37338, 30804, 30822, 30856, 30902, 30919, 30930, 30935,  8491,
 8651, 30948, 30958, 30960, 30961, 30965, 31026, 31027, 31030, 31064,
12307, 31065, 31089, 31102, 31107, 31110, 31111, 31121, 31129, 31135,
31141, 31202, 31217, 31220, 31274, 31290, 31301, 31333, 31420, 31426,
31433, 31451, 31465, 31486, 31500, 31527, 31529, 31554, 31555, 31573,
31599, 31666, 27102, 27129,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0, 37238, 33114,
33527, 21579, 33074, 32957, 33816, 37214, 37232, 37260, 33096, 59459,
17462, 33113, 32927, 59463, 21833, 21537, 21722, 21554, 21945, 21652,
59470, 30802, 30789, 30796, 59474, 33981, 33820, 33476, 59478, 33915,
35629, 59481, 22347, 59483, 59484, 22341, 34766, 22112, 21994, 22139,
32956, 59491, 30904, 27148, 21708, 31696, 31724, 31738, 31765, 31771,
31797, 31812, 31853, 31886, 31928, 31939, 31974, 31981, 31987, 31989,
31993, 59511, 31996, 32139, 32151, 32164, 32168, 32205, 32208, 32211,
32229, 32253, 27154, 27170, 27184, 27190, 27237, 59527, 59528, 59529,
59530, 59531, 59532, 59533, 59534, 27251, 27256, 59537, 59538, 27260,
27305, 27306,  9450,  9312,  9313,  9314,  9315,  9316,  9317,  9318,
 9319,  9320,  9321,  9322,  9323,  9324,  9325,  9326,  9327,  9328,
 9329,  9330,  9331, 37700, 37805, 37830, 37861, 37914, 37921, 37950,
37953, 37971, 37978, 38042, 38071, 38104, 38110, 38131, 38147, 38158,
38159, 38168, 38173, 38186, 38187, 38207, 38213, 38222, 38242, 38245,
38249, 38258, 38279, 38297, 38304, 38322, 38502, 38557, 38575, 38578,
38707, 38715, 38733, 38735, 38737,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0, 38741,
38756, 38763, 38769, 38802, 38834, 38898, 38973, 38996, 39077, 39107,
39130, 39150, 39197, 39200, 39267, 39296, 39303, 39309, 39315, 39317,
39356, 39368, 39410, 39606, 39641, 39646, 39695, 39753, 39794, 39811,
39839, 39867, 39907, 39925, 39936, 39940, 39963,  9398,  9399,  9400,
 9401,  9402,  9403,  9404,  9405,  9406,  9407,  9408,  9409,  9410,
 9411,  9412,  9413,  9414,  9415,  9416,  9417,  9418,  9419,  9420,
 9421,  9422,  9423,  9424,  9425,  9426,  9427,  9428,  9429,  9430,
 9431,  9432,  9433,  9434,  9435,  9436,  9437,  9438,  9439,  9440,
 9441,  9442,  9443,  9444,  9445,  9446,  9447,  9448,  9449,   174,
 8482, 59697, 59698, 40054, 10102, 10103, 10104, 10105, 10106, 10107,
10108, 10109, 10110, 10111, 40069, 40070, 40071, 40075, 40080, 40094,
40110, 40112, 40114, 40116, 40122, 40124, 40125, 40134, 40135, 40138,
40139, 40147, 40152, 40153, 40162, 40171, 40172, 40234, 40264, 40272,
40314, 40390, 40523, 40533, 40539, 40561, 40618, 40637, 40644, 40674,
40682, 40712, 40715, 40717, 40737, 40772, 40785, 40861, 64014, 64015,
64017, 64019, 64020, 64024, 64031, 64032,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
64033, 64035, 64036, 64039, 64040, 64041, 19972, 20015, 20097, 20103,
20131, 20151, 20156, 20216, 20264, 20265, 20279, 20290, 20293, 20299,
20338, 20386, 20400, 20413, 20424, 20428, 20464, 20466, 20473, 20483,
20488, 20532, 20539, 20568, 20582, 20609, 20624, 20668, 20688, 20703,
20705, 20732, 20749, 20779, 20832, 20910, 20920, 20946, 20962, 20997,
21044, 21052, 21081, 21096, 21113, 21156, 21196, 21287, 21314, 21341,
21373, 21374, 21445, 21456, 21458, 21502, 21613, 21637, 21651, 21662,
21689, 21731, 21743, 21773, 21784, 21797, 21800, 21803, 21831, 21881,
21904, 21940, 21953, 21975, 21976, 22011, 20404, 22049,  8707, 22098,
59852,  9787, 59854, 59855, 22109,  9332,  9333,  9334,  9335,  9336,
 9337,  9338,  9339,  9340,  9341,  9342,  9343,  9344,  9345,  9346,
 9347,  9348,  9349,  9350,  9351, 22113, 22153, 22155, 22174, 22177,
22193, 22201, 22207, 22230, 22255, 22293, 22301, 22322, 22333, 22335,
22339,  8660, 22398, 22410, 22413, 22416, 22428, 22459, 22462, 22468,
22494, 22526, 22546, 22562, 22599, 22620, 22623, 22643, 22695, 22698,
22704, 22709, 22710, 22731, 22736, 22752, 22789,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0, 22801, 22921, 22932, 22938, 22943, 22960, 22968, 22980, 23023,
23024, 23032, 23042, 23051, 23053, 23058, 23073, 23076, 23079, 23082,
23083, 23084, 23101, 23109, 23124, 23129, 23137, 23144, 23147, 23150,
23153, 23161, 23166, 23169, 23170, 23174, 23176, 23185, 23193, 23200,
23201, 23211, 23235, 23246, 23247, 23251, 23268, 23280, 23294, 23309,
23313, 23317, 23327, 23339, 23361, 23364, 23366, 23370, 23375, 23400,
23412, 23414, 23420, 23426, 23440,  9372,  9373,  9374,  9375,  9376,
 9377,  9378,  9379,  9380,  9381,  9382,  9383,  9384,  9385,  9386,
 9387,  9388,  9389,  9390,  9391,  9392,  9393,  9394,  9395,  9396,
 9397, 60009, 12850, 12849, 27307, 23446,  9352,  9353,  9354,  9355,
 9356,  9357,  9358,  9359,  9360,  9361,  9362,  9363,  9364,  9365,
 9366,  9367,  9368,  9369,  9370,  9371, 23509, 23511, 23587, 23685,
23710, 23746, 23824, 23852, 23855, 23880, 23894, 23920, 23931, 23941,
23972, 23979, 23990, 24001, 24023, 24073, 24136, 24210, 24253, 24334,
24434, 24497, 24514, 24539, 24543, 24611, 24702, 24791, 24839, 24844,
24857, 24866, 24912, 24928, 24961, 24981, 25017, 25024,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0, 25039, 25043, 25050, 25232, 25393,  8835, 25399, 25465,
25483, 25537, 25570, 25574, 25595, 25598, 25607, 25650, 25656, 25659,
25690, 25713, 25724, 25741, 25775, 25780, 25782, 25821, 25829, 25866,
25873, 25887, 25951, 25965, 25990, 26037, 26046, 26065, 26068, 26083,
26111, 26136, 26147, 26211, 26219, 26237, 26245, 26258, 26266, 26276,
26285, 26291, 26294, 26317, 26318, 26370, 26380, 26393, 26436, 26475,
26511, 26532, 26559, 26582, 26583,  8834, 26637, 26640, 26651, 26678,
26695, 26710, 26756, 26760, 26813, 26819, 26821, 26882, 26883, 26889,
26904, 26947, 26950, 26980, 26983, 26994, 27013, 27039, 27042, 27089,
27093, 27094, 39457, 39462, 39471, 27329, 22975, 27105, 27139, 27162,
27164, 27180, 27181, 27187, 27203, 27205, 27212, 27219, 27223, 27235,
27252, 27266, 27274, 27279, 27289, 27303, 27313, 27317, 27326, 27337,
27348, 27352, 27382, 27479, 27514, 27612, 27676, 27697, 27736, 27758,
27765, 27775, 27823, 27851, 27871, 27903, 27906, 27909, 27910, 27942,
27991, 27995, 28017, 28033, 28047, 28069, 28081, 28158, 28162, 28164,
28175, 28184, 28202, 28240, 28249, 28314, 28341, 28344, 28379,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0, 28410, 28420, 28427, 28428, 28438, 28439, 28468,
28477, 28502, 28537, 28554, 28573, 28575, 28603, 28606, 28627, 28633,
28664, 28675, 28747, 28749, 28752, 28756, 28764, 28775, 28791, 28793,
28811, 28815, 28832, 28835, 28837, 28838, 28839, 28868, 28876, 28880,
28886,   618,   603,   230,   652,   593,   596,   650,   605,   601,
  602,   604,   609,  7747,  7753,   330,  7739,   629,   240,   643,
  658,   679,   676,   227, 60294, 60295,   623,   632,   647, 60299,
  199,   339,   594, 65351,   715,   719, 65345, 65346, 65348, 65349,
65350, 65352, 65353, 65354, 65355, 65356, 65357, 65358, 65359, 65360,
65362, 65363, 65364, 65365, 65366, 65367, 65370, 28917, 12832, 12833,
12834, 12835, 12836, 12837, 12838, 12839, 12840, 12841, 28926, 28933,
28957, 28969, 28971, 28972, 28979, 28981, 28987, 28990, 28992, 29007,
29035, 29045, 29047, 29052, 29054, 29068, 29070, 29073, 29078, 29090,
29091, 29101, 29108, 29111, 29114, 29137, 29149, 29163, 29184, 29193,
29198, 29199, 29206, 29207, 29220, 23204, 29230,  8838, 29271, 29276,
29332, 29444, 29456, 29505, 29556, 29580, 29583, 29592, 29596, 29598,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0, 29607, 29610, 29653, 29665, 29666, 29668,
29670, 29679, 29683,  8839, 29689, 29691, 29698, 29713, 29714, 29716,
29717, 29719, 29721, 29724, 29726, 29727, 29751, 29752, 29753, 29763,
29765, 29767, 29768, 29769, 29779, 29782, 29797, 29803, 29804, 29812,
29818, 29826, 21378, 24191, 20008, 24186, 20886, 23424, 21353, 11911,
60436, 21251,  9746, 33401, 17553, 11916, 11914, 20022, 60444, 21274,
60446, 60447, 11925, 60449, 60450,  9492, 20058, 36790, 24308, 20872,
20101, 60457, 20031, 60459, 60460, 20059, 21430, 36710, 32415, 35744,
36125, 40479, 38376, 38021, 38429, 25164, 27701, 20155, 24516, 28780,
11950, 21475, 27362, 39483, 39484, 39512, 39516, 39523,  9742,  8594,
 8592,  8593,  8595,  8680,  8678,  8679,  8681,  8680,  8678,  8679,
 8681,  9758,  9756,  9755,  9759, 12310, 12311,  9675, 10005, 10003,
22267,  9789, 22813, 26189, 29221, 10025, 10017,  9786,  9785, 60515,
60516, 60517, 60518, 60519, 23672,  9836,  9834, 23249, 23479, 23804,
60526,  9993,  9986, 60529, 60530, 60531, 60532, 23765, 26478, 29793,
29853, 32595, 34195, 10063, 60540, 60541, 23928, 24379, 60544,  9473,
 9475,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0, 60547, 60548, 60549, 60550, 60551,
60552, 60553, 60554, 60555, 60556, 60557, 60558, 60559, 60560, 60561,
39602, 39648, 39700, 39732, 39737, 39744, 39760, 39807,  9788, 32149,
 9729, 38708,  9730, 60575, 60576, 60577,  9992, 60579, 60580, 60581,
60582, 60583, 60584, 60585,  8507,  8481, 26343, 28247, 60590, 29015,
31178,  8470, 33132, 35577, 38998, 60597, 60598,  9760, 60600,  9828,
 9824,  9831,  9827,  9826,  9830,  9825,  9829, 60609, 60610, 27364,
 8478, 13250, 13272, 13217, 60616, 13221, 60618, 60619, 60620, 60621,
60622,  9745, 39809, 39819, 39821, 39901, 39913, 39917, 39924, 39967,
39968, 39974, 40019, 40029, 40059, 40204, 40214,  8626, 27397, 36073,
36082, 36099, 36113, 36124, 36218, 36265, 36288, 36353, 36366, 36422,
36456, 36465, 36478, 36480, 36534, 36537, 36540, 36547, 36580, 36589,
36594, 36656, 36673, 36682, 36773, 36787, 36792, 36810, 36815, 36872,
36915, 36919, 36964, 36972, 37289, 37302, 37316, 37370, 37384, 37395,
37409, 37416, 37419, 37429, 37436, 37441, 37464, 37469, 37471, 37483,
37486, 37505, 37508, 37513, 37519, 37553, 37562, 37567, 37588, 37595,
37603, 37605,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0, 37611, 37612, 37620, 37622,
37629, 37635, 37639, 37680, 37681, 37696, 37698, 37699, 37727, 37730,
37734, 37736, 37747, 37748, 37752, 37757, 37761, 37764, 37766, 37767,
37776, 37788, 37792, 37816, 37819, 37821, 37823, 37835, 37843, 37851,
37856, 37872, 37873, 37875, 37876, 37889, 37892, 37896, 37911, 37915,
37917, 37924, 37925, 37926, 37933, 37954, 37955, 37965, 37972, 37976,
37989, 37991, 37996, 38009, 38011, 38264, 38277, 38310, 38314, 38486,
38523, 38565, 38644, 38683, 38710, 38720, 38721, 38743, 38791, 38793,
38811, 38833, 38845, 38848, 38850, 38866, 38880, 38932, 38933, 38947,
38963, 39016, 39095, 39097, 39111, 39114, 39136, 39137, 39148, 39157,
40225, 40244, 40249, 40265, 40270, 40301,  8759, 40302, 40316, 40323,
40339, 40357,  8748, 40381, 27521, 27569, 40015, 40592, 40384, 60817,
60818,  9775,  9776,  9783,  9779,  9780,  9781,  9778,  9782,  9777,
40393, 40404, 40444, 40458, 40460, 40462, 40472, 40571, 40581, 40610,
40620, 40625, 40641, 40646, 40647, 40689, 40696, 40743, 39182, 39193,
39196, 39223, 39261, 39266, 39323, 39332, 39338, 39352, 39392, 39398,
39413, 39455, 32254,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0, 32263, 32347, 32357,
32364, 32567, 32576, 32577, 32585, 32594, 32655, 32659, 32692, 32733,
32743, 32762, 32770, 32776, 32814, 32815, 32828, 32935, 33036, 33066,
33076, 33090, 33110, 33156, 33189, 33252, 33364, 33381, 33403, 33415,
33471, 33506, 33518, 33528, 33532, 33535, 33547, 33565, 33597, 33623,
33681, 33708, 33741, 33773, 33797, 33812, 33814, 33825, 33838, 33854,
33866, 33875, 33877, 33880, 33892, 33906, 33919, 33920, 33938, 33939,
33942, 33955, 33982, 34014, 34017, 34018, 34020, 34040, 34051, 34053,
34064, 34099,  8208, 34114, 34124, 34130, 34143, 34159, 34160, 34163,
34262, 34272, 34286, 34300, 34317, 34319, 34324, 34344, 34370, 34373,
34418, 34972, 23405, 33079, 60958, 39224, 21874, 21867, 60962, 13774,
21873, 21946, 22001, 13778, 22000, 22021, 22050, 22061, 22083, 22046,
22162, 31949, 21530, 21523, 21655, 26353, 30004, 21581, 22180, 22175,
25811, 25390, 25592, 25886, 20088, 27626, 27698, 27709, 27746, 27826,
28152, 28201, 28278, 28290, 28294, 28347, 28383, 28386, 28433, 28452,
28532, 28561, 28597, 28659, 28661, 28859, 28864, 28943,  8706, 29013,
29043, 29050, 61016, 21027,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0, 61018, 13393,
61020, 36812, 61022, 61023,   192,   200,   204,   210,   217,   193,
  205,   211,   218,   257,   275,   299,   333,   363,   470,   196,
  203,   207,   214,   220,   198,   199,   209,   195,   213,   225,
  233,   237,   243,   250,   472,   228,   235,   239,   246,   252,
  230,   231,   241,   227,   245,   462,   283,   464,   466,   468,
  474,   197,   201, 29064,   216,   208,  7922,   222,   223,   170,
  161,   224,   232,   236,   242,   249,   476,   229, 29080, 29143,
  248,   240,  7923,   254,   255,   186,   191,   226,   234,   238,
  244,   251, 29173,   194,   202,   206,   212,   219,   184,   164,
61110,   402, 12288, 65292, 12289, 12290, 65294,  8231, 65307, 65306,
65311, 65281, 65072,  8230,  8229, 65104, 65105, 65106,   183, 65108,
65109, 65110, 65111, 65372,  8211, 65073,  8212, 65075,  9588, 65076,
65103, 65288, 65289, 65077, 65078, 65371, 65373, 65079, 65080, 12308,
12309, 65081, 65082, 12304, 12305, 65083, 65084, 12298, 12299, 65085,
65086, 12296, 12297, 65087, 65088, 12300, 12301, 65089, 65090, 12302,
12303, 65091, 65092, 65113, 65114,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0, 65115,
65116, 65117, 65118,  8216,  8217,  8220,  8221, 12317, 12318,  8245,
 8242, 65283, 65286, 65290,  8251,   167, 12291,  9675,  9679,  9651,
 9650,  9678,  9734,  9733,  9671,  9670,  9633,  9632,  9661,  9660,
12963,  8453,   175, 65507, 65343,   717, 65097, 65098, 65101, 65102,
65099, 65100, 65119, 65120, 65121, 65291, 65293,   215,   247,   177,
 8730, 65308, 65310, 65309,  8806,  8807,  8800,  8734,  8786,  8801,
65122, 65123, 65124, 65125, 65126, 65374,  8745,  8746,  8869,  8736,
 8735,  8895, 13266, 13265,  8747,  8750,  8757,  8756,  9792,  9794,
 8853,  8857,  8593,  8595,  8592,  8594,  8598,  8599,  8601,  8600,
 8741,  8739, 65295, 65340,  8725, 65128, 65284, 65509, 12306, 65504,
65505, 65285, 65312,  8451,  8457, 65129, 65130, 65131, 13269, 13212,
13213, 13214, 13262, 13217, 13198, 13199, 13252,   176, 20825, 20827,
20830, 20829, 20833, 20835, 21991, 29929, 31950,  9601,  9602,  9603,
 9604,  9605,  9606,  9607,  9608,  9615,  9614,  9613,  9612,  9611,
 9610,  9609,  9532,  9524,  9516,  9508,  9500,  9620,  9472,  9474,
 9621,  9484,  9488,  9492,  9496,  9581,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
 9582,  9584,  9583,  9552,  9566,  9578,  9569,  9698,  9699,  9701,
 9700,  9585,  9586,  9587, 65296, 65297, 65298, 65299, 65300, 65301,
65302, 65303, 65304, 65305,  8544,  8545,  8546,  8547,  8548,  8549,
 8550,  8551,  8552,  8553, 12321, 12322, 12323, 12324, 12325, 12326,
12327, 12328, 12329, 21313, 21316, 21317, 65313, 65314, 65315, 65316,
65317, 65318, 65319, 65320, 65321, 65322, 65323, 65324, 65325, 65326,
65327, 65328, 65329, 65330, 65331, 65332, 65333, 65334, 65335, 65336,
65337, 65338, 65345, 65346, 65347, 65348, 65349, 65350, 65351, 65352,
65353, 65354, 65355, 65356, 65357, 65358, 65359, 65360, 65361, 65362,
65363, 65364, 65365, 65366, 65367, 65368, 65369, 65370,   913,   914,
  915,   916,   917,   918,   919,   920,   921,   922,   923,   924,
  925,   926,   927,   928,   929,   931,   932,   933,   934,   935,
  936,   937,   945,   946,   947,   948,   949,   950,   951,   952,
  953,   954,   955,   956,   957,   958,   959,   960,   961,   963,
  964,   965,   966,   967,   968,   969, 12549, 12550, 12551, 12552,
12553, 12554, 12555, 12556, 12557, 12558, 12559,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0, 12560, 12561, 12562, 12563, 12564, 12565, 12566, 12567, 12568,
12569, 12570, 12571, 12572, 12573, 12574, 12575, 12576, 12577, 12578,
12579, 12580, 12581, 12582, 12583, 12584, 12585,   729,   713,   714,
  711,   715,  9216,  9217,  9218,  9219,  9220,  9221,  9222,  9223,
 9224,  9225,  9226,  9227,  9228,  9229,  9230,  9231,  9232,  9233,
 9234,  9235,  9236,  9237,  9238,  9239,  9240,  9241,  9242,  9243,
 9244,  9245,  9246,  9247,  9249,  8364, 63561, 63562, 63563, 63564,
63565, 63566, 63567, 63568, 63569, 63570, 63571, 63572, 63573, 63574,
63575, 63576, 63577, 63578, 63579, 63580, 63581, 63582, 63583, 63584,
63585, 63586, 63587, 63588, 63589, 19968, 20057, 19969, 19971, 20035,
20061, 20102, 20108, 20154, 20799, 20837, 20843, 20960, 20992, 20993,
21147, 21269, 21313, 21340, 21448, 19977, 19979, 19976, 19978, 20011,
20024, 20961, 20037, 20040, 20063, 20062, 20110, 20129, 20800, 20995,
21242, 21315, 21449, 21475, 22303, 22763, 22805, 22823, 22899, 23376,
23377, 23379, 23544, 23567, 23586, 23608, 23665, 24029, 24037, 24049,
24050, 24051, 24062, 24178, 24318, 24331, 24339, 25165,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0, 19985, 19984, 19981, 20013, 20016, 20025, 20043, 23609,
20104, 20113, 20117, 20114, 20116, 20130, 20161, 20160, 20163, 20166,
20167, 20173, 20170, 20171, 20164, 20803, 20801, 20839, 20845, 20846,
20844, 20887, 20982, 20998, 20999, 21000, 21243, 21246, 21247, 21270,
21305, 21320, 21319, 21317, 21342, 21380, 21451, 21450, 21453, 22764,
22825, 22827, 22826, 22829, 23380, 23569, 23588, 23610, 23663, 24052,
24187, 24319, 24340, 24341, 24515, 25096, 25142, 25163, 25166, 25903,
25991, 26007, 26020, 26041, 26085, 26352, 26376, 26408, 27424, 27490,
27513, 27595, 27604, 27611, 27663, 27700, 28779, 29226, 29238, 29243,
29255, 29273, 29275, 29356, 29579, 19993, 19990, 19989, 19988, 19992,
20027, 20045, 20047, 20046, 20197, 20184, 20180, 20181, 20182, 20183,
20195, 20196, 20185, 20190, 20805, 20804, 20873, 20874, 20908, 20985,
20986, 20984, 21002, 21152, 21151, 21253, 21254, 21271, 21277, 20191,
21322, 21321, 21345, 21344, 21359, 21358, 21435, 21487, 21476, 21491,
21484, 21486, 21481, 21480, 21500, 21496, 21493, 21483, 21478, 21482,
21490, 21489, 21488, 21477, 21485, 21499, 22235, 22234, 22806,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0, 22830, 22833, 22900, 22902, 23381, 23427, 23612,
24040, 24039, 24038, 24066, 24067, 24179, 24188, 24321, 24344, 24343,
24517, 25098, 25171, 25172, 25170, 25169, 26021, 26086, 26414, 26412,
26410, 26411, 26413, 27491, 27597, 27665, 27664, 27704, 27713, 27712,
27710, 29359, 29572, 29577, 29916, 29926, 29976, 29983, 29992, 29993,
30000, 30001, 30002, 30003, 30091, 30333, 30382, 30399, 30446, 30683,
30690, 30707, 31034, 31166, 31348, 31435, 19998, 19999, 20050, 20051,
20073, 20121, 20132, 20134, 20133, 20223, 20233, 20249, 20234, 20245,
20237, 20240, 20241, 20239, 20210, 20214, 20219, 20208, 20211, 20221,
20225, 20235, 20809, 20807, 20806, 20808, 20840, 20849, 20877, 20912,
21015, 21009, 21010, 21006, 21014, 21155, 21256, 21281, 21280, 21360,
21361, 21513, 21519, 21516, 21514, 21520, 21505, 21515, 21508, 21521,
21517, 21512, 21507, 21518, 21510, 21522, 22240, 22238, 22237, 22323,
22320, 22312, 22317, 22316, 22319, 22313, 22809, 22810, 22839, 22840,
22916, 22904, 22915, 22909, 22905, 22914, 22913, 23383, 23384, 23431,
23432, 23429, 23433, 23546, 23574, 23673, 24030, 24070, 24182, 24180,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0, 24335, 24347, 24537, 24534, 25102, 25100,
25101, 25104, 25187, 25179, 25176, 25910, 26089, 26088, 26092, 26093,
26354, 26355, 26377, 26429, 26420, 26417, 26421, 27425, 27492, 27515,
27670, 27741, 27735, 27737, 27743, 27744, 27728, 27733, 27745, 27739,
27725, 27726, 28784, 29279, 29277, 30334, 31481, 31859, 31992, 32566,
32650, 32701, 32769, 32771, 32780, 32786, 32819, 32895, 32905, 32907,
32908, 33251, 33258, 33267, 33276, 33292, 33307, 33311, 33390, 33394,
33406, 34411, 34880, 34892, 34915, 35199, 38433, 20018, 20136, 20301,
20303, 20295, 20311, 20318, 20276, 20315, 20309, 20272, 20304, 20305,
20285, 20282, 20280, 20291, 20308, 20284, 20294, 20323, 20316, 20320,
20271, 20302, 20278, 20313, 20317, 20296, 20314, 20812, 20811, 20813,
20853, 20918, 20919, 21029, 21028, 21033, 21034, 21032, 21163, 21161,
21162, 21164, 21283, 21363, 21365, 21533, 21549, 21534, 21566, 21542,
21582, 21543, 21574, 21571, 21555, 21576, 21570, 21531, 21545, 21578,
21561, 21563, 21560, 21550, 21557, 21558, 21536, 21564, 21568, 21553,
21547, 21535, 21548, 22250, 22256, 22244, 22251, 22346, 22353, 22336,
22349,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0, 22343, 22350, 22334, 22352, 22351,
22331, 22767, 22846, 22941, 22930, 22952, 22942, 22947, 22937, 22934,
22925, 22948, 22931, 22922, 22949, 23389, 23388, 23386, 23387, 23436,
23435, 23439, 23596, 23616, 23617, 23615, 23614, 23696, 23697, 23700,
23692, 24043, 24076, 24207, 24199, 24202, 24311, 24324, 24351, 24420,
24418, 24439, 24441, 24536, 24524, 24535, 24525, 24561, 24555, 24568,
24554, 25106, 25105, 25220, 25239, 25238, 25216, 25206, 25225, 25197,
25226, 25212, 25214, 25209, 25203, 25234, 25199, 25240, 25198, 25237,
25235, 25233, 25222, 25913, 25915, 25912, 26097, 26356, 26463, 26446,
26447, 26448, 26449, 26460, 26454, 26462, 26441, 26438, 26464, 26451,
26455, 27493, 27599, 27714, 27742, 27801, 27777, 27784, 27785, 27781,
27803, 27754, 27770, 27792, 27760, 27788, 27752, 27798, 27794, 27773,
27779, 27762, 27774, 27764, 27782, 27766, 27789, 27796, 27800, 27778,
28790, 28796, 28797, 28792, 29282, 29281, 29280, 29380, 29378, 29590,
29996, 29995, 30007, 30008, 30338, 30447, 30691, 31169, 31168, 31167,
31350, 31995, 32597, 32918, 32915, 32925, 32920, 32923, 32922, 32946,
33391, 33426,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0, 33419, 33421, 35211, 35282,
35328, 35895, 35910, 35925, 35997, 36196, 36208, 36275, 36523, 36554,
36763, 36784, 36802, 36806, 36805, 36804, 24033, 37009, 37026, 37034,
37030, 37027, 37193, 37318, 37324, 38450, 38446, 38449, 38442, 38444,
20006, 20054, 20083, 20107, 20123, 20126, 20139, 20140, 20335, 20381,
20365, 20339, 20351, 20332, 20379, 20363, 20358, 20355, 20336, 20341,
20360, 20329, 20347, 20374, 20350, 20367, 20369, 20346, 20820, 20818,
20821, 20841, 20855, 20854, 20856, 20925, 20989, 21051, 21048, 21047,
21050, 21040, 21038, 21046, 21057, 21182, 21179, 21330, 21332, 21331,
21329, 21350, 21367, 21368, 21369, 21462, 21460, 21463, 21619, 21621,
21654, 21624, 21653, 21632, 21627, 21623, 21636, 21650, 21638, 21628,
21648, 21617, 21622, 21644, 21658, 21602, 21608, 21643, 21629, 21646,
22266, 22403, 22391, 22378, 22377, 22369, 22374, 22372, 22396, 22812,
22857, 22855, 22856, 22852, 22868, 22974, 22971, 22996, 22969, 22958,
22993, 22982, 22992, 22989, 22987, 22995, 22986, 22959, 22963, 22994,
22981, 23391, 23396, 23395, 23447, 23450, 23448, 23452, 23449, 23451,
23578, 23624, 23621,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0, 23622, 23735, 23713,
23736, 23721, 23723, 23729, 23731, 24088, 24090, 24086, 24085, 24091,
24081, 24184, 24218, 24215, 24220, 24213, 24214, 24310, 24358, 24359,
24361, 24448, 24449, 24447, 24444, 24541, 24544, 24573, 24565, 24575,
24591, 24596, 24623, 24629, 24598, 24618, 24597, 24609, 24615, 24617,
24619, 24603, 25110, 25109, 25151, 25150, 25152, 25215, 25289, 25292,
25284, 25279, 25282, 25273, 25298, 25307, 25259, 25299, 25300, 25291,
25288, 25256, 25277, 25276, 25296, 25305, 25287, 25293, 25269, 25306,
25265, 25304, 25302, 25303, 25286, 25260, 25294, 25918, 26023, 26044,
26106, 26132, 26131, 26124, 26118, 26114, 26126, 26112, 26127, 26133,
26122, 26119, 26381, 26379, 26477, 26507, 26517, 26481, 26524, 26483,
26487, 26503, 26525, 26519, 26479, 26480, 26495, 26505, 26494, 26512,
26485, 26522, 26515, 26492, 26474, 26482, 27427, 27494, 27495, 27519,
27667, 27675, 27875, 27880, 27891, 27825, 27852, 27877, 27827, 27837,
27838, 27836, 27874, 27819, 27861, 27859, 27832, 27844, 27833, 27841,
27822, 27863, 27845, 27889, 27839, 27835, 27873, 27867, 27850, 27820,
27887, 27868, 27862, 27872,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0, 28821, 28814,
28818, 28810, 28825, 29228, 29229, 29240, 29256, 29287, 29289, 29376,
29390, 29401, 29399, 29392, 29609, 29608, 29599, 29611, 29605, 30013,
30109, 30105, 30106, 30340, 30402, 30450, 30452, 30693, 30717, 31038,
31040, 31041, 31177, 31176, 31354, 31353, 31482, 31998, 32596, 32652,
32651, 32773, 32954, 32933, 32930, 32945, 32929, 32939, 32937, 32948,
32938, 32943, 33253, 33278, 33293, 33459, 33437, 33433, 33453, 33469,
33439, 33465, 33457, 33452, 33445, 33455, 33464, 33443, 33456, 33470,
33463, 34382, 34417, 21021, 34920, 36555, 36814, 36820, 36817, 37045,
37048, 37041, 37046, 37319, 37329, 38263, 38272, 38428, 38464, 38463,
38459, 38468, 38466, 38585, 38632, 38738, 38750, 20127, 20141, 20142,
20449, 20405, 20399, 20415, 20448, 20433, 20431, 20445, 20419, 20406,
20440, 20447, 20426, 20439, 20398, 20432, 20420, 20418, 20442, 20430,
20446, 20407, 20823, 20882, 20881, 20896, 21070, 21059, 21066, 21069,
21068, 21067, 21063, 21191, 21193, 21187, 21185, 21261, 21335, 21371,
21402, 21467, 21676, 21696, 21672, 21710, 21705, 21688, 21670, 21683,
21703, 21698, 21693, 21674, 21697,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0, 21700,
21704, 21679, 21675, 21681, 21691, 21673, 21671, 21695, 22271, 22402,
22411, 22432, 22435, 22434, 22478, 22446, 22419, 22869, 22865, 22863,
22862, 22864, 23004, 23000, 23039, 23011, 23016, 23043, 23013, 23018,
23002, 23014, 23041, 23035, 23401, 23459, 23462, 23460, 23458, 23461,
23553, 23630, 23631, 23629, 23627, 23769, 23762, 24055, 24093, 24101,
24095, 24189, 24224, 24230, 24314, 24328, 24365, 24421, 24456, 24453,
24458, 24459, 24455, 24460, 24457, 24594, 24605, 24608, 24613, 24590,
24616, 24653, 24688, 24680, 24674, 24646, 24643, 24684, 24683, 24682,
24676, 25153, 25308, 25366, 25353, 25340, 25325, 25345, 25326, 25341,
25351, 25329, 25335, 25327, 25324, 25342, 25332, 25361, 25346, 25919,
25925, 26027, 26045, 26082, 26149, 26157, 26144, 26151, 26159, 26143,
26152, 26161, 26148, 26359, 26623, 26579, 26609, 26580, 26576, 26604,
26550, 26543, 26613, 26601, 26607, 26564, 26577, 26548, 26586, 26597,
26552, 26575, 26590, 26611, 26544, 26585, 26594, 26589, 26578, 27498,
27523, 27526, 27573, 27602, 27607, 27679, 27849, 27915, 27954, 27946,
27969, 27941, 27916, 27953, 27934, 27927,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
27963, 27965, 27966, 27958, 27931, 27893, 27961, 27943, 27960, 27945,
27950, 27957, 27918, 27947, 28843, 28858, 28851, 28844, 28847, 28845,
28856, 28846, 28836, 29232, 29298, 29295, 29300, 29417, 29408, 29409,
29623, 29642, 29627, 29618, 29645, 29632, 29619, 29978, 29997, 30031,
30028, 30030, 30027, 30123, 30116, 30117, 30114, 30115, 30328, 30342,
30343, 30344, 30408, 30406, 30403, 30405, 30465, 30457, 30456, 30473,
30475, 30462, 30460, 30471, 30684, 30722, 30740, 30732, 30733, 31046,
31049, 31048, 31047, 31161, 31162, 31185, 31186, 31179, 31359, 31361,
31487, 31485, 31869, 32002, 32005, 32000, 32009, 32007, 32004, 32006,
32568, 32654, 32703, 32772, 32784, 32781, 32785, 32822, 32982, 32997,
32986, 32963, 32964, 32972, 32993, 32987, 32974, 32990, 32996, 32989,
33268, 33314, 33511, 33539, 33541, 33507, 33499, 33510, 33540, 33509,
33538, 33545, 33490, 33495, 33521, 33537, 33500, 33492, 33489, 33502,
33491, 33503, 33519, 33542, 34384, 34425, 34427, 34426, 34893, 34923,
35201, 35284, 35336, 35330, 35331, 35998, 36000, 36212, 36211, 36276,
36557, 36556, 36848, 36838, 36834, 36842, 36837,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0, 36845, 36843, 36836, 36840, 37066, 37070, 37057, 37059, 37195,
37194, 37325, 38274, 38480, 38475, 38476, 38477, 38754, 38761, 38859,
38893, 38899, 38913, 39080, 39131, 39135, 39318, 39321, 20056, 20147,
20492, 20493, 20515, 20463, 20518, 20517, 20472, 20521, 20502, 20486,
20540, 20511, 20506, 20498, 20497, 20474, 20480, 20500, 20520, 20465,
20513, 20491, 20505, 20504, 20467, 20462, 20525, 20522, 20478, 20523,
20489, 20860, 20900, 20901, 20898, 20941, 20940, 20934, 20939, 21078,
21084, 21076, 21083, 21085, 21290, 21375, 21407, 21405, 21471, 21736,
21776, 21761, 21815, 21756, 21733, 21746, 21766, 21754, 21780, 21737,
21741, 21729, 21769, 21742, 21738, 21734, 21799, 21767, 21757, 21775,
22275, 22276, 22466, 22484, 22475, 22467, 22537, 22799, 22871, 22872,
22874, 23057, 23064, 23068, 23071, 23067, 23059, 23020, 23072, 23075,
23081, 23077, 23052, 23049, 23403, 23640, 23472, 23475, 23478, 23476,
23470, 23477, 23481, 23480, 23556, 23633, 23637, 23632, 23789, 23805,
23803, 23786, 23784, 23792, 23798, 23809, 23796, 24046, 24109, 24107,
24235, 24237, 24231, 24369, 24466, 24465, 24464, 24665,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0, 24675, 24677, 24656, 24661, 24685, 24681, 24687, 24708,
24735, 24730, 24717, 24724, 24716, 24709, 24726, 25159, 25331, 25352,
25343, 25422, 25406, 25391, 25429, 25410, 25414, 25423, 25417, 25402,
25424, 25405, 25386, 25387, 25384, 25421, 25420, 25928, 25929, 26009,
26049, 26053, 26178, 26185, 26191, 26179, 26194, 26188, 26181, 26177,
26360, 26388, 26389, 26391, 26657, 26680, 26696, 26694, 26707, 26681,
26690, 26708, 26665, 26803, 26647, 26700, 26705, 26685, 26612, 26704,
26688, 26684, 26691, 26666, 26693, 26643, 26648, 26689, 27530, 27529,
27575, 27683, 27687, 27688, 27686, 27684, 27888, 28010, 28053, 28040,
28039, 28006, 28024, 28023, 27993, 28051, 28012, 28041, 28014, 27994,
28020, 28009, 28044, 28042, 28025, 28037, 28005, 28052, 28874, 28888,
28900, 28889, 28872, 28879, 29241, 29305, 29436, 29433, 29437, 29432,
29431, 29574, 29677, 29705, 29678, 29664, 29674, 29662, 30036, 30045,
30044, 30042, 30041, 30142, 30149, 30151, 30130, 30131, 30141, 30140,
30137, 30146, 30136, 30347, 30384, 30410, 30413, 30414, 30505, 30495,
30496, 30504, 30697, 30768, 30759, 30776, 30749, 30772, 30775,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0, 30757, 30765, 30752, 30751, 30770, 31061, 31056,
31072, 31071, 31062, 31070, 31069, 31063, 31066, 31204, 31203, 31207,
31199, 31206, 31209, 31192, 31364, 31368, 31449, 31494, 31505, 31881,
32033, 32023, 32011, 32010, 32032, 32034, 32020, 32016, 32021, 32026,
32028, 32013, 32025, 32027, 32570, 32607, 32660, 32709, 32705, 32774,
32792, 32789, 32793, 32791, 32829, 32831, 33009, 33026, 33008, 33029,
33005, 33012, 33030, 33016, 33011, 33032, 33021, 33034, 33020, 33007,
33261, 33260, 33280, 33296, 33322, 33323, 33320, 33324, 33467, 33579,
33618, 33620, 33610, 33592, 33616, 33609, 33589, 33588, 33615, 33586,
33593, 33590, 33559, 33600, 33585, 33576, 33603, 34388, 34442, 34474,
34451, 34468, 34473, 34444, 34467, 34460, 34928, 34935, 34945, 34946,
34941, 34937, 35352, 35344, 35342, 35340, 35349, 35338, 35351, 35347,
35350, 35343, 35345, 35912, 35962, 35961, 36001, 36002, 36215, 36524,
36562, 36564, 36559, 36785, 36865, 36870, 36855, 36864, 36858, 36852,
36867, 36861, 36869, 36856, 37013, 37089, 37085, 37090, 37202, 37197,
37196, 37336, 37341, 37335, 37340, 37337, 38275, 38498, 38499, 38497,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0, 38491, 38493, 38500, 38488, 38494, 38587,
39138, 39340, 39592, 39640, 39717, 39730, 39740, 20094, 20602, 20605,
20572, 20551, 20547, 20556, 20570, 20553, 20581, 20598, 20558, 20565,
20597, 20596, 20599, 20559, 20495, 20591, 20589, 20828, 20885, 20976,
21098, 21103, 21202, 21209, 21208, 21205, 21264, 21263, 21273, 21311,
21312, 21310, 21443, 26364, 21830, 21866, 21862, 21828, 21854, 21857,
21827, 21834, 21809, 21846, 21839, 21845, 21807, 21860, 21816, 21806,
21852, 21804, 21859, 21811, 21825, 21847, 22280, 22283, 22281, 22495,
22533, 22538, 22534, 22496, 22500, 22522, 22530, 22581, 22519, 22521,
22816, 22882, 23094, 23105, 23113, 23142, 23146, 23104, 23100, 23138,
23130, 23110, 23114, 23408, 23495, 23493, 23492, 23490, 23487, 23494,
23561, 23560, 23559, 23648, 23644, 23645, 23815, 23814, 23822, 23835,
23830, 23842, 23825, 23849, 23828, 23833, 23844, 23847, 23831, 24034,
24120, 24118, 24115, 24119, 24247, 24248, 24246, 24245, 24254, 24373,
24375, 24407, 24428, 24425, 24427, 24471, 24473, 24478, 24472, 24481,
24480, 24476, 24703, 24739, 24713, 24736, 24744, 24779, 24756, 24806,
24765,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0, 24773, 24763, 24757, 24796, 24764,
24792, 24789, 24774, 24799, 24760, 24794, 24775, 25114, 25115, 25160,
25504, 25511, 25458, 25494, 25506, 25509, 25463, 25447, 25496, 25514,
25457, 25513, 25481, 25475, 25499, 25451, 25512, 25476, 25480, 25497,
25505, 25516, 25490, 25487, 25472, 25467, 25449, 25448, 25466, 25949,
25942, 25937, 25945, 25943, 21855, 25935, 25944, 25941, 25940, 26012,
26011, 26028, 26063, 26059, 26060, 26062, 26205, 26202, 26212, 26216,
26214, 26206, 26361, 21207, 26395, 26753, 26799, 26786, 26771, 26805,
26751, 26742, 26801, 26791, 26775, 26800, 26755, 26820, 26797, 26758,
26757, 26772, 26781, 26792, 26783, 26785, 26754, 27442, 27578, 27627,
27628, 27691, 28046, 28092, 28147, 28121, 28082, 28129, 28108, 28132,
28155, 28154, 28165, 28103, 28107, 28079, 28113, 28078, 28126, 28153,
28088, 28151, 28149, 28101, 28114, 28186, 28085, 28122, 28139, 28120,
28138, 28145, 28142, 28136, 28102, 28100, 28074, 28140, 28095, 28134,
28921, 28937, 28938, 28925, 28911, 29245, 29309, 29313, 29468, 29467,
29462, 29459, 29465, 29575, 29701, 29706, 29699, 29702, 29694, 29709,
29920, 29942,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0, 29943, 29980, 29986, 30053,
30054, 30050, 30064, 30095, 30164, 30165, 30133, 30154, 30157, 30350,
30420, 30418, 30427, 30519, 30526, 30524, 30518, 30520, 30522, 30827,
30787, 30798, 31077, 31080, 31085, 31227, 31378, 31381, 31520, 31528,
31515, 31532, 31526, 31513, 31518, 31534, 31890, 31895, 31893, 32070,
32067, 32113, 32046, 32057, 32060, 32064, 32048, 32051, 32068, 32047,
32066, 32050, 32049, 32573, 32670, 32666, 32716, 32718, 32722, 32796,
32842, 32838, 33071, 33046, 33059, 33067, 33065, 33072, 33060, 33282,
33333, 33335, 33334, 33337, 33678, 33694, 33688, 33656, 33698, 33686,
33725, 33707, 33682, 33674, 33683, 33673, 33696, 33655, 33659, 33660,
33670, 33703, 34389, 24426, 34503, 34496, 34486, 34500, 34485, 34502,
34507, 34481, 34479, 34505, 34899, 34974, 34952, 34987, 34962, 34966,
34957, 34955, 35219, 35215, 35370, 35357, 35363, 35365, 35377, 35373,
35359, 35355, 35362, 35913, 35930, 36009, 36012, 36011, 36008, 36010,
36007, 36199, 36198, 36286, 36282, 36571, 36575, 36889, 36877, 36890,
36887, 36899, 36895, 36893, 36880, 36885, 36894, 36896, 36879, 36898,
36886, 36891, 36884,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0, 37096, 37101, 37117,
37207, 37326, 37365, 37350, 37347, 37351, 37357, 37353, 38281, 38506,
38517, 38515, 38520, 38512, 38516, 38518, 38519, 38508, 38592, 38634,
38633, 31456, 31455, 38914, 38915, 39770, 40165, 40565, 40575, 40613,
40635, 20642, 20621, 20613, 20633, 20625, 20608, 20630, 20632, 20634,
26368, 20977, 21106, 21108, 21109, 21097, 21214, 21213, 21211, 21338,
21413, 21883, 21888, 21927, 21884, 21898, 21917, 21912, 21890, 21916,
21930, 21908, 21895, 21899, 21891, 21939, 21934, 21919, 21822, 21938,
21914, 21947, 21932, 21937, 21886, 21897, 21931, 21913, 22285, 22575,
22570, 22580, 22564, 22576, 22577, 22561, 22557, 22560, 22777, 22778,
22880, 23159, 23194, 23167, 23186, 23195, 23207, 23411, 23409, 23506,
23500, 23507, 23504, 23562, 23563, 23601, 23884, 23888, 23860, 23879,
24061, 24133, 24125, 24128, 24131, 24190, 24266, 24257, 24258, 24260,
24380, 24429, 24489, 24490, 24488, 24785, 24801, 24754, 24758, 24800,
24860, 24867, 24826, 24853, 24816, 24827, 24820, 24936, 24817, 24846,
24822, 24841, 24832, 24850, 25119, 25161, 25507, 25484, 25551, 25536,
25577, 25545, 25542, 25549,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0, 25554, 25571,
25552, 25569, 25558, 25581, 25582, 25462, 25588, 25578, 25563, 25682,
25562, 25593, 25950, 25958, 25954, 25955, 26001, 26000, 26031, 26222,
26224, 26228, 26230, 26223, 26257, 26234, 26238, 26231, 26366, 26367,
26399, 26397, 26874, 26837, 26848, 26840, 26839, 26885, 26847, 26869,
26862, 26855, 26873, 26834, 26866, 26851, 26827, 26829, 26893, 26898,
26894, 26825, 26842, 26990, 26875, 27454, 27450, 27453, 27544, 27542,
27580, 27631, 27694, 27695, 27692, 28207, 28216, 28244, 28193, 28210,
28263, 28234, 28192, 28197, 28195, 28187, 28251, 28248, 28196, 28246,
28270, 28205, 28198, 28271, 28212, 28237, 28218, 28204, 28227, 28189,
28222, 28363, 28297, 28185, 28238, 28259, 28228, 28274, 28265, 28255,
28953, 28954, 28966, 28976, 28961, 28982, 29038, 28956, 29260, 29316,
29312, 29494, 29477, 29492, 29481, 29754, 29738, 29747, 29730, 29733,
29749, 29750, 29748, 29743, 29723, 29734, 29736, 29989, 29990, 30059,
30058, 30178, 30171, 30179, 30169, 30168, 30174, 30176, 30331, 30332,
30358, 30355, 30388, 30428, 30543, 30701, 30813, 30828, 30831, 31245,
31240, 31243, 31237, 31232, 31384,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0, 31383,
31382, 31461, 31459, 31561, 31574, 31558, 31568, 31570, 31572, 31565,
31563, 31567, 31569, 31903, 31909, 32094, 32080, 32104, 32085, 32043,
32110, 32114, 32097, 32102, 32098, 32112, 32115, 21892, 32724, 32725,
32779, 32850, 32901, 33109, 33108, 33099, 33105, 33102, 33081, 33094,
33086, 33100, 33107, 33140, 33298, 33308, 33769, 33795, 33784, 33805,
33760, 33733, 33803, 33729, 33775, 33777, 33780, 33879, 33802, 33776,
33804, 33740, 33789, 33778, 33738, 33848, 33806, 33796, 33756, 33799,
33748, 33759, 34395, 34527, 34521, 34541, 34516, 34523, 34532, 34512,
34526, 34903, 35009, 35010, 34993, 35203, 35222, 35387, 35424, 35413,
35422, 35388, 35393, 35412, 35419, 35408, 35398, 35380, 35386, 35382,
35414, 35937, 35970, 36015, 36028, 36019, 36029, 36033, 36027, 36032,
36020, 36023, 36022, 36031, 36024, 36234, 36229, 36225, 36302, 36317,
36299, 36314, 36305, 36300, 36315, 36294, 36603, 36600, 36604, 36764,
36910, 36917, 36913, 36920, 36914, 36918, 37122, 37109, 37129, 37118,
37219, 37221, 37327, 37396, 37397, 37411, 37385, 37406, 37389, 37392,
37383, 37393, 38292, 38287, 38283, 38289,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
38291, 38290, 38286, 38538, 38542, 38539, 38525, 38533, 38534, 38541,
38514, 38532, 38593, 38597, 38596, 38598, 38599, 38639, 38642, 38860,
38917, 38918, 38920, 39143, 39146, 39151, 39145, 39154, 39149, 39342,
39341, 40643, 40653, 40657, 20098, 20653, 20661, 20658, 20659, 20677,
20670, 20652, 20663, 20667, 20655, 20679, 21119, 21111, 21117, 21215,
21222, 21220, 21218, 21219, 21295, 21983, 21992, 21971, 21990, 21966,
21980, 21959, 21969, 21987, 21988, 21999, 21978, 21985, 21957, 21958,
21989, 21961, 22290, 22291, 22622, 22609, 22616, 22615, 22618, 22612,
22635, 22604, 22637, 22602, 22626, 22610, 22603, 22887, 23233, 23241,
23244, 23230, 23229, 23228, 23219, 23234, 23218, 23913, 23919, 24140,
24185, 24265, 24264, 24338, 24409, 24492, 24494, 24858, 24847, 24904,
24863, 24819, 24859, 24825, 24833, 24840, 24910, 24908, 24900, 24909,
24894, 24884, 24871, 24845, 24838, 24887, 25121, 25122, 25619, 25662,
25630, 25642, 25645, 25661, 25644, 25615, 25628, 25620, 25613, 25654,
25622, 25623, 25606, 25964, 26015, 26032, 26263, 26249, 26247, 26248,
26262, 26244, 26264, 26253, 26371, 27028, 26989,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0, 26970, 26999, 26976, 26964, 26997, 26928, 27010, 26954, 26984,
26987, 26974, 26963, 27001, 27014, 26973, 26979, 26971, 27463, 27506,
27584, 27583, 27603, 27645, 28322, 28335, 28371, 28342, 28354, 28304,
28317, 28359, 28357, 28325, 28312, 28348, 28346, 28331, 28369, 28310,
28316, 28356, 28372, 28330, 28327, 28340, 29006, 29017, 29033, 29028,
29001, 29031, 29020, 29036, 29030, 29004, 29029, 29022, 28998, 29032,
29014, 29242, 29266, 29495, 29509, 29503, 29502, 29807, 29786, 29781,
29791, 29790, 29761, 29759, 29785, 29787, 29788, 30070, 30072, 30208,
30192, 30209, 30194, 30193, 30202, 30207, 30196, 30195, 30430, 30431,
30555, 30571, 30566, 30558, 30563, 30585, 30570, 30572, 30556, 30565,
30568, 30562, 30702, 30862, 30896, 30871, 30872, 30860, 30857, 30844,
30865, 30867, 30847, 31098, 31103, 31105, 33836, 31165, 31260, 31258,
31264, 31252, 31263, 31262, 31391, 31392, 31607, 31680, 31584, 31598,
31591, 31921, 31923, 31925, 32147, 32121, 32145, 32129, 32143, 32091,
32622, 32617, 32618, 32626, 32681, 32680, 32676, 32854, 32856, 32902,
32900, 33137, 33136, 33144, 33125, 33134, 33139, 33131,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0, 33145, 33146, 33126, 33285, 33351, 33922, 33911, 33853,
33841, 33909, 33894, 33899, 33865, 33900, 33883, 33852, 33845, 33889,
33891, 33897, 33901, 33862, 34398, 34396, 34399, 34553, 34579, 34568,
34567, 34560, 34558, 34555, 34562, 34563, 34566, 34570, 34905, 35039,
35028, 35033, 35036, 35032, 35037, 35041, 35018, 35029, 35026, 35228,
35299, 35435, 35442, 35443, 35430, 35433, 35440, 35463, 35452, 35427,
35488, 35441, 35461, 35437, 35426, 35438, 35436, 35449, 35451, 35390,
35432, 35938, 35978, 35977, 36042, 36039, 36040, 36036, 36018, 36035,
36034, 36037, 36321, 36319, 36328, 36335, 36339, 36346, 36330, 36324,
36326, 36530, 36611, 36617, 36606, 36618, 36767, 36786, 36939, 36938,
36947, 36930, 36948, 36924, 36949, 36944, 36935, 36943, 36942, 36941,
36945, 36926, 36929, 37138, 37143, 37228, 37226, 37225, 37321, 37431,
37463, 37432, 37437, 37440, 37438, 37467, 37451, 37476, 37457, 37428,
37449, 37453, 37445, 37433, 37439, 37466, 38296, 38552, 38548, 38549,
38605, 38603, 38601, 38602, 38647, 38651, 38649, 38646, 38742, 38772,
38774, 38928, 38929, 38931, 38922, 38930, 38924, 39164, 39156,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0, 39165, 39166, 39347, 39345, 39348, 39649, 40169,
40578, 40718, 40723, 40736, 20711, 20718, 20709, 20694, 20717, 20698,
20693, 20687, 20689, 20721, 20686, 20713, 20834, 20979, 21123, 21122,
21297, 21421, 22014, 22016, 22043, 22039, 22013, 22036, 22022, 22025,
22029, 22030, 22007, 22038, 22047, 22024, 22032, 22006, 22296, 22294,
22645, 22654, 22659, 22675, 22666, 22649, 22661, 22653, 22781, 22821,
22818, 22820, 22890, 22889, 23265, 23270, 23273, 23255, 23254, 23256,
23267, 23413, 23518, 23527, 23521, 23525, 23526, 23528, 23522, 23524,
23519, 23565, 23650, 23940, 23943, 24155, 24163, 24149, 24151, 24148,
24275, 24278, 24330, 24390, 24432, 24505, 24903, 24895, 24907, 24951,
24930, 24931, 24927, 24922, 24920, 24949, 25130, 25735, 25688, 25684,
25764, 25720, 25695, 25722, 25681, 25703, 25652, 25709, 25723, 25970,
26017, 26071, 26070, 26274, 26280, 26269, 27036, 27048, 27029, 27073,
27054, 27091, 27083, 27035, 27063, 27067, 27051, 27060, 27088, 27085,
27053, 27084, 27046, 27075, 27043, 27465, 27468, 27699, 28467, 28436,
28414, 28435, 28404, 28457, 28478, 28448, 28460, 28431, 28418, 28450,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0, 28415, 28399, 28422, 28465, 28472, 28466,
28451, 28437, 28459, 28463, 28552, 28458, 28396, 28417, 28402, 28364,
28407, 29076, 29081, 29053, 29066, 29060, 29074, 29246, 29330, 29334,
29508, 29520, 29796, 29795, 29802, 29808, 29805, 29956, 30097, 30247,
30221, 30219, 30217, 30227, 30433, 30435, 30596, 30589, 30591, 30561,
30913, 30879, 30887, 30899, 30889, 30883, 31118, 31119, 31117, 31278,
31281, 31402, 31401, 31469, 31471, 31649, 31637, 31627, 31605, 31639,
31645, 31636, 31631, 31672, 31623, 31620, 31929, 31933, 31934, 32187,
32176, 32156, 32189, 32190, 32160, 32202, 32180, 32178, 32177, 32186,
32162, 32191, 32181, 32184, 32173, 32210, 32199, 32172, 32624, 32736,
32737, 32735, 32862, 32858, 32903, 33104, 33152, 33167, 33160, 33162,
33151, 33154, 33255, 33274, 33287, 33300, 33310, 33355, 33993, 33983,
33990, 33988, 33945, 33950, 33970, 33948, 33995, 33976, 33984, 34003,
33936, 33980, 34001, 33994, 34623, 34588, 34619, 34594, 34597, 34612,
34584, 34645, 34615, 34601, 35059, 35074, 35060, 35065, 35064, 35069,
35048, 35098, 35055, 35494, 35468, 35486, 35491, 35469, 35489, 35475,
35492,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0, 35498, 35493, 35496, 35480, 35473,
35482, 35495, 35946, 35981, 35980, 36051, 36049, 36050, 36203, 36249,
36245, 36348, 36628, 36626, 36629, 36627, 36771, 36960, 36952, 36956,
36963, 36953, 36958, 36962, 36957, 36955, 37145, 37144, 37150, 37237,
37240, 37239, 37236, 37496, 37504, 37509, 37528, 37526, 37499, 37523,
37532, 37544, 37500, 37521, 38305, 38312, 38313, 38307, 38309, 38308,
38553, 38556, 38555, 38604, 38610, 38656, 38780, 38789, 38902, 38935,
38936, 39087, 39089, 39171, 39173, 39180, 39177, 39361, 39599, 39600,
39654, 39745, 39746, 40180, 40182, 40179, 40636, 40763, 40778, 20740,
20736, 20731, 20725, 20729, 20738, 20744, 20745, 20741, 20956, 21127,
21128, 21129, 21133, 21130, 21232, 21426, 22062, 22075, 22073, 22066,
22079, 22068, 22057, 22099, 22094, 22103, 22132, 22070, 22063, 22064,
22656, 22687, 22686, 22707, 22684, 22702, 22697, 22694, 22893, 23305,
23291, 23307, 23285, 23308, 23304, 23534, 23532, 23529, 23531, 23652,
23653, 23965, 23956, 24162, 24159, 24161, 24290, 24282, 24287, 24285,
24291, 24288, 24392, 24433, 24503, 24501, 24950, 24935, 24942, 24925,
24917, 24962,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0, 24956, 24944, 24939, 24958,
24999, 24976, 25003, 24974, 25004, 24986, 24996, 24980, 25006, 25134,
25705, 25711, 25721, 25758, 25778, 25736, 25744, 25776, 25765, 25747,
25749, 25769, 25746, 25774, 25773, 25771, 25754, 25772, 25753, 25762,
25779, 25973, 25975, 25976, 26286, 26283, 26292, 26289, 27171, 27167,
27112, 27137, 27166, 27161, 27133, 27169, 27155, 27146, 27123, 27138,
27141, 27117, 27153, 27472, 27470, 27556, 27589, 27590, 28479, 28540,
28548, 28497, 28518, 28500, 28550, 28525, 28507, 28536, 28526, 28558,
28538, 28528, 28516, 28567, 28504, 28373, 28527, 28512, 28511, 29087,
29100, 29105, 29096, 29270, 29339, 29518, 29527, 29801, 29835, 29827,
29822, 29824, 30079, 30240, 30249, 30239, 30244, 30246, 30241, 30242,
30362, 30394, 30436, 30606, 30599, 30604, 30609, 30603, 30923, 30917,
30906, 30922, 30910, 30933, 30908, 30928, 31295, 31292, 31296, 31293,
31287, 31291, 31407, 31406, 31661, 31665, 31684, 31668, 31686, 31687,
31681, 31648, 31692, 31946, 32224, 32244, 32239, 32251, 32216, 32236,
32221, 32232, 32227, 32218, 32222, 32233, 32158, 32217, 32242, 32249,
32629, 32631, 32687,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0, 32745, 32806, 33179,
33180, 33181, 33184, 33178, 33176, 34071, 34109, 34074, 34030, 34092,
34093, 34067, 34065, 34083, 34081, 34068, 34028, 34085, 34047, 34054,
34690, 34676, 34678, 34656, 34662, 34680, 34664, 34649, 34647, 34636,
34643, 34907, 34909, 35088, 35079, 35090, 35091, 35093, 35082, 35516,
35538, 35527, 35524, 35477, 35531, 35576, 35506, 35529, 35522, 35519,
35504, 35542, 35533, 35510, 35513, 35547, 35916, 35918, 35948, 36064,
36062, 36070, 36068, 36076, 36077, 36066, 36067, 36060, 36074, 36065,
36205, 36255, 36259, 36395, 36368, 36381, 36386, 36367, 36393, 36383,
36385, 36382, 36538, 36637, 36635, 36639, 36649, 36646, 36650, 36636,
36638, 36645, 36969, 36974, 36968, 36973, 36983, 37168, 37165, 37159,
37169, 37255, 37257, 37259, 37251, 37573, 37563, 37559, 37610, 37548,
37604, 37569, 37555, 37564, 37586, 37575, 37616, 37554, 38317, 38321,
38660, 38662, 38663, 38665, 38752, 38797, 38795, 38799, 38945, 38955,
38940, 39091, 39178, 39187, 39186, 39192, 39389, 39376, 39391, 39387,
39377, 39381, 39378, 39385, 39607, 39662, 39663, 39719, 39749, 39748,
39799, 39791, 40198, 40201,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0, 40195, 40617,
40638, 40654, 22696, 40786, 20754, 20760, 20756, 20752, 20757, 20864,
20906, 20957, 21137, 21139, 21235, 22105, 22123, 22137, 22121, 22116,
22136, 22122, 22120, 22117, 22129, 22127, 22124, 22114, 22134, 22721,
22718, 22727, 22725, 22894, 23325, 23348, 23416, 23536, 23566, 24394,
25010, 24977, 25001, 24970, 25037, 25014, 25022, 25034, 25032, 25136,
25797, 25793, 25803, 25787, 25788, 25818, 25796, 25799, 25794, 25805,
25791, 25810, 25812, 25790, 25972, 26310, 26313, 26297, 26308, 26311,
26296, 27197, 27192, 27194, 27225, 27243, 27224, 27193, 27204, 27234,
27233, 27211, 27207, 27189, 27231, 27208, 27481, 27511, 27653, 28610,
28593, 28577, 28611, 28580, 28609, 28583, 28595, 28608, 28601, 28598,
28582, 28576, 28596, 29118, 29129, 29136, 29138, 29128, 29141, 29113,
29134, 29145, 29148, 29123, 29124, 29544, 29852, 29859, 29848, 29855,
29854, 29922, 29964, 29965, 30260, 30264, 30266, 30439, 30437, 30624,
30622, 30623, 30629, 30952, 30938, 30956, 30951, 31142, 31309, 31310,
31302, 31308, 31307, 31418, 31705, 31761, 31689, 31716, 31707, 31713,
31721, 31718, 31957, 31958, 32266,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0, 32273,
32264, 32283, 32291, 32286, 32285, 32265, 32272, 32633, 32690, 32752,
32753, 32750, 32808, 33203, 33193, 33192, 33275, 33288, 33368, 33369,
34122, 34137, 34120, 34152, 34153, 34115, 34121, 34157, 34154, 34142,
34691, 34719, 34718, 34722, 34701, 34913, 35114, 35122, 35109, 35115,
35105, 35242, 35238, 35558, 35578, 35563, 35569, 35584, 35548, 35559,
35566, 35582, 35585, 35586, 35575, 35565, 35571, 35574, 35580, 35947,
35949, 35987, 36084, 36420, 36401, 36404, 36418, 36409, 36405, 36667,
36655, 36664, 36659, 36776, 36774, 36981, 36980, 36984, 36978, 36988,
36986, 37172, 37266, 37664, 37686, 37624, 37683, 37679, 37666, 37628,
37675, 37636, 37658, 37648, 37670, 37665, 37653, 37678, 37657, 38331,
38567, 38568, 38570, 38613, 38670, 38673, 38678, 38669, 38675, 38671,
38747, 38748, 38758, 38808, 38960, 38968, 38971, 38967, 38957, 38969,
38948, 39184, 39208, 39198, 39195, 39201, 39194, 39405, 39394, 39409,
39608, 39612, 39675, 39661, 39720, 39825, 40213, 40227, 40230, 40232,
40210, 40219, 40664, 40660, 40845, 40860, 20778, 20767, 20769, 20786,
21237, 22158, 22144, 22160, 22149, 22151,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
22159, 22741, 22739, 22737, 22734, 23344, 23338, 23332, 23418, 23607,
23656, 23996, 23994, 23997, 23992, 24171, 24396, 24509, 25033, 25026,
25031, 25062, 25035, 25138, 25140, 25806, 25802, 25816, 25824, 25840,
25830, 25836, 25841, 25826, 25837, 25986, 25987, 26329, 26326, 27264,
27284, 27268, 27298, 27292, 27355, 27299, 27262, 27287, 27280, 27296,
27484, 27566, 27610, 27656, 28632, 28657, 28639, 28640, 28635, 28644,
28651, 28655, 28544, 28652, 28641, 28649, 28629, 28654, 28656, 29159,
29151, 29166, 29158, 29157, 29165, 29164, 29172, 29152, 29237, 29254,
29552, 29554, 29865, 29872, 29862, 29864, 30278, 30274, 30284, 30442,
30643, 30634, 30640, 30636, 30631, 30637, 30703, 30967, 30970, 30964,
30959, 30977, 31143, 31146, 31319, 31423, 31751, 31757, 31742, 31735,
31756, 31712, 31968, 31964, 31966, 31970, 31967, 31961, 31965, 32302,
32318, 32326, 32311, 32306, 32323, 32299, 32317, 32305, 32325, 32321,
32308, 32313, 32328, 32309, 32319, 32303, 32580, 32755, 32764, 32881,
32882, 32880, 32879, 32883, 33222, 33219, 33210, 33218, 33216, 33215,
33213, 33225, 33214, 33256, 33289, 33393, 34218,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0, 34180, 34174, 34204, 34193, 34196, 34223, 34203, 34183, 34216,
34186, 34407, 34752, 34769, 34739, 34770, 34758, 34731, 34747, 34746,
34760, 34763, 35131, 35126, 35140, 35128, 35133, 35244, 35598, 35607,
35609, 35611, 35594, 35616, 35613, 35588, 35600, 35905, 35903, 35955,
36090, 36093, 36092, 36088, 36091, 36264, 36425, 36427, 36424, 36426,
36676, 36670, 36674, 36677, 36671, 36991, 36989, 36996, 36993, 36994,
36992, 37177, 37283, 37278, 37276, 37709, 37762, 37672, 37749, 37706,
37733, 37707, 37656, 37758, 37740, 37723, 37744, 37722, 37716, 38346,
38347, 38348, 38344, 38342, 38577, 38584, 38614, 38684, 38686, 38816,
38867, 38982, 39094, 39221, 39425, 39423, 39854, 39851, 39850, 39853,
40251, 40255, 40587, 40655, 40670, 40668, 40669, 40667, 40766, 40779,
21474, 22165, 22190, 22745, 22744, 23352, 24413, 25059, 25139, 25844,
25842, 25854, 25862, 25850, 25851, 25847, 26039, 26332, 26406, 27315,
27308, 27331, 27323, 27320, 27330, 27310, 27311, 27487, 27512, 27567,
28681, 28683, 28670, 28678, 28666, 28689, 28687, 29179, 29180, 29182,
29176, 29559, 29557, 29863, 29887, 29973, 30294, 30296,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0, 30290, 30653, 30655, 30651, 30652, 30990, 31150, 31329,
31330, 31328, 31428, 31429, 31787, 31783, 31786, 31774, 31779, 31777,
31975, 32340, 32341, 32350, 32346, 32353, 32338, 32345, 32584, 32761,
32763, 32887, 32886, 33229, 33231, 33290, 34255, 34217, 34253, 34256,
34249, 34224, 34234, 34233, 34214, 34799, 34796, 34802, 34784, 35206,
35250, 35316, 35624, 35641, 35628, 35627, 35920, 36101, 36441, 36451,
36454, 36452, 36447, 36437, 36544, 36681, 36685, 36999, 36995, 37000,
37291, 37292, 37328, 37780, 37770, 37782, 37794, 37811, 37806, 37804,
37808, 37784, 37786, 37783, 38356, 38358, 38352, 38357, 38626, 38620,
38617, 38619, 38622, 38692, 38819, 38822, 38829, 38905, 38989, 38991,
38988, 38990, 38995, 39098, 39230, 39231, 39229, 39214, 39333, 39438,
39617, 39683, 39686, 39759, 39758, 39757, 39882, 39881, 39933, 39880,
39872, 40273, 40285, 40288, 40672, 40725, 40748, 20787, 22181, 22750,
22751, 22754, 23541, 40848, 24300, 25074, 25079, 25078, 25077, 25856,
25871, 26336, 26333, 27365, 27357, 27354, 27347, 28699, 28703, 28712,
28698, 28701, 28693, 28696, 29190, 29197, 29272, 29346, 29560,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0, 29562, 29885, 29898, 29923, 30087, 30086, 30303,
30305, 30663, 31001, 31153, 31339, 31337, 31806, 31807, 31800, 31805,
31799, 31808, 32363, 32365, 32377, 32361, 32362, 32645, 32371, 32694,
32697, 32696, 33240, 34281, 34269, 34282, 34261, 34276, 34277, 34295,
34811, 34821, 34829, 34809, 34814, 35168, 35167, 35158, 35166, 35649,
35676, 35672, 35657, 35674, 35662, 35663, 35654, 35673, 36104, 36106,
36476, 36466, 36487, 36470, 36460, 36474, 36468, 36692, 36686, 36781,
37002, 37003, 37297, 37294, 37857, 37841, 37855, 37827, 37832, 37852,
37853, 37846, 37858, 37837, 37848, 37860, 37847, 37864, 38364, 38580,
38627, 38698, 38695, 38753, 38876, 38907, 39006, 39000, 39003, 39100,
39237, 39241, 39446, 39449, 39693, 39912, 39911, 39894, 39899, 40329,
40289, 40306, 40298, 40300, 40594, 40599, 40595, 40628, 21240, 22184,
22199, 22198, 22196, 22204, 22756, 23360, 23363, 23421, 23542, 24009,
25080, 25082, 25880, 25876, 25881, 26342, 26407, 27372, 28734, 28720,
28722, 29200, 29563, 29903, 30306, 30309, 31014, 31018, 31020, 31019,
31431, 31478, 31820, 31811, 31821, 31983, 31984, 36782, 32381, 32380,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0, 32386, 32588, 32768, 33242, 33382, 34299,
34297, 34321, 34298, 34310, 34315, 34311, 34314, 34836, 34837, 35172,
35258, 35320, 35696, 35692, 35686, 35695, 35679, 35691, 36111, 36109,
36489, 36481, 36485, 36482, 37300, 37323, 37912, 37891, 37885, 38369,
38704, 39108, 39250, 39249, 39336, 39467, 39472, 39479, 39477, 39955,
39949, 40569, 40629, 40680, 40751, 40799, 40803, 40801, 20791, 20792,
22209, 22208, 22210, 22804, 23660, 24013, 25084, 25086, 25885, 25884,
26005, 26345, 27387, 27396, 27386, 27570, 28748, 29211, 29351, 29910,
29908, 30313, 30675, 31824, 32399, 32396, 32700, 34327, 34349, 34330,
34851, 34850, 34849, 34847, 35178, 35180, 35261, 35700, 35703, 35709,
36115, 36490, 36493, 36491, 36703, 36783, 37306, 37934, 37939, 37941,
37946, 37944, 37938, 37931, 38370, 38712, 38713, 38706, 38911, 39015,
39013, 39255, 39493, 39491, 39488, 39486, 39631, 39764, 39761, 39981,
39973, 40367, 40372, 40386, 40376, 40605, 40687, 40729, 40796, 40806,
40807, 20796, 20795, 22216, 22218, 22217, 23423, 24020, 24018, 24398,
25087, 25892, 27402, 27489, 28753, 28760, 29568, 29924, 30090, 30318,
30316,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0, 31155, 31840, 31839, 32894, 32893,
33247, 35186, 35183, 35324, 35712, 36118, 36119, 36497, 36499, 36705,
37192, 37956, 37969, 37970, 38717, 38718, 38851, 38849, 39019, 39253,
39509, 39501, 39634, 39706, 40009, 39985, 39998, 39995, 40403, 40407,
40756, 40812, 40810, 40852, 22220, 24022, 25088, 25891, 25899, 25898,
26348, 27408, 29914, 31434, 31844, 31843, 31845, 32403, 32406, 32404,
33250, 34360, 34367, 34865, 35722, 37008, 37007, 37987, 37984, 37988,
38760, 39023, 39260, 39514, 39515, 39511, 39635, 39636, 39633, 40020,
40023, 40022, 40421, 40607, 40692, 22225, 22761, 25900, 28766, 30321,
30322, 30679, 32592, 32648, 34870, 34873, 34914, 35731, 35730, 35734,
33399, 36123, 37312, 37994, 38722, 38728, 38724, 38854, 39024, 39519,
39714, 39768, 40031, 40441, 40442, 40572, 40573, 40711, 40823, 40818,
24307, 27414, 28771, 31852, 31854, 34875, 35264, 36513, 37313, 38002,
38000, 39025, 39262, 39638, 39715, 40652, 28772, 30682, 35738, 38007,
38857, 39522, 39525, 32412, 35740, 36522, 37317, 38013, 38014, 38012,
40055, 40056, 40695, 35924, 38015, 40474, 29224, 39530, 39729, 40475,
40478, 31858,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,  9312,  9313,  9314,  9315,
 9316,  9317,  9318,  9319,  9320,  9321,  9332,  9333,  9334,  9335,
 9336,  9337,  9338,  9339,  9340,  9341,  8560,  8561,  8562,  8563,
 8564,  8565,  8566,  8567,  8568,  8569, 20022, 20031, 20101, 20128,
20866, 20886, 20907, 21241, 21304, 21353, 21430, 22794, 23424, 24027,
24186, 24191, 24308, 24400, 24417, 25908, 26080, 30098, 30326, 36789,
38582,   168,   710, 12541, 12542, 12445, 12446, 12291, 20189, 12293,
12294, 12295, 12540, 65339, 65341, 10045, 12353, 12354, 12355, 12356,
12357, 12358, 12359, 12360, 12361, 12362, 12363, 12364, 12365, 12366,
12367, 12368, 12369, 12370, 12371, 12372, 12373, 12374, 12375, 12376,
12377, 12378, 12379, 12380, 12381, 12382, 12383, 12384, 12385, 12386,
12387, 12388, 12389, 12390, 12391, 12392, 12393, 12394, 12395, 12396,
12397, 12398, 12399, 12400, 12401, 12402, 12403, 12404, 12405, 12406,
12407, 12408, 12409, 12410, 12411, 12412, 12413, 12414, 12415, 12416,
12417, 12418, 12419, 12420, 12421, 12422, 12423, 12424, 12425, 12426,
12427, 12428, 12429, 12430, 12431, 12432, 12433, 12434, 12435, 12449,
12450, 12451, 12452,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0, 12453, 12454, 12455,
12456, 12457, 12458, 12459, 12460, 12461, 12462, 12463, 12464, 12465,
12466, 12467, 12468, 12469, 12470, 12471, 12472, 12473, 12474, 12475,
12476, 12477, 12478, 12479, 12480, 12481, 12482, 12483, 12484, 12485,
12486, 12487, 12488, 12489, 12490, 12491, 12492, 12493, 12494, 12495,
12496, 12497, 12498, 12499, 12500, 12501, 12502, 12503, 12504, 12505,
12506, 12507, 12508, 12509, 12510, 12511, 12512, 12513, 12514, 12515,
12516, 12517, 12518, 12519, 12520, 12521, 12522, 12523, 12524, 12525,
12526, 12527, 12528, 12529, 12530, 12531, 12532, 12533, 12534,  1040,
 1041,  1042,  1043,  1044,  1045,  1025,  1046,  1047,  1048,  1049,
 1050,  1051,  1052,  1053,  1054,  1055,  1056,  1057,  1058,  1059,
 1060,  1061,  1062,  1063,  1064,  1065,  1066,  1067,  1068,  1069,
 1070,  1071,  1072,  1073,  1074,  1075,  1076,  1077,  1105,  1078,
 1079,  1080,  1081,  1082,  1083,  1084,  1085,  1086,  1087,  1088,
 1089,  1090,  1091,  1092,  1093,  1094,  1095,  1096,  1097,  1098,
 1099,  1100,  1101,  1102,  1103,  8679,  8632,  8633, 12751, 63462,
20058, 63464, 20994, 17553,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0, 40880, 20872,
40881, 63470, 63471, 63472, 63473, 63474, 63475, 63476, 63477, 63478,
63479, 63480, 63481, 63482, 12443, 12444, 12436, 12535, 12536, 12537,
12538, 12539, 65377, 65378, 65379, 65380, 65381, 65382, 65383, 65384,
65385, 65386, 65387, 65388, 65389, 65390, 65391, 65392, 65393, 65394,
65395, 65396, 65506, 65508, 65287, 65282, 12849,  8470,  8481, 65397,
65398, 65399, 65400, 65401, 65402, 65403, 65404, 65405, 65406, 65407,
65408, 65409, 65410, 65411, 65412, 65413, 65414, 65415, 65416, 65417,
65418, 65419, 65420, 65421, 65422, 65423, 65424, 65425, 65426, 65427,
65428, 65429, 65430, 65431, 65432, 65433, 65434, 65435, 65436, 65437,
65438, 65439, 20034, 20060, 20981, 21274, 21378, 19975, 19980, 20039,
20109, 22231, 64012, 23662, 24435, 19983, 20871, 19982, 20014, 20115,
20162, 20169, 20168, 20888, 21244, 21356, 21433, 22304, 22787, 22828,
23568, 24063, 26081, 27571, 27596, 27668, 29247, 20017, 20028, 20200,
20188, 20201, 20193, 20189, 20186, 21004, 21276, 21324, 22306, 22307,
22807, 22831, 23425, 23428, 23570, 23611, 23668, 23667, 24068, 24192,
24194, 24521, 25097, 25168, 27669,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0, 27702,
27715, 27711, 27707, 29358, 29360, 29578, 31160, 32906, 38430, 20238,
20248, 20268, 20213, 20244, 20209, 20224, 20215, 20232, 20253, 20226,
20229, 20258, 20243, 20228, 20212, 20242, 20913, 21011, 21001, 21008,
21158, 21282, 21279, 21325, 21386, 21511, 22241, 22239, 22318, 22314,
22324, 22844, 22912, 22908, 22917, 22907, 22910, 22903, 22911, 23382,
23573, 23589, 23676, 23674, 23675, 23678, 24031, 24181, 24196, 24322,
24346, 24436, 24533, 24532, 24527, 25180, 25182, 25188, 25185, 25190,
25186, 25177, 25184, 25178, 25189, 26095, 26094, 26430, 26425, 26424,
26427, 26426, 26431, 26428, 26419, 27672, 27718, 27730, 27740, 27727,
27722, 27732, 27723, 27724, 28785, 29278, 29364, 29365, 29582, 29994,
30335, 31349, 32593, 33400, 33404, 33408, 33405, 33407, 34381, 35198,
37017, 37015, 37016, 37019, 37012, 38434, 38436, 38432, 38435, 20310,
20283, 20322, 20297, 20307, 20324, 20286, 20327, 20306, 20319, 20289,
20312, 20269, 20275, 20287, 20321, 20879, 20921, 21020, 21022, 21025,
21165, 21166, 21257, 21347, 21362, 21390, 21391, 21552, 21559, 21546,
21588, 21573, 21529, 21532, 21541, 21528,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
21565, 21583, 21569, 21544, 21540, 21575, 22254, 22247, 22245, 22337,
22341, 22348, 22345, 22347, 22354, 22790, 22848, 22950, 22936, 22944,
22935, 22926, 22946, 22928, 22927, 22951, 22945, 23438, 23442, 23592,
23594, 23693, 23695, 23688, 23691, 23689, 23698, 23690, 23686, 23699,
23701, 24032, 24074, 24078, 24203, 24201, 24204, 24200, 24205, 24325,
24349, 24440, 24438, 24530, 24529, 24528, 24557, 24552, 24558, 24563,
24545, 24548, 24547, 24570, 24559, 24567, 24571, 24576, 24564, 25146,
25219, 25228, 25230, 25231, 25236, 25223, 25201, 25211, 25210, 25200,
25217, 25224, 25207, 25213, 25202, 25204, 25911, 26096, 26100, 26099,
26098, 26101, 26437, 26439, 26457, 26453, 26444, 26440, 26461, 26445,
26458, 26443, 27600, 27673, 27674, 27768, 27751, 27755, 27780, 27787,
27791, 27761, 27759, 27753, 27802, 27757, 27783, 27797, 27804, 27750,
27763, 27749, 27771, 27790, 28788, 28794, 29283, 29375, 29373, 29379,
29382, 29377, 29370, 29381, 29589, 29591, 29587, 29588, 29586, 30010,
30009, 30100, 30101, 30337, 31037, 32820, 32917, 32921, 32912, 32914,
32924, 33424, 33423, 33413, 33422, 33425, 33427,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0, 33418, 33411, 33412, 35960, 36809, 36799, 37023, 37025, 37029,
37022, 37031, 37024, 38448, 38440, 38447, 38445, 20019, 20376, 20348,
20357, 20349, 20352, 20359, 20342, 20340, 20361, 20356, 20343, 20300,
20375, 20330, 20378, 20345, 20353, 20344, 20368, 20380, 20372, 20382,
20370, 20354, 20373, 20331, 20334, 20894, 20924, 20926, 21045, 21042,
21043, 21062, 21041, 21180, 21258, 21259, 21308, 21394, 21396, 21639,
21631, 21633, 21649, 21634, 21640, 21611, 21626, 21630, 21605, 21612,
21620, 21606, 21645, 21615, 21601, 21600, 21656, 21603, 21607, 21604,
22263, 22265, 22383, 22386, 22381, 22379, 22385, 22384, 22390, 22400,
22389, 22395, 22387, 22388, 22370, 22376, 22397, 22796, 22853, 22965,
22970, 22991, 22990, 22962, 22988, 22977, 22966, 22972, 22979, 22998,
22961, 22973, 22976, 22984, 22964, 22983, 23394, 23397, 23443, 23445,
23620, 23623, 23726, 23716, 23712, 23733, 23727, 23720, 23724, 23711,
23715, 23725, 23714, 23722, 23719, 23709, 23717, 23734, 23728, 23718,
24087, 24084, 24089, 24360, 24354, 24355, 24356, 24404, 24450, 24446,
24445, 24542, 24549, 24621, 24614, 24601, 24626, 24587,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0, 24628, 24586, 24599, 24627, 24602, 24606, 24620, 24610,
24589, 24592, 24622, 24595, 24593, 24588, 24585, 24604, 25108, 25149,
25261, 25268, 25297, 25278, 25258, 25270, 25290, 25262, 25267, 25263,
25275, 25257, 25264, 25272, 25917, 26024, 26043, 26121, 26108, 26116,
26130, 26120, 26107, 26115, 26123, 26125, 26117, 26109, 26129, 26128,
26358, 26378, 26501, 26476, 26510, 26514, 26486, 26491, 26520, 26502,
26500, 26484, 26509, 26508, 26490, 26527, 26513, 26521, 26499, 26493,
26497, 26488, 26489, 26516, 27429, 27520, 27518, 27614, 27677, 27795,
27884, 27883, 27886, 27865, 27830, 27860, 27821, 27879, 27831, 27856,
27842, 27834, 27843, 27846, 27885, 27890, 27858, 27869, 27828, 27786,
27805, 27776, 27870, 27840, 27952, 27853, 27847, 27824, 27897, 27855,
27881, 27857, 28820, 28824, 28805, 28819, 28806, 28804, 28817, 28822,
28802, 28826, 28803, 29290, 29398, 29387, 29400, 29385, 29404, 29394,
29396, 29402, 29388, 29393, 29604, 29601, 29613, 29606, 29602, 29600,
29612, 29597, 29917, 29928, 30015, 30016, 30014, 30092, 30104, 30383,
30451, 30449, 30448, 30453, 30712, 30716, 30713, 30715, 30714,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0, 30711, 31042, 31039, 31173, 31352, 31355, 31483,
31861, 31997, 32821, 32911, 32942, 32931, 32952, 32949, 32941, 33312,
33440, 33472, 33451, 33434, 33432, 33435, 33461, 33447, 33454, 33468,
33438, 33466, 33460, 33448, 33441, 33449, 33474, 33444, 33475, 33462,
33442, 34416, 34415, 34413, 34414, 35926, 36818, 36811, 36819, 36813,
36822, 36821, 36823, 37042, 37044, 37039, 37043, 37040, 38457, 38461,
38460, 38458, 38467, 20429, 20421, 20435, 20402, 20425, 20427, 20417,
20436, 20444, 20441, 20411, 20403, 20443, 20423, 20438, 20410, 20416,
20409, 20460, 21060, 21065, 21184, 21186, 21309, 21372, 21399, 21398,
21401, 21400, 21690, 21665, 21677, 21669, 21711, 21699, 33549, 21687,
21678, 21718, 21686, 21701, 21702, 21664, 21616, 21692, 21666, 21694,
21618, 21726, 21680, 22453, 22430, 22431, 22436, 22412, 22423, 22429,
22427, 22420, 22424, 22415, 22425, 22437, 22426, 22421, 22772, 22797,
22867, 23009, 23006, 23022, 23040, 23025, 23005, 23034, 23037, 23036,
23030, 23012, 23026, 23031, 23003, 23017, 23027, 23029, 23008, 23038,
23028, 23021, 23464, 23628, 23760, 23768, 23756, 23767, 23755, 23771,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0, 23774, 23770, 23753, 23751, 23754, 23766,
23763, 23764, 23759, 23752, 23750, 23758, 23775, 23800, 24057, 24097,
24098, 24099, 24096, 24100, 24240, 24228, 24226, 24219, 24227, 24229,
24327, 24366, 24406, 24454, 24631, 24633, 24660, 24690, 24670, 24645,
24659, 24647, 24649, 24667, 24652, 24640, 24642, 24671, 24612, 24644,
24664, 24678, 24686, 25154, 25155, 25295, 25357, 25355, 25333, 25358,
25347, 25323, 25337, 25359, 25356, 25336, 25334, 25344, 25363, 25364,
25338, 25365, 25339, 25328, 25921, 25923, 26026, 26047, 26166, 26145,
26162, 26165, 26140, 26150, 26146, 26163, 26155, 26170, 26141, 26164,
26169, 26158, 26383, 26384, 26561, 26610, 26568, 26554, 26588, 26555,
26616, 26584, 26560, 26551, 26565, 26603, 26596, 26591, 26549, 26573,
26547, 26615, 26614, 26606, 26595, 26562, 26553, 26574, 26599, 26608,
26546, 26620, 26566, 26605, 26572, 26542, 26598, 26587, 26618, 26569,
26570, 26563, 26602, 26571, 27432, 27522, 27524, 27574, 27606, 27608,
27616, 27680, 27681, 27944, 27956, 27949, 27935, 27964, 27967, 27922,
27914, 27866, 27955, 27908, 27929, 27962, 27930, 27921, 27904, 27933,
27970,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0, 27905, 27928, 27959, 27907, 27919,
27968, 27911, 27936, 27948, 27912, 27938, 27913, 27920, 28855, 28831,
28862, 28849, 28848, 28833, 28852, 28853, 28841, 29249, 29257, 29258,
29292, 29296, 29299, 29294, 29386, 29412, 29416, 29419, 29407, 29418,
29414, 29411, 29573, 29644, 29634, 29640, 29637, 29625, 29622, 29621,
29620, 29675, 29631, 29639, 29630, 29635, 29638, 29624, 29643, 29932,
29934, 29998, 30023, 30024, 30119, 30122, 30329, 30404, 30472, 30467,
30468, 30469, 30474, 30455, 30459, 30458, 30695, 30696, 30726, 30737,
30738, 30725, 30736, 30735, 30734, 30729, 30723, 30739, 31050, 31052,
31051, 31045, 31044, 31189, 31181, 31183, 31190, 31182, 31360, 31358,
31441, 31488, 31489, 31866, 31864, 31865, 31871, 31872, 31873, 32003,
32008, 32001, 32600, 32657, 32653, 32702, 32775, 32782, 32783, 32788,
32823, 32984, 32967, 32992, 32977, 32968, 32962, 32976, 32965, 32995,
32985, 32988, 32970, 32981, 32969, 32975, 32983, 32998, 32973, 33279,
33313, 33428, 33497, 33534, 33529, 33543, 33512, 33536, 33493, 33594,
33515, 33494, 33524, 33516, 33505, 33522, 33525, 33548, 33531, 33526,
33520, 33514,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0, 33508, 33504, 33530, 33523,
33517, 34423, 34420, 34428, 34419, 34881, 34894, 34919, 34922, 34921,
35283, 35332, 35335, 36210, 36835, 36833, 36846, 36832, 37105, 37053,
37055, 37077, 37061, 37054, 37063, 37067, 37064, 37332, 37331, 38484,
38479, 38481, 38483, 38474, 38478, 20510, 20485, 20487, 20499, 20514,
20528, 20507, 20469, 20468, 20531, 20535, 20524, 20470, 20471, 20503,
20508, 20512, 20519, 20533, 20527, 20529, 20494, 20826, 20884, 20883,
20938, 20932, 20933, 20936, 20942, 21089, 21082, 21074, 21086, 21087,
21077, 21090, 21197, 21262, 21406, 21798, 21730, 21783, 21778, 21735,
21747, 21732, 21786, 21759, 21764, 21768, 21739, 21777, 21765, 21745,
21770, 21755, 21751, 21752, 21728, 21774, 21763, 21771, 22273, 22274,
22476, 22578, 22485, 22482, 22458, 22470, 22461, 22460, 22456, 22454,
22463, 22471, 22480, 22457, 22465, 22798, 22858, 23065, 23062, 23085,
23086, 23061, 23055, 23063, 23050, 23070, 23091, 23404, 23463, 23469,
23468, 23555, 23638, 23636, 23788, 23807, 23790, 23793, 23799, 23808,
23801, 24105, 24104, 24232, 24238, 24234, 24236, 24371, 24368, 24423,
24669, 24666, 24679,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0, 24641, 24738, 24712,
24704, 24722, 24705, 24733, 24707, 24725, 24731, 24727, 24711, 24732,
24718, 25113, 25158, 25330, 25360, 25430, 25388, 25412, 25413, 25398,
25411, 25572, 25401, 25419, 25418, 25404, 25385, 25409, 25396, 25432,
25428, 25433, 25389, 25415, 25395, 25434, 25425, 25400, 25431, 25408,
25416, 25930, 25926, 26054, 26051, 26052, 26050, 26186, 26207, 26183,
26193, 26386, 26387, 26655, 26650, 26697, 26674, 26675, 26683, 26699,
26703, 26646, 26673, 26652, 26677, 26667, 26669, 26671, 26702, 26692,
26676, 26653, 26642, 26644, 26662, 26664, 26670, 26701, 26682, 26661,
26656, 27436, 27439, 27437, 27441, 27444, 27501, 32898, 27528, 27622,
27620, 27624, 27619, 27618, 27623, 27685, 28026, 28003, 28004, 28022,
27917, 28001, 28050, 27992, 28002, 28013, 28015, 28049, 28045, 28143,
28031, 28038, 27998, 28007, 28000, 28055, 28016, 28028, 27999, 28034,
28056, 27951, 28008, 28043, 28030, 28032, 28036, 27926, 28035, 28027,
28029, 28021, 28048, 28892, 28883, 28881, 28893, 28875, 32569, 28898,
28887, 28882, 28894, 28896, 28884, 28877, 28869, 28870, 28871, 28890,
28878, 28897, 29250, 29304,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0, 29303, 29302,
29440, 29434, 29428, 29438, 29430, 29427, 29435, 29441, 29651, 29657,
29669, 29654, 29628, 29671, 29667, 29673, 29660, 29650, 29659, 29652,
29661, 29658, 29655, 29656, 29672, 29918, 29919, 29940, 29941, 29985,
30043, 30047, 30128, 30145, 30139, 30148, 30144, 30143, 30134, 30138,
30346, 30409, 30493, 30491, 30480, 30483, 30482, 30499, 30481, 30485,
30489, 30490, 30498, 30503, 30755, 30764, 30754, 30773, 30767, 30760,
30766, 30763, 30753, 30761, 30771, 30762, 30769, 31060, 31067, 31055,
31068, 31059, 31058, 31057, 31211, 31212, 31200, 31214, 31213, 31210,
31196, 31198, 31197, 31366, 31369, 31365, 31371, 31372, 31370, 31367,
31448, 31504, 31492, 31507, 31493, 31503, 31496, 31498, 31502, 31497,
31506, 31876, 31889, 31882, 31884, 31880, 31885, 31877, 32030, 32029,
32017, 32014, 32024, 32022, 32019, 32031, 32018, 32015, 32012, 32604,
32609, 32606, 32608, 32605, 32603, 32662, 32658, 32707, 32706, 32704,
32790, 32830, 32825, 33018, 33010, 33017, 33013, 33025, 33019, 33024,
33281, 33327, 33317, 33587, 33581, 33604, 33561, 33617, 33573, 33622,
33599, 33601, 33574, 33564, 33570,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0, 33602,
33614, 33563, 33578, 33544, 33596, 33613, 33558, 33572, 33568, 33591,
33583, 33577, 33607, 33605, 33612, 33619, 33566, 33580, 33611, 33575,
33608, 34387, 34386, 34466, 34472, 34454, 34445, 34449, 34462, 34439,
34455, 34438, 34443, 34458, 34437, 34469, 34457, 34465, 34471, 34453,
34456, 34446, 34461, 34448, 34452, 34883, 34884, 34925, 34933, 34934,
34930, 34944, 34929, 34943, 34927, 34947, 34942, 34932, 34940, 35346,
35911, 35927, 35963, 36004, 36003, 36214, 36216, 36277, 36279, 36278,
36561, 36563, 36862, 36853, 36866, 36863, 36859, 36868, 36860, 36854,
37078, 37088, 37081, 37082, 37091, 37087, 37093, 37080, 37083, 37079,
37084, 37092, 37200, 37198, 37199, 37333, 37346, 37338, 38492, 38495,
38588, 39139, 39647, 39727, 20095, 20592, 20586, 20577, 20574, 20576,
20563, 20555, 20573, 20594, 20552, 20557, 20545, 20571, 20554, 20578,
20501, 20549, 20575, 20585, 20587, 20579, 20580, 20550, 20544, 20590,
20595, 20567, 20561, 20944, 21099, 21101, 21100, 21102, 21206, 21203,
21293, 21404, 21877, 21878, 21820, 21837, 21840, 21812, 21802, 21841,
21858, 21814, 21813, 21808, 21842, 21829,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
21772, 21810, 21861, 21838, 21817, 21832, 21805, 21819, 21824, 21835,
22282, 22279, 22523, 22548, 22498, 22518, 22492, 22516, 22528, 22509,
22525, 22536, 22520, 22539, 22515, 22479, 22535, 22510, 22499, 22514,
22501, 22508, 22497, 22542, 22524, 22544, 22503, 22529, 22540, 22513,
22505, 22512, 22541, 22532, 22876, 23136, 23128, 23125, 23143, 23134,
23096, 23093, 23149, 23120, 23135, 23141, 23148, 23123, 23140, 23127,
23107, 23133, 23122, 23108, 23131, 23112, 23182, 23102, 23117, 23097,
23116, 23152, 23145, 23111, 23121, 23126, 23106, 23132, 23410, 23406,
23489, 23488, 23641, 23838, 23819, 23837, 23834, 23840, 23820, 23848,
23821, 23846, 23845, 23823, 23856, 23826, 23843, 23839, 23854, 24126,
24116, 24241, 24244, 24249, 24242, 24243, 24374, 24376, 24475, 24470,
24479, 24714, 24720, 24710, 24766, 24752, 24762, 24787, 24788, 24783,
24804, 24793, 24797, 24776, 24753, 24795, 24759, 24778, 24767, 24771,
24781, 24768, 25394, 25445, 25482, 25474, 25469, 25533, 25502, 25517,
25501, 25495, 25515, 25486, 25455, 25479, 25488, 25454, 25519, 25461,
25500, 25453, 25518, 25468, 25508, 25403, 25503,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0, 25464, 25477, 25473, 25489, 25485, 25456, 25939, 26061, 26213,
26209, 26203, 26201, 26204, 26210, 26392, 26745, 26759, 26768, 26780,
26733, 26734, 26798, 26795, 26966, 26735, 26787, 26796, 26793, 26741,
26740, 26802, 26767, 26743, 26770, 26748, 26731, 26738, 26794, 26752,
26737, 26750, 26779, 26774, 26763, 26784, 26761, 26788, 26744, 26747,
26769, 26764, 26762, 26749, 27446, 27443, 27447, 27448, 27537, 27535,
27533, 27534, 27532, 27690, 28096, 28075, 28084, 28083, 28276, 28076,
28137, 28130, 28087, 28150, 28116, 28160, 28104, 28128, 28127, 28118,
28094, 28133, 28124, 28125, 28123, 28148, 28106, 28093, 28141, 28144,
28090, 28117, 28098, 28111, 28105, 28112, 28146, 28115, 28157, 28119,
28109, 28131, 28091, 28922, 28941, 28919, 28951, 28916, 28940, 28912,
28932, 28915, 28944, 28924, 28927, 28934, 28947, 28928, 28920, 28918,
28939, 28930, 28942, 29310, 29307, 29308, 29311, 29469, 29463, 29447,
29457, 29464, 29450, 29448, 29439, 29455, 29470, 29576, 29686, 29688,
29685, 29700, 29697, 29693, 29703, 29696, 29690, 29692, 29695, 29708,
29707, 29684, 29704, 30052, 30051, 30158, 30162, 30159,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0, 30155, 30156, 30161, 30160, 30351, 30345, 30419, 30521,
30511, 30509, 30513, 30514, 30516, 30515, 30525, 30501, 30523, 30517,
30792, 30802, 30793, 30797, 30794, 30796, 30758, 30789, 30800, 31076,
31079, 31081, 31082, 31075, 31083, 31073, 31163, 31226, 31224, 31222,
31223, 31375, 31380, 31376, 31541, 31559, 31540, 31525, 31536, 31522,
31524, 31539, 31512, 31530, 31517, 31537, 31531, 31533, 31535, 31538,
31544, 31514, 31523, 31892, 31896, 31894, 31907, 32053, 32061, 32056,
32054, 32058, 32069, 32044, 32041, 32065, 32071, 32062, 32063, 32074,
32059, 32040, 32611, 32661, 32668, 32669, 32667, 32714, 32715, 32717,
32720, 32721, 32711, 32719, 32713, 32799, 32798, 32795, 32839, 32835,
32840, 33048, 33061, 33049, 33051, 33069, 33055, 33068, 33054, 33057,
33045, 33063, 33053, 33058, 33297, 33336, 33331, 33338, 33332, 33330,
33396, 33680, 33699, 33704, 33677, 33658, 33651, 33700, 33652, 33679,
33665, 33685, 33689, 33653, 33684, 33705, 33661, 33667, 33676, 33693,
33691, 33706, 33675, 33662, 33701, 33711, 33672, 33687, 33712, 33663,
33702, 33671, 33710, 33654, 33690, 34393, 34390, 34495, 34487,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0, 34498, 34497, 34501, 34490, 34480, 34504, 34489,
34483, 34488, 34508, 34484, 34491, 34492, 34499, 34493, 34494, 34898,
34953, 34965, 34984, 34978, 34986, 34970, 34961, 34977, 34975, 34968,
34983, 34969, 34971, 34967, 34980, 34988, 34956, 34963, 34958, 35202,
35286, 35289, 35285, 35376, 35367, 35372, 35358, 35897, 35899, 35932,
35933, 35965, 36005, 36221, 36219, 36217, 36284, 36290, 36281, 36287,
36289, 36568, 36574, 36573, 36572, 36567, 36576, 36577, 36900, 36875,
36881, 36892, 36876, 36897, 37103, 37098, 37104, 37108, 37106, 37107,
37076, 37099, 37100, 37097, 37206, 37208, 37210, 37203, 37205, 37356,
37364, 37361, 37363, 37368, 37348, 37369, 37354, 37355, 37367, 37352,
37358, 38266, 38278, 38280, 38524, 38509, 38507, 38513, 38511, 38591,
38762, 38916, 39141, 39319, 20635, 20629, 20628, 20638, 20619, 20643,
20611, 20620, 20622, 20637, 20584, 20636, 20626, 20610, 20615, 20831,
20948, 21266, 21265, 21412, 21415, 21905, 21928, 21925, 21933, 21879,
22085, 21922, 21907, 21896, 21903, 21941, 21889, 21923, 21906, 21924,
21885, 21900, 21926, 21887, 21909, 21921, 21902, 22284, 22569, 22583,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0, 22553, 22558, 22567, 22563, 22568, 22517,
22600, 22565, 22556, 22555, 22579, 22591, 22582, 22574, 22585, 22584,
22573, 22572, 22587, 22881, 23215, 23188, 23199, 23162, 23202, 23198,
23160, 23206, 23164, 23205, 23212, 23189, 23214, 23095, 23172, 23178,
23191, 23171, 23179, 23209, 23163, 23165, 23180, 23196, 23183, 23187,
23197, 23530, 23501, 23499, 23508, 23505, 23498, 23502, 23564, 23600,
23863, 23875, 23915, 23873, 23883, 23871, 23861, 23889, 23886, 23893,
23859, 23866, 23890, 23869, 23857, 23897, 23874, 23865, 23881, 23864,
23868, 23858, 23862, 23872, 23877, 24132, 24129, 24408, 24486, 24485,
24491, 24777, 24761, 24780, 24802, 24782, 24772, 24852, 24818, 24842,
24854, 24837, 24821, 24851, 24824, 24828, 24830, 24769, 24835, 24856,
24861, 24848, 24831, 24836, 24843, 25162, 25492, 25521, 25520, 25550,
25573, 25576, 25583, 25539, 25757, 25587, 25546, 25568, 25590, 25557,
25586, 25589, 25697, 25567, 25534, 25565, 25564, 25540, 25560, 25555,
25538, 25543, 25548, 25547, 25544, 25584, 25559, 25561, 25906, 25959,
25962, 25956, 25948, 25960, 25957, 25996, 26013, 26014, 26030, 26064,
26066,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0, 26236, 26220, 26235, 26240, 26225,
26233, 26218, 26226, 26369, 26892, 26835, 26884, 26844, 26922, 26860,
26858, 26865, 26895, 26838, 26871, 26859, 26852, 26870, 26899, 26896,
26867, 26849, 26887, 26828, 26888, 26992, 26804, 26897, 26863, 26822,
26900, 26872, 26832, 26877, 26876, 26856, 26891, 26890, 26903, 26830,
26824, 26845, 26846, 26854, 26868, 26833, 26886, 26836, 26857, 26901,
26917, 26823, 27449, 27451, 27455, 27452, 27540, 27543, 27545, 27541,
27581, 27632, 27634, 27635, 27696, 28156, 28230, 28231, 28191, 28233,
28296, 28220, 28221, 28229, 28258, 28203, 28223, 28225, 28253, 28275,
28188, 28211, 28235, 28224, 28241, 28219, 28163, 28206, 28254, 28264,
28252, 28257, 28209, 28200, 28256, 28273, 28267, 28217, 28194, 28208,
28243, 28261, 28199, 28280, 28260, 28279, 28245, 28281, 28242, 28262,
28213, 28214, 28250, 28960, 28958, 28975, 28923, 28974, 28977, 28963,
28965, 28962, 28978, 28959, 28968, 28986, 28955, 29259, 29274, 29320,
29321, 29318, 29317, 29323, 29458, 29451, 29488, 29474, 29489, 29491,
29479, 29490, 29485, 29478, 29475, 29493, 29452, 29742, 29740, 29744,
29739, 29718,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0, 29722, 29729, 29741, 29745,
29732, 29731, 29725, 29737, 29728, 29746, 29947, 29999, 30063, 30060,
30183, 30170, 30177, 30182, 30173, 30175, 30180, 30167, 30357, 30354,
30426, 30534, 30535, 30532, 30541, 30533, 30538, 30542, 30539, 30540,
30686, 30700, 30816, 30820, 30821, 30812, 30829, 30833, 30826, 30830,
30832, 30825, 30824, 30814, 30818, 31092, 31091, 31090, 31088, 31234,
31242, 31235, 31244, 31236, 31385, 31462, 31460, 31562, 31547, 31556,
31560, 31564, 31566, 31552, 31576, 31557, 31906, 31902, 31912, 31905,
32088, 32111, 32099, 32083, 32086, 32103, 32106, 32079, 32109, 32092,
32107, 32082, 32084, 32105, 32081, 32095, 32078, 32574, 32575, 32613,
32614, 32674, 32672, 32673, 32727, 32849, 32847, 32848, 33022, 32980,
33091, 33098, 33106, 33103, 33095, 33085, 33101, 33082, 33254, 33262,
33271, 33272, 33273, 33284, 33340, 33341, 33343, 33397, 33595, 33743,
33785, 33827, 33728, 33768, 33810, 33767, 33764, 33788, 33782, 33808,
33734, 33736, 33771, 33763, 33727, 33793, 33757, 33765, 33752, 33791,
33761, 33739, 33742, 33750, 33781, 33737, 33801, 33807, 33758, 33809,
33798, 33730, 33779,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0, 33749, 33786, 33735,
33745, 33770, 33811, 33731, 33772, 33774, 33732, 33787, 33751, 33762,
33819, 33755, 33790, 34520, 34530, 34534, 34515, 34531, 34522, 34538,
34525, 34539, 34524, 34540, 34537, 34519, 34536, 34513, 34888, 34902,
34901, 35002, 35031, 35001, 35000, 35008, 35006, 34998, 35004, 34999,
35005, 34994, 35073, 35017, 35221, 35224, 35223, 35293, 35290, 35291,
35406, 35405, 35385, 35417, 35392, 35415, 35416, 35396, 35397, 35410,
35400, 35409, 35402, 35404, 35407, 35935, 35969, 35968, 36026, 36030,
36016, 36025, 36021, 36228, 36224, 36233, 36312, 36307, 36301, 36295,
36310, 36316, 36303, 36309, 36313, 36296, 36311, 36293, 36591, 36599,
36602, 36601, 36582, 36590, 36581, 36597, 36583, 36584, 36598, 36587,
36593, 36588, 36596, 36585, 36909, 36916, 36911, 37126, 37164, 37124,
37119, 37116, 37128, 37113, 37115, 37121, 37120, 37127, 37125, 37123,
37217, 37220, 37215, 37218, 37216, 37377, 37386, 37413, 37379, 37402,
37414, 37391, 37388, 37376, 37394, 37375, 37373, 37382, 37380, 37415,
37378, 37404, 37412, 37401, 37399, 37381, 37398, 38267, 38285, 38284,
38288, 38535, 38526, 38536,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0, 38537, 38531,
38528, 38594, 38600, 38595, 38641, 38640, 38764, 38768, 38766, 38919,
39081, 39147, 40166, 40697, 20099, 20100, 20150, 20669, 20671, 20678,
20654, 20676, 20682, 20660, 20680, 20674, 20656, 20673, 20666, 20657,
20683, 20681, 20662, 20664, 20951, 21114, 21112, 21115, 21116, 21955,
21979, 21964, 21968, 21963, 21962, 21981, 21952, 21972, 21956, 21993,
21951, 21970, 21901, 21967, 21973, 21986, 21974, 21960, 22002, 21965,
21977, 21954, 22292, 22611, 22632, 22628, 22607, 22605, 22601, 22639,
22613, 22606, 22621, 22617, 22629, 22619, 22589, 22627, 22641, 22780,
23239, 23236, 23243, 23226, 23224, 23217, 23221, 23216, 23231, 23240,
23227, 23238, 23223, 23232, 23242, 23220, 23222, 23245, 23225, 23184,
23510, 23512, 23513, 23583, 23603, 23921, 23907, 23882, 23909, 23922,
23916, 23902, 23912, 23911, 23906, 24048, 24143, 24142, 24138, 24141,
24139, 24261, 24268, 24262, 24267, 24263, 24384, 24495, 24493, 24823,
24905, 24906, 24875, 24901, 24886, 24882, 24878, 24902, 24879, 24911,
24873, 24896, 25120, 37224, 25123, 25125, 25124, 25541, 25585, 25579,
25616, 25618, 25609, 25632, 25636,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0, 25651,
25667, 25631, 25621, 25624, 25657, 25655, 25634, 25635, 25612, 25638,
25648, 25640, 25665, 25653, 25647, 25610, 25626, 25664, 25637, 25639,
25611, 25575, 25627, 25646, 25633, 25614, 25967, 26002, 26067, 26246,
26252, 26261, 26256, 26251, 26250, 26265, 26260, 26232, 26400, 26982,
26975, 26936, 26958, 26978, 26993, 26943, 26949, 26986, 26937, 26946,
26967, 26969, 27002, 26952, 26953, 26933, 26988, 26931, 26941, 26981,
26864, 27000, 26932, 26985, 26944, 26991, 26948, 26998, 26968, 26945,
26996, 26956, 26939, 26955, 26935, 26972, 26959, 26961, 26930, 26962,
26927, 27003, 26940, 27462, 27461, 27459, 27458, 27464, 27457, 27547,
64013, 27643, 27644, 27641, 27639, 27640, 28315, 28374, 28360, 28303,
28352, 28319, 28307, 28308, 28320, 28337, 28345, 28358, 28370, 28349,
28353, 28318, 28361, 28343, 28336, 28365, 28326, 28367, 28338, 28350,
28355, 28380, 28376, 28313, 28306, 28302, 28301, 28324, 28321, 28351,
28339, 28368, 28362, 28311, 28334, 28323, 28999, 29012, 29010, 29027,
29024, 28993, 29021, 29026, 29042, 29048, 29034, 29025, 28994, 29016,
28995, 29003, 29040, 29023, 29008, 29011,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
28996, 29005, 29018, 29263, 29325, 29324, 29329, 29328, 29326, 29500,
29506, 29499, 29498, 29504, 29514, 29513, 29764, 29770, 29771, 29778,
29777, 29783, 29760, 29775, 29776, 29774, 29762, 29766, 29773, 29780,
29921, 29951, 29950, 29949, 29981, 30073, 30071, 27011, 30191, 30223,
30211, 30199, 30206, 30204, 30201, 30200, 30224, 30203, 30198, 30189,
30197, 30205, 30361, 30389, 30429, 30549, 30559, 30560, 30546, 30550,
30554, 30569, 30567, 30548, 30553, 30573, 30688, 30855, 30874, 30868,
30863, 30852, 30869, 30853, 30854, 30881, 30851, 30841, 30873, 30848,
30870, 30843, 31100, 31106, 31101, 31097, 31249, 31256, 31257, 31250,
31255, 31253, 31266, 31251, 31259, 31248, 31395, 31394, 31390, 31467,
31590, 31588, 31597, 31604, 31593, 31602, 31589, 31603, 31601, 31600,
31585, 31608, 31606, 31587, 31922, 31924, 31919, 32136, 32134, 32128,
32141, 32127, 32133, 32122, 32142, 32123, 32131, 32124, 32140, 32148,
32132, 32125, 32146, 32621, 32619, 32615, 32616, 32620, 32678, 32677,
32679, 32731, 32732, 32801, 33124, 33120, 33143, 33116, 33129, 33115,
33122, 33138, 26401, 33118, 33142, 33127, 33135,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0, 33092, 33121, 33309, 33353, 33348, 33344, 33346, 33349, 34033,
33855, 33878, 33910, 33913, 33935, 33933, 33893, 33873, 33856, 33926,
33895, 33840, 33869, 33917, 33882, 33881, 33908, 33907, 33885, 34055,
33886, 33847, 33850, 33844, 33914, 33859, 33912, 33842, 33861, 33833,
33753, 33867, 33839, 33858, 33837, 33887, 33904, 33849, 33870, 33868,
33874, 33903, 33989, 33934, 33851, 33863, 33846, 33843, 33896, 33918,
33860, 33835, 33888, 33876, 33902, 33872, 34571, 34564, 34551, 34572,
34554, 34518, 34549, 34637, 34552, 34574, 34569, 34561, 34550, 34573,
34565, 35030, 35019, 35021, 35022, 35038, 35035, 35034, 35020, 35024,
35205, 35227, 35295, 35301, 35300, 35297, 35296, 35298, 35292, 35302,
35446, 35462, 35455, 35425, 35391, 35447, 35458, 35460, 35445, 35459,
35457, 35444, 35450, 35900, 35915, 35914, 35941, 35940, 35942, 35974,
35972, 35973, 36044, 36200, 36201, 36241, 36236, 36238, 36239, 36237,
36243, 36244, 36240, 36242, 36336, 36320, 36332, 36337, 36334, 36304,
36329, 36323, 36322, 36327, 36338, 36331, 36340, 36614, 36607, 36609,
36608, 36613, 36615, 36616, 36610, 36619, 36946, 36927,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0, 36932, 36937, 36925, 37136, 37133, 37135, 37137, 37142,
37140, 37131, 37134, 37230, 37231, 37448, 37458, 37424, 37434, 37478,
37427, 37477, 37470, 37507, 37422, 37450, 37446, 37485, 37484, 37455,
37472, 37479, 37487, 37430, 37473, 37488, 37425, 37460, 37475, 37456,
37490, 37454, 37459, 37452, 37462, 37426, 38303, 38300, 38302, 38299,
38546, 38547, 38545, 38551, 38606, 38650, 38653, 38648, 38645, 38771,
38775, 38776, 38770, 38927, 38925, 38926, 39084, 39158, 39161, 39343,
39346, 39344, 39349, 39597, 39595, 39771, 40170, 40173, 40167, 40576,
40701, 20710, 20692, 20695, 20712, 20723, 20699, 20714, 20701, 20708,
20691, 20716, 20720, 20719, 20707, 20704, 20952, 21120, 21121, 21225,
21227, 21296, 21420, 22055, 22037, 22028, 22034, 22012, 22031, 22044,
22017, 22035, 22018, 22010, 22045, 22020, 22015, 22009, 22665, 22652,
22672, 22680, 22662, 22657, 22655, 22644, 22667, 22650, 22663, 22673,
22670, 22646, 22658, 22664, 22651, 22676, 22671, 22782, 22891, 23260,
23278, 23269, 23253, 23274, 23258, 23277, 23275, 23283, 23266, 23264,
23259, 23276, 23262, 23261, 23257, 23272, 23263, 23415, 23520,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0, 23523, 23651, 23938, 23936, 23933, 23942, 23930,
23937, 23927, 23946, 23945, 23944, 23934, 23932, 23949, 23929, 23935,
24152, 24153, 24147, 24280, 24273, 24279, 24270, 24284, 24277, 24281,
24274, 24276, 24388, 24387, 24431, 24502, 24876, 24872, 24897, 24926,
24945, 24947, 24914, 24915, 24946, 24940, 24960, 24948, 24916, 24954,
24923, 24933, 24891, 24938, 24929, 24918, 25129, 25127, 25131, 25643,
25677, 25691, 25693, 25716, 25718, 25714, 25715, 25725, 25717, 25702,
25766, 25678, 25730, 25694, 25692, 25675, 25683, 25696, 25680, 25727,
25663, 25708, 25707, 25689, 25701, 25719, 25971, 26016, 26273, 26272,
26271, 26373, 26372, 26402, 27057, 27062, 27081, 27040, 27086, 27030,
27056, 27052, 27068, 27025, 27033, 27022, 27047, 27021, 27049, 27070,
27055, 27071, 27076, 27069, 27044, 27092, 27065, 27082, 27034, 27087,
27059, 27027, 27050, 27041, 27038, 27097, 27031, 27024, 27074, 27061,
27045, 27078, 27466, 27469, 27467, 27550, 27551, 27552, 27587, 27588,
27646, 28366, 28405, 28401, 28419, 28453, 28408, 28471, 28411, 28462,
28425, 28494, 28441, 28442, 28455, 28440, 28475, 28434, 28397, 28426,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0, 28470, 28531, 28409, 28398, 28461, 28480,
28464, 28476, 28469, 28395, 28423, 28430, 28483, 28421, 28413, 28406,
28473, 28444, 28412, 28474, 28447, 28429, 28446, 28424, 28449, 29063,
29072, 29065, 29056, 29061, 29058, 29071, 29051, 29062, 29057, 29079,
29252, 29267, 29335, 29333, 29331, 29507, 29517, 29521, 29516, 29794,
29811, 29809, 29813, 29810, 29799, 29806, 29952, 29954, 29955, 30077,
30096, 30230, 30216, 30220, 30229, 30225, 30218, 30228, 30392, 30593,
30588, 30597, 30594, 30574, 30592, 30575, 30590, 30595, 30898, 30890,
30900, 30893, 30888, 30846, 30891, 30878, 30885, 30880, 30892, 30882,
30884, 31128, 31114, 31115, 31126, 31125, 31124, 31123, 31127, 31112,
31122, 31120, 31275, 31306, 31280, 31279, 31272, 31270, 31400, 31403,
31404, 31470, 31624, 31644, 31626, 31633, 31632, 31638, 31629, 31628,
31643, 31630, 31621, 31640, 21124, 31641, 31652, 31618, 31931, 31935,
31932, 31930, 32167, 32183, 32194, 32163, 32170, 32193, 32192, 32197,
32157, 32206, 32196, 32198, 32203, 32204, 32175, 32185, 32150, 32188,
32159, 32166, 32174, 32169, 32161, 32201, 32627, 32738, 32739, 32741,
32734,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0, 32804, 32861, 32860, 33161, 33158,
33155, 33159, 33165, 33164, 33163, 33301, 33943, 33956, 33953, 33951,
33978, 33998, 33986, 33964, 33966, 33963, 33977, 33972, 33985, 33997,
33962, 33946, 33969, 34000, 33949, 33959, 33979, 33954, 33940, 33991,
33996, 33947, 33961, 33967, 33960, 34006, 33944, 33974, 33999, 33952,
34007, 34004, 34002, 34011, 33968, 33937, 34401, 34611, 34595, 34600,
34667, 34624, 34606, 34590, 34593, 34585, 34587, 34627, 34604, 34625,
34622, 34630, 34592, 34610, 34602, 34605, 34620, 34578, 34618, 34609,
34613, 34626, 34598, 34599, 34616, 34596, 34586, 34608, 34577, 35063,
35047, 35057, 35058, 35066, 35070, 35054, 35068, 35062, 35067, 35056,
35052, 35051, 35229, 35233, 35231, 35230, 35305, 35307, 35304, 35499,
35481, 35467, 35474, 35471, 35478, 35901, 35944, 35945, 36053, 36047,
36055, 36246, 36361, 36354, 36351, 36365, 36349, 36362, 36355, 36359,
36358, 36357, 36350, 36352, 36356, 36624, 36625, 36622, 36621, 37155,
37148, 37152, 37154, 37151, 37149, 37146, 37156, 37153, 37147, 37242,
37234, 37241, 37235, 37541, 37540, 37494, 37531, 37498, 37536, 37524,
37546, 37517,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0, 37542, 37530, 37547, 37497,
37527, 37503, 37539, 37614, 37518, 37506, 37525, 37538, 37501, 37512,
37537, 37514, 37510, 37516, 37529, 37543, 37502, 37511, 37545, 37533,
37515, 37421, 38558, 38561, 38655, 38744, 38781, 38778, 38782, 38787,
38784, 38786, 38779, 38788, 38785, 38783, 38862, 38861, 38934, 39085,
39086, 39170, 39168, 39175, 39325, 39324, 39363, 39353, 39355, 39354,
39362, 39357, 39367, 39601, 39651, 39655, 39742, 39743, 39776, 39777,
39775, 40177, 40178, 40181, 40615, 20735, 20739, 20784, 20728, 20742,
20743, 20726, 20734, 20747, 20748, 20733, 20746, 21131, 21132, 21233,
21231, 22088, 22082, 22092, 22069, 22081, 22090, 22089, 22086, 22104,
22106, 22080, 22067, 22077, 22060, 22078, 22072, 22058, 22074, 22298,
22699, 22685, 22705, 22688, 22691, 22703, 22700, 22693, 22689, 22783,
23295, 23284, 23293, 23287, 23286, 23299, 23288, 23298, 23289, 23297,
23303, 23301, 23311, 23655, 23961, 23959, 23967, 23954, 23970, 23955,
23957, 23968, 23964, 23969, 23962, 23966, 24169, 24157, 24160, 24156,
32243, 24283, 24286, 24289, 24393, 24498, 24971, 24963, 24953, 25009,
25008, 24994, 24969,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0, 24987, 24979, 25007,
25005, 24991, 24978, 25002, 24993, 24973, 24934, 25011, 25133, 25710,
25712, 25750, 25760, 25733, 25751, 25756, 25743, 25739, 25738, 25740,
25763, 25759, 25704, 25777, 25752, 25974, 25978, 25977, 25979, 26034,
26035, 26293, 26288, 26281, 26290, 26295, 26282, 26287, 27136, 27142,
27159, 27109, 27128, 27157, 27121, 27108, 27168, 27135, 27116, 27106,
27163, 27165, 27134, 27175, 27122, 27118, 27156, 27127, 27111, 27200,
27144, 27110, 27131, 27149, 27132, 27115, 27145, 27140, 27160, 27173,
27151, 27126, 27174, 27143, 27124, 27158, 27473, 27557, 27555, 27554,
27558, 27649, 27648, 27647, 27650, 28481, 28454, 28542, 28551, 28614,
28562, 28557, 28553, 28556, 28514, 28495, 28549, 28506, 28566, 28534,
28524, 28546, 28501, 28530, 28498, 28496, 28503, 28564, 28563, 28509,
28416, 28513, 28523, 28541, 28519, 28560, 28499, 28555, 28521, 28543,
28565, 28515, 28535, 28522, 28539, 29106, 29103, 29083, 29104, 29088,
29082, 29097, 29109, 29085, 29093, 29086, 29092, 29089, 29098, 29084,
29095, 29107, 29336, 29338, 29528, 29522, 29534, 29535, 29536, 29533,
29531, 29537, 29530, 29529,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0, 29538, 29831,
29833, 29834, 29830, 29825, 29821, 29829, 29832, 29820, 29817, 29960,
29959, 30078, 30245, 30238, 30233, 30237, 30236, 30243, 30234, 30248,
30235, 30364, 30365, 30366, 30363, 30605, 30607, 30601, 30600, 30925,
30907, 30927, 30924, 30929, 30926, 30932, 30920, 30915, 30916, 30921,
31130, 31137, 31136, 31132, 31138, 31131, 27510, 31289, 31410, 31412,
31411, 31671, 31691, 31678, 31660, 31694, 31663, 31673, 31690, 31669,
31941, 31944, 31948, 31947, 32247, 32219, 32234, 32231, 32215, 32225,
32259, 32250, 32230, 32246, 32241, 32240, 32238, 32223, 32630, 32684,
32688, 32685, 32749, 32747, 32746, 32748, 32742, 32744, 32868, 32871,
33187, 33183, 33182, 33173, 33186, 33177, 33175, 33302, 33359, 33363,
33362, 33360, 33358, 33361, 34084, 34107, 34063, 34048, 34089, 34062,
34057, 34061, 34079, 34058, 34087, 34076, 34043, 34091, 34042, 34056,
34060, 34036, 34090, 34034, 34069, 34039, 34027, 34035, 34044, 34066,
34026, 34025, 34070, 34046, 34088, 34077, 34094, 34050, 34045, 34078,
34038, 34097, 34086, 34023, 34024, 34032, 34031, 34041, 34072, 34080,
34096, 34059, 34073, 34095, 34402,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0, 34646,
34659, 34660, 34679, 34785, 34675, 34648, 34644, 34651, 34642, 34657,
34650, 34641, 34654, 34669, 34666, 34640, 34638, 34655, 34653, 34671,
34668, 34682, 34670, 34652, 34661, 34639, 34683, 34677, 34658, 34663,
34665, 34906, 35077, 35084, 35092, 35083, 35095, 35096, 35097, 35078,
35094, 35089, 35086, 35081, 35234, 35236, 35235, 35309, 35312, 35308,
35535, 35526, 35512, 35539, 35537, 35540, 35541, 35515, 35543, 35518,
35520, 35525, 35544, 35523, 35514, 35517, 35545, 35902, 35917, 35983,
36069, 36063, 36057, 36072, 36058, 36061, 36071, 36256, 36252, 36257,
36251, 36384, 36387, 36389, 36388, 36398, 36373, 36379, 36374, 36369,
36377, 36390, 36391, 36372, 36370, 36376, 36371, 36380, 36375, 36378,
36652, 36644, 36632, 36634, 36640, 36643, 36630, 36631, 36979, 36976,
36975, 36967, 36971, 37167, 37163, 37161, 37162, 37170, 37158, 37166,
37253, 37254, 37258, 37249, 37250, 37252, 37248, 37584, 37571, 37572,
37568, 37593, 37558, 37583, 37617, 37599, 37592, 37609, 37591, 37597,
37580, 37615, 37570, 37608, 37578, 37576, 37582, 37606, 37581, 37589,
37577, 37600, 37598, 37607, 37585, 37587,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
37557, 37601, 37574, 37556, 38268, 38316, 38315, 38318, 38320, 38564,
38562, 38611, 38661, 38664, 38658, 38746, 38794, 38798, 38792, 38864,
38863, 38942, 38941, 38950, 38953, 38952, 38944, 38939, 38951, 39090,
39176, 39162, 39185, 39188, 39190, 39191, 39189, 39388, 39373, 39375,
39379, 39380, 39374, 39369, 39382, 39384, 39371, 39383, 39372, 39603,
39660, 39659, 39667, 39666, 39665, 39750, 39747, 39783, 39796, 39793,
39782, 39798, 39797, 39792, 39784, 39780, 39788, 40188, 40186, 40189,
40191, 40183, 40199, 40192, 40185, 40187, 40200, 40197, 40196, 40579,
40659, 40719, 40720, 20764, 20755, 20759, 20762, 20753, 20958, 21300,
21473, 22128, 22112, 22126, 22131, 22118, 22115, 22125, 22130, 22110,
22135, 22300, 22299, 22728, 22717, 22729, 22719, 22714, 22722, 22716,
22726, 23319, 23321, 23323, 23329, 23316, 23315, 23312, 23318, 23336,
23322, 23328, 23326, 23535, 23980, 23985, 23977, 23975, 23989, 23984,
23982, 23978, 23976, 23986, 23981, 23983, 23988, 24167, 24168, 24166,
24175, 24297, 24295, 24294, 24296, 24293, 24395, 24508, 24989, 25000,
24982, 25029, 25012, 25030, 25025, 25036, 25018,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0, 25023, 25016, 24972, 25815, 25814, 25808, 25807, 25801, 25789,
25737, 25795, 25819, 25843, 25817, 25907, 25983, 25980, 26018, 26312,
26302, 26304, 26314, 26315, 26319, 26301, 26299, 26298, 26316, 26403,
27188, 27238, 27209, 27239, 27186, 27240, 27198, 27229, 27245, 27254,
27227, 27217, 27176, 27226, 27195, 27199, 27201, 27242, 27236, 27216,
27215, 27220, 27247, 27241, 27232, 27196, 27230, 27222, 27221, 27213,
27214, 27206, 27477, 27476, 27478, 27559, 27562, 27563, 27592, 27591,
27652, 27651, 27654, 28589, 28619, 28579, 28615, 28604, 28622, 28616,
28510, 28612, 28605, 28574, 28618, 28584, 28676, 28581, 28590, 28602,
28588, 28586, 28623, 28607, 28600, 28578, 28617, 28587, 28621, 28591,
28594, 28592, 29125, 29122, 29119, 29112, 29142, 29120, 29121, 29131,
29140, 29130, 29127, 29135, 29117, 29144, 29116, 29126, 29146, 29147,
29341, 29342, 29545, 29542, 29543, 29548, 29541, 29547, 29546, 29823,
29850, 29856, 29844, 29842, 29845, 29857, 29963, 30080, 30255, 30253,
30257, 30269, 30259, 30268, 30261, 30258, 30256, 30395, 30438, 30618,
30621, 30625, 30620, 30619, 30626, 30627, 30613, 30617,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0, 30615, 30941, 30953, 30949, 30954, 30942, 30947, 30939,
30945, 30946, 30957, 30943, 30944, 31140, 31300, 31304, 31303, 31414,
31416, 31413, 31409, 31415, 31710, 31715, 31719, 31709, 31701, 31717,
31706, 31720, 31737, 31700, 31722, 31714, 31708, 31723, 31704, 31711,
31954, 31956, 31959, 31952, 31953, 32274, 32289, 32279, 32268, 32287,
32288, 32275, 32270, 32284, 32277, 32282, 32290, 32267, 32271, 32278,
32269, 32276, 32293, 32292, 32579, 32635, 32636, 32634, 32689, 32751,
32810, 32809, 32876, 33201, 33190, 33198, 33209, 33205, 33195, 33200,
33196, 33204, 33202, 33207, 33191, 33266, 33365, 33366, 33367, 34134,
34117, 34155, 34125, 34131, 34145, 34136, 34112, 34118, 34148, 34113,
34146, 34116, 34129, 34119, 34147, 34110, 34139, 34161, 34126, 34158,
34165, 34133, 34151, 34144, 34188, 34150, 34141, 34132, 34149, 34156,
34403, 34405, 34404, 34715, 34703, 34711, 34707, 34706, 34696, 34689,
34710, 34712, 34681, 34695, 34723, 34693, 34704, 34705, 34717, 34692,
34708, 34716, 34714, 34697, 35102, 35110, 35120, 35117, 35118, 35111,
35121, 35106, 35113, 35107, 35119, 35116, 35103, 35313, 35552,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0, 35554, 35570, 35572, 35573, 35549, 35604, 35556,
35551, 35568, 35528, 35550, 35553, 35560, 35583, 35567, 35579, 35985,
35986, 35984, 36085, 36078, 36081, 36080, 36083, 36204, 36206, 36261,
36263, 36403, 36414, 36408, 36416, 36421, 36406, 36412, 36413, 36417,
36400, 36415, 36541, 36662, 36654, 36661, 36658, 36665, 36663, 36660,
36982, 36985, 36987, 36998, 37114, 37171, 37173, 37174, 37267, 37264,
37265, 37261, 37263, 37671, 37662, 37640, 37663, 37638, 37647, 37754,
37688, 37692, 37659, 37667, 37650, 37633, 37702, 37677, 37646, 37645,
37579, 37661, 37626, 37669, 37651, 37625, 37623, 37684, 37634, 37668,
37631, 37673, 37689, 37685, 37674, 37652, 37644, 37643, 37630, 37641,
37632, 37627, 37654, 38332, 38349, 38334, 38329, 38330, 38326, 38335,
38325, 38333, 38569, 38612, 38667, 38674, 38672, 38809, 38807, 38804,
38896, 38904, 38965, 38959, 38962, 39204, 39199, 39207, 39209, 39326,
39406, 39404, 39397, 39396, 39408, 39395, 39402, 39401, 39399, 39609,
39615, 39604, 39611, 39670, 39674, 39673, 39671, 39731, 39808, 39813,
39815, 39804, 39806, 39803, 39810, 39827, 39826, 39824, 39802, 39829,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0, 39805, 39816, 40229, 40215, 40224, 40222,
40212, 40233, 40221, 40216, 40226, 40208, 40217, 40223, 40584, 40582,
40583, 40622, 40621, 40661, 40662, 40698, 40722, 40765, 20774, 20773,
20770, 20772, 20768, 20777, 21236, 22163, 22156, 22157, 22150, 22148,
22147, 22142, 22146, 22143, 22145, 22742, 22740, 22735, 22738, 23341,
23333, 23346, 23331, 23340, 23335, 23334, 23343, 23342, 23419, 23537,
23538, 23991, 24172, 24170, 24510, 24507, 25027, 25013, 25020, 25063,
25056, 25061, 25060, 25064, 25054, 25839, 25833, 25827, 25835, 25828,
25832, 25985, 25984, 26038, 26074, 26322, 27277, 27286, 27265, 27301,
27273, 27295, 27291, 27297, 27294, 27271, 27283, 27278, 27285, 27267,
27304, 27300, 27281, 27263, 27302, 27290, 27269, 27276, 27282, 27483,
27565, 27657, 28620, 28585, 28660, 28628, 28643, 28636, 28653, 28647,
28646, 28638, 28658, 28637, 28642, 28648, 29153, 29169, 29160, 29170,
29156, 29168, 29154, 29555, 29550, 29551, 29847, 29874, 29867, 29840,
29866, 29869, 29873, 29861, 29871, 29968, 29969, 29970, 29967, 30084,
30275, 30280, 30281, 30279, 30372, 30441, 30645, 30635, 30642, 30647,
30646,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0, 30644, 30641, 30632, 30704, 30963,
30973, 30978, 30971, 30972, 30962, 30981, 30969, 30974, 30980, 31147,
31144, 31324, 31323, 31318, 31320, 31316, 31322, 31422, 31424, 31425,
31749, 31759, 31730, 31744, 31743, 31739, 31758, 31732, 31755, 31731,
31746, 31753, 31747, 31745, 31736, 31741, 31750, 31728, 31729, 31760,
31754, 31976, 32301, 32316, 32322, 32307, 38984, 32312, 32298, 32329,
32320, 32327, 32297, 32332, 32304, 32315, 32310, 32324, 32314, 32581,
32639, 32638, 32637, 32756, 32754, 32812, 33211, 33220, 33228, 33226,
33221, 33223, 33212, 33257, 33371, 33370, 33372, 34179, 34176, 34191,
34215, 34197, 34208, 34187, 34211, 34171, 34212, 34202, 34206, 34167,
34172, 34185, 34209, 34170, 34168, 34135, 34190, 34198, 34182, 34189,
34201, 34205, 34177, 34210, 34178, 34184, 34181, 34169, 34166, 34200,
34192, 34207, 34408, 34750, 34730, 34733, 34757, 34736, 34732, 34745,
34741, 34748, 34734, 34761, 34755, 34754, 34764, 34743, 34735, 34756,
34762, 34740, 34742, 34751, 34744, 34749, 34782, 34738, 35125, 35123,
35132, 35134, 35137, 35154, 35127, 35138, 35245, 35247, 35246, 35314,
35315, 35614,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0, 35608, 35606, 35601, 35589,
35595, 35618, 35599, 35602, 35605, 35591, 35597, 35592, 35590, 35612,
35603, 35610, 35919, 35952, 35954, 35953, 35951, 35989, 35988, 36089,
36207, 36430, 36429, 36435, 36432, 36428, 36423, 36675, 36672, 36997,
36990, 37176, 37274, 37282, 37275, 37273, 37279, 37281, 37277, 37280,
37793, 37763, 37807, 37732, 37718, 37703, 37756, 37720, 37724, 37750,
37705, 37712, 37713, 37728, 37741, 37775, 37708, 37738, 37753, 37719,
37717, 37714, 37711, 37745, 37751, 37755, 37729, 37726, 37731, 37735,
37760, 37710, 37721, 38343, 38336, 38345, 38339, 38341, 38327, 38574,
38576, 38572, 38688, 38687, 38680, 38685, 38681, 38810, 38817, 38812,
38814, 38813, 38869, 38868, 38897, 38977, 38980, 38986, 38985, 38981,
38979, 39205, 39211, 39212, 39210, 39219, 39218, 39215, 39213, 39217,
39216, 39320, 39331, 39329, 39426, 39418, 39412, 39415, 39417, 39416,
39414, 39419, 39421, 39422, 39420, 39427, 39614, 39678, 39677, 39681,
39676, 39752, 39834, 39848, 39838, 39835, 39846, 39841, 39845, 39844,
39814, 39842, 39840, 39855, 40243, 40257, 40295, 40246, 40238, 40239,
40241, 40248, 40240,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0, 40261, 40258, 40259,
40254, 40247, 40256, 40253, 32757, 40237, 40586, 40585, 40589, 40624,
40648, 40666, 40699, 40703, 40740, 40739, 40738, 40788, 40864, 20785,
20781, 20782, 22168, 22172, 22167, 22170, 22173, 22169, 22896, 23356,
23657, 23658, 24000, 24173, 24174, 25048, 25055, 25069, 25070, 25073,
25066, 25072, 25067, 25046, 25065, 25855, 25860, 25853, 25848, 25857,
25859, 25852, 26004, 26075, 26330, 26331, 26328, 27333, 27321, 27325,
27361, 27334, 27322, 27318, 27319, 27335, 27316, 27309, 27486, 27593,
27659, 28679, 28684, 28685, 28673, 28677, 28692, 28686, 28671, 28672,
28667, 28710, 28668, 28663, 28682, 29185, 29183, 29177, 29187, 29181,
29558, 29880, 29888, 29877, 29889, 29886, 29878, 29883, 29890, 29972,
29971, 30300, 30308, 30297, 30288, 30291, 30295, 30298, 30374, 30397,
30444, 30658, 30650, 30975, 30988, 30995, 30996, 30985, 30992, 30994,
30993, 31149, 31148, 31327, 31772, 31785, 31769, 31776, 31775, 31789,
31773, 31782, 31784, 31778, 31781, 31792, 32348, 32336, 32342, 32355,
32344, 32354, 32351, 32337, 32352, 32343, 32339, 32693, 32691, 32759,
32760, 32885, 33233, 33234,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0, 33232, 33375,
33374, 34228, 34246, 34240, 34243, 34242, 34227, 34229, 34237, 34247,
34244, 34239, 34251, 34254, 34248, 34245, 34225, 34230, 34258, 34340,
34232, 34231, 34238, 34409, 34791, 34790, 34786, 34779, 34795, 34794,
34789, 34783, 34803, 34788, 34772, 34780, 34771, 34797, 34776, 34787,
34724, 34775, 34777, 34817, 34804, 34792, 34781, 35155, 35147, 35151,
35148, 35142, 35152, 35153, 35145, 35626, 35623, 35619, 35635, 35632,
35637, 35655, 35631, 35644, 35646, 35633, 35621, 35639, 35622, 35638,
35630, 35620, 35643, 35645, 35642, 35906, 35957, 35993, 35992, 35991,
36094, 36100, 36098, 36096, 36444, 36450, 36448, 36439, 36438, 36446,
36453, 36455, 36443, 36442, 36449, 36445, 36457, 36436, 36678, 36679,
36680, 36683, 37160, 37178, 37179, 37182, 37288, 37285, 37287, 37295,
37290, 37813, 37772, 37778, 37815, 37787, 37789, 37769, 37799, 37774,
37802, 37790, 37798, 37781, 37768, 37785, 37791, 37773, 37809, 37777,
37810, 37796, 37800, 37812, 37795, 37797, 38354, 38355, 38353, 38579,
38615, 38618, 24002, 38623, 38616, 38621, 38691, 38690, 38693, 38828,
38830, 38824, 38827, 38820, 38826,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0, 38818,
38821, 38871, 38873, 38870, 38872, 38906, 38992, 38993, 38994, 39096,
39233, 39228, 39226, 39439, 39435, 39433, 39437, 39428, 39441, 39434,
39429, 39431, 39430, 39616, 39644, 39688, 39684, 39685, 39721, 39733,
39754, 39756, 39755, 39879, 39878, 39875, 39871, 39873, 39861, 39864,
39891, 39862, 39876, 39865, 39869, 40284, 40275, 40271, 40266, 40283,
40267, 40281, 40278, 40268, 40279, 40274, 40276, 40287, 40280, 40282,
40590, 40588, 40671, 40705, 40704, 40726, 40741, 40747, 40746, 40745,
40744, 40780, 40789, 20788, 20789, 21142, 21239, 21428, 22187, 22189,
22182, 22183, 22186, 22188, 22746, 22749, 22747, 22802, 23357, 23358,
23359, 24003, 24176, 24511, 25083, 25863, 25872, 25869, 25865, 25868,
25870, 25988, 26078, 26077, 26334, 27367, 27360, 27340, 27345, 27353,
27339, 27359, 27356, 27344, 27371, 27343, 27341, 27358, 27488, 27568,
27660, 28697, 28711, 28704, 28694, 28715, 28705, 28706, 28707, 28713,
28695, 28708, 28700, 28714, 29196, 29194, 29191, 29186, 29189, 29349,
29350, 29348, 29347, 29345, 29899, 29893, 29879, 29891, 29974, 30304,
30665, 30666, 30660, 30705, 31005, 31003,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
31009, 31004, 30999, 31006, 31152, 31335, 31336, 31795, 31804, 31801,
31788, 31803, 31980, 31978, 32374, 32373, 32376, 32368, 32375, 32367,
32378, 32370, 32372, 32360, 32587, 32586, 32643, 32646, 32695, 32765,
32766, 32888, 33239, 33237, 33380, 33377, 33379, 34283, 34289, 34285,
34265, 34273, 34280, 34266, 34263, 34284, 34290, 34296, 34264, 34271,
34275, 34268, 34257, 34288, 34278, 34287, 34270, 34274, 34816, 34810,
34819, 34806, 34807, 34825, 34828, 34827, 34822, 34812, 34824, 34815,
34826, 34818, 35170, 35162, 35163, 35159, 35169, 35164, 35160, 35165,
35161, 35208, 35255, 35254, 35318, 35664, 35656, 35658, 35648, 35667,
35670, 35668, 35659, 35669, 35665, 35650, 35666, 35671, 35907, 35959,
35958, 35994, 36102, 36103, 36105, 36268, 36266, 36269, 36267, 36461,
36472, 36467, 36458, 36463, 36475, 36546, 36690, 36689, 36687, 36688,
36691, 36788, 37184, 37183, 37296, 37293, 37854, 37831, 37839, 37826,
37850, 37840, 37881, 37868, 37836, 37849, 37801, 37862, 37834, 37844,
37870, 37859, 37845, 37828, 37838, 37824, 37842, 37863, 38269, 38362,
38363, 38625, 38697, 38699, 38700, 38696, 38694,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0, 38835, 38839, 38838, 38877, 38878, 38879, 39004, 39001, 39005,
38999, 39103, 39101, 39099, 39102, 39240, 39239, 39235, 39334, 39335,
39450, 39445, 39461, 39453, 39460, 39451, 39458, 39456, 39463, 39459,
39454, 39452, 39444, 39618, 39691, 39690, 39694, 39692, 39735, 39914,
39915, 39904, 39902, 39908, 39910, 39906, 39920, 39892, 39895, 39916,
39900, 39897, 39909, 39893, 39905, 39898, 40311, 40321, 40330, 40324,
40328, 40305, 40320, 40312, 40326, 40331, 40332, 40317, 40299, 40308,
40309, 40304, 40297, 40325, 40307, 40315, 40322, 40303, 40313, 40319,
40327, 40296, 40596, 40593, 40640, 40700, 40749, 40768, 40769, 40781,
40790, 40791, 40792, 21303, 22194, 22197, 22195, 22755, 23365, 24006,
24007, 24302, 24303, 24512, 24513, 25081, 25879, 25878, 25877, 25875,
26079, 26344, 26339, 26340, 27379, 27376, 27370, 27368, 27385, 27377,
27374, 27375, 28732, 28725, 28719, 28727, 28724, 28721, 28738, 28728,
28735, 28730, 28729, 28736, 28731, 28723, 28737, 29203, 29204, 29352,
29565, 29564, 29882, 30379, 30378, 30398, 30445, 30668, 30670, 30671,
30669, 30706, 31013, 31011, 31015, 31016, 31012, 31017,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0, 31154, 31342, 31340, 31341, 31479, 31817, 31816, 31818,
31815, 31813, 31982, 32379, 32382, 32385, 32384, 32698, 32767, 32889,
33243, 33241, 33291, 33384, 33385, 34338, 34303, 34305, 34302, 34331,
34304, 34294, 34308, 34313, 34309, 34316, 34301, 34841, 34832, 34833,
34839, 34835, 34838, 35171, 35174, 35257, 35319, 35680, 35690, 35677,
35688, 35683, 35685, 35687, 35693, 36270, 36486, 36488, 36484, 36697,
36694, 36695, 36693, 36696, 36698, 37005, 37187, 37185, 37303, 37301,
37298, 37299, 37899, 37907, 37883, 37920, 37903, 37908, 37886, 37909,
37904, 37928, 37913, 37901, 37877, 37888, 37879, 37895, 37902, 37910,
37906, 37882, 37897, 37880, 37898, 37887, 37884, 37900, 37878, 37905,
37894, 38366, 38368, 38367, 38702, 38703, 38841, 38843, 38909, 38910,
39008, 39010, 39011, 39007, 39105, 39106, 39248, 39246, 39257, 39244,
39243, 39251, 39474, 39476, 39473, 39468, 39466, 39478, 39465, 39470,
39480, 39469, 39623, 39626, 39622, 39696, 39698, 39697, 39947, 39944,
39927, 39941, 39954, 39928, 40000, 39943, 39950, 39942, 39959, 39956,
39945, 40351, 40345, 40356, 40349, 40338, 40344, 40336, 40347,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0, 40352, 40340, 40348, 40362, 40343, 40353, 40346,
40354, 40360, 40350, 40355, 40383, 40361, 40342, 40358, 40359, 40601,
40603, 40602, 40677, 40676, 40679, 40678, 40752, 40750, 40795, 40800,
40798, 40797, 40793, 40849, 20794, 20793, 21144, 21143, 22211, 22205,
22206, 23368, 23367, 24011, 24015, 24305, 25085, 25883, 27394, 27388,
27395, 27384, 27392, 28739, 28740, 28746, 28744, 28745, 28741, 28742,
29213, 29210, 29209, 29566, 29975, 30314, 30672, 31021, 31025, 31023,
31828, 31827, 31986, 32394, 32391, 32392, 32395, 32390, 32397, 32589,
32699, 32816, 33245, 34328, 34346, 34342, 34335, 34339, 34332, 34329,
34343, 34350, 34337, 34336, 34345, 34334, 34341, 34857, 34845, 34843,
34848, 34852, 34844, 34859, 34890, 35181, 35177, 35182, 35179, 35322,
35705, 35704, 35653, 35706, 35707, 36112, 36116, 36271, 36494, 36492,
36702, 36699, 36701, 37190, 37188, 37189, 37305, 37951, 37947, 37942,
37929, 37949, 37948, 37936, 37945, 37930, 37943, 37932, 37952, 37937,
38373, 38372, 38371, 38709, 38714, 38847, 38881, 39012, 39113, 39110,
39104, 39256, 39254, 39481, 39485, 39494, 39492, 39490, 39489, 39482,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0, 39487, 39629, 39701, 39703, 39704, 39702,
39738, 39762, 39979, 39965, 39964, 39980, 39971, 39976, 39977, 39972,
39969, 40375, 40374, 40380, 40385, 40391, 40394, 40399, 40382, 40389,
40387, 40379, 40373, 40398, 40377, 40378, 40364, 40392, 40369, 40365,
40396, 40371, 40397, 40370, 40570, 40604, 40683, 40686, 40685, 40731,
40728, 40730, 40753, 40782, 40805, 40804, 40850, 20153, 22214, 22213,
22219, 22897, 23371, 23372, 24021, 24017, 24306, 25889, 25888, 25894,
25890, 27403, 27400, 27401, 27661, 28757, 28758, 28759, 28754, 29214,
29215, 29353, 29567, 29912, 29909, 29913, 29911, 30317, 30381, 31029,
31156, 31344, 31345, 31831, 31836, 31833, 31835, 31834, 31988, 31985,
32401, 32591, 32647, 33246, 33387, 34356, 34357, 34355, 34348, 34354,
34358, 34860, 34856, 34854, 34858, 34853, 35185, 35263, 35262, 35323,
35710, 35716, 35714, 35718, 35717, 35711, 36117, 36501, 36500, 36506,
36498, 36496, 36502, 36503, 36704, 36706, 37191, 37964, 37968, 37962,
37963, 37967, 37959, 37957, 37960, 37961, 37958, 38719, 38883, 39018,
39017, 39115, 39252, 39259, 39502, 39507, 39508, 39500, 39503, 39496,
39498,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0, 39497, 39506, 39504, 39632, 39705,
39723, 39739, 39766, 39765, 40006, 40008, 39999, 40004, 39993, 39987,
40001, 39996, 39991, 39988, 39986, 39997, 39990, 40411, 40402, 40414,
40410, 40395, 40400, 40412, 40401, 40415, 40425, 40409, 40408, 40406,
40437, 40405, 40413, 40630, 40688, 40757, 40755, 40754, 40770, 40811,
40853, 40866, 20797, 21145, 22760, 22759, 22898, 23373, 24024, 34863,
24399, 25089, 25091, 25092, 25897, 25893, 26006, 26347, 27409, 27410,
27407, 27594, 28763, 28762, 29218, 29570, 29569, 29571, 30320, 30676,
31847, 31846, 32405, 33388, 34362, 34368, 34361, 34364, 34353, 34363,
34366, 34864, 34866, 34862, 34867, 35190, 35188, 35187, 35326, 35724,
35726, 35723, 35720, 35909, 36121, 36504, 36708, 36707, 37308, 37986,
37973, 37981, 37975, 37982, 38852, 38853, 38912, 39510, 39513, 39710,
39711, 39712, 40018, 40024, 40016, 40010, 40013, 40011, 40021, 40025,
40012, 40014, 40443, 40439, 40431, 40419, 40427, 40440, 40420, 40438,
40417, 40430, 40422, 40434, 40432, 40418, 40428, 40436, 40435, 40424,
40429, 40642, 40656, 40690, 40691, 40710, 40732, 40760, 40759, 40758,
40771, 40783,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0, 40817, 40816, 40814, 40815,
22227, 22221, 23374, 23661, 25901, 26349, 26350, 27411, 28767, 28769,
28765, 28768, 29219, 29915, 29925, 30677, 31032, 31159, 31158, 31850,
32407, 32649, 33389, 34371, 34872, 34871, 34869, 34891, 35732, 35733,
36510, 36511, 36512, 36509, 37310, 37309, 37314, 37995, 37992, 37993,
38629, 38726, 38723, 38727, 38855, 38885, 39518, 39637, 39769, 40035,
40039, 40038, 40034, 40030, 40032, 40450, 40446, 40455, 40451, 40454,
40453, 40448, 40449, 40457, 40447, 40445, 40452, 40608, 40734, 40774,
40820, 40821, 40822, 22228, 25902, 26040, 27416, 27417, 27415, 27418,
28770, 29222, 29354, 30680, 30681, 31033, 31849, 31851, 31990, 32410,
32408, 32411, 32409, 33248, 33249, 34374, 34375, 34376, 35193, 35194,
35196, 35195, 35327, 35736, 35737, 36517, 36516, 36515, 37998, 37997,
37999, 38001, 38003, 38729, 39026, 39263, 40040, 40046, 40045, 40459,
40461, 40464, 40463, 40466, 40465, 40609, 40693, 40713, 40775, 40824,
40827, 40826, 40825, 22302, 28774, 31855, 34876, 36274, 36518, 37315,
38004, 38008, 38006, 38005, 39520, 40052, 40051, 40049, 40053, 40468,
40467, 40694, 40714,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0, 40868, 28776, 28773,
31991, 34410, 34878, 34877, 34879, 35742, 35996, 36521, 36553, 38731,
39027, 39028, 39116, 39265, 39339, 39524, 39526, 39527, 39716, 40469,
40471, 40776, 25095, 27422, 29223, 34380, 36520, 38018, 38016, 38017,
39529, 39528, 39726, 40473, 29225, 34379, 35743, 38019, 40057, 40631,
30325, 39531, 40058, 40477, 28777, 28778, 40612, 40830, 40777, 40856,
30849, 37561, 35023, 22715, 24658, 31911, 23290,  9556,  9574,  9559,
 9568,  9580,  9571,  9562,  9577,  9565,  9554,  9572,  9557,  9566,
 9578,  9569,  9560,  9575,  9563,  9555,  9573,  9558,  9567,  9579,
 9570,  9561,  9576,  9564,  9553,  9552,  9581,  9582,  9584,  9583,
 9619, 57344, 57345, 57346, 57347, 57348, 57349, 57350, 57351, 57352,
57353, 57354, 57355, 57356, 57357, 57358, 57359, 57360, 57361, 57362,
57363, 57364, 57365, 57366, 57367, 57368, 57369, 57370, 57371, 57372,
57373, 57374, 57375, 57376, 57377, 57378, 57379, 29234, 29244, 29286,
29314, 29327, 29343, 29357, 29361, 29368, 29374, 29389, 29403, 29476,
29487, 29496, 29497, 29629, 29646, 29681, 29814, 29858, 29953, 29977,
29987, 30012, 30020, 30025,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0, 30029, 30061,
30082, 30083, 30089, 30124, 30166, 30185, 30272, 30285, 30292, 30312,
30336, 30339, 30352, 30391, 30393, 30477, 30494, 30531, 30744, 30748,
30777, 30780, 30791, 30806, 30842, 30901, 30905, 30918, 30937, 30983,
31024, 31028, 31035, 31104, 31133, 31171, 31201, 31238, 31246, 31299,
31312, 31427, 31442, 31458, 31463, 31480, 31542, 31586, 31596, 31610,
31611, 31642, 31646, 31647, 31650, 31655, 31734, 31762, 31764, 31823,
31830, 31832, 31915, 31994, 32072, 32075, 32119, 32212, 32213, 32214,
32228, 32333, 32349, 32383, 32393, 32398, 32402, 32468, 32497, 32530,
32560, 32625, 32642, 32686, 32710, 32800, 32802, 32805, 32817, 32863,
32872, 32940, 32951, 20890, 21526, 21524, 13535, 19581, 25283, 57508,
57509, 57510, 21707, 57512, 21948, 32950, 20903, 57516, 57517, 57518,
21779, 33318, 57521, 21790, 21982, 25529, 26776, 57526, 21762, 21865,
30132, 25596, 40580, 37418, 57533, 57534, 57535, 35015, 24734, 22053,
28997, 23282, 57541, 21135, 22095, 30611, 34694, 36397, 33206, 13822,
29174, 57550, 34820, 37765, 57553, 57554, 30310, 57556, 40050, 57558,
25294, 57560, 40598, 18825, 31955,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0, 36570,
40619, 25831, 57567, 33450, 26471, 28018, 30982, 31172, 32590, 34798,
57575, 33726, 34351, 35237, 17935, 57580, 39112, 39232, 39245, 39436,
39639, 40600, 40742, 57588, 20227, 57590, 20281, 20274, 20395, 20566,
57595, 20526, 20646, 20697, 20750, 20717, 20737, 20980, 21023, 21088,
21079, 21146, 21201, 21216, 21217, 20947, 20959, 30022, 20990, 21298,
21292, 21299, 21419, 21418, 40846, 21609, 21660, 21466, 27338, 21875,
57625, 13782, 57627, 22033, 22093, 57630, 22100, 13811, 57633, 22342,
22394, 22375, 22586, 22502, 22493, 22592, 57641, 22566, 22748, 22967,
23001, 23584, 57647, 23761, 23785, 23878, 23950, 57652, 24053, 24075,
24082, 24110, 24158, 57658, 24397, 31357, 23491, 31419, 57663, 57664,
24484, 24506, 24508, 57668, 24695, 24740, 24755, 24829, 24880, 57674,
24988, 24921, 24957, 24924, 25471, 25058, 28885, 25145, 25192, 25221,
25218, 25254, 25301, 25444, 25397, 25744, 14940, 26184, 26215, 26398,
26627, 26540, 26617, 26806, 26924, 26881, 26880, 26826, 26995, 27008,
26942, 57706, 27058, 27072, 27018, 27130, 27113, 27314, 27218, 27293,
27421, 27474, 27642, 15569, 27854, 28239,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
28089, 28484, 57723, 28634, 28801, 31180, 28980, 15820, 29046, 57730,
57731, 29205, 29264, 29319, 29484, 29362, 29410, 29442, 29512, 29480,
29519, 29553, 25989, 57744, 29789, 29800, 29982, 30035, 30074, 30369,
30412, 30500, 30507, 16485, 30803, 30931, 30936, 40318, 30895, 57760,
24898, 31145, 39994, 31188, 57765, 31277, 31294, 31305, 31453, 31450,
30147, 30215, 30210, 57774, 30311, 30319, 22048, 35431, 40727, 31519,
31634, 31651, 31695, 57784, 31740, 31810, 31825, 31837, 31856, 31870,
31878, 31875, 31916, 31943, 31938, 57796, 31962, 57798, 32077, 32090,
32245, 32295, 32366, 40597, 21107, 32797, 32866, 32867, 32870, 32859,
32934, 33027, 40577, 33224, 57815, 36768, 33270, 33306, 57819, 34673,
34729, 34700, 40606, 34753, 40476, 57826, 34774, 34805, 34831, 34840,
34861, 34882, 34885, 39989, 34926, 34986, 34976, 25245, 35139, 35149,
29042, 34910, 57843, 33533, 17591, 33488, 33669, 40194, 40809, 33824,
57851, 34010, 33965, 17659, 34123, 57856, 34306, 34320, 25553, 35209,
35210, 35220, 40005, 35260, 35454, 35401, 35596, 35651, 35713, 35660,
57871, 36013, 36075, 36087, 36108, 36226, 36262,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0, 36308, 36392, 36431, 36471, 36469, 36519, 36633, 57885, 36700,
40260, 37060, 37201, 57890, 37212, 37209, 37223, 37244, 37262, 37307,
40616, 36950, 36940, 37374, 37474, 37566, 37739, 37742, 37818, 37927,
38295, 38311, 57909, 38456, 57911, 38531, 38550, 38529, 38589, 38659,
38689, 38705, 38751, 38815, 38836, 38840, 38842, 38846, 38856, 40639,
38943, 38958, 40869, 38983, 38987, 39014, 39020, 39092, 40794, 39132,
39142, 39234, 39225, 39227, 40787, 39242, 40773, 19326, 39386, 31432,
39610, 39613, 40706, 39722, 57951, 39725, 39650, 39682, 39679, 19463,
39689, 19460, 19515, 39823, 39837, 39856, 39948, 39957, 39946, 39935,
39982, 33000, 33001, 33004, 33038, 27705, 20074, 38465, 22770, 31074,
26658, 57978, 57979, 33031, 22487, 17642, 25653, 34100, 16607, 57986,
26906, 39938, 30129, 33747, 29041, 27147, 57993, 27258, 39668, 57996,
57997, 30649, 25904, 28054, 22071, 26405, 27179, 32093, 36961, 20120,
31910, 31545, 58009, 22901, 14023, 28799, 58013, 28299, 58015, 58016,
38749, 37584, 22356, 58020, 16089, 58022, 58023, 24985, 29792, 28991,
31022, 23190, 37704, 26254, 20477, 37697, 13908, 23925,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    0,     0, 28702, 25979, 28813, 24269, 58039, 24743, 31408, 24419,
58043, 29687, 58045, 29800, 30132, 58048, 39785,   189,  8531,  8532,
  188,   190,  8533,  8534,  8535,  8536,  8537,  8538, 34450, 34464,
34477, 34482, 34725, 34737,  8539,  8540,  8541,  8542, 34778, 34895,
34912, 34951, 34959, 34960, 35046, 35071, 35072, 35108, 35143, 35156,
35173, 35200, 35217, 35356, 35369, 35371, 35384, 35389,  8978, 35472,
35476, 35484, 35497, 35503, 35508, 35562, 35615,  8240, 35647, 35661,
35678, 35682, 35689, 35739, 35921, 35995, 35999, 36052, 36054, 33042,
33073, 33078, 33119, 33133, 33149, 33171, 33194, 33208, 33217, 33321,
33325, 33326, 33342, 33378, 33386, 33416
};

static const uchar ucs_to_big5[][2] =
{
    {0x00,0x00},{0x00,0x01},{0x00,0x02},{0x00,0x03},{0x00,0x04},
    {0x00,0x05},{0x00,0x06},{0x00,0x07},{0x00,0x08},{0x00,0x09},
    {0x00,0x0a},{0x00,0x0b},{0x00,0x0c},{0x00,0x0d},{0x00,0x0e},
    {0x00,0x0f},{0x00,0x10},{0x00,0x11},{0x00,0x12},{0x00,0x13},
    {0x00,0x14},{0x00,0x15},{0x00,0x16},{0x00,0x17},{0x00,0x18},
    {0x00,0x19},{0x00,0x1a},{0x00,0x1b},{0x00,0x1c},{0x00,0x1d},
    {0x00,0x1e},{0x00,0x1f},{0x00,0x20},{0x00,0x21},{0x00,0x22},
    {0x00,0x23},{0x00,0x24},{0x00,0x25},{0x00,0x26},{0x00,0x27},
    {0x00,0x28},{0x00,0x29},{0x00,0x2a},{0x00,0x2b},{0x00,0x2c},
    {0x00,0x2d},{0x00,0x2e},{0x00,0x2f},{0x00,0x30},{0x00,0x31},
    {0x00,0x32},{0x00,0x33},{0x00,0x34},{0x00,0x35},{0x00,0x36},
    {0x00,0x37},{0x00,0x38},{0x00,0x39},{0x00,0x3a},{0x00,0x3b},
    {0x00,0x3c},{0x00,0x3d},{0x00,0x3e},{0x00,0x3f},{0x00,0x40},
    {0x00,0x41},{0x00,0x42},{0x00,0x43},{0x00,0x44},{0x00,0x45},
    {0x00,0x46},{0x00,0x47},{0x00,0x48},{0x00,0x49},{0x00,0x4a},
    {0x00,0x4b},{0x00,0x4c},{0x00,0x4d},{0x00,0x4e},{0x00,0x4f},
    {0x00,0x50},{0x00,0x51},{0x00,0x52},{0x00,0x53},{0x00,0x54},
    {0x00,0x55},{0x00,0x56},{0x00,0x57},{0x00,0x58},{0x00,0x59},
    {0x00,0x5a},{0x00,0x5b},{0x00,0x5c},{0x00,0x5d},{0x00,0x5e},
    {0x00,0x5f},{0x00,0x60},{0x00,0x61},{0x00,0x62},{0x00,0x63},
    {0x00,0x64},{0x00,0x65},{0x00,0x66},{0x00,0x67},{0x00,0x68},
    {0x00,0x69},{0x00,0x6a},{0x00,0x6b},{0x00,0x6c},{0x00,0x6d},
    {0x00,0x6e},{0x00,0x6f},{0x00,0x70},{0x00,0x71},{0x00,0x72},
    {0x00,0x73},{0x00,0x74},{0x00,0x75},{0x00,0x76},{0x00,0x77},
    {0x00,0x78},{0x00,0x79},{0x00,0x7a},{0x00,0x7b},{0x00,0x7c},
    {0x00,0x7d},{0x00,0x7e},{0x00,0x7f},{0x00,0x80},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0xa0,0xdf},{0xa2,0x46},{0xa2,0x47},{0xa0,0xfc},
    {0xa2,0x44},{0x7c,0x20},{0xa1,0xb1},{0xc6,0xd8},{0x63,0x20},
    {0xa0,0xde},{0x00,0x00},{0x00,0x00},{0x2d,0x20},{0x97,0xfb},
    {0xa1,0xc2},{0xa2,0x58},{0xa1,0xd3},{0x32,0x20},{0x33,0x20},
    {0xa1,0xac},{0xa3,0x67},{0x91,0xf8},{0xa1,0x50},{0xa0,0xfb},
    {0x31,0x20},{0xa0,0xee},{0x00,0x00},{0xfe,0xb3},{0xfe,0xb0},
    {0xfe,0xb4},{0xa0,0xef},{0xa0,0xa7},{0xa0,0xac},{0xa0,0xf6},
    {0xa0,0xbe},{0xa0,0xb6},{0xa0,0xd6},{0xa0,0xbb},{0xa0,0xbc},
    {0xa0,0xa8},{0xa0,0xd7},{0xa0,0xf7},{0xa0,0xb7},{0xa0,0xa9},
    {0xa0,0xad},{0xa0,0xf8},{0xa0,0xb8},{0xa0,0xda},{0xa0,0xbd},
    {0xa0,0xaa},{0xa0,0xae},{0xa0,0xf9},{0xa0,0xbf},{0xa0,0xb9},
    {0xa1,0xd1},{0xa0,0xd9},{0xa0,0xab},{0xa0,0xaf},{0xa0,0xfa},
    {0xa0,0xba},{0x59,0x20},{0xa0,0xdc},{0xa0,0xdd},{0xa0,0xe0},
    {0xa0,0xc0},{0xa0,0xf0},{0xa0,0xce},{0xa0,0xc6},{0xa0,0xe6},
    {0xa0,0xcb},{0xa0,0xcc},{0xa0,0xe1},{0xa0,0xc1},{0xa0,0xf1},
    {0xa0,0xc7},{0xa0,0xe2},{0xa0,0xc2},{0xa0,0xf2},{0xa0,0xc8},
    {0xa0,0xea},{0xa0,0xcd},{0xa0,0xe3},{0xa0,0xc3},{0xa0,0xf3},
    {0xa0,0xcf},{0xa0,0xc9},{0xa1,0xd2},{0xa0,0xe9},{0xa0,0xe4},
    {0xa0,0xc4},{0xa0,0xf4},{0xa0,0xca},{0x79,0x20},{0xa0,0xec},
    {0xa0,0xed},{0x00,0x00},{0xa0,0xb0},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0xa0,0xb1},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0xa0,0xd1},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0xa0,0xb2},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x9b,0xd5},{0x00,0x00},{0x00,0x00},{0xa0,0xb3},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x9b,0xe5},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0xa0,0xb4},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0xa0,0xfe},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0xa0,0xd0},{0x00,0x00},{0xa0,0xd2},
    {0x00,0x00},{0xa0,0xd3},{0x00,0x00},{0xa0,0xd4},{0x00,0x00},
    {0xa0,0xb5},{0x00,0x00},{0xa0,0xc5},{0x00,0x00},{0xa0,0xd5},
    {0x00,0x00},{0xa0,0xe5},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x9b,0xcb},{0x9b,0xe6},
    {0x00,0x00},{0x9b,0xcc},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x9b,0xcf},{0x9b,0xd0},{0x9b,0xc8},{0x9b,0xd1},
    {0x9b,0xce},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x9b,0xd2},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x9b,0xc7},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x9b,0xe0},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x9b,0xd7},
    {0x00,0x00},{0x00,0x00},{0x9b,0xe1},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x9b,0xd9},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x9b,0xe2},{0x00,0x00},{0x00,0x00},
    {0x9b,0xcd},{0x00,0x00},{0x9b,0xca},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x9b,0xda},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x9b,0xdc},{0x00,0x00},{0x00,0x00},{0x9b,0xdb},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0xc6,0xd9},{0xa3,0xbe},{0x00,0x00},{0xa3,0xbc},{0xa3,0xbd},
    {0xa3,0xbf},{0x00,0x00},{0xa1,0xc5},{0x00,0x00},{0x9b,0xe9},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0xa3,0xbb},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0xa3,0x44},{0xa3,0x45},
    {0xa3,0x46},{0xa3,0x47},{0xa3,0x48},{0xa3,0x49},{0xa3,0x4a},
    {0xa3,0x4b},{0xa3,0x4c},{0xa3,0x4d},{0xa3,0x4e},{0xa3,0x4f},
    {0xa3,0x50},{0xa3,0x51},{0xa3,0x52},{0xa3,0x53},{0xa3,0x54},
    {0x00,0x00},{0xa3,0x55},{0xa3,0x56},{0xa3,0x57},{0xa3,0x58},
    {0xa3,0x59},{0xa3,0x5a},{0xa3,0x5b},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0xa3,0x5c},{0xa3,0x5d},{0xa3,0x5e},{0xa3,0x5f},{0xa3,0x60},
    {0xa3,0x61},{0xa3,0x62},{0xa3,0x63},{0xa3,0x64},{0xa3,0x65},
    {0xa3,0x66},{0xa3,0x67},{0xa3,0x68},{0xa3,0x69},{0xa3,0x6a},
    {0xa3,0x6b},{0xa3,0x6c},{0x00,0x00},{0xa3,0x6d},{0xa3,0x6e},
    {0xa3,0x6f},{0xa3,0x70},{0xa3,0x71},{0xa3,0x72},{0xa3,0x73},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0xc7,0xf9},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0xc7,0xf3},{0xc7,0xf4},{0xc7,0xf5},{0xc7,0xf6},{0xc7,0xf7},
    {0xc7,0xf8},{0xc7,0xfa},{0xc7,0xfb},{0xc7,0xfc},{0xc7,0xfd},
    {0xc7,0xfe},{0xc8,0x40},{0xc8,0x41},{0xc8,0x42},{0xc8,0x43},
    {0xc8,0x44},{0xc8,0x45},{0xc8,0x46},{0xc8,0x47},{0xc8,0x48},
    {0xc8,0x49},{0xc8,0x4a},{0xc8,0x4b},{0xc8,0x4c},{0xc8,0x4d},
    {0xc8,0x4e},{0xc8,0x4f},{0xc8,0x50},{0xc8,0x51},{0xc8,0x52},
    {0xc8,0x53},{0xc8,0x54},{0xc8,0x55},{0xc8,0x56},{0xc8,0x57},
    {0xc8,0x58},{0xc8,0x59},{0xc8,0x5a},{0xc8,0x5c},{0xc8,0x5d},
    {0xc8,0x5e},{0xc8,0x5f},{0xc8,0x60},{0xc8,0x61},{0xc8,0x62},
    {0xc8,0x63},{0xc8,0x64},{0xc8,0x65},{0xc8,0x66},{0xc8,0x67},
    {0xc8,0x68},{0xc8,0x69},{0xc8,0x6a},{0xc8,0x6b},{0xc8,0x6c},
    {0xc8,0x6d},{0xc8,0x6e},{0xc8,0x6f},{0xc8,0x70},{0xc8,0x71},
    {0xc8,0x72},{0xc8,0x73},{0xc8,0x74},{0xc8,0x75},{0x00,0x00},
    {0xc8,0x5b},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x9b,0xd6},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x9b,0xd3},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x9b,0xd4},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0xa0,0xdb},{0xa0,0xeb},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x9f,0xec},{0x00,0x00},
    {0x00,0x00},{0xa1,0x56},{0xa1,0x58},{0xa2,0x77},{0xa1,0xfc},
    {0x00,0x00},{0xa1,0xa5},{0xa1,0xa6},{0x00,0x00},{0x00,0x00},
    {0xa1,0xa7},{0xa1,0xa8},{0x00,0x00},{0x00,0x00},{0xa1,0xcf},
    {0x91,0xde},{0xa1,0x45},{0x00,0x00},{0xa3,0xbb},{0xa1,0x4c},
    {0xa1,0x4b},{0xa1,0x45},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0xfe,0xe2},{0x00,0x00},{0xa1,0xac},{0xa1,0xb2},{0x00,0x00},
    {0xa1,0xab},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0xa1,0xb0},{0x91,0xf7},{0x00,0x00},{0xa1,0xc3},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0xa3,0xe1},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0xa2,0x4a},{0x00,0x00},{0xa1,0xc1},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0xa2,0x4b},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x9d,0xcf},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x9d,0xe2},{0x00,0x00},
    {0x00,0x00},{0x9d,0xc9},{0x97,0xfc},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x96,0x52},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x9d,0xc8},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0xfe,0xb1},{0xfe,0xb2},{0xfe,0xb5},{0xfe,0xb6},
    {0xfe,0xb7},{0xfe,0xb8},{0xfe,0xb9},{0xfe,0xba},{0xfe,0xc1},
    {0xfe,0xc2},{0xfe,0xc3},{0xfe,0xc4},{0x00,0x00},{0xa2,0xb9},
    {0xa2,0xba},{0xa2,0xbb},{0xa2,0xbc},{0xa2,0xbd},{0xa2,0xbe},
    {0xa2,0xbf},{0xa2,0xc0},{0xa2,0xc1},{0xa2,0xc2},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0xc6,0xb5},{0xc6,0xb6},{0xc6,0xb7},{0xc6,0xb8},{0xc6,0xb9},
    {0xc6,0xba},{0xc6,0xbb},{0xc6,0xbc},{0xc6,0xbd},{0xc6,0xbe},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0xa1,0xf6},{0xa1,0xf4},{0xa1,0xf7},
    {0xa1,0xf5},{0x91,0xfb},{0x91,0xf6},{0xa1,0xf8},{0xa1,0xf9},
    {0xa1,0xfb},{0xa1,0xfa},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x91,0xfa},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x9d,0xfd},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0xc8,0x77},{0xc8,0x78},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x96,0x53},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x99,0x65},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x9d,0x4a},{0xc8,0x76},
    {0x9d,0x49},{0x9d,0x4c},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x91,0xf9},
    {0x00,0x00},{0xa0,0x79},{0x98,0xf9},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0xa1,0xbe},{0x91,0x6b},{0x00,0x00},{0x00,0x00},
    {0x91,0x5f},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0xa3,0x53},
    {0x00,0x00},{0xa3,0x55},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0xa2,0x41},{0xa2,0x42},{0x00,0x00},{0xa2,0x58},{0x00,0x00},
    {0xa1,0xd4},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0xa1,0xdb},
    {0xa1,0xe8},{0xa1,0xe7},{0x00,0x00},{0x00,0x00},{0xa1,0xfd},
    {0x00,0x00},{0xa1,0xfc},{0x00,0x00},{0xa3,0x4e},{0xa2,0xe4},
    {0xa1,0xe4},{0xa1,0xe5},{0xa1,0xec},{0x9f,0x4c},{0x00,0x00},
    {0xa1,0xed},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0xa1,0xef},{0xa1,0xee},{0xa1,0x47},{0x9f,0x46},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0xa1,0xdc},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0xa1,0xda},{0xa1,0xdd},{0x00,0x00},{0xa1,0xdd},{0x00,0x00},
    {0x00,0x00},{0xa1,0xd8},{0xa1,0xd9},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x9a,0xe0},
    {0x9a,0xa6},{0x00,0x00},{0x00,0x00},{0x9c,0x72},{0x9c,0xaa},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0xa1,0xf2},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0xa1,0xf3},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0xa1,0xe6},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0xa1,0xe9},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x91,0xfc},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0xa1,0x5b},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0xfe,0xd9},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0xa3,0xc0},{0xa3,0xc1},{0xa3,0xc2},{0xa3,0xc3},
    {0xa3,0xc4},{0xa3,0xc5},{0xa3,0xc6},{0xa3,0xc7},{0xa3,0xc8},
    {0xa3,0xc9},{0xa3,0xca},{0xa3,0xcb},{0xa3,0xcc},{0xa3,0xcd},
    {0xa3,0xce},{0xa3,0xcf},{0xa3,0xd0},{0xa3,0xd1},{0xa3,0xd2},
    {0xa3,0xd3},{0xa3,0xd4},{0xa3,0xd5},{0xa3,0xd6},{0xa3,0xd7},
    {0xa3,0xd8},{0xa3,0xd9},{0xa3,0xda},{0xa3,0xdb},{0xa3,0xdc},
    {0xa3,0xdd},{0xa3,0xde},{0xa3,0xdf},{0x00,0x00},{0xa3,0xe0},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0xc6,0xa1},{0xc6,0xa2},{0xc6,0xa3},
    {0xc6,0xa4},{0xc6,0xa5},{0xc6,0xa6},{0xc6,0xa7},{0xc6,0xa8},
    {0xc6,0xa9},{0xc6,0xaa},{0x97,0x4b},{0x97,0x4c},{0x97,0x4d},
    {0x97,0x4e},{0x97,0x4f},{0x97,0x50},{0x97,0x51},{0x97,0x52},
    {0x97,0x53},{0x97,0x54},{0xc6,0xab},{0xc6,0xac},{0xc6,0xad},
    {0xc6,0xae},{0xc6,0xaf},{0xc6,0xb0},{0xc6,0xb1},{0xc6,0xb2},
    {0xc6,0xb3},{0xc6,0xb4},{0x99,0x4b},{0x99,0x4c},{0x99,0x4d},
    {0x99,0x4e},{0x99,0x4f},{0x99,0x50},{0x99,0x51},{0x99,0x52},
    {0x99,0x53},{0x99,0x54},{0x9a,0x41},{0x9a,0x42},{0x9a,0x43},
    {0x9a,0x44},{0x9a,0x45},{0x9a,0x46},{0x9a,0x47},{0x9a,0x48},
    {0x9a,0x49},{0x9a,0x4a},{0x9a,0x4b},{0x9a,0x4c},{0x9a,0x4d},
    {0x9a,0x4e},{0x9a,0x4f},{0x9a,0x50},{0x9a,0x51},{0x9a,0x52},
    {0x9a,0x53},{0x9a,0x54},{0x99,0xe1},{0x99,0xe2},{0x99,0xe3},
    {0x99,0xe4},{0x99,0xe5},{0x99,0xe6},{0x99,0xe7},{0x99,0xe8},
    {0x99,0xe9},{0x99,0xea},{0x99,0xeb},{0x99,0xec},{0x99,0xed},
    {0x99,0xee},{0x99,0xef},{0x99,0xf0},{0x99,0xf1},{0x99,0xf2},
    {0x99,0xf3},{0x99,0xf4},{0x99,0xf5},{0x99,0xf6},{0x99,0xf7},
    {0x99,0xf8},{0x99,0xf9},{0x99,0xfa},{0x97,0xc7},{0x97,0xc8},
    {0x97,0xc9},{0x97,0xca},{0x97,0xcb},{0x97,0xcc},{0x97,0xcd},
    {0x97,0xce},{0x97,0xcf},{0x97,0xd0},{0x97,0xd1},{0x97,0xd2},
    {0x97,0xd3},{0x97,0xd4},{0x97,0xd5},{0x97,0xd6},{0x97,0xd7},
    {0x97,0xd8},{0x97,0xd9},{0x97,0xda},{0x97,0xdb},{0x97,0xdc},
    {0x97,0xdd},{0x97,0xde},{0x97,0xdf},{0x97,0xe0},{0x97,0xe1},
    {0x97,0xe2},{0x97,0xe3},{0x97,0xe4},{0x97,0xe5},{0x97,0xe6},
    {0x97,0xe7},{0x97,0xe8},{0x97,0xe9},{0x97,0xea},{0x97,0xeb},
    {0x97,0xec},{0x97,0xed},{0x97,0xee},{0x97,0xef},{0x97,0xf0},
    {0x97,0xf1},{0x97,0xf2},{0x97,0xf3},{0x97,0xf4},{0x97,0xf5},
    {0x97,0xf6},{0x97,0xf7},{0x97,0xf8},{0x97,0xf9},{0x97,0xfa},
    {0x97,0x40},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0xa2,0x77},{0x9d,0x7d},{0xa2,0x78},
    {0x9d,0x7e},{0xa1,0x4c},{0xa1,0x4c},{0xa1,0x4a},{0xa1,0x4a},
    {0xa1,0x4b},{0xa1,0x4b},{0xa1,0x55},{0xa1,0x55},{0xa2,0x7a},
    {0xa2,0x7a},{0xa2,0x7a},{0xa2,0x7a},{0xa2,0x7b},{0xa2,0x7b},
    {0xa2,0x7b},{0xa2,0x7b},{0xa2,0x7c},{0xa2,0x7c},{0xa2,0x7c},
    {0xa2,0x7c},{0xa2,0x7d},{0xa2,0x7d},{0xa2,0x7d},{0xa2,0x7d},
    {0xa2,0x75},{0xa2,0x75},{0xa2,0x75},{0xa2,0x75},{0xa2,0x75},
    {0xa2,0x75},{0xa2,0x75},{0xa2,0x75},{0xa2,0x74},{0xa2,0x74},
    {0xa2,0x74},{0xa2,0x74},{0xa2,0x74},{0xa2,0x74},{0xa2,0x74},
    {0xa2,0x74},{0xa2,0x73},{0xa2,0x73},{0xa2,0x73},{0xa2,0x73},
    {0xa2,0x73},{0xa2,0x73},{0xa2,0x73},{0xa2,0x73},{0xa2,0x72},
    {0xa2,0x72},{0xa2,0x72},{0xa2,0x72},{0xa2,0x72},{0xa2,0x72},
    {0xa2,0x72},{0xa2,0x72},{0xa2,0x71},{0xa2,0x71},{0xa2,0x71},
    {0xa2,0x71},{0xa2,0x71},{0xa2,0x71},{0xa2,0x71},{0xa2,0x71},
    {0xa2,0x71},{0xa2,0x71},{0xa2,0x71},{0xa2,0x71},{0xa2,0x71},
    {0xa2,0x71},{0xa2,0x71},{0xa2,0x71},{0x00,0x00},{0x00,0x00},
    {0x91,0xf0},{0x00,0x00},{0xf9,0xf9},{0xf9,0xf8},{0xf9,0xe6},
    {0xf9,0xef},{0xf9,0xdd},{0xf9,0xe8},{0xf9,0xf1},{0xf9,0xdf},
    {0xf9,0xec},{0xf9,0xf5},{0xf9,0xe3},{0xf9,0xee},{0xf9,0xf7},
    {0xf9,0xe5},{0xf9,0xe9},{0xf9,0xf2},{0xf9,0xe0},{0xf9,0xeb},
    {0xf9,0xf4},{0xf9,0xe2},{0xf9,0xe7},{0xf9,0xf0},{0xf9,0xde},
    {0xf9,0xed},{0xf9,0xf6},{0xf9,0xe4},{0xf9,0xea},{0xf9,0xf3},
    {0xf9,0xe1},{0xa2,0x7e},{0xa2,0xa1},{0xa2,0xa3},{0xa2,0xa2},
    {0xa2,0xac},{0xa2,0xad},{0xa2,0xae},{0xa1,0x5a},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0xa2,0x62},{0xa2,0x63},{0xa2,0x64},{0xa2,0x65},
    {0xa2,0x66},{0xa2,0x67},{0xa2,0x68},{0xa2,0x69},{0xa2,0x70},
    {0xa2,0x6f},{0xa2,0x6e},{0xa2,0x6d},{0xa2,0x6c},{0xa2,0x6b},
    {0xa2,0x6a},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0xf9,0xfe},
    {0xa2,0x76},{0xa2,0x79},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0xa1,0xbd},{0xa1,0xbc},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0xa1,0xb6},{0xa1,0xb5},{0x00,0x00},{0x00,0x00},{0x91,0xf4},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0xa1,0xbf},{0xa1,0xbe},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x91,0xf5},{0x00,0x00},
    {0xa1,0xbb},{0xa1,0xba},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0xa1,0xb3},{0x00,0x00},{0x00,0x00},{0xa1,0xb7},{0xa1,0xb4},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x91,0xf1},{0x91,0xf2},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0xa2,0xa8},{0xa2,0xa9},
    {0xa2,0xab},{0xa2,0xaa},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0xa1,0xb3},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x9d,0xba},
    {0x9d,0xbc},{0x00,0x00},{0x00,0x00},{0xa1,0xb9},{0xa1,0xb8},
    {0x00,0x00},{0x00,0x00},{0xa1,0xf3},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x9d,0x40},{0x00,0x00},{0x00,0x00},
    {0x9d,0xed},{0x9c,0xd1},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x9d,0x4f},{0x9d,0x4e},{0x00,0x00},{0x9d,0x4d},{0x9d,0x50},
    {0x9d,0xd5},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x9f,0x55},{0x9f,0x56},{0x9f,0x5d},{0x9f,0x5b},{0x9f,0x58},
    {0x9f,0x59},{0x9f,0x5a},{0x9f,0x5c},{0x9f,0x57},{0x00,0x00},
    {0x9d,0x5e},{0x9d,0x5d},{0x98,0xfc},{0x9d,0xb8},{0x9d,0x57},
    {0x00,0x00},{0x00,0x00},{0xa1,0xf0},{0xa1,0xf2},{0xa1,0xf1},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x9d,0xd8},
    {0x9d,0xdd},{0x9d,0xdb},{0x9d,0xda},{0x9d,0xd7},{0x9d,0xde},
    {0x9d,0xdc},{0x9d,0xd9},{0x00,0x00},{0x00,0x00},{0x9d,0x66},
    {0x00,0x00},{0x9d,0x65},{0xa2,0xea},{0x00,0x00},{0xa1,0xad},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x9d,0x6c},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x9d,0xc0},{0x9d,0x6b},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x9d,0x55},{0x00,0x00},
    {0x9d,0x54},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x9d,0x5c},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x9d,0x5b},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0xc6,0xe6},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x9d,0x77},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x98,0x41},{0x98,0x42},{0x98,0x43},
    {0x98,0x44},{0x98,0x45},{0x98,0x46},{0x98,0x47},{0x98,0x48},
    {0x98,0x49},{0x98,0x4a},{0xc6,0xa1},{0xc6,0xa2},{0xc6,0xa3},
    {0xc6,0xa4},{0xc6,0xa5},{0xc6,0xa6},{0xc6,0xa7},{0xc6,0xa8},
    {0xc6,0xa9},{0xc6,0xaa},{0x98,0x41},{0x98,0x42},{0x98,0x43},
    {0x98,0x44},{0x98,0x45},{0x98,0x46},{0x98,0x47},{0x98,0x48},
    {0x98,0x49},{0x98,0x4a},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x91,0xed},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x9c,0xce},{0x00,0x00},{0x00,0x00},{0x9c,0xd5},
    {0x00,0x00},{0x9c,0xd4},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x9c,0xdb},{0x00,0x00},{0x91,0xdb},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x91,0xc9},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x9c,0xf7},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0xc6,0xbf},
    {0xc6,0xc0},{0x00,0x00},{0xc6,0xc1},{0x00,0x00},{0xc6,0xc2},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0xc6,0xc3},
    {0xc6,0xc4},{0xc6,0xc5},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0xc6,0xc6},{0x00,0x00},{0x00,0x00},{0xc6,0xc7},
    {0x00,0x00},{0x00,0x00},{0xc6,0xc8},{0x00,0x00},{0xc6,0xc9},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0xc6,0xca},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0xc6,0xcb},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0xc6,0xcc},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0xc6,0xcd},{0xc6,0xce},
    {0xc6,0xcf},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0xc6,0xd0},
    {0xc6,0xd1},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0xc6,0xd2},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0xc6,0xd3},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0xc6,0xd4},{0xc6,0xd5},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0xc6,0xd6},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0xc6,0xd7},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0xa1,0x40},{0xa1,0x42},
    {0xa1,0x43},{0xa1,0xb2},{0x00,0x00},{0xc6,0xe0},{0xc6,0xe1},
    {0xc6,0xe2},{0xa1,0x71},{0xa1,0x72},{0xa1,0x6d},{0xa1,0x6e},
    {0xa1,0x75},{0xa1,0x76},{0xa1,0x79},{0xa1,0x7a},{0xa1,0x69},
    {0xa1,0x6a},{0xa2,0x45},{0x96,0x5d},{0xa1,0x65},{0xa1,0x66},
    {0x9d,0x51},{0x9d,0x52},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0xa1,0xe3},{0xa1,0xa9},{0xa1,0xaa},{0x00,0x00},
    {0x00,0x00},{0xa2,0xc3},{0xa2,0xc4},{0xa2,0xc5},{0xa2,0xc6},
    {0xa2,0xc7},{0xa2,0xc8},{0xa2,0xc9},{0xa2,0xca},{0xa2,0xcb},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0xa1,0xca},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0xa2,0xcc},
    {0xa2,0xcd},{0xa2,0xce},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0xc6,0xe7},{0xc6,0xe8},
    {0xc6,0xe9},{0xc6,0xea},{0xc6,0xeb},{0xc6,0xec},{0xc6,0xed},
    {0xc6,0xee},{0xc6,0xef},{0xc6,0xf0},{0xc6,0xf1},{0xc6,0xf2},
    {0xc6,0xf3},{0xc6,0xf4},{0xc6,0xf5},{0xc6,0xf6},{0xc6,0xf7},
    {0xc6,0xf8},{0xc6,0xf9},{0xc6,0xfa},{0xc6,0xfb},{0xc6,0xfc},
    {0xc6,0xfd},{0xc6,0xfe},{0xc7,0x40},{0xc7,0x41},{0xc7,0x42},
    {0xc7,0x43},{0xc7,0x44},{0xc7,0x45},{0xc7,0x46},{0xc7,0x47},
    {0xc7,0x48},{0xc7,0x49},{0xc7,0x4a},{0xc7,0x4b},{0xc7,0x4c},
    {0xc7,0x4d},{0xc7,0x4e},{0xc7,0x4f},{0xc7,0x50},{0xc7,0x51},
    {0xc7,0x52},{0xc7,0x53},{0xc7,0x54},{0xc7,0x55},{0xc7,0x56},
    {0xc7,0x57},{0xc7,0x58},{0xc7,0x59},{0xc7,0x5a},{0xc7,0x5b},
    {0xc7,0x5c},{0xc7,0x5d},{0xc7,0x5e},{0xc7,0x5f},{0xc7,0x60},
    {0xc7,0x61},{0xc7,0x62},{0xc7,0x63},{0xc7,0x64},{0xc7,0x65},
    {0xc7,0x66},{0xc7,0x67},{0xc7,0x68},{0xc7,0x69},{0xc7,0x6a},
    {0xc7,0x6b},{0xc7,0x6c},{0xc7,0x6d},{0xc7,0x6e},{0xc7,0x6f},
    {0xc7,0x70},{0xc7,0x71},{0xc7,0x72},{0xc7,0x73},{0xc7,0x74},
    {0xc7,0x75},{0xc7,0x76},{0xc7,0x77},{0xc7,0x78},{0xc7,0x79},
    {0xc7,0x7a},{0xc8,0xb3},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0xc8,0xb1},{0xc8,0xb2},
    {0xc6,0xdc},{0xc6,0xdd},{0x00,0x00},{0x00,0x00},{0xc7,0x7b},
    {0xc7,0x7c},{0xc7,0x7d},{0xc7,0x7e},{0xc7,0xa1},{0xc7,0xa2},
    {0xc7,0xa3},{0xc7,0xa4},{0xc7,0xa5},{0xc7,0xa6},{0xc7,0xa7},
    {0xc7,0xa8},{0xc7,0xa9},{0xc7,0xaa},{0xc7,0xab},{0xc7,0xac},
    {0xc7,0xad},{0xc7,0xae},{0xc7,0xaf},{0xc7,0xb0},{0xc7,0xb1},
    {0xc7,0xb2},{0xc7,0xb3},{0xc7,0xb4},{0xc7,0xb5},{0xc7,0xb6},
    {0xc7,0xb7},{0xc7,0xb8},{0xc7,0xb9},{0xc7,0xba},{0xc7,0xbb},
    {0xc7,0xbc},{0xc7,0xbd},{0xc7,0xbe},{0xc7,0xbf},{0xc7,0xc0},
    {0xc7,0xc1},{0xc7,0xc2},{0xc7,0xc3},{0xc7,0xc4},{0xc7,0xc5},
    {0xc7,0xc6},{0xc7,0xc7},{0xc7,0xc8},{0xc7,0xc9},{0xc7,0xca},
    {0xc7,0xcb},{0xc7,0xcc},{0xc7,0xcd},{0xc7,0xce},{0xc7,0xcf},
    {0xc7,0xd0},{0xc7,0xd1},{0xc7,0xd2},{0xc7,0xd3},{0xc7,0xd4},
    {0xc7,0xd5},{0xc7,0xd6},{0xc7,0xd7},{0xc7,0xd8},{0xc7,0xd9},
    {0xc7,0xda},{0xc7,0xdb},{0xc7,0xdc},{0xc7,0xdd},{0xc7,0xde},
    {0xc7,0xdf},{0xc7,0xe0},{0xc7,0xe1},{0xc7,0xe2},{0xc7,0xe3},
    {0xc7,0xe4},{0xc7,0xe5},{0xc7,0xe6},{0xc7,0xe7},{0xc7,0xe8},
    {0xc7,0xe9},{0xc7,0xea},{0xc7,0xeb},{0xc7,0xec},{0xc7,0xed},
    {0xc7,0xee},{0xc7,0xef},{0xc7,0xf0},{0xc7,0xf1},{0xc7,0xf2},
    {0xc8,0xb4},{0xc8,0xb5},{0xc8,0xb6},{0xc8,0xb7},{0xc8,0xb8},
    {0xc6,0xe3},{0xc6,0xda},{0xc6,0xdb},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0xa3,0x74},
    {0xa3,0x75},{0xa3,0x76},{0xa3,0x77},{0xa3,0x78},{0xa3,0x79},
    {0xa3,0x7a},{0xa3,0x7b},{0xa3,0x7c},{0xa3,0x7d},{0xa3,0x7e},
    {0xa3,0xa1},{0xa3,0xa2},{0xa3,0xa3},{0xa3,0xa4},{0xa3,0xa5},
    {0xa3,0xa6},{0xa3,0xa7},{0xa3,0xa8},{0xa3,0xa9},{0xa3,0xaa},
    {0xa3,0xab},{0xa3,0xac},{0xa3,0xad},{0xa3,0xae},{0xa3,0xaf},
    {0xa3,0xb0},{0xa3,0xb1},{0xa3,0xb2},{0xa3,0xb3},{0xa3,0xb4},
    {0xa3,0xb5},{0xa3,0xb6},{0xa3,0xb7},{0xa3,0xb8},{0xa3,0xb9},
    {0xa3,0xba},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0xa4,0x40},{0xa4,0x47},{0xa4,0x54},{0xa5,0x7c},{0xa4,0x57},
    {0xa4,0xa4},{0xa4,0x55},{0xa5,0xd2},{0xa4,0x41},{0xa4,0xfe},
    {0xa4,0x42},{0xa4,0xd1},{0xa6,0x61},{0xa4,0x48},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0xc8,0x79},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x9c,0x41},{0x9c,0x42},{0x9c,0x43},
    {0x9c,0x44},{0x9c,0x45},{0x9c,0x46},{0x9c,0x47},{0x9c,0x48},
    {0x9c,0x49},{0x9c,0x4a},{0xa4,0xeb},{0xa4,0xf5},{0xa4,0xf4},
    {0xa4,0xec},{0xaa,0xf7},{0xa4,0x67},{0xa4,0xe9},{0x99,0xfd},
    {0x99,0xfc},{0xaa,0xc0},{0xa6,0x57},{0xaf,0x53},{0xb0,0x5d},
    {0xaf,0xac},{0xb3,0xd2},{0xa5,0x4e},{0xa9,0x49},{0xbe,0xc7},
    {0xba,0xca},{0xa5,0xf8},{0xb8,0xea},{0xa8,0xf3},{0xb2,0xbd},
    {0xa5,0xf0},{0xa6,0xdb},{0xa6,0xdc},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0xa4,0x40},{0xa4,0x47},
    {0xa4,0x54},{0xa5,0x7c},{0xa4,0xad},{0xa4,0xbb},{0xa4,0x43},
    {0xa4,0x4b},{0xa4,0x45},{0xa4,0x51},{0xa4,0xeb},{0xa4,0xf5},
    {0xa4,0xf4},{0xa4,0xec},{0xaa,0xf7},{0xa4,0x67},{0xa4,0xe9},
    {0xae,0xe8},{0xa6,0xb3},{0xaa,0xc0},{0xa6,0x57},{0xaf,0x53},
    {0xb0,0x5d},{0xaf,0xac},{0xb3,0xd2},{0xaf,0xb5},{0xa8,0x6b},
    {0xa4,0x6b},{0xbe,0x41},{0xc0,0x75},{0xa6,0x4c},{0xaa,0x60},
    {0xb6,0xb5},{0xa5,0xf0},{0xbc,0x67},{0xa1,0xc0},{0xa4,0x57},
    {0xa4,0xa4},{0xa4,0x55},{0xa5,0xaa},{0xa5,0x6b},{0xc2,0xe5},
    {0xa9,0x76},{0xbe,0xc7},{0xba,0xca},{0xa5,0xf8},{0xb8,0xea},
    {0xa8,0xf3},{0xa9,0x5d},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x48,0x67},
    {0x00,0x00},{0x65,0x56},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x64,0x61},{0x41,0x55},{0x00,0x00},{0x6f,0x56},{0x70,0x63},
    {0x64,0x6d},{0x00,0x00},{0x00,0x00},{0x49,0x55},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x70,0x41},
    {0x6e,0x41},{0x00,0x00},{0x6d,0x41},{0x6b,0x41},{0x4b,0x42},
    {0x4d,0x42},{0x47,0x42},{0x00,0x00},{0x00,0x00},{0x70,0x46},
    {0x6e,0x46},{0x00,0x00},{0x00,0x00},{0xa2,0x55},{0xa2,0x56},
    {0x48,0x7a},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x66,0x6d},
    {0x6e,0x6d},{0x00,0x00},{0xa2,0x50},{0xa2,0x51},{0xa2,0x52},
    {0x00,0x00},{0x00,0x00},{0xa2,0x54},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x9d,0xe7},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x50,0x61},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x70,0x73},{0x6e,0x73},{0x00,0x00},
    {0x6d,0x73},{0x70,0x56},{0x6e,0x56},{0x00,0x00},{0x6d,0x56},
    {0x6b,0x56},{0x4d,0x56},{0x70,0x57},{0x6e,0x57},{0x00,0x00},
    {0x6d,0x57},{0x6b,0x57},{0x4d,0x57},{0x00,0x00},{0x00,0x00},
    {0x9d,0xe3},{0x42,0x71},{0xa2,0x57},{0x63,0x64},{0x00,0x00},
    {0x00,0x00},{0x64,0x42},{0x47,0x79},{0x68,0x61},{0x48,0x50},
    {0x69,0x6e},{0x4b,0x4b},{0xa2,0x53},{0x6b,0x74},{0x6c,0x6d},
    {0xa1,0xeb},{0xa1,0xea},{0x6c,0x78},{0x6d,0x62},{0xa2,0x4f},
    {0x00,0x00},{0x50,0x48},{0x9d,0xe4},{0x00,0x00},{0x50,0x52},
    {0x73,0x72},{0x53,0x76},{0x57,0x62},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x91,0xe0},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0xa0,0xa2},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0xfb,0x44},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x95,0xb8},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0xa0,0x48},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0xa0,0x4c},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0xfb,0xdf},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0xfb,0xe5},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0xfb,0x6f},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x95,0x42},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0xfe,0x7d},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0xfe,0x67},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x95,0x5e},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x95,0xde},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x95,0xc7},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0xfc,0x61},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x95,0xc9},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0xfc,0x7c},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0xfc,0xa8},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0xfe,0x71},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0xfc,0xc2},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0xfe,0x4d},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x96,0xad},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x9c,0xd3},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0xfd,0x5e},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0xfe,0x4a},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0xfd,0x67},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0xfb,0xb0},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0xfb,0x7d},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0xfd,0xe3},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0xfd,0xf1},{0x00,0x00},{0x00,0x00},{0xfd,0xef},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0xfd,0xf2},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0xfb,0x45},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0xa4,0x40},{0xa4,0x42},
    {0x00,0x00},{0xa4,0x43},{0x98,0xa7},{0x00,0x00},{0x91,0xd7},
    {0xc9,0x45},{0xa4,0x56},{0xa4,0x54},{0xa4,0x57},{0xa4,0x55},
    {0xc9,0x46},{0xa4,0xa3},{0xc9,0x4f},{0xc9,0x4d},{0xa4,0xa2},
    {0xa4,0xa1},{0x00,0x00},{0x83,0xfd},{0xa5,0x42},{0xa5,0x41},
    {0xa5,0x40},{0x81,0x40},{0xa5,0x43},{0xa4,0xfe},{0x85,0xd2},
    {0x8a,0xbd},{0x83,0x5b},{0x85,0x46},{0xa5,0xe0},{0xa5,0xe1},
    {0x00,0x00},{0x93,0xe5},{0x81,0x41},{0x00,0x00},{0x83,0x55},
    {0x8b,0xf2},{0xa8,0xc3},{0x84,0xca},{0x9c,0xc9},{0x00,0x00},
    {0x83,0xaa},{0xa4,0x58},{0x81,0x42},{0xa4,0xa4},{0xc9,0x50},
    {0x98,0xa8},{0xa4,0xa5},{0xc9,0x63},{0xa6,0xea},{0xcb,0xb1},
    {0x8a,0x5a},{0x00,0x00},{0xc6,0xbf},{0x91,0xcc},{0xa4,0x59},
    {0xa4,0xa6},{0x83,0x6f},{0xa5,0x44},{0xc9,0x64},{0x8b,0xed},
    {0x8a,0x5b},{0xc6,0xc0},{0x00,0x00},{0x00,0x00},{0xc9,0x40},
    {0xa4,0x44},{0x94,0xf2},{0xa4,0x5b},{0x00,0x00},{0xc9,0x47},
    {0xa4,0x5c},{0x85,0xf3},{0x00,0x00},{0xa4,0xa7},{0x83,0xbf},
    {0xa5,0x45},{0xa5,0x47},{0xa5,0x46},{0x87,0xe4},{0x00,0x00},
    {0xa5,0xe2},{0xa5,0xe3},{0x84,0xce},{0x81,0x43},{0xa8,0xc4},
    {0x92,0xe9},{0xad,0xbc},{0xa4,0x41},{0x9c,0xdf},{0x9c,0xe8},
    {0xc9,0x41},{0xa4,0x45},{0xa4,0x5e},{0xa4,0x5d},{0x84,0x74},
    {0x85,0x70},{0x81,0x44},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x83,0xbc},{0x00,0x00},{0x00,0x00},{0xa5,0xe4},{0xfe,0x41},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x85,0x67},{0x85,0xaf},{0x00,0x00},{0xa8,0xc5},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0xa0,0x61},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0xb0,0xae},
    {0xd4,0x4b},{0x93,0xfa},{0x98,0xa9},{0xb6,0xc3},{0xdc,0xb1},
    {0xdc,0xb2},{0xc6,0xc1},{0xa4,0x46},{0x98,0xaa},{0xa4,0xa9},
    {0x83,0x5c},{0x81,0x45},{0xa8,0xc6},{0xa4,0x47},{0xc9,0x48},
    {0xa4,0x5f},{0x8a,0x5f},{0x00,0x00},{0xa4,0xaa},{0xa4,0xac},
    {0xc9,0x51},{0xa4,0xad},{0xa4,0xab},{0x00,0x00},{0x00,0x00},
    {0xfe,0x62},{0xa5,0xe5},{0x83,0x52},{0xa8,0xc7},{0x92,0x40},
    {0x00,0x00},{0xa8,0xc8},{0xab,0x45},{0xc6,0xc2},{0xa4,0x60},
    {0xa4,0xae},{0x98,0xab},{0xa5,0xe6},{0xa5,0xe8},{0xa5,0xe7},
    {0x84,0x64},{0xa6,0xeb},{0x83,0xc2},{0x00,0x00},{0xa8,0xc9},
    {0xa8,0xca},{0xab,0x46},{0xab,0x47},{0x00,0x00},{0x81,0x46},
    {0x00,0x00},{0x89,0x5d},{0xad,0xbd},{0x00,0x00},{0x8a,0x62},
    {0xdc,0xb3},{0x98,0xac},{0x00,0x00},{0xf6,0xd6},{0xa4,0x48},
    {0x9c,0xf4},{0x98,0xad},{0x00,0x00},{0x00,0x00},{0x87,0xa3},
    {0xa4,0xb0},{0xa4,0xaf},{0xc9,0x52},{0xa4,0xb1},{0xa4,0xb7},
    {0x85,0xb2},{0xa4,0xb2},{0xa4,0xb3},{0xc9,0x54},{0xc9,0x53},
    {0xa4,0xb5},{0xa4,0xb6},{0x00,0x00},{0xa4,0xb4},{0x84,0x47},
    {0x93,0xc2},{0x00,0x00},{0x83,0x54},{0x00,0x00},{0x83,0xac},
    {0xa5,0x4a},{0xa5,0x4b},{0xa5,0x4c},{0xa5,0x4d},{0xa5,0x49},
    {0xa5,0x50},{0xc9,0x6a},{0x00,0x00},{0xc9,0x66},{0xc9,0x69},
    {0xa5,0x51},{0xa5,0x61},{0x00,0x00},{0xc9,0x68},{0x00,0x00},
    {0xa5,0x4e},{0xa5,0x4f},{0xa5,0x48},{0x00,0x00},{0x00,0x00},
    {0xc9,0x65},{0xc9,0x67},{0x87,0xa4},{0x81,0x47},{0x83,0xa8},
    {0x81,0x48},{0x92,0x54},{0x00,0x00},{0xa5,0xf5},{0xc9,0xb0},
    {0xa5,0xf2},{0xa5,0xf6},{0xc9,0xba},{0xc9,0xae},{0xa5,0xf3},
    {0xc9,0xb2},{0x98,0xae},{0x00,0x00},{0x00,0x00},{0xa5,0xf4},
    {0x81,0x49},{0xa5,0xf7},{0x00,0x00},{0xa5,0xe9},{0xc9,0xb1},
    {0xa5,0xf8},{0xc9,0xb5},{0xfb,0xba},{0xc9,0xb9},{0xc9,0xb6},
    {0x00,0x00},{0x00,0x00},{0xc9,0xb3},{0xa5,0xea},{0xa5,0xec},
    {0xa5,0xf9},{0x00,0x00},{0xa5,0xee},{0xc9,0xab},{0xa5,0xf1},
    {0xa5,0xef},{0xa5,0xf0},{0xc9,0xbb},{0xc9,0xb8},{0xc9,0xaf},
    {0xa5,0xed},{0x00,0x00},{0x84,0x67},{0xc9,0xac},{0xa5,0xeb},
    {0x85,0xd1},{0x8d,0xfd},{0x81,0x4a},{0xc9,0xb4},{0x84,0xc4},
    {0x83,0xec},{0x85,0xb1},{0x00,0x00},{0xc9,0xb7},{0x00,0x00},
    {0x85,0xb4},{0x83,0xa9},{0x83,0xab},{0x84,0xc3},{0x98,0xaf},
    {0x98,0xb0},{0x83,0xeb},{0x83,0x43},{0xc9,0xad},{0xca,0x66},
    {0x00,0x00},{0xa7,0x42},{0xa6,0xf4},{0x00,0x00},{0xfb,0xbd},
    {0xca,0x67},{0xa6,0xf1},{0x00,0x00},{0xa7,0x44},{0x98,0xb1},
    {0xa6,0xf9},{0xfb,0xbc},{0xa6,0xf8},{0xca,0x5b},{0xa6,0xfc},
    {0xa6,0xf7},{0xca,0x60},{0xca,0x68},{0x00,0x00},{0xca,0x64},
    {0x98,0xb2},{0xa6,0xfa},{0x00,0x00},{0x98,0xb3},{0xa6,0xfd},
    {0xa6,0xee},{0xa7,0x47},{0xca,0x5d},{0x00,0x00},{0x98,0xb4},
    {0xcb,0xbd},{0xa6,0xec},{0xa7,0x43},{0xa6,0xed},{0xa6,0xf5},
    {0xa6,0xf6},{0xca,0x62},{0xca,0x5e},{0xa6,0xfb},{0xa6,0xf3},
    {0xca,0x5a},{0xa6,0xef},{0xca,0x65},{0xa7,0x45},{0xa7,0x48},
    {0xa6,0xf2},{0xa7,0x40},{0xa7,0x46},{0xa6,0xf0},{0xca,0x63},
    {0xa7,0x41},{0xca,0x69},{0xca,0x5c},{0xa6,0xfe},{0xca,0x5f},
    {0x8e,0x40},{0x00,0x00},{0xca,0x61},{0x00,0x00},{0xa8,0xd8},
    {0xcb,0xbf},{0xcb,0xcb},{0xa8,0xd0},{0x00,0x00},{0xcb,0xcc},
    {0xa8,0xcb},{0xa8,0xd5},{0x00,0x00},{0x98,0xb5},{0xa8,0xce},
    {0xcb,0xb9},{0xa8,0xd6},{0xcb,0xb8},{0xcb,0xbc},{0xcb,0xc3},
    {0xcb,0xc1},{0xa8,0xde},{0xa8,0xd9},{0xcb,0xb3},{0xcb,0xb5},
    {0xa8,0xdb},{0xa8,0xcf},{0xcb,0xb6},{0xcb,0xc2},{0xcb,0xc9},
    {0xa8,0xd4},{0xcb,0xbb},{0xcb,0xb4},{0xa8,0xd3},{0xcb,0xb7},
    {0xa8,0xd7},{0xcb,0xba},{0x81,0x4b},{0xa8,0xd2},{0x00,0x00},
    {0xa8,0xcd},{0x00,0x00},{0xa8,0xdc},{0xcb,0xc4},{0xa8,0xdd},
    {0xcb,0xc8},{0x00,0x00},{0xcb,0xc6},{0xcb,0xca},{0xa8,0xda},
    {0xcb,0xbe},{0xcb,0xb2},{0x00,0x00},{0xcb,0xc0},{0xa8,0xd1},
    {0xcb,0xc5},{0xa8,0xcc},{0xcb,0xc7},{0x00,0x00},{0x83,0x65},
    {0x92,0x55},{0x98,0xb6},{0x83,0x66},{0x00,0x00},{0x86,0xab},
    {0x83,0xed},{0x83,0xee},{0x86,0xac},{0x87,0xa7},{0x88,0xca},
    {0xfb,0xbe},{0x87,0xa6},{0x82,0x7d},{0xab,0x56},{0xab,0x4a},
    {0x98,0xb7},{0x00,0x00},{0xcd,0xe0},{0xcd,0xe8},{0x98,0xf7},
    {0xab,0x49},{0xab,0x51},{0xab,0x5d},{0x00,0x00},{0xcd,0xee},
    {0xcd,0xec},{0xcd,0xe7},{0x00,0x00},{0x98,0xb8},{0x00,0x00},
    {0xab,0x4b},{0xcd,0xed},{0xcd,0xe3},{0xab,0x59},{0xab,0x50},
    {0xab,0x58},{0xcd,0xde},{0x00,0x00},{0xcd,0xea},{0x98,0xb9},
    {0xcd,0xe1},{0xab,0x54},{0xcd,0xe2},{0x98,0xba},{0xcd,0xdd},
    {0xab,0x5b},{0xab,0x4e},{0xab,0x57},{0xab,0x4d},{0x00,0x00},
    {0xcd,0xdf},{0xcd,0xe4},{0x00,0x00},{0xcd,0xeb},{0xab,0x55},
    {0xab,0x52},{0xcd,0xe6},{0xab,0x5a},{0xcd,0xe9},{0xcd,0xe5},
    {0xab,0x4f},{0xab,0x5c},{0xab,0x53},{0xab,0x4c},{0xab,0x48},
    {0x00,0x00},{0x8d,0xb9},{0x94,0x5f},{0x94,0x60},{0x88,0xc8},
    {0x00,0x00},{0x8c,0xc8},{0x83,0xa7},{0x8c,0x6c},{0x00,0x00},
    {0xcd,0xef},{0x87,0xa8},{0xad,0xd7},{0xad,0xc1},{0x98,0xbb},
    {0xad,0xd1},{0x98,0xbc},{0xad,0xd6},{0xd0,0xd0},{0xd0,0xcf},
    {0xd0,0xd4},{0xd0,0xd5},{0xad,0xc4},{0x98,0xbd},{0xad,0xcd},
    {0x00,0x00},{0x00,0x00},{0xfe,0x7b},{0xad,0xda},{0x81,0x4c},
    {0xad,0xce},{0x00,0x00},{0x00,0x00},{0x98,0xbe},{0x00,0x00},
    {0xd0,0xc9},{0xad,0xc7},{0xd0,0xca},{0x98,0xbf},{0xad,0xdc},
    {0x00,0x00},{0xad,0xd3},{0xad,0xbe},{0xad,0xbf},{0xd0,0xdd},
    {0xb0,0xbf},{0x00,0x00},{0xad,0xcc},{0xad,0xcb},{0xd0,0xcb},
    {0xad,0xcf},{0xd4,0x5b},{0xad,0xc6},{0xd0,0xd6},{0xad,0xd5},
    {0xad,0xd4},{0xad,0xca},{0xd0,0xce},{0xd0,0xd7},{0x00,0x00},
    {0xd0,0xc8},{0xad,0xc9},{0xd0,0xd8},{0xad,0xd2},{0xd0,0xcc},
    {0xad,0xc0},{0x82,0xa9},{0xad,0xc3},{0xad,0xc2},{0xd0,0xd9},
    {0xad,0xd0},{0xad,0xc5},{0xad,0xd9},{0xad,0xdb},{0xd0,0xd3},
    {0xad,0xd8},{0xfb,0xc1},{0xd0,0xdb},{0xd0,0xcd},{0xd0,0xdc},
    {0x00,0x00},{0xd0,0xd1},{0x98,0xc0},{0xd0,0xda},{0x82,0xa3},
    {0xd0,0xd2},{0x00,0x00},{0x92,0xb2},{0x85,0xb0},{0x98,0xc1},
    {0xad,0xc8},{0x00,0x00},{0x85,0xb3},{0x00,0x00},{0xd4,0x63},
    {0xd4,0x57},{0x81,0x4d},{0xb0,0xb3},{0x00,0x00},{0xd4,0x5c},
    {0xd4,0x62},{0xb0,0xb2},{0xd4,0x55},{0xb0,0xb6},{0xd4,0x59},
    {0xd4,0x52},{0xb0,0xb4},{0xd4,0x56},{0xb0,0xb9},{0xb0,0xbe},
    {0x81,0x4e},{0xd4,0x67},{0x00,0x00},{0xd4,0x51},{0x00,0x00},
    {0xb0,0xba},{0xfb,0xbf},{0xd4,0x66},{0x98,0xc2},{0x00,0x00},
    {0xb0,0xb5},{0xd4,0x58},{0xb0,0xb1},{0xd4,0x53},{0xd4,0x4f},
    {0xd4,0x5d},{0xd4,0x50},{0xd4,0x4e},{0xd4,0x5a},{0xd4,0x60},
    {0xd4,0x61},{0xb0,0xb7},{0x98,0xc3},{0x00,0x00},{0xd8,0x5b},
    {0xd4,0x5e},{0xd4,0x4d},{0xd4,0x5f},{0x85,0xb5},{0xb0,0xc1},
    {0xd4,0x64},{0xb0,0xc0},{0xd4,0x4c},{0x00,0x00},{0xd4,0x54},
    {0xd4,0x65},{0xb0,0xbc},{0xb0,0xbb},{0xb0,0xb8},{0xb0,0xbd},
    {0x81,0x4f},{0x00,0x00},{0xb0,0xaf},{0x8d,0xfe},{0x00,0x00},
    {0xb0,0xb0},{0x8e,0x65},{0x89,0xc8},{0xb3,0xc8},{0x98,0xc4},
    {0xd8,0x5e},{0xd8,0x57},{0x00,0x00},{0xb3,0xc5},{0x00,0x00},
    {0xd8,0x5f},{0x90,0xf0},{0x00,0x00},{0x00,0x00},{0xd8,0x55},
    {0xd8,0x58},{0xb3,0xc4},{0xd8,0x59},{0x00,0x00},{0x98,0xc5},
    {0xb3,0xc7},{0xd8,0x5d},{0x00,0x00},{0xd8,0x53},{0xd8,0x52},
    {0xb3,0xc9},{0x00,0x00},{0xb3,0xca},{0xb3,0xc6},{0xb3,0xcb},
    {0xd8,0x51},{0xd8,0x5c},{0xd8,0x5a},{0xd8,0x54},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0xb3,0xc3},{0xd8,0x56},{0x00,0x00},
    {0x8c,0xc9},{0xfb,0xc2},{0x88,0xc9},{0x89,0xc9},{0x8f,0xfb},
    {0x00,0x00},{0x00,0x00},{0xb6,0xca},{0xb6,0xc4},{0xdc,0xb7},
    {0xb6,0xcd},{0xdc,0xbd},{0xdc,0xc0},{0xb6,0xc6},{0xb6,0xc7},
    {0xdc,0xba},{0xb6,0xc5},{0xdc,0xc3},{0xb6,0xcb},{0xdc,0xc4},
    {0x00,0x00},{0xdc,0xbf},{0xb6,0xcc},{0x98,0xc6},{0xdc,0xb4},
    {0xb6,0xc9},{0xdc,0xb5},{0x00,0x00},{0xdc,0xbe},{0xdc,0xbc},
    {0x00,0x00},{0xdc,0xb8},{0xb6,0xc8},{0xdc,0xb6},{0xb6,0xce},
    {0xdc,0xbb},{0xdc,0xc2},{0xdc,0xb9},{0xdc,0xc1},{0x00,0x00},
    {0x94,0x4f},{0xb9,0xb6},{0xb9,0xb3},{0x98,0xc7},{0xb9,0xb4},
    {0x00,0x00},{0xe0,0xf9},{0xe0,0xf1},{0xb9,0xb2},{0xb9,0xaf},
    {0xe0,0xf2},{0x81,0x50},{0xfb,0xc3},{0xb9,0xb1},{0xe0,0xf5},
    {0x00,0x00},{0xe0,0xf7},{0x81,0x51},{0x98,0xc8},{0xe0,0xfe},
    {0x98,0xc9},{0x00,0x00},{0xe0,0xfd},{0xe0,0xf8},{0xb9,0xae},
    {0xe0,0xf0},{0xb9,0xac},{0xe0,0xf3},{0xb9,0xb7},{0xe0,0xf6},
    {0x00,0x00},{0xe0,0xfa},{0xb9,0xb0},{0xb9,0xad},{0xe0,0xfc},
    {0xe0,0xfb},{0xb9,0xb5},{0x00,0x00},{0xe0,0xf4},{0x81,0x52},
    {0xbb,0xf8},{0xe4,0xec},{0x00,0x00},{0xe4,0xe9},{0xbb,0xf9},
    {0x00,0x00},{0xbb,0xf7},{0x98,0xca},{0xe4,0xf0},{0xe4,0xed},
    {0xe4,0xe6},{0xbb,0xf6},{0xfb,0xc6},{0xbb,0xfa},{0xe4,0xe7},
    {0xbb,0xf5},{0xbb,0xfd},{0xe4,0xea},{0xe4,0xeb},{0xbb,0xfb},
    {0xbb,0xfc},{0xe4,0xf1},{0xe4,0xee},{0xe4,0xef},{0x98,0xcb},
    {0xfb,0xc4},{0x00,0x00},{0xbe,0xaa},{0xe8,0xf8},{0xbe,0xa7},
    {0xe8,0xf5},{0xbe,0xa9},{0xbe,0xab},{0x81,0x53},{0xe8,0xf6},
    {0xbe,0xa8},{0x00,0x00},{0xe8,0xf7},{0x00,0x00},{0xe8,0xf4},
    {0x00,0x00},{0x00,0x00},{0xc0,0x76},{0xec,0xbd},{0xc0,0x77},
    {0xec,0xbb},{0x00,0x00},{0xec,0xbc},{0xec,0xba},{0xec,0xb9},
    {0x00,0x00},{0x00,0x00},{0xec,0xbe},{0xc0,0x75},{0x98,0xcc},
    {0x00,0x00},{0xef,0xb8},{0xef,0xb9},{0x00,0x00},{0xe4,0xe8},
    {0xef,0xb7},{0xc0,0x78},{0xc3,0x5f},{0xf1,0xeb},{0xf1,0xec},
    {0x00,0x00},{0xc4,0xd7},{0xc4,0xd8},{0xf5,0xc1},{0xf5,0xc0},
    {0xc5,0x6c},{0xc5,0x6b},{0xf7,0xd0},{0x00,0x00},{0xa4,0x49},
    {0xa4,0x61},{0xa4,0xb9},{0x00,0x00},{0xa4,0xb8},{0xa5,0x53},
    {0xa5,0x52},{0xa5,0xfc},{0xa5,0xfb},{0xa5,0xfd},{0xa5,0xfa},
    {0x81,0x54},{0xa7,0x4a},{0xa7,0x49},{0xa7,0x4b},{0x95,0xfc},
    {0x00,0x00},{0x92,0xd1},{0x81,0x55},{0xa8,0xe0},{0x00,0x00},
    {0xa8,0xdf},{0xa8,0xe1},{0x83,0x67},{0xab,0x5e},{0x00,0x00},
    {0xa2,0x59},{0xd0,0xde},{0xa2,0x5a},{0xb0,0xc2},{0xa2,0x5c},
    {0xa2,0x5b},{0xd8,0x60},{0x98,0xcd},{0xa2,0x5d},{0xb9,0xb8},
    {0xa2,0x5e},{0x81,0x56},{0xa4,0x4a},{0x00,0x00},{0xa4,0xba},
    {0xa5,0xfe},{0xa8,0xe2},{0x81,0x57},{0xa4,0x4b},{0xa4,0xbd},
    {0xa4,0xbb},{0xa4,0xbc},{0x00,0x00},{0x8c,0xa3},{0xa6,0x40},
    {0x00,0x00},{0x8b,0xd7},{0x89,0x55},{0xa7,0x4c},{0xa8,0xe4},
    {0xa8,0xe3},{0xa8,0xe5},{0x90,0xbc},{0x00,0x00},{0x88,0xb5},
    {0xad,0xdd},{0x8b,0xa6},{0x00,0x00},{0x00,0x00},{0xbe,0xac},
    {0x90,0x54},{0xc6,0xc3},{0x00,0x00},{0x00,0x00},{0x81,0x58},
    {0x92,0x4c},{0xc9,0x4e},{0x83,0x58},{0xa5,0x54},{0xa5,0x55},
    {0x00,0x00},{0x95,0xe4},{0xa6,0x41},{0x00,0x00},{0xca,0x6a},
    {0x81,0x59},{0xab,0x60},{0xab,0x5f},{0xd0,0xe0},{0xd0,0xdf},
    {0xb0,0xc3},{0xc6,0xc4},{0xa4,0xbe},{0xc9,0x55},{0x87,0xc0},
    {0xfb,0x41},{0x83,0x7e},{0x86,0x61},{0x81,0x5a},{0xcb,0xcd},
    {0x00,0x00},{0xab,0x61},{0x00,0x00},{0xad,0xe0},{0x00,0x00},
    {0xad,0xde},{0xad,0xdf},{0x81,0x5b},{0xfb,0x4e},{0x81,0x5c},
    {0x81,0x5d},{0xbe,0xad},{0xc6,0xc5},{0xa5,0x56},{0x00,0x00},
    {0x98,0xce},{0x85,0xad},{0xa6,0x42},{0xc9,0xbc},{0x83,0x4c},
    {0x83,0x4b},{0x94,0xfb},{0x95,0xd5},{0xa7,0x4d},{0xa7,0x4e},
    {0x98,0xcf},{0xca,0x6b},{0x00,0x00},{0x83,0xad},{0xcb,0xce},
    {0xa8,0xe6},{0xcb,0xcf},{0x00,0x00},{0x84,0x60},{0x00,0x00},
    {0x00,0x00},{0x95,0xf3},{0xd0,0xe2},{0xd0,0xe3},{0xad,0xe3},
    {0x81,0x5e},{0xd0,0xe4},{0x84,0x5b},{0xd0,0xe1},{0xad,0xe4},
    {0xad,0xe2},{0xad,0xe1},{0xd0,0xe5},{0x90,0xb6},{0xd4,0x68},
    {0x84,0xee},{0x98,0xd0},{0xfb,0xcf},{0xd8,0x61},{0x00,0x00},
    {0x81,0x5f},{0xdc,0xc5},{0xe1,0x40},{0x00,0x00},{0x00,0x00},
    {0x81,0x60},{0xbb,0xfe},{0xbe,0xae},{0xe8,0xf9},{0xfb,0xd0},
    {0xa4,0x4c},{0xa4,0x5a},{0x98,0xd1},{0x00,0x00},{0x87,0xa1},
    {0x00,0x00},{0x92,0xe1},{0x94,0x4c},{0x00,0x00},{0x94,0x61},
    {0x94,0x52},{0x8e,0x63},{0x81,0x61},{0x88,0xd7},{0x00,0x00},
    {0x84,0xc5},{0xb0,0xc4},{0xb3,0xcd},{0x00,0x00},{0xb9,0xb9},
    {0xfb,0xc7},{0xc9,0x42},{0xa4,0xbf},{0x00,0x00},{0xa5,0x59},
    {0xa5,0x57},{0xa5,0x58},{0x89,0xdb},{0x81,0x62},{0xa8,0xe7},
    {0xfb,0xd2},{0x8d,0xad},{0xa4,0x4d},{0xa4,0x4e},{0xc8,0x7d},
    {0xa4,0x62},{0x95,0xcf},{0x98,0xd2},{0xa4,0xc0},{0xa4,0xc1},
    {0xa4,0xc2},{0xc9,0xbe},{0xa5,0x5a},{0x81,0x63},{0xc9,0x6b},
    {0x83,0xd2},{0xa6,0x46},{0x00,0x00},{0xc9,0xbf},{0xa6,0x44},
    {0xa6,0x45},{0xc9,0xbd},{0x81,0x64},{0x81,0x65},{0xa6,0x47},
    {0xa6,0x43},{0x87,0xaa},{0x83,0x68},{0x83,0xae},{0x84,0xc7},
    {0xca,0x6c},{0xaa,0xec},{0xca,0x6d},{0xfb,0xc8},{0x81,0x66},
    {0xca,0x6e},{0x00,0x00},{0xa0,0x7e},{0xa7,0x50},{0xa7,0x4f},
    {0x95,0x7b},{0x95,0xe5},{0xa7,0x53},{0xa7,0x51},{0xa7,0x52},
    {0x81,0x67},{0x00,0x00},{0x8d,0xba},{0xa8,0xed},{0x00,0x00},
    {0xa8,0xec},{0xcb,0xd4},{0xcb,0xd1},{0xcb,0xd2},{0x98,0xd3},
    {0xcb,0xd0},{0xa8,0xee},{0xa8,0xea},{0xa8,0xe9},{0x81,0x68},
    {0xa8,0xeb},{0xa8,0xe8},{0x98,0xd4},{0x87,0xac},{0x00,0x00},
    {0x8e,0xaf},{0x84,0xc6},{0xa8,0xef},{0x88,0xcc},{0xab,0x63},
    {0xcd,0xf0},{0x00,0x00},{0xcb,0xd3},{0xab,0x68},{0x00,0x00},
    {0xcd,0xf1},{0xab,0x64},{0xab,0x67},{0xab,0x66},{0xab,0x65},
    {0xab,0x62},{0x81,0x69},{0x8d,0xc8},{0x87,0xab},{0xd0,0xe8},
    {0x00,0x00},{0xad,0xe7},{0xd0,0xeb},{0xad,0xe5},{0xfb,0xca},
    {0x00,0x00},{0x98,0xd5},{0xd0,0xe7},{0xad,0xe8},{0xad,0xe6},
    {0xad,0xe9},{0xd0,0xe9},{0xd0,0xea},{0xfb,0xc9},{0xd0,0xe6},
    {0xd0,0xec},{0x92,0xb3},{0x92,0xc9},{0x82,0x76},{0x00,0x00},
    {0x87,0xa9},{0x98,0xd6},{0xb3,0xd1},{0xb0,0xc5},{0xd4,0x69},
    {0xd4,0x6b},{0xd4,0x6a},{0xd4,0x6c},{0xb0,0xc6},{0x92,0xeb},
    {0x81,0x6a},{0xb3,0xce},{0xfc,0xf5},{0xb3,0xcf},{0xb3,0xd0},
    {0x00,0x00},{0xb6,0xd0},{0xdc,0xc7},{0x98,0xd7},{0xdc,0xc6},
    {0xdc,0xc8},{0xdc,0xc9},{0xb6,0xd1},{0x00,0x00},{0xb6,0xcf},
    {0xe1,0x41},{0xe1,0x42},{0xb9,0xbb},{0xb9,0xba},{0xe3,0x5a},
    {0x00,0x00},{0x00,0x00},{0xbc,0x40},{0xbc,0x41},{0xbc,0x42},
    {0xbc,0x44},{0xe4,0xf2},{0xe4,0xf3},{0xbc,0x43},{0x00,0x00},
    {0xfb,0x69},{0x81,0x6b},{0xbe,0xaf},{0x81,0x6c},{0xbe,0xb0},
    {0x81,0x6d},{0x00,0x00},{0xf1,0xed},{0xf5,0xc3},{0xf5,0xc2},
    {0xf7,0xd1},{0xfb,0xcb},{0xa4,0x4f},{0x81,0x6e},{0x8b,0xef},
    {0x89,0x74},{0xa5,0x5c},{0xa5,0x5b},{0x83,0xef},{0x8e,0xb0},
    {0xa6,0x48},{0x98,0xd8},{0x00,0x00},{0xc9,0xc0},{0x00,0x00},
    {0x83,0xf0},{0xa7,0x55},{0xa7,0x56},{0xa7,0x54},{0xa7,0x57},
    {0xca,0x6f},{0xca,0x70},{0x81,0x6f},{0x00,0x00},{0x89,0xca},
    {0x83,0x69},{0x84,0xc8},{0x93,0xf5},{0x81,0x70},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x95,0xa2},{0x00,0x00},{0xa8,0xf1},
    {0xcb,0xd5},{0x00,0x00},{0xa8,0xf0},{0x85,0xb7},{0xcd,0xf2},
    {0xab,0x6c},{0xcd,0xf3},{0xab,0x6b},{0x00,0x00},{0x95,0x44},
    {0x00,0x00},{0xab,0x69},{0x00,0x00},{0xab,0x6a},{0x00,0x00},
    {0x84,0xc9},{0x98,0xd9},{0xd0,0xed},{0x00,0x00},{0x00,0x00},
    {0x81,0x71},{0xfb,0xcc},{0xb0,0xc7},{0xd4,0x6e},{0x00,0x00},
    {0xb0,0xca},{0xd4,0x6d},{0xb1,0xe5},{0xb0,0xc9},{0xb0,0xc8},
    {0x00,0x00},{0xb3,0xd4},{0x00,0x00},{0xb3,0xd3},{0xb3,0xd2},
    {0xb6,0xd2},{0xfb,0xcd},{0xfb,0xce},{0xb6,0xd5},{0xb6,0xd6},
    {0xb6,0xd4},{0x00,0x00},{0xb6,0xd3},{0x92,0x68},{0x00,0x00},
    {0xe1,0x43},{0x00,0x00},{0xe1,0x44},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0xe4,0xf5},{0xbc,0x45},{0xe4,0xf4},{0x92,0xa4},
    {0xbe,0xb1},{0xec,0xbf},{0xc0,0x79},{0x00,0x00},{0xf1,0xee},
    {0xc4,0x55},{0xc6,0xc6},{0xa4,0x63},{0xa4,0xc3},{0xc9,0x56},
    {0x00,0x00},{0xa4,0xc4},{0xa4,0xc5},{0x81,0x72},{0x94,0x5e},
    {0x94,0x53},{0x9c,0xd0},{0x00,0x00},{0xa5,0x5d},{0xa5,0x5e},
    {0x81,0x73},{0xa6,0x49},{0xca,0x71},{0xcb,0xd6},{0xcb,0xd7},
    {0x00,0x00},{0xab,0x6d},{0xd0,0xee},{0xb0,0xcc},{0xb0,0xcb},
    {0xd8,0x63},{0xd8,0x62},{0x00,0x00},{0x00,0x00},{0xa4,0x50},
    {0xa4,0xc6},{0xa5,0x5f},{0x00,0x00},{0xb0,0xcd},{0xc9,0x43},
    {0x00,0x00},{0xc9,0x6c},{0xa5,0x60},{0x00,0x00},{0xc9,0xc2},
    {0xa6,0x4b},{0xa6,0x4a},{0xc9,0xc1},{0xa7,0x58},{0x81,0x74},
    {0x00,0x00},{0x8d,0xc9},{0x98,0xda},{0x00,0x00},{0x00,0x00},
    {0xad,0xea},{0x00,0x00},{0xfb,0xd4},{0xd4,0x6f},{0x86,0xad},
    {0xb6,0xd7},{0xe1,0x45},{0xb9,0xbc},{0xfb,0xd3},{0xfb,0xd5},
    {0xe8,0xfa},{0x00,0x00},{0x00,0x00},{0xf3,0xfd},{0xc6,0xc7},
    {0xa4,0xc7},{0x83,0xf1},{0x8b,0x4b},{0xcb,0xd8},{0xcd,0xf4},
    {0xb0,0xd0},{0xb0,0xce},{0xb0,0xcf},{0xa4,0x51},{0x98,0xdb},
    {0xa4,0x64},{0xa2,0xcd},{0xa4,0xca},{0x81,0x75},{0xa4,0xc9},
    {0xa4,0xc8},{0xa5,0x63},{0xa5,0x62},{0x00,0x00},{0xc9,0x6d},
    {0xc9,0xc3},{0x85,0x4f},{0x83,0x56},{0x00,0x00},{0xa8,0xf5},
    {0xa8,0xf2},{0xa8,0xf4},{0xa8,0xf3},{0x84,0xcb},{0x88,0x6f},
    {0xab,0x6e},{0x93,0x6d},{0x00,0x00},{0xb3,0xd5},{0x00,0x00},
    {0xa4,0x52},{0x98,0xdc},{0xa4,0xcb},{0x81,0x76},{0xa5,0x65},
    {0xa5,0x64},{0x89,0x41},{0xca,0x72},{0x84,0xc0},{0x00,0x00},
    {0xa8,0xf6},{0x83,0x60},{0x00,0x00},{0xc6,0xc8},{0x00,0x00},
    {0x88,0x55},{0xc9,0x57},{0x95,0xf2},{0xa5,0x67},{0xa5,0x66},
    {0xa6,0x4c},{0xa6,0x4d},{0xca,0x73},{0xa7,0x59},{0x83,0x6a},
    {0xa7,0x5a},{0x00,0x00},{0xa8,0xf7},{0xa8,0xf8},{0xa8,0xf9},
    {0x8d,0xbd},{0xab,0x6f},{0xcd,0xf5},{0x98,0xdd},{0x98,0xde},
    {0xad,0xeb},{0x00,0x00},{0x00,0x00},{0xc9,0x44},{0x00,0x00},
    {0xa4,0xcc},{0x8d,0x6d},{0x88,0xe5},{0x00,0x00},{0x00,0x00},
    {0x87,0xad},{0xc9,0xc4},{0x89,0xcd},{0x86,0xae},{0x8d,0xbb},
    {0xca,0x74},{0xca,0x75},{0x00,0x00},{0x00,0x00},{0xcb,0xd9},
    {0x81,0x77},{0xcb,0xda},{0x84,0xda},{0xcd,0xf7},{0xcd,0xf6},
    {0xcd,0xf9},{0xcd,0xf8},{0xab,0x70},{0x00,0x00},{0xd4,0x70},
    {0xad,0xed},{0xd0,0xef},{0xad,0xec},{0x95,0xe8},{0x00,0x00},
    {0x95,0xe9},{0x8f,0xb6},{0xd8,0x64},{0xb3,0xd6},{0x95,0x7a},
    {0xd8,0x65},{0x87,0xc5},{0x84,0xdb},{0xfb,0xd7},{0xfb,0xd6},
    {0xe1,0x46},{0xb9,0xbd},{0x87,0xc7},{0x00,0x00},{0x81,0x78},
    {0x00,0x00},{0xbc,0x46},{0x92,0xba},{0xf1,0xef},{0x00,0x00},
    {0xc6,0xc9},{0x00,0x00},{0x00,0x00},{0xc9,0x58},{0x00,0x00},
    {0xa5,0x68},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x89,0x4f},
    {0x00,0x00},{0x95,0x48},{0x83,0xf2},{0xb0,0xd1},{0x00,0x00},
    {0x98,0xdf},{0x00,0x00},{0x00,0x00},{0xa4,0x53},{0xa4,0x65},
    {0xa4,0xce},{0xa4,0xcd},{0x8b,0x5a},{0xa4,0xcf},{0x83,0x42},
    {0x00,0x00},{0x98,0xe0},{0x84,0xfa},{0x98,0xe1},{0x00,0x00},
    {0xa8,0xfb},{0x00,0x00},{0xa8,0xfa},{0xa8,0xfc},{0x8d,0x40},
    {0x95,0xb3},{0xfb,0xdb},{0xab,0x71},{0x00,0x00},{0x81,0x79},
    {0x00,0x00},{0xad,0xee},{0x8c,0xd4},{0xe8,0xfb},{0xc2,0x4f},
    {0xa4,0x66},{0xa5,0x6a},{0xa5,0x79},{0xa5,0x74},{0x00,0x00},
    {0xa5,0x6f},{0xa5,0x6e},{0xa5,0x75},{0xa5,0x73},{0xa5,0x6c},
    {0xa5,0x7a},{0xa5,0x6d},{0xa5,0x69},{0xa5,0x78},{0xa5,0x77},
    {0xa5,0x76},{0xa5,0x6b},{0x00,0x00},{0xa5,0x72},{0x85,0xfc},
    {0x86,0x41},{0xa5,0x71},{0x86,0xb1},{0x94,0x62},{0xa5,0x7b},
    {0xa5,0x70},{0x87,0xb4},{0x98,0xe2},{0x00,0x00},{0x00,0x00},
    {0xa6,0x53},{0x00,0x00},{0xa6,0x59},{0xa6,0x55},{0x00,0x00},
    {0xa6,0x5b},{0xc9,0xc5},{0xa6,0x58},{0xa6,0x4e},{0xa6,0x51},
    {0xa6,0x54},{0xa6,0x50},{0xa6,0x57},{0xa6,0x5a},{0xa6,0x4f},
    {0xa6,0x52},{0xa6,0x56},{0xa6,0x5c},{0x89,0xcc},{0xfb,0x43},
    {0x90,0xb8},{0xfb,0x42},{0x85,0xba},{0xca,0x7e},{0xca,0x7b},
    {0xa0,0x55},{0xa7,0x67},{0xca,0x7c},{0xa7,0x5b},{0xa7,0x5d},
    {0xa7,0x75},{0xa7,0x70},{0x96,0xb2},{0x00,0x00},{0x81,0x7a},
    {0xca,0xa5},{0xca,0x7d},{0xa7,0x5f},{0xa7,0x61},{0xca,0xa4},
    {0xa7,0x68},{0xca,0x78},{0xa7,0x74},{0xa7,0x76},{0xa7,0x5c},
    {0xa7,0x6d},{0x84,0x51},{0xca,0x76},{0xa7,0x73},{0x96,0xb4},
    {0xa7,0x64},{0x83,0x45},{0xa7,0x6e},{0xa7,0x6f},{0xca,0x77},
    {0xa7,0x6c},{0xa7,0x6a},{0x00,0x00},{0xa7,0x6b},{0xa7,0x71},
    {0xca,0xa1},{0xa7,0x5e},{0x00,0x00},{0xa7,0x72},{0xca,0xa3},
    {0xa7,0x66},{0xa7,0x63},{0x00,0x00},{0xca,0x7a},{0xa7,0x62},
    {0xca,0xa6},{0xa7,0x65},{0x92,0xbb},{0xa7,0x69},{0x96,0xa4},
    {0x00,0x00},{0xa0,0x5a},{0xa7,0x60},{0xca,0xa2},{0x81,0x7b},
    {0x81,0x7c},{0x8e,0xb2},{0x8c,0xca},{0xca,0x79},{0x86,0xb0},
    {0x8f,0xb7},{0x8d,0xc2},{0x83,0xb0},{0x8d,0xbc},{0x00,0x00},
    {0x85,0xbc},{0x85,0xbb},{0x00,0x00},{0x00,0x00},{0x82,0xaf},
    {0xcb,0xeb},{0xcb,0xea},{0xa9,0x4f},{0xcb,0xed},{0xcb,0xef},
    {0xcb,0xe4},{0xcb,0xe7},{0xcb,0xee},{0xa9,0x50},{0xfb,0xd9},
    {0x94,0xfc},{0xcb,0xe1},{0xcb,0xe5},{0x98,0xe3},{0x00,0x00},
    {0xcb,0xe9},{0xce,0x49},{0xa9,0x4b},{0xce,0x4d},{0xa8,0xfd},
    {0xcb,0xe6},{0xa8,0xfe},{0xa9,0x4c},{0xa9,0x45},{0xa9,0x41},
    {0x00,0x00},{0xcb,0xe2},{0xa9,0x44},{0xa9,0x49},{0xa9,0x52},
    {0xcb,0xe3},{0xcb,0xdc},{0xa9,0x43},{0xcb,0xdd},{0xcb,0xdf},
    {0x00,0x00},{0xa9,0x46},{0x98,0xe4},{0xa9,0x48},{0xcb,0xdb},
    {0xcb,0xe0},{0x00,0x00},{0x81,0x7d},{0xa9,0x51},{0xa9,0x4d},
    {0xcb,0xe8},{0xa9,0x53},{0x95,0xa3},{0xa9,0x4a},{0xcb,0xde},
    {0xa9,0x47},{0x98,0xe5},{0x96,0xb6},{0xa9,0x42},{0xa9,0x40},
    {0xa0,0x57},{0xcb,0xec},{0x8b,0xf0},{0xa9,0x4e},{0x89,0xcb},
    {0xfb,0xda},{0x81,0x7e},{0x98,0xe6},{0x00,0x00},{0xce,0x48},
    {0xcd,0xfb},{0xce,0x4b},{0x81,0xa1},{0x95,0x79},{0xcd,0xfd},
    {0xab,0x78},{0xab,0xa8},{0xab,0x74},{0xab,0xa7},{0xab,0x7d},
    {0xab,0xa4},{0xab,0x72},{0xcd,0xfc},{0xce,0x43},{0xab,0xa3},
    {0xce,0x4f},{0xab,0xa5},{0x94,0x46},{0xab,0x79},{0x81,0xa2},
    {0x00,0x00},{0xce,0x45},{0xce,0x42},{0xab,0x77},{0x98,0xe7},
    {0xcd,0xfa},{0xab,0xa6},{0xce,0x4a},{0xab,0x7c},{0xce,0x4c},
    {0xab,0xa9},{0xab,0x73},{0xab,0x7e},{0xab,0x7b},{0xce,0x40},
    {0xab,0xa1},{0xce,0x46},{0xce,0x47},{0xab,0x7a},{0xab,0xa2},
    {0xab,0x76},{0x00,0x00},{0xfb,0x4a},{0x96,0xcf},{0x8c,0xb7},
    {0xab,0x75},{0xcd,0xfe},{0x81,0xa3},{0x83,0xf3},{0x8e,0xe2},
    {0x8e,0xb1},{0x86,0xb4},{0x8e,0xe3},{0xce,0x44},{0x87,0xb0},
    {0x94,0x63},{0x8e,0xe4},{0x96,0xb3},{0x00,0x00},{0x8f,0x4f},
    {0x88,0xce},{0xce,0x4e},{0x84,0xcc},{0xd1,0x44},{0xad,0xfb},
    {0xd0,0xf1},{0x98,0xe8},{0xd0,0xf6},{0xad,0xf4},{0xae,0x40},
    {0xd0,0xf4},{0xad,0xef},{0xad,0xf9},{0xad,0xfe},{0xd0,0xfb},
    {0x00,0x00},{0xad,0xfa},{0xad,0xfd},{0x98,0xe9},{0x00,0x00},
    {0xd0,0xfe},{0xad,0xf5},{0xd0,0xf5},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0xd1,0x42},{0xd1,0x43},{0x00,0x00},{0xad,0xf7},
    {0xd1,0x41},{0xad,0xf3},{0xae,0x43},{0x00,0x00},{0xd0,0xf8},
    {0x00,0x00},{0xad,0xf1},{0xfb,0x5a},{0xd1,0x46},{0xd0,0xf9},
    {0xd0,0xfd},{0xad,0xf6},{0xae,0x42},{0xd0,0xfa},{0xad,0xfc},
    {0xd1,0x40},{0xd1,0x47},{0xd4,0xa1},{0x98,0xea},{0xd1,0x45},
    {0xae,0x44},{0xad,0xf0},{0xd0,0xfc},{0xd0,0xf3},{0xfb,0x52},
    {0xad,0xf8},{0x00,0x00},{0x82,0x40},{0xd0,0xf2},{0x98,0xeb},
    {0x00,0x00},{0xd0,0xf7},{0x8e,0x66},{0x00,0x00},{0x00,0x00},
    {0xfb,0x55},{0x00,0x00},{0x87,0xae},{0x00,0x00},{0x8e,0x41},
    {0x81,0xa4},{0x84,0xcd},{0x98,0xec},{0xd0,0xf0},{0xae,0x41},
    {0x98,0xed},{0x00,0x00},{0xd4,0x77},{0x98,0xee},{0xb0,0xe4},
    {0xd4,0xa7},{0xb0,0xe2},{0xb0,0xdf},{0xd4,0x7c},{0xb0,0xdb},
    {0xd4,0xa2},{0xb0,0xe6},{0xd4,0x76},{0xd4,0x7b},{0xd4,0x7a},
    {0xad,0xf2},{0xb0,0xe1},{0xd4,0xa5},{0x00,0x00},{0xd4,0xa8},
    {0xd4,0x73},{0x00,0x00},{0xb3,0xe8},{0x81,0xa5},{0xd4,0xa9},
    {0xb0,0xe7},{0x00,0x00},{0xb0,0xd9},{0xb0,0xd6},{0xd4,0x7e},
    {0xb0,0xd3},{0x98,0xef},{0xd4,0xa6},{0x96,0xb1},{0xb0,0xda},
    {0xd4,0xaa},{0x81,0xa6},{0xd4,0x74},{0xd4,0xa4},{0xb0,0xdd},
    {0xd4,0x75},{0xd4,0x78},{0xd4,0x7d},{0x81,0xa7},{0x00,0x00},
    {0xb0,0xde},{0xb0,0xdc},{0xb0,0xe8},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0xb0,0xe3},{0x81,0xa8},{0xb0,0xd7},
    {0xb1,0xd2},{0x00,0x00},{0xb0,0xd8},{0xd4,0x79},{0xb0,0xe5},
    {0xb0,0xe0},{0xd4,0xa3},{0xb0,0xd5},{0x86,0xb3},{0x00,0x00},
    {0xfb,0x5b},{0xb0,0xd4},{0xa0,0x46},{0x81,0xa9},{0x8c,0x6e},
    {0x8c,0xc7},{0x00,0x00},{0x00,0x00},{0xa0,0x49},{0xa0,0x45},
    {0xfb,0xdd},{0x00,0x00},{0xd4,0x71},{0xd4,0x72},{0xd8,0x6a},
    {0x87,0xb3},{0x98,0xf0},{0x00,0x00},{0xb3,0xd7},{0xb3,0xda},
    {0xd8,0x75},{0xb3,0xee},{0xd8,0x78},{0xb3,0xd8},{0xd8,0x71},
    {0xb3,0xde},{0xb3,0xe4},{0xb5,0xbd},{0x00,0x00},{0x95,0xed},
    {0xb3,0xe2},{0xd8,0x6e},{0xb3,0xef},{0xb3,0xdb},{0xb3,0xe3},
    {0xd8,0x76},{0xdc,0xd7},{0xd8,0x7b},{0xd8,0x6f},{0x98,0xf1},
    {0xd8,0x66},{0xd8,0x73},{0xd8,0x6d},{0xb3,0xe1},{0xd8,0x79},
    {0x00,0x00},{0x00,0x00},{0xb3,0xdd},{0xb3,0xf1},{0xb3,0xea},
    {0x00,0x00},{0xb3,0xdf},{0xb3,0xdc},{0x81,0xaa},{0xb3,0xe7},
    {0x00,0x00},{0xd8,0x7a},{0xd8,0x6c},{0xd8,0x72},{0xd8,0x74},
    {0xd8,0x68},{0xd8,0x77},{0xb3,0xd9},{0xd8,0x67},{0x81,0xab},
    {0xb3,0xe0},{0xb3,0xf0},{0xb3,0xec},{0xd8,0x69},{0xb3,0xe6},
    {0x00,0x00},{0x94,0x42},{0xb3,0xed},{0xb3,0xe9},{0xb3,0xe5},
    {0x98,0xf2},{0xd8,0x70},{0x92,0x49},{0x87,0xb2},{0x00,0x00},
    {0x96,0xb5},{0xa0,0x4a},{0xb3,0xeb},{0xfb,0x4c},{0x86,0xb2},
    {0x8f,0xd9},{0xdc,0xd5},{0xdc,0xd1},{0x98,0xf3},{0xdc,0xe0},
    {0xdc,0xca},{0xdc,0xd3},{0xb6,0xe5},{0xb6,0xe6},{0xb6,0xde},
    {0xdc,0xdc},{0xb6,0xe8},{0xdc,0xcf},{0xdc,0xce},{0xdc,0xcc},
    {0xdc,0xde},{0xb6,0xdc},{0xdc,0xd8},{0xdc,0xcd},{0xb6,0xdf},
    {0xdc,0xd6},{0xb6,0xda},{0xdc,0xd2},{0xdc,0xd9},{0xdc,0xdb},
    {0x98,0xf4},{0x98,0xf5},{0xdc,0xdf},{0xb6,0xe3},{0xdc,0xcb},
    {0xb6,0xdd},{0xdc,0xd0},{0xfb,0x56},{0xb6,0xd8},{0x00,0x00},
    {0xb6,0xe4},{0xdc,0xda},{0xb6,0xe0},{0xb6,0xe1},{0xb6,0xe7},
    {0xb6,0xdb},{0xa2,0x5f},{0xb6,0xd9},{0xdc,0xd4},{0x96,0xc9},
    {0x8c,0x6d},{0x81,0xac},{0x00,0x00},{0x00,0x00},{0xb6,0xe2},
    {0xa0,0x4d},{0xa0,0x4b},{0xdc,0xdd},{0x88,0xcf},{0x00,0x00},
    {0x81,0xad},{0xb9,0xcd},{0xb9,0xc8},{0x00,0x00},{0xe1,0x55},
    {0xe1,0x51},{0x98,0xf6},{0xe1,0x4b},{0xb9,0xc2},{0xb9,0xbe},
    {0xe1,0x54},{0xb9,0xbf},{0xe1,0x4e},{0xe1,0x50},{0x00,0x00},
    {0xe1,0x53},{0xa0,0x4e},{0xb9,0xc4},{0x00,0x00},{0xb9,0xcb},
    {0xb9,0xc5},{0x00,0x00},{0x00,0x00},{0xe1,0x49},{0xb9,0xc6},
    {0xb9,0xc7},{0xe1,0x4c},{0xb9,0xcc},{0xfb,0xe1},{0xe1,0x4a},
    {0xe1,0x4f},{0xb9,0xc3},{0xe1,0x48},{0xb9,0xc9},{0xb9,0xc1},
    {0x82,0xb3},{0x00,0x00},{0x00,0x00},{0xb9,0xc0},{0xe1,0x4d},
    {0xe1,0x52},{0xa0,0x52},{0xb9,0xca},{0xfc,0xd9},{0x98,0xf8},
    {0xa0,0x4f},{0x81,0xae},{0x8b,0xf1},{0xfb,0x65},{0x00,0x00},
    {0xe1,0x47},{0x00,0x00},{0xbc,0x4d},{0xe5,0x47},{0x00,0x00},
    {0xe5,0x44},{0xa0,0x50},{0xbc,0x47},{0xbc,0x53},{0xbc,0x54},
    {0x8d,0x51},{0xbc,0x4a},{0xe5,0x42},{0xbc,0x4c},{0xe4,0xf9},
    {0xbc,0x52},{0xfe,0x5d},{0xe5,0x46},{0xbc,0x49},{0xe5,0x48},
    {0xbc,0x48},{0x00,0x00},{0xe5,0x43},{0xe5,0x45},{0xbc,0x4b},
    {0xe5,0x41},{0xe4,0xfa},{0xe4,0xf7},{0xa0,0x51},{0x00,0x00},
    {0xd8,0x6b},{0xe4,0xfd},{0x00,0x00},{0xe4,0xf6},{0xe4,0xfc},
    {0xe4,0xfb},{0x00,0x00},{0xe4,0xf8},{0xfb,0xe2},{0xbc,0x4f},
    {0xfb,0x6a},{0x81,0xaf},{0x00,0x00},{0x98,0xfa},{0xbc,0x4e},
    {0xfb,0xe4},{0x00,0x00},{0x00,0x00},{0xbc,0x50},{0xe4,0xfe},
    {0xbe,0xb2},{0xe5,0x40},{0x82,0x4f},{0x8a,0xbe},{0x99,0x40},
    {0xe9,0x45},{0x00,0x00},{0xe8,0xfd},{0x99,0x55},{0xbe,0xbe},
    {0xe9,0x42},{0xbe,0xb6},{0xbe,0xba},{0xe9,0x41},{0x00,0x00},
    {0xbe,0xb9},{0xbe,0xb5},{0xbe,0xb8},{0xbe,0xb3},{0xbe,0xbd},
    {0xe9,0x43},{0xe8,0xfe},{0xbe,0xbc},{0xe8,0xfc},{0xbe,0xbb},
    {0xe9,0x44},{0xe9,0x40},{0xbc,0x51},{0x00,0x00},{0xbe,0xbf},
    {0xe9,0x46},{0xbe,0xb7},{0xbe,0xb4},{0x94,0x57},{0x96,0xca},
    {0x81,0xb0},{0x00,0x00},{0xec,0xc6},{0xec,0xc8},{0xc0,0x7b},
    {0xec,0xc9},{0xec,0xc7},{0xec,0xc5},{0xec,0xc4},{0xc0,0x7d},
    {0xec,0xc3},{0xc0,0x7e},{0x00,0x00},{0x99,0x56},{0x81,0xb1},
    {0x99,0x57},{0xec,0xc1},{0xec,0xc2},{0xc0,0x7a},{0xc0,0xa1},
    {0xc0,0x7c},{0x00,0x00},{0xa0,0x53},{0xec,0xc0},{0x81,0xb2},
    {0xc2,0x50},{0x00,0x00},{0xef,0xbc},{0xef,0xba},{0xef,0xbf},
    {0xef,0xbd},{0x00,0x00},{0xef,0xbb},{0xef,0xbe},{0x99,0x58},
    {0xa0,0x5c},{0x81,0xb3},{0x99,0x59},{0x82,0x74},{0x8c,0x6f},
    {0xa0,0x5b},{0xc3,0x60},{0xf1,0xf2},{0xf1,0xf3},{0xc4,0x56},
    {0x00,0x00},{0xf1,0xf4},{0xf1,0xf0},{0xf1,0xf5},{0xf1,0xf1},
    {0xc2,0x51},{0x81,0xb4},{0x00,0x00},{0x99,0x5a},{0xf3,0xfe},
    {0xf4,0x41},{0xc4,0x59},{0xf4,0x40},{0xc4,0x58},{0xc4,0x57},
    {0x00,0x00},{0x99,0x5b},{0x00,0x00},{0x00,0x00},{0xc4,0x5a},
    {0xf5,0xc5},{0xf5,0xc6},{0x99,0x5c},{0xc4,0xda},{0xc4,0xd9},
    {0xc4,0xdb},{0xf5,0xc4},{0x00,0x00},{0xf6,0xd8},{0xf6,0xd7},
    {0x00,0x00},{0xc5,0x6d},{0xc5,0x6f},{0xc5,0x6e},{0xf6,0xd9},
    {0xc5,0xc8},{0xf8,0xa6},{0x94,0x64},{0x00,0x00},{0x00,0x00},
    {0xc5,0xf1},{0x00,0x00},{0xf8,0xa5},{0xf8,0xee},{0x00,0x00},
    {0x99,0x5d},{0xc9,0x49},{0x81,0xb5},{0x00,0x00},{0xa5,0x7d},
    {0xa5,0x7c},{0x00,0x00},{0xa6,0x5f},{0xa6,0x5e},{0xc9,0xc7},
    {0xa6,0x5d},{0xc9,0xc6},{0x86,0xb5},{0x93,0x6f},{0xa7,0x79},
    {0xca,0xa9},{0x00,0x00},{0xca,0xa8},{0x00,0x00},{0x00,0x00},
    {0xa7,0x77},{0xa7,0x7a},{0x00,0x00},{0x85,0xbd},{0xca,0xa7},
    {0x99,0x5e},{0xa7,0x78},{0x83,0x46},{0x92,0x43},{0x92,0xf6},
    {0x84,0xcf},{0x8d,0xca},{0x00,0x00},{0xcb,0xf0},{0x00,0x00},
    {0xcb,0xf1},{0xa9,0x54},{0x9d,0x56},{0x00,0x00},{0x83,0xf6},
    {0x86,0xb6},{0xab,0xaa},{0x81,0xb6},{0xd1,0x48},{0xd1,0x49},
    {0xae,0x45},{0xae,0x46},{0x00,0x00},{0x85,0xbe},{0xd4,0xac},
    {0xb0,0xe9},{0xb0,0xeb},{0xd4,0xab},{0xb0,0xea},{0xd8,0x7c},
    {0xb3,0xf2},{0x00,0x00},{0x92,0xb5},{0x00,0x00},{0x00,0x00},
    {0xb6,0xe9},{0xb6,0xea},{0xdc,0xe1},{0x99,0x5f},{0xb9,0xcf},
    {0x00,0x00},{0xb9,0xce},{0x00,0x00},{0xe5,0x49},{0xe9,0x48},
    {0xe9,0x47},{0x99,0x60},{0xf9,0x6b},{0xa4,0x67},{0xc9,0x59},
    {0x00,0x00},{0xc9,0x6e},{0xc9,0x6f},{0x00,0x00},{0x00,0x00},
    {0x94,0x65},{0x92,0x42},{0xa6,0x62},{0xa6,0x66},{0xc9,0xc9},
    {0x00,0x00},{0xa6,0x64},{0xa6,0x63},{0xc9,0xc8},{0xa6,0x65},
    {0xa6,0x61},{0x00,0x00},{0x99,0x61},{0xa6,0x60},{0xc9,0xca},
    {0x00,0x00},{0x00,0x00},{0x94,0x66},{0x94,0x67},{0x8a,0xbf},
    {0x84,0xd1},{0xa7,0xa6},{0x00,0x00},{0x99,0x62},{0xa7,0xa3},
    {0x99,0x63},{0xa7,0x7d},{0xca,0xaa},{0x95,0xb5},{0x99,0x64},
    {0x00,0x00},{0xca,0xab},{0xfb,0xe7},{0xa7,0xa1},{0x00,0x00},
    {0xca,0xad},{0xa7,0x7b},{0xca,0xae},{0xca,0xac},{0xa7,0x7e},
    {0xa7,0xa2},{0xa7,0xa5},{0xa7,0xa4},{0xa7,0x7c},{0xca,0xaf},
    {0x00,0x00},{0xfe,0x6f},{0x00,0x00},{0x00,0x00},{0x85,0xc0},
    {0x00,0x00},{0x81,0xb7},{0x83,0xf7},{0x88,0xd1},{0x8b,0x6f},
    {0x8d,0x52},{0x85,0xc1},{0x87,0xb6},{0x87,0xb7},{0xa9,0x59},
    {0xcb,0xfe},{0x00,0x00},{0xa9,0x5b},{0x81,0xb8},{0xa9,0x5a},
    {0xfb,0xe9},{0xcc,0x40},{0xa9,0x58},{0xa9,0x57},{0xcb,0xf5},
    {0x00,0x00},{0xcb,0xf4},{0x00,0x00},{0xcb,0xf2},{0xcb,0xf7},
    {0xcb,0xf6},{0xcb,0xf3},{0xcb,0xfc},{0xcb,0xfd},{0xcb,0xfa},
    {0xcb,0xf8},{0xa9,0x56},{0x00,0x00},{0x00,0x00},{0xfb,0xe8},
    {0xcb,0xfb},{0xa9,0x5c},{0xcc,0x41},{0x99,0x66},{0x81,0xb9},
    {0xcb,0xf9},{0x00,0x00},{0xab,0xab},{0xa9,0x55},{0x8b,0x6e},
    {0x81,0xba},{0x8f,0xb8},{0x00,0x00},{0x94,0x68},{0x81,0xbb},
    {0x99,0x67},{0xab,0xac},{0xce,0x54},{0x99,0x68},{0x00,0x00},
    {0xce,0x5a},{0x99,0x69},{0x00,0x00},{0x8a,0xc0},{0xab,0xb2},
    {0xce,0x58},{0xce,0x5e},{0x00,0x00},{0xce,0x55},{0xce,0x59},
    {0xce,0x5b},{0xce,0x5d},{0xce,0x57},{0x99,0x6a},{0xce,0x56},
    {0xce,0x51},{0xce,0x52},{0xab,0xad},{0x81,0xbc},{0xab,0xaf},
    {0xab,0xae},{0xce,0x53},{0xce,0x5c},{0x88,0xd0},{0x8d,0xb6},
    {0x00,0x00},{0x83,0xf8},{0x94,0x6a},{0x86,0xb8},{0x81,0xbd},
    {0x8d,0xcb},{0xab,0xb1},{0x00,0x00},{0x94,0x6b},{0x00,0x00},
    {0x8e,0x42},{0x94,0x69},{0x81,0xbe},{0xce,0x50},{0xd1,0x53},
    {0x00,0x00},{0xd1,0x52},{0xd1,0x57},{0xd1,0x4e},{0x99,0x6b},
    {0xd1,0x51},{0xd1,0x50},{0x99,0x6c},{0xd1,0x54},{0x81,0xbf},
    {0xd1,0x58},{0xae,0x47},{0xae,0x4a},{0x99,0x6d},{0x00,0x00},
    {0xd1,0x4f},{0xd1,0x55},{0x81,0xc0},{0x00,0x00},{0x00,0x00},
    {0xae,0x49},{0xd1,0x4a},{0x00,0x00},{0xab,0xb0},{0xd4,0xba},
    {0xd1,0x56},{0x00,0x00},{0xd1,0x4d},{0x81,0xc1},{0xae,0x48},
    {0xd1,0x4c},{0x94,0x6c},{0xfe,0x49},{0x85,0xc2},{0x89,0xce},
    {0x84,0xd3},{0x00,0x00},{0xd4,0xb1},{0xfb,0xec},{0x99,0x6e},
    {0xb0,0xec},{0xb0,0xf0},{0xd4,0xc1},{0xd4,0xaf},{0xd4,0xbd},
    {0xb0,0xf1},{0xd4,0xbf},{0xfb,0xeb},{0xd4,0xc5},{0x00,0x00},
    {0xd4,0xc9},{0x00,0x00},{0x00,0x00},{0xd4,0xc0},{0xd4,0xb4},
    {0xd4,0xbc},{0x81,0xc2},{0xd4,0xca},{0xd4,0xc8},{0xd4,0xbe},
    {0xd4,0xb9},{0xd4,0xb2},{0xd8,0xa6},{0xd4,0xb0},{0xb0,0xf5},
    {0xd4,0xb7},{0xb0,0xf6},{0xb0,0xf2},{0xd4,0xad},{0xd4,0xc3},
    {0xd4,0xb5},{0x99,0x6f},{0x00,0x00},{0xd4,0xb3},{0xd4,0xc6},
    {0xb0,0xf3},{0x95,0x4a},{0xd4,0xcc},{0xb0,0xed},{0xb0,0xef},
    {0xd4,0xbb},{0xd4,0xb6},{0xae,0x4b},{0xb0,0xee},{0xd4,0xb8},
    {0xd4,0xc7},{0xd4,0xcb},{0xd4,0xc2},{0x00,0x00},{0xd4,0xc4},
    {0x86,0xb9},{0x99,0x70},{0x00,0x00},{0xd4,0xae},{0x87,0xb8},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0xd8,0xa1},{0x00,0x00},
    {0xd8,0xaa},{0xd8,0xa9},{0xb3,0xfa},{0xd8,0xa2},{0x00,0x00},
    {0xb3,0xfb},{0xb3,0xf9},{0x99,0x71},{0xd8,0xa4},{0xb3,0xf6},
    {0xd8,0xa8},{0xfb,0xef},{0xd8,0xa3},{0xd8,0xa5},{0xd8,0x7d},
    {0xb3,0xf4},{0x00,0x00},{0xd8,0xb2},{0xd8,0xb1},{0xd8,0xae},
    {0xb3,0xf3},{0xb3,0xf7},{0xb3,0xf8},{0xd1,0x4b},{0xd8,0xab},
    {0xb3,0xf5},{0xb0,0xf4},{0xd8,0xad},{0xd8,0x7e},{0xd8,0xb0},
    {0xd8,0xaf},{0xfb,0xea},{0xd8,0xb3},{0x00,0x00},{0xdc,0xef},
    {0x00,0x00},{0xd8,0xac},{0x94,0x59},{0x93,0xe9},{0x00,0x00},
    {0x00,0x00},{0x81,0xc3},{0x00,0x00},{0x00,0x00},{0x99,0x72},
    {0xd8,0xa7},{0xdc,0xe7},{0xb6,0xf4},{0xb6,0xf7},{0xb6,0xf2},
    {0xdc,0xe6},{0xdc,0xea},{0xdc,0xe5},{0x00,0x00},{0xb6,0xec},
    {0xb6,0xf6},{0xdc,0xe2},{0xb6,0xf0},{0xdc,0xe9},{0x00,0x00},
    {0xb6,0xee},{0xb6,0xed},{0xdc,0xec},{0xb6,0xef},{0xdc,0xee},
    {0x99,0x73},{0xdc,0xeb},{0xb6,0xeb},{0x99,0x74},{0x00,0x00},
    {0x00,0x00},{0xb6,0xf5},{0xdc,0xf0},{0xdc,0xe4},{0xdc,0xed},
    {0x00,0x00},{0x00,0x00},{0xdc,0xe3},{0x95,0xcd},{0x00,0x00},
    {0xb6,0xf1},{0x81,0xc4},{0xb6,0xf3},{0x00,0x00},{0xdc,0xe8},
    {0x94,0x6d},{0xdc,0xf1},{0x95,0x62},{0x99,0x75},{0xe1,0x5d},
    {0xb9,0xd0},{0xe1,0x63},{0x00,0x00},{0x00,0x00},{0xb9,0xd5},
    {0xe1,0x5f},{0xe1,0x66},{0xe1,0x57},{0xb9,0xd7},{0xb9,0xd1},
    {0xe1,0x5c},{0xbc,0x55},{0xe1,0x5b},{0xe1,0x64},{0xb9,0xd2},
    {0x00,0x00},{0xb9,0xd6},{0xe1,0x5a},{0xe1,0x60},{0xe1,0x65},
    {0xe1,0x56},{0xb9,0xd4},{0xe1,0x5e},{0x00,0x00},{0x00,0x00},
    {0xe1,0x62},{0xe1,0x68},{0xe1,0x58},{0xe1,0x61},{0x81,0xc5},
    {0xb9,0xd3},{0xe1,0x67},{0x00,0x00},{0x00,0x00},{0x93,0x5e},
    {0xe1,0x59},{0x89,0xf5},{0x81,0xc6},{0x00,0x00},{0xbc,0x59},
    {0xe5,0x4b},{0xbc,0x57},{0xbc,0x56},{0xe5,0x4d},{0xe5,0x52},
    {0x00,0x00},{0xe5,0x4e},{0x00,0x00},{0xe5,0x51},{0xbc,0x5c},
    {0x99,0x76},{0xbe,0xa5},{0xbc,0x5b},{0x99,0x77},{0xe5,0x4a},
    {0xe5,0x50},{0x00,0x00},{0xbc,0x5a},{0xe5,0x4f},{0x99,0x78},
    {0xe5,0x4c},{0x81,0xc7},{0xbc,0x58},{0x00,0x00},{0x99,0x79},
    {0x99,0x7a},{0x00,0x00},{0x81,0xc8},{0x94,0x6e},{0xe9,0x4d},
    {0xf9,0xd9},{0xe9,0x4f},{0xe9,0x4a},{0xbe,0xc1},{0xe9,0x4c},
    {0x00,0x00},{0xbe,0xc0},{0xe9,0x4e},{0x00,0x00},{0x00,0x00},
    {0xbe,0xc3},{0xe9,0x50},{0xbe,0xc2},{0xe9,0x49},{0xe9,0x4b},
    {0x92,0x5c},{0x99,0x7b},{0x92,0xee},{0x00,0x00},{0xc0,0xa5},
    {0xec,0xcc},{0x99,0x7c},{0xc0,0xa4},{0xec,0xcd},{0xc0,0xa3},
    {0xec,0xcb},{0xc0,0xa2},{0xec,0xca},{0x94,0x6f},{0xc2,0x53},
    {0xc2,0x52},{0xf1,0xf6},{0xf1,0xf8},{0xfb,0xf0},{0xf1,0xf7},
    {0xc3,0x61},{0xc3,0x62},{0x99,0x7d},{0x00,0x00},{0xc3,0x63},
    {0xf4,0x42},{0xc4,0x5b},{0x81,0xc9},{0x00,0x00},{0xf7,0xd3},
    {0xf7,0xd2},{0xc5,0xf2},{0x00,0x00},{0xa4,0x68},{0xa4,0xd0},
    {0x00,0x00},{0x83,0x47},{0xa7,0xa7},{0x8a,0x52},{0x92,0x45},
    {0x93,0xb3},{0x84,0xea},{0xce,0x5f},{0x00,0x00},{0x84,0xd4},
    {0x82,0x41},{0x00,0x00},{0xb3,0xfc},{0xb3,0xfd},{0x81,0xca},
    {0xdc,0xf2},{0xb9,0xd8},{0xe1,0x69},{0xe5,0x53},{0x00,0x00},
    {0x00,0x00},{0x81,0xcb},{0xc9,0x5a},{0x84,0x7a},{0x99,0x7e},
    {0xca,0xb0},{0x84,0xc2},{0x00,0x00},{0x93,0xc4},{0xc6,0xca},
    {0x81,0xcc},{0xcc,0x42},{0xce,0x60},{0xd1,0x59},{0xae,0x4c},
    {0x81,0xcd},{0x99,0xa1},{0xf1,0xf9},{0x00,0x00},{0xc4,0xdc},
    {0xa4,0x69},{0xa5,0x7e},{0xc9,0x70},{0x81,0xce},{0xa6,0x67},
    {0xa6,0x68},{0x81,0xcf},{0xa9,0x5d},{0x9d,0x58},{0x00,0x00},
    {0x83,0xfa},{0xb0,0xf7},{0x00,0x00},{0xb9,0xda},{0x00,0x00},
    {0xb9,0xdb},{0xb9,0xd9},{0x00,0x00},{0xa4,0x6a},{0x00,0x00},
    {0xa4,0xd1},{0xa4,0xd3},{0xa4,0xd2},{0xc9,0x5b},{0xa4,0xd4},
    {0xa5,0xa1},{0xc9,0x71},{0x00,0x00},{0xa5,0xa2},{0x82,0xb5},
    {0x00,0x00},{0x89,0xb3},{0x00,0x00},{0x00,0x00},{0xa6,0x69},
    {0xa6,0x6a},{0x83,0x48},{0x86,0xbc},{0x00,0x00},{0xc9,0xcb},
    {0x00,0x00},{0xa7,0xa8},{0x00,0x00},{0xca,0xb1},{0x86,0xbd},
    {0x83,0x6b},{0x00,0x00},{0xa9,0x61},{0xcc,0x43},{0x00,0x00},
    {0xa9,0x5f},{0xa9,0x60},{0xa9,0x5e},{0xd1,0x5a},{0x88,0xd2},
    {0x00,0x00},{0x00,0x00},{0xab,0xb6},{0xab,0xb5},{0xab,0xb7},
    {0xab,0xb4},{0x00,0x00},{0xce,0x61},{0xa9,0x62},{0xab,0xb3},
    {0x87,0xf2},{0xae,0x4d},{0xae,0x4e},{0x00,0x00},{0xae,0x4f},
    {0x82,0xb6},{0xd4,0xcd},{0x82,0xb7},{0x00,0x00},{0x00,0x00},
    {0xb3,0xfe},{0xd8,0xb4},{0xb0,0xf8},{0x82,0xb8},{0x00,0x00},
    {0x85,0xc4},{0x00,0x00},{0xb6,0xf8},{0x92,0xe6},{0xb9,0xdd},
    {0xb9,0xdc},{0xe1,0x6a},{0x82,0xb9},{0xbc,0x5d},{0xbe,0xc4},
    {0x00,0x00},{0xef,0xc0},{0xf6,0xda},{0xf7,0xd4},{0xa4,0x6b},
    {0xa5,0xa3},{0xfe,0x66},{0xa5,0xa4},{0xc9,0xd1},{0xa6,0x6c},
    {0xa6,0x6f},{0x00,0x00},{0xc9,0xcf},{0xc9,0xcd},{0xa6,0x6e},
    {0xc9,0xd0},{0xc9,0xd2},{0xc9,0xcc},{0xa6,0x71},{0xa6,0x70},
    {0xa6,0x6d},{0xa6,0x6b},{0xc9,0xce},{0x83,0x49},{0x83,0xfc},
    {0x85,0xc5},{0x99,0xa2},{0xa7,0xb3},{0x00,0x00},{0x00,0x00},
    {0xa7,0xb0},{0xca,0xb6},{0xca,0xb9},{0xca,0xb8},{0x00,0x00},
    {0xa7,0xaa},{0xa7,0xb2},{0x99,0xa3},{0x00,0x00},{0xa7,0xaf},
    {0xca,0xb5},{0xca,0xb3},{0xa7,0xae},{0x99,0xa4},{0x82,0xba},
    {0x00,0x00},{0xa7,0xa9},{0xa7,0xac},{0x99,0xa5},{0xca,0xb4},
    {0xca,0xbb},{0xca,0xb7},{0xa7,0xad},{0xa7,0xb1},{0xa7,0xb4},
    {0xca,0xb2},{0xca,0xba},{0xa7,0xab},{0x87,0xbb},{0x86,0xbe},
    {0x8d,0xdb},{0x95,0xa5},{0x00,0x00},{0xa9,0x67},{0xa9,0x6f},
    {0x99,0xa6},{0xcc,0x4f},{0xcc,0x48},{0xa9,0x70},{0xcc,0x53},
    {0xcc,0x44},{0xcc,0x4b},{0xfb,0xf1},{0x99,0xa7},{0xa9,0x66},
    {0xcc,0x45},{0xa9,0x64},{0xcc,0x4c},{0xcc,0x50},{0xa9,0x63},
    {0x9b,0x40},{0xcc,0x51},{0xcc,0x4a},{0x00,0x00},{0xcc,0x4d},
    {0x99,0xa8},{0xa9,0x72},{0xa9,0x69},{0xcc,0x54},{0xcc,0x52},
    {0x93,0xfc},{0xa9,0x6e},{0xa9,0x6c},{0xcc,0x49},{0xa9,0x6b},
    {0xcc,0x47},{0xcc,0x46},{0xa9,0x6a},{0xa9,0x68},{0xa9,0x71},
    {0xa9,0x6d},{0xa9,0x65},{0x00,0x00},{0xcc,0x4e},{0x82,0xbb},
    {0xab,0xb9},{0xfb,0xf2},{0xab,0xc0},{0xce,0x6f},{0xab,0xb8},
    {0xce,0x67},{0xce,0x63},{0x00,0x00},{0xce,0x73},{0xce,0x62},
    {0x00,0x00},{0xab,0xbb},{0xce,0x6c},{0xab,0xbe},{0xab,0xc1},
    {0x00,0x00},{0xab,0xbc},{0xce,0x70},{0xab,0xbf},{0x82,0xbc},
    {0xae,0x56},{0xce,0x76},{0xce,0x64},{0x99,0xa9},{0x99,0xaa},
    {0xce,0x66},{0xce,0x6d},{0xce,0x71},{0xce,0x75},{0xce,0x72},
    {0xce,0x6b},{0xce,0x6e},{0x99,0xab},{0x95,0xc0},{0xce,0x68},
    {0xab,0xc3},{0xce,0x6a},{0xce,0x69},{0xce,0x74},{0xab,0xba},
    {0xce,0x65},{0xab,0xc2},{0x99,0xac},{0xab,0xbd},{0x83,0xfb},
    {0x8d,0xcc},{0x87,0xbd},{0x87,0xbc},{0x90,0x55},{0xae,0x5c},
    {0xd1,0x62},{0x99,0xad},{0xae,0x5b},{0x99,0xae},{0x00,0x00},
    {0xd1,0x60},{0x00,0x00},{0xae,0x50},{0x99,0xaf},{0xae,0x55},
    {0x00,0x00},{0xd1,0x5f},{0xd1,0x5c},{0xd1,0x61},{0xae,0x51},
    {0xd1,0x5b},{0x82,0xbd},{0xae,0x54},{0xae,0x52},{0x00,0x00},
    {0xd1,0x63},{0xae,0x53},{0xae,0x57},{0x99,0xb0},{0x00,0x00},
    {0xae,0x58},{0x99,0xb1},{0xae,0x5a},{0x00,0x00},{0x99,0xb2},
    {0x00,0x00},{0xae,0x59},{0x99,0xb3},{0x99,0xb4},{0x99,0xb5},
    {0xd1,0x5d},{0xd1,0x5e},{0x92,0xbc},{0x00,0x00},{0x83,0xb1},
    {0x84,0xd5},{0xd1,0x64},{0x87,0xb9},{0xd4,0xd4},{0xb0,0xf9},
    {0xd8,0xc2},{0xd4,0xd3},{0xd4,0xe6},{0x00,0x00},{0x00,0x00},
    {0xb1,0x40},{0x99,0xb6},{0xd4,0xe4},{0x00,0x00},{0xb0,0xfe},
    {0xb0,0xfa},{0xd4,0xed},{0xd4,0xdd},{0xd4,0xe0},{0x99,0xb7},
    {0xb1,0x43},{0xd4,0xea},{0xd4,0xe2},{0xb0,0xfb},{0xb1,0x44},
    {0x00,0x00},{0xd4,0xe7},{0xd4,0xe5},{0x00,0x00},{0x00,0x00},
    {0xd4,0xd6},{0xd4,0xeb},{0xd4,0xdf},{0xd4,0xda},{0x99,0xb8},
    {0xd4,0xd0},{0xd4,0xec},{0xd4,0xdc},{0xd4,0xcf},{0x99,0xb9},
    {0xb1,0x42},{0xd4,0xe1},{0xd4,0xee},{0xd4,0xde},{0xd4,0xd2},
    {0xd4,0xd7},{0xd4,0xce},{0x99,0xba},{0xb1,0x41},{0x95,0x63},
    {0xd4,0xdb},{0xd4,0xd8},{0xb0,0xfc},{0xd4,0xd1},{0x99,0xbb},
    {0xd4,0xe9},{0xb0,0xfd},{0x99,0xbc},{0xd4,0xd9},{0xd4,0xd5},
    {0x99,0xbd},{0x00,0x00},{0xd4,0xe8},{0x99,0xbe},{0x00,0x00},
    {0x00,0x00},{0x89,0xcf},{0x87,0xba},{0x8a,0xc1},{0xb4,0x40},
    {0xd8,0xbb},{0x99,0xbf},{0xd8,0xb8},{0xd8,0xc9},{0xd8,0xbd},
    {0xd8,0xca},{0x99,0xc0},{0xb4,0x42},{0x00,0x00},{0x99,0xc1},
    {0x99,0xc2},{0xd8,0xc6},{0xd8,0xc3},{0x00,0x00},{0x99,0xc3},
    {0x00,0x00},{0x99,0xc4},{0x00,0x00},{0xd8,0xc4},{0xd8,0xc7},
    {0xd8,0xcb},{0x00,0x00},{0xd4,0xe3},{0xd8,0xcd},{0xdd,0x47},
    {0x99,0xc5},{0xb4,0x43},{0xd8,0xce},{0xd8,0xb6},{0xd8,0xc0},
    {0xfe,0x78},{0xd8,0xc5},{0x00,0x00},{0x99,0xc6},{0xb4,0x41},
    {0xb4,0x44},{0xd8,0xcc},{0xd8,0xcf},{0xd8,0xba},{0xd8,0xb7},
    {0x99,0xc7},{0x99,0xc8},{0xd8,0xb9},{0x00,0x00},{0x9c,0x70},
    {0xd8,0xbe},{0xd8,0xbc},{0xb4,0x45},{0x00,0x00},{0xd8,0xc8},
    {0x82,0xbe},{0x99,0xc9},{0xd8,0xbf},{0x00,0x00},{0xd8,0xc1},
    {0xd8,0xb5},{0xdc,0xfa},{0xdc,0xf8},{0xb7,0x42},{0xb7,0x40},
    {0xdd,0x43},{0xdc,0xf9},{0xdd,0x44},{0xdd,0x40},{0xdc,0xf7},
    {0xdd,0x46},{0xdc,0xf6},{0xdc,0xfd},{0xb6,0xfe},{0xb6,0xfd},
    {0xb6,0xfc},{0xdc,0xfb},{0xdd,0x41},{0xb6,0xf9},{0xb7,0x41},
    {0x99,0xca},{0xdc,0xf4},{0x00,0x00},{0xdc,0xfe},{0xdc,0xf3},
    {0xdc,0xfc},{0xb6,0xfa},{0xdd,0x42},{0xdc,0xf5},{0xb6,0xfb},
    {0xdd,0x45},{0x99,0xcb},{0x99,0xcc},{0x82,0xbf},{0x9d,0x67},
    {0x8e,0xe5},{0x99,0xcd},{0x89,0xd0},{0xe1,0x6e},{0xb9,0xe2},
    {0xb9,0xe1},{0xb9,0xe3},{0xe1,0x7a},{0xe1,0x70},{0xe1,0x76},
    {0xe1,0x6b},{0xe1,0x79},{0xe1,0x78},{0xe1,0x7c},{0xe1,0x75},
    {0xb9,0xde},{0xe1,0x74},{0xb9,0xe4},{0x99,0xce},{0xe1,0x6d},
    {0xb9,0xdf},{0x00,0x00},{0xe1,0x7b},{0xb9,0xe0},{0xe1,0x6f},
    {0xe1,0x72},{0xe1,0x77},{0xe1,0x71},{0xe1,0x6c},{0x00,0x00},
    {0x99,0xcf},{0x82,0xc0},{0xfb,0x67},{0xe1,0x73},{0xe5,0x55},
    {0xbc,0x61},{0xe5,0x58},{0xe5,0x57},{0xe5,0x5a},{0xe5,0x5c},
    {0xf9,0xdc},{0xbc,0x5f},{0x00,0x00},{0xe5,0x56},{0x99,0xd0},
    {0xe5,0x54},{0x00,0x00},{0xe5,0x5d},{0xe5,0x5b},{0xe5,0x59},
    {0x00,0x00},{0xe5,0x5f},{0x00,0x00},{0xe5,0x5e},{0xbc,0x63},
    {0xbc,0x5e},{0x00,0x00},{0xbc,0x60},{0xbc,0x62},{0x99,0xd1},
    {0x00,0x00},{0xe5,0x60},{0xe9,0x57},{0x99,0xd2},{0x00,0x00},
    {0xe9,0x56},{0xe9,0x55},{0x99,0xd3},{0xe9,0x58},{0xe9,0x51},
    {0x00,0x00},{0xe9,0x52},{0xe9,0x5a},{0xe9,0x53},{0x00,0x00},
    {0xbe,0xc5},{0xe9,0x5c},{0x99,0xd4},{0xe9,0x5b},{0xe9,0x54},
    {0x92,0xef},{0xec,0xd1},{0xc0,0xa8},{0xec,0xcf},{0xec,0xd4},
    {0xec,0xd3},{0xe9,0x59},{0x00,0x00},{0xc0,0xa7},{0x99,0xd5},
    {0xec,0xd2},{0xec,0xce},{0xec,0xd6},{0xec,0xd5},{0xc0,0xa6},
    {0x00,0x00},{0xec,0xd0},{0x00,0x00},{0xbe,0xc6},{0x00,0x00},
    {0x82,0xc1},{0x89,0xd1},{0xc2,0x54},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0xef,0xc1},{0xf1,0xfa},{0xf1,0xfb},{0xf1,0xfc},
    {0xc4,0x5c},{0x99,0xd6},{0x00,0x00},{0xc4,0x5d},{0x99,0xd7},
    {0xf4,0x43},{0x99,0xd8},{0xf5,0xc8},{0xf5,0xc7},{0x00,0x00},
    {0x99,0xd9},{0xf6,0xdb},{0xf6,0xdc},{0xf7,0xd5},{0xf8,0xa7},
    {0x99,0xda},{0xa4,0x6c},{0xa4,0x6d},{0x00,0x00},{0xa4,0x6e},
    {0xa4,0xd5},{0xa5,0xa5},{0xc9,0xd3},{0xa6,0x72},{0xa6,0x73},
    {0x83,0xb2},{0xa7,0xb7},{0xa7,0xb8},{0xa7,0xb6},{0xa7,0xb5},
    {0x00,0x00},{0xa9,0x73},{0x00,0x00},{0x00,0x00},{0xcc,0x55},
    {0xa9,0x75},{0xa9,0x74},{0xcc,0x56},{0x88,0xd4},{0x00,0x00},
    {0x99,0xdb},{0xab,0xc4},{0x8c,0xcb},{0xae,0x5d},{0xd1,0x65},
    {0xa0,0x41},{0xd4,0xf0},{0x00,0x00},{0xb1,0x45},{0xb4,0x47},
    {0xd4,0xef},{0xb4,0x46},{0x99,0xdc},{0xb9,0xe5},{0x99,0xdd},
    {0xe1,0x7d},{0xbe,0xc7},{0x00,0x00},{0xc0,0xa9},{0xec,0xd7},
    {0x99,0xde},{0xc4,0x5e},{0x00,0x00},{0xc5,0x70},{0xc6,0xcb},
    {0xc9,0x72},{0x99,0xdf},{0xa5,0xa6},{0xc9,0x73},{0xa6,0x76},
    {0x00,0x00},{0xa6,0x74},{0xa6,0x75},{0xa6,0x77},{0x00,0x00},
    {0xa7,0xba},{0xa7,0xb9},{0x93,0xfd},{0xca,0xbc},{0xa7,0xbb},
    {0x99,0xe0},{0x00,0x00},{0xca,0xbd},{0xcc,0x57},{0x00,0x00},
    {0xcc,0x58},{0x9a,0x40},{0xa9,0x76},{0xa9,0x78},{0xa9,0x7a},
    {0xa9,0x77},{0xa9,0x7b},{0xa9,0x79},{0x8b,0xf3},{0x86,0xbf},
    {0x92,0xd4},{0x8b,0x70},{0x87,0xbf},{0xab,0xc8},{0xab,0xc5},
    {0xab,0xc7},{0xab,0xc9},{0xab,0xc6},{0xd1,0x66},{0xce,0x77},
    {0x00,0x00},{0x88,0xd6},{0x90,0xb3},{0xd1,0x68},{0xd1,0x67},
    {0xae,0x63},{0x00,0x00},{0xae,0x5f},{0x00,0x00},{0x00,0x00},
    {0xae,0x60},{0xae,0x62},{0xae,0x64},{0xae,0x61},{0x9d,0x68},
    {0xae,0x66},{0xae,0x65},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x87,0xbe},{0x87,0x59},{0xb1,0x4a},{0xd4,0xf2},{0xd4,0xf1},
    {0xb1,0x49},{0xfc,0x43},{0xb1,0x48},{0xb1,0x47},{0xb1,0x4b},
    {0xb1,0x46},{0x00,0x00},{0x82,0xc2},{0xd8,0xd5},{0xd8,0xd2},
    {0xb4,0x49},{0xd8,0xd1},{0xd8,0xd6},{0x00,0x00},{0xb4,0x4b},
    {0xd8,0xd4},{0xb4,0x48},{0xb4,0x4a},{0xd8,0xd3},{0x9a,0x55},
    {0xdd,0x48},{0x9a,0x56},{0xdd,0x49},{0xdd,0x4a},{0x00,0x00},
    {0x92,0x69},{0x00,0x00},{0x86,0xc0},{0xb9,0xe6},{0xb9,0xee},
    {0xe1,0x7e},{0xb9,0xe8},{0xb9,0xec},{0xe1,0xa1},{0xb9,0xed},
    {0xb9,0xe9},{0xb9,0xea},{0xb9,0xe7},{0xb9,0xeb},{0xbc,0x66},
    {0xd8,0xd0},{0xbc,0x67},{0xbc,0x65},{0x00,0x00},{0xbc,0x64},
    {0xe9,0x5d},{0xbe,0xc8},{0xec,0xd8},{0xec,0xd9},{0x82,0xc3},
    {0x00,0x00},{0xc3,0x64},{0xc4,0x5f},{0x00,0x00},{0xa4,0x6f},
    {0x86,0xc1},{0xa6,0x78},{0x84,0xd6},{0x88,0xd5},{0x00,0x00},
    {0x93,0x66},{0x86,0xba},{0x00,0x00},{0xab,0xca},{0x93,0x47},
    {0xd1,0x69},{0xae,0x67},{0x95,0x5b},{0x92,0xe2},{0xb1,0x4e},
    {0xb1,0x4d},{0xb1,0x4c},{0xb4,0x4c},{0xb4,0x4d},{0xd8,0xd7},
    {0xb9,0xef},{0xbe,0xc9},{0xa4,0x70},{0xc9,0x5c},{0xa4,0xd6},
    {0xc9,0x74},{0x82,0xc4},{0x86,0xe0},{0xc9,0xd4},{0xa6,0x79},
    {0x00,0x00},{0x86,0xb7},{0x00,0x00},{0xa9,0x7c},{0x00,0x00},
    {0x82,0xc5},{0x86,0xaf},{0x82,0xc6},{0xdd,0x4b},{0xfb,0xf3},
    {0x00,0x00},{0xa4,0x71},{0x9a,0x57},{0xa4,0xd7},{0xc9,0xd5},
    {0x00,0x00},{0x84,0xd0},{0xca,0xbe},{0x00,0x00},{0xca,0xbf},
    {0x00,0x00},{0xa7,0xbc},{0x82,0x59},{0x00,0x00},{0x00,0x00},
    {0xd8,0xd8},{0xb4,0x4e},{0x00,0x00},{0xdd,0x4c},{0x89,0xd2},
    {0x00,0x00},{0x00,0x00},{0xc0,0xaa},{0xa4,0x72},{0xa4,0xa8},
    {0xa4,0xd8},{0xc9,0x75},{0xa5,0xa7},{0x86,0xe9},{0xa7,0xc0},
    {0xa7,0xbf},{0xa7,0xbd},{0xa7,0xbe},{0x87,0xc1},{0x00,0x00},
    {0xcc,0x59},{0xa9,0x7e},{0xa9,0xa1},{0xcc,0x5a},{0xa9,0x7d},
    {0x84,0x40},{0x83,0x57},{0xab,0xce},{0xce,0x78},{0xab,0xcd},
    {0xab,0xcb},{0xab,0xcc},{0xae,0x6a},{0xae,0x68},{0x00,0x00},
    {0x82,0xc7},{0xd1,0x6b},{0xae,0x69},{0xd1,0x6a},{0x00,0x00},
    {0xae,0x5e},{0xd4,0xf3},{0x00,0x00},{0x00,0x00},{0xb1,0x50},
    {0xb1,0x51},{0x8c,0x70},{0x00,0x00},{0xb1,0x4f},{0x86,0xc2},
    {0xb9,0xf0},{0xe1,0xa2},{0xbc,0x68},{0xbc,0x69},{0x89,0xd3},
    {0xe5,0x61},{0xc0,0xab},{0xef,0xc2},{0xef,0xc3},{0x00,0x00},
    {0xc4,0xdd},{0xf8,0xa8},{0xc9,0x4b},{0xa4,0xd9},{0x00,0x00},
    {0xa4,0x73},{0x00,0x00},{0xc9,0x77},{0xc9,0x76},{0x00,0x00},
    {0x94,0x70},{0x00,0x00},{0x9d,0x64},{0xa6,0x7a},{0xc9,0xd7},
    {0xc9,0xd8},{0xc9,0xd6},{0x00,0x00},{0xc9,0xd9},{0x89,0xd4},
    {0x00,0x00},{0x85,0xd7},{0x83,0xdb},{0x00,0x00},{0x00,0x00},
    {0x9a,0x58},{0xca,0xc7},{0x00,0x00},{0xca,0xc2},{0xca,0xc4},
    {0xca,0xc6},{0xca,0xc3},{0xa7,0xc4},{0xca,0xc0},{0x00,0x00},
    {0xca,0xc1},{0xa7,0xc1},{0xa7,0xc2},{0xca,0xc5},{0xca,0xc8},
    {0xa7,0xc3},{0xca,0xc9},{0x86,0xc4},{0x84,0x42},{0x83,0xb5},
    {0x82,0xc8},{0x84,0xd7},{0x83,0xb4},{0x82,0xc9},{0xcc,0x68},
    {0x9a,0x59},{0xcc,0x62},{0xcc,0x5d},{0xa9,0xa3},{0xcc,0x65},
    {0xcc,0x63},{0xcc,0x5c},{0xcc,0x69},{0xcc,0x6c},{0xcc,0x67},
    {0xcc,0x60},{0xa9,0xa5},{0xcc,0x66},{0xa9,0xa6},{0xcc,0x61},
    {0xcc,0x64},{0xcc,0x5b},{0xcc,0x5f},{0xcc,0x6b},{0xa9,0xa7},
    {0x00,0x00},{0xa9,0xa8},{0x00,0x00},{0xcc,0x5e},{0xcc,0x6a},
    {0xa9,0xa2},{0xa9,0xa4},{0x00,0x00},{0x82,0xca},{0x82,0xcb},
    {0x94,0x71},{0x8d,0xcd},{0x94,0x73},{0x8f,0xfc},{0x00,0x00},
    {0x82,0xcc},{0x9a,0x5a},{0x00,0x00},{0x8e,0xe6},{0x94,0x72},
    {0xce,0xab},{0xce,0xa4},{0xce,0xaa},{0xce,0xa3},{0xce,0xa5},
    {0xce,0x7d},{0xce,0x7b},{0x00,0x00},{0xce,0xac},{0xce,0xa9},
    {0xce,0x79},{0xfb,0xf5},{0xab,0xd0},{0xce,0xa7},{0xce,0xa8},
    {0x9d,0x71},{0xce,0xa6},{0xce,0x7c},{0xce,0x7a},{0xab,0xcf},
    {0xce,0xa2},{0xce,0x7e},{0x00,0x00},{0x00,0x00},{0xce,0xa1},
    {0xce,0xad},{0x94,0x50},{0x83,0xb3},{0x00,0x00},{0x00,0x00},
    {0x8e,0xb4},{0x84,0x41},{0x8c,0xcd},{0x00,0x00},{0xae,0x6f},
    {0xfb,0xf6},{0xae,0x6e},{0x00,0x00},{0xd1,0x6c},{0xae,0x6b},
    {0xd1,0x6e},{0x95,0x5d},{0xae,0x70},{0xd1,0x6f},{0x00,0x00},
    {0x00,0x00},{0xae,0x73},{0x82,0xcd},{0xae,0x71},{0xd1,0x70},
    {0xce,0xae},{0xd1,0x72},{0x82,0xce},{0xae,0x6d},{0x9d,0x69},
    {0xae,0x6c},{0x00,0x00},{0xd1,0x6d},{0xd1,0x71},{0xae,0x72},
    {0x8e,0xb3},{0x8d,0xce},{0x00,0x00},{0x00,0x00},{0xb1,0x53},
    {0xb1,0x52},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0xd4,0xf5},
    {0xd4,0xf9},{0xd4,0xfb},{0xb1,0x54},{0xd4,0xfe},{0x9a,0x5b},
    {0xb1,0x58},{0xd5,0x41},{0x00,0x00},{0xb1,0x5a},{0x82,0xcf},
    {0xb1,0x56},{0xb1,0x5e},{0x82,0xd0},{0xb1,0x5b},{0xd4,0xf7},
    {0xb1,0x55},{0x00,0x00},{0xd4,0xf6},{0xd4,0xf4},{0xd5,0x43},
    {0xd4,0xf8},{0x00,0x00},{0xb1,0x57},{0xd5,0x42},{0xb1,0x5c},
    {0xd4,0xfd},{0xd4,0xfc},{0xb1,0x5d},{0xd4,0xfa},{0xb1,0x59},
    {0x00,0x00},{0x00,0x00},{0x9a,0x5c},{0x86,0xc3},{0xd5,0x44},
    {0x9a,0x5d},{0xd5,0x40},{0xd8,0xe7},{0xd8,0xee},{0xd8,0xe3},
    {0xb4,0x51},{0xd8,0xdf},{0xd8,0xef},{0xd8,0xd9},{0xd8,0xec},
    {0xd8,0xea},{0xd8,0xe4},{0x00,0x00},{0xd8,0xed},{0xd8,0xe6},
    {0x82,0xd1},{0xd8,0xde},{0xd8,0xf0},{0xd8,0xdc},{0xd8,0xe9},
    {0xd8,0xda},{0x00,0x00},{0xd8,0xf1},{0xfb,0xf7},{0xb4,0x52},
    {0x9a,0x5e},{0xd8,0xeb},{0xdd,0x4f},{0xd8,0xdd},{0xb4,0x4f},
    {0x00,0x00},{0xd8,0xe1},{0x00,0x00},{0xb4,0x50},{0xd8,0xe0},
    {0xd8,0xe5},{0x82,0xd2},{0x00,0x00},{0xd8,0xe2},{0x9a,0x5f},
    {0x95,0x65},{0x89,0xd5},{0xd8,0xe8},{0x00,0x00},{0x8d,0xdc},
    {0x82,0xd3},{0x8e,0x67},{0xdd,0x53},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0xdd,0x56},{0xdd,0x4e},{0x00,0x00},{0xdd,0x50},
    {0x00,0x00},{0xdd,0x55},{0xdd,0x54},{0xb7,0x43},{0x00,0x00},
    {0xd8,0xdb},{0xdd,0x52},{0x82,0xd4},{0x00,0x00},{0xb7,0x44},
    {0x9a,0x60},{0xdd,0x4d},{0xdd,0x51},{0x82,0xd5},{0x82,0xd6},
    {0xfe,0x7e},{0x94,0x74},{0xe1,0xa9},{0x9d,0x7a},{0xe1,0xb0},
    {0xe1,0xa7},{0x9a,0x61},{0xe1,0xae},{0xe1,0xa5},{0xe1,0xad},
    {0xe1,0xb1},{0xe1,0xa4},{0xe1,0xa8},{0xe1,0xa3},{0x00,0x00},
    {0xb9,0xf1},{0x9a,0x62},{0xe1,0xa6},{0xb9,0xf2},{0xe1,0xac},
    {0xe1,0xab},{0xe1,0xaa},{0x93,0xfe},{0x82,0xd7},{0xe1,0xaf},
    {0xfb,0xf8},{0x00,0x00},{0x82,0xd8},{0x00,0x00},{0xe5,0x65},
    {0xe5,0x67},{0xbc,0x6b},{0xe5,0x68},{0x00,0x00},{0xe5,0x63},
    {0x00,0x00},{0xe5,0x62},{0xe5,0x6c},{0x00,0x00},{0xe5,0x6a},
    {0xbc,0x6a},{0xe5,0x6d},{0xe5,0x64},{0xe5,0x69},{0xe5,0x6b},
    {0xe5,0x66},{0x00,0x00},{0x9a,0x63},{0x00,0x00},{0x00,0x00},
    {0xe9,0x61},{0xe9,0x66},{0xe9,0x60},{0xe9,0x65},{0x9a,0x64},
    {0xe9,0x5e},{0xe9,0x68},{0xe9,0x64},{0xe9,0x69},{0xe9,0x63},
    {0xe9,0x5f},{0xe9,0x67},{0x00,0x00},{0xe9,0x6a},{0xe9,0x62},
    {0x9a,0x65},{0xec,0xda},{0xc0,0xaf},{0x82,0xd9},{0xc0,0xad},
    {0x00,0x00},{0xc0,0xac},{0xc0,0xae},{0x00,0x00},{0x00,0x00},
    {0xef,0xc4},{0x9a,0x66},{0xf1,0x72},{0xf1,0xfd},{0x00,0x00},
    {0x8c,0xcc},{0xf4,0x44},{0xf4,0x45},{0x00,0x00},{0xc4,0x60},
    {0x00,0x00},{0xf5,0xc9},{0x82,0x53},{0xc4,0xde},{0x00,0x00},
    {0xf5,0xca},{0x82,0xda},{0xf6,0xde},{0xc5,0x72},{0x82,0xdb},
    {0xc5,0x71},{0xf6,0xdd},{0xc5,0xc9},{0x9a,0x67},{0xf7,0xd6},
    {0x00,0x00},{0x00,0x00},{0xc6,0xcc},{0x00,0x00},{0xa4,0x74},
    {0xa6,0x7b},{0xc9,0xda},{0xca,0xca},{0xa8,0xb5},{0xb1,0x5f},
    {0x93,0x57},{0x00,0x00},{0xa4,0x75},{0xa5,0xaa},{0xa5,0xa9},
    {0xa5,0xa8},{0x88,0xb2},{0x00,0x00},{0xa7,0xc5},{0x00,0x00},
    {0x00,0x00},{0xae,0x74},{0x8e,0x43},{0xdd,0x57},{0xa4,0x76},
    {0xa4,0x77},{0xa4,0x78},{0xa4,0xda},{0xfb,0xfa},{0x00,0x00},
    {0xab,0xd1},{0x00,0x00},{0xce,0xaf},{0x00,0x00},{0x92,0x66},
    {0x00,0x00},{0xb4,0x53},{0xa4,0x79},{0xc9,0x5d},{0x00,0x00},
    {0x86,0xc5},{0xa5,0xab},{0xa5,0xac},{0xc9,0x78},{0x83,0x6c},
    {0xa6,0x7c},{0x00,0x00},{0x83,0xb6},{0x9a,0x68},{0xca,0xcb},
    {0xfb,0xfb},{0xa7,0xc6},{0x00,0x00},{0xca,0xcc},{0x84,0xd9},
    {0x84,0x44},{0xa9,0xae},{0xfb,0xfc},{0x00,0x00},{0xcc,0x6e},
    {0xa9,0xac},{0xa9,0xab},{0xcc,0x6d},{0xa9,0xa9},{0xcc,0x6f},
    {0xa9,0xaa},{0xa9,0xad},{0x87,0xc3},{0xab,0xd2},{0x00,0x00},
    {0xab,0xd4},{0xce,0xb3},{0xce,0xb0},{0xce,0xb1},{0xce,0xb2},
    {0xce,0xb4},{0xab,0xd3},{0x84,0x43},{0x84,0xd8},{0xd1,0x74},
    {0xd1,0x73},{0x00,0x00},{0xae,0x76},{0x00,0x00},{0xae,0x75},
    {0x89,0xd6},{0x93,0x67},{0x92,0x6f},{0x8f,0x50},{0x00,0x00},
    {0xb1,0x62},{0xd5,0x46},{0x00,0x00},{0xb1,0x61},{0xb1,0x63},
    {0xb1,0x60},{0x00,0x00},{0x00,0x00},{0x8e,0x68},{0x86,0xc6},
    {0xb4,0x55},{0xd5,0x45},{0x00,0x00},{0xb4,0x56},{0xd8,0xf3},
    {0x88,0xcb},{0xb4,0x57},{0xd8,0xf2},{0xb4,0x54},{0x00,0x00},
    {0x82,0xdc},{0x9a,0x69},{0x00,0x00},{0xdd,0x5a},{0xdd,0x5c},
    {0xb7,0x45},{0xdd,0x5b},{0xdd,0x59},{0xdd,0x58},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0xe1,0xb4},{0xb9,0xf7},{0xb9,0xf5},
    {0x00,0x00},{0xb9,0xf6},{0xe1,0xb2},{0xe1,0xb3},{0x00,0x00},
    {0xb9,0xf3},{0xe5,0x71},{0xe5,0x6f},{0xfb,0xfe},{0xbc,0x6d},
    {0xe5,0x70},{0xbc,0x6e},{0xbc,0x6c},{0xb9,0xf4},{0x82,0xdd},
    {0x00,0x00},{0xe9,0x6d},{0xe9,0x6b},{0xe9,0x6c},{0xe5,0x6e},
    {0xec,0xdc},{0xc0,0xb0},{0xec,0xdb},{0xef,0xc5},{0xef,0xc6},
    {0xe9,0x6e},{0xf1,0xfe},{0x00,0x00},{0xa4,0x7a},{0xa5,0xad},
    {0xa6,0x7e},{0xc9,0xdb},{0xa6,0x7d},{0x00,0x00},{0xa9,0xaf},
    {0xb7,0x46},{0xc6,0xcd},{0xa4,0xdb},{0xa5,0xae},{0xab,0xd5},
    {0xb4,0x58},{0xc6,0xce},{0xc9,0x79},{0x93,0x75},{0xc9,0x7a},
    {0x92,0xbe},{0xc9,0xdc},{0x00,0x00},{0x87,0xca},{0xa7,0xc8},
    {0xca,0xd0},{0xca,0xce},{0xa7,0xc9},{0xca,0xcd},{0xca,0xcf},
    {0xca,0xd1},{0x00,0x00},{0xa7,0xc7},{0x8b,0x72},{0x8e,0xb5},
    {0x9a,0x6a},{0x83,0xb7},{0x89,0xd8},{0xa9,0xb3},{0xa9,0xb4},
    {0xa9,0xb1},{0x00,0x00},{0x87,0xc6},{0xa9,0xb0},{0xce,0xb8},
    {0xa9,0xb2},{0x00,0x00},{0x8b,0x71},{0x87,0xc4},{0xab,0xd6},
    {0x00,0x00},{0xce,0xb7},{0xce,0xb9},{0xce,0xb6},{0xce,0xba},
    {0xab,0xd7},{0xae,0x79},{0xd1,0x75},{0x00,0x00},{0xd1,0x77},
    {0xae,0x77},{0xd1,0x78},{0xae,0x78},{0xd1,0x76},{0x00,0x00},
    {0xce,0xb5},{0xd5,0x47},{0xd5,0x4a},{0xd5,0x4b},{0xd5,0x48},
    {0xb1,0x67},{0xb1,0x66},{0xb1,0x64},{0xb1,0x65},{0xd5,0x49},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x9a,0x6b},{0xb1,0x68},
    {0x00,0x00},{0x00,0x00},{0xb4,0x5a},{0xb4,0x5b},{0x93,0xb2},
    {0xb4,0x5c},{0xdd,0x5d},{0xdd,0x5f},{0xdd,0x61},{0xb7,0x48},
    {0xb7,0x47},{0xb4,0x59},{0xdd,0x60},{0xdd,0x5e},{0xfe,0xa4},
    {0xe1,0xb8},{0x82,0xde},{0x82,0xdf},{0xe1,0xb6},{0xe1,0xbc},
    {0xb9,0xf8},{0xe1,0xbd},{0xe1,0xba},{0xb9,0xf9},{0xe1,0xb7},
    {0xe1,0xb5},{0xe1,0xbb},{0xbc,0x70},{0xe5,0x73},{0xe1,0xb9},
    {0xbc,0x72},{0xe5,0x74},{0xbc,0x71},{0xbc,0x74},{0xe5,0x75},
    {0xbc,0x6f},{0xbc,0x73},{0x00,0x00},{0xe9,0x73},{0xe9,0x71},
    {0xe9,0x70},{0xe9,0x72},{0xe9,0x6f},{0x82,0xe0},{0x00,0x00},
    {0xc3,0x66},{0x00,0x00},{0xf4,0x46},{0xf4,0x47},{0x82,0xe1},
    {0xf5,0xcb},{0xf6,0xdf},{0xc6,0x55},{0xc6,0xcf},{0x00,0x00},
    {0xa9,0xb5},{0xa7,0xca},{0x95,0xa4},{0x95,0xa1},{0xab,0xd8},
    {0x95,0xee},{0x95,0xfa},{0x00,0x00},{0xa4,0x7b},{0xa4,0xdc},
    {0x85,0x7b},{0xa5,0xaf},{0xc9,0xdd},{0x84,0x56},{0xa7,0xcb},
    {0xca,0xd2},{0x00,0x00},{0xce,0xbb},{0xab,0xd9},{0x82,0xe2},
    {0xb9,0xfa},{0xa4,0x7c},{0x82,0xe3},{0x95,0xaa},{0x9a,0x6c},
    {0xa6,0xa1},{0x93,0xae},{0x82,0xe4},{0xb7,0x49},{0xa4,0x7d},
    {0xa4,0xdd},{0xa4,0xde},{0x94,0x75},{0xa5,0xb1},{0xa5,0xb0},
    {0x00,0x00},{0xc9,0xde},{0xa6,0xa2},{0x00,0x00},{0xca,0xd3},
    {0x00,0x00},{0xa7,0xcc},{0x84,0x45},{0x82,0xe5},{0xcc,0x71},
    {0xcc,0x72},{0xcc,0x73},{0x93,0xf9},{0xa9,0xb6},{0xa9,0xb7},
    {0xcc,0x70},{0xa9,0xb8},{0x8d,0xc3},{0x00,0x00},{0x00,0x00},
    {0xab,0xda},{0xce,0xbc},{0x8c,0xce},{0xd1,0x7a},{0xae,0x7a},
    {0x00,0x00},{0xd1,0x79},{0x82,0xe6},{0xb1,0x69},{0xd5,0x4c},
    {0xb1,0x6a},{0xd5,0x4d},{0x87,0xc9},{0x84,0x46},{0x9d,0x7b},
    {0xb4,0x5d},{0x00,0x00},{0x93,0x71},{0x00,0x00},{0xdd,0x62},
    {0x82,0xe7},{0x00,0x00},{0xe1,0xbf},{0xe1,0xbe},{0x82,0xe8},
    {0xb9,0xfb},{0x00,0x00},{0xbc,0x75},{0xe5,0x76},{0xbe,0xca},
    {0xe9,0x74},{0xc0,0xb1},{0xfc,0x41},{0xc5,0x73},{0xf7,0xd8},
    {0xc6,0xd0},{0x82,0xe9},{0x8a,0xd0},{0x85,0xe5},{0xcc,0x74},
    {0x89,0xa3},{0xce,0xbd},{0xb1,0x6b},{0xd8,0xf4},{0xb7,0x4a},
    {0x00,0x00},{0x00,0x00},{0x82,0xea},{0xc2,0x55},{0xc2,0x55},
    {0x00,0x00},{0x00,0x00},{0xc6,0xd1},{0xa7,0xce},{0xfe,0xa8},
    {0xa7,0xcd},{0xab,0xdb},{0x82,0xeb},{0xd1,0x7b},{0x00,0x00},
    {0xb1,0x6d},{0xb3,0x43},{0xb1,0x6e},{0xb1,0x6c},{0xb4,0x5e},
    {0x00,0x00},{0xe1,0xc0},{0xb9,0xfc},{0xbc,0x76},{0x9a,0x6d},
    {0xc9,0x4c},{0xc9,0xdf},{0x00,0x00},{0xca,0xd5},{0xa7,0xcf},
    {0xca,0xd4},{0xa7,0xd0},{0x00,0x00},{0x86,0xc7},{0xa9,0xbc},
    {0xcc,0x77},{0xcc,0x76},{0xa9,0xbb},{0xa9,0xb9},{0xa9,0xba},
    {0xcc,0x75},{0x82,0xec},{0x92,0xa6},{0xab,0xdd},{0xce,0xbe},
    {0xab,0xe0},{0xab,0xdc},{0xab,0xe2},{0xab,0xde},{0xab,0xdf},
    {0xab,0xe1},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0xae,0x7d},
    {0xae,0x7c},{0xae,0x7b},{0x92,0xdc},{0x00,0x00},{0x84,0x48},
    {0xd5,0x4f},{0xb1,0x6f},{0xb1,0x72},{0xb1,0x70},{0x00,0x00},
    {0xd5,0x4e},{0xb1,0x75},{0x00,0x00},{0xb1,0x71},{0xd5,0x50},
    {0xb1,0x74},{0xb1,0x73},{0x00,0x00},{0x00,0x00},{0xfc,0x47},
    {0xd8,0xf6},{0xd8,0xf5},{0x95,0x5a},{0xb4,0x61},{0xb4,0x5f},
    {0xb4,0x60},{0xd8,0xf7},{0xb7,0x4b},{0xdd,0x64},{0xb7,0x4c},
    {0xdd,0x63},{0x00,0x00},{0x9a,0x6e},{0xe5,0x77},{0x93,0xa8},
    {0x93,0x76},{0xbc,0x78},{0xe1,0xc1},{0xbc,0x77},{0x00,0x00},
    {0xb9,0xfd},{0xfc,0x48},{0xec,0xde},{0xe9,0x75},{0xc0,0xb2},
    {0xec,0xdd},{0xf2,0x40},{0xf4,0x48},{0xf4,0x49},{0x9a,0x6f},
    {0xa4,0xdf},{0x9c,0xf5},{0xa5,0xb2},{0x88,0xda},{0x00,0x00},
    {0x00,0x00},{0xc9,0x7b},{0x00,0x00},{0x00,0x00},{0xa7,0xd2},
    {0xa7,0xd4},{0x00,0x00},{0xc9,0xe2},{0xca,0xd8},{0xca,0xd7},
    {0xca,0xd6},{0x00,0x00},{0xc9,0xe1},{0xc9,0xe0},{0xa6,0xa4},
    {0xa7,0xd3},{0xa7,0xd1},{0xa6,0xa3},{0x00,0x00},{0x9a,0x70},
    {0x92,0x4e},{0xa9,0xbd},{0xcc,0x78},{0x9a,0x71},{0xa9,0xbe},
    {0xca,0xdd},{0x00,0x00},{0xca,0xdf},{0xca,0xde},{0xcc,0x79},
    {0x00,0x00},{0x87,0xcc},{0xca,0xda},{0x00,0x00},{0xa7,0xd8},
    {0xa7,0xd6},{0x00,0x00},{0xca,0xd9},{0xca,0xdb},{0xca,0xe1},
    {0x82,0xed},{0xa7,0xd5},{0x00,0x00},{0xca,0xdc},{0xca,0xe5},
    {0xa9,0xc0},{0x00,0x00},{0xca,0xe2},{0xa7,0xd7},{0x00,0x00},
    {0xca,0xe0},{0xca,0xe3},{0x00,0x00},{0xa9,0xbf},{0x85,0xc7},
    {0xa9,0xc1},{0xca,0xe4},{0x86,0xc8},{0x87,0xcd},{0x87,0xd1},
    {0x8e,0x6b},{0x84,0x4a},{0x85,0xc8},{0x00,0x00},{0x00,0x00},
    {0xcc,0xaf},{0xcc,0xa2},{0xcc,0x7e},{0xcc,0xae},{0xcc,0xa9},
    {0xab,0xe7},{0xa9,0xc2},{0xcc,0xaa},{0xcc,0xad},{0xab,0xe3},
    {0xcc,0xac},{0xa9,0xc3},{0xa9,0xc8},{0xa9,0xc6},{0xcc,0xa3},
    {0x00,0x00},{0xcc,0x7c},{0xcc,0xa5},{0xa9,0xcd},{0xcc,0xb0},
    {0xab,0xe4},{0xcc,0xa6},{0x00,0x00},{0xab,0xe5},{0xa9,0xc9},
    {0xcc,0xa8},{0x9a,0x72},{0xce,0xcd},{0xab,0xe6},{0xcc,0x7b},
    {0xa9,0xca},{0xab,0xe8},{0xa9,0xcb},{0xa9,0xc7},{0xa9,0xcc},
    {0xcc,0xa7},{0xcc,0x7a},{0xcc,0xab},{0xa9,0xc4},{0x00,0x00},
    {0x95,0xa6},{0xcc,0x7d},{0xcc,0xa4},{0xcc,0xa1},{0xa9,0xc5},
    {0x00,0x00},{0xce,0xbf},{0x00,0x00},{0xce,0xc0},{0x94,0x76},
    {0x8a,0x4b},{0x8f,0x74},{0x00,0x00},{0x00,0x00},{0x8e,0xe7},
    {0xce,0xca},{0xd1,0xa1},{0xce,0xcb},{0xab,0xee},{0xce,0xce},
    {0xce,0xc4},{0xab,0xed},{0xce,0xc6},{0x00,0x00},{0xce,0xc7},
    {0x82,0xee},{0x8c,0xf6},{0xce,0xc9},{0xab,0xe9},{0x00,0x00},
    {0x00,0x00},{0xae,0xa3},{0x00,0x00},{0xf9,0xda},{0xce,0xc5},
    {0xce,0xc1},{0xae,0xa4},{0x00,0x00},{0x00,0x00},{0xce,0xcf},
    {0xae,0x7e},{0xd1,0x7d},{0xce,0xc8},{0x00,0x00},{0xd1,0x7c},
    {0xce,0xc3},{0xce,0xcc},{0x82,0xef},{0x00,0x00},{0xab,0xec},
    {0xae,0xa1},{0xab,0xf2},{0xae,0xa2},{0xce,0xd0},{0xd1,0x7e},
    {0xab,0xeb},{0xae,0xa6},{0xab,0xf1},{0xab,0xf0},{0xab,0xef},
    {0xae,0xa5},{0xce,0xd1},{0xae,0xa7},{0xab,0xea},{0x00,0x00},
    {0xce,0xc2},{0x89,0xd9},{0x00,0x00},{0x92,0xa8},{0x84,0xdc},
    {0xfc,0x4b},{0x86,0xca},{0x8f,0x51},{0x85,0xc9},{0x84,0xdf},
    {0x84,0xe0},{0x8d,0xdd},{0x9a,0x73},{0xb1,0x76},{0xd1,0xa4},
    {0xd1,0xa6},{0x00,0x00},{0xd1,0xa8},{0xae,0xa8},{0xae,0xae},
    {0xd5,0x53},{0xd1,0xac},{0xd1,0xa3},{0xb1,0x78},{0xd5,0x51},
    {0x82,0xf0},{0xae,0xad},{0xae,0xab},{0xd1,0xae},{0x00,0x00},
    {0xd5,0x52},{0x00,0x00},{0xd1,0xa5},{0x00,0x00},{0xae,0xac},
    {0xd1,0xa9},{0xae,0xaf},{0xd1,0xab},{0x00,0x00},{0x00,0x00},
    {0xae,0xaa},{0xd1,0xaa},{0xd1,0xad},{0xd1,0xa7},{0xfb,0x64},
    {0xae,0xa9},{0xb1,0x79},{0x00,0x00},{0xd1,0xa2},{0xb1,0x77},
    {0xfc,0x4c},{0x00,0x00},{0x82,0xf1},{0xfe,0xa6},{0xb1,0x7a},
    {0x93,0xaf},{0x92,0x41},{0x8e,0x69},{0x8b,0xf4},{0x8e,0x6a},
    {0x00,0x00},{0x87,0xce},{0xd5,0x55},{0xd5,0x5e},{0xb4,0x64},
    {0xfc,0x4d},{0xb1,0x7c},{0xb1,0xa3},{0xb4,0x65},{0xd5,0x60},
    {0xb1,0xaa},{0xd8,0xf9},{0xd5,0x56},{0xb1,0xa2},{0xb1,0xa5},
    {0xb1,0x7e},{0xd5,0x54},{0xd5,0x62},{0xd5,0x65},{0xd9,0x49},
    {0x00,0x00},{0xd5,0x63},{0xd8,0xfd},{0xb1,0xa1},{0xb1,0xa8},
    {0xb1,0xac},{0xd5,0x5d},{0xd8,0xf8},{0xd5,0x61},{0xb1,0x7b},
    {0xd8,0xfa},{0xd5,0x64},{0xd8,0xfc},{0xd5,0x59},{0x00,0x00},
    {0xb4,0x62},{0x00,0x00},{0xd5,0x57},{0xd5,0x58},{0xb1,0xa7},
    {0x00,0x00},{0x9a,0x74},{0xb1,0xa6},{0xd5,0x5b},{0xb1,0xab},
    {0xd5,0x5f},{0xb1,0xa4},{0xd5,0x5c},{0x82,0xf2},{0xb1,0xa9},
    {0xb4,0x66},{0xb4,0x63},{0xd8,0xfb},{0x82,0xad},{0xd5,0x5a},
    {0x00,0x00},{0xb1,0x7d},{0x8c,0x71},{0x86,0xcc},{0x8b,0x73},
    {0x00,0x00},{0x88,0xd8},{0x84,0xde},{0x86,0xcb},{0x87,0xcf},
    {0x86,0xc9},{0xb4,0x6b},{0xb4,0x6f},{0xd9,0x40},{0xb7,0x51},
    {0xb4,0x6d},{0xd9,0x44},{0xb4,0x71},{0xdd,0x65},{0xd9,0x46},
    {0xb7,0x53},{0xb4,0x69},{0xb4,0x6c},{0xd9,0x47},{0xfc,0x4e},
    {0xd9,0x48},{0xd9,0x4e},{0xb4,0x73},{0xb7,0x54},{0x00,0x00},
    {0xd9,0x4a},{0xd9,0x4f},{0xd9,0x43},{0xb7,0x5e},{0x9a,0x75},
    {0xb7,0x55},{0xb4,0x72},{0xd9,0x41},{0xd9,0x50},{0x9a,0x76},
    {0xb7,0x5d},{0xb4,0x70},{0xb7,0x4e},{0xd9,0x4d},{0x82,0xf3},
    {0xb4,0x74},{0xd9,0x45},{0xd8,0xfe},{0xb4,0x6a},{0xd9,0x42},
    {0x00,0x00},{0xd9,0x4b},{0x9a,0x77},{0xb7,0x4d},{0xb7,0x52},
    {0xb4,0x67},{0xd9,0x4c},{0x00,0x00},{0xb7,0x50},{0x82,0xf4},
    {0x82,0xf5},{0x9a,0x78},{0xb4,0x68},{0x87,0xd0},{0x00,0x00},
    {0x8e,0xb6},{0xb7,0x5c},{0xe1,0xc3},{0xdd,0x70},{0x00,0x00},
    {0xdd,0x68},{0xe1,0xc2},{0x00,0x00},{0xdd,0x6c},{0xdd,0x6e},
    {0xfc,0x4f},{0x00,0x00},{0xdd,0x6b},{0x00,0x00},{0xb7,0x5b},
    {0x00,0x00},{0xdd,0x6a},{0xb7,0x5f},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0xe1,0xd2},{0x82,0xf6},{0x82,0xf7},{0xb7,0x5a},
    {0xba,0x40},{0xdd,0x71},{0xe1,0xc4},{0xfc,0xc9},{0x00,0x00},
    {0xb7,0x58},{0xdd,0x69},{0xdd,0x6d},{0xb9,0xfe},{0xb7,0x4f},
    {0xdd,0x66},{0xdd,0x67},{0xba,0x41},{0xb7,0x57},{0xb7,0x59},
    {0xb7,0x56},{0xdd,0x6f},{0x9a,0x79},{0x8c,0x72},{0xe1,0xc8},
    {0xe1,0xc9},{0xe1,0xce},{0xbc,0x7d},{0xe1,0xd5},{0x00,0x00},
    {0xba,0x47},{0xfc,0x52},{0xba,0x46},{0xe1,0xd0},{0xfc,0x54},
    {0xbc,0x7c},{0xe1,0xc5},{0xba,0x45},{0x9a,0x7a},{0xe1,0xd4},
    {0xba,0x43},{0xba,0x44},{0x95,0xad},{0xe1,0xd1},{0xe5,0xaa},
    {0xbc,0x7a},{0xb4,0x6e},{0x00,0x00},{0xe1,0xd3},{0xbc,0xa3},
    {0xe1,0xcb},{0x00,0x00},{0xbc,0x7b},{0x95,0x66},{0xbc,0xa2},
    {0xe1,0xc6},{0xe1,0xca},{0xe1,0xc7},{0xe1,0xcd},{0xba,0x48},
    {0xbc,0x79},{0xba,0x42},{0x00,0x00},{0xe5,0x7a},{0xe1,0xcf},
    {0x00,0x00},{0xbc,0xa1},{0xfc,0x53},{0xbc,0xa4},{0x00,0x00},
    {0xe1,0xcc},{0x9a,0x7b},{0xbc,0x7e},{0xe5,0x79},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x95,0xd1},{0x00,0x00},{0xe5,0x7e},
    {0xbe,0xce},{0xe5,0x78},{0xe9,0xa3},{0xe5,0xa9},{0xbc,0xa8},
    {0x00,0x00},{0xbc,0xa6},{0xbe,0xcc},{0xe5,0xa6},{0xe5,0xa2},
    {0xbc,0xac},{0x9a,0x7c},{0xe9,0x78},{0x00,0x00},{0x82,0xf8},
    {0xfe,0x74},{0xbc,0xaa},{0xe5,0xa1},{0xfc,0x51},{0xe9,0x76},
    {0x00,0x00},{0xe5,0xa5},{0x00,0x00},{0xe5,0xa8},{0xe5,0x7d},
    {0x00,0x00},{0xbc,0xab},{0x00,0x00},{0x00,0x00},{0xbc,0xa5},
    {0xe9,0x77},{0xbe,0xcd},{0xe5,0xa7},{0xbc,0xa7},{0xbc,0xa9},
    {0xe5,0xa4},{0xbc,0xad},{0xe5,0xa3},{0xe5,0x7c},{0xe5,0x7b},
    {0xbe,0xcb},{0xe5,0xab},{0xe9,0x7a},{0xec,0xe0},{0xbe,0xd0},
    {0x82,0xf9},{0xe9,0xa2},{0x9a,0x7d},{0xe9,0x7e},{0x00,0x00},
    {0xec,0xe1},{0x00,0x00},{0xbe,0xd1},{0xe9,0xa1},{0x9a,0x7e},
    {0xe9,0x7c},{0xc0,0xb4},{0xec,0xdf},{0x00,0x00},{0xe9,0x79},
    {0xe9,0x7b},{0xc0,0xb5},{0xbe,0xd3},{0xc0,0xb3},{0xbe,0xd2},
    {0xc0,0xb7},{0xe9,0x7d},{0xbe,0xcf},{0x00,0x00},{0x9a,0xa1},
    {0x92,0x5d},{0x8a,0xc2},{0x8b,0x75},{0x9a,0xa2},{0x88,0xd9},
    {0x00,0x00},{0xef,0xcf},{0x00,0x00},{0xef,0xc7},{0x00,0x00},
    {0x9a,0xa3},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0xec,0xe7},
    {0xef,0xc8},{0xec,0xe3},{0x00,0x00},{0xfc,0x56},{0xc2,0x56},
    {0xec,0xe5},{0xec,0xe4},{0xc0,0xb6},{0xec,0xe2},{0xec,0xe6},
    {0xef,0xd0},{0xef,0xcc},{0xef,0xce},{0x00,0x00},{0xef,0xc9},
    {0xef,0xca},{0x00,0x00},{0xef,0xcd},{0xef,0xcb},{0xc3,0x67},
    {0x00,0x00},{0x82,0xfa},{0xc3,0x6a},{0xc3,0x69},{0xc3,0x68},
    {0xc4,0x61},{0xf4,0x4a},{0xc4,0x62},{0xf2,0x41},{0xc4,0xdf},
    {0xf5,0xcc},{0xc4,0xe0},{0xc5,0x74},{0xc5,0xca},{0xf7,0xd9},
    {0x00,0x00},{0xf7,0xda},{0xf7,0xdb},{0x00,0x00},{0x90,0xab},
    {0xf9,0xba},{0xa4,0xe0},{0xc9,0x7c},{0xa5,0xb3},{0x8d,0xb8},
    {0xa6,0xa6},{0xa6,0xa7},{0xa6,0xa5},{0x89,0xda},{0xa6,0xa8},
    {0xa7,0xda},{0xa7,0xd9},{0x82,0xfb},{0xcc,0xb1},{0xa9,0xcf},
    {0xa9,0xce},{0x8e,0x6d},{0x88,0xdb},{0xd1,0xaf},{0xb1,0xad},
    {0xb1,0xae},{0x00,0x00},{0x82,0xfc},{0x82,0xfd},{0xb4,0x75},
    {0xdd,0x72},{0xb7,0x60},{0xb7,0x61},{0xdd,0x74},{0xdd,0x76},
    {0xdd,0x75},{0x93,0x49},{0xe1,0xd7},{0x00,0x00},{0xe1,0xd6},
    {0xba,0x49},{0xe1,0xd8},{0x8e,0x6c},{0xe5,0xac},{0xbc,0xae},
    {0x92,0x70},{0xbe,0xd4},{0x00,0x00},{0xc0,0xb8},{0xc2,0x57},
    {0xc0,0xb9},{0x00,0x00},{0xa4,0xe1},{0x82,0xfe},{0x90,0xbd},
    {0xfc,0x58},{0xca,0xe6},{0x93,0xec},{0x00,0x00},{0xcc,0xb2},
    {0xa9,0xd1},{0xa9,0xd0},{0xa9,0xd2},{0xab,0xf3},{0xce,0xd2},
    {0xce,0xd3},{0x00,0x00},{0x00,0x00},{0xd1,0xb0},{0xae,0xb0},
    {0xb1,0xaf},{0xb4,0x76},{0xd9,0x51},{0xa4,0xe2},{0x9c,0xf2},
    {0xa4,0x7e},{0xa4,0xe3},{0x00,0x00},{0xc9,0x7d},{0xa5,0xb7},
    {0xa5,0xb6},{0xa5,0xb4},{0xa5,0xb5},{0x93,0xc1},{0x00,0x00},
    {0x00,0x00},{0xa6,0xab},{0xc9,0xe9},{0xc9,0xeb},{0xa6,0xaa},
    {0xc9,0xe3},{0x00,0x00},{0xc9,0xe4},{0x00,0x00},{0xc9,0xea},
    {0xc9,0xe6},{0xc9,0xe8},{0xa6,0xa9},{0xc9,0xe5},{0xc9,0xec},
    {0xc9,0xe7},{0x83,0xf9},{0xfc,0x59},{0x8a,0xc3},{0x84,0x4d},
    {0x84,0x4b},{0x84,0xe4},{0xa7,0xe1},{0xa7,0xea},{0xa7,0xe8},
    {0xca,0xf0},{0xca,0xed},{0xca,0xf5},{0xa7,0xe6},{0xca,0xf6},
    {0x00,0x00},{0xa7,0xdf},{0xca,0xf3},{0x00,0x00},{0xa7,0xe5},
    {0xca,0xef},{0xca,0xee},{0xa7,0xe3},{0xca,0xf4},{0xa7,0xe4},
    {0xa9,0xd3},{0xa7,0xde},{0xca,0xf1},{0xfc,0x5b},{0xca,0xe7},
    {0xa7,0xdb},{0xfc,0x5a},{0xa7,0xee},{0xca,0xec},{0xca,0xf2},
    {0xa7,0xe0},{0xa7,0xe2},{0x00,0x00},{0xca,0xe8},{0x00,0x00},
    {0xca,0xe9},{0xca,0xea},{0x9a,0xa4},{0xa7,0xed},{0xa7,0xe7},
    {0xa7,0xec},{0xca,0xeb},{0xa7,0xeb},{0xa7,0xdd},{0xa7,0xdc},
    {0xa7,0xe9},{0x00,0x00},{0x87,0xd7},{0x90,0xbe},{0x93,0xbb},
    {0xfd,0x57},{0x93,0x6a},{0x8e,0x6e},{0x8e,0x6f},{0x84,0x4e},
    {0x85,0xcb},{0x00,0x00},{0x8c,0xa8},{0x84,0xd2},{0xfc,0x5c},
    {0x00,0x00},{0xa9,0xe1},{0xcc,0xbe},{0xcc,0xb7},{0xa9,0xdc},
    {0xa9,0xef},{0xcc,0xb3},{0xcc,0xba},{0xcc,0xbc},{0xcc,0xbf},
    {0xa9,0xea},{0x00,0x00},{0xcc,0xbb},{0xcc,0xb4},{0xa9,0xe8},
    {0xcc,0xb8},{0x00,0x00},{0xcc,0xc0},{0xa9,0xd9},{0x00,0x00},
    {0xcc,0xbd},{0xa9,0xe3},{0xa9,0xe2},{0xcc,0xb6},{0xa9,0xd7},
    {0x00,0x00},{0x00,0x00},{0xa9,0xd8},{0xfb,0x46},{0xa9,0xd6},
    {0x88,0xe3},{0xa9,0xee},{0xa9,0xe6},{0xa9,0xe0},{0xa9,0xd4},
    {0xcc,0xb9},{0xa9,0xdf},{0xa9,0xd5},{0xa9,0xe7},{0xa9,0xf0},
    {0xce,0xd4},{0xa9,0xe4},{0xcc,0xb5},{0xa9,0xda},{0xa9,0xdd},
    {0xa9,0xde},{0xfc,0x5d},{0xa9,0xec},{0xa9,0xed},{0xa9,0xeb},
    {0xa9,0xe5},{0xa9,0xe9},{0xa9,0xdb},{0xab,0xf4},{0x93,0xb1},
    {0x00,0x00},{0x89,0xde},{0x92,0x75},{0x92,0x5e},{0x8b,0x76},
    {0x84,0xe1},{0x00,0x00},{0x88,0xdc},{0x8b,0xf6},{0x89,0xdd},
    {0x87,0xd5},{0x88,0xe1},{0x00,0x00},{0xce,0xda},{0xac,0x41},
    {0xab,0xf8},{0xab,0xfa},{0xac,0x40},{0xce,0xe6},{0xab,0xfd},
    {0xd1,0xb1},{0xae,0xb1},{0xac,0x43},{0xce,0xd7},{0xce,0xdf},
    {0xab,0xfe},{0xce,0xde},{0xce,0xdb},{0xce,0xe3},{0xce,0xe5},
    {0xab,0xf7},{0xab,0xfb},{0xac,0x42},{0xae,0xb3},{0xce,0xe0},
    {0xab,0xf9},{0xac,0x45},{0xce,0xd9},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0xab,0xfc},{0xae,0xb2},{0xab,0xf6},{0x00,0x00},
    {0xce,0xd6},{0xce,0xdd},{0xce,0xd5},{0xce,0xd8},{0xce,0xdc},
    {0xd1,0xb2},{0xac,0x44},{0x00,0x00},{0xce,0xe1},{0xce,0xe2},
    {0xce,0xe4},{0xab,0xf5},{0x00,0x00},{0x94,0xf4},{0x92,0x76},
    {0x87,0xd2},{0x8c,0xf7},{0x00,0x00},{0x88,0xe4},{0x88,0xde},
    {0x83,0xb9},{0x87,0xd6},{0x88,0xdd},{0x8e,0xb7},{0x84,0x4f},
    {0x89,0xdc},{0x84,0xe2},{0x00,0x00},{0x90,0xbf},{0xae,0xc1},
    {0xd1,0xbe},{0xae,0xbf},{0xae,0xc0},{0xd1,0xb4},{0xd1,0xc4},
    {0xa0,0x5e},{0xae,0xb6},{0x00,0x00},{0x9a,0xa5},{0xd5,0x66},
    {0xd1,0xc6},{0xd1,0xc0},{0xfc,0x5f},{0xd1,0xb7},{0x9a,0xa7},
    {0xd1,0xc9},{0xd1,0xba},{0xae,0xbc},{0xd5,0x7d},{0xd1,0xbd},
    {0xae,0xbe},{0xae,0xb5},{0x93,0x56},{0xd1,0xcb},{0xd1,0xbf},
    {0xae,0xb8},{0xd1,0xb8},{0xd1,0xb5},{0xd1,0xb6},{0xae,0xb9},
    {0xd1,0xc5},{0xd1,0xcc},{0xae,0xbb},{0xd1,0xbc},{0xd1,0xbb},
    {0xae,0xc3},{0xae,0xc2},{0xae,0xb4},{0xae,0xba},{0xae,0xbd},
    {0xd1,0xc8},{0x00,0x00},{0x00,0x00},{0xd1,0xc2},{0xae,0xb7},
    {0xd1,0xb3},{0xd1,0xca},{0xd1,0xc1},{0xd1,0xc3},{0xd1,0xc7},
    {0x00,0x00},{0x93,0x55},{0x00,0x00},{0x87,0xd4},{0x85,0xca},
    {0x00,0x00},{0x88,0xe2},{0x84,0xe3},{0x85,0xcc},{0xfc,0x5e},
    {0xd5,0x67},{0x00,0x00},{0xb1,0xb7},{0xb1,0xcb},{0xb1,0xca},
    {0x00,0x00},{0xb1,0xbf},{0x95,0x59},{0xd5,0x79},{0xd5,0x75},
    {0xd5,0x72},{0xd5,0xa6},{0xb1,0xba},{0xb1,0xb2},{0x00,0x00},
    {0x00,0x00},{0xd5,0x77},{0xb4,0xa8},{0xb1,0xb6},{0xd5,0xa1},
    {0x9a,0xa8},{0xb1,0xcc},{0xb1,0xc9},{0xd5,0x7b},{0xd5,0x6a},
    {0x00,0x00},{0xfc,0x55},{0xb1,0xc8},{0xd5,0xa3},{0xd5,0x69},
    {0xb1,0xbd},{0xb1,0xc1},{0xd5,0xa2},{0x00,0x00},{0xd5,0x73},
    {0xb1,0xc2},{0xb1,0xbc},{0xd5,0x68},{0x9a,0xa9},{0xb4,0x78},
    {0xd5,0xa5},{0xd5,0x71},{0xb1,0xc7},{0xd5,0x74},{0xd5,0xa4},
    {0xb1,0xc6},{0x00,0x00},{0xd9,0x52},{0x00,0x00},{0xb1,0xb3},
    {0xd5,0x6f},{0xb1,0xb8},{0xb1,0xc3},{0x00,0x00},{0xb1,0xbe},
    {0xd5,0x78},{0xd5,0x6e},{0xd5,0x6c},{0xd5,0x7e},{0xb1,0xb0},
    {0xb1,0xc4},{0xb1,0xb4},{0xb4,0x77},{0xd5,0x7c},{0xb1,0xb5},
    {0x00,0x00},{0xb1,0xb1},{0xb1,0xc0},{0xb1,0xbb},{0xb1,0xb9},
    {0xd5,0x70},{0xb1,0xc5},{0xd5,0x6d},{0xd5,0x7a},{0xd5,0x76},
    {0xd9,0x54},{0xd9,0x53},{0x92,0xa9},{0x88,0xe0},{0x86,0xce},
    {0x94,0x77},{0x00,0x00},{0x8a,0xc4},{0x87,0xd8},{0xfb,0x57},
    {0x86,0xcf},{0x90,0xc0},{0x8e,0x70},{0xd5,0x6b},{0xd9,0x64},
    {0x00,0x00},{0xb4,0x7a},{0x9a,0xaa},{0xd9,0x6a},{0xd9,0x59},
    {0xd9,0x67},{0xdd,0x77},{0xb4,0x7d},{0xd9,0x6b},{0xd9,0x6e},
    {0xb4,0x7c},{0xd9,0x5c},{0xd9,0x6d},{0xd9,0x6c},{0xb4,0x7e},
    {0xd9,0x55},{0xb4,0x79},{0xb4,0xa3},{0xfd,0x6c},{0xb4,0xa1},
    {0xd9,0x69},{0x00,0x00},{0xd9,0x5f},{0xb4,0xa5},{0xd9,0x70},
    {0xd9,0x68},{0xd9,0x71},{0xb4,0xad},{0xb4,0xab},{0xd9,0x66},
    {0xd9,0x65},{0x90,0xc1},{0xd9,0x63},{0xd9,0x5d},{0xb4,0xa4},
    {0x9a,0xab},{0xb4,0xa2},{0xd1,0xb9},{0xd9,0x56},{0x9a,0xac},
    {0xdd,0xb7},{0xd9,0x57},{0xb4,0x7b},{0xb4,0xaa},{0xdd,0x79},
    {0x00,0x00},{0xb4,0xa6},{0xb4,0xa7},{0xd9,0x58},{0xd9,0x6f},
    {0xdd,0x78},{0xd9,0x60},{0xd9,0x5b},{0xb4,0xa9},{0xd9,0x61},
    {0xd9,0x5e},{0x00,0x00},{0xa0,0x5f},{0xb4,0xae},{0x90,0xc2},
    {0x9a,0xad},{0xfb,0x5d},{0x8d,0x53},{0x9a,0xae},{0x87,0xd9},
    {0x8b,0xf7},{0x89,0xdf},{0x86,0xcd},{0x00,0x00},{0x00,0x00},
    {0x8c,0xf8},{0xb7,0x70},{0x9a,0xaf},{0x00,0x00},{0xdd,0x7c},
    {0xdd,0xb1},{0xdd,0xb6},{0xdd,0xaa},{0xb7,0x6c},{0xdd,0xbb},
    {0xb7,0x69},{0xdd,0x7a},{0x00,0x00},{0xdd,0x7b},{0xb7,0x62},
    {0xb7,0x6b},{0xdd,0xa4},{0xb7,0x6e},{0xb7,0x6f},{0xdd,0xa5},
    {0x00,0x00},{0xdd,0xb2},{0xdd,0xb8},{0xb7,0x6a},{0x00,0x00},
    {0xb7,0x64},{0xdd,0xa3},{0xdd,0x7d},{0xdd,0xba},{0xdd,0xa8},
    {0xdd,0xa9},{0xdd,0x7e},{0xdd,0xb4},{0xdd,0xab},{0xdd,0xb5},
    {0xdd,0xad},{0x00,0x00},{0xb7,0x65},{0xe1,0xd9},{0xb7,0x68},
    {0xb7,0x66},{0xdd,0xb9},{0xdd,0xb0},{0xdd,0xac},{0x00,0x00},
    {0x9a,0xb0},{0xdd,0xa1},{0xba,0x53},{0xdd,0xaf},{0xb7,0x6d},
    {0xdd,0xa7},{0x9a,0xb1},{0xdd,0xa6},{0x8c,0x74},{0x9a,0xb2},
    {0x00,0x00},{0xb7,0x67},{0xb7,0x63},{0xe1,0xee},{0xdd,0xb3},
    {0xdd,0xae},{0x93,0x45},{0xdd,0xa2},{0x8c,0x73},{0x8f,0x75},
    {0x8a,0xc7},{0x93,0xda},{0x8f,0x52},{0x00,0x00},{0x8c,0xcf},
    {0xe1,0xe9},{0x00,0x00},{0xe1,0xda},{0xe1,0xe5},{0x00,0x00},
    {0xe1,0xec},{0xba,0x51},{0xb4,0xac},{0xe1,0xea},{0xba,0x4c},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0xba,0x4b},{0xe1,0xf1},
    {0x9a,0xb3},{0xe1,0xdb},{0xe1,0xe8},{0xe1,0xdc},{0xe1,0xe7},
    {0xba,0x4f},{0xe1,0xeb},{0xd9,0x62},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0xe1,0xf2},{0xe1,0xe3},{0xba,0x52},{0xe5,0xba},
    {0xbc,0xaf},{0x00,0x00},{0xe1,0xf0},{0xe1,0xef},{0xba,0x54},
    {0xe5,0xad},{0xbc,0xb0},{0xe5,0xae},{0x9a,0xb4},{0xe1,0xdf},
    {0xe1,0xe0},{0xe1,0xdd},{0xe1,0xe2},{0xe1,0xde},{0xe1,0xf3},
    {0xba,0x4e},{0xbc,0xb1},{0xba,0x50},{0xba,0x55},{0x9a,0xb5},
    {0xe1,0xe1},{0x00,0x00},{0xe1,0xed},{0x00,0x00},{0x00,0x00},
    {0xe1,0xe6},{0x92,0xb0},{0x8f,0xda},{0xe5,0xb1},{0x00,0x00},
    {0xba,0x4a},{0xbc,0xb4},{0xe9,0xaa},{0xe5,0xb6},{0xe5,0xb5},
    {0xe5,0xb7},{0x9a,0xb6},{0x00,0x00},{0xe5,0xb4},{0xbc,0xb5},
    {0x90,0xc3},{0xbc,0xbb},{0xbc,0xb8},{0x00,0x00},{0xbc,0xb9},
    {0xe5,0xaf},{0xe5,0xb2},{0xe5,0xbc},{0xbc,0xc1},{0xbc,0xbf},
    {0x00,0x00},{0xe5,0xb3},{0xd9,0x5a},{0xbc,0xb2},{0xe5,0xb9},
    {0xe5,0xb0},{0x00,0x00},{0xbc,0xc2},{0xe5,0xb8},{0xba,0x4d},
    {0xbc,0xb7},{0xe1,0xe4},{0x00,0x00},{0x00,0x00},{0xbc,0xba},
    {0x00,0x00},{0xbc,0xbe},{0xbc,0xc0},{0xbc,0xbd},{0xbc,0xbc},
    {0x9a,0xb7},{0xbc,0xb6},{0xe5,0xbb},{0xbc,0xb3},{0xbc,0xc3},
    {0x9a,0xb8},{0x8a,0xc6},{0x9a,0xb9},{0x8a,0xc9},{0x8f,0x76},
    {0x82,0x4d},{0x8f,0xfe},{0xbe,0xd8},{0xbe,0xd9},{0xe9,0xa9},
    {0xbe,0xe2},{0xbe,0xdf},{0x90,0xc4},{0xbe,0xd6},{0xbe,0xdd},
    {0xe9,0xab},{0xbe,0xdb},{0xbe,0xd5},{0x00,0x00},{0xbe,0xdc},
    {0x00,0x00},{0xe9,0xa8},{0xc0,0xbb},{0xbe,0xd7},{0x00,0x00},
    {0xbe,0xde},{0xc0,0xba},{0xe9,0xa7},{0xe9,0xa6},{0x00,0x00},
    {0xbe,0xe0},{0xa0,0x5d},{0xbe,0xe1},{0x00,0x00},{0xe9,0xa5},
    {0xe9,0xa4},{0xc0,0xbc},{0xe9,0xae},{0xbe,0xda},{0xe9,0xac},
    {0x00,0x00},{0x9a,0xba},{0x8a,0xc8},{0x00,0x00},{0xc0,0xbd},
    {0x90,0xc5},{0xc0,0xc2},{0xec,0xea},{0xec,0xec},{0x9a,0xbb},
    {0xc0,0xbf},{0xfb,0xa3},{0xec,0xed},{0xec,0xe9},{0x95,0xc8},
    {0xec,0xeb},{0xc0,0xc0},{0xc0,0xc3},{0x00,0x00},{0xec,0xe8},
    {0xc0,0xbe},{0xc0,0xc1},{0xc2,0x59},{0xe9,0xad},{0xc2,0x58},
    {0x00,0x00},{0x90,0xc6},{0xc2,0x5e},{0xef,0xd4},{0x00,0x00},
    {0xc2,0x5c},{0xc2,0x5d},{0xef,0xd7},{0xef,0xd3},{0xc2,0x5a},
    {0xef,0xd1},{0xc3,0x6b},{0xef,0xd5},{0x00,0x00},{0xef,0xd6},
    {0xef,0xd2},{0x90,0xc7},{0xc2,0x5b},{0xf2,0x42},{0x00,0x00},
    {0xf2,0x45},{0x9a,0xbc},{0x00,0x00},{0xf2,0x46},{0xf2,0x44},
    {0xf2,0x47},{0xc3,0x6c},{0xf2,0x43},{0x9a,0xbd},{0x90,0x57},
    {0xf4,0x4e},{0xc4,0x64},{0xf4,0x4d},{0xf4,0x4c},{0xf4,0x4b},
    {0xc4,0x63},{0xc4,0x65},{0x00,0x00},{0xf5,0xcd},{0xc4,0xe2},
    {0xc4,0xe1},{0xa0,0x60},{0x9a,0xbe},{0xf6,0xe1},{0xf6,0xe0},
    {0xf6,0xe3},{0xc5,0xcb},{0xc5,0x75},{0xf7,0xdd},{0xf6,0xe2},
    {0x00,0x00},{0x00,0x00},{0xf7,0xdc},{0xc5,0xcd},{0xc5,0xcc},
    {0xc5,0xf3},{0xf8,0xa9},{0xf8,0xef},{0xa4,0xe4},{0xfe,0x5b},
    {0x00,0x00},{0xd9,0x72},{0xe9,0xaf},{0xc6,0xd2},{0x90,0xc8},
    {0xa6,0xac},{0xca,0xf7},{0xa7,0xf1},{0xa7,0xef},{0x00,0x00},
    {0xa7,0xf0},{0x00,0x00},{0xcc,0xc1},{0xa9,0xf1},{0xac,0x46},
    {0x00,0x00},{0xce,0xe7},{0x00,0x00},{0xce,0xe8},{0x00,0x00},
    {0xac,0x47},{0xd1,0xce},{0x00,0x00},{0xae,0xc4},{0xae,0xc5},
    {0xd1,0xcd},{0x00,0x00},{0x87,0xda},{0x95,0xb4},{0x90,0xc9},
    {0xb1,0xd3},{0x00,0x00},{0xb1,0xcf},{0x00,0x00},{0xd5,0xa7},
    {0xb1,0xd6},{0xb1,0xd5},{0xb1,0xce},{0xb1,0xd1},{0xb1,0xd4},
    {0xb1,0xd0},{0x00,0x00},{0x89,0xe0},{0xd9,0x76},{0xb1,0xcd},
    {0xb4,0xaf},{0x9a,0xbf},{0x00,0x00},{0x00,0x00},{0xb4,0xb1},
    {0xb4,0xb2},{0xd9,0x75},{0xd9,0x78},{0xb4,0xb0},{0xd9,0x73},
    {0xd9,0x77},{0x00,0x00},{0xd9,0x74},{0x90,0xca},{0xb7,0x71},
    {0x9a,0xc0},{0x00,0x00},{0xdd,0xbc},{0x87,0xdb},{0x00,0x00},
    {0xba,0x56},{0xe1,0xf4},{0xbe,0xe3},{0xbc,0xc4},{0xe5,0xbd},
    {0xbc,0xc5},{0xbc,0xc6},{0xe5,0xbf},{0xe5,0xbe},{0xe5,0xc0},
    {0xe9,0xb1},{0x00,0x00},{0x00,0x00},{0xe9,0xb0},{0xec,0xef},
    {0xec,0xee},{0xc0,0xc4},{0xc0,0xc5},{0xf2,0x48},{0xfc,0xb7},
    {0x9a,0xc1},{0xa4,0xe5},{0x90,0xcb},{0x93,0x42},{0x00,0x00},
    {0x8a,0xbc},{0xd9,0x79},{0x00,0x00},{0x92,0xc7},{0x00,0x00},
    {0xb4,0xb4},{0xb4,0xb3},{0xdd,0xbd},{0x8c,0x75},{0xef,0xd8},
    {0xc4,0xe3},{0xf7,0xde},{0xa4,0xe6},{0x00,0x00},{0xae,0xc6},
    {0x00,0x00},{0xb1,0xd8},{0xb1,0xd7},{0xd9,0x7a},{0xd9,0x7b},
    {0xb7,0x72},{0xe1,0xf5},{0xba,0x57},{0xe9,0xb2},{0x00,0x00},
    {0xa4,0xe7},{0xa5,0xb8},{0x00,0x00},{0xa9,0xf2},{0xcc,0xc2},
    {0x84,0x53},{0xce,0xe9},{0xac,0x48},{0xb1,0xd9},{0x8a,0xca},
    {0xd9,0x7c},{0xb4,0xb5},{0xb7,0x73},{0x00,0x00},{0xe5,0xc1},
    {0xe5,0xc2},{0x00,0x00},{0x9a,0xc2},{0xec,0xf0},{0xc2,0x5f},
    {0xf8,0xf0},{0xa4,0xe8},{0x00,0x00},{0xcc,0xc3},{0xa9,0xf3},
    {0xac,0x49},{0x9a,0xc3},{0xce,0xea},{0x00,0x00},{0xae,0xc7},
    {0xd1,0xd2},{0xd1,0xd0},{0xd1,0xd1},{0xae,0xc8},{0xd1,0xcf},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0xb1,0xdb},
    {0xb1,0xdc},{0xd5,0xa8},{0xb1,0xdd},{0xb1,0xda},{0xd9,0x7d},
    {0x9a,0xc4},{0xd9,0x7e},{0xdd,0xbe},{0x9a,0xc5},{0x00,0x00},
    {0xba,0x59},{0xba,0x58},{0x00,0x00},{0x90,0xcc},{0xec,0xf1},
    {0xef,0xd9},{0x00,0x00},{0xf2,0x4a},{0xf2,0x49},{0xf4,0x4f},
    {0xc6,0xd3},{0xc9,0x5e},{0xac,0x4a},{0x9a,0xc6},{0x00,0x00},
    {0xa4,0xe9},{0xa5,0xb9},{0x8a,0xf6},{0xa6,0xae},{0xa6,0xad},
    {0x00,0x00},{0x00,0x00},{0xa6,0xaf},{0xa6,0xb0},{0xc9,0xee},
    {0xc9,0xed},{0xca,0xf8},{0xa7,0xf2},{0xca,0xfb},{0xca,0xfa},
    {0xca,0xf9},{0xca,0xfc},{0x83,0xba},{0x8b,0x77},{0x85,0xd0},
    {0x00,0x00},{0xa9,0xf4},{0xcc,0xc9},{0xcc,0xc5},{0xcc,0xce},
    {0x00,0x00},{0x9a,0xc7},{0xa9,0xfb},{0x00,0x00},{0xa9,0xf9},
    {0xcc,0xca},{0xcc,0xc6},{0xcc,0xcd},{0xa9,0xf8},{0xaa,0x40},
    {0xcc,0xc8},{0xcc,0xc4},{0xa9,0xfe},{0xcc,0xcb},{0xa9,0xf7},
    {0xcc,0xcc},{0xa9,0xfa},{0xa9,0xfc},{0xcc,0xd0},{0xcc,0xcf},
    {0xcc,0xc7},{0xa9,0xf6},{0xa9,0xf5},{0xa9,0xfd},{0x00,0x00},
    {0x00,0x00},{0x9a,0xc8},{0x88,0xe8},{0x00,0x00},{0x00,0x00},
    {0xce,0xef},{0xce,0xf5},{0x90,0xcd},{0xac,0x50},{0xac,0x4d},
    {0xce,0xec},{0xce,0xf1},{0x9a,0xc9},{0xac,0x53},{0xac,0x4b},
    {0xce,0xf0},{0xac,0x4e},{0xac,0x51},{0x00,0x00},{0x00,0x00},
    {0xce,0xf3},{0x00,0x00},{0xac,0x4c},{0xce,0xf8},{0xac,0x4f},
    {0x95,0xfe},{0xac,0x52},{0xce,0xed},{0xce,0xf2},{0xce,0xf6},
    {0xce,0xee},{0xce,0xeb},{0x00,0x00},{0x00,0x00},{0xce,0xf7},
    {0xce,0xf4},{0x90,0xce},{0x84,0x54},{0x00,0x00},{0x8d,0x46},
    {0x90,0xcf},{0x00,0x00},{0xae,0xd0},{0xae,0xc9},{0xae,0xcc},
    {0x90,0xd0},{0xae,0xcf},{0x00,0x00},{0xd1,0xd5},{0xfc,0x62},
    {0xae,0xca},{0xd1,0xd3},{0x83,0xbb},{0xae,0xce},{0x9d,0x59},
    {0x00,0x00},{0xae,0xcb},{0x00,0x00},{0xd1,0xd6},{0xae,0xcd},
    {0x88,0xe6},{0x88,0xe7},{0x85,0xcf},{0x85,0xce},{0x90,0xd1},
    {0x00,0x00},{0xd5,0xac},{0xb1,0xdf},{0xd5,0xab},{0xd5,0xad},
    {0xb1,0xde},{0xb1,0xe3},{0xd1,0xd4},{0x00,0x00},{0xd5,0xaa},
    {0xd5,0xae},{0x9a,0xca},{0xb1,0xe0},{0xd5,0xa9},{0xb1,0xe2},
    {0xfc,0x63},{0xb1,0xe1},{0x90,0xd2},{0xd9,0xa7},{0x9a,0xcb},
    {0xd9,0xa2},{0x00,0x00},{0xb4,0xb6},{0xb4,0xba},{0xb4,0xb7},
    {0xd9,0xa5},{0xd9,0xa8},{0x90,0xd3},{0xb4,0xb8},{0x00,0x00},
    {0xb4,0xb9},{0xb4,0xbe},{0xdd,0xc7},{0xd9,0xa6},{0xb4,0xbc},
    {0xd9,0xa3},{0xd9,0xa1},{0x9a,0xcc},{0xb4,0xbd},{0x00,0x00},
    {0xd9,0xa4},{0x92,0x7d},{0x87,0xdc},{0x90,0xd4},{0xb7,0x79},
    {0x9a,0xcd},{0xdd,0xbf},{0xb7,0x76},{0xb7,0x77},{0xb7,0x75},
    {0xdd,0xc4},{0xdd,0xc3},{0xdd,0xc0},{0xb7,0x7b},{0xfe,0x7a},
    {0x00,0x00},{0xdd,0xc2},{0xb4,0xbb},{0x9a,0xce},{0x00,0x00},
    {0xdd,0xc6},{0xdd,0xc1},{0xb7,0x78},{0xb7,0x74},{0xb7,0x7a},
    {0xdd,0xc5},{0x9a,0xcf},{0x00,0x00},{0x00,0x00},{0xba,0x5c},
    {0x00,0x00},{0xe1,0xf8},{0xe1,0xf7},{0xe1,0xf6},{0xba,0x5a},
    {0x00,0x00},{0x9a,0xd0},{0x00,0x00},{0x93,0xef},{0x89,0xe2},
    {0xba,0x5b},{0xe5,0xc5},{0xe5,0xc8},{0xbc,0xc8},{0x00,0x00},
    {0x9a,0xd1},{0xbc,0xc7},{0xe5,0xc9},{0xe5,0xc4},{0xbc,0xca},
    {0xe5,0xc6},{0x9a,0xd2},{0xbc,0xc9},{0xe5,0xc3},{0x9a,0xd3},
    {0xe5,0xc7},{0xbe,0xe9},{0xbe,0xe6},{0xe9,0xbb},{0xe9,0xba},
    {0x90,0xd5},{0xe9,0xb9},{0xe9,0xb4},{0x90,0xd6},{0xe9,0xb5},
    {0x90,0xd7},{0x00,0x00},{0x00,0x00},{0xbe,0xe7},{0x00,0x00},
    {0xbe,0xe4},{0xbe,0xe8},{0xe9,0xb3},{0xbe,0xe5},{0xe9,0xb6},
    {0xe9,0xb7},{0xe9,0xbc},{0x9a,0xd4},{0x9a,0xd5},{0xe9,0xb8},
    {0x00,0x00},{0x00,0x00},{0xec,0xf2},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0xc0,0xc7},{0x00,0x00},{0xef,0xdc},{0xc0,0xc6},
    {0xef,0xda},{0xef,0xdb},{0xc2,0x60},{0xc3,0x6e},{0xf2,0x4b},
    {0x00,0x00},{0xc3,0x6d},{0x00,0x00},{0x00,0x00},{0xf4,0x51},
    {0xf4,0x52},{0x00,0x00},{0xc4,0x66},{0x9d,0xca},{0xf4,0x50},
    {0xc4,0xe4},{0x00,0x00},{0xf7,0xdf},{0xc5,0xce},{0xf8,0xaa},
    {0xf8,0xab},{0x00,0x00},{0xa4,0xea},{0xa0,0x58},{0xa6,0xb1},
    {0xa6,0xb2},{0xa7,0xf3},{0x90,0xd8},{0xcc,0xd1},{0xac,0x54},
    {0xae,0xd1},{0xb1,0xe4},{0x90,0xd9},{0x90,0xda},{0xb0,0xd2},
    {0x93,0xfb},{0xb4,0xbf},{0xb4,0xc0},{0xb3,0xcc},{0xd9,0xa9},
    {0x9a,0xd6},{0xb7,0x7c},{0xe1,0xfa},{0xe1,0xf9},{0x00,0x00},
    {0x00,0x00},{0xa4,0xeb},{0xa6,0xb3},{0xcc,0xd2},{0xaa,0x42},
    {0x9a,0xd7},{0xaa,0x41},{0x90,0xdb},{0xce,0xf9},{0xce,0xfa},
    {0x00,0x00},{0xd1,0xd7},{0xd1,0xd8},{0xae,0xd2},{0xae,0xd3},
    {0x90,0xdc},{0xae,0xd4},{0xd5,0xaf},{0x9a,0xd8},{0x00,0x00},
    {0xb1,0xe6},{0x00,0x00},{0xb4,0xc2},{0xfc,0x64},{0xb4,0xc1},
    {0xdd,0xc8},{0xdf,0x7a},{0xe1,0xfb},{0xe9,0xbd},{0x00,0x00},
    {0xfe,0x5e},{0xc2,0x61},{0xc4,0x67},{0xa4,0xec},{0x91,0xd1},
    {0xa5,0xbc},{0xa5,0xbd},{0xa5,0xbb},{0xa5,0xbe},{0xa5,0xba},
    {0x84,0x7b},{0x00,0x00},{0xa6,0xb6},{0x00,0x00},{0xc9,0xf6},
    {0xa6,0xb5},{0xa6,0xb7},{0x95,0x7c},{0x90,0xdd},{0xc9,0xf1},
    {0xc9,0xf0},{0xc9,0xf3},{0xc9,0xf2},{0xc9,0xf5},{0xa6,0xb4},
    {0xc9,0xef},{0xc9,0xf4},{0x84,0x59},{0x94,0x78},{0x8b,0x59},
    {0x8c,0xd0},{0x9a,0xd9},{0xca,0xfd},{0xa7,0xfd},{0xca,0xfe},
    {0xcb,0x43},{0xa7,0xfc},{0x00,0x00},{0xcb,0x47},{0xcb,0x42},
    {0xcb,0x45},{0xa7,0xf5},{0xa7,0xf6},{0xa7,0xf7},{0xa7,0xf8},
    {0x00,0x00},{0xa8,0x40},{0x00,0x00},{0xcb,0x41},{0xa7,0xfa},
    {0xa8,0x41},{0x00,0x00},{0xcb,0x40},{0xcb,0x46},{0x00,0x00},
    {0xa7,0xf9},{0xcb,0x44},{0xa7,0xfb},{0xa7,0xf4},{0xa7,0xfe},
    {0x84,0x57},{0x94,0x5c},{0x94,0x79},{0x90,0xde},{0x83,0x53},
    {0x90,0xdf},{0xfb,0xa6},{0x85,0xd4},{0x8e,0x72},{0xaa,0x57},
    {0x9a,0xda},{0xcc,0xd4},{0xaa,0x43},{0x9d,0x72},{0xaa,0x4d},
    {0xaa,0x4e},{0xaa,0x46},{0xaa,0x58},{0xaa,0x48},{0xcc,0xdc},
    {0xaa,0x53},{0xcc,0xd7},{0xaa,0x49},{0xcc,0xe6},{0xcc,0xe7},
    {0xcc,0xdf},{0xcc,0xd8},{0xaa,0x56},{0xcc,0xe4},{0xaa,0x51},
    {0xaa,0x4f},{0x00,0x00},{0xcc,0xe5},{0x00,0x00},{0xcc,0xe3},
    {0xcc,0xdb},{0xcc,0xd3},{0xcc,0xda},{0xaa,0x4a},{0x00,0x00},
    {0xaa,0x50},{0x00,0x00},{0xaa,0x44},{0xcc,0xde},{0xcc,0xdd},
    {0xcc,0xd5},{0x9a,0xdb},{0xaa,0x52},{0xcc,0xe1},{0xcc,0xd6},
    {0xaa,0x55},{0xcc,0xe8},{0xaa,0x45},{0x00,0x00},{0xaa,0x4c},
    {0xcc,0xd9},{0xcc,0xe2},{0xaa,0x54},{0x00,0x00},{0xaa,0x47},
    {0xaa,0x4b},{0x87,0xe5},{0xcc,0xe0},{0x94,0xfd},{0x94,0x7a},
    {0x87,0xe0},{0x84,0xe5},{0x9a,0xdc},{0x8f,0xdc},{0x90,0xe0},
    {0x90,0xe1},{0x8d,0xdf},{0x90,0xe2},{0x86,0xd2},{0x85,0xd6},
    {0xfc,0x66},{0x84,0x58},{0xcf,0x5b},{0xac,0x5c},{0xac,0x69},
    {0x95,0x45},{0xcf,0x56},{0xcf,0x4c},{0xac,0x62},{0xcf,0x4a},
    {0xac,0x5b},{0xcf,0x45},{0xac,0x65},{0xcf,0x52},{0xce,0xfe},
    {0xcf,0x41},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x9a,0xdd},
    {0xcf,0x44},{0xce,0xfb},{0xcf,0x51},{0xcf,0x61},{0xac,0x60},
    {0xcf,0x46},{0xcf,0x58},{0x00,0x00},{0xce,0xfd},{0xcf,0x5f},
    {0xcf,0x60},{0xcf,0x63},{0xcf,0x5a},{0xcf,0x4b},{0xcf,0x53},
    {0xac,0x66},{0xac,0x59},{0xac,0x61},{0xac,0x6d},{0xac,0x56},
    {0xac,0x58},{0x00,0x00},{0x9a,0xde},{0x9a,0xdf},{0xcf,0x43},
    {0xac,0x6a},{0xac,0x63},{0xcf,0x5d},{0xcf,0x40},{0xac,0x6c},
    {0xac,0x67},{0xcf,0x49},{0x8a,0xce},{0x00,0x00},{0xac,0x6b},
    {0xcf,0x50},{0xcf,0x48},{0xac,0x64},{0xcf,0x5c},{0xcf,0x54},
    {0x00,0x00},{0xac,0x5e},{0xcf,0x62},{0xcf,0x47},{0xac,0x5a},
    {0xcf,0x59},{0xcf,0x4f},{0xac,0x5f},{0xcf,0x55},{0xac,0x57},
    {0xce,0xfc},{0xac,0x68},{0xae,0xe3},{0xac,0x5d},{0xcf,0x4e},
    {0xcf,0x4d},{0xcf,0x42},{0xfc,0x67},{0xcf,0x5e},{0x90,0xe3},
    {0xcf,0x57},{0x90,0xe4},{0x94,0x5a},{0xac,0x55},{0x90,0xe5},
    {0x90,0xe6},{0x94,0x4d},{0x94,0x51},{0x92,0x48},{0x90,0xe7},
    {0x00,0x00},{0x87,0xe1},{0x84,0xe7},{0x89,0xe6},{0x8f,0xdb},
    {0x84,0xe6},{0x8f,0xdd},{0x9a,0xe1},{0x8f,0xba},{0x8c,0x77},
    {0x9a,0xe2},{0x88,0xeb},{0xd1,0xec},{0xae,0xea},{0xd1,0xed},
    {0x00,0x00},{0xd1,0xe1},{0xae,0xdf},{0xae,0xeb},{0x00,0x00},
    {0xd1,0xda},{0x9a,0xe3},{0xd1,0xe3},{0xd1,0xeb},{0x90,0xe8},
    {0xd1,0xd9},{0xd1,0xf4},{0xae,0xd5},{0xfe,0x45},{0x00,0x00},
    {0x00,0x00},{0xd1,0xf3},{0xd1,0xee},{0x00,0x00},{0xd1,0xef},
    {0xae,0xdd},{0xae,0xe8},{0xd1,0xe5},{0x00,0x00},{0xd1,0xe6},
    {0xd1,0xf0},{0xd1,0xe7},{0x00,0x00},{0xd1,0xe2},{0xd1,0xdc},
    {0xd1,0xdd},{0xd1,0xea},{0xd1,0xe4},{0x9a,0xe4},{0x87,0xde},
    {0xae,0xd6},{0xae,0xda},{0xd1,0xf2},{0xd1,0xde},{0xae,0xe6},
    {0xae,0xe2},{0x90,0x6a},{0x00,0x00},{0xae,0xe5},{0xae,0xec},
    {0xae,0xdb},{0xae,0xe7},{0xd1,0xe9},{0xae,0xe9},{0xae,0xd8},
    {0x9a,0xe5},{0xae,0xd7},{0xd1,0xdb},{0x90,0xe9},{0xd1,0xdf},
    {0xae,0xe0},{0xd1,0xf1},{0xd1,0xe8},{0xd1,0xe0},{0xae,0xe4},
    {0xae,0xe1},{0x90,0xea},{0xae,0xd9},{0xae,0xdc},{0x90,0xeb},
    {0x9a,0xe6},{0x00,0x00},{0x00,0x00},{0x90,0xec},{0x00,0x00},
    {0x00,0x00},{0x92,0x51},{0x82,0x7c},{0x00,0x00},{0x92,0xcc},
    {0x8d,0xde},{0x88,0xef},{0x85,0xd5},{0x89,0xe3},{0x8e,0x71},
    {0x88,0xed},{0x88,0xe9},{0x89,0xe5},{0x87,0xe3},{0x87,0xdf},
    {0x00,0x00},{0xd5,0xc4},{0x00,0x00},{0xd5,0xb4},{0xd5,0xb5},
    {0xd5,0xb9},{0x00,0x00},{0xd5,0xc8},{0xd5,0xc5},{0x00,0x00},
    {0xd5,0xbe},{0xd5,0xbd},{0xb1,0xed},{0xd5,0xc1},{0xd5,0xd0},
    {0xd5,0xb0},{0x00,0x00},{0xd5,0xd1},{0xd5,0xc3},{0xd5,0xd5},
    {0xd5,0xc9},{0xb1,0xec},{0xd5,0xc7},{0xb1,0xe7},{0xb1,0xfc},
    {0xb1,0xf2},{0x9a,0xe7},{0xb1,0xf6},{0xb1,0xf5},{0xd5,0xb1},
    {0x9a,0xe8},{0xd5,0xce},{0xd5,0xd4},{0xd5,0xcc},{0xd5,0xd3},
    {0x90,0xed},{0x00,0x00},{0xd5,0xc0},{0xd5,0xb2},{0xd5,0xd2},
    {0xd5,0xc2},{0xb1,0xea},{0xb1,0xf7},{0x00,0x00},{0xd5,0xcb},
    {0xb1,0xf0},{0xfb,0x58},{0x00,0x00},{0x00,0x00},{0xd5,0xca},
    {0xd5,0xb3},{0xb1,0xf8},{0x00,0x00},{0xb1,0xfa},{0xd5,0xcd},
    {0xb1,0xfb},{0xb1,0xe9},{0xd5,0xba},{0xd5,0xcf},{0x00,0x00},
    {0x86,0xbb},{0xb1,0xef},{0xb1,0xf9},{0xd5,0xbc},{0xd5,0xc6},
    {0xd5,0xb7},{0xd5,0xbb},{0xb1,0xf4},{0xd5,0xb6},{0xb1,0xe8},
    {0xb1,0xf1},{0xb1,0xee},{0xd5,0xbf},{0xae,0xde},{0xd9,0xc0},
    {0xb1,0xeb},{0xfc,0x68},{0x00,0x00},{0x00,0x00},{0x90,0xee},
    {0x94,0x7b},{0x00,0x00},{0x82,0x6f},{0x9a,0xe9},{0x00,0x00},
    {0x00,0x00},{0x89,0xe4},{0x00,0x00},{0x8c,0x78},{0x9a,0xea},
    {0xb1,0xf3},{0x9a,0xeb},{0xd9,0xc3},{0xd9,0xd9},{0xd9,0xce},
    {0xb4,0xd6},{0xfc,0x6c},{0xb4,0xd1},{0xd9,0xbd},{0xb4,0xd2},
    {0xd9,0xcd},{0x90,0xef},{0xd9,0xc6},{0xd9,0xd3},{0xb4,0xce},
    {0xd9,0xab},{0xd9,0xd5},{0xb4,0xc4},{0xd9,0xb3},{0xb4,0xc7},
    {0xb4,0xc6},{0x00,0x00},{0xb4,0xd7},{0x00,0x00},{0xd9,0xad},
    {0xd9,0xcf},{0xd9,0xd0},{0xb4,0xc9},{0xb4,0xc5},{0xd9,0xbb},
    {0x00,0x00},{0xb4,0xd0},{0xd9,0xb6},{0x00,0x00},{0xd9,0xd1},
    {0xb4,0xcc},{0xd9,0xc9},{0xd9,0xd6},{0xd9,0xb0},{0xd9,0xb5},
    {0xd9,0xaf},{0x00,0x00},{0xb4,0xcb},{0xd9,0xc2},{0xdd,0xde},
    {0xd9,0xb1},{0xb4,0xcf},{0xd9,0xba},{0xd9,0xd2},{0xb4,0xca},
    {0xd9,0xb7},{0xd9,0xb4},{0xd9,0xc5},{0xb4,0xcd},{0xb4,0xc3},
    {0xb4,0xd9},{0xd9,0xc8},{0xd9,0xc7},{0x00,0x00},{0x00,0x00},
    {0xfc,0x6b},{0xfc,0x6a},{0x9a,0xec},{0x9a,0xed},{0xd9,0xac},
    {0xb4,0xc8},{0xd9,0xd4},{0xd9,0xbc},{0xd9,0xbe},{0x9a,0xee},
    {0xd9,0xcb},{0xd9,0xca},{0xd9,0xaa},{0xb4,0xd3},{0xb4,0xd5},
    {0xd9,0xb2},{0xd9,0xb9},{0xd9,0xc1},{0xb4,0xd4},{0xd9,0xb8},
    {0xd9,0xc4},{0xd9,0xd7},{0x00,0x00},{0xd9,0xcc},{0x9a,0xef},
    {0x94,0x49},{0xfe,0x4f},{0x94,0x41},{0x92,0xb6},{0x00,0x00},
    {0x00,0x00},{0x8b,0x79},{0x8e,0xb8},{0x94,0xa2},{0x90,0xf3},
    {0x94,0xa1},{0x90,0x6b},{0xd9,0xd8},{0x90,0xf4},{0x00,0x00},
    {0x94,0x7d},{0x00,0x00},{0xd9,0xae},{0x00,0x00},{0xfc,0x69},
    {0x88,0xec},{0x00,0x00},{0xdd,0xf2},{0xb7,0xa6},{0x00,0x00},
    {0xdd,0xf0},{0xdd,0xdb},{0xdd,0xe0},{0xdd,0xd9},{0x90,0xfd},
    {0xdd,0xec},{0xdd,0xcb},{0xdd,0xd2},{0x00,0x00},{0xdd,0xea},
    {0xdd,0xf4},{0xdd,0xdc},{0xfc,0x6f},{0xdd,0xcf},{0xdd,0xe2},
    {0xdd,0xe7},{0xdd,0xd3},{0x9a,0xf0},{0xdd,0xe4},{0xdd,0xd0},
    {0x9a,0xf1},{0x00,0x00},{0xdd,0xd7},{0xdd,0xd8},{0xb7,0xa8},
    {0xdd,0xeb},{0xdd,0xe9},{0x00,0x00},{0xdd,0xcc},{0xdd,0xee},
    {0x00,0x00},{0xdd,0xef},{0xdd,0xf1},{0xb7,0xac},{0xb7,0xa4},
    {0x82,0x6c},{0xd5,0xb8},{0xdd,0xd4},{0xdd,0xe6},{0xdd,0xd5},
    {0xb7,0xa1},{0xb7,0xb1},{0xdd,0xed},{0xb7,0xaf},{0xb7,0xab},
    {0xdd,0xca},{0xb7,0xa3},{0x90,0xfe},{0xdd,0xcd},{0xb7,0xb0},
    {0x9a,0xf2},{0xdd,0xdd},{0xdd,0xc9},{0x9a,0xf3},{0xb7,0xa9},
    {0xdd,0xe1},{0xdd,0xd1},{0xb7,0xaa},{0xdd,0xda},{0xb7,0x7e},
    {0xb4,0xd8},{0xdd,0xe3},{0xd9,0xbf},{0xdd,0xce},{0x9a,0xf4},
    {0xfc,0x6d},{0xdd,0xe8},{0xb7,0xa5},{0xdd,0xe5},{0xb7,0xa2},
    {0xdd,0xdf},{0xb7,0xad},{0xdd,0xd6},{0xdd,0xf3},{0x87,0xe2},
    {0x92,0x62},{0x94,0xa3},{0x00,0x00},{0xfc,0x6e},{0x94,0xa4},
    {0xb7,0xa7},{0xde,0xc6},{0x8d,0x6e},{0x9a,0xf5},{0xb7,0xae},
    {0x8b,0xf9},{0x8b,0x7a},{0x90,0x40},{0x94,0x45},{0x00,0x00},
    {0x00,0x00},{0xe2,0x4a},{0xe2,0x48},{0x00,0x00},{0xe2,0x5e},
    {0xe2,0x46},{0x00,0x00},{0xe2,0x58},{0xb7,0x7d},{0xba,0x5f},
    {0xe2,0x42},{0xe2,0x5d},{0x95,0x67},{0xe2,0x47},{0xe2,0x55},
    {0xba,0x64},{0xba,0x5d},{0x00,0x00},{0xe2,0x5b},{0x9a,0xf6},
    {0xe2,0x40},{0xe2,0x5a},{0x9a,0xf7},{0xba,0x6f},{0xe2,0x51},
    {0xe2,0x61},{0xba,0x6d},{0xe2,0x49},{0xba,0x5e},{0xe2,0x4b},
    {0xe2,0x59},{0xba,0x67},{0xe2,0x44},{0xba,0x6b},{0xba,0x61},
    {0xe2,0x4d},{0xe2,0x43},{0xe1,0xfc},{0xfc,0x71},{0xe2,0x57},
    {0xba,0x68},{0xe2,0x60},{0xe1,0xfd},{0xba,0x65},{0x00,0x00},
    {0xe2,0x53},{0x00,0x00},{0xba,0x66},{0xe2,0x45},{0xe2,0x50},
    {0xe2,0x4c},{0xe2,0x4e},{0xfc,0x72},{0xba,0x60},{0xe2,0x5f},
    {0xba,0x6e},{0xe2,0x4f},{0x00,0x00},{0xe2,0x62},{0x91,0xee},
    {0x00,0x00},{0xe1,0xfe},{0xe2,0x54},{0xba,0x63},{0xba,0x6c},
    {0xba,0x6a},{0xe2,0x41},{0xe2,0x56},{0xba,0x69},{0x9a,0xf8},
    {0x00,0x00},{0xba,0x62},{0xe2,0x52},{0x9a,0xf9},{0x9a,0xfa},
    {0x00,0x00},{0x93,0xdb},{0xe2,0x5c},{0x00,0x00},{0x8a,0xcd},
    {0x00,0x00},{0x94,0xa5},{0x96,0x7d},{0x8a,0xcb},{0x8f,0xb9},
    {0x9b,0x41},{0xe5,0xd5},{0x00,0x00},{0xe5,0xd1},{0xe5,0xcd},
    {0xe5,0xe1},{0xe5,0xde},{0xbc,0xcd},{0xfc,0x75},{0x00,0x00},
    {0xe5,0xe5},{0xe5,0xd4},{0xbc,0xd8},{0xe5,0xdb},{0x00,0x00},
    {0x00,0x00},{0xe5,0xd0},{0xe5,0xda},{0xbc,0xd5},{0xe5,0xee},
    {0x00,0x00},{0xe5,0xeb},{0xe5,0xdd},{0xe5,0xce},{0x96,0x7e},
    {0xfc,0x74},{0xe5,0xe2},{0xe5,0xe4},{0xbc,0xd1},{0xe5,0xd8},
    {0xe5,0xd3},{0xe5,0xca},{0xbc,0xce},{0xbc,0xd6},{0x9b,0x42},
    {0xe5,0xe7},{0xbc,0xd7},{0xe5,0xcb},{0xe5,0xed},{0xe5,0xe0},
    {0xe5,0xe6},{0xbc,0xd4},{0xfe,0x54},{0x96,0xce},{0xe5,0xe3},
    {0x00,0x00},{0xe5,0xea},{0x00,0x00},{0xbc,0xd9},{0x96,0xeb},
    {0xbc,0xd3},{0xe5,0xdc},{0xe5,0xcf},{0xe5,0xef},{0xe5,0xcc},
    {0xe5,0xe8},{0xbc,0xd0},{0x9b,0x43},{0xe5,0xd6},{0x9b,0x44},
    {0xe5,0xd7},{0xbc,0xcf},{0xbc,0xcc},{0xe5,0xd2},{0xbc,0xd2},
    {0x96,0xec},{0xbc,0xcb},{0x00,0x00},{0xe5,0xe9},{0xe5,0xec},
    {0xe5,0xd9},{0xe9,0xca},{0x92,0xb7},{0x88,0xea},{0x94,0x40},
    {0x9b,0x45},{0x9b,0x46},{0x94,0xa6},{0x89,0xe7},{0x96,0xed},
    {0x8c,0x76},{0xe9,0xc2},{0x9b,0x47},{0xe9,0xbe},{0xbe,0xf6},
    {0x96,0xee},{0x00,0x00},{0xbe,0xeb},{0xbe,0xf0},{0xbe,0xec},
    {0xe9,0xcc},{0xe9,0xd7},{0xbe,0xea},{0xe9,0xc4},{0xe9,0xcd},
    {0xe5,0xdf},{0xe9,0xce},{0x00,0x00},{0x9b,0x48},{0xbe,0xf1},
    {0x9b,0x49},{0xe9,0xdd},{0xbe,0xf5},{0xbe,0xf8},{0xe9,0xc0},
    {0x00,0x00},{0xbe,0xf4},{0x9b,0x4a},{0xe9,0xdb},{0xe9,0xdc},
    {0xe9,0xd2},{0xe9,0xd1},{0xe9,0xc9},{0xfc,0x77},{0x9b,0x4b},
    {0xe9,0xd3},{0xe9,0xda},{0xe9,0xd9},{0x9b,0x4c},{0xbe,0xef},
    {0xbe,0xed},{0xe9,0xcb},{0xe9,0xc8},{0x00,0x00},{0xe9,0xc5},
    {0xe9,0xd8},{0xbe,0xf7},{0xe9,0xd6},{0xbe,0xf3},{0xbe,0xf2},
    {0x9b,0x4d},{0xe9,0xd0},{0x96,0xef},{0xe9,0xbf},{0xe9,0xc1},
    {0xe9,0xc3},{0xe9,0xd5},{0xe9,0xcf},{0xbe,0xee},{0x00,0x00},
    {0xe9,0xc6},{0x00,0x00},{0xe9,0xd4},{0x00,0x00},{0x8b,0x78},
    {0x94,0xa7},{0x96,0xf8},{0x9b,0x4e},{0x00,0x00},{0xe9,0xc7},
    {0x00,0x00},{0x96,0xf9},{0x8b,0x7b},{0x94,0x7e},{0x00,0x00},
    {0x96,0xfc},{0x00,0x00},{0xc0,0xcf},{0xed,0x45},{0xc0,0xc8},
    {0xec,0xf5},{0x9b,0x4f},{0xed,0x41},{0xc0,0xca},{0xed,0x48},
    {0x00,0x00},{0xec,0xfc},{0x00,0x00},{0xec,0xf7},{0x9b,0x50},
    {0x00,0x00},{0xed,0x49},{0xec,0xf3},{0xec,0xfe},{0x9b,0x51},
    {0xc0,0xd1},{0xed,0x44},{0xed,0x4a},{0xec,0xfd},{0xc0,0xc9},
    {0xed,0x40},{0xec,0xf4},{0xc0,0xd0},{0x00,0x00},{0x9b,0x52},
    {0xed,0x47},{0xec,0xf9},{0xc0,0xcc},{0xfc,0x78},{0xec,0xfb},
    {0xec,0xf8},{0xc0,0xd2},{0xec,0xfa},{0xc0,0xcb},{0xc0,0xce},
    {0xed,0x43},{0xec,0xf6},{0xed,0x46},{0x9b,0x53},{0xed,0x42},
    {0x96,0xfd},{0x96,0xfe},{0x99,0xfe},{0xc2,0x63},{0xef,0xe7},
    {0xc2,0x68},{0xc2,0x69},{0x00,0x00},{0x9b,0x54},{0xfc,0x76},
    {0xc2,0x62},{0xef,0xe6},{0x9b,0x55},{0xef,0xe3},{0xef,0xe4},
    {0xc2,0x66},{0xef,0xde},{0xef,0xe2},{0xc2,0x65},{0x00,0x00},
    {0xef,0xdf},{0x9b,0x56},{0x00,0x00},{0x00,0x00},{0x9a,0xfe},
    {0xc2,0x67},{0xc2,0x64},{0x00,0x00},{0xef,0xdd},{0xef,0xe1},
    {0xef,0xe5},{0x95,0xe3},{0x9b,0x57},{0xfb,0xdc},{0xf2,0x51},
    {0xf2,0x4e},{0xf2,0x57},{0x00,0x00},{0xf2,0x56},{0xf2,0x54},
    {0xf2,0x4f},{0x00,0x00},{0xc3,0x72},{0x9b,0x58},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x9b,0x59},{0xf2,0x50},{0xc3,0x71},
    {0xc0,0xcd},{0xf2,0x53},{0xc3,0x70},{0xf2,0x58},{0xf2,0x52},
    {0xf2,0x4d},{0xef,0xe0},{0x9c,0xf9},{0x00,0x00},{0x9d,0xe1},
    {0xc3,0x6f},{0x00,0x00},{0xf2,0x4c},{0xf4,0x56},{0x00,0x00},
    {0xf4,0x55},{0xf2,0x55},{0xc4,0x68},{0x00,0x00},{0xf4,0x59},
    {0xf4,0x5a},{0xf4,0x54},{0xf4,0x58},{0x00,0x00},{0xf4,0x53},
    {0x00,0x00},{0x00,0x00},{0x9b,0x5a},{0x00,0x00},{0xf5,0xd1},
    {0xf4,0x57},{0xc4,0xe7},{0xc4,0xe5},{0xf5,0xcf},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0xf5,0xd2},{0x00,0x00},{0xf5,0xce},
    {0xf5,0xd0},{0xc4,0xe6},{0x9d,0xfe},{0x00,0x00},{0x00,0x00},
    {0xf6,0xe5},{0xf6,0xe6},{0xc5,0x76},{0xf6,0xe4},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0xf7,0xe2},{0xc5,0xcf},{0xf7,0xe0},
    {0xf7,0xe1},{0xf8,0xac},{0x00,0x00},{0x00,0x00},{0xc6,0x56},
    {0xf8,0xf3},{0xf8,0xf1},{0xf8,0xf2},{0xf8,0xf4},{0x00,0x00},
    {0x00,0x00},{0xfc,0x79},{0xf9,0xbb},{0x94,0xa8},{0xa4,0xed},
    {0xa6,0xb8},{0x8c,0xd1},{0xaa,0x59},{0x8a,0xcf},{0xcc,0xe9},
    {0x00,0x00},{0x87,0xe6},{0xcf,0x64},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0xd1,0xf5},{0xd1,0xf7},{0x00,0x00},{0xd1,0xf6},
    {0x00,0x00},{0xd1,0xf8},{0xb1,0xfd},{0xd5,0xd7},{0xd1,0xf9},
    {0x95,0xb9},{0xd5,0xd6},{0xd5,0xd8},{0xd5,0xd9},{0xd9,0xda},
    {0xb4,0xdb},{0xd9,0xdb},{0xd9,0xdd},{0xb4,0xdc},{0xb4,0xda},
    {0xd9,0xdc},{0x00,0x00},{0xdd,0xfa},{0xdd,0xf8},{0xdd,0xf7},
    {0x00,0x00},{0xdd,0xf6},{0xdd,0xf5},{0xb7,0xb2},{0xdd,0xf9},
    {0xba,0x70},{0xe2,0x63},{0xe2,0x65},{0xba,0x71},{0xe2,0x64},
    {0xbc,0xdb},{0x00,0x00},{0xbc,0xda},{0xe5,0xf0},{0xfc,0x7a},
    {0x92,0x6c},{0xe9,0xdf},{0xe9,0xde},{0xe9,0xe0},{0x9b,0x5b},
    {0x00,0x00},{0xbe,0xf9},{0x00,0x00},{0xed,0x4b},{0xc0,0xd3},
    {0x00,0x00},{0xef,0xe8},{0xc2,0x6a},{0xf2,0x59},{0xc5,0x77},
    {0xa4,0xee},{0xa5,0xbf},{0xa6,0xb9},{0xa8,0x42},{0xaa,0x5a},
    {0xaa,0x5b},{0x00,0x00},{0x93,0xc5},{0xac,0x6e},{0x00,0x00},
    {0x00,0x00},{0xd1,0xfa},{0x00,0x00},{0x92,0xd0},{0x00,0x00},
    {0x00,0x00},{0xb7,0xb3},{0x92,0xc8},{0x93,0xf0},{0x00,0x00},
    {0xe6,0xd1},{0xbe,0xfa},{0xc2,0x6b},{0xa4,0xef},{0x9b,0x5c},
    {0xa6,0xba},{0x8c,0x79},{0x00,0x00},{0xcc,0xeb},{0xaa,0x5c},
    {0xcc,0xea},{0x9f,0x4e},{0xcf,0x65},{0xac,0x6f},{0xcf,0x66},
    {0x00,0x00},{0xac,0x70},{0x87,0xe7},{0xd1,0xfc},{0xae,0xee},
    {0xae,0xed},{0x92,0xcf},{0xd5,0xde},{0xd5,0xdc},{0xd5,0xdd},
    {0xd5,0xdb},{0x00,0x00},{0xd5,0xda},{0x8d,0xb5},{0x89,0xe8},
    {0xd9,0xde},{0xd9,0xe1},{0xb4,0xde},{0xd9,0xdf},{0xb4,0xdd},
    {0xd9,0xe0},{0x8e,0xe8},{0xdd,0xfb},{0x00,0x00},{0x00,0x00},
    {0xe2,0x66},{0xe2,0x67},{0xe2,0x68},{0x8a,0xd1},{0xe5,0xf3},
    {0xe5,0xf2},{0xbc,0xdc},{0xe5,0xf1},{0xe5,0xf4},{0xe9,0xe1},
    {0x00,0x00},{0x00,0x00},{0xe9,0xe2},{0xe9,0xe3},{0x00,0x00},
    {0xed,0x4c},{0xc0,0xd4},{0xc2,0x6c},{0xf2,0x5a},{0x9f,0x4f},
    {0xc4,0xe8},{0xc9,0x5f},{0x87,0xe8},{0xac,0x71},{0xcf,0x67},
    {0xae,0xef},{0x00,0x00},{0x00,0x00},{0xb1,0xfe},{0x92,0x5f},
    {0xb4,0xdf},{0xd9,0xe2},{0x00,0x00},{0xb7,0xb5},{0xb7,0xb4},
    {0x90,0xb5},{0x8a,0x75},{0xe2,0x69},{0xe2,0x6a},{0xbc,0xdd},
    {0xbc,0xde},{0xe9,0xe5},{0xe9,0xe4},{0xef,0xe9},{0xf7,0xe3},
    {0xa4,0xf0},{0xc9,0x60},{0xa5,0xc0},{0x93,0xd1},{0xa8,0x43},
    {0xcb,0x48},{0x00,0x00},{0xac,0x72},{0xb7,0xb6},{0xa4,0xf1},
    {0x84,0x65},{0xcf,0x68},{0xac,0x73},{0xcf,0x69},{0x89,0xe1},
    {0xc0,0xd5},{0xa4,0xf2},{0x9b,0x5d},{0x00,0x00},{0xcc,0xec},
    {0x94,0xa9},{0xcf,0x6a},{0x89,0xe9},{0xd2,0x42},{0xd2,0x41},
    {0xd1,0xfe},{0x00,0x00},{0xd1,0xfd},{0xd2,0x43},{0xd2,0x40},
    {0x00,0x00},{0xa0,0x62},{0xb2,0x40},{0xb2,0x41},{0x00,0x00},
    {0x00,0x00},{0xb4,0xe0},{0xd9,0xe3},{0x00,0x00},{0xd9,0xe4},
    {0xd9,0xe5},{0x00,0x00},{0x8e,0xb9},{0x00,0x00},{0xde,0x41},
    {0xde,0x42},{0xde,0x40},{0xfc,0x7b},{0xdd,0xfd},{0xdd,0xfe},
    {0xb7,0xb7},{0xe2,0x6b},{0xe5,0xf7},{0xe5,0xf6},{0xe5,0xf5},
    {0xe5,0xf8},{0xe9,0xe7},{0xe9,0xe6},{0xbe,0xfb},{0xe9,0xe8},
    {0x8f,0xbb},{0xc0,0xd6},{0xed,0x4d},{0x00,0x00},{0xef,0xea},
    {0xf2,0x5b},{0xf6,0xe7},{0x00,0x00},{0xa4,0xf3},{0xa5,0xc2},
    {0xa5,0xc1},{0x00,0x00},{0xaa,0x5d},{0xc9,0x61},{0xc9,0x7e},
    {0xa6,0xbb},{0x92,0x6e},{0xc9,0xf7},{0xcb,0x49},{0xcb,0x4a},
    {0xaa,0x5e},{0x9b,0x5e},{0xcc,0xed},{0x00,0x00},{0xac,0x74},
    {0xcf,0x6b},{0xcf,0x6c},{0x84,0x5a},{0xae,0xf0},{0xae,0xf4},
    {0xd2,0x44},{0xae,0xf3},{0xae,0xf1},{0xae,0xf2},{0x84,0xec},
    {0xd5,0xdf},{0xb2,0x42},{0xb4,0xe3},{0x00,0x00},{0xb4,0xe1},
    {0xb4,0xe2},{0xd9,0xe6},{0x9b,0x5f},{0xa0,0x63},{0xba,0x72},
    {0xa4,0xf4},{0x9c,0xf3},{0xc9,0xa1},{0x95,0xeb},{0xa5,0xc3},
    {0xfe,0x40},{0x91,0xd2},{0xc9,0xa4},{0x00,0x00},{0xa0,0x64},
    {0xa5,0xc6},{0xc9,0xa3},{0xa5,0xc5},{0xa5,0xc4},{0xa8,0x44},
    {0xc9,0xa2},{0x00,0x00},{0x00,0x00},{0xc9,0xf8},{0x85,0xb9},
    {0x00,0x00},{0x86,0xd5},{0xc9,0xfc},{0xc9,0xfe},{0xca,0x40},
    {0xa6,0xc5},{0xa6,0xc6},{0xc9,0xfb},{0xa6,0xc1},{0x00,0x00},
    {0xc9,0xf9},{0x00,0x00},{0xc9,0xfd},{0xa6,0xc2},{0x00,0x00},
    {0xa6,0xbd},{0x9b,0x60},{0xa6,0xbe},{0x95,0xea},{0xa6,0xc4},
    {0xc9,0xfa},{0xa6,0xbc},{0xa8,0x45},{0xa6,0xbf},{0xa6,0xc0},
    {0xa6,0xc3},{0xa0,0x65},{0x00,0x00},{0x84,0xf1},{0xcb,0x5b},
    {0xcb,0x59},{0xcb,0x4c},{0xa8,0x51},{0xcb,0x53},{0xa8,0x4c},
    {0xcb,0x4d},{0x00,0x00},{0xcb,0x55},{0x9b,0x61},{0xcb,0x52},
    {0xa8,0x4f},{0xcb,0x51},{0xa8,0x56},{0xcb,0x5a},{0xa8,0x58},
    {0x9b,0x62},{0xa8,0x5a},{0x00,0x00},{0xcb,0x4b},{0x83,0x6e},
    {0xa8,0x4d},{0xcb,0x5c},{0x00,0x00},{0xa8,0x54},{0xa8,0x57},
    {0x9b,0x63},{0xcd,0x45},{0xa8,0x47},{0xa8,0x5e},{0xa8,0x55},
    {0xcb,0x4e},{0xa8,0x4a},{0xa8,0x59},{0xcb,0x56},{0xa8,0x48},
    {0xa8,0x49},{0xcd,0x43},{0xcb,0x4f},{0xa8,0x50},{0xa8,0x5b},
    {0xcb,0x5d},{0xcb,0x50},{0xa8,0x4e},{0x00,0x00},{0xa8,0x53},
    {0xcc,0xee},{0xa8,0x5c},{0xcb,0x57},{0xa8,0x52},{0x00,0x00},
    {0xa8,0x5d},{0xa8,0x46},{0xcb,0x54},{0xa8,0x4b},{0xcb,0x58},
    {0xcd,0x44},{0x00,0x00},{0x85,0xd8},{0x00,0x00},{0x95,0xca},
    {0x93,0x6b},{0x88,0xf4},{0x8e,0x75},{0x8b,0x7e},{0x84,0x5f},
    {0x85,0xdc},{0x00,0x00},{0x8d,0xe0},{0x86,0xdb},{0xaa,0x6a},
    {0xaa,0x7a},{0xcc,0xf5},{0xaa,0x71},{0x9b,0x64},{0xcd,0x4b},
    {0xaa,0x62},{0xa0,0x66},{0xaa,0x65},{0xcd,0x42},{0x00,0x00},
    {0xcc,0xf3},{0xcc,0xf7},{0xaa,0x6d},{0xaa,0x6f},{0xcc,0xfa},
    {0xaa,0x76},{0xaa,0x68},{0xaa,0x66},{0xaa,0x67},{0xaa,0x75},
    {0xcd,0x47},{0xaa,0x70},{0xcc,0xf9},{0xcc,0xfb},{0xaa,0x6e},
    {0xaa,0x73},{0xcc,0xfc},{0xcd,0x4a},{0x00,0x00},{0xac,0x75},
    {0xaa,0x79},{0x9b,0x65},{0xaa,0x63},{0xcd,0x49},{0xfc,0x7d},
    {0xcd,0x4d},{0xcc,0xf8},{0xcd,0x4f},{0xcd,0x40},{0xaa,0x6c},
    {0xcc,0xf4},{0xaa,0x6b},{0xaa,0x7d},{0xaa,0x72},{0x00,0x00},
    {0xcc,0xf2},{0xcf,0x75},{0xaa,0x78},{0xaa,0x7c},{0xcd,0x41},
    {0xcd,0x46},{0x9b,0x66},{0xaa,0x7e},{0xaa,0x77},{0xaa,0x69},
    {0xaa,0x5f},{0x00,0x00},{0xaa,0x64},{0x00,0x00},{0xcc,0xf6},
    {0xaa,0x60},{0xcd,0x4e},{0x84,0x5e},{0xcc,0xf0},{0xcc,0xef},
    {0xcc,0xfd},{0xcc,0xf1},{0xaa,0x7b},{0xae,0xf5},{0xaa,0x74},
    {0xcc,0xfe},{0xaa,0x61},{0x00,0x00},{0xac,0xa6},{0x8f,0x54},
    {0x8f,0xbc},{0x8b,0xa2},{0xcd,0x4c},{0x8f,0x77},{0x8a,0xd2},
    {0x87,0xea},{0x88,0xf2},{0x83,0xbd},{0x9b,0x67},{0xcf,0x7c},
    {0xcf,0xa1},{0x9b,0x68},{0xcf,0xa4},{0xcf,0x77},{0x9b,0x69},
    {0x9b,0x6a},{0xcf,0xa7},{0xcf,0xaa},{0xcf,0xac},{0xcf,0x74},
    {0xac,0x76},{0xac,0x7b},{0xd2,0x49},{0xac,0xad},{0xcf,0xa5},
    {0xcf,0xad},{0xcf,0x7b},{0xcf,0x73},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0xd2,0x64},{0xac,0x7e},{0xcf,0xa2},{0xcf,0x78},
    {0xcf,0x7a},{0xac,0xa5},{0x00,0x00},{0xcf,0x7d},{0xac,0x7d},
    {0xcf,0x70},{0xcf,0xa8},{0x00,0x00},{0xcf,0xab},{0x00,0x00},
    {0x95,0xb0},{0xac,0x7a},{0x9b,0x6b},{0xac,0xa8},{0xcf,0x6d},
    {0xac,0xaa},{0xac,0x78},{0xac,0xae},{0xcf,0xa9},{0xcf,0x6f},
    {0xac,0xab},{0xd2,0x5e},{0xcd,0x48},{0xac,0x7c},{0xac,0x77},
    {0xcf,0x76},{0xcf,0x6e},{0xac,0xac},{0xac,0xa4},{0xcf,0xa3},
    {0xac,0xa9},{0xac,0xa7},{0xcf,0x79},{0xac,0xa1},{0xcf,0x71},
    {0xac,0xa2},{0xac,0xa3},{0xcf,0x72},{0xcf,0xa6},{0xac,0x79},
    {0xcf,0x7e},{0x83,0xbe},{0x92,0xea},{0x93,0x48},{0x87,0xe9},
    {0x87,0xec},{0x8d,0xe1},{0x00,0x00},{0x88,0xf3},{0x84,0xf2},
    {0x00,0x00},{0x8e,0xe9},{0x89,0xec},{0x8a,0xd7},{0x00,0x00},
    {0x84,0xf3},{0x8e,0x74},{0x88,0xf1},{0x87,0xf0},{0x00,0x00},
    {0x00,0x00},{0x9b,0x6c},{0xd2,0x4c},{0xae,0xfd},{0xaf,0x43},
    {0x9b,0x6d},{0x93,0xbd},{0x00,0x00},{0xd2,0x55},{0xd2,0x5b},
    {0xd2,0x57},{0xd2,0x4a},{0xd2,0x4d},{0xd2,0x46},{0xd2,0x47},
    {0xaf,0x4a},{0xae,0xfa},{0xd2,0x56},{0xd2,0x5f},{0xaf,0x45},
    {0xae,0xf6},{0x00,0x00},{0xaf,0x40},{0xd2,0x4e},{0xaf,0x42},
    {0xd2,0x4f},{0xd2,0x59},{0x9b,0x6e},{0xfb,0xa7},{0x00,0x00},
    {0xaf,0x44},{0xd2,0x68},{0xd2,0x48},{0xae,0xfc},{0xae,0xfb},
    {0xaf,0x48},{0xd2,0x45},{0xd2,0x66},{0xd2,0x5a},{0xd2,0x67},
    {0xd2,0x61},{0xd2,0x53},{0xd2,0x62},{0x9b,0x6f},{0xd2,0x5c},
    {0xd2,0x65},{0xd2,0x63},{0xaf,0x49},{0xd2,0x54},{0xae,0xf9},
    {0xae,0xf8},{0xaf,0x41},{0xaf,0x47},{0xd2,0x60},{0xaf,0x46},
    {0xd2,0x51},{0xb2,0x43},{0x9b,0x70},{0xd2,0x69},{0xd2,0x50},
    {0xd2,0x4b},{0xae,0xfe},{0xaf,0x4b},{0xae,0xf7},{0xfe,0x5c},
    {0xd2,0x58},{0xd2,0x5d},{0x93,0xe8},{0x00,0x00},{0x89,0xed},
    {0x82,0x71},{0x8e,0xbb},{0x8d,0xcf},{0x86,0xda},{0x8e,0xbd},
    {0x84,0xf0},{0x00,0x00},{0x84,0xf4},{0x86,0xde},{0x9b,0x71},
    {0x87,0xee},{0x87,0xef},{0x86,0xd9},{0x89,0xef},{0xb2,0x65},
    {0xd5,0xe1},{0xd5,0xe5},{0x00,0x00},{0xb2,0x52},{0xb2,0x50},
    {0x00,0x00},{0x9b,0x72},{0xb2,0x47},{0xd5,0xe3},{0xd5,0xe2},
    {0xb2,0x5b},{0x00,0x00},{0xd5,0xe8},{0xb2,0x55},{0xfc,0xa1},
    {0xd5,0xfa},{0xd6,0x47},{0xb2,0x44},{0xd5,0xf7},{0xd5,0xf0},
    {0xb2,0x67},{0xd5,0xe0},{0x00,0x00},{0xd5,0xfc},{0x00,0x00},
    {0xb2,0x64},{0xb2,0x58},{0xb2,0x63},{0xb2,0x4e},{0xd5,0xec},
    {0xd5,0xfe},{0xd5,0xf6},{0xb2,0x4f},{0xb2,0x49},{0xd6,0x45},
    {0x00,0x00},{0xd5,0xfd},{0xd6,0x40},{0xb2,0x51},{0xb2,0x59},
    {0xd6,0x42},{0xd5,0xea},{0xd5,0xfb},{0xd5,0xef},{0xd6,0x44},
    {0xb2,0x5e},{0xb2,0x46},{0xb2,0x5c},{0xd5,0xf4},{0xd5,0xf2},
    {0xd5,0xf3},{0xb2,0x53},{0xd5,0xee},{0xd5,0xed},{0xb2,0x48},
    {0xd5,0xe7},{0xd6,0x46},{0xb2,0x4a},{0xd5,0xf1},{0xb2,0x68},
    {0x00,0x00},{0xb2,0x62},{0xd5,0xe6},{0xb2,0x5f},{0xb2,0x5d},
    {0xb2,0x66},{0xd5,0xf8},{0xb2,0x61},{0xd2,0x52},{0xd5,0xf9},
    {0xb2,0x60},{0xd6,0x41},{0xb2,0x45},{0xd5,0xf5},{0xb2,0x57},
    {0xd5,0xe9},{0xb2,0x56},{0xa0,0x67},{0xb2,0x54},{0xb2,0x4c},
    {0xb2,0x4b},{0xd9,0xe7},{0xd6,0x43},{0x9b,0x73},{0x00,0x00},
    {0xd5,0xeb},{0x00,0x00},{0x9b,0x74},{0xd9,0xfc},{0x9b,0x75},
    {0xb2,0x4d},{0x00,0x00},{0x92,0x64},{0x92,0xc6},{0x92,0xe4},
    {0x84,0x5d},{0x92,0xdd},{0x8d,0xd0},{0x86,0xd4},{0x8a,0xd5},
    {0x9b,0x76},{0x86,0xd8},{0x88,0xf6},{0x00,0x00},{0x92,0xaa},
    {0x86,0xdc},{0x94,0xaa},{0x8a,0xd3},{0x86,0xdd},{0x9b,0x77},
    {0xb5,0x41},{0xb2,0x5a},{0xb4,0xee},{0xd9,0xf6},{0xb4,0xfc},
    {0x00,0x00},{0xd9,0xea},{0xb4,0xeb},{0xb4,0xe7},{0xda,0x49},
    {0xb4,0xed},{0xb4,0xf1},{0xb4,0xec},{0xb4,0xf5},{0xda,0x4d},
    {0xda,0x44},{0xa0,0x68},{0x9b,0x78},{0xd9,0xf1},{0xb4,0xfa},
    {0xb4,0xf4},{0xd9,0xfd},{0xb4,0xe4},{0xda,0x4a},{0xda,0x43},
    {0xb4,0xe8},{0xd9,0xf7},{0xb4,0xf7},{0xda,0x55},{0xda,0x56},
    {0x00,0x00},{0xb4,0xe5},{0xda,0x48},{0xb4,0xf9},{0xd9,0xfb},
    {0xd9,0xed},{0xd9,0xee},{0xb4,0xfd},{0xd9,0xf2},{0xd9,0xf9},
    {0xd9,0xf3},{0x00,0x00},{0xb4,0xfb},{0xb5,0x44},{0xd9,0xef},
    {0xd9,0xe8},{0xd9,0xe9},{0x00,0x00},{0xd9,0xeb},{0xb4,0xea},
    {0xd9,0xf8},{0x00,0x00},{0xb4,0xf8},{0xb5,0x42},{0xfc,0x7e},
    {0x9b,0x79},{0xd9,0xfa},{0xda,0x53},{0xda,0x4b},{0xb4,0xe6},
    {0xda,0x51},{0xb4,0xf2},{0x9d,0xcb},{0xb4,0xf0},{0x9b,0x7a},
    {0xda,0x57},{0xb4,0xef},{0xda,0x41},{0xd9,0xf4},{0xd9,0xfe},
    {0xb5,0x47},{0xda,0x45},{0xda,0x42},{0xd9,0xf0},{0xb5,0x43},
    {0xda,0x4f},{0xda,0x4c},{0xda,0x54},{0xb4,0xe9},{0xda,0x40},
    {0xb5,0x46},{0x00,0x00},{0xda,0x47},{0x00,0x00},{0x00,0x00},
    {0xb4,0xf3},{0xb4,0xf6},{0x00,0x00},{0xda,0x46},{0xb5,0x45},
    {0xd9,0xf5},{0xd5,0xe4},{0x00,0x00},{0xa0,0x69},{0xda,0x50},
    {0xda,0x4e},{0xda,0x52},{0x00,0x00},{0x00,0x00},{0x95,0xcb},
    {0x00,0x00},{0x8d,0x6f},{0x85,0xda},{0x93,0xd2},{0x00,0x00},
    {0xa0,0x6a},{0x87,0xed},{0x00,0x00},{0x8a,0xd6},{0xa0,0x6b},
    {0x00,0x00},{0xd9,0xec},{0xb5,0x40},{0x00,0x00},{0xfe,0x6a},
    {0x82,0x78},{0xde,0x61},{0xde,0x60},{0xde,0x46},{0xb7,0xbd},
    {0x00,0x00},{0xde,0x5f},{0xde,0x49},{0xde,0x4a},{0x00,0x00},
    {0xb7,0xc7},{0xde,0x68},{0xb7,0xc2},{0xde,0x5e},{0x9b,0x7b},
    {0xde,0x43},{0xb7,0xc8},{0xb7,0xbe},{0xde,0x52},{0xde,0x48},
    {0xde,0x4b},{0xde,0x63},{0xb7,0xb8},{0xde,0x6a},{0xde,0x62},
    {0xb7,0xc1},{0xde,0x57},{0xb7,0xcc},{0x00,0x00},{0x00,0x00},
    {0xb7,0xcb},{0xb7,0xc5},{0x00,0x00},{0x00,0x00},{0xde,0x69},
    {0xb7,0xb9},{0xde,0x55},{0xde,0x4c},{0xde,0x59},{0xde,0x65},
    {0xb7,0xcd},{0x9b,0x7c},{0xb7,0xbb},{0xde,0x54},{0x9b,0x7d},
    {0xde,0x4d},{0xb7,0xc4},{0xa0,0x6c},{0xb7,0xc3},{0xde,0x50},
    {0xde,0x5a},{0xde,0x64},{0xde,0x47},{0xde,0x51},{0xb7,0xbc},
    {0xde,0x5b},{0xb7,0xc9},{0xb7,0xc0},{0xde,0x4e},{0xb7,0xbf},
    {0xde,0x45},{0xde,0x53},{0xde,0x67},{0xb4,0xfe},{0xba,0xb0},
    {0xde,0x56},{0xe2,0x6c},{0xde,0x58},{0xde,0x66},{0xb7,0xc6},
    {0xde,0x4f},{0xb7,0xba},{0xb7,0xca},{0xbc,0xf0},{0xde,0x44},
    {0x8e,0xbe},{0xde,0x5d},{0x95,0x50},{0x86,0xd3},{0x9b,0x7e},
    {0xde,0x5c},{0x93,0x69},{0x86,0xd7},{0xa0,0x6d},{0x90,0x41},
    {0x86,0xd6},{0xa0,0x6e},{0x00,0x00},{0x8a,0xd4},{0x89,0xee},
    {0x8d,0x7b},{0x00,0x00},{0x89,0xeb},{0x8c,0xd2},{0x00,0x00},
    {0xe2,0xaa},{0xba,0xad},{0xe2,0x7d},{0xe2,0xa4},{0xba,0xa2},
    {0x00,0x00},{0xe2,0x6e},{0xba,0xaf},{0x00,0x00},{0xba,0x77},
    {0xe2,0x6d},{0xe2,0xb0},{0xba,0xb1},{0xe2,0x71},{0xe2,0xa3},
    {0x9b,0xa1},{0xe2,0x73},{0xe2,0xb3},{0xe2,0xaf},{0xba,0x75},
    {0xba,0xa1},{0xe6,0x53},{0xba,0xae},{0xba,0x7d},{0xe2,0x6f},
    {0x9b,0xa2},{0xe2,0xae},{0xba,0xa3},{0xe2,0xab},{0xe2,0xb8},
    {0xe2,0x75},{0xe2,0x7e},{0x9b,0xa3},{0x9b,0xa4},{0xe2,0xb6},
    {0xe2,0xac},{0xba,0x7c},{0x00,0x00},{0xa0,0x6f},{0xe2,0x7c},
    {0xba,0x76},{0xba,0x74},{0xba,0xa8},{0x9b,0xa5},{0x9b,0xa6},
    {0xe2,0x7a},{0xe2,0x77},{0xe2,0x78},{0x00,0x00},{0xe2,0xb2},
    {0x00,0x00},{0xe2,0xb7},{0xe2,0xb5},{0xba,0x7a},{0xe2,0xb9},
    {0xba,0x7e},{0xba,0xa7},{0xa0,0x70},{0xe2,0x70},{0xe5,0xfa},
    {0xe2,0x79},{0x00,0x00},{0xba,0x78},{0xba,0xac},{0xba,0xa9},
    {0xba,0x7b},{0xe2,0xa5},{0xe2,0x74},{0xba,0xaa},{0xe2,0xa7},
    {0xba,0xa4},{0xba,0xa6},{0xba,0x73},{0x9b,0xa7},{0xe2,0xa9},
    {0xe2,0xa1},{0xe2,0x72},{0xba,0xa5},{0xe2,0xb1},{0xe2,0xb4},
    {0xe2,0x7b},{0xe2,0xa8},{0x9b,0xa8},{0xba,0x79},{0xbc,0xdf},
    {0xe2,0xa6},{0xe5,0xf9},{0x00,0x00},{0xe2,0xad},{0xfc,0xa2},
    {0x82,0x50},{0x8f,0xbd},{0x8b,0x7c},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x8b,0xfb},{0x00,0x00},{0x89,0xf0},{0xe2,0x76},
    {0xe6,0x44},{0xe6,0x4e},{0xbc,0xe2},{0xe6,0x4d},{0xe6,0x59},
    {0xbc,0xe4},{0xe6,0x4b},{0x9b,0xa9},{0xe6,0x4f},{0xbc,0xef},
    {0x00,0x00},{0xe6,0x46},{0xbc,0xe7},{0x90,0xb9},{0xe6,0x52},
    {0xe9,0xf0},{0xbc,0xf3},{0xbc,0xf2},{0xe6,0x54},{0xe6,0x43},
    {0xe6,0x5e},{0xbc,0xed},{0x00,0x00},{0xbc,0xe3},{0xe6,0x57},
    {0x00,0x00},{0xe6,0x5b},{0xe6,0x60},{0xe6,0x55},{0xe6,0x49},
    {0xbc,0xe6},{0xbc,0xe9},{0xbc,0xf1},{0xbc,0xec},{0x00,0x00},
    {0xe6,0x4c},{0xe2,0xa2},{0xa0,0x71},{0x00,0x00},{0xe6,0x48},
    {0xe6,0x5f},{0xbc,0xe8},{0x9b,0xaa},{0xbc,0xeb},{0xe6,0x61},
    {0xbc,0xe0},{0xe6,0x56},{0xe5,0xfb},{0xe6,0x5c},{0xc0,0xdf},
    {0x95,0x6b},{0xe6,0x4a},{0x00,0x00},{0xbc,0xe1},{0xe6,0x45},
    {0xbc,0xe5},{0xe5,0xfc},{0xba,0xab},{0xe6,0x41},{0x9b,0xab},
    {0xe6,0x5a},{0xe6,0x42},{0xe6,0x40},{0xbc,0xea},{0x00,0x00},
    {0xe6,0x58},{0xa0,0x72},{0xe5,0xfe},{0xe6,0x51},{0xe6,0x50},
    {0xe6,0x5d},{0xe6,0x47},{0xbc,0xee},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x8b,0xfa},{0x9b,0xac},{0xe9,0xf3},
    {0x9b,0xad},{0xbf,0x49},{0xbe,0xfe},{0xea,0x40},{0xe9,0xeb},
    {0xbf,0x41},{0xe9,0xf7},{0xbf,0x48},{0xbf,0x43},{0xe9,0xf5},
    {0xed,0x4f},{0xe9,0xfb},{0xea,0x42},{0xe9,0xfa},{0xe9,0xe9},
    {0xe9,0xf8},{0xea,0x44},{0xea,0x46},{0xbe,0xfd},{0xea,0x45},
    {0xbf,0x44},{0xbf,0x4a},{0xa0,0x73},{0xbf,0x47},{0x00,0x00},
    {0xe9,0xfe},{0xbf,0x46},{0xe9,0xf9},{0x9b,0xae},{0xe9,0xed},
    {0xe9,0xf2},{0x9b,0xaf},{0xe9,0xfd},{0xbf,0x45},{0xbf,0x42},
    {0xbe,0xfc},{0xbf,0x40},{0xe9,0xf1},{0x00,0x00},{0xe5,0xfd},
    {0xe9,0xec},{0xe9,0xef},{0xea,0x41},{0xe9,0xf4},{0xe9,0xea},
    {0xed,0x4e},{0xea,0x43},{0xe9,0xee},{0xe9,0xfc},{0x00,0x00},
    {0x8b,0x7d},{0x8b,0xa1},{0x9b,0xb0},{0xed,0x51},{0xc0,0xe3},
    {0x00,0x00},{0x00,0x00},{0xc0,0xd7},{0x9b,0xb1},{0xfc,0xa4},
    {0xc0,0xdb},{0xed,0x53},{0xed,0x59},{0xed,0x57},{0xc0,0xd9},
    {0xc0,0xda},{0xc0,0xe1},{0xed,0x5a},{0xed,0x52},{0xc0,0xdc},
    {0x00,0x00},{0xed,0x56},{0xed,0x55},{0xed,0x5b},{0xc0,0xe2},
    {0x00,0x00},{0xc0,0xdd},{0xc0,0xe0},{0xed,0x54},{0xc0,0xe4},
    {0xc0,0xde},{0xc0,0xe5},{0xc0,0xd8},{0xed,0x58},{0xa0,0x74},
    {0xed,0x50},{0xa0,0x75},{0x95,0xc6},{0xef,0xf7},{0x9b,0xb2},
    {0x00,0x00},{0xc2,0x71},{0xef,0xf4},{0xef,0xf6},{0x00,0x00},
    {0xc2,0x6f},{0xef,0xf2},{0xef,0xf3},{0xef,0xee},{0x00,0x00},
    {0x9b,0xb3},{0xe9,0xf6},{0xef,0xef},{0xc2,0x70},{0xef,0xeb},
    {0x00,0x00},{0xc2,0x6d},{0xef,0xf8},{0xc2,0x6e},{0xef,0xec},
    {0xef,0xed},{0xef,0xf1},{0xc2,0x73},{0x00,0x00},{0xc2,0x72},
    {0x00,0x00},{0x00,0x00},{0xef,0xf0},{0xc3,0x78},{0xf2,0x5f},
    {0xf2,0x65},{0xc3,0x79},{0xf2,0x5c},{0xc3,0x76},{0xc3,0x73},
    {0xf2,0x67},{0xc3,0x77},{0xfe,0xa1},{0xc3,0x74},{0xf2,0x5e},
    {0xf2,0x61},{0xf2,0x62},{0xf2,0x63},{0xf2,0x66},{0x00,0x00},
    {0xef,0xf5},{0xf2,0x5d},{0xc3,0x75},{0xf2,0x64},{0xf2,0x68},
    {0xf2,0x60},{0x93,0x40},{0x00,0x00},{0x00,0x00},{0xf4,0x5d},
    {0xc4,0x6a},{0xf4,0x60},{0xc4,0x6b},{0xf4,0x68},{0xf4,0x5f},
    {0xf4,0x5c},{0x00,0x00},{0xf4,0x5e},{0xf4,0x62},{0xf4,0x65},
    {0xf4,0x64},{0xf4,0x67},{0xf4,0x5b},{0x00,0x00},{0xc4,0x69},
    {0xf4,0x63},{0xf4,0x66},{0xf4,0x69},{0xf4,0x61},{0xf5,0xd3},
    {0xf5,0xd4},{0xf5,0xd8},{0xf5,0xd9},{0x00,0x00},{0xf5,0xd6},
    {0xf5,0xd7},{0xf5,0xd5},{0x9b,0xb4},{0xc4,0xe9},{0x9b,0xb5},
    {0x00,0x00},{0x90,0x76},{0x9b,0xb6},{0xc5,0x78},{0xf6,0xeb},
    {0x00,0x00},{0x9b,0xb7},{0xf6,0xe8},{0xf6,0xe9},{0xf6,0xea},
    {0xc5,0x79},{0x00,0x00},{0xf7,0xe5},{0xf7,0xe4},{0x9b,0xb8},
    {0xf8,0xaf},{0xc5,0xf4},{0xf8,0xad},{0xf8,0xb0},{0xf8,0xae},
    {0xf8,0xf5},{0xc6,0x57},{0xc6,0x65},{0xf9,0xa3},{0xf9,0x6c},
    {0x9b,0xb9},{0xf9,0xa2},{0xf9,0xd0},{0xf9,0xd1},{0xa4,0xf5},
    {0x9c,0xf6},{0x85,0xd9},{0x00,0x00},{0x88,0xf9},{0xa6,0xc7},
    {0xca,0x41},{0x00,0x00},{0x00,0x00},{0xcb,0x5e},{0x8d,0x5f},
    {0xa8,0x5f},{0x9b,0xba},{0xa8,0x62},{0x9b,0xbb},{0xcb,0x5f},
    {0x00,0x00},{0xa8,0x60},{0xa8,0x61},{0x83,0x4d},{0x89,0xf2},
    {0x85,0xdf},{0xfc,0xa5},{0xcd,0x58},{0xcd,0x5a},{0xcd,0x55},
    {0xcd,0x52},{0xcd,0x54},{0x00,0x00},{0x00,0x00},{0x93,0xf4},
    {0xaa,0xa4},{0x9b,0xbc},{0x00,0x00},{0xfe,0xa3},{0xaa,0xa2},
    {0x9b,0xbd},{0x00,0x00},{0xcd,0x56},{0xaa,0xa3},{0xcd,0x53},
    {0xcd,0x50},{0xaa,0xa1},{0xcd,0x57},{0x00,0x00},{0xcd,0x51},
    {0xaa,0xa5},{0xcd,0x59},{0x00,0x00},{0x8e,0x45},{0x8e,0x76},
    {0x00,0x00},{0xcf,0xaf},{0x9b,0xbe},{0xcf,0xb3},{0x00,0x00},
    {0x9b,0xbf},{0xac,0xb7},{0x9b,0xc0},{0x9b,0xc1},{0x9b,0xc2},
    {0x00,0x00},{0xcf,0xb6},{0x00,0x00},{0xac,0xaf},{0xac,0xb2},
    {0xac,0xb4},{0xac,0xb6},{0xac,0xb3},{0xcf,0xb2},{0xcf,0xb1},
    {0x00,0x00},{0xac,0xb1},{0xcf,0xb4},{0xcf,0xb5},{0x00,0x00},
    {0xcf,0xae},{0xac,0xb5},{0x8a,0xbb},{0xac,0xb0},{0xa0,0x76},
    {0x85,0xde},{0x88,0xf7},{0xcf,0xb0},{0x00,0x00},{0xa0,0x77},
    {0x8b,0xa3},{0x8c,0x7a},{0x8d,0xd1},{0x9b,0xc3},{0xd2,0x77},
    {0xd2,0x78},{0xd2,0x79},{0xaf,0x50},{0x00,0x00},{0xaf,0x4c},
    {0xd2,0x6e},{0x9b,0xc4},{0xd2,0x76},{0xd2,0x7b},{0xaf,0x51},
    {0x9b,0xc5},{0xd2,0x6c},{0xd2,0x72},{0xd2,0x6b},{0xd2,0x75},
    {0xfc,0x57},{0x9b,0xc6},{0xd2,0x71},{0xaf,0x4d},{0xaf,0x4f},
    {0xd2,0x7a},{0x89,0xf3},{0xd2,0x6a},{0xd2,0x6d},{0xd2,0x73},
    {0x95,0xaf},{0xd2,0x74},{0xd2,0x7c},{0xd2,0x70},{0x00,0x00},
    {0xaf,0x4e},{0x00,0x00},{0x85,0xdd},{0x88,0xf8},{0x8e,0xea},
    {0x89,0xf4},{0x00,0x00},{0x88,0xfa},{0x8a,0xd8},{0x87,0xf1},
    {0x00,0x00},{0xb2,0x6d},{0xd6,0x4e},{0x95,0x49},{0x00,0x00},
    {0xd6,0x50},{0xd6,0x4c},{0x9c,0x40},{0xd6,0x58},{0xd6,0x4a},
    {0xd6,0x57},{0xb2,0x69},{0xd6,0x48},{0xda,0x5b},{0xd6,0x52},
    {0xb2,0x6c},{0x9c,0x4b},{0xd6,0x53},{0xd6,0x56},{0x00,0x00},
    {0xd6,0x5a},{0x00,0x00},{0xd6,0x4f},{0x9c,0x4c},{0xd6,0x54},
    {0x00,0x00},{0x00,0x00},{0xb2,0x6a},{0xb2,0x6b},{0xd6,0x59},
    {0xd6,0x4d},{0xd6,0x49},{0xd6,0x5b},{0xa0,0x78},{0xd6,0x51},
    {0x00,0x00},{0x00,0x00},{0xd6,0x55},{0x82,0x44},{0x85,0xe0},
    {0x88,0xfb},{0xd6,0x4b},{0x8a,0xd9},{0xb5,0x48},{0xb5,0x49},
    {0xda,0x65},{0xb5,0x4f},{0x9c,0x4d},{0xda,0x59},{0xda,0x62},
    {0xda,0x58},{0xb5,0x4c},{0xda,0x60},{0xda,0x5e},{0x00,0x00},
    {0xda,0x5f},{0xb5,0x4a},{0x00,0x00},{0xda,0x63},{0x9c,0x4e},
    {0x00,0x00},{0x9c,0x4f},{0x9c,0x50},{0x00,0x00},{0xda,0x5c},
    {0xda,0x5a},{0xb5,0x4b},{0xda,0x5d},{0xda,0x61},{0x9c,0x51},
    {0xfc,0xa7},{0x9c,0x52},{0xb5,0x4d},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0xda,0x64},{0x9c,0x53},{0x92,0xe5},{0x00,0x00},
    {0x9c,0x54},{0xfe,0x76},{0x9c,0x55},{0xde,0x70},{0xde,0x77},
    {0xde,0x79},{0xde,0xa1},{0xfb,0x66},{0xb7,0xda},{0xde,0x6b},
    {0x00,0x00},{0xb7,0xd2},{0x95,0x4f},{0xde,0x7a},{0xb7,0xd7},
    {0xde,0xa2},{0xb7,0xce},{0x9c,0x56},{0xde,0x7d},{0x95,0x5f},
    {0xde,0x6d},{0xde,0x7e},{0xde,0x6c},{0xa0,0x7a},{0xb7,0xdc},
    {0x9d,0xcd},{0xde,0x78},{0xb7,0xcf},{0xde,0xa3},{0x00,0x00},
    {0xb7,0xd4},{0xde,0x71},{0xb7,0xd9},{0xde,0x7c},{0xde,0x6f},
    {0xde,0x76},{0xde,0x72},{0xde,0x6e},{0xb7,0xd1},{0xb7,0xd8},
    {0xb7,0xd6},{0xb7,0xd3},{0xb7,0xdb},{0xb7,0xd0},{0xde,0x75},
    {0x9c,0x57},{0xb7,0xd5},{0x00,0x00},{0xb5,0x4e},{0x00,0x00},
    {0xde,0x7b},{0xfe,0x53},{0xde,0x73},{0xa0,0x7b},{0x00,0x00},
    {0x9c,0x58},{0xfc,0xa9},{0x9c,0x59},{0xde,0x74},{0x00,0x00},
    {0xa0,0x7c},{0xe2,0xc1},{0x9c,0x5a},{0xba,0xb4},{0x9c,0x5b},
    {0x00,0x00},{0xe2,0xbd},{0xe2,0xc3},{0xe2,0xbf},{0x00,0x00},
    {0xba,0xb6},{0xe2,0xbe},{0xe2,0xc2},{0xe2,0xba},{0xa0,0xd8},
    {0xe2,0xbc},{0xba,0xb5},{0x00,0x00},{0x9c,0x5c},{0x00,0x00},
    {0x9c,0x5d},{0xe2,0xc0},{0xe2,0xbb},{0x9c,0x5e},{0xba,0xb7},
    {0x00,0x00},{0xba,0xb2},{0x94,0xab},{0x9c,0x5f},{0xe2,0xc4},
    {0xa0,0xe7},{0xba,0xb3},{0xe6,0x67},{0xe6,0x64},{0xe6,0x70},
    {0xe6,0x6a},{0xe6,0x6c},{0xbc,0xf4},{0xe6,0x66},{0xe6,0x6e},
    {0x9c,0x60},{0x9c,0x61},{0xe6,0x6d},{0xe6,0x6b},{0x00,0x00},
    {0xe6,0x71},{0xbc,0xf7},{0xe6,0x68},{0xe6,0x6f},{0x00,0x00},
    {0xbc,0xf5},{0x9c,0x62},{0x00,0x00},{0xe6,0x63},{0xe6,0x65},
    {0xbc,0xf6},{0xe6,0x62},{0xe6,0x72},{0x9c,0x63},{0xe6,0x69},
    {0x00,0x00},{0x9c,0x64},{0xea,0x4a},{0xbf,0x51},{0x9c,0x65},
    {0x00,0x00},{0xea,0x55},{0xea,0x53},{0xbf,0x4b},{0xea,0x49},
    {0xea,0x4c},{0xea,0x4d},{0xea,0x48},{0xbf,0x55},{0xbf,0x56},
    {0xea,0x47},{0xea,0x56},{0xea,0x51},{0xbf,0x4f},{0xbf,0x4c},
    {0xea,0x50},{0xea,0x4e},{0x00,0x00},{0x00,0x00},{0xbf,0x52},
    {0xea,0x52},{0xbf,0x4d},{0x9c,0x66},{0xbf,0x4e},{0x00,0x00},
    {0xea,0x4f},{0xbf,0x50},{0xea,0x4b},{0xa0,0xe8},{0xea,0x54},
    {0xbf,0x53},{0xea,0x57},{0xea,0x58},{0xbf,0x54},{0x9c,0x67},
    {0x00,0x00},{0xc0,0xe7},{0xc0,0xee},{0xed,0x5c},{0xed,0x62},
    {0x00,0x00},{0xed,0x60},{0xc0,0xea},{0xc0,0xe9},{0xc0,0xe6},
    {0xed,0x5e},{0x00,0x00},{0x00,0x00},{0x9c,0x68},{0xc0,0xec},
    {0xc0,0xeb},{0xc0,0xe8},{0x00,0x00},{0xed,0x61},{0xed,0x5d},
    {0xed,0x5f},{0x00,0x00},{0xc0,0xed},{0xa0,0xf5},{0xfb,0x70},
    {0x00,0x00},{0xc2,0x77},{0xef,0xfb},{0x00,0x00},{0xc2,0x74},
    {0xc2,0x75},{0xef,0xfd},{0xc2,0x76},{0xef,0xfa},{0x9c,0x69},
    {0xef,0xf9},{0xf2,0x6c},{0xef,0xfc},{0x00,0x00},{0xf2,0x6d},
    {0xc3,0x7a},{0xf2,0x6b},{0x00,0x00},{0x9c,0x6a},{0xf2,0x6a},
    {0x00,0x00},{0xf2,0x69},{0xc3,0x7b},{0x9c,0x6b},{0x9c,0x6c},
    {0xc4,0x6c},{0x00,0x00},{0x00,0x00},{0xf4,0x6a},{0xf4,0x6b},
    {0xfc,0xac},{0x9c,0x6d},{0x9c,0x6e},{0x00,0x00},{0xf5,0xdc},
    {0xf5,0xdb},{0xc4,0xea},{0x00,0x00},{0xf5,0xda},{0xf6,0xec},
    {0xf6,0xed},{0x00,0x00},{0x00,0x00},{0xf7,0xe6},{0xf8,0xb1},
    {0x9c,0x6f},{0x9d,0x5a},{0xf8,0xf6},{0xf9,0xbc},{0xc6,0x79},
    {0xf9,0xc6},{0xa4,0xf6},{0x91,0xc9},{0xaa,0xa6},{0xaa,0xa7},
    {0x9c,0x71},{0x00,0x00},{0xac,0xb8},{0x85,0xc6},{0xfa,0x64},
    {0x00,0x00},{0x00,0x00},{0xc0,0xef},{0xa4,0xf7},{0x85,0xe1},
    {0xaa,0xa8},{0xaf,0x52},{0xb7,0xdd},{0xa4,0xf8},{0xfa,0x65},
    {0xb2,0x6e},{0xba,0xb8},{0xc9,0x62},{0x95,0xa7},{0xcf,0xb7},
    {0xd2,0x7d},{0x00,0x00},{0xe2,0xc5},{0x00,0x00},{0xc0,0xf0},
    {0xa4,0xf9},{0xaa,0xa9},{0xcf,0xb8},{0xcf,0xb9},{0xda,0x66},
    {0xb5,0x50},{0x8b,0xa4},{0x00,0x00},{0xde,0xa4},{0xfc,0xad},
    {0x00,0x00},{0xb7,0xde},{0xe2,0xc6},{0x00,0x00},{0x95,0x6e},
    {0xbc,0xf8},{0x9c,0x73},{0xc3,0x7c},{0xa4,0xfa},{0xda,0x67},
    {0xa4,0xfb},{0x9c,0x74},{0xa6,0xc9},{0xca,0x42},{0xa6,0xc8},
    {0xa8,0x65},{0xa8,0x64},{0xa8,0x63},{0xcb,0x60},{0x00,0x00},
    {0x00,0x00},{0xfa,0x66},{0xaa,0xaa},{0x00,0x00},{0xaa,0xab},
    {0xcd,0x5b},{0x00,0x00},{0xcf,0xba},{0x00,0x00},{0xcf,0xbd},
    {0xac,0xba},{0xcf,0xbb},{0x00,0x00},{0xac,0xb9},{0xcf,0xbc},
    {0xac,0xbb},{0x84,0x61},{0xd2,0xa2},{0xd2,0xa1},{0xd2,0x7e},
    {0xaf,0x53},{0x8c,0x7b},{0xd6,0x5d},{0xd6,0x5e},{0xb2,0x6f},
    {0xd6,0x5c},{0xd6,0x5f},{0xb5,0x52},{0xb2,0x70},{0xfa,0x67},
    {0x00,0x00},{0xb5,0x51},{0xda,0x6b},{0xda,0x6a},{0xfc,0xae},
    {0xda,0x68},{0xda,0x69},{0x8b,0xa5},{0xda,0x6c},{0xde,0xa6},
    {0xde,0xa5},{0xde,0xa9},{0xfa,0x68},{0xde,0xa8},{0xde,0xa7},
    {0xba,0xb9},{0xe2,0xc9},{0x9c,0x75},{0xe2,0xc8},{0xba,0xba},
    {0xe2,0xc7},{0xe6,0x73},{0x00,0x00},{0xe6,0x74},{0xbc,0xf9},
    {0x00,0x00},{0xea,0x59},{0xea,0x5a},{0xfa,0x69},{0x92,0x71},
    {0xf2,0x72},{0xc3,0x7d},{0xf2,0x71},{0xf2,0x70},{0xf2,0x6e},
    {0xf2,0x6f},{0xc4,0xeb},{0xf4,0x6c},{0xf6,0xee},{0xf8,0xf7},
    {0x00,0x00},{0xa4,0xfc},{0xfa,0x6a},{0xc9,0xa5},{0xa5,0xc7},
    {0xc9,0xa6},{0xfa,0x6b},{0xfc,0xb0},{0x00,0x00},{0xca,0x43},
    {0xca,0x44},{0x83,0x5d},{0x8a,0xda},{0xfa,0x6c},{0x84,0xf6},
    {0xcb,0x66},{0x00,0x00},{0x00,0x00},{0xcb,0x62},{0xfa,0x6d},
    {0xcb,0x61},{0xaa,0xac},{0xcb,0x65},{0xa8,0x67},{0xcb,0x63},
    {0xa8,0x66},{0xcb,0x67},{0xcb,0x64},{0x00,0x00},{0x83,0xc1},
    {0xcd,0x5f},{0xcf,0xbe},{0xcd,0x5d},{0xcd,0x64},{0xfa,0x6e},
    {0xaa,0xad},{0x00,0x00},{0xaa,0xb0},{0xcd,0x65},{0xcd,0x61},
    {0x00,0x00},{0xcd,0x62},{0x00,0x00},{0xcd,0x5c},{0xaa,0xaf},
    {0xcd,0x5e},{0xaa,0xae},{0xcd,0x63},{0xfa,0x6f},{0xcd,0x60},
    {0x00,0x00},{0x89,0xf6},{0xcf,0xc2},{0xac,0xbd},{0xac,0xbe},
    {0xfc,0xb1},{0xcf,0xc5},{0xcf,0xbf},{0x00,0x00},{0xcf,0xc4},
    {0x00,0x00},{0xcf,0xc0},{0xac,0xbc},{0xcf,0xc3},{0xcf,0xc1},
    {0x88,0xfc},{0x83,0xc0},{0x85,0xe2},{0x8e,0xec},{0x84,0x62},
    {0x86,0xe2},{0x8e,0x47},{0xd2,0xa8},{0xd2,0xa5},{0x00,0x00},
    {0xd2,0xa7},{0xaf,0x58},{0xaf,0x57},{0xaf,0x55},{0xd2,0xa4},
    {0xd2,0xa9},{0xaf,0x54},{0xaf,0x56},{0xd2,0xa6},{0xd6,0x67},
    {0xd2,0xa3},{0xd2,0xaa},{0xfc,0xb2},{0x8e,0xeb},{0x9c,0x76},
    {0x00,0x00},{0x00,0x00},{0xd6,0x62},{0xd6,0x66},{0x00,0x00},
    {0xd6,0x65},{0xda,0x6e},{0xda,0x79},{0x00,0x00},{0x8a,0xdb},
    {0xd6,0x68},{0x9c,0x77},{0xd6,0x63},{0xda,0x6d},{0xb2,0x74},
    {0x00,0x00},{0x8f,0x55},{0xb2,0x73},{0xd6,0x61},{0xd6,0x64},
    {0xb2,0x75},{0x00,0x00},{0xb2,0x72},{0xb2,0x71},{0xd6,0x60},
    {0xd6,0x69},{0x93,0xe6},{0x00,0x00},{0x8c,0xd3},{0xda,0x70},
    {0xda,0x77},{0xfa,0x70},{0xb5,0x54},{0xda,0x76},{0xda,0x73},
    {0xfc,0xb4},{0xb5,0x56},{0x95,0xbd},{0x95,0xbc},{0xfc,0xaf},
    {0xda,0x75},{0x95,0x52},{0xfa,0x71},{0xda,0x6f},{0xda,0x71},
    {0xda,0x74},{0xda,0x72},{0xb5,0x55},{0xda,0x78},{0xb5,0x53},
    {0xb7,0xdf},{0xfa,0x72},{0xfa,0x73},{0xde,0xad},{0xde,0xac},
    {0xde,0xaa},{0x00,0x00},{0xb7,0xe2},{0xb7,0xe1},{0xde,0xae},
    {0x9c,0x78},{0xde,0xab},{0xe2,0xca},{0xba,0xbb},{0xb7,0xe0},
    {0x00,0x00},{0x00,0x00},{0xfc,0xb3},{0xde,0xb0},{0xde,0xaf},
    {0x00,0x00},{0xe2,0xcd},{0xe2,0xcb},{0xbc,0xfa},{0xfc,0xb5},
    {0xba,0xbc},{0xe2,0xcc},{0xe6,0x76},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0xbc,0xfb},{0xe6,0x75},{0xe6,0x7e},
    {0xe6,0x7d},{0xe6,0x7b},{0x00,0x00},{0xe6,0x7a},{0xe6,0x77},
    {0xe6,0x78},{0xe6,0x79},{0xe6,0x7c},{0xe6,0xa1},{0x92,0xde},
    {0x00,0x00},{0xea,0x5f},{0xea,0x5c},{0xea,0x5d},{0xbf,0x57},
    {0xea,0x5b},{0xea,0x61},{0xea,0x60},{0xea,0x5e},{0x8b,0xa7},
    {0xed,0x64},{0xed,0x65},{0xc0,0xf1},{0xfc,0xb6},{0xc0,0xf2},
    {0xed,0x63},{0x9c,0x79},{0xc2,0x79},{0xef,0xfe},{0xc2,0x78},
    {0xc3,0x7e},{0x00,0x00},{0xc3,0xa1},{0xc4,0x6d},{0xf4,0x6e},
    {0xf4,0x6d},{0xf5,0xdd},{0xf6,0xef},{0xc5,0x7a},{0xf7,0xe8},
    {0xf7,0xe7},{0xf7,0xe9},{0xa5,0xc8},{0xcf,0xc6},{0xaf,0x59},
    {0xb2,0x76},{0xd6,0x6a},{0xa5,0xc9},{0xc9,0xa7},{0xa4,0xfd},
    {0x9c,0x7a},{0x00,0x00},{0xca,0x45},{0x9c,0x7b},{0x00,0x00},
    {0x88,0xfd},{0xcb,0x6c},{0xcb,0x6a},{0xcb,0x6b},{0xcb,0x68},
    {0xa8,0x68},{0xcb,0x69},{0x9c,0x7c},{0x00,0x00},{0x00,0x00},
    {0x86,0xe4},{0x9c,0x7d},{0xcd,0x6d},{0x9c,0x7e},{0xaa,0xb3},
    {0xcd,0x6b},{0xcd,0x67},{0xcd,0x6a},{0x00,0x00},{0xcd,0x66},
    {0xaa,0xb5},{0xcd,0x69},{0x9c,0xa1},{0xaa,0xb2},{0xaa,0xb1},
    {0x9c,0xa2},{0xaa,0xb4},{0xcd,0x6c},{0xcd,0x68},{0x8e,0x48},
    {0x89,0xf8},{0x84,0x63},{0x00,0x00},{0xac,0xc2},{0xac,0xc5},
    {0xcf,0xce},{0xcf,0xcd},{0xcf,0xcc},{0xac,0xbf},{0xcf,0xd5},
    {0xcf,0xcb},{0x8b,0xa8},{0xac,0xc1},{0xd2,0xaf},{0xfa,0x74},
    {0xcf,0xd2},{0xcf,0xd0},{0xac,0xc4},{0x00,0x00},{0xcf,0xc8},
    {0xcf,0xd3},{0x00,0x00},{0xcf,0xca},{0xcf,0xd4},{0xcf,0xd1},
    {0xcf,0xc9},{0x95,0xbe},{0xac,0xc0},{0xcf,0xd6},{0xcf,0xc7},
    {0xac,0xc3},{0xfa,0x75},{0x95,0xb6},{0x90,0xb2},{0x8b,0xfd},
    {0xd2,0xb4},{0xd2,0xab},{0xd2,0xb6},{0x9c,0xa3},{0xd2,0xae},
    {0xd2,0xb9},{0xd2,0xba},{0xd2,0xac},{0xd2,0xb8},{0xd2,0xb5},
    {0xd2,0xb3},{0xd2,0xb7},{0xaf,0x5f},{0x00,0x00},{0xaf,0x5d},
    {0x9c,0xa4},{0x9c,0xa5},{0xd2,0xb1},{0x9c,0xa6},{0xd2,0xad},
    {0x9c,0xa7},{0xd2,0xb0},{0xd2,0xbb},{0xd2,0xb2},{0xaf,0x5e},
    {0xcf,0xcf},{0x00,0x00},{0xaf,0x5a},{0xaf,0x5c},{0x9c,0xa8},
    {0x00,0x00},{0xfa,0x76},{0x85,0xe4},{0x9c,0xa9},{0xd6,0x78},
    {0xd6,0x6d},{0xd6,0x6b},{0xfe,0xaa},{0xd6,0x6c},{0x9c,0xab},
    {0xd6,0x73},{0x9c,0xac},{0xd6,0x74},{0xd6,0x70},{0xb2,0x7b},
    {0xd6,0x75},{0xd6,0x72},{0xd6,0x6f},{0x9c,0xad},{0xb2,0x79},
    {0xd6,0x6e},{0xb2,0x77},{0xb2,0x7a},{0xd6,0x71},{0xd6,0x79},
    {0xaf,0x5b},{0xb2,0x78},{0xd6,0x77},{0xd6,0x76},{0xb2,0x7c},
    {0x00,0x00},{0x8e,0xbf},{0x86,0xe3},{0x9c,0xae},{0x9c,0xaf},
    {0x00,0x00},{0x9c,0xb0},{0x9c,0xb1},{0xda,0x7e},{0x9c,0xb2},
    {0x00,0x00},{0x9c,0xb3},{0xda,0xa1},{0xb5,0x60},{0x9c,0xb4},
    {0xda,0xa7},{0x9c,0xb5},{0x9c,0xb6},{0xda,0xa9},{0xda,0xa2},
    {0xb5,0x5a},{0xda,0xa6},{0xda,0xa5},{0xb5,0x5b},{0xb5,0x61},
    {0x00,0x00},{0xb5,0x62},{0xda,0xa8},{0xb5,0x58},{0xda,0x7d},
    {0xda,0x7b},{0xda,0xa3},{0xda,0x7a},{0xb5,0x5f},{0xda,0x7c},
    {0xda,0xa4},{0xda,0xaa},{0xb5,0x59},{0xb5,0x5e},{0xb5,0x5c},
    {0xb5,0x5d},{0x9c,0xb7},{0x9c,0xb8},{0x9c,0xb9},{0xb5,0x57},
    {0x00,0x00},{0x8b,0xa9},{0x00,0x00},{0x00,0x00},{0xb7,0xe9},
    {0xde,0xb7},{0xb7,0xe8},{0xde,0xbb},{0x9c,0xba},{0xde,0xb1},
    {0x9c,0xbb},{0xde,0xbc},{0x9c,0xbc},{0x9c,0xbd},{0x9c,0xbe},
    {0xde,0xb2},{0xde,0xb3},{0x00,0x00},{0xde,0xbd},{0xde,0xba},
    {0xde,0xb8},{0xde,0xb9},{0xde,0xb5},{0xde,0xb4},{0x9c,0xbf},
    {0xde,0xbe},{0xb7,0xe5},{0x9c,0xc0},{0xde,0xb6},{0x00,0x00},
    {0xb7,0xea},{0xb7,0xe4},{0xb7,0xeb},{0xb7,0xec},{0xfc,0xb9},
    {0xb7,0xe7},{0xb7,0xe6},{0xfe,0x75},{0x9d,0x73},{0xe2,0xce},
    {0xba,0xbe},{0xba,0xbd},{0x9c,0xc1},{0x00,0x00},{0xe2,0xd3},
    {0xfe,0xac},{0xbc,0xfc},{0xba,0xbf},{0x9c,0xc2},{0x9c,0xc3},
    {0xba,0xc1},{0xe2,0xd4},{0xb7,0xe3},{0xba,0xc0},{0xe2,0xd0},
    {0xe2,0xd2},{0xe2,0xcf},{0x9c,0xc4},{0xe2,0xd1},{0xfa,0x77},
    {0x89,0xf9},{0x00,0x00},{0xe6,0xab},{0x9c,0xc5},{0x00,0x00},
    {0xe6,0xaa},{0xe6,0xa7},{0xbd,0x40},{0xea,0x62},{0xbd,0x41},
    {0xe6,0xa6},{0x9c,0xc6},{0xbc,0xfe},{0x00,0x00},{0xe6,0xa8},
    {0xe6,0xa5},{0xe6,0xa2},{0xe6,0xa9},{0xe6,0xa3},{0xe6,0xa4},
    {0xbc,0xfd},{0x81,0xd0},{0x81,0xd1},{0x8c,0x7d},{0x00,0x00},
    {0xed,0x69},{0x00,0x00},{0xea,0x66},{0x00,0x00},{0xea,0x65},
    {0xea,0x67},{0x00,0x00},{0xed,0x66},{0xbf,0x5a},{0x81,0xd2},
    {0xea,0x63},{0x81,0xd3},{0xbf,0x58},{0x9d,0x74},{0xbf,0x5c},
    {0xbf,0x5b},{0xea,0x64},{0xea,0x68},{0xfa,0x78},{0xbf,0x59},
    {0x81,0xd4},{0xed,0x6d},{0xc0,0xf5},{0xc2,0x7a},{0xc0,0xf6},
    {0xc0,0xf3},{0xed,0x6a},{0xed,0x68},{0x00,0x00},{0xed,0x6b},
    {0x00,0x00},{0xed,0x6e},{0xc0,0xf4},{0xed,0x6c},{0xed,0x67},
    {0x00,0x00},{0x81,0xd5},{0xf0,0x42},{0xf0,0x45},{0xf2,0x75},
    {0xf0,0x40},{0x81,0xd6},{0xf4,0x6f},{0xf0,0x46},{0x00,0x00},
    {0xc3,0xa2},{0xf0,0x44},{0xc2,0x7b},{0xf0,0x41},{0xf0,0x43},
    {0xf0,0x47},{0xf2,0x76},{0x00,0x00},{0xf2,0x74},{0x00,0x00},
    {0x00,0x00},{0x81,0xd7},{0x00,0x00},{0xc3,0xa3},{0xf2,0x73},
    {0x81,0xd8},{0x00,0x00},{0x00,0x00},{0xc4,0x6e},{0x81,0xd9},
    {0x00,0x00},{0x8c,0xf9},{0x81,0xda},{0xc4,0xed},{0xf6,0xf1},
    {0xc4,0xec},{0xf6,0xf3},{0xf6,0xf0},{0xf6,0xf2},{0xc5,0xd0},
    {0xf8,0xb2},{0xa5,0xca},{0xcd,0x6e},{0xd2,0xbc},{0xd2,0xbd},
    {0xb2,0x7d},{0xde,0xbf},{0xbf,0x5d},{0xc3,0xa4},{0xc5,0x7b},
    {0xf8,0xb3},{0xa5,0xcb},{0x94,0xac},{0xcd,0x6f},{0xa2,0x60},
    {0x00,0x00},{0x00,0x00},{0xcf,0xd7},{0x00,0x00},{0xcf,0xd8},
    {0x88,0xfe},{0x94,0xae},{0x94,0xaf},{0x94,0xad},{0x00,0x00},
    {0xd2,0xbe},{0xd2,0xbf},{0xb2,0x7e},{0xb2,0xa1},{0x94,0xb0},
    {0x00,0x00},{0x00,0x00},{0xda,0xab},{0x00,0x00},{0xde,0xc2},
    {0xde,0xc1},{0xde,0xc0},{0xe2,0xd5},{0xfa,0x79},{0xe2,0xd6},
    {0xe2,0xd7},{0xba,0xc2},{0x94,0xb1},{0x00,0x00},{0xe6,0xad},
    {0xe6,0xac},{0x00,0x00},{0x00,0x00},{0xea,0x69},{0xbf,0x5e},
    {0xbf,0x5f},{0x95,0xc2},{0xed,0x72},{0xed,0x6f},{0xed,0x70},
    {0xed,0x71},{0xf0,0x49},{0xf0,0x48},{0xc2,0x7c},{0xf2,0x77},
    {0xf5,0xde},{0xa5,0xcc},{0xfa,0x7a},{0xac,0xc6},{0x00,0x00},
    {0xb2,0xa2},{0xde,0xc3},{0xfc,0xbb},{0xa5,0xcd},{0x00,0x00},
    {0xd2,0xc0},{0xb2,0xa3},{0xfa,0x7b},{0x00,0x00},{0xb5,0x63},
    {0xb5,0x64},{0x00,0x00},{0xa5,0xce},{0xa5,0xcf},{0xca,0x46},
    {0xa8,0x6a},{0xa8,0x69},{0xac,0xc7},{0xcf,0xd9},{0xda,0xac},
    {0xa5,0xd0},{0xa5,0xd1},{0xa5,0xd2},{0xa5,0xd3},{0xa0,0x59},
    {0x86,0x7a},{0x00,0x00},{0xa8,0x6b},{0xa8,0x6c},{0xcb,0x6e},
    {0xcb,0x6d},{0x84,0xf8},{0xfa,0x7c},{0xaa,0xb6},{0xcd,0x72},
    {0xcd,0x70},{0xcd,0x71},{0x00,0x00},{0x81,0xdb},{0x00,0x00},
    {0xfa,0x7d},{0x86,0xd0},{0xfb,0xd1},{0xcf,0xda},{0xcf,0xdb},
    {0xfa,0x7e},{0x95,0xbf},{0xac,0xcb},{0xac,0xc9},{0xfa,0xa1},
    {0xac,0xca},{0xac,0xc8},{0x00,0x00},{0x94,0x55},{0x00,0x00},
    {0xfc,0xbc},{0xaf,0x60},{0x81,0xdc},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0xaf,0x64},{0xaf,0x63},{0xd2,0xc1},{0xaf,0x62},
    {0xaf,0x61},{0x00,0x00},{0xd2,0xc2},{0x94,0x56},{0x00,0x00},
    {0xb2,0xa6},{0xd6,0x7b},{0xd6,0x7a},{0xb2,0xa4},{0xb2,0xa5},
    {0x95,0xcc},{0x00,0x00},{0x94,0xb2},{0xb5,0x66},{0xb5,0x65},
    {0xda,0xae},{0xfa,0xa2},{0x81,0xdd},{0xda,0xad},{0xb2,0xa7},
    {0x00,0x00},{0x8d,0xe2},{0x92,0xec},{0x8b,0xaa},{0x00,0x00},
    {0xb7,0xed},{0xde,0xc5},{0xb7,0xee},{0xde,0xc4},{0xfc,0xbd},
    {0x00,0x00},{0x00,0x00},{0xe2,0xd8},{0xe6,0xae},{0xbd,0x42},
    {0xea,0x6a},{0x00,0x00},{0xfa,0xa3},{0xfa,0xa4},{0xed,0x73},
    {0x00,0x00},{0xc3,0xa6},{0xc3,0xa5},{0x00,0x00},{0xfa,0xa5},
    {0xc5,0x7c},{0xa5,0xd4},{0xcd,0x73},{0x81,0xde},{0x93,0x51},
    {0xb2,0xa8},{0xe2,0xd9},{0xba,0xc3},{0xc6,0xd4},{0x00,0x00},
    {0xcb,0x6f},{0xcb,0x70},{0x8f,0x78},{0x89,0xfb},{0xcd,0x74},
    {0xaa,0xb8},{0xaa,0xb9},{0x00,0x00},{0x00,0x00},{0xaa,0xb7},
    {0x81,0xdf},{0x86,0xe5},{0x8a,0xdd},{0x86,0xe6},{0xac,0xcf},
    {0xac,0xd0},{0xac,0xcd},{0xac,0xce},{0x00,0x00},{0xcf,0xdc},
    {0x00,0x00},{0x00,0x00},{0xcf,0xdd},{0xac,0xcc},{0xfa,0xa6},
    {0x00,0x00},{0x87,0xf4},{0x86,0xe7},{0xd2,0xc3},{0xfe,0x51},
    {0xaf,0x68},{0xaf,0x69},{0xfb,0x5c},{0xb2,0xab},{0xd2,0xc9},
    {0x00,0x00},{0xaf,0x6e},{0xaf,0x6c},{0xd2,0xca},{0xd2,0xc5},
    {0xaf,0x6b},{0xaf,0x6a},{0xaf,0x65},{0xd2,0xc8},{0xd2,0xc7},
    {0xd2,0xc4},{0xaf,0x6d},{0xfc,0xd3},{0xd2,0xc6},{0xaf,0x66},
    {0x00,0x00},{0xaf,0x67},{0x8f,0xfd},{0x84,0xf9},{0xb2,0xac},
    {0xd6,0xa1},{0xd6,0xa2},{0xb2,0xad},{0xd6,0x7c},{0xd6,0x7e},
    {0xd6,0xa4},{0xd6,0xa3},{0xd6,0x7d},{0x00,0x00},{0xb2,0xa9},
    {0xb2,0xaa},{0xfa,0xa7},{0xda,0xb6},{0xb5,0x6b},{0xb5,0x6a},
    {0xda,0xb0},{0xb5,0x68},{0x81,0xe0},{0xda,0xb3},{0xb5,0x6c},
    {0xda,0xb4},{0xb5,0x6d},{0xda,0xb1},{0xb5,0x67},{0xb5,0x69},
    {0xda,0xb5},{0x00,0x00},{0xda,0xb2},{0xda,0xaf},{0x89,0xfa},
    {0xfa,0xa8},{0x86,0xe8},{0x8f,0x58},{0x00,0x00},{0xde,0xd2},
    {0x00,0x00},{0xde,0xc7},{0xb7,0xf0},{0xb7,0xf3},{0xb7,0xf2},
    {0xb7,0xf7},{0xb7,0xf6},{0xde,0xd3},{0xde,0xd1},{0xde,0xca},
    {0xde,0xce},{0xde,0xcd},{0xb7,0xf4},{0xde,0xd0},{0xde,0xcc},
    {0xde,0xd4},{0xde,0xcb},{0xb7,0xf5},{0xb7,0xef},{0xb7,0xf1},
    {0xfc,0xd5},{0xde,0xc9},{0x00,0x00},{0x8f,0x57},{0x00,0x00},
    {0xfc,0xd4},{0xe2,0xdb},{0xba,0xc7},{0xe2,0xdf},{0xba,0xc6},
    {0xe2,0xdc},{0xba,0xc5},{0x00,0x00},{0xde,0xc8},{0xde,0xcf},
    {0xe2,0xde},{0x00,0x00},{0xba,0xc8},{0xe2,0xe0},{0xe2,0xdd},
    {0xe2,0xda},{0x8e,0xc1},{0x89,0x40},{0xe6,0xb1},{0xe6,0xb5},
    {0xe6,0xb7},{0xe6,0xb3},{0xe6,0xb2},{0xe6,0xb0},{0xbd,0x45},
    {0xbd,0x43},{0xbd,0x48},{0xbd,0x49},{0xe6,0xb4},{0xbd,0x46},
    {0xe6,0xaf},{0xbd,0x47},{0xba,0xc4},{0xe6,0xb6},{0xbd,0x44},
    {0x8b,0xab},{0x8d,0x54},{0x81,0xe1},{0xea,0x6c},{0x00,0x00},
    {0xea,0x6b},{0xea,0x73},{0xea,0x6d},{0xea,0x72},{0xea,0x6f},
    {0xbf,0x60},{0xea,0x71},{0x00,0x00},{0x00,0x00},{0xbf,0x61},
    {0x00,0x00},{0xbf,0x62},{0x95,0xa9},{0xea,0x70},{0xea,0x6e},
    {0x8c,0xd5},{0x90,0x58},{0xfa,0xa9},{0x00,0x00},{0xc0,0xf8},
    {0xed,0x74},{0x00,0x00},{0x00,0x00},{0xc0,0xf7},{0xed,0x77},
    {0xed,0x75},{0xed,0x76},{0x00,0x00},{0x00,0x00},{0xc0,0xf9},
    {0xfa,0xaa},{0x95,0x6f},{0x81,0xe2},{0xf0,0x4d},{0x81,0xe3},
    {0xc2,0xa1},{0xf0,0x4e},{0xfa,0xab},{0x00,0x00},{0xc2,0x7d},
    {0xf0,0x4f},{0xc2,0x7e},{0xf0,0x4c},{0xf0,0x50},{0x00,0x00},
    {0xf0,0x4a},{0x00,0x00},{0x8c,0x7e},{0xc3,0xa7},{0xf2,0x78},
    {0xc3,0xa8},{0xc4,0x6f},{0x8c,0xd6},{0xf0,0x4b},{0xc4,0x70},
    {0xfb,0x76},{0xfc,0xd7},{0xfa,0xac},{0xc4,0xee},{0xf5,0xdf},
    {0x8d,0x55},{0xc5,0x7e},{0xf6,0xf4},{0xc5,0x7d},{0xfc,0xd8},
    {0xf7,0xea},{0xc5,0xf5},{0xc5,0xf6},{0x81,0xe4},{0x81,0xe5},
    {0xf9,0xcc},{0xc6,0xd5},{0x00,0x00},{0xac,0xd1},{0xcf,0xde},
    {0x93,0xb9},{0xb5,0x6e},{0xb5,0x6f},{0xa5,0xd5},{0xa6,0xca},
    {0xca,0x47},{0xfa,0xad},{0xcb,0x71},{0xa8,0x6d},{0xfa,0xae},
    {0xaa,0xba},{0x00,0x00},{0xac,0xd2},{0xac,0xd3},{0xac,0xd4},
    {0xd6,0xa6},{0xd2,0xcb},{0xaf,0x6f},{0x00,0x00},{0x00,0x00},
    {0xb2,0xae},{0xd6,0xa5},{0xfa,0xaf},{0x87,0xf5},{0xda,0xb8},
    {0xb5,0x71},{0x00,0x00},{0xda,0xb7},{0xb5,0x70},{0x00,0x00},
    {0x00,0x00},{0xde,0xd5},{0xbd,0x4a},{0xe6,0xbb},{0xe6,0xb8},
    {0xe6,0xb9},{0xe6,0xba},{0x00,0x00},{0x00,0x00},{0xfc,0xbe},
    {0x00,0x00},{0x00,0x00},{0xed,0x78},{0x81,0xe6},{0xf0,0x51},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0xf4,0x71},{0xf4,0x70},
    {0x00,0x00},{0xf6,0xf5},{0xa5,0xd6},{0xcd,0x75},{0xaf,0x70},
    {0x87,0xf6},{0x8e,0x77},{0x00,0x00},{0xb5,0x72},{0xde,0xd6},
    {0x00,0x00},{0xfa,0xb0},{0xe2,0xe1},{0xfa,0xb1},{0xbd,0x4b},
    {0xea,0x74},{0x00,0x00},{0xf0,0x52},{0xf4,0x72},{0xa5,0xd7},
    {0x00,0x00},{0x00,0x00},{0xaa,0xbb},{0xac,0xd7},{0xcf,0xdf},
    {0xac,0xd8},{0xac,0xd6},{0x00,0x00},{0xac,0xd5},{0xd2,0xcc},
    {0xaf,0x71},{0x00,0x00},{0xfc,0xbf},{0xaf,0x72},{0xaf,0x73},
    {0x85,0xe6},{0x8d,0x69},{0x86,0xea},{0xb2,0xb0},{0xd6,0xa7},
    {0xb2,0xaf},{0x00,0x00},{0x87,0x49},{0x84,0xfb},{0x87,0xf7},
    {0x81,0xe7},{0xda,0xb9},{0xb2,0xb1},{0xb5,0x73},{0xde,0xd7},
    {0xb7,0xf8},{0xb7,0xf9},{0x00,0x00},{0xba,0xc9},{0x00,0x00},
    {0xba,0xca},{0xbd,0x4c},{0xbf,0x64},{0xea,0x75},{0xbf,0x63},
    {0x00,0x00},{0xed,0x79},{0xc0,0xfa},{0x00,0x00},{0xf0,0x53},
    {0xf4,0x73},{0xa5,0xd8},{0xa8,0x6e},{0xcd,0x78},{0xcd,0x77},
    {0xaa,0xbc},{0xcd,0x76},{0xaa,0xbd},{0xcd,0x79},{0x00,0x00},
    {0xcf,0xe5},{0xac,0xdb},{0xac,0xda},{0xcf,0xe7},{0xcf,0xe6},
    {0xac,0xdf},{0x00,0x00},{0xac,0xde},{0x00,0x00},{0x00,0x00},
    {0xac,0xd9},{0x00,0x00},{0xcf,0xe1},{0xcf,0xe2},{0xcf,0xe3},
    {0x00,0x00},{0xac,0xe0},{0xcf,0xe0},{0xac,0xdc},{0xcf,0xe4},
    {0xac,0xdd},{0x92,0xb1},{0xfa,0xb2},{0x81,0xe8},{0x81,0xe9},
    {0xd2,0xcf},{0xd2,0xd3},{0xd2,0xd1},{0xd2,0xd0},{0x00,0x00},
    {0xd2,0xd4},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0xd2,0xd5},
    {0xd2,0xd6},{0xd2,0xce},{0x00,0x00},{0xd2,0xcd},{0xfa,0xb3},
    {0xaf,0x75},{0xaf,0x76},{0x00,0x00},{0xd2,0xd7},{0xd2,0xd2},
    {0xfc,0xc0},{0xd6,0xb0},{0x8d,0xd2},{0xd2,0xd8},{0xaf,0x77},
    {0xaf,0x74},{0x00,0x00},{0xfc,0xc1},{0x00,0x00},{0xd6,0xaa},
    {0x00,0x00},{0xd6,0xa9},{0x00,0x00},{0xd6,0xab},{0xd6,0xac},
    {0xd6,0xae},{0xd6,0xad},{0xd6,0xb2},{0xb2,0xb5},{0xb2,0xb2},
    {0xb2,0xb6},{0xd6,0xa8},{0xb2,0xb7},{0xd6,0xb1},{0xb2,0xb4},
    {0xd6,0xaf},{0xb2,0xb3},{0x00,0x00},{0x95,0x4d},{0x85,0xe8},
    {0x00,0x00},{0xfa,0xb4},{0xda,0xbc},{0xda,0xbe},{0xda,0xba},
    {0xda,0xbb},{0x00,0x00},{0x00,0x00},{0xda,0xbf},{0xda,0xc1},
    {0xda,0xc2},{0xda,0xbd},{0xda,0xc0},{0xb5,0x74},{0x85,0xe7},
    {0x8a,0xde},{0xde,0xdb},{0x00,0x00},{0xde,0xe0},{0xde,0xd8},
    {0xde,0xdc},{0x00,0x00},{0x81,0xea},{0xde,0xe1},{0xde,0xdd},
    {0xb7,0xfa},{0xb8,0x43},{0x00,0x00},{0xb7,0xfd},{0xde,0xd9},
    {0xde,0xda},{0xba,0xce},{0xb8,0x46},{0xb7,0xfe},{0x00,0x00},
    {0xb8,0x44},{0xb7,0xfc},{0xde,0xdf},{0xb8,0x45},{0xde,0xde},
    {0xb8,0x41},{0xb7,0xfb},{0xb8,0x42},{0xde,0xe2},{0xe2,0xe6},
    {0xe2,0xe8},{0x00,0x00},{0x00,0x00},{0x81,0xeb},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x81,0xec},{0x81,0xed},
    {0xb8,0x40},{0x81,0xee},{0x81,0xef},{0xe2,0xe3},{0xba,0xcc},
    {0xe2,0xe9},{0xba,0xcd},{0xe2,0xe7},{0xe2,0xe2},{0xe2,0xe5},
    {0xe2,0xea},{0xba,0xcb},{0xe2,0xe4},{0x00,0x00},{0xbd,0x4e},
    {0xe6,0xbf},{0xe6,0xbe},{0x00,0x00},{0xbd,0x51},{0xbd,0x4f},
    {0xe6,0xbc},{0xbd,0x4d},{0xe6,0xbd},{0x00,0x00},{0xbd,0x50},
    {0x89,0x42},{0xfb,0x6b},{0x00,0x00},{0xea,0x7d},{0x00,0x00},
    {0xea,0xa1},{0x81,0xf0},{0xea,0x7e},{0xea,0x76},{0xea,0x7a},
    {0xea,0x79},{0xea,0x77},{0xbf,0x66},{0xbf,0x67},{0xbf,0x65},
    {0xea,0x78},{0xea,0x7b},{0xea,0x7c},{0x00,0x00},{0xbf,0x68},
    {0x00,0x00},{0xc1,0x40},{0xed,0xa3},{0x8d,0x7c},{0xc0,0xfc},
    {0xed,0x7b},{0xc0,0xfe},{0xc1,0x41},{0x00,0x00},{0x81,0xf1},
    {0xc0,0xfd},{0xed,0xa2},{0xed,0x7c},{0xc0,0xfb},{0xed,0xa1},
    {0xed,0x7a},{0xed,0x7e},{0xed,0x7d},{0x00,0x00},{0xfe,0x5a},
    {0xf0,0x55},{0xc2,0xa4},{0xc2,0xa5},{0xc2,0xa2},{0x81,0xf2},
    {0xc2,0xa3},{0x00,0x00},{0x00,0x00},{0xf0,0x54},{0x81,0xf3},
    {0xf2,0x7b},{0x81,0xf4},{0x00,0x00},{0xc3,0xa9},{0x00,0x00},
    {0xf2,0x79},{0xf2,0x7a},{0x81,0xf5},{0xf4,0x74},{0xf4,0x77},
    {0xf4,0x75},{0xf4,0x76},{0xf5,0xe0},{0x00,0x00},{0x00,0x00},
    {0xc4,0xef},{0xf7,0xeb},{0xf8,0xb4},{0x00,0x00},{0xc5,0xf7},
    {0xf8,0xf8},{0xf8,0xf9},{0xc6,0x66},{0xa5,0xd9},{0xac,0xe1},
    {0x81,0xf6},{0xda,0xc3},{0x00,0x00},{0xde,0xe3},{0x00,0x00},
    {0xa5,0xda},{0xa8,0x6f},{0x00,0x00},{0xaa,0xbe},{0x81,0xf7},
    {0xcf,0xe8},{0xcf,0xe9},{0xaf,0x78},{0x00,0x00},{0x89,0xfc},
    {0xda,0xc4},{0xb5,0x75},{0xb8,0x47},{0xc1,0x42},{0xed,0xa4},
    {0xf2,0x7c},{0xf4,0x78},{0xa5,0xdb},{0x81,0xf8},{0x00,0x00},
    {0x89,0xfe},{0xcd,0xa1},{0xcd,0x7a},{0xcd,0x7c},{0xcd,0x7e},
    {0xcd,0x7d},{0xcd,0x7b},{0xaa,0xbf},{0x8c,0x41},{0x8b,0xfe},
    {0x8e,0x78},{0x87,0xf9},{0xac,0xe2},{0xcf,0xf2},{0x00,0x00},
    {0xcf,0xed},{0xcf,0xea},{0x00,0x00},{0x96,0x41},{0xcf,0xf1},
    {0x00,0x00},{0x00,0x00},{0xac,0xe4},{0xac,0xe5},{0xcf,0xf0},
    {0xcf,0xef},{0xcf,0xee},{0xcf,0xeb},{0xcf,0xec},{0xcf,0xf3},
    {0xac,0xe3},{0x92,0xc5},{0x89,0x43},{0x8d,0xe3},{0xfa,0xb5},
    {0x00,0x00},{0x84,0xfc},{0x00,0x00},{0xfa,0xb6},{0xaf,0x7c},
    {0x81,0xf9},{0xaf,0xa4},{0xaf,0xa3},{0xd2,0xe1},{0xd2,0xdb},
    {0xd2,0xd9},{0x00,0x00},{0xaf,0xa1},{0xd6,0xb9},{0xaf,0x7a},
    {0xd2,0xde},{0xd2,0xe2},{0xd2,0xe4},{0xd2,0xe0},{0xd2,0xda},
    {0xaf,0xa2},{0xd2,0xdf},{0xd2,0xdd},{0xaf,0x79},{0xd2,0xe5},
    {0xaf,0xa5},{0xd2,0xe3},{0xaf,0x7d},{0xd2,0xdc},{0x00,0x00},
    {0xaf,0x7e},{0xaf,0x7b},{0xfa,0xb7},{0x8c,0x40},{0x90,0x42},
    {0xfa,0xb8},{0x81,0xfa},{0x8c,0x42},{0x82,0x5f},{0x8a,0xdf},
    {0x00,0x00},{0x81,0xfb},{0xb2,0xb9},{0x81,0xfc},{0xd6,0xba},
    {0x00,0x00},{0xfa,0xb9},{0xd6,0xb3},{0xd6,0xb5},{0xd6,0xb7},
    {0x81,0xfd},{0xd6,0xb8},{0xd6,0xb6},{0xb2,0xba},{0x00,0x00},
    {0xd6,0xbb},{0x81,0xfe},{0xd6,0xb4},{0xfc,0xc3},{0x96,0x4b},
    {0x86,0xeb},{0xfa,0xba},{0x8f,0x59},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0xda,0xc8},{0xb5,0x76},{0xda,0xd0},
    {0x00,0x00},{0xda,0xc5},{0x00,0x00},{0xda,0xd1},{0x00,0x00},
    {0xda,0xc6},{0xda,0xc7},{0x96,0x4c},{0x00,0x00},{0xda,0xcf},
    {0xda,0xce},{0xda,0xcb},{0xb2,0xb8},{0xb5,0x77},{0xda,0xc9},
    {0xda,0xcc},{0xb5,0x78},{0xda,0xcd},{0xda,0xca},{0x94,0x54},
    {0x00,0x00},{0x94,0xb4},{0x00,0x00},{0x00,0x00},{0x8d,0x68},
    {0x00,0x00},{0xde,0xee},{0xfa,0xbb},{0xde,0xf2},{0xb8,0x4e},
    {0x00,0x00},{0xe2,0xf0},{0xb8,0x51},{0xde,0xf0},{0xf9,0xd6},
    {0x00,0x00},{0xde,0xed},{0xde,0xe8},{0xde,0xea},{0xde,0xeb},
    {0xde,0xe4},{0x96,0x4d},{0xb8,0x4d},{0x00,0x00},{0x00,0x00},
    {0xb8,0x4c},{0x8b,0xac},{0xb8,0x48},{0xde,0xe7},{0x00,0x00},
    {0xb8,0x4f},{0x00,0x00},{0xb8,0x50},{0xde,0xe6},{0xde,0xe9},
    {0xde,0xf1},{0xb8,0x4a},{0xb8,0x4b},{0xde,0xef},{0xde,0xe5},
    {0x89,0x44},{0x8e,0xed},{0x00,0x00},{0xe2,0xf2},{0xba,0xd0},
    {0xe2,0xf4},{0xde,0xec},{0xe2,0xf6},{0xba,0xd4},{0xe2,0xf7},
    {0xe2,0xf3},{0x00,0x00},{0xba,0xd1},{0xe2,0xef},{0xba,0xd3},
    {0xe2,0xec},{0xe2,0xf1},{0xe2,0xf5},{0xe2,0xee},{0x00,0x00},
    {0xfc,0xc7},{0xb8,0x49},{0x95,0xf0},{0xe2,0xeb},{0xba,0xd2},
    {0xe2,0xed},{0xfa,0xbc},{0x96,0x4e},{0x00,0x00},{0x96,0xcd},
    {0xfa,0xbd},{0xbd,0x54},{0xe6,0xc1},{0xbd,0x58},{0x00,0x00},
    {0xbd,0x56},{0x00,0x00},{0x00,0x00},{0xba,0xcf},{0x00,0x00},
    {0xe6,0xc8},{0xe6,0xc9},{0xbd,0x53},{0xfa,0xbe},{0x96,0x4f},
    {0xe6,0xc7},{0xe6,0xca},{0xbd,0x55},{0xbd,0x52},{0xe6,0xc3},
    {0xe6,0xc0},{0xe6,0xc5},{0xe6,0xc2},{0xbd,0x59},{0xe6,0xc4},
    {0x96,0x50},{0xfc,0xc4},{0xe6,0xc6},{0xbd,0x57},{0x00,0x00},
    {0x96,0x51},{0xfc,0xc5},{0xfa,0xbf},{0xbf,0x6a},{0xea,0xa8},
    {0x00,0x00},{0xea,0xa2},{0xea,0xa6},{0xea,0xac},{0xea,0xad},
    {0xea,0xa9},{0xea,0xaa},{0xea,0xa7},{0x96,0x54},{0xea,0xa4},
    {0x00,0x00},{0xbf,0x6c},{0xbf,0x69},{0xea,0xa3},{0xea,0xa5},
    {0x00,0x00},{0xbf,0x6b},{0xea,0xab},{0x96,0x55},{0xc1,0x46},
    {0x96,0x56},{0x96,0x57},{0xed,0xaa},{0xed,0xa5},{0xc1,0x45},
    {0x96,0x58},{0x00,0x00},{0xc1,0x43},{0x00,0x00},{0xed,0xac},
    {0xc1,0x44},{0xed,0xa8},{0xed,0xa9},{0xed,0xa6},{0xed,0xad},
    {0xf0,0x56},{0x00,0x00},{0xc1,0x47},{0xed,0xa7},{0x00,0x00},
    {0xed,0xae},{0xed,0xab},{0xfb,0xa8},{0xfa,0xc0},{0x00,0x00},
    {0xf0,0x5a},{0x00,0x00},{0x00,0x00},{0xf0,0x57},{0x00,0x00},
    {0xc2,0xa6},{0x00,0x00},{0xf0,0x5b},{0xf0,0x5d},{0xf0,0x5c},
    {0xf0,0x58},{0xf0,0x59},{0x00,0x00},{0x00,0x00},{0xf2,0xa3},
    {0x00,0x00},{0xc3,0xaa},{0x00,0x00},{0xf2,0x7e},{0xf2,0xa2},
    {0xf2,0x7d},{0xf2,0xa4},{0x00,0x00},{0x00,0x00},{0xf2,0xa1},
    {0x00,0x00},{0xf4,0x7a},{0xf4,0x7d},{0xf4,0x79},{0xc4,0x71},
    {0xf4,0x7b},{0xf4,0x7c},{0xf4,0x7e},{0xc4,0x72},{0xc4,0x74},
    {0xc4,0x73},{0xf5,0xe1},{0xfe,0x77},{0xf5,0xe3},{0xfa,0xc1},
    {0xf5,0xe2},{0x96,0x59},{0x96,0x5a},{0xfa,0xc2},{0xf6,0xf6},
    {0x96,0x5b},{0x00,0x00},{0xf8,0xb5},{0xf8,0xfa},{0xa5,0xdc},
    {0xfa,0xc3},{0x8a,0xe0},{0xcb,0x72},{0xaa,0xc0},{0xcd,0xa3},
    {0xaa,0xc1},{0xaa,0xc2},{0xcd,0xa2},{0x00,0x00},{0xcf,0xf8},
    {0xcf,0xf7},{0xac,0xe6},{0xac,0xe9},{0xac,0xe8},{0xac,0xe7},
    {0xcf,0xf4},{0xcf,0xf6},{0xcf,0xf5},{0x00,0x00},{0x00,0x00},
    {0xd2,0xe8},{0xaf,0xa7},{0xd2,0xec},{0xd2,0xeb},{0xd2,0xea},
    {0xd2,0xe6},{0xaf,0xa6},{0xaf,0xaa},{0xaf,0xad},{0x96,0x5c},
    {0x96,0x5e},{0xaf,0xae},{0xd2,0xe7},{0xd2,0xe9},{0xaf,0xac},
    {0xaf,0xab},{0xaf,0xa9},{0xaf,0xa8},{0xd6,0xc2},{0x8f,0xbe},
    {0xd6,0xc0},{0xd6,0xbc},{0xb2,0xbb},{0x00,0x00},{0xd6,0xbd},
    {0xb2,0xbc},{0xd6,0xbe},{0xd6,0xbf},{0xd6,0xc1},{0x00,0x00},
    {0xb2,0xbd},{0x00,0x00},{0x86,0xec},{0xda,0xd5},{0x96,0x5f},
    {0xda,0xd4},{0xda,0xd3},{0xda,0xd2},{0x00,0x00},{0x00,0x00},
    {0x82,0x70},{0x86,0xed},{0xde,0xf6},{0xb8,0x52},{0x00,0x00},
    {0xde,0xf3},{0xde,0xf5},{0x96,0x60},{0xb8,0x53},{0xfa,0xc4},
    {0xb8,0x54},{0xde,0xf4},{0x96,0x61},{0x82,0x77},{0x93,0x50},
    {0x96,0x62},{0x96,0x63},{0xe3,0x41},{0x00,0x00},{0xe2,0xf9},
    {0xe2,0xfa},{0x00,0x00},{0xba,0xd7},{0xba,0xd5},{0xba,0xd6},
    {0xe3,0x43},{0x96,0x64},{0xe3,0x42},{0xe2,0xfe},{0xe2,0xfd},
    {0xe2,0xfc},{0xe2,0xfb},{0xe3,0x40},{0xe2,0xf8},{0x96,0x65},
    {0xe6,0xcb},{0xe6,0xd0},{0xe6,0xce},{0xfa,0xc5},{0x00,0x00},
    {0x96,0x66},{0xe6,0xcd},{0xe6,0xcc},{0xe6,0xcf},{0x00,0x00},
    {0xea,0xae},{0x96,0x67},{0xbf,0x6d},{0xc1,0x48},{0xed,0xb0},
    {0xfc,0xca},{0xc1,0x49},{0xed,0xaf},{0xf0,0x5f},{0xf0,0x5e},
    {0xc2,0xa7},{0x00,0x00},{0xf2,0xa5},{0xc3,0xab},{0xf4,0xa1},
    {0xc5,0xa1},{0xf6,0xf7},{0x00,0x00},{0xf8,0xb7},{0xf8,0xb6},
    {0xc9,0xa8},{0xac,0xea},{0xac,0xeb},{0xd6,0xc3},{0x00,0x00},
    {0xb8,0x56},{0xa5,0xdd},{0xa8,0x72},{0xa8,0x71},{0xa8,0x70},
    {0x00,0x00},{0xfa,0xc6},{0xfb,0xa9},{0xcd,0xa4},{0x84,0xfd},
    {0x00,0x00},{0xaa,0xc4},{0xaa,0xc3},{0x9d,0xce},{0xac,0xee},
    {0xfc,0xa6},{0xcf,0xfa},{0xcf,0xfd},{0xcf,0xfb},{0x00,0x00},
    {0xac,0xec},{0xac,0xed},{0x00,0x00},{0xfc,0xcc},{0xcf,0xf9},
    {0xcf,0xfc},{0x00,0x00},{0xaf,0xb5},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0xd2,0xf3},{0xd2,0xf5},{0xd2,0xf4},{0xaf,0xb2},
    {0xd2,0xef},{0xfa,0xc7},{0x96,0x68},{0xaf,0xb0},{0xaf,0xaf},
    {0x00,0x00},{0xaf,0xb3},{0xaf,0xb1},{0x00,0x00},{0xaf,0xb4},
    {0xd2,0xf2},{0xd2,0xed},{0xd2,0xee},{0xd2,0xf1},{0xd2,0xf0},
    {0x85,0xb8},{0x86,0xef},{0x96,0x69},{0x00,0x00},{0x00,0x00},
    {0x96,0x6a},{0x00,0x00},{0xd6,0xc6},{0xd6,0xc7},{0xd6,0xc5},
    {0x00,0x00},{0xd6,0xc4},{0xb2,0xbe},{0x00,0x00},{0x8a,0xe2},
    {0x00,0x00},{0x00,0x00},{0xb5,0x7d},{0x00,0x00},{0xda,0xd6},
    {0xda,0xd8},{0xda,0xda},{0xb5,0x7c},{0xfa,0xc8},{0x00,0x00},
    {0xb5,0x7a},{0x00,0x00},{0xda,0xd7},{0xb5,0x7b},{0xda,0xd9},
    {0xb5,0x79},{0xfa,0xc9},{0x00,0x00},{0xdf,0x41},{0xde,0xf7},
    {0xde,0xfa},{0xde,0xfe},{0xb8,0x5a},{0xde,0xfc},{0x00,0x00},
    {0xde,0xfb},{0xde,0xf8},{0xde,0xf9},{0xb8,0x58},{0xdf,0x40},
    {0xb8,0x57},{0x00,0x00},{0xb8,0x5c},{0xb8,0x5b},{0xb8,0x59},
    {0x00,0x00},{0xde,0xfd},{0x89,0x47},{0x00,0x00},{0x00,0x00},
    {0xe3,0x49},{0x00,0x00},{0xe3,0x48},{0x00,0x00},{0x96,0x6b},
    {0xe3,0x44},{0x00,0x00},{0xfc,0xce},{0xba,0xd8},{0xe3,0x47},
    {0xe3,0x46},{0xba,0xd9},{0x93,0xa6},{0x8b,0xae},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0xbd,0x5e},{0x00,0x00},{0xe6,0xd2},
    {0x96,0x6c},{0xbd,0x5f},{0xbd,0x5b},{0xbd,0x5d},{0xfc,0xcf},
    {0xbd,0x5a},{0xbd,0x5c},{0x00,0x00},{0x92,0xf9},{0xfa,0xca},
    {0xea,0xaf},{0x96,0x6d},{0xbf,0x70},{0xea,0xb1},{0xea,0xb0},
    {0xfc,0xd0},{0xe3,0x45},{0xbf,0x72},{0xbf,0x71},{0xbf,0x6e},
    {0xbf,0x6f},{0x92,0x53},{0xfa,0xcb},{0x8a,0xe1},{0x00,0x00},
    {0x00,0x00},{0xed,0xb5},{0x00,0x00},{0xed,0xb3},{0xc1,0x4a},
    {0xed,0xb4},{0x00,0x00},{0xed,0xb6},{0xed,0xb2},{0xed,0xb1},
    {0x00,0x00},{0x00,0x00},{0xf0,0x60},{0xc2,0xaa},{0xc2,0xa8},
    {0xc2,0xa9},{0x82,0x67},{0x00,0x00},{0x96,0x6e},{0x00,0x00},
    {0xf2,0xa6},{0xf2,0xa7},{0xc3,0xad},{0x00,0x00},{0xc3,0xac},
    {0xf4,0xa3},{0xf4,0xa4},{0xf4,0xa2},{0x00,0x00},{0xf6,0xf8},
    {0xf6,0xf9},{0x00,0x00},{0x00,0x00},{0xa5,0xde},{0xca,0x48},
    {0xa8,0x73},{0x87,0xfb},{0xcd,0xa5},{0xaa,0xc6},{0xaa,0xc5},
    {0xcd,0xa6},{0x00,0x00},{0xfc,0x42},{0xd0,0x40},{0xac,0xef},
    {0xcf,0xfe},{0xac,0xf0},{0x00,0x00},{0x8c,0xfa},{0xaf,0xb6},
    {0xd2,0xf8},{0xd2,0xf6},{0xd2,0xfc},{0xaf,0xb7},{0xd2,0xf7},
    {0xd2,0xfb},{0xd2,0xf9},{0xd2,0xfa},{0x8a,0xe4},{0x00,0x00},
    {0xd6,0xc8},{0xd6,0xca},{0x87,0xfa},{0xb2,0xbf},{0x93,0x58},
    {0xd6,0xc9},{0xb2,0xc0},{0xb5,0xa2},{0xb5,0xa1},{0xb5,0x7e},
    {0xda,0xdb},{0x00,0x00},{0x00,0x00},{0x8a,0xe3},{0x86,0xf1},
    {0xdf,0x44},{0xb8,0x5d},{0xb8,0x5e},{0x00,0x00},{0xdf,0x43},
    {0xdf,0x42},{0x00,0x00},{0x89,0x48},{0x8c,0x43},{0x00,0x00},
    {0xe3,0x4a},{0xba,0xdb},{0xba,0xda},{0xe3,0x4b},{0xe3,0x4c},
    {0x8e,0xee},{0xbd,0x61},{0xbd,0x60},{0xfe,0xa7},{0xea,0xb5},
    {0xe6,0xd3},{0xe6,0xd5},{0xe6,0xd4},{0xea,0xb4},{0xea,0xb2},
    {0xea,0xb6},{0xea,0xb3},{0x00,0x00},{0xbf,0x73},{0xfc,0x44},
    {0x96,0x6f},{0x00,0x00},{0xed,0xb7},{0xc1,0x4b},{0xed,0xb8},
    {0xed,0xb9},{0x96,0x70},{0xfa,0xcc},{0xc2,0xab},{0xc2,0xac},
    {0x00,0x00},{0xc4,0x75},{0xfd,0xe5},{0x96,0x71},{0xc5,0xd1},
    {0xa5,0xdf},{0x00,0x00},{0x94,0xb5},{0x00,0x00},{0x94,0xb6},
    {0x00,0x00},{0xd0,0x41},{0xfa,0xcd},{0x94,0xb8},{0x00,0x00},
    {0x94,0xb7},{0x88,0x67},{0x00,0x00},{0xd2,0xfd},{0xaf,0xb8},
    {0xfc,0xd2},{0x96,0x72},{0x93,0xe2},{0xfc,0xd1},{0x8c,0x44},
    {0xb3,0xba},{0xb3,0xb9},{0x94,0xb9},{0xfa,0xce},{0xb5,0xa4},
    {0xda,0xdd},{0xb5,0xa3},{0xda,0xdc},{0xfa,0xcf},{0x00,0x00},
    {0x96,0x73},{0x82,0x6d},{0xdf,0x45},{0x00,0x00},{0xba,0xdc},
    {0xe3,0x4d},{0xba,0xdd},{0x94,0xba},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0xc4,0x76},{0xf4,0xa5},
    {0xfa,0xd0},{0xa6,0xcb},{0xaa,0xc7},{0xcd,0xa7},{0x00,0x00},
    {0xac,0xf2},{0x96,0x74},{0xac,0xf1},{0xd0,0x42},{0xd0,0x43},
    {0x94,0xbb},{0x89,0x49},{0xd3,0x40},{0xd3,0x42},{0xaf,0xb9},
    {0x00,0x00},{0xd3,0x44},{0xd3,0x47},{0xd3,0x45},{0x85,0x41},
    {0x96,0x75},{0x00,0x00},{0xd3,0x46},{0xd3,0x43},{0xd2,0xfe},
    {0xaf,0xba},{0xd3,0x48},{0xd3,0x41},{0x85,0x40},{0x85,0xec},
    {0x00,0x00},{0x00,0x00},{0xd6,0xd3},{0xb2,0xc6},{0xd6,0xdc},
    {0xb2,0xc3},{0x00,0x00},{0xd6,0xd5},{0xb2,0xc7},{0xfc,0xdc},
    {0xb2,0xc1},{0x00,0x00},{0xd6,0xd0},{0xd6,0xdd},{0xd6,0xd1},
    {0xd6,0xce},{0xb2,0xc5},{0x96,0x76},{0xb2,0xc2},{0x96,0x77},
    {0xd6,0xd4},{0xd6,0xd7},{0xb2,0xc4},{0xd6,0xd8},{0xb2,0xc8},
    {0xd6,0xd9},{0xd6,0xcf},{0xd6,0xd6},{0xd6,0xda},{0xd6,0xd2},
    {0xd6,0xcd},{0xd6,0xcb},{0xfa,0xd1},{0x00,0x00},{0xd6,0xdb},
    {0xfe,0x64},{0x86,0xf2},{0xda,0xdf},{0x8c,0xd7},{0x00,0x00},
    {0x90,0x7a},{0x00,0x00},{0xda,0xe4},{0x00,0x00},{0x96,0x78},
    {0x96,0x79},{0xda,0xe0},{0xda,0xe6},{0xb5,0xa7},{0xd6,0xcc},
    {0xda,0xe1},{0xb5,0xa5},{0xda,0xde},{0xb5,0xac},{0xda,0xe2},
    {0xb5,0xab},{0xda,0xe3},{0xb5,0xad},{0xb5,0xa8},{0xb5,0xae},
    {0xb5,0xa9},{0x00,0x00},{0xb5,0xaa},{0x96,0x7a},{0xb5,0xa6},
    {0x00,0x00},{0xda,0xe5},{0x00,0x00},{0x8f,0x5b},{0x89,0x4a},
    {0x00,0x00},{0x86,0xf3},{0x00,0x00},{0x00,0x00},{0xb8,0x61},
    {0xdf,0x50},{0xfa,0xd2},{0xdf,0x53},{0xdf,0x47},{0xdf,0x4c},
    {0xdf,0x46},{0xb8,0x63},{0x00,0x00},{0xdf,0x4a},{0x00,0x00},
    {0x00,0x00},{0xfa,0xd3},{0xdf,0x48},{0xb8,0x62},{0x96,0x7b},
    {0xdf,0x4f},{0xdf,0x4e},{0xdf,0x4b},{0xdf,0x4d},{0xdf,0x49},
    {0xba,0xe1},{0xdf,0x52},{0xb8,0x5f},{0xdf,0x51},{0x8c,0x45},
    {0xfa,0xd4},{0xfa,0xd5},{0x00,0x00},{0x00,0x00},{0x8b,0xaf},
    {0x00,0x00},{0x8a,0xe9},{0x00,0x00},{0xe3,0x5d},{0x00,0x00},
    {0xba,0xe8},{0xe3,0x58},{0x82,0x7a},{0xba,0xe7},{0xe3,0x4e},
    {0x00,0x00},{0xe3,0x50},{0xba,0xe0},{0xe3,0x55},{0xe3,0x54},
    {0xe3,0x57},{0xba,0xe5},{0xe3,0x52},{0xe3,0x51},{0xfc,0xdd},
    {0x00,0x00},{0xba,0xe4},{0xba,0xdf},{0xe3,0x53},{0xba,0xe2},
    {0xe3,0x59},{0xe3,0x5b},{0xfa,0xd6},{0xe3,0x56},{0xe3,0x4f},
    {0xba,0xe3},{0xfa,0xd7},{0xfa,0xd8},{0xbd,0x69},{0xba,0xde},
    {0xfa,0xd9},{0xfc,0xde},{0xe3,0x5c},{0x00,0x00},{0x8f,0x5a},
    {0xfa,0xda},{0x90,0x59},{0x8d,0x71},{0x8a,0xe7},{0x8a,0xe5},
    {0xe6,0xd9},{0xbd,0x62},{0x00,0x00},{0xe6,0xdb},{0x00,0x00},
    {0xbd,0x63},{0x96,0x7c},{0x00,0x00},{0xbd,0x65},{0xe6,0xde},
    {0x00,0x00},{0xe6,0xd6},{0xba,0xe6},{0xe6,0xdc},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0xe6,0xd8},{0x00,0x00},
    {0xb8,0x60},{0xbd,0x68},{0x00,0x00},{0x00,0x00},{0xbd,0x64},
    {0x00,0x00},{0xbd,0x66},{0xbd,0x67},{0x00,0x00},{0xbf,0x76},
    {0xe6,0xdd},{0xe6,0xd7},{0xbd,0x6a},{0x00,0x00},{0xe6,0xda},
    {0xfc,0xdf},{0x96,0xd0},{0x8a,0xe8},{0x00,0x00},{0x8a,0x40},
    {0xea,0xc0},{0xea,0xbb},{0x00,0x00},{0x00,0x00},{0xea,0xc5},
    {0xbf,0x74},{0xea,0xbd},{0xbf,0x78},{0xea,0xc3},{0xea,0xba},
    {0xea,0xb7},{0xea,0xc6},{0xc1,0x51},{0xbf,0x79},{0xea,0xc2},
    {0xea,0xb8},{0xbf,0x77},{0xea,0xbc},{0xbf,0x7b},{0xea,0xb9},
    {0xea,0xbe},{0xbf,0x7a},{0xea,0xc1},{0xea,0xc4},{0x96,0xd1},
    {0x82,0xa1},{0x8c,0x46},{0x00,0x00},{0xed,0xcb},{0xed,0xcc},
    {0xed,0xbc},{0xed,0xc3},{0xed,0xc1},{0x00,0x00},{0xfa,0xdb},
    {0xc1,0x4f},{0xed,0xc8},{0xea,0xbf},{0x96,0xd2},{0xed,0xbf},
    {0xfc,0xe1},{0xed,0xc9},{0xc1,0x4e},{0xed,0xbe},{0xed,0xbd},
    {0xed,0xc7},{0xed,0xc4},{0xed,0xc6},{0x00,0x00},{0xed,0xba},
    {0xed,0xca},{0xc1,0x4c},{0x00,0x00},{0xed,0xc5},{0xed,0xce},
    {0xed,0xc2},{0xc1,0x50},{0xc1,0x4d},{0xed,0xc0},{0xed,0xbb},
    {0xed,0xcd},{0xbf,0x75},{0xfa,0xdc},{0x94,0xbc},{0xfa,0xdd},
    {0x96,0xd3},{0x90,0x77},{0x94,0xbd},{0x00,0x00},{0xf0,0x63},
    {0x00,0x00},{0x96,0xd4},{0xf0,0x61},{0xf0,0x67},{0xc2,0xb0},
    {0xf0,0x65},{0xf0,0x64},{0xc2,0xb2},{0xf0,0x6a},{0xc2,0xb1},
    {0x00,0x00},{0xf0,0x6b},{0xf0,0x68},{0xc2,0xae},{0xf0,0x69},
    {0xf0,0x62},{0xc2,0xaf},{0xc2,0xad},{0xf2,0xab},{0xf0,0x66},
    {0x00,0x00},{0x00,0x00},{0xf0,0x6c},{0x00,0x00},{0x00,0x00},
    {0xf2,0xa8},{0x00,0x00},{0x96,0xd5},{0x00,0x00},{0xc3,0xb2},
    {0xc3,0xb0},{0xf2,0xaa},{0x00,0x00},{0xf2,0xac},{0xf2,0xa9},
    {0xc3,0xb1},{0xc3,0xae},{0xc3,0xaf},{0xc3,0xb3},{0x8c,0xd8},
    {0xfc,0xe2},{0xc4,0x78},{0x96,0xd6},{0xf4,0xaa},{0x00,0x00},
    {0xf4,0xa9},{0xf4,0xa7},{0xf4,0xa6},{0xf4,0xa8},{0x00,0x00},
    {0xc4,0x77},{0xc4,0x79},{0x00,0x00},{0xfa,0xde},{0xc4,0xf0},
    {0xfc,0xe3},{0x00,0x00},{0xf5,0xe5},{0xf5,0xe4},{0x00,0x00},
    {0xfa,0xdf},{0xf6,0xfa},{0xfa,0xe0},{0xf6,0xfc},{0xf6,0xfe},
    {0xf6,0xfd},{0xf6,0xfb},{0xfc,0xe4},{0x00,0x00},{0xc5,0xa3},
    {0xc5,0xa2},{0x00,0x00},{0x00,0x00},{0xc5,0xd3},{0xc5,0xd2},
    {0xc5,0xd4},{0xf7,0xed},{0xf7,0xec},{0x00,0x00},{0xf8,0xfb},
    {0xf8,0xb8},{0xf8,0xfc},{0xc6,0x58},{0x96,0xd7},{0xc6,0x59},
    {0xf9,0x6d},{0xfc,0xe5},{0x00,0x00},{0xc6,0x7e},{0xa6,0xcc},
    {0x90,0x5a},{0xcd,0xa8},{0x00,0x00},{0x00,0x00},{0xd0,0x45},
    {0xd0,0x46},{0xd0,0x44},{0x8b,0xdd},{0x83,0x5e},{0xac,0xf3},
    {0xfc,0xe6},{0xd0,0x47},{0xd0,0x48},{0xd0,0x49},{0x94,0x43},
    {0xfc,0xe8},{0xd3,0x49},{0xd3,0x4f},{0xfc,0xe7},{0x00,0x00},
    {0xd3,0x4d},{0xaf,0xbb},{0xd3,0x4b},{0x92,0xf7},{0xd3,0x4c},
    {0xd3,0x4e},{0x96,0xd8},{0x00,0x00},{0x94,0xbe},{0xd3,0x4a},
    {0xb2,0xc9},{0x00,0x00},{0xd6,0xde},{0xb2,0xcb},{0xd6,0xe0},
    {0xb2,0xca},{0xd6,0xdf},{0x00,0x00},{0x00,0x00},{0x92,0xe0},
    {0x90,0x7b},{0x90,0x43},{0xda,0xe8},{0xb5,0xaf},{0x00,0x00},
    {0xda,0xea},{0xda,0xe7},{0xd6,0xe1},{0x85,0xed},{0xb5,0xb0},
    {0xfe,0x63},{0xf9,0xdb},{0xda,0xe9},{0x00,0x00},{0x8a,0x41},
    {0xfa,0xe1},{0xfc,0xe9},{0x94,0xbf},{0x8a,0xea},{0xdf,0x56},
    {0x00,0x00},{0xb8,0x64},{0xdf,0x54},{0xb8,0x65},{0xdf,0x55},
    {0xb8,0x66},{0x00,0x00},{0x00,0x00},{0x96,0xd9},{0xba,0xe9},
    {0xe3,0x61},{0xe3,0x5e},{0xe3,0x60},{0xba,0xea},{0xba,0xeb},
    {0xe3,0x5f},{0x94,0xc0},{0x8a,0x43},{0xfc,0xeb},{0x96,0xda},
    {0x00,0x00},{0xe6,0xdf},{0x00,0x00},{0xfc,0xea},{0xe6,0xe0},
    {0x95,0xb2},{0xbd,0x6b},{0xe6,0xe2},{0xe6,0xe1},{0xa0,0x54},
    {0xa2,0x61},{0x00,0x00},{0xea,0xca},{0xea,0xcb},{0xea,0xc7},
    {0xfb,0x7e},{0xea,0xc8},{0xbf,0x7c},{0xbf,0x7d},{0xea,0xc9},
    {0x94,0xc1},{0xc1,0x57},{0xfc,0xed},{0x00,0x00},{0xc1,0x53},
    {0xc1,0x58},{0xc1,0x54},{0xc1,0x56},{0xc1,0x52},{0x00,0x00},
    {0xc1,0x55},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x96,0xdb},
    {0xc2,0xb3},{0xed,0xcf},{0x00,0x00},{0xf2,0xae},{0x00,0x00},
    {0xf2,0xad},{0x96,0xdc},{0xf4,0xab},{0xc4,0x7a},{0xc4,0x7b},
    {0xf7,0x41},{0xf5,0xe6},{0x96,0xdd},{0xf7,0x40},{0x96,0xde},
    {0xf8,0xfd},{0xf9,0xa4},{0xa6,0xcd},{0x96,0xdf},{0xfa,0xe2},
    {0xa8,0x74},{0x96,0xe1},{0xcd,0xa9},{0xaa,0xc8},{0x00,0x00},
    {0xac,0xf6},{0xd0,0x4c},{0xac,0xf4},{0xd0,0x4a},{0xac,0xf9},
    {0xac,0xf5},{0xac,0xfa},{0xac,0xf8},{0xd0,0x4b},{0xac,0xf7},
    {0xaf,0xbf},{0xaf,0xbe},{0xd3,0x5a},{0xaf,0xc7},{0xd3,0x53},
    {0xd3,0x59},{0xaf,0xc3},{0xd3,0x52},{0xd3,0x58},{0xd3,0x56},
    {0xaf,0xc2},{0xaf,0xc4},{0xd3,0x55},{0xaf,0xbd},{0xd3,0x54},
    {0xaf,0xc8},{0xaf,0xc5},{0xaf,0xc9},{0xaf,0xc6},{0xd3,0x51},
    {0xd3,0x50},{0xd3,0x57},{0xaf,0xc0},{0xaf,0xbc},{0xaf,0xc1},
    {0x00,0x00},{0x00,0x00},{0x95,0xe2},{0x00,0x00},{0x86,0xfa},
    {0xd6,0xf0},{0xd6,0xe9},{0x00,0x00},{0xb5,0xb5},{0xd6,0xe8},
    {0x00,0x00},{0xb2,0xcf},{0xb2,0xd6},{0xb2,0xd3},{0xb2,0xd9},
    {0xb2,0xd8},{0xb2,0xd4},{0x00,0x00},{0xd6,0xe2},{0xd6,0xe5},
    {0x00,0x00},{0xd6,0xe4},{0xb2,0xd0},{0xd6,0xe6},{0xd6,0xef},
    {0xb2,0xd1},{0xd6,0xe3},{0xd6,0xec},{0xd6,0xed},{0xb2,0xd2},
    {0xd6,0xea},{0xb2,0xd7},{0xb2,0xcd},{0xb2,0xd5},{0xd6,0xe7},
    {0xb2,0xcc},{0xd6,0xeb},{0xfa,0xe3},{0x00,0x00},{0xd6,0xee},
    {0xfa,0xe4},{0x92,0xab},{0xfc,0xef},{0xda,0xfb},{0xda,0xf2},
    {0xb5,0xb2},{0xda,0xf9},{0xda,0xf6},{0xda,0xee},{0xda,0xf7},
    {0xb5,0xb4},{0xda,0xef},{0x00,0x00},{0xda,0xeb},{0x00,0x00},
    {0xfc,0xf0},{0xb8,0x6c},{0xda,0xf4},{0xfe,0x60},{0xb5,0xb1},
    {0xda,0xfa},{0x00,0x00},{0xb5,0xb8},{0xb5,0xba},{0xda,0xed},
    {0x00,0x00},{0x00,0x00},{0xb5,0xb9},{0xda,0xf0},{0xb5,0xb3},
    {0xda,0xf8},{0xda,0xf1},{0xda,0xf5},{0x00,0x00},{0xda,0xf3},
    {0xb5,0xb6},{0xda,0xec},{0xb5,0xbb},{0xb2,0xce},{0xb5,0xb7},
    {0xb5,0xbc},{0x00,0x00},{0x92,0x5b},{0x93,0x46},{0xfa,0xe5},
    {0x00,0x00},{0xb8,0x68},{0xdf,0x5d},{0xdf,0x5f},{0xdf,0x61},
    {0xdf,0x65},{0x00,0x00},{0xdf,0x5b},{0xdf,0x59},{0xb8,0x6a},
    {0x00,0x00},{0xdf,0x60},{0xdf,0x64},{0xdf,0x5c},{0xdf,0x58},
    {0x00,0x00},{0xdf,0x57},{0x95,0x68},{0x00,0x00},{0x96,0xe2},
    {0xdf,0x62},{0xdf,0x5a},{0xdf,0x5e},{0xb8,0x6b},{0x00,0x00},
    {0xb8,0x69},{0xdf,0x66},{0xb8,0x67},{0xdf,0x63},{0x9d,0xb9},
    {0xe3,0x72},{0x96,0xe3},{0x00,0x00},{0x92,0xae},{0x93,0x64},
    {0x94,0xc2},{0xba,0xee},{0xe3,0x6a},{0xbd,0x78},{0xe3,0x74},
    {0xba,0xf1},{0xe3,0x78},{0xba,0xf7},{0xe3,0x65},{0x96,0xe4},
    {0x00,0x00},{0xe3,0x75},{0xe3,0x62},{0x96,0xe5},{0xe3,0x77},
    {0xe3,0x66},{0x95,0x56},{0xba,0xfe},{0xba,0xfb},{0xe3,0x76},
    {0xe3,0x70},{0xba,0xed},{0xba,0xf5},{0xba,0xf4},{0x95,0x6a},
    {0xba,0xf3},{0xba,0xf9},{0x00,0x00},{0xe3,0x63},{0xba,0xfa},
    {0xe3,0x71},{0xba,0xf6},{0xba,0xec},{0xe3,0x73},{0xba,0xef},
    {0xba,0xf0},{0xba,0xf8},{0xe3,0x68},{0xe3,0x67},{0xe3,0x64},
    {0x00,0x00},{0xe3,0x6c},{0xe3,0x69},{0xe3,0x6d},{0xba,0xfd},
    {0x00,0x00},{0xe3,0x79},{0xba,0xf2},{0xe3,0x6e},{0xe3,0x6f},
    {0x96,0xe6},{0xe3,0x6b},{0x93,0x5c},{0x96,0xe7},{0x93,0xe7},
    {0xba,0xfc},{0x96,0xe8},{0xfa,0xe6},{0xfa,0xe7},{0xfa,0xe8},
    {0xe6,0xe7},{0xbd,0x70},{0xbd,0x79},{0xbd,0x75},{0xe6,0xe4},
    {0x95,0xc3},{0xbd,0x72},{0xbd,0x76},{0xe6,0xf0},{0xbd,0x6c},
    {0xe6,0xe8},{0x00,0x00},{0xbd,0x74},{0xfa,0xe9},{0x96,0xe9},
    {0xe6,0xeb},{0xe6,0xe6},{0xbd,0x73},{0xbd,0x77},{0xe6,0xe5},
    {0x00,0x00},{0xbd,0x71},{0x00,0x00},{0xe6,0xef},{0xbd,0x6e},
    {0xe6,0xee},{0xe6,0xed},{0xbd,0x7a},{0xe5,0x72},{0xbd,0x6d},
    {0xfc,0xf1},{0xe6,0xec},{0xe6,0xe3},{0x00,0x00},{0xbd,0x7b},
    {0xe6,0xea},{0xbd,0x6f},{0x00,0x00},{0x96,0xea},{0x9f,0x7e},
    {0x00,0x00},{0x00,0x00},{0x92,0x4d},{0x00,0x00},{0xe6,0xe9},
    {0x92,0xed},{0x94,0xc3},{0x00,0x00},{0x9f,0xa1},{0xbf,0xa2},
    {0xbf,0xa7},{0xbf,0x7e},{0xea,0xd8},{0xea,0xcf},{0xea,0xdb},
    {0xea,0xd3},{0xea,0xd9},{0xbf,0xa8},{0xbf,0xa1},{0xea,0xcc},
    {0xea,0xd2},{0xea,0xdc},{0xea,0xd5},{0xea,0xda},{0xea,0xce},
    {0x00,0x00},{0x00,0x00},{0xea,0xd6},{0xbf,0xa3},{0xea,0xd4},
    {0xbf,0xa6},{0xbf,0xa5},{0xea,0xd0},{0xea,0xd1},{0xea,0xcd},
    {0xea,0xd7},{0xbf,0xa4},{0xea,0xde},{0xea,0xdd},{0x92,0xdf},
    {0xfc,0xf2},{0x00,0x00},{0xed,0xda},{0xed,0xd6},{0xc1,0x5f},
    {0x00,0x00},{0xed,0xd0},{0xc1,0x59},{0xc1,0x69},{0xed,0xdc},
    {0xc1,0x61},{0xc1,0x5d},{0xed,0xd3},{0xc1,0x64},{0xc1,0x67},
    {0xed,0xde},{0xc1,0x5c},{0xed,0xd5},{0xc1,0x65},{0xed,0xe0},
    {0xed,0xdd},{0xed,0xd1},{0xc1,0x60},{0xc1,0x5a},{0xc1,0x68},
    {0xed,0xd8},{0xc1,0x63},{0xed,0xd2},{0xc1,0x5e},{0xed,0xdf},
    {0xc1,0x62},{0xc1,0x5b},{0xed,0xd9},{0xc1,0x66},{0xed,0xd7},
    {0x93,0x4f},{0x82,0x5a},{0xed,0xdb},{0xfa,0xea},{0x00,0x00},
    {0x00,0x00},{0xf0,0x6e},{0xf0,0x74},{0xc2,0xb9},{0xf0,0x77},
    {0xc2,0xb4},{0xc2,0xb5},{0xf0,0x6f},{0xf0,0x76},{0xf0,0x71},
    {0xc2,0xba},{0xc2,0xb7},{0x9f,0xa2},{0xf0,0x6d},{0xfa,0xeb},
    {0xc2,0xb6},{0xf0,0x73},{0xf0,0x75},{0xc2,0xb8},{0xf0,0x72},
    {0xf0,0x70},{0x00,0x00},{0x9f,0xa3},{0x8a,0x50},{0x94,0xc4},
    {0xf2,0xb8},{0xc3,0xb7},{0xc3,0xb8},{0xc3,0xb4},{0x9f,0xa4},
    {0xc3,0xb5},{0x8c,0xe8},{0xf2,0xb4},{0xf2,0xb2},{0x00,0x00},
    {0xf2,0xb6},{0xc3,0xba},{0xf2,0xb7},{0xf2,0xb0},{0xf2,0xaf},
    {0xf2,0xb3},{0xf2,0xb1},{0xc3,0xb6},{0xf2,0xb5},{0xf4,0xac},
    {0xc4,0x7e},{0xc4,0x7d},{0xf4,0xad},{0xfa,0xec},{0xf4,0xaf},
    {0xf4,0xae},{0xc4,0xa1},{0x94,0xc5},{0x00,0x00},{0x00,0x00},
    {0xf5,0xeb},{0xf5,0xe8},{0xf5,0xe9},{0xfa,0xed},{0xf5,0xe7},
    {0xf5,0xea},{0xc4,0xf2},{0xf5,0xec},{0xfa,0xee},{0xc4,0xf1},
    {0x94,0xc6},{0xf7,0x42},{0xfa,0xef},{0xc5,0xd5},{0xc5,0xd7},
    {0xf7,0xee},{0xc5,0xd6},{0xf8,0xb9},{0xf9,0x40},{0xf9,0x42},
    {0xf8,0xfe},{0xf9,0x41},{0xc6,0x6c},{0x00,0x00},{0x00,0x00},
    {0x9c,0xeb},{0x83,0x5f},{0x83,0x76},{0x83,0x71},{0x83,0x70},
    {0x8a,0x4e},{0x83,0x74},{0x83,0x75},{0x83,0xcb},{0x8d,0xbe},
    {0x90,0x44},{0x83,0x72},{0x83,0x73},{0x87,0xfe},{0x83,0xcc},
    {0x00,0x00},{0x83,0xc8},{0x83,0xca},{0x83,0xc6},{0x86,0xfc},
    {0x83,0xcd},{0x00,0x00},{0x8a,0x4c},{0x87,0x41},{0x83,0xcf},
    {0x83,0xce},{0x83,0xc7},{0x83,0xc5},{0x00,0x00},{0x00,0x00},
    {0x83,0xc9},{0x8d,0xc5},{0x88,0x45},{0x8d,0xd3},{0x84,0x71},
    {0x84,0x72},{0x87,0xfd},{0x84,0x6f},{0x84,0x6e},{0x84,0x6d},
    {0x8a,0xeb},{0x84,0x70},{0x89,0x53},{0x84,0x68},{0x84,0x6b},
    {0x84,0x6c},{0x84,0x6a},{0x8b,0xb1},{0x85,0xee},{0x8d,0xd4},
    {0x85,0xf0},{0x85,0x44},{0x85,0x43},{0xfa,0xf0},{0x8a,0xed},
    {0x85,0x4a},{0x8d,0xe4},{0x8b,0xb3},{0x85,0x48},{0x85,0x49},
    {0x85,0x4b},{0x85,0x47},{0x85,0x45},{0x85,0x42},{0x84,0x69},
    {0x8e,0x4a},{0x8e,0x4b},{0x85,0xef},{0x8a,0xef},{0x00,0x00},
    {0x85,0xf1},{0x85,0xf2},{0x8c,0x49},{0x8e,0x49},{0x8a,0x45},
    {0x87,0x43},{0x86,0xf8},{0x00,0x00},{0x8c,0xa2},{0x86,0xfd},
    {0x8e,0x7b},{0x86,0xf7},{0xfa,0xf1},{0x8e,0x7a},{0x8b,0xb2},
    {0x87,0x42},{0x87,0x40},{0x87,0x45},{0x8a,0x49},{0x86,0xfe},
    {0x00,0x00},{0x8e,0x7c},{0x8e,0x79},{0x86,0xf6},{0x86,0xf4},
    {0x86,0xf5},{0x86,0xf9},{0x86,0xfb},{0x87,0x44},{0x88,0x49},
    {0x8e,0xc2},{0x88,0x40},{0x88,0x41},{0x8d,0xa3},{0x88,0x4b},
    {0x88,0x4a},{0x88,0x42},{0x00,0x00},{0x8f,0x79},{0x8e,0xc4},
    {0x88,0x48},{0x88,0x46},{0x8e,0xc5},{0x00,0x00},{0x8e,0xc6},
    {0xfa,0xf2},{0x88,0x47},{0x87,0xfc},{0x8a,0x47},{0x88,0x43},
    {0x8e,0xc3},{0x88,0x44},{0x89,0x52},{0x89,0x4e},{0x8e,0xf0},
    {0x89,0x51},{0x8a,0x4a},{0x00,0x00},{0x89,0x50},{0x8c,0xa1},
    {0x8f,0x5d},{0x89,0x4b},{0x89,0x4c},{0x8c,0x48},{0x8a,0x4f},
    {0x8a,0x51},{0x8a,0x48},{0x8c,0xfb},{0x8a,0x44},{0x8a,0x46},
    {0x8a,0x4d},{0x90,0x45},{0x8a,0xee},{0x8a,0xec},{0x8a,0xf0},
    {0xfa,0xf3},{0x8f,0xde},{0x8f,0xbf},{0x8f,0xc0},{0x8b,0xb5},
    {0x90,0x7c},{0xa6,0xce},{0x9f,0xa5},{0xac,0xfb},{0xd2,0x6f},
    {0xaf,0xca},{0x00,0x00},{0x00,0x00},{0xb2,0xda},{0xda,0xfc},
    {0xda,0xfd},{0x9f,0xa6},{0x9f,0xa7},{0x8c,0x4a},{0xea,0xdf},
    {0xc1,0x6a},{0xed,0xe1},{0x00,0x00},{0x95,0x74},{0xc2,0xbb},
    {0x9f,0xa8},{0xf2,0xba},{0xf2,0xb9},{0xc4,0xa2},{0xf5,0xed},
    {0xfb,0xaa},{0xf7,0x43},{0xc5,0xf8},{0xca,0x49},{0x9f,0xa9},
    {0x9d,0x75},{0xaa,0xc9},{0xa8,0x75},{0x00,0x00},{0x8b,0xb4},
    {0xd0,0x4d},{0x00,0x00},{0x87,0x46},{0xd3,0x60},{0xd3,0x5b},
    {0xd3,0x5f},{0xd3,0x5d},{0xaf,0xcb},{0xd3,0x5e},{0xd3,0x5c},
    {0x88,0x4d},{0xd6,0xf1},{0x00,0x00},{0xda,0xfe},{0xdb,0x40},
    {0xdf,0x69},{0xdf,0x6a},{0xb8,0x6e},{0xb8,0x6f},{0xdf,0x68},
    {0xdf,0x6b},{0xdf,0x67},{0xb8,0x6d},{0x00,0x00},{0xbb,0x40},
    {0xfa,0xf4},{0xb8,0x70},{0xe3,0x7a},{0x8f,0xc1},{0xbd,0x7c},
    {0xe6,0xf1},{0xbd,0x7d},{0x95,0x64},{0xbf,0xa9},{0xea,0xe2},
    {0xea,0xe0},{0xea,0xe1},{0xed,0xe4},{0xed,0xe3},{0xed,0xe2},
    {0x00,0x00},{0x8d,0x56},{0xfa,0xf5},{0xf2,0xbb},{0x00,0x00},
    {0xc3,0xb9},{0xf2,0xbc},{0xf7,0x44},{0xc5,0xf9},{0xf8,0xba},
    {0xa6,0xcf},{0xaa,0xcb},{0xaa,0xca},{0xd0,0x4f},{0xac,0xfc},
    {0x9f,0xaa},{0x00,0x00},{0xd0,0x4e},{0xd3,0x62},{0x9f,0xab},
    {0xaf,0xcc},{0xd6,0xf2},{0xd3,0x61},{0x95,0xe0},{0x00,0x00},
    {0x00,0x00},{0xb2,0xdc},{0xd6,0xf5},{0xd6,0xf3},{0xd6,0xf4},
    {0xb2,0xdb},{0x8e,0x4c},{0xdb,0x42},{0xdb,0x43},{0xdb,0x41},
    {0x95,0x55},{0xb8,0x73},{0xdf,0x6d},{0xdf,0x6c},{0xdf,0x6e},
    {0xb8,0x72},{0xb8,0x71},{0x00,0x00},{0x00,0x00},{0xe6,0xf2},
    {0xe6,0xf4},{0xfa,0xf6},{0xbd,0x7e},{0xe6,0xf3},{0xea,0xe3},
    {0xbf,0xaa},{0xf0,0x79},{0x9f,0xac},{0xf0,0x78},{0xc3,0xbb},
    {0xf2,0xbd},{0xc3,0xbd},{0xc3,0xbc},{0xf4,0xb0},{0xf5,0xee},
    {0xc4,0xf3},{0xa6,0xd0},{0xd0,0x50},{0xac,0xfd},{0xd3,0x65},
    {0xaf,0xce},{0xd3,0x64},{0xd3,0x63},{0x00,0x00},{0xaf,0xcd},
    {0xfa,0xf7},{0xd6,0xfb},{0x00,0x00},{0xd6,0xfd},{0xd6,0xf6},
    {0xd6,0xf7},{0xb2,0xdd},{0xd6,0xf8},{0xb2,0xde},{0xd6,0xfc},
    {0xd6,0xf9},{0xd6,0xfa},{0xb2,0xdf},{0x00,0x00},{0xb5,0xbe},
    {0xb5,0xbf},{0x00,0x00},{0xdb,0x44},{0x8a,0xf1},{0x00,0x00},
    {0x00,0x00},{0xdf,0x6f},{0xdf,0x70},{0x9f,0xad},{0xe3,0x7e},
    {0xbb,0x43},{0xbb,0x41},{0xbb,0x42},{0xe3,0x7b},{0xe3,0x7c},
    {0x00,0x00},{0xe3,0x7d},{0xe6,0xf9},{0x9f,0xae},{0xe6,0xfa},
    {0xbd,0xa1},{0xe6,0xf7},{0xe6,0xf6},{0xe6,0xf8},{0xe6,0xf5},
    {0xbf,0xad},{0xea,0xe4},{0xbf,0xab},{0xbf,0xac},{0xed,0xe6},
    {0xc1,0x6b},{0xed,0xe5},{0xef,0xa8},{0x00,0x00},{0xf0,0x7a},
    {0xf0,0x7b},{0xc2,0xbc},{0x9f,0xaf},{0xc2,0xbd},{0xc1,0x6c},
    {0xf2,0xbe},{0xf2,0xbf},{0xf4,0xb1},{0xc4,0xa3},{0xa6,0xd1},
    {0x9f,0xb0},{0xa6,0xd2},{0xac,0xfe},{0xaa,0xcc},{0xaf,0xcf},
    {0xd0,0x51},{0x9f,0xb1},{0x00,0x00},{0x00,0x00},{0xb5,0xc0},
    {0xa6,0xd3},{0xad,0x41},{0xd0,0x52},{0xd0,0x53},{0xad,0x40},
    {0xad,0x42},{0xa6,0xd4},{0x00,0x00},{0xd0,0x54},{0xaf,0xd1},
    {0xd3,0x66},{0xaf,0xd3},{0xaf,0xd0},{0xaf,0xd2},{0x00,0x00},
    {0xd7,0x41},{0xb2,0xe0},{0xfc,0xf6},{0xd7,0x40},{0xd6,0xfe},
    {0xfa,0xf8},{0xdf,0x71},{0xfa,0xf9},{0x00,0x00},{0xe3,0xa1},
    {0xfa,0xfa},{0xbd,0xa2},{0x8f,0x5e},{0xbf,0xae},{0xea,0xe6},
    {0xea,0xe5},{0x00,0x00},{0xed,0xe7},{0x00,0x00},{0x9f,0xb2},
    {0x9f,0xb3},{0xf5,0xef},{0xfa,0xfb},{0x00,0x00},{0xa6,0xd5},
    {0xcb,0x73},{0xcd,0xaa},{0xad,0x43},{0xd0,0x55},{0x8a,0x55},
    {0xd3,0x68},{0x00,0x00},{0x95,0x5c},{0x9f,0xb4},{0xaf,0xd4},
    {0xd3,0x67},{0xaf,0xd5},{0x00,0x00},{0x00,0x00},{0x8a,0xf3},
    {0xd7,0x43},{0x00,0x00},{0x00,0x00},{0xb2,0xe2},{0xd7,0x42},
    {0xd7,0x44},{0x00,0x00},{0xb2,0xe1},{0x8c,0xd9},{0x8a,0xf2},
    {0x8f,0xdf},{0x00,0x00},{0xdb,0x46},{0xdb,0x47},{0xdb,0x45},
    {0xb5,0xc1},{0x00,0x00},{0x8a,0x54},{0x00,0x00},{0xb8,0x74},
    {0x00,0x00},{0xb8,0x75},{0x00,0x00},{0xbb,0x45},{0xfc,0xfa},
    {0xe3,0xa3},{0xe3,0xa2},{0xbb,0x44},{0xfa,0xfc},{0x00,0x00},
    {0x82,0x6b},{0xfc,0xf7},{0xfc,0xf8},{0xe6,0xfb},{0x00,0x00},
    {0xfc,0xf9},{0xe6,0xfc},{0xfa,0xfd},{0x8f,0x7a},{0x8a,0x53},
    {0x00,0x00},{0xea,0xe7},{0x00,0x00},{0x00,0x00},{0xc1,0x70},
    {0xc1,0x6f},{0xc1,0x6d},{0xc1,0x6e},{0xc1,0x71},{0x93,0x77},
    {0xf0,0x7c},{0xc2,0xbf},{0xc2,0xbe},{0xf2,0xc0},{0xf4,0xb2},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0xc5,0xa5},{0xc5,0xa4},
    {0xa6,0xd6},{0x91,0xd5},{0x00,0x00},{0xd1,0xfb},{0x85,0x4c},
    {0xb8,0x77},{0xb5,0xc2},{0xb8,0x76},{0xbb,0x46},{0x00,0x00},
    {0xa6,0xd7},{0xc9,0xa9},{0xa6,0xd8},{0xa6,0xd9},{0x00,0x00},
    {0x00,0x00},{0xcd,0xab},{0xcb,0x76},{0x00,0x00},{0xcb,0x77},
    {0xa8,0x77},{0x00,0x00},{0xcb,0x74},{0xa8,0x76},{0x00,0x00},
    {0xa8,0x79},{0xcb,0x75},{0xa8,0x7b},{0xa8,0x7a},{0xcb,0x78},
    {0xa8,0x78},{0x00,0x00},{0x96,0xaf},{0x85,0xf6},{0xaa,0xd1},
    {0xaa,0xcf},{0xcd,0xad},{0x88,0x4f},{0xaa,0xce},{0xfc,0xfb},
    {0x9f,0xb5},{0x00,0x00},{0xaa,0xd3},{0xaa,0xd5},{0xaa,0xd2},
    {0xfa,0xfe},{0xcd,0xb0},{0xcd,0xac},{0xaa,0xd6},{0x00,0x00},
    {0xaa,0xd0},{0xa8,0x7c},{0x00,0x00},{0xaa,0xd4},{0xcd,0xaf},
    {0xfb,0x4d},{0xfb,0x40},{0xcd,0xae},{0x00,0x00},{0xaa,0xcd},
    {0x00,0x00},{0x96,0xcb},{0x96,0xa6},{0x85,0x4d},{0x85,0xf8},
    {0x85,0x4e},{0x83,0xd0},{0xd0,0x5b},{0xad,0x47},{0xad,0x48},
    {0xd0,0x5d},{0x8a,0x57},{0xd0,0x57},{0xd0,0x5a},{0xd0,0x63},
    {0xd0,0x61},{0x00,0x00},{0xad,0x49},{0xd0,0x67},{0xad,0x4c},
    {0xd0,0x64},{0xd0,0x5c},{0xd0,0x59},{0x00,0x00},{0x00,0x00},
    {0xdb,0x49},{0xd0,0x62},{0xad,0x44},{0xd0,0x65},{0xd0,0x56},
    {0xd0,0x5f},{0xad,0x46},{0xad,0x4b},{0xd0,0x60},{0xad,0x4f},
    {0xad,0x4d},{0x00,0x00},{0xd0,0x58},{0xad,0x4a},{0x00,0x00},
    {0xd0,0x5e},{0xad,0x4e},{0xad,0x45},{0xd0,0x66},{0x8b,0xf8},
    {0xfd,0xfb},{0xfd,0xfc},{0x8c,0x4b},{0x8d,0xd5},{0xfd,0xfd},
    {0xaf,0xda},{0x00,0x00},{0xaf,0xe3},{0xaf,0xd8},{0xaf,0xd6},
    {0xd3,0x6a},{0xaf,0xde},{0xaf,0xdb},{0xd3,0x6c},{0x88,0x4e},
    {0x00,0x00},{0xaf,0xdd},{0xd3,0x6b},{0xd3,0x69},{0xd3,0x6e},
    {0xaf,0xe2},{0xaf,0xe0},{0xdb,0x48},{0x00,0x00},{0xd3,0x6f},
    {0xd3,0x6d},{0xaf,0xd7},{0xfc,0xfc},{0x00,0x00},{0xaf,0xd9},
    {0xaf,0xdc},{0xfe,0x48},{0xaf,0xdf},{0x83,0xd1},{0xaf,0xe1},
    {0x00,0x00},{0x9f,0xb6},{0x8a,0x59},{0xfd,0xfe},{0x8c,0xda},
    {0x8a,0xf4},{0x85,0xf9},{0xfe,0xee},{0x8a,0x56},{0x90,0x7d},
    {0xd7,0x4e},{0xb2,0xe4},{0x95,0xa8},{0xd7,0x45},{0xd7,0x47},
    {0x85,0xf7},{0xd7,0x48},{0x00,0x00},{0xd7,0x50},{0xd7,0x4c},
    {0xd7,0x4a},{0x00,0x00},{0xd7,0x4d},{0xd7,0x51},{0xb2,0xe5},
    {0xb2,0xe9},{0xd7,0x46},{0x00,0x00},{0xd7,0x4f},{0x00,0x00},
    {0xb2,0xe7},{0x9f,0xb7},{0xb2,0xe6},{0xd7,0x4b},{0xd7,0x49},
    {0x00,0x00},{0xb2,0xe3},{0xb2,0xe8},{0xfe,0xef},{0x96,0xa5},
    {0x93,0xb0},{0x9f,0xb8},{0x00,0x00},{0xfe,0xf0},{0xa0,0x42},
    {0x8a,0x58},{0xb5,0xc8},{0xdb,0x51},{0x00,0x00},{0x00,0x00},
    {0xdb,0x4f},{0xb5,0xca},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x9f,0xb9},{0xdb,0x4a},{0xdf,0xa1},{0x00,0x00},{0xb5,0xc9},
    {0xdb,0x4e},{0x96,0xab},{0x00,0x00},{0xdb,0x4b},{0xb5,0xc5},
    {0xb5,0xcb},{0xdb,0x50},{0xb5,0xc7},{0xdb,0x4d},{0xbb,0x47},
    {0xb5,0xc6},{0xdb,0x4c},{0xb5,0xcc},{0xb5,0xc4},{0xb5,0xc3},
    {0x9f,0xba},{0x00,0x00},{0x00,0x00},{0x96,0xae},{0x96,0xa2},
    {0xdf,0x77},{0xdf,0x75},{0x00,0x00},{0xdf,0x7b},{0xfe,0xf1},
    {0xdf,0x73},{0xdf,0xa2},{0xdf,0x78},{0x00,0x00},{0xdf,0x72},
    {0xb8,0x7b},{0xb8,0xa3},{0xdf,0x7d},{0x00,0x00},{0xdf,0x76},
    {0x00,0x00},{0xb8,0x7e},{0x9d,0xd0},{0xfe,0xf2},{0xb8,0x7c},
    {0xdf,0x7e},{0xb8,0x79},{0xb8,0x78},{0xdf,0x79},{0xb8,0x7d},
    {0xb5,0xcd},{0x00,0x00},{0xdf,0x7c},{0xdf,0x74},{0xb8,0x7a},
    {0xb8,0xa1},{0xb8,0xa2},{0x89,0x54},{0x89,0xae},{0xfe,0xf3},
    {0x8c,0x65},{0xbb,0x4c},{0xbb,0x48},{0x00,0x00},{0xbb,0x4d},
    {0xe3,0xa6},{0x9f,0xbb},{0x00,0x00},{0xe3,0xa5},{0xe3,0xa7},
    {0xbb,0x4a},{0xe3,0xa4},{0xbb,0x4b},{0xe3,0xaa},{0xe3,0xa9},
    {0xe3,0xa8},{0x00,0x00},{0xbb,0x49},{0x00,0x00},{0x8a,0xf5},
    {0x00,0x00},{0xfe,0xf4},{0x00,0x00},{0xe7,0x41},{0x00,0x00},
    {0xe7,0x44},{0xbd,0xa8},{0xe7,0x43},{0xbd,0xa7},{0xbd,0xa3},
    {0xbd,0xa4},{0xbd,0xa5},{0xe7,0x40},{0xe6,0xfe},{0xbd,0xa6},
    {0x00,0x00},{0xe7,0x42},{0xe6,0xfd},{0x94,0xc7},{0x9f,0xbc},
    {0xea,0xe9},{0xea,0xf3},{0xbf,0xb1},{0xbf,0xb0},{0xfe,0xf5},
    {0xea,0xed},{0xea,0xef},{0x00,0x00},{0xea,0xea},{0x00,0x00},
    {0xea,0xee},{0xea,0xe8},{0xea,0xf1},{0xbf,0xaf},{0xea,0xf0},
    {0xea,0xec},{0xfb,0x6e},{0xea,0xf2},{0xfe,0xf6},{0xea,0xeb},
    {0xc1,0x74},{0xed,0xe8},{0xed,0xee},{0xc1,0x78},{0xc1,0x7a},
    {0xc1,0x77},{0xc1,0x76},{0xfe,0xf7},{0xc1,0x75},{0xc1,0x73},
    {0xed,0xe9},{0xed,0xec},{0xc1,0x72},{0xed,0xed},{0xfc,0xfe},
    {0xc1,0x79},{0xed,0xeb},{0x00,0x00},{0xed,0xea},{0xc2,0xc0},
    {0x00,0x00},{0xc2,0xc1},{0xf0,0xa1},{0xf0,0x7d},{0xf0,0x7e},
    {0x93,0x62},{0x00,0x00},{0xf2,0xc2},{0x00,0x00},{0xf2,0xc1},
    {0xc3,0xbe},{0xf4,0xb4},{0xc4,0xa4},{0xf4,0xb3},{0x00,0x00},
    {0xf5,0xf0},{0xf7,0x45},{0xc5,0xa6},{0xf9,0x43},{0xf9,0x44},
    {0xc5,0xd8},{0xa6,0xda},{0x9f,0xbd},{0xaa,0xd7},{0xdb,0x52},
    {0xbb,0x4e},{0xc1,0x7b},{0xed,0xef},{0xa6,0xdb},{0x00,0x00},
    {0xaf,0xe5},{0xaf,0xe4},{0xdb,0x53},{0x95,0xd3},{0x00,0x00},
    {0x00,0x00},{0xea,0xf4},{0xa6,0xdc},{0xad,0x50},{0x00,0x00},
    {0xfd,0x42},{0xdb,0x54},{0xdb,0x55},{0xdb,0x56},{0xbb,0x4f},
    {0xbf,0xb2},{0xa6,0xdd},{0x00,0x00},{0xaa,0xd8},{0xd0,0x68},
    {0xaf,0xe6},{0xd3,0x70},{0xb2,0xea},{0x00,0x00},{0xdb,0x57},
    {0xb8,0xa4},{0x8a,0x77},{0xbb,0x50},{0xbf,0xb3},{0xc1,0x7c},
    {0xc2,0xc2},{0xf4,0xb5},{0xa6,0xde},{0xaa,0xd9},{0x92,0xd6},
    {0x00,0x00},{0xaf,0xe7},{0xd7,0x52},{0xb5,0xce},{0x00,0x00},
    {0xbb,0x51},{0xe3,0xab},{0xe7,0x45},{0x93,0xc6},{0x95,0xec},
    {0x00,0x00},{0xfd,0x43},{0xa6,0xdf},{0xb5,0xcf},{0xdf,0xa3},
    {0xbb,0x52},{0xa6,0xe0},{0xcd,0xb1},{0xd0,0x69},{0xad,0x51},
    {0x8f,0xc2},{0x00,0x00},{0xd3,0x72},{0xfb,0x53},{0x00,0x00},
    {0xaf,0xea},{0xfe,0xf8},{0xaf,0xe8},{0xaf,0xe9},{0xaf,0xeb},
    {0xfe,0xf9},{0xfe,0xfa},{0xd3,0x71},{0x8c,0x4c},{0x89,0x56},
    {0xd7,0x57},{0xd7,0x54},{0xd7,0x56},{0xb2,0xeb},{0xb2,0xed},
    {0xb2,0xec},{0xd7,0x53},{0xb2,0xee},{0xd7,0x55},{0x90,0x5b},
    {0xdb,0x58},{0xdb,0x59},{0xfe,0xfb},{0xdb,0x5a},{0xdf,0xa6},
    {0x00,0x00},{0xdf,0xa7},{0x00,0x00},{0xdf,0xa5},{0xdf,0xa8},
    {0x00,0x00},{0xb8,0xa5},{0x00,0x00},{0xdf,0xa4},{0x00,0x00},
    {0xbb,0x53},{0x00,0x00},{0x00,0x00},{0xe7,0x4a},{0xe7,0x46},
    {0xe7,0x49},{0xe7,0x4b},{0xe7,0x48},{0xe7,0x47},{0x9f,0xbe},
    {0xea,0xf5},{0xea,0xf6},{0xea,0xf7},{0xbf,0xb4},{0xbf,0xb5},
    {0xed,0xf1},{0xed,0xf0},{0xed,0xf2},{0x94,0xc8},{0xf0,0xa3},
    {0xf0,0xa2},{0x00,0x00},{0xf2,0xc4},{0xfe,0xfc},{0xf2,0xc5},
    {0xf2,0xc3},{0x9f,0xbf},{0xc4,0xa5},{0x00,0x00},{0xf4,0xb6},
    {0xf4,0xb7},{0xfe,0xfd},{0xf7,0x46},{0xf7,0xef},{0xf8,0xbb},
    {0xa6,0xe1},{0xa8,0x7d},{0x8a,0x5c},{0xc1,0x7d},{0xa6,0xe2},
    {0x8d,0x5b},{0xd7,0x58},{0xdb,0x5b},{0x82,0x45},{0xc6,0x41},
    {0xca,0x4a},{0x9c,0xd2},{0x8b,0xb7},{0x9f,0xc0},{0xca,0x4b},
    {0xca,0x4d},{0xa6,0xe3},{0xca,0x4e},{0xca,0x4c},{0x00,0x00},
    {0x85,0xeb},{0xcb,0xa2},{0xcb,0xa3},{0xcb,0x7b},{0x00,0x00},
    {0x9f,0xc1},{0xfe,0xfe},{0x00,0x00},{0xcb,0xa1},{0xa8,0xa1},
    {0x00,0x00},{0xa8,0xa2},{0xcb,0x7c},{0xcb,0x7a},{0xcb,0x79},
    {0xcb,0x7d},{0xa8,0x7e},{0xcb,0x7e},{0xd0,0x6a},{0x00,0x00},
    {0x00,0x00},{0x8e,0xf6},{0xcd,0xb6},{0xaa,0xdc},{0xcd,0xb5},
    {0xcd,0xb7},{0x89,0x59},{0xaa,0xdb},{0xcd,0xbc},{0xaa,0xdf},
    {0xcd,0xb2},{0xcd,0xc0},{0xcd,0xc6},{0xaa,0xe6},{0xcd,0xc3},
    {0xaa,0xe3},{0x8c,0x4f},{0xcd,0xb9},{0xcd,0xbf},{0xcd,0xc1},
    {0xfb,0xa5},{0xcd,0xb4},{0xaa,0xe2},{0xaa,0xdd},{0xcd,0xba},
    {0xaa,0xe4},{0xaa,0xe7},{0xaa,0xe1},{0x00,0x00},{0xaa,0xda},
    {0xcd,0xbe},{0xcd,0xb8},{0xcd,0xc5},{0xaa,0xe9},{0xaa,0xe5},
    {0xaa,0xe0},{0xcd,0xbd},{0xaf,0xec},{0xcd,0xbb},{0xaa,0xde},
    {0xaa,0xe8},{0x9f,0xc2},{0xcd,0xb3},{0x8e,0xca},{0xcd,0xc2},
    {0xcd,0xc4},{0x96,0xbe},{0x91,0x40},{0x00,0x00},{0x85,0xfb},
    {0x8f,0xe1},{0x00,0x00},{0x91,0x41},{0x84,0x79},{0x85,0x51},
    {0x87,0x4b},{0x83,0x78},{0x84,0xf7},{0xfd,0x5f},{0xad,0x62},
    {0xad,0x5c},{0xad,0x64},{0xad,0x61},{0xd0,0x71},{0xd0,0x74},
    {0xad,0x5d},{0x91,0x42},{0xd0,0x6b},{0x00,0x00},{0xad,0x56},
    {0xad,0x60},{0x00,0x00},{0xad,0x63},{0xad,0x65},{0xd0,0xa2},
    {0xd0,0x77},{0x9f,0xc3},{0xad,0x55},{0xd0,0xa1},{0xad,0x59},
    {0xad,0x57},{0xad,0x52},{0xd0,0x6f},{0x00,0x00},{0xd0,0x7e},
    {0xd0,0x73},{0xd0,0x76},{0xd0,0xa5},{0x9f,0xc4},{0xad,0x66},
    {0xd0,0x7d},{0xad,0x5e},{0xd0,0x78},{0xd0,0xa4},{0xd0,0x75},
    {0xd0,0x79},{0xd0,0x7c},{0x96,0xa3},{0x9f,0xc5},{0xd0,0x6d},
    {0xd0,0xa3},{0xd0,0x7b},{0x9f,0xc6},{0xfd,0x5d},{0xd0,0x6c},
    {0x9f,0xc7},{0xd0,0x70},{0xad,0x5f},{0xad,0x5a},{0xad,0x53},
    {0xad,0x58},{0xad,0x54},{0xad,0x67},{0xd0,0x6e},{0xd3,0xa5},
    {0xad,0x5b},{0x00,0x00},{0x9f,0xc8},{0xd0,0x7a},{0xce,0x41},
    {0x92,0xa7},{0x8f,0xe0},{0x00,0x00},{0x8e,0xc9},{0x00,0x00},
    {0x00,0x00},{0x85,0xc3},{0x8e,0x46},{0xd3,0xa8},{0xaf,0xfa},
    {0x91,0x43},{0xd3,0x76},{0x91,0x44},{0xd3,0xa3},{0xd3,0x7d},
    {0x9f,0xc9},{0xd3,0xb2},{0x00,0x00},{0xd3,0xaa},{0x00,0x00},
    {0xd3,0x7e},{0x91,0x45},{0xd3,0xa9},{0xd3,0x78},{0xd3,0x7c},
    {0xd3,0xb5},{0xaf,0xfd},{0xd3,0xad},{0xd3,0xa4},{0xaf,0xed},
    {0xd3,0xb3},{0xd3,0x74},{0x00,0x00},{0xd3,0xac},{0x00,0x00},
    {0xaf,0xfc},{0xaf,0xf7},{0xd3,0x73},{0xaf,0xf5},{0xaf,0xf4},
    {0xaf,0xf9},{0xd3,0xab},{0xaf,0xf1},{0xaf,0xf8},{0xd0,0x72},
    {0xdb,0x5c},{0xd3,0xa6},{0x9f,0xca},{0x00,0x00},{0xd3,0x7a},
    {0xaf,0xfb},{0xd3,0x7b},{0xd3,0xa1},{0xaf,0xfe},{0xd3,0x75},
    {0xd3,0xaf},{0x91,0x46},{0xd3,0xae},{0xd3,0xb6},{0xaf,0xf3},
    {0xaf,0xf0},{0xd3,0xb4},{0xd3,0xb0},{0xd3,0xa7},{0xd3,0xa2},
    {0xaf,0xf6},{0xaf,0xf2},{0xd3,0x77},{0xaf,0xee},{0xd3,0xb1},
    {0xaf,0xef},{0x00,0x00},{0xd3,0x79},{0x9f,0xcb},{0x93,0x54},
    {0x00,0x00},{0x84,0x75},{0x91,0x47},{0x8e,0xc7},{0x00,0x00},
    {0x8e,0xf4},{0x8f,0x5f},{0x8a,0xf9},{0x89,0x57},{0x91,0x48},
    {0x86,0xd1},{0x85,0xfa},{0x8e,0x73},{0x86,0xe1},{0x86,0xdf},
    {0x8e,0xf2},{0x8f,0x7b},{0x87,0x4a},{0x88,0x51},{0x91,0x49},
    {0x8e,0x4d},{0x91,0x4a},{0x8b,0xb9},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0xd7,0x5e},{0xd7,0x60},{0xd7,0x65},{0xd7,0x79},
    {0xb2,0xfc},{0xb2,0xf2},{0x00,0x00},{0xd7,0x5d},{0xb2,0xfd},
    {0xb2,0xfe},{0xd7,0x68},{0xd7,0x6f},{0xd7,0x75},{0x00,0x00},
    {0xd7,0x62},{0x00,0x00},{0xd7,0x69},{0x00,0x00},{0x87,0x48},
    {0xb3,0x40},{0xd7,0x77},{0xd7,0x72},{0xb2,0xfa},{0xb2,0xf8},
    {0xd7,0x6e},{0xd7,0x6a},{0xd7,0x5c},{0xb2,0xef},{0xd7,0x61},
    {0xd7,0x59},{0x9f,0xcc},{0xb2,0xf7},{0xb2,0xf9},{0xd7,0x66},
    {0xd7,0x63},{0xb2,0xf4},{0xd7,0x73},{0xb2,0xf1},{0xd7,0x64},
    {0xd7,0x7a},{0xd7,0x6c},{0x91,0x4b},{0xd7,0x6b},{0xb2,0xf0},
    {0x91,0x4c},{0xb2,0xfb},{0x00,0x00},{0xb2,0xf3},{0xd7,0x5a},
    {0xd7,0x5f},{0xd7,0x70},{0xd7,0x76},{0xb3,0x41},{0xd7,0x5b},
    {0xd7,0x67},{0xd7,0x6d},{0xb2,0xf6},{0x9f,0xcd},{0x00,0x00},
    {0xd7,0x78},{0xd7,0x71},{0xd7,0x74},{0x85,0x50},{0x88,0x50},
    {0x8e,0x7d},{0x85,0xfd},{0x91,0x4d},{0x8f,0x60},{0x89,0xf7},
    {0x8e,0xf5},{0x87,0xf3},{0x8c,0xc2},{0x00,0x00},{0x91,0x4e},
    {0xb2,0xf5},{0xfb,0xad},{0xdb,0x6c},{0xdb,0x60},{0xb5,0xd7},
    {0xdb,0x7d},{0xdb,0xa7},{0xdb,0xaa},{0xb5,0xd5},{0xdb,0x68},
    {0xdb,0xa3},{0xdb,0x69},{0xdb,0x77},{0xb5,0xe2},{0xdb,0x73},
    {0xb5,0xdf},{0x9f,0xce},{0xdb,0x74},{0xdb,0x5d},{0x00,0x00},
    {0xdb,0xa4},{0x00,0x00},{0xfe,0x52},{0xb5,0xe8},{0xdb,0xa1},
    {0xdb,0x75},{0xdb,0xac},{0xdb,0x70},{0xdf,0xc8},{0x00,0x00},
    {0xdb,0xaf},{0xb5,0xe6},{0xdb,0x6e},{0xdb,0x7a},{0xb5,0xe9},
    {0xb5,0xd4},{0xdb,0x72},{0xdb,0xad},{0xdb,0x6b},{0xdb,0x64},
    {0xdb,0x6f},{0x00,0x00},{0xdb,0x63},{0xdb,0x61},{0xb5,0xd0},
    {0xdb,0xa5},{0xdb,0x6a},{0xdb,0xa8},{0x9f,0xcf},{0xdb,0xa9},
    {0xb5,0xd8},{0xb5,0xdd},{0xb5,0xd9},{0xb5,0xe1},{0xdb,0x7e},
    {0xb5,0xda},{0xdb,0x76},{0xdb,0x66},{0x91,0x4f},{0xb5,0xd2},
    {0xdb,0x5e},{0xdb,0xa2},{0xdb,0xab},{0xdb,0x65},{0xb5,0xe0},
    {0xdb,0xb0},{0xdb,0x71},{0x00,0x00},{0xdb,0x6d},{0x00,0x00},
    {0xb5,0xd1},{0xb5,0xe5},{0x9f,0xd0},{0xdb,0x7c},{0xb5,0xe7},
    {0x00,0x00},{0xdb,0x78},{0xb5,0xdc},{0xb5,0xd6},{0xb5,0xde},
    {0xb5,0xd3},{0xb5,0xe4},{0xdb,0x79},{0xdb,0x67},{0xdb,0x7b},
    {0xdb,0x62},{0xdb,0xa6},{0x9f,0xd1},{0x00,0x00},{0x9f,0xd2},
    {0x00,0x00},{0x96,0xa7},{0x00,0x00},{0x00,0x00},{0xdb,0xae},
    {0x96,0xbd},{0x8c,0xfd},{0x00,0x00},{0x00,0x00},{0xfd,0x63},
    {0x9f,0xd3},{0x94,0xc9},{0xdb,0x5f},{0x89,0x5b},{0x89,0xf1},
    {0x89,0x4d},{0x89,0x58},{0x8a,0xf7},{0xdf,0xc7},{0x91,0x50},
    {0xdf,0xdd},{0xb8,0x55},{0xdf,0xcc},{0x9f,0xd4},{0xdf,0xca},
    {0xdf,0xb5},{0xb8,0xa9},{0xdf,0xc5},{0xdf,0xd9},{0xdf,0xc1},
    {0xb8,0xb1},{0xdf,0xd8},{0xdf,0xbf},{0xb5,0xe3},{0xdf,0xcf},
    {0xdf,0xc0},{0xdf,0xd6},{0xb8,0xb0},{0xb8,0xa8},{0x9f,0xd5},
    {0xdf,0xaa},{0xdf,0xb2},{0x00,0x00},{0xdf,0xcb},{0xdf,0xc3},
    {0xdf,0xdc},{0xdf,0xc6},{0xb8,0xb6},{0xdf,0xd7},{0x91,0x51},
    {0xb8,0xad},{0x9f,0xd6},{0xdf,0xc9},{0xdf,0xd1},{0xdf,0xb6},
    {0xdf,0xd0},{0x00,0x00},{0xdf,0xe1},{0xdf,0xb1},{0xdf,0xd2},
    {0x9f,0xd7},{0xdf,0xdf},{0x9f,0xd8},{0xdf,0xab},{0xb5,0xdb},
    {0x9f,0xd9},{0xdf,0xb9},{0xdf,0xb8},{0xb8,0xaf},{0x91,0x52},
    {0xdf,0xbc},{0xdf,0xbe},{0xdf,0xcd},{0xdf,0xde},{0xb8,0xb2},
    {0x91,0x53},{0xb8,0xb3},{0x9f,0xda},{0xdf,0xb0},{0xb8,0xab},
    {0xdf,0xb4},{0xdf,0xda},{0xb8,0xb4},{0x00,0x00},{0xb8,0xac},
    {0xb8,0xae},{0xb8,0xb5},{0xdf,0xe0},{0xdf,0xd3},{0xdf,0xce},
    {0x95,0xf5},{0x9f,0xdb},{0xdf,0xbb},{0xdf,0xba},{0xb8,0xaa},
    {0xdf,0xac},{0xb8,0xa7},{0xdf,0xc4},{0xdf,0xad},{0xdf,0xc2},
    {0x96,0xc0},{0x00,0x00},{0xdf,0xb7},{0xdf,0xdb},{0x9f,0xdc},
    {0x9f,0xdd},{0x00,0x00},{0xb8,0xa6},{0x00,0x00},{0x91,0x54},
    {0x00,0x00},{0xdf,0xb3},{0x8e,0xf1},{0x91,0x55},{0x8e,0xf3},
    {0x00,0x00},{0x88,0x52},{0x8e,0xc8},{0xdf,0xaf},{0xdf,0xd5},
    {0xdf,0xae},{0xbb,0x60},{0xe3,0xd3},{0x9f,0xde},{0x9f,0xdf},
    {0xe3,0xc2},{0x00,0x00},{0x9f,0xe0},{0xe3,0xac},{0xe3,0xca},
    {0xbb,0x58},{0xe3,0xbb},{0xe3,0xc5},{0xbb,0x5b},{0xe3,0xbe},
    {0xbb,0x59},{0xe3,0xaf},{0xe3,0xcd},{0xe3,0xae},{0xe3,0xc1},
    {0x9f,0xe1},{0xe3,0xad},{0x00,0x00},{0x00,0x00},{0xe3,0xbf},
    {0xe3,0xc8},{0xe3,0xc6},{0xe3,0xba},{0xe3,0xb5},{0xe3,0xb3},
    {0xfd,0x66},{0xe3,0xb4},{0xe3,0xc7},{0xe3,0xd2},{0xe3,0xbc},
    {0xbb,0x5a},{0x00,0x00},{0xe3,0xb7},{0x00,0x00},{0xe3,0xcb},
    {0x00,0x00},{0xbb,0x5d},{0xe3,0xb6},{0xe3,0xb0},{0xe3,0xc0},
    {0xbb,0x61},{0x96,0xbc},{0x9f,0xe2},{0xbb,0x55},{0xbb,0x5e},
    {0xe3,0xb8},{0xe3,0xb2},{0x00,0x00},{0xbb,0x57},{0xdf,0xd4},
    {0xbb,0x56},{0xe3,0xc3},{0x00,0x00},{0xbb,0x54},{0xbb,0x63},
    {0xbb,0x5c},{0xe3,0xc4},{0xe3,0xb9},{0xe3,0xb1},{0xe3,0xcc},
    {0xe3,0xbd},{0xbb,0x62},{0xe3,0xd0},{0xbb,0x5f},{0xe3,0xcf},
    {0x00,0x00},{0xe3,0xc9},{0xe3,0xce},{0x00,0x00},{0x94,0xca},
    {0xfd,0x65},{0xe3,0xd1},{0x91,0x56},{0x8a,0xf8},{0x9f,0xe3},
    {0x8a,0x5e},{0x90,0x6c},{0x9f,0xe4},{0x9f,0xe5},{0x91,0x57},
    {0x9f,0xe6},{0x8f,0xaa},{0x8c,0xbd},{0xe7,0x73},{0xe7,0x74},
    {0xe7,0x67},{0xe7,0x66},{0xe7,0x62},{0xbd,0xb4},{0x00,0x00},
    {0xbd,0xac},{0xe7,0x76},{0xe7,0x75},{0xdf,0xa9},{0xe7,0x5f},
    {0xe7,0x63},{0xe7,0x5d},{0x00,0x00},{0xe7,0x70},{0xe7,0x61},
    {0x9f,0xe7},{0xe7,0x77},{0xe7,0x5a},{0xe7,0x58},{0xe7,0x64},
    {0xe7,0x6e},{0xe7,0x69},{0xbd,0xb6},{0xe7,0x4f},{0x00,0x00},
    {0xe7,0x6d},{0x9f,0xe8},{0x00,0x00},{0x9f,0xe9},{0xbd,0xb7},
    {0xdf,0xbd},{0xe7,0x5b},{0xe7,0x52},{0xe7,0x55},{0xe7,0x7b},
    {0xe7,0x5c},{0xe7,0x53},{0xe7,0x51},{0xe7,0x4e},{0x9f,0xea},
    {0xbd,0xb0},{0xe7,0x65},{0xbd,0xaf},{0xbd,0xb3},{0xe7,0x60},
    {0xe7,0x68},{0xbd,0xa9},{0xe7,0x78},{0xe7,0x7c},{0xbd,0xab},
    {0x00,0x00},{0xe7,0x57},{0xe7,0x6b},{0xe7,0x6f},{0xe7,0x54},
    {0xe7,0x79},{0xbd,0xb2},{0x00,0x00},{0xbd,0xb1},{0xe7,0x4c},
    {0xbd,0xb5},{0xe7,0x72},{0xe7,0x56},{0xe7,0x6a},{0xe7,0x50},
    {0xe7,0x5e},{0xe7,0x59},{0xbd,0xad},{0xbd,0xae},{0xe7,0x6c},
    {0xe7,0x7d},{0xe7,0x7a},{0xe7,0x71},{0x00,0x00},{0x9f,0xeb},
    {0xfe,0x4c},{0x93,0x60},{0x00,0x00},{0x8a,0x5d},{0x91,0x58},
    {0x90,0x46},{0x8c,0x4e},{0xe7,0x4d},{0x8c,0x4d},{0xbd,0xaa},
    {0xeb,0x49},{0x00,0x00},{0xeb,0x40},{0xeb,0x43},{0x9f,0xed},
    {0xbf,0xbb},{0xeb,0x45},{0xea,0xf9},{0xeb,0x41},{0xeb,0x47},
    {0xbf,0xb8},{0xbf,0xbc},{0xbf,0xb6},{0xfd,0x68},{0x9f,0xee},
    {0xea,0xfb},{0xeb,0x4c},{0x00,0x00},{0x00,0x00},{0xeb,0x46},
    {0x9f,0xef},{0xea,0xfc},{0xeb,0x55},{0xeb,0x4f},{0xea,0xf8},
    {0xee,0x46},{0xea,0xfe},{0xbf,0xb7},{0x91,0x59},{0xeb,0x4a},
    {0x00,0x00},{0xeb,0x54},{0xbf,0xbf},{0x9f,0xf0},{0xeb,0x51},
    {0xea,0xfd},{0xeb,0x44},{0xeb,0x48},{0xeb,0x42},{0xeb,0x56},
    {0xeb,0x53},{0xeb,0x50},{0xbf,0xb9},{0xbf,0xba},{0xbf,0xbe},
    {0xea,0xfa},{0xeb,0x57},{0xbf,0xbd},{0xeb,0x4d},{0x9f,0xf1},
    {0x9f,0xf2},{0xeb,0x4b},{0x8f,0xe2},{0x9f,0xf3},{0x8c,0x51},
    {0xeb,0x4e},{0xee,0x53},{0xee,0x40},{0xee,0x45},{0xee,0x52},
    {0xee,0x44},{0xed,0xfb},{0xee,0x41},{0x00,0x00},{0xc1,0xa2},
    {0x00,0x00},{0xed,0xf4},{0xee,0x4d},{0xee,0x4f},{0xed,0xf3},
    {0xc1,0xa1},{0xee,0x51},{0xee,0x49},{0xc1,0xa8},{0xee,0x50},
    {0xee,0x42},{0xc1,0xaa},{0xed,0xf9},{0xeb,0x52},{0xee,0x4a},
    {0xee,0x47},{0xed,0xf5},{0xee,0x55},{0xc1,0xa4},{0x00,0x00},
    {0x9d,0x76},{0xc1,0xa5},{0xed,0xf7},{0xee,0x48},{0x91,0x5a},
    {0xee,0x54},{0xee,0x4b},{0xed,0xfd},{0xc1,0xa7},{0xc1,0xa3},
    {0xee,0x4c},{0xed,0xfe},{0xee,0x56},{0xed,0xf8},{0xee,0x43},
    {0xee,0x4e},{0xed,0xfa},{0xed,0xfc},{0x00,0x00},{0xc2,0xcb},
    {0xed,0xf6},{0xc1,0xa9},{0xc2,0xc4},{0xc1,0x7e},{0x91,0x5b},
    {0x93,0xd6},{0x00,0x00},{0x82,0x7e},{0xc1,0xa6},{0xc2,0xc8},
    {0xf0,0xb3},{0x00,0x00},{0xf0,0xa9},{0xf0,0xa4},{0xf0,0xaa},
    {0xf0,0xb4},{0xf0,0xb8},{0xf0,0xb7},{0xc2,0xca},{0xc2,0xc9},
    {0x00,0x00},{0x00,0x00},{0xf0,0xab},{0xf0,0xb9},{0xf0,0xae},
    {0xf0,0xa6},{0x91,0x5c},{0xf0,0xa8},{0xf0,0xa7},{0xf0,0xad},
    {0xf0,0xb2},{0xf0,0xa5},{0xf0,0xac},{0xf0,0xb1},{0xc2,0xc7},
    {0x00,0x00},{0xf0,0xaf},{0x00,0x00},{0xc2,0xc5},{0xf0,0xb0},
    {0xc2,0xc3},{0xc2,0xc6},{0xf2,0xd5},{0xf0,0xb5},{0x8c,0xa4},
    {0x00,0x00},{0xc3,0xc2},{0x9f,0xf4},{0xf2,0xcd},{0xf2,0xd1},
    {0xf2,0xc9},{0xf2,0xcc},{0x00,0x00},{0xf2,0xd4},{0xc3,0xc0},
    {0xf2,0xd9},{0xf2,0xd2},{0x9f,0xf5},{0xf2,0xca},{0xf2,0xda},
    {0xf2,0xd3},{0xc3,0xc3},{0xc3,0xc4},{0xf2,0xd7},{0x00,0x00},
    {0xf2,0xcb},{0xc3,0xbf},{0xc3,0xc1},{0xf2,0xc6},{0xf2,0xce},
    {0xf2,0xc8},{0x9f,0xf6},{0xf2,0xd8},{0xf2,0xd6},{0xf2,0xc7},
    {0xf2,0xcf},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0xf4,0xbe},
    {0xc3,0xc5},{0xf2,0xd0},{0xc4,0xa7},{0xc4,0xa9},{0xc4,0xa6},
    {0x9f,0xf7},{0xf4,0xc3},{0xf4,0xbb},{0xf4,0xb9},{0xf4,0xbd},
    {0xf4,0xba},{0xfd,0x6a},{0x00,0x00},{0xf4,0xbf},{0xf4,0xc1},
    {0xc4,0xaa},{0xc4,0xac},{0x00,0x00},{0xf4,0xc0},{0xc4,0xad},
    {0xc4,0xab},{0xf4,0xc2},{0x9f,0xf8},{0x00,0x00},{0x9f,0xf9},
    {0xfd,0x6b},{0xc4,0xa8},{0x00,0x00},{0x91,0x5d},{0x9f,0xfa},
    {0x00,0x00},{0x91,0x5e},{0xc4,0xf4},{0xf5,0xf1},{0xf5,0xf7},
    {0xc4,0xf6},{0xf4,0xbc},{0xf5,0xf6},{0x00,0x00},{0xf5,0xfd},
    {0xf5,0xf4},{0xf5,0xfb},{0xf5,0xfa},{0xf4,0xb8},{0xf5,0xf5},
    {0xf0,0xb6},{0xf5,0xfe},{0xf5,0xf3},{0xf5,0xf8},{0x9f,0xfb},
    {0xf5,0xfc},{0xf5,0xf2},{0x00,0x00},{0xf7,0x4a},{0xc4,0xf5},
    {0xf5,0xf9},{0xfb,0xae},{0x94,0xcb},{0xf7,0xf4},{0xf7,0x4b},
    {0xf7,0x49},{0xf7,0x47},{0xf7,0x48},{0xf7,0x4c},{0x00,0x00},
    {0xc5,0xd9},{0xf7,0xf2},{0xf7,0xf0},{0xf7,0xf5},{0xf7,0xf3},
    {0x00,0x00},{0xf7,0xf6},{0xc5,0xda},{0xf7,0xf1},{0x00,0x00},
    {0x9f,0xfc},{0xf8,0xbc},{0x00,0x00},{0x9f,0xfd},{0xf9,0x45},
    {0xf9,0x46},{0xf9,0x47},{0x00,0x00},{0x00,0x00},{0xf9,0xc7},
    {0xf9,0xbd},{0xca,0x4f},{0xaa,0xea},{0x86,0x40},{0xad,0x68},
    {0x87,0xcb},{0xd3,0xb8},{0xd3,0xb7},{0xb0,0x40},{0xb3,0x42},
    {0xd7,0x7c},{0x00,0x00},{0x00,0x00},{0xd7,0x7b},{0x85,0x52},
    {0xb5,0xea},{0xb8,0xb8},{0x00,0x00},{0xb8,0xb7},{0xb8,0xb9},
    {0x00,0x00},{0xe3,0xd4},{0xe7,0x7e},{0xeb,0x58},{0xeb,0x5a},
    {0xeb,0x59},{0x00,0x00},{0xc1,0xab},{0xee,0x57},{0xf0,0xba},
    {0xf9,0xa5},{0xa6,0xe4},{0x95,0x78},{0xcd,0xc9},{0xcd,0xca},
    {0xcd,0xc8},{0xcd,0xc7},{0xaa,0xeb},{0x9f,0xfe},{0xd0,0xa9},
    {0xd0,0xa7},{0x00,0x00},{0x00,0x00},{0xd0,0xa6},{0x00,0x00},
    {0xad,0x69},{0xad,0x6b},{0xad,0x6a},{0xd0,0xa8},{0x8a,0xaf},
    {0x88,0x53},{0x8f,0xc4},{0x87,0x4c},{0x8b,0xba},{0x89,0x5a},
    {0x00,0x00},{0x00,0x00},{0xd3,0xc4},{0xd3,0xc1},{0xd3,0xbf},
    {0x00,0x00},{0x00,0x00},{0xb0,0x41},{0xd3,0xc2},{0xb0,0x46},
    {0xd3,0xbc},{0xd3,0xcb},{0x00,0x00},{0xd3,0xcd},{0xd3,0xbd},
    {0xfe,0xbb},{0xb0,0x43},{0xd3,0xce},{0xd3,0xc9},{0xd3,0xbb},
    {0xd3,0xc0},{0xd3,0xca},{0xd3,0xc6},{0xd3,0xc3},{0x00,0x00},
    {0xb0,0x48},{0xd3,0xcc},{0xd3,0xbe},{0x00,0x00},{0xfe,0xbc},
    {0xd3,0xc7},{0xd3,0xb9},{0xb0,0x47},{0xb0,0x44},{0xd3,0xc5},
    {0x00,0x00},{0xd3,0xc8},{0xd3,0xba},{0xb0,0x45},{0xb0,0x42},
    {0x94,0xcc},{0x86,0x43},{0xfe,0xbd},{0x00,0x00},{0xb3,0x4c},
    {0xd7,0xa5},{0xb3,0x4b},{0xfe,0xbe},{0xd7,0xa8},{0xd7,0xab},
    {0xb3,0x48},{0xb3,0x46},{0xd7,0x7e},{0xd7,0xa9},{0xd7,0xa7},
    {0xd7,0xa4},{0xd7,0xac},{0xd7,0xad},{0xd7,0xaf},{0xd7,0xb0},
    {0xd7,0x7d},{0xb3,0x45},{0xd7,0xa2},{0xd7,0xa1},{0xd7,0xae},
    {0xb3,0x47},{0xd7,0xa3},{0xb3,0x49},{0xb3,0x44},{0xd7,0xa6},
    {0xb3,0x4d},{0x8c,0xfe},{0xb3,0x4a},{0xd7,0xaa},{0x92,0xac},
    {0x82,0x4c},{0x8f,0xc3},{0xb5,0xf1},{0xdb,0xbf},{0x00,0x00},
    {0xdb,0xb4},{0xb5,0xee},{0x00,0x00},{0xdf,0xe7},{0xdb,0xbd},
    {0xdb,0xb1},{0xb5,0xec},{0xdb,0xb6},{0xb5,0xef},{0xdb,0xba},
    {0xdb,0xb8},{0xb5,0xf2},{0xb5,0xeb},{0x00,0x00},{0x00,0x00},
    {0xdb,0xb2},{0xdb,0xb5},{0xb5,0xf0},{0x00,0x00},{0xdb,0xb3},
    {0x00,0x00},{0xdb,0xbe},{0xdb,0xbc},{0xdb,0xb7},{0xdb,0xb9},
    {0xdb,0xbb},{0xb5,0xed},{0x8d,0x72},{0x94,0xcd},{0x8f,0x61},
    {0x8e,0x4e},{0x8a,0xfa},{0x8e,0xf7},{0x8f,0xe3},{0xdf,0xe8},
    {0xdf,0xee},{0xdf,0xe4},{0xdf,0xea},{0xb8,0xba},{0xdf,0xe6},
    {0xb8,0xc0},{0x00,0x00},{0x00,0x00},{0xb8,0xbf},{0x00,0x00},
    {0xb8,0xbe},{0xdf,0xed},{0xb8,0xc1},{0xb8,0xc2},{0xdf,0xe3},
    {0xdf,0xf0},{0xb8,0xc3},{0xb8,0xbd},{0xb8,0xbc},{0xdf,0xec},
    {0xb8,0xc4},{0xdf,0xe2},{0xdf,0xe5},{0xdf,0xef},{0xdf,0xeb},
    {0x00,0x00},{0x00,0x00},{0xe3,0xf4},{0xe3,0xe9},{0xb8,0xbb},
    {0x00,0x00},{0x91,0x60},{0x00,0x00},{0x88,0x54},{0xbb,0x6a},
    {0xe3,0xdd},{0xe3,0xf2},{0xe3,0xde},{0xbb,0x65},{0x00,0x00},
    {0xe3,0xdb},{0x00,0x00},{0xe3,0xe4},{0xe3,0xdc},{0xbb,0x67},
    {0xe3,0xd6},{0xe3,0xf1},{0xbb,0x68},{0xe3,0xee},{0xe3,0xef},
    {0xe3,0xd7},{0xbb,0x6d},{0xe3,0xe6},{0x00,0x00},{0xe3,0xe0},
    {0xe3,0xe7},{0xe3,0xda},{0x00,0x00},{0xe3,0xf3},{0xe3,0xeb},
    {0xe3,0xe5},{0xe3,0xd5},{0xbb,0x69},{0xe3,0xec},{0x00,0x00},
    {0xbb,0x6c},{0xe3,0xf0},{0x00,0x00},{0xe3,0xea},{0xbb,0x66},
    {0xe3,0xe8},{0x00,0x00},{0xe3,0xe2},{0xbb,0x64},{0xe3,0xd9},
    {0xe3,0xe1},{0xe3,0xed},{0xe3,0xdf},{0x00,0x00},{0x00,0x00},
    {0xe3,0xe3},{0x8b,0xbb},{0x8a,0x61},{0x8a,0xfb},{0x00,0x00},
    {0x82,0xa2},{0xbd,0xc1},{0xdf,0xe9},{0xe7,0xb2},{0xe7,0xbb},
    {0xe7,0xb1},{0xe7,0xad},{0xe7,0xaa},{0xbd,0xc2},{0xe7,0xa8},
    {0xbb,0x6b},{0xe7,0xa1},{0xbd,0xc0},{0xe7,0xa7},{0xbd,0xbf},
    {0xe7,0xac},{0xe7,0xa9},{0xe7,0xb9},{0xe7,0xb4},{0xe7,0xae},
    {0xe7,0xb3},{0xbd,0xbb},{0xe7,0xab},{0xe7,0xbe},{0xe7,0xa2},
    {0xe7,0xa3},{0xe7,0xba},{0xbd,0xbc},{0xe7,0xbf},{0xbd,0xbe},
    {0xe7,0xc0},{0xe7,0xb0},{0xe3,0xd8},{0xe7,0xb6},{0xe7,0xaf},
    {0xe7,0xb8},{0xe7,0xb5},{0x91,0x61},{0xfd,0x45},{0x00,0x00},
    {0xe7,0xa6},{0xbd,0xb9},{0xe7,0xbd},{0xbd,0xba},{0xe7,0xa4},
    {0xbd,0xbd},{0xeb,0x64},{0xe7,0xb7},{0xe7,0xbc},{0x8a,0x60},
    {0x91,0x62},{0x8f,0xe4},{0x82,0x75},{0x00,0x00},{0xeb,0x61},
    {0xbd,0xb8},{0xbf,0xc0},{0xeb,0x6b},{0xeb,0x67},{0xfb,0x6c},
    {0xeb,0x65},{0xeb,0x60},{0xeb,0x6f},{0x00,0x00},{0x91,0x63},
    {0xfd,0x47},{0xbf,0xc4},{0x00,0x00},{0xeb,0x5c},{0xeb,0x68},
    {0xeb,0x69},{0xeb,0x5f},{0xeb,0x5e},{0xeb,0x6c},{0x00,0x00},
    {0xeb,0x62},{0xeb,0x5d},{0xeb,0x63},{0x00,0x00},{0xeb,0x6e},
    {0xeb,0x5b},{0xeb,0x6d},{0xeb,0x6a},{0xbf,0xc2},{0xbf,0xc1},
    {0x00,0x00},{0x00,0x00},{0xbf,0xc3},{0xeb,0x66},{0xf0,0xcb},
    {0xfe,0xbf},{0x00,0x00},{0x00,0x00},{0x91,0x64},{0xfd,0x46},
    {0xee,0x59},{0xc1,0xb1},{0xee,0x5d},{0xee,0x5a},{0xee,0x61},
    {0xee,0x67},{0xee,0x5c},{0xfe,0xc0},{0xee,0x70},{0xc1,0xae},
    {0xee,0x6a},{0xee,0x5f},{0xee,0x6b},{0xee,0x66},{0xee,0x6d},
    {0xee,0x5e},{0xc1,0xb3},{0xc1,0xb2},{0xee,0x60},{0xee,0x6e},
    {0xee,0x58},{0xee,0x6c},{0xc1,0xac},{0xfd,0x49},{0xee,0x64},
    {0xee,0x63},{0xee,0x68},{0xee,0x5b},{0xc1,0xb0},{0x91,0x65},
    {0xc1,0xb4},{0xee,0x62},{0xee,0x69},{0xc1,0xb5},{0xee,0x65},
    {0x00,0x00},{0x96,0xc7},{0x00,0x00},{0x91,0x66},{0xc1,0xad},
    {0xc1,0xaf},{0xf0,0xc7},{0xf0,0xc5},{0x00,0x00},{0xfd,0x4c},
    {0xf0,0xcc},{0xf0,0xc9},{0xf0,0xcd},{0xfe,0xc5},{0xf0,0xbe},
    {0xf0,0xc6},{0xf0,0xd1},{0xee,0x6f},{0xf0,0xc2},{0xc2,0xcf},
    {0xe7,0xa5},{0xf0,0xbd},{0xf0,0xca},{0xf0,0xc4},{0xf0,0xc1},
    {0xf0,0xbc},{0xf0,0xbb},{0xf0,0xd0},{0x00,0x00},{0xf0,0xc0},
    {0xf0,0xbf},{0xc2,0xcd},{0xf0,0xc8},{0xfb,0xab},{0xc2,0xcc},
    {0x00,0x00},{0x00,0x00},{0xc2,0xce},{0xf0,0xc3},{0xf0,0xcf},
    {0xfd,0x4d},{0xf2,0xde},{0xf2,0xdf},{0x00,0x00},{0xc3,0xc9},
    {0xf2,0xdc},{0xc3,0xc6},{0xf2,0xe4},{0x00,0x00},{0xc3,0xca},
    {0xf2,0xe6},{0xf2,0xdb},{0xf0,0xce},{0xf2,0xe8},{0xf2,0xdd},
    {0xfb,0x72},{0xc3,0xc7},{0xf2,0xe3},{0x91,0x67},{0xf2,0xe5},
    {0xf2,0xe0},{0xf2,0xe7},{0xf2,0xe2},{0xf2,0xe1},{0xc3,0xc8},
    {0x91,0x68},{0xfd,0x4e},{0xf4,0xc5},{0xf4,0xc6},{0x00,0x00},
    {0xf4,0xc8},{0xc4,0xae},{0xc4,0xaf},{0xf4,0xc9},{0xf4,0xc7},
    {0xfd,0x4f},{0xf4,0xc4},{0x00,0x00},{0xf6,0x42},{0xf6,0x45},
    {0xf6,0x41},{0x00,0x00},{0xc4,0xfa},{0xf6,0x43},{0xc4,0xf9},
    {0xc4,0xf8},{0xc4,0xf7},{0xf6,0x44},{0xf7,0x51},{0xf7,0x4f},
    {0x91,0x69},{0xf7,0x4e},{0xf6,0x40},{0xf7,0x50},{0xf6,0x46},
    {0xf7,0x4d},{0xfd,0x50},{0xf7,0xf9},{0xf7,0xd7},{0xf7,0xf7},
    {0xc5,0xdb},{0xf7,0xf8},{0xf7,0xfa},{0x00,0x00},{0xf8,0xbf},
    {0xc5,0xfa},{0xf8,0xbe},{0xf8,0xbd},{0xc5,0xfb},{0x00,0x00},
    {0xc6,0x5a},{0xf9,0x6e},{0xf9,0xa7},{0xf9,0xa6},{0xf9,0xa8},
    {0xa6,0xe5},{0xd0,0xaa},{0xfd,0x51},{0xd3,0xcf},{0xd3,0xd0},
    {0x8d,0x75},{0x92,0xdb},{0x00,0x00},{0xdb,0xc0},{0x00,0x00},
    {0xf6,0x47},{0xf8,0xc0},{0xa6,0xe6},{0xad,0x6c},{0xd0,0xab},
    {0xfe,0xc6},{0x00,0x00},{0x00,0x00},{0xd7,0xb1},{0xb3,0x4e},
    {0x83,0xf5},{0xdb,0xc2},{0xdb,0xc1},{0xb5,0xf3},{0x00,0x00},
    {0xb8,0xc5},{0xe7,0xc1},{0xbd,0xc3},{0x00,0x00},{0xbd,0xc4},
    {0xfd,0x5b},{0x00,0x00},{0xfe,0xc7},{0xbf,0xc5},{0xc5,0xfc},
    {0xa6,0xe7},{0x91,0xd6},{0x86,0x44},{0x00,0x00},{0xd0,0xac},
    {0xaa,0xed},{0xd0,0xae},{0xd0,0xad},{0xad,0x6d},{0x8c,0xdc},
    {0xd3,0xd1},{0x84,0x7c},{0xd3,0xd8},{0xb0,0x49},{0xd3,0xd6},
    {0xd3,0xd4},{0x00,0x00},{0xd3,0xdb},{0xd3,0xd2},{0xd3,0xd3},
    {0xb0,0x4a},{0x00,0x00},{0xb0,0x4e},{0x00,0x00},{0x00,0x00},
    {0xd3,0xdc},{0xb0,0x4d},{0xd3,0xda},{0xd3,0xd7},{0xd3,0xd5},
    {0xb0,0x4b},{0xb0,0x4c},{0xd3,0xd9},{0x8b,0xbd},{0x88,0xd3},
    {0x00,0x00},{0xfe,0xc8},{0xb3,0x50},{0xd7,0xb2},{0x00,0x00},
    {0xb3,0x55},{0xd7,0xc2},{0xb3,0x54},{0xd7,0xc4},{0xfe,0xc9},
    {0xfe,0xca},{0xd7,0xb8},{0xb3,0x52},{0xd7,0xc3},{0x00,0x00},
    {0xd7,0xb3},{0xb3,0x53},{0xd7,0xbf},{0xd7,0xbb},{0xd7,0xbd},
    {0xd7,0xb7},{0xd7,0xbe},{0x90,0xba},{0x00,0x00},{0xb3,0x4f},
    {0xd7,0xba},{0xfd,0x56},{0xd7,0xb9},{0xd7,0xb5},{0x00,0x00},
    {0xd7,0xc0},{0x00,0x00},{0x00,0x00},{0xd7,0xbc},{0xd7,0xb4},
    {0x00,0x00},{0xd7,0xb6},{0xb3,0x51},{0xd7,0xc1},{0x8c,0xdb},
    {0x91,0x6a},{0x00,0x00},{0x94,0xce},{0xb5,0xf6},{0xdb,0xcd},
    {0x00,0x00},{0x95,0xdd},{0x91,0x6c},{0xdb,0xc9},{0xdb,0xcb},
    {0xdb,0xc6},{0xdb,0xc5},{0xdb,0xc3},{0x00,0x00},{0xdb,0xca},
    {0xdb,0xcc},{0xdb,0xc8},{0x91,0x6d},{0xdb,0xc7},{0xb5,0xf4},
    {0xb5,0xf5},{0x94,0xcf},{0x94,0xd0},{0x86,0x45},{0x8b,0xbc},
    {0xfb,0x63},{0x00,0x00},{0xdb,0xcf},{0xb8,0xcd},{0xdf,0xf2},
    {0xdf,0xf8},{0xdf,0xf3},{0xdf,0xf4},{0xf9,0xd8},{0xdf,0xf9},
    {0x00,0x00},{0xb8,0xcf},{0x00,0x00},{0xb8,0xc7},{0xb8,0xce},
    {0xdf,0xf1},{0xdb,0xc4},{0xb8,0xca},{0xb8,0xc8},{0xdf,0xf7},
    {0xdf,0xf6},{0xb8,0xc9},{0xb8,0xcb},{0xdf,0xf5},{0xb8,0xc6},
    {0x00,0x00},{0xb8,0xcc},{0x8f,0x62},{0x8f,0xc5},{0x89,0x5c},
    {0x91,0x6e},{0xfe,0xcb},{0xe3,0xf6},{0xbb,0x74},{0x00,0x00},
    {0x00,0x00},{0xe4,0x42},{0xe4,0x41},{0x00,0x00},{0xe3,0xfb},
    {0xbb,0x76},{0xe4,0x40},{0xe3,0xf7},{0xe3,0xf8},{0xbb,0x6e},
    {0xbb,0x70},{0x91,0x6f},{0xe3,0xfd},{0xe3,0xf5},{0xbb,0x72},
    {0xbb,0x71},{0xe3,0xf9},{0xe3,0xfe},{0xe3,0xfc},{0xbb,0x73},
    {0xe3,0xfa},{0xfe,0xcc},{0xfe,0xcd},{0xdb,0xce},{0xbb,0x6f},
    {0x00,0x00},{0x94,0xd1},{0xe7,0xc2},{0xe7,0xc9},{0xbd,0xc6},
    {0x00,0x00},{0xe7,0xcd},{0xbd,0xca},{0xe7,0xc5},{0xe7,0xc3},
    {0x00,0x00},{0xe7,0xcc},{0x00,0x00},{0xbd,0xc5},{0xe7,0xcb},
    {0xbd,0xc7},{0xbd,0xc8},{0xe7,0xc4},{0xbd,0xc9},{0xe7,0xca},
    {0xe7,0xc6},{0xe7,0xc7},{0xe7,0xc8},{0xbb,0x75},{0x8a,0x63},
    {0x91,0x70},{0x91,0x71},{0xeb,0x70},{0xeb,0x7c},{0x00,0x00},
    {0xbf,0xca},{0xeb,0x77},{0xeb,0x79},{0xfe,0xce},{0xbf,0xc8},
    {0xeb,0x71},{0xeb,0x75},{0x00,0x00},{0xeb,0x78},{0xbf,0xc6},
    {0xbf,0xc9},{0xeb,0x7b},{0xeb,0x73},{0xeb,0x74},{0xeb,0x7a},
    {0xeb,0x72},{0xeb,0x76},{0xbf,0xc7},{0xee,0x72},{0x8c,0x53},
    {0xee,0x71},{0xc1,0xb7},{0xee,0x77},{0xc1,0xb9},{0x00,0x00},
    {0x00,0x00},{0xc1,0xb6},{0xee,0x73},{0xc1,0xba},{0xee,0x74},
    {0x00,0x00},{0x00,0x00},{0xee,0x75},{0xee,0x78},{0xfd,0x58},
    {0xc1,0xb8},{0x00,0x00},{0xf0,0xd6},{0xfe,0xcf},{0x00,0x00},
    {0xf0,0xd9},{0x00,0x00},{0xf0,0xd3},{0xf0,0xd5},{0xfd,0x59},
    {0x00,0x00},{0xf0,0xd4},{0xf0,0xd7},{0xf0,0xd8},{0xee,0x76},
    {0xf0,0xd2},{0xfe,0xd0},{0x00,0x00},{0xc3,0xcd},{0xf2,0xec},
    {0xf2,0xef},{0xf2,0xf1},{0xf2,0xea},{0xf2,0xeb},{0xf2,0xee},
    {0xf2,0xf0},{0xc3,0xce},{0xc3,0xcc},{0xc3,0xcb},{0xf2,0xed},
    {0xf2,0xe9},{0xf4,0xca},{0xc4,0xb0},{0xfe,0xd1},{0xf4,0xcb},
    {0x00,0x00},{0x00,0x00},{0xf6,0x49},{0xc4,0xfb},{0xf6,0x4b},
    {0xc4,0xfc},{0xf6,0x48},{0xf6,0x4a},{0xc5,0xa8},{0x00,0x00},
    {0xf7,0x52},{0xc5,0xa7},{0xf7,0xfd},{0xf7,0xfc},{0x00,0x00},
    {0xf7,0xfb},{0x91,0x72},{0x00,0x00},{0xf9,0x48},{0xf9,0x49},
    {0xf9,0x4b},{0xf9,0x4a},{0x00,0x00},{0xca,0x50},{0xa6,0xe8},
    {0xfe,0xd2},{0xad,0x6e},{0xd7,0xc5},{0xb5,0xf7},{0x00,0x00},
    {0xdf,0xfa},{0xc2,0xd0},{0x95,0xf6},{0xf2,0xf2},{0xfd,0x6d},
    {0xfd,0x6e},{0xa8,0xa3},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0xb3,0x57},{0x00,0x00},{0xfe,0xd3},{0x00,0x00},{0xb3,0x56},
    {0xfd,0x6f},{0xdb,0xd0},{0xb5,0xf8},{0xdb,0xd2},{0xdb,0xd1},
    {0x00,0x00},{0x92,0x60},{0xdf,0xfb},{0xb8,0xd0},{0xe4,0x43},
    {0xe4,0x46},{0xe4,0x45},{0x00,0x00},{0xe4,0x44},{0xe7,0xce},
    {0xe7,0xd0},{0xe7,0xcf},{0xfb,0xaf},{0xbf,0xcc},{0x93,0xe1},
    {0x00,0x00},{0x95,0xc5},{0xbf,0xcb},{0x00,0x00},{0xc1,0xbb},
    {0xee,0x79},{0xee,0x7b},{0xee,0x7a},{0x00,0x00},{0x00,0x00},
    {0xc2,0xd1},{0x92,0x6d},{0x00,0x00},{0x00,0x00},{0xf2,0xf4},
    {0xf2,0xf3},{0x00,0x00},{0xf4,0xcc},{0xc4,0xb1},{0x00,0x00},
    {0xfd,0x71},{0xc4,0xfd},{0xf7,0x54},{0xf7,0x53},{0xc6,0x5b},
    {0x83,0x4e},{0x8d,0x73},{0x00,0x00},{0x84,0x7e},{0x84,0x7d},
    {0x85,0x53},{0x8d,0xe6},{0x8c,0xa6},{0x8c,0x54},{0x8a,0x64},
    {0x8e,0x7e},{0x90,0x5c},{0x00,0x00},{0x89,0x5e},{0x8f,0x63},
    {0x8a,0xfc},{0x8f,0xc6},{0xa8,0xa4},{0xd0,0xaf},{0xad,0x6f},
    {0xd7,0xc8},{0xd7,0xc6},{0x00,0x00},{0x00,0x00},{0xd7,0xc7},
    {0xdb,0xd4},{0xdb,0xd5},{0xe0,0x43},{0xdb,0xd3},{0x8a,0xfd},
    {0xdf,0xfc},{0xe0,0x41},{0xe0,0x40},{0xe0,0x42},{0xb8,0xd1},
    {0xdf,0xfe},{0xdf,0xfd},{0xe0,0x44},{0x91,0x73},{0xe4,0x49},
    {0xe4,0x47},{0x00,0x00},{0xe4,0x48},{0xe7,0xd3},{0xe7,0xd1},
    {0x00,0x00},{0x8f,0xc7},{0xe7,0xd2},{0xeb,0x7d},{0xee,0x7c},
    {0xee,0x7d},{0xc2,0xd2},{0x00,0x00},{0xf2,0xf5},{0xf4,0xcd},
    {0xc4,0xb2},{0x00,0x00},{0xf6,0x4c},{0xf7,0x55},{0xc5,0xa9},
    {0x00,0x00},{0xf7,0xfe},{0xf9,0x4c},{0xa8,0xa5},{0x00,0x00},
    {0xad,0x71},{0xad,0x72},{0xd0,0xb0},{0x00,0x00},{0x00,0x00},
    {0xd0,0xb1},{0xad,0x70},{0x00,0x00},{0xb0,0x54},{0x00,0x00},
    {0xb0,0x52},{0x00,0x00},{0xb0,0x51},{0xb0,0x58},{0xb0,0x50},
    {0xb0,0x59},{0xd3,0xdd},{0xb0,0x56},{0x00,0x00},{0xb0,0x53},
    {0xb0,0x57},{0xb0,0x55},{0xb0,0x4f},{0x00,0x00},{0x00,0x00},
    {0xb3,0x5f},{0xfe,0xd4},{0xb3,0x59},{0xd7,0xcc},{0xb3,0x5e},
    {0x00,0x00},{0x00,0x00},{0xb3,0x60},{0xb3,0x5a},{0x00,0x00},
    {0xb3,0x5b},{0x00,0x00},{0xd7,0xca},{0x00,0x00},{0xfe,0xd5},
    {0xb3,0x58},{0xfe,0xd6},{0xd7,0xcb},{0xb3,0x5d},{0x00,0x00},
    {0x00,0x00},{0xd7,0xc9},{0xb3,0x5c},{0x00,0x00},{0x93,0xd5},
    {0xb6,0x44},{0x00,0x00},{0xb6,0x46},{0x91,0x74},{0xfe,0xd7},
    {0xdb,0xd8},{0xb6,0x45},{0xb5,0xf9},{0xb5,0xfd},{0xfe,0xd8},
    {0xb8,0xe4},{0xe0,0x49},{0xdb,0xda},{0xb5,0xfe},{0x00,0x00},
    {0x00,0x00},{0xdb,0xdd},{0xdb,0xde},{0xb6,0x43},{0x00,0x00},
    {0xdb,0xe0},{0xfd,0x73},{0xdb,0xe2},{0x00,0x00},{0xdb,0xe3},
    {0xdb,0xd7},{0xdb,0xd6},{0xdb,0xe4},{0xb6,0x42},{0xdb,0xe1},
    {0xdb,0xdf},{0x00,0x00},{0xb6,0x40},{0xb5,0xfb},{0xb6,0x47},
    {0xdb,0xdb},{0xdb,0xdc},{0xdb,0xd9},{0x00,0x00},{0xb6,0x41},
    {0x00,0x00},{0x00,0x00},{0xb5,0xfc},{0x00,0x00},{0xb5,0xfa},
    {0xe0,0x48},{0xb8,0xdf},{0xb8,0xda},{0x00,0x00},{0x00,0x00},
    {0xb8,0xd5},{0xfc,0xda},{0xb8,0xe5},{0xb8,0xd6},{0x00,0x00},
    {0xb8,0xd2},{0xb8,0xe1},{0xb8,0xde},{0xb8,0xe0},{0x00,0x00},
    {0xb8,0xd7},{0xb8,0xdc},{0xb8,0xd3},{0xb8,0xd4},{0xe0,0x50},
    {0xe0,0x4d},{0xe0,0x45},{0xe0,0x4a},{0x00,0x00},{0xb8,0xe2},
    {0xe0,0x51},{0xb8,0xe3},{0xb8,0xd9},{0x00,0x00},{0xfd,0x72},
    {0xe0,0x47},{0x00,0x00},{0xe0,0x4f},{0xe0,0x4b},{0xe0,0x4e},
    {0xe0,0x4c},{0xb8,0xdd},{0xe0,0x46},{0xb8,0xd8},{0x00,0x00},
    {0x8c,0xa9},{0x8a,0x6c},{0xe4,0x4c},{0xbb,0x78},{0xbb,0x7b},
    {0x00,0x00},{0xe4,0x4e},{0xfe,0xda},{0xbb,0xa5},{0xe4,0x4d},
    {0xbb,0x7d},{0xfe,0xdb},{0xbd,0xcf},{0xe4,0x4f},{0x00,0x00},
    {0xbb,0xa4},{0xe4,0x4b},{0xbb,0xa6},{0x00,0x00},{0xfe,0xdc},
    {0x00,0x00},{0xbb,0x79},{0x00,0x00},{0xb8,0xdb},{0xbb,0x7c},
    {0x00,0x00},{0xbb,0x7a},{0xbb,0x7e},{0xbb,0xa2},{0xbb,0x77},
    {0xbb,0xa7},{0xbb,0xa3},{0xfe,0xdd},{0xbb,0xa1},{0xe4,0x4a},
    {0x91,0x75},{0x93,0xab},{0x00,0x00},{0xfe,0xde},{0xbd,0xd6},
    {0x00,0x00},{0xbd,0xd2},{0x00,0x00},{0xfe,0xdf},{0x00,0x00},
    {0xbd,0xd9},{0x00,0x00},{0xe7,0xd6},{0xbd,0xda},{0xe7,0xe2},
    {0xe7,0xdb},{0xbd,0xcb},{0xe7,0xe3},{0xe7,0xdd},{0xbd,0xd5},
    {0xe7,0xde},{0x00,0x00},{0xbd,0xd4},{0xe7,0xe1},{0xbd,0xce},
    {0xe7,0xdf},{0xe7,0xd5},{0xbd,0xcd},{0xeb,0xaa},{0xbd,0xd3},
    {0x00,0x00},{0xbd,0xd0},{0x82,0x51},{0xbd,0xd8},{0x00,0x00},
    {0xe7,0xd4},{0x00,0x00},{0xe7,0xd8},{0xbd,0xcc},{0xe7,0xd7},
    {0xe7,0xd9},{0xe7,0xda},{0xbd,0xd7},{0xe7,0xdc},{0xe7,0xe0},
    {0xe7,0xe4},{0x91,0x76},{0xbd,0xdb},{0xbf,0xd2},{0xeb,0xa5},
    {0xeb,0xab},{0xeb,0xa8},{0xeb,0x7e},{0xeb,0xac},{0xeb,0xa1},
    {0x00,0x00},{0xeb,0xa7},{0x00,0x00},{0xbf,0xcd},{0xbf,0xd3},
    {0xeb,0xad},{0x00,0x00},{0xfe,0xe0},{0xbf,0xcf},{0x00,0x00},
    {0xbf,0xd9},{0xbf,0xd4},{0xeb,0xaf},{0xeb,0xa9},{0xbf,0xd0},
    {0xeb,0xa2},{0xbf,0xda},{0xeb,0xa3},{0xeb,0xa4},{0xbf,0xdb},
    {0xbf,0xd8},{0xbd,0xd1},{0x9d,0xd1},{0xbf,0xce},{0xeb,0xb0},
    {0xbf,0xdc},{0x00,0x00},{0xbf,0xd5},{0xeb,0xae},{0xbf,0xd1},
    {0xbf,0xd6},{0xbf,0xd7},{0x00,0x00},{0xc1,0xc3},{0xee,0xa4},
    {0xee,0xad},{0xee,0xaa},{0xee,0xac},{0x00,0x00},{0xc1,0xc0},
    {0xee,0xa5},{0xfd,0x74},{0xee,0xab},{0xc1,0xbc},{0xee,0xa7},
    {0xc1,0xc4},{0xee,0xa3},{0xee,0xa8},{0xee,0xaf},{0xeb,0xa6},
    {0xee,0xa9},{0xee,0xa2},{0xc1,0xbd},{0xee,0xa1},{0xc1,0xbe},
    {0xee,0xb0},{0xc1,0xbf},{0xee,0xae},{0xc1,0xc2},{0xee,0x7e},
    {0xfe,0xe1},{0xc1,0xc1},{0x93,0xdc},{0xee,0xa6},{0xf0,0xdc},
    {0xf0,0xea},{0xf0,0xe5},{0xf0,0xe7},{0xf0,0xdb},{0xc2,0xd3},
    {0x00,0x00},{0xf0,0xda},{0xc2,0xd6},{0xc2,0xd5},{0x96,0xc1},
    {0xf0,0xe9},{0xf0,0xe1},{0xf0,0xde},{0xf0,0xe4},{0x00,0x00},
    {0xf0,0xdd},{0x00,0x00},{0xf0,0xdf},{0xf0,0xe8},{0xf0,0xe6},
    {0x00,0x00},{0xc2,0xd4},{0xf0,0xed},{0xf0,0xeb},{0xf0,0xe2},
    {0xf0,0xec},{0xf0,0xe3},{0xfe,0xe3},{0xf2,0xf9},{0xc3,0xcf},
    {0xf3,0x41},{0xfd,0x75},{0x00,0x00},{0xf6,0x4f},{0xc3,0xd6},
    {0xf0,0xe0},{0xf2,0xf7},{0xc3,0xd2},{0xf2,0xf8},{0xf2,0xfd},
    {0xfd,0x77},{0xfe,0xe4},{0xc3,0xd4},{0xc3,0xd5},{0xf2,0xf6},
    {0xf3,0x40},{0xf3,0x42},{0xf2,0xfa},{0xf2,0xfc},{0xf2,0xfe},
    {0xf2,0xfb},{0xf3,0x43},{0xc3,0xd1},{0xc3,0xd7},{0xc3,0xd3},
    {0x91,0x77},{0xc3,0xd0},{0xf4,0xd0},{0xfe,0xe5},{0xc4,0xb7},
    {0xf4,0xce},{0x00,0x00},{0xfe,0xe6},{0xf4,0xd2},{0x00,0x00},
    {0xf4,0xd3},{0xc4,0xb5},{0xf4,0xd4},{0xf4,0xd1},{0xfe,0xe7},
    {0xf4,0xcf},{0xc4,0xb8},{0xc4,0xb4},{0xf4,0xd5},{0x00,0x00},
    {0xc4,0xb6},{0xc4,0xb3},{0x91,0x78},{0x92,0xf0},{0x00,0x00},
    {0xc4,0xfe},{0x00,0x00},{0x00,0x00},{0xc5,0x40},{0xf6,0x4e},
    {0xf6,0x4d},{0xf6,0x50},{0xf6,0x51},{0x00,0x00},{0xc5,0x41},
    {0xf7,0x56},{0xf7,0x5b},{0xc5,0xaa},{0xfd,0x76},{0xf7,0x58},
    {0x82,0x63},{0xf7,0x57},{0xf7,0x5a},{0xf7,0x59},{0x00,0x00},
    {0xf8,0x43},{0x00,0x00},{0xc5,0xdc},{0xf8,0x42},{0xf8,0x40},
    {0x00,0x00},{0xf8,0x41},{0x00,0x00},{0x95,0xf8},{0x00,0x00},
    {0xc5,0xfe},{0xc5,0xfd},{0xf8,0xc1},{0xf8,0xc2},{0xc6,0x40},
    {0x00,0x00},{0xf9,0x4d},{0xf9,0x4e},{0xc6,0x67},{0xfe,0xe8},
    {0xc6,0x6d},{0x00,0x00},{0xf9,0xa9},{0xf9,0xc8},{0x9c,0xec},
    {0x83,0x79},{0x83,0x7a},{0x83,0x7b},{0x87,0x50},{0x8b,0xc2},
    {0x83,0xd4},{0x83,0xd6},{0x83,0xd5},{0x8d,0x58},{0x83,0xd7},
    {0x83,0xda},{0x00,0x00},{0x83,0xd9},{0x8c,0x56},{0x83,0xd8},
    {0x83,0xd3},{0x00,0x00},{0x8a,0x68},{0x89,0x62},{0x8f,0x7e},
    {0x8d,0xe7},{0x84,0xa2},{0x84,0xa4},{0x84,0xa5},{0x84,0xa8},
    {0x88,0x62},{0x00,0x00},{0x84,0xa7},{0x89,0x6a},{0x84,0xa6},
    {0x84,0xa1},{0x84,0xa3},{0x85,0x56},{0x85,0x57},{0x85,0x5e},
    {0x85,0x54},{0x85,0x59},{0x8b,0xbf},{0x00,0x00},{0x85,0x5a},
    {0x85,0x5c},{0x85,0x5d},{0x85,0x5b},{0x8f,0x65},{0x85,0x55},
    {0x8d,0xe8},{0x85,0x58},{0x00,0x00},{0x8c,0x57},{0x8d,0xe9},
    {0x8e,0x4f},{0x8e,0x52},{0x86,0x49},{0x8e,0x50},{0x86,0x4a},
    {0x86,0x4b},{0x86,0x4c},{0x86,0x4e},{0x86,0x50},{0x8e,0x53},
    {0x86,0x4f},{0x88,0x5a},{0x86,0x54},{0x86,0x53},{0x86,0x51},
    {0x86,0x52},{0x86,0x4d},{0x88,0x63},{0x86,0x47},{0x86,0x48},
    {0x86,0x46},{0x8e,0xf8},{0x8e,0x51},{0x00,0x00},{0x87,0x51},
    {0x87,0x4f},{0x87,0x4e},{0x87,0x58},{0x87,0x52},{0x87,0x54},
    {0x87,0x56},{0x87,0x55},{0x87,0x57},{0x87,0x53},{0x87,0x4d},
    {0x8e,0xa1},{0x88,0x5b},{0x88,0x5c},{0x8e,0xcb},{0x89,0x67},
    {0x8c,0xdd},{0x8e,0xcc},{0x88,0x65},{0x88,0x5d},{0x88,0x5e},
    {0x88,0x66},{0x88,0x61},{0x8e,0xcd},{0x88,0x60},{0x88,0x5f},
    {0x88,0x57},{0x88,0x59},{0x88,0x64},{0x88,0x58},{0x00,0x00},
    {0x88,0x56},{0x89,0x63},{0x89,0x6d},{0x89,0x64},{0x8a,0x69},
    {0x89,0x61},{0x89,0x65},{0x8e,0xf9},{0x89,0x68},{0x89,0x69},
    {0x8e,0xfa},{0x89,0x6b},{0x89,0x6e},{0x8d,0x59},{0x89,0x66},
    {0x89,0x6c},{0x89,0x60},{0x89,0x5f},{0x8a,0x65},{0x8e,0xfb},
    {0x00,0x00},{0x8a,0xfe},{0x8d,0xa4},{0x8f,0x64},{0x8a,0x6b},
    {0x8a,0x6a},{0x8a,0x66},{0x8f,0x66},{0x8a,0x67},{0x8a,0x6d},
    {0x8b,0x40},{0x8f,0xa1},{0x8b,0x42},{0x91,0x79},{0x8b,0x41},
    {0x8b,0xc0},{0x8f,0xc8},{0x8b,0xc3},{0x90,0x78},{0x8b,0xbe},
    {0x8b,0xc1},{0x90,0xa6},{0x8c,0xa7},{0x8c,0x58},{0x8d,0x5a},
    {0xa8,0xa6},{0x00,0x00},{0xd7,0xcd},{0x91,0x7a},{0xd7,0xce},
    {0xe0,0x52},{0xe4,0x50},{0xe7,0xe5},{0xc1,0xc6},{0x00,0x00},
    {0xc1,0xc5},{0xf0,0xee},{0xf3,0x44},{0x00,0x00},{0xf8,0x44},
    {0xa8,0xa7},{0xd3,0xde},{0xb0,0x5a},{0xb3,0x61},{0xe0,0x54},
    {0xe0,0x53},{0xbd,0xdc},{0xe7,0xe6},{0xbd,0xdd},{0xee,0xb1},
    {0xc2,0xd7},{0xfe,0xe9},{0x00,0x00},{0x00,0x00},{0xc6,0x76},
    {0xa8,0xa8},{0xcd,0xcb},{0xd3,0xdf},{0x00,0x00},{0x00,0x00},
    {0xb3,0x62},{0x00,0x00},{0xd7,0xcf},{0xd7,0xd0},{0x00,0x00},
    {0xdb,0xe5},{0x00,0x00},{0xb6,0x48},{0xb8,0xe6},{0x00,0x00},
    {0xe0,0x56},{0xe0,0x55},{0xe0,0x57},{0x00,0x00},{0xe4,0x51},
    {0xe4,0x52},{0xbb,0xa8},{0xbf,0xdd},{0xbd,0xde},{0xbf,0xde},
    {0x00,0x00},{0xee,0xb5},{0xee,0xb2},{0xee,0xb4},{0xee,0xb3},
    {0xc1,0xc7},{0x00,0x00},{0xf0,0xef},{0xf3,0x46},{0xf3,0x45},
    {0xcb,0xa4},{0xb0,0x5c},{0xb0,0x5b},{0xd3,0xe0},{0x91,0x7b},
    {0xd7,0xd1},{0x00,0x00},{0x00,0x00},{0xdb,0xe7},{0xdb,0xe6},
    {0xb6,0x49},{0x00,0x00},{0xe0,0x59},{0xe0,0x5a},{0xe0,0x58},
    {0x00,0x00},{0x00,0x00},{0xb8,0xe8},{0xb8,0xe7},{0x00,0x00},
    {0xbb,0xaa},{0xbb,0xa9},{0x91,0x7c},{0xe7,0xe7},{0xeb,0xb3},
    {0xeb,0xb1},{0xeb,0xb2},{0xbf,0xdf},{0xee,0xb7},{0xee,0xb6},
    {0x00,0x00},{0xf0,0xf2},{0xf0,0xf1},{0xf0,0xf0},{0xf3,0x47},
    {0xfe,0xea},{0xf9,0xaa},{0xa8,0xa9},{0xad,0x73},{0xfe,0xeb},
    {0xad,0x74},{0xb0,0x5d},{0xb0,0x5e},{0xd3,0xe2},{0xd3,0xe1},
    {0xd7,0xd2},{0x00,0x00},{0xb3,0x68},{0xb3,0x66},{0xb3,0x63},
    {0xb3,0x67},{0xb3,0x65},{0xb3,0x64},{0xfd,0x79},{0x91,0x7d},
    {0xb6,0x4a},{0xdb,0xea},{0x00,0x00},{0xb8,0xed},{0xb6,0x4c},
    {0xb6,0x51},{0xdb,0xec},{0xb6,0x53},{0xb6,0x52},{0xb6,0x55},
    {0xdb,0xeb},{0xdb,0xe8},{0xb6,0x4f},{0xb6,0x4b},{0xb6,0x4d},
    {0xdb,0xe9},{0xb6,0x54},{0xb6,0x50},{0xb6,0x4e},{0xb8,0xef},
    {0xb8,0xee},{0xb8,0xec},{0xb8,0xf0},{0x00,0x00},{0xb8,0xea},
    {0xb8,0xeb},{0x00,0x00},{0xb8,0xe9},{0x00,0x00},{0xe0,0x5b},
    {0x95,0x60},{0x82,0x62},{0xe4,0x54},{0x00,0x00},{0xbb,0xac},
    {0xbb,0xad},{0xbb,0xab},{0xfe,0xec},{0xe4,0x53},{0xfe,0xed},
    {0xe4,0x55},{0x00,0x00},{0xe7,0xea},{0xe7,0xec},{0x92,0xce},
    {0xbd,0xe7},{0xe7,0xed},{0xbd,0xe0},{0xe7,0xe9},{0xbd,0xdf},
    {0xbd,0xe9},{0xbd,0xe5},{0xbd,0xe6},{0xbd,0xe2},{0xe7,0xe8},
    {0xbd,0xe1},{0xe7,0xee},{0xe7,0xeb},{0x9e,0x40},{0xbd,0xe8},
    {0xfd,0x7a},{0xbd,0xe3},{0xbd,0xe4},{0xeb,0xb5},{0x00,0x00},
    {0xeb,0xb7},{0xeb,0xb6},{0x9e,0x41},{0xeb,0xb8},{0xbf,0xe0},
    {0xeb,0xb4},{0x00,0x00},{0xfd,0x7b},{0xc1,0xcb},{0xee,0xb8},
    {0xc1,0xc8},{0xc1,0xcc},{0xc1,0xca},{0xc1,0xc9},{0xf0,0xf3},
    {0x00,0x00},{0xf0,0xf6},{0x00,0x00},{0xf0,0xf5},{0x9e,0x42},
    {0xf0,0xf4},{0xc2,0xd8},{0xf3,0x48},{0xf3,0x49},{0xc3,0xd8},
    {0xf3,0x4a},{0xc3,0xd9},{0x82,0x57},{0xfd,0x7c},{0xc4,0xba},
    {0x00,0x00},{0xc4,0xb9},{0xf6,0x52},{0x9e,0x43},{0x91,0x7e},
    {0xc5,0x42},{0xf6,0x53},{0xf7,0x5c},{0xc5,0xab},{0xc5,0xac},
    {0x95,0x76},{0xf8,0x45},{0x00,0x00},{0xc6,0x42},{0x9e,0x44},
    {0x83,0x50},{0x83,0x7c},{0x83,0x7d},{0x00,0x00},{0x83,0xdd},
    {0x83,0xdc},{0x84,0xaa},{0x88,0x6e},{0x84,0x50},{0x88,0x6c},
    {0x84,0xac},{0x88,0x71},{0x84,0xa9},{0x84,0xad},{0x84,0xae},
    {0x85,0x68},{0x8a,0x70},{0x85,0x5f},{0x84,0xab},{0x85,0x61},
    {0x88,0x6b},{0x85,0x63},{0x8d,0xeb},{0x85,0x60},{0x85,0x66},
    {0x8d,0xea},{0x85,0x6a},{0x85,0x69},{0x85,0x64},{0x85,0x65},
    {0x85,0x62},{0x86,0x55},{0x8f,0xa3},{0x86,0x57},{0x86,0x58},
    {0x86,0x59},{0x86,0x5a},{0x86,0x5b},{0x8c,0xaa},{0x86,0x56},
    {0x86,0x5c},{0x90,0x47},{0x8e,0xa2},{0x87,0x5a},{0x91,0xa1},
    {0x87,0x5b},{0x88,0x6a},{0x88,0x6d},{0x91,0xa2},{0x8c,0xde},
    {0x88,0x69},{0x88,0x70},{0x00,0x00},{0x00,0x00},{0x88,0x72},
    {0x88,0x68},{0x8e,0xce},{0x89,0x6f},{0x00,0x00},{0x8b,0x43},
    {0x8a,0x71},{0x8a,0x6e},{0x8a,0x6f},{0x8f,0xa2},{0x8c,0xdf},
    {0x8b,0xc5},{0x00,0x00},{0x8b,0xc4},{0x8c,0x5a},{0x8c,0x59},
    {0x8d,0x5c},{0xa8,0xaa},{0x00,0x00},{0xb3,0x6a},{0xb3,0x69},
    {0xe0,0x5c},{0xe0,0x5d},{0x00,0x00},{0xbb,0xae},{0xeb,0xb9},
    {0xbd,0xea},{0xeb,0xba},{0xee,0xb9},{0xa8,0xab},{0x91,0xa3},
    {0xd0,0xb2},{0xad,0x76},{0xad,0x75},{0x87,0x5c},{0xd3,0xe3},
    {0xb0,0x5f},{0xd3,0xe4},{0xd7,0xd5},{0x9e,0x45},{0xd7,0xd4},
    {0x00,0x00},{0xd7,0xd3},{0x00,0x00},{0x00,0x00},{0xdb,0xee},
    {0xb6,0x58},{0xfd,0x7d},{0x00,0x00},{0xdb,0xed},{0xb6,0x57},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0xdb,0xef},{0xb6,0x56},
    {0x8a,0x72},{0xe0,0x5f},{0xe0,0x62},{0xe0,0x60},{0xe0,0x61},
    {0xe0,0x65},{0xe0,0x5e},{0xe0,0x66},{0xe0,0x63},{0xe0,0x64},
    {0xbb,0xb0},{0xe4,0x56},{0x00,0x00},{0x00,0x00},{0xbb,0xaf},
    {0x00,0x00},{0xe7,0xf2},{0xe7,0xf0},{0x00,0x00},{0x00,0x00},
    {0xbd,0xeb},{0xe7,0xef},{0xe7,0xf1},{0x00,0x00},{0xbd,0xec},
    {0x00,0x00},{0xeb,0xbb},{0xfd,0x7e},{0xeb,0xbc},{0xc1,0xcd},
    {0x9e,0x46},{0xf3,0x4c},{0xf3,0x4e},{0xf3,0x4b},{0xf3,0x4d},
    {0xf4,0xd6},{0xf6,0x54},{0x00,0x00},{0x90,0xa3},{0xf9,0x6f},
    {0xa8,0xac},{0xad,0x77},{0xd3,0xe5},{0xd3,0xe7},{0xd3,0xe6},
    {0x8c,0x5b},{0xd7,0xd8},{0xb3,0x6c},{0x00,0x00},{0xd7,0xd6},
    {0x00,0x00},{0xb3,0x6b},{0xd7,0xd9},{0x9e,0x47},{0xd7,0xda},
    {0xd7,0xd7},{0x8c,0xac},{0x8f,0x67},{0xdb,0xfb},{0xb6,0x60},
    {0xdb,0xf3},{0xdb,0xf9},{0x00,0x00},{0x00,0x00},{0xb6,0x5b},
    {0xb6,0x5e},{0xdb,0xf2},{0xb6,0x59},{0xdb,0xf6},{0xe0,0x6c},
    {0xb6,0x5d},{0x00,0x00},{0xdb,0xf1},{0xfd,0xa1},{0xdb,0xf7},
    {0xdb,0xf4},{0xdb,0xfa},{0xdb,0xf0},{0xdb,0xf8},{0xb6,0x5c},
    {0xb6,0x5f},{0xdb,0xf5},{0xb6,0x5a},{0x90,0x5e},{0xb8,0xf2},
    {0xe0,0x68},{0xb8,0xf1},{0xe0,0x6f},{0xe0,0x6e},{0xb8,0xf8},
    {0x00,0x00},{0xb8,0xf9},{0xe0,0x70},{0xb8,0xf3},{0xe0,0x6d},
    {0xb8,0xf7},{0xe0,0x72},{0xe0,0x69},{0x00,0x00},{0xe0,0x6b},
    {0xb8,0xf4},{0xe0,0x67},{0xe0,0x6a},{0xe0,0x71},{0xb8,0xf5},
    {0xe0,0x73},{0x88,0x73},{0x00,0x00},{0x8b,0xc6},{0x8b,0x46},
    {0x90,0x5d},{0xb8,0xf6},{0x8c,0xad},{0xbb,0xb1},{0xe4,0x5b},
    {0xe4,0x61},{0xe4,0x59},{0xe4,0x62},{0x9e,0x48},{0xe4,0x58},
    {0xe4,0x5d},{0xe4,0x63},{0xe4,0x60},{0xe4,0x5f},{0xe4,0x5e},
    {0x91,0xa4},{0xe4,0x57},{0xe4,0x5c},{0x00,0x00},{0x8c,0xab},
    {0xe4,0x5a},{0x9e,0x49},{0xbd,0xf1},{0xbd,0xee},{0xe7,0xfb},
    {0xe8,0x41},{0xe8,0x43},{0xe8,0x40},{0xe7,0xf8},{0xe7,0xfa},
    {0xe8,0x45},{0xe8,0x42},{0xe7,0xfc},{0xe8,0x46},{0xe7,0xf9},
    {0xe8,0x44},{0xbd,0xef},{0xbd,0xf5},{0xbd,0xf3},{0xe7,0xf3},
    {0xbd,0xf4},{0xbd,0xf0},{0xe7,0xf4},{0xe7,0xf6},{0xe7,0xf5},
    {0xe7,0xfd},{0xe7,0xfe},{0xfd,0xa2},{0xbd,0xf2},{0x95,0x57},
    {0xbd,0xed},{0x8c,0xe1},{0xfb,0x6d},{0xe7,0xf7},{0x8c,0xe0},
    {0xeb,0xc6},{0xbf,0xe2},{0x00,0x00},{0xeb,0xbd},{0xbf,0xe3},
    {0xbf,0xe6},{0xeb,0xc2},{0x00,0x00},{0xeb,0xbf},{0xbf,0xe5},
    {0x91,0xa5},{0x00,0x00},{0xeb,0xc3},{0xeb,0xc4},{0xeb,0xbe},
    {0xeb,0xc7},{0xeb,0xc0},{0xeb,0xc5},{0xbf,0xe4},{0x00,0x00},
    {0xbf,0xe1},{0xeb,0xc1},{0x9e,0x4a},{0xee,0xbf},{0xc1,0xd0},
    {0xc1,0xce},{0xc1,0xd1},{0xc1,0xcf},{0xee,0xbe},{0xee,0xbb},
    {0xee,0xba},{0xfd,0xa3},{0xee,0xbd},{0x8d,0x74},{0x8b,0x44},
    {0xee,0xbc},{0xf1,0x45},{0xc2,0xde},{0xf0,0xfb},{0xf0,0xfa},
    {0x00,0x00},{0xc2,0xd9},{0xf1,0x41},{0xf1,0x40},{0xf0,0xf7},
    {0xf1,0x43},{0xf0,0xfc},{0xc2,0xdd},{0xf0,0xf9},{0xf1,0x42},
    {0xf0,0xf8},{0xc2,0xda},{0xc2,0xdc},{0xf0,0xfd},{0xc2,0xdb},
    {0xf0,0xfe},{0x9e,0x4b},{0xf1,0x44},{0xf3,0x52},{0x00,0x00},
    {0xc3,0xde},{0xf3,0x4f},{0x00,0x00},{0xf3,0x53},{0x91,0xa6},
    {0x9e,0x4c},{0xc3,0xdb},{0xf3,0x51},{0xc3,0xe0},{0xfd,0xa5},
    {0xc3,0xdd},{0xfd,0xa4},{0xf3,0x50},{0x00,0x00},{0xc3,0xdf},
    {0xf3,0x54},{0xc3,0xda},{0x00,0x00},{0x9e,0x4d},{0x90,0x7e},
    {0x9e,0x4e},{0xc4,0xbc},{0xc4,0xbe},{0x00,0x00},{0xf4,0xd9},
    {0xc4,0xbd},{0xf4,0xd7},{0xc3,0xdc},{0xf4,0xd8},{0xc4,0xbb},
    {0xc5,0x43},{0xc5,0x45},{0xf6,0x56},{0xc5,0x44},{0xf6,0x55},
    {0x8d,0xa5},{0xf7,0x61},{0xc5,0xad},{0xf7,0x60},{0xc5,0xae},
    {0xf7,0x5e},{0xf7,0x5d},{0xf7,0x62},{0xf7,0x63},{0xf8,0x46},
    {0x91,0xa7},{0xf7,0x5f},{0x00,0x00},{0x90,0xa4},{0xf8,0xc6},
    {0xf8,0xc3},{0xf8,0xc4},{0xf8,0xc5},{0xc6,0x5c},{0x00,0x00},
    {0xf9,0x51},{0xf9,0x50},{0xf9,0x4f},{0xf9,0x70},{0xfd,0xa6},
    {0xf9,0xbe},{0xf9,0xab},{0xc6,0x6e},{0xa8,0xad},{0xb0,0x60},
    {0x95,0xdf},{0x00,0x00},{0x82,0x49},{0x91,0xa8},{0x91,0xa9},
    {0xb8,0xfa},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x9e,0x4f},
    {0x00,0x00},{0x00,0x00},{0x9e,0x50},{0xbd,0xf6},{0x00,0x00},
    {0x9e,0x51},{0xeb,0xc8},{0x94,0xd3},{0x00,0x00},{0xc2,0xdf},
    {0x00,0x00},{0xf3,0x55},{0x9e,0x52},{0x00,0x00},{0x91,0xaa},
    {0x91,0xab},{0x00,0x00},{0x94,0xd4},{0xf9,0xac},{0xa8,0xae},
    {0xaa,0xee},{0xad,0x79},{0xad,0x78},{0x91,0xac},{0xb0,0x63},
    {0x00,0x00},{0xd3,0xe8},{0xb0,0x61},{0xd3,0xe9},{0xb0,0x62},
    {0x00,0x00},{0x00,0x00},{0xd7,0xdf},{0xd7,0xdb},{0x00,0x00},
    {0xfb,0xa1},{0xb3,0x6d},{0xd7,0xde},{0xd7,0xdd},{0xd7,0xdc},
    {0xb3,0x6e},{0xd7,0xe0},{0xd7,0xe1},{0x93,0x7d},{0x91,0xad},
    {0x9e,0x53},{0xdc,0x43},{0xdc,0x41},{0xdc,0x45},{0xdc,0x46},
    {0xdc,0x4c},{0x00,0x00},{0xdc,0x48},{0xdc,0x4a},{0x9e,0x54},
    {0xdc,0x42},{0xdb,0xfc},{0x00,0x00},{0xdc,0x49},{0x9e,0x55},
    {0x00,0x00},{0xdc,0x4b},{0xdc,0x44},{0xdc,0x47},{0xdb,0xfd},
    {0xb6,0x62},{0xdc,0x40},{0xdb,0xfe},{0xb6,0x61},{0xb6,0x63},
    {0x92,0xad},{0xb8,0xfd},{0xe0,0x75},{0xe0,0x77},{0xe0,0x76},
    {0xe0,0x7b},{0xb8,0xfb},{0x00,0x00},{0xe0,0x78},{0xe0,0x74},
    {0xe0,0x79},{0xe0,0x7a},{0xb8,0xfc},{0xb8,0xfe},{0xe0,0x7c},
    {0x91,0xae},{0xe4,0x67},{0xe4,0x66},{0x00,0x00},{0xe4,0x64},
    {0xe4,0x65},{0xbb,0xb3},{0xbb,0xb5},{0xbb,0xb2},{0xbb,0xb4},
    {0xe8,0x4d},{0xe8,0x4e},{0xe8,0x49},{0xfd,0xa7},{0xe8,0x4a},
    {0xbd,0xf8},{0xbd,0xfd},{0xbd,0xf7},{0xbd,0xfe},{0xbd,0xf9},
    {0xe8,0x4b},{0x00,0x00},{0x00,0x00},{0xe8,0x4c},{0xe8,0x48},
    {0xbe,0x40},{0xbd,0xfb},{0x00,0x00},{0x00,0x00},{0xbd,0xfa},
    {0xbd,0xfc},{0x00,0x00},{0xe8,0x47},{0x95,0x70},{0xeb,0xca},
    {0xbf,0xe8},{0x9e,0x56},{0x00,0x00},{0xeb,0xcc},{0xbf,0xea},
    {0xeb,0xcf},{0xeb,0xcb},{0xeb,0xc9},{0xeb,0xce},{0xbf,0xe9},
    {0xeb,0xcd},{0x00,0x00},{0xbf,0xe7},{0x00,0x00},{0x00,0x00},
    {0xc1,0xd3},{0xc1,0xd6},{0xee,0xc1},{0x9e,0x57},{0xc1,0xd4},
    {0xee,0xc0},{0xc1,0xd2},{0xc1,0xd5},{0xf1,0x46},{0xf1,0x47},
    {0xf1,0x48},{0xc2,0xe0},{0x9e,0x58},{0xf1,0x49},{0x94,0xd5},
    {0xc2,0xe1},{0xc3,0xe2},{0xf3,0x58},{0xf3,0x59},{0xf3,0x57},
    {0xf3,0x56},{0xf3,0x5a},{0xc3,0xe1},{0xf4,0xdd},{0xf4,0xdb},
    {0xf4,0xdc},{0xf4,0xde},{0xf4,0xda},{0xf4,0xdf},{0xf6,0x58},
    {0xfd,0xa9},{0xf6,0x59},{0xf6,0x57},{0xc5,0x46},{0xf7,0x64},
    {0xc5,0xaf},{0xf7,0x65},{0xf8,0x48},{0xf8,0x47},{0x00,0x00},
    {0x83,0x51},{0x83,0x61},{0x83,0xa1},{0x83,0xde},{0x00,0x00},
    {0x83,0xdf},{0x8b,0x48},{0x84,0xaf},{0x88,0x79},{0x84,0xb0},
    {0x8c,0xae},{0x91,0xaf},{0x85,0x6b},{0x90,0x6e},{0x85,0x6c},
    {0x8d,0xed},{0x85,0x6d},{0x91,0xb0},{0x8d,0xee},{0x90,0x5f},
    {0x8d,0xec},{0x87,0x60},{0x86,0x5f},{0x86,0x5e},{0x86,0x60},
    {0x8b,0xc8},{0x00,0x00},{0x8e,0x56},{0x8e,0x55},{0x86,0x5d},
    {0x87,0x5f},{0x87,0x5e},{0x88,0x75},{0x88,0x78},{0x88,0x77},
    {0x88,0x74},{0x88,0x7c},{0x88,0x7b},{0x00,0x00},{0x88,0x76},
    {0x88,0x7a},{0x89,0x73},{0x89,0x70},{0x89,0x71},{0x00,0x00},
    {0x89,0x72},{0x8c,0xe2},{0x8a,0x76},{0x8a,0x73},{0x8a,0x74},
    {0x8f,0xa4},{0x8b,0x49},{0x8b,0xc7},{0xa8,0xaf},{0xb6,0x64},
    {0x00,0x00},{0x8b,0xc9},{0xb9,0x40},{0xfd,0x41},{0x00,0x00},
    {0x00,0x00},{0xbb,0xb6},{0x00,0x00},{0x9e,0x59},{0xbf,0xec},
    {0x91,0xb1},{0xbf,0xeb},{0x8c,0xaf},{0x00,0x00},{0x8c,0x47},
    {0x00,0x00},{0xc3,0xe3},{0xc4,0x7c},{0xc5,0x47},{0xa8,0xb0},
    {0xb0,0x64},{0xb9,0x41},{0x9e,0x5a},{0xf3,0x5b},{0xc6,0xd6},
    {0x9c,0xe0},{0x94,0xd6},{0x9e,0x5b},{0x8b,0xca},{0x93,0xc3},
    {0x94,0x4e},{0x94,0x44},{0x89,0x77},{0x86,0x63},{0xcb,0xa6},
    {0x00,0x00},{0x88,0x7e},{0xa8,0xb1},{0x00,0x00},{0xa8,0xb4},
    {0xa8,0xb3},{0xa8,0xb2},{0x86,0x65},{0x8a,0x79},{0xcb,0xa5},
    {0x9e,0x5c},{0xcd,0xcd},{0xa0,0xa4},{0xcd,0xcf},{0xaa,0xef},
    {0x9e,0x5d},{0x86,0x62},{0xaa,0xf1},{0xcd,0xcc},{0xcd,0xce},
    {0xaa,0xf0},{0xcd,0xd1},{0xcd,0xd0},{0xcd,0xd2},{0x8a,0x78},
    {0x84,0xb1},{0x94,0xd7},{0x85,0x6e},{0x87,0x61},{0x86,0x64},
    {0x84,0xb2},{0x89,0x76},{0xd0,0xb6},{0xd0,0xb4},{0xad,0x7c},
    {0xd0,0xb3},{0xad,0xa3},{0xad,0x7e},{0xad,0x7b},{0x00,0x00},
    {0xad,0xa4},{0x8b,0x4a},{0xad,0x7d},{0xad,0xa2},{0x00,0x00},
    {0xad,0xa1},{0xd0,0xb5},{0x91,0xb2},{0xad,0x7a},{0x00,0x00},
    {0x00,0x00},{0x84,0xb3},{0xb0,0x6a},{0xd3,0xeb},{0xd3,0xf1},
    {0xb0,0x67},{0xb0,0x6e},{0x95,0xd9},{0xb0,0x69},{0xd3,0xee},
    {0xd3,0xf0},{0xb0,0x6c},{0xd3,0xea},{0xd3,0xed},{0xb0,0x68},
    {0xb0,0x65},{0xd3,0xec},{0xb0,0x6b},{0xd3,0xef},{0xb0,0x6d},
    {0xb0,0x66},{0x00,0x00},{0x9e,0x5e},{0x89,0x75},{0x87,0x62},
    {0xd7,0xe3},{0xd7,0xe6},{0xb3,0x70},{0x91,0xb3},{0xb3,0x7a},
    {0xb3,0x76},{0xd7,0xe4},{0x87,0x63},{0x93,0x7a},{0xb3,0x7e},
    {0xb3,0x77},{0xb3,0x7c},{0xb3,0x72},{0x00,0x00},{0xb3,0x6f},
    {0xb3,0x71},{0xb3,0x7d},{0xd7,0xe5},{0xb3,0x75},{0xb3,0x78},
    {0xb3,0x74},{0xb3,0x79},{0xd7,0xe7},{0xb3,0x7b},{0xb3,0x73},
    {0xd7,0xe2},{0x00,0x00},{0x8d,0x41},{0x94,0xd8},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0xdc,0x4d},
    {0xb6,0x65},{0xdc,0x4f},{0x00,0x00},{0xb6,0x67},{0xb6,0x69},
    {0x9e,0x5f},{0xdc,0x4e},{0xb6,0x66},{0xb6,0x6a},{0x9e,0x60},
    {0xb6,0x68},{0x91,0xb4},{0x00,0x00},{0x8d,0x42},{0xb9,0x47},
    {0xe0,0xa3},{0xb9,0x4f},{0xe0,0x7e},{0x00,0x00},{0xb9,0x50},
    {0xb9,0x45},{0x00,0x00},{0xe0,0xa1},{0x93,0x72},{0x00,0x00},
    {0xb9,0x4a},{0x00,0x00},{0xe0,0xa2},{0xb9,0x43},{0xb9,0x42},
    {0xfd,0xb6},{0xb9,0x4d},{0xb9,0x4c},{0xb9,0x4b},{0xb9,0x49},
    {0xb9,0x4e},{0xe0,0x7d},{0xb9,0x44},{0xb9,0x46},{0xb9,0x48},
    {0xfd,0xb5},{0x89,0x78},{0xbb,0xb8},{0xbb,0xbb},{0x00,0x00},
    {0xbb,0xbf},{0xbb,0xb9},{0xbb,0xbe},{0xbb,0xbc},{0x00,0x00},
    {0xbb,0xb7},{0xfe,0x61},{0xbb,0xbd},{0xbb,0xba},{0x9e,0x61},
    {0x91,0xb5},{0x00,0x00},{0xe8,0x52},{0xbe,0x43},{0xbe,0x41},
    {0x00,0x00},{0xe8,0x53},{0x9e,0x62},{0xbe,0x44},{0xbe,0x42},
    {0xe8,0x51},{0xe8,0x50},{0x00,0x00},{0xbf,0xf0},{0xe8,0x4f},
    {0xbf,0xee},{0xbf,0xed},{0xeb,0xd0},{0xbe,0x45},{0xbf,0xef},
    {0xeb,0xd1},{0xbf,0xf2},{0xeb,0xd2},{0xbf,0xf1},{0xc1,0xd8},
    {0xee,0xc3},{0xc1,0xd7},{0xc1,0xdc},{0xc1,0xda},{0xc1,0xdb},
    {0xc2,0xe3},{0xc1,0xd9},{0xee,0xc2},{0xeb,0xd3},{0xc2,0xe2},
    {0xc2,0xe4},{0x91,0xb6},{0xc3,0xe4},{0xc3,0xe5},{0x00,0x00},
    {0xf4,0xe0},{0x00,0x00},{0xc5,0xde},{0xc5,0xdd},{0xa8,0xb6},
    {0x00,0x00},{0x88,0xa3},{0xca,0x55},{0xb0,0x6f},{0x00,0x00},
    {0xca,0x52},{0xca,0x53},{0xca,0x51},{0x00,0x00},{0xca,0x54},
    {0x00,0x00},{0x8f,0xa5},{0xcb,0xaa},{0xcb,0xa7},{0xcb,0xac},
    {0xcb,0xa8},{0xa8,0xb7},{0xa8,0xba},{0x00,0x00},{0xcb,0xa9},
    {0xa8,0xb9},{0xcb,0xab},{0x95,0x40},{0x00,0x00},{0xa8,0xb8},
    {0x00,0x00},{0x8e,0x57},{0x00,0x00},{0x85,0x6f},{0xcd,0xd5},
    {0xcd,0xd7},{0xaa,0xf4},{0xcd,0xd3},{0xcd,0xd6},{0xcd,0xd4},
    {0xaa,0xf2},{0xaa,0xf5},{0x00,0x00},{0xaa,0xf3},{0x86,0x66},
    {0x89,0x79},{0x88,0xa1},{0x00,0x00},{0xd0,0xb8},{0xd0,0xbc},
    {0xd0,0xb9},{0x00,0x00},{0xad,0xa7},{0x00,0x00},{0xad,0xa8},
    {0xfd,0xab},{0xd0,0xbb},{0x00,0x00},{0xd0,0xbd},{0xd0,0xbf},
    {0x00,0x00},{0xad,0xa5},{0xd0,0xbe},{0x00,0x00},{0x00,0x00},
    {0xad,0xa6},{0x8d,0xc6},{0x8e,0xfc},{0x88,0xa2},{0x00,0x00},
    {0x8d,0xf0},{0xd7,0xee},{0xd0,0xba},{0xd3,0xf2},{0xd3,0xfb},
    {0xd3,0xf9},{0xd3,0xf4},{0xd3,0xf5},{0xd3,0xfa},{0xd3,0xfc},
    {0xb0,0x71},{0x91,0xb7},{0xd3,0xf7},{0xd3,0xf3},{0xb0,0x70},
    {0xb0,0x72},{0xd3,0xf6},{0xd3,0xfd},{0xd3,0xf8},{0x8c,0xe3},
    {0x90,0xbb},{0xb3,0xa1},{0xd7,0xf1},{0xd7,0xe9},{0xd7,0xef},
    {0xd7,0xf0},{0xb3,0xa2},{0x00,0x00},{0xd7,0xe8},{0xd7,0xea},
    {0xd0,0xb7},{0xd7,0xec},{0xd7,0xed},{0xd7,0xeb},{0xb6,0x6c},
    {0x00,0x00},{0x92,0x7b},{0x8e,0xcf},{0xdc,0x56},{0xeb,0xd4},
    {0xdc,0x57},{0xdc,0x54},{0xb3,0xa3},{0xb6,0x6e},{0xdc,0x53},
    {0xdc,0x59},{0xdc,0x58},{0xb6,0x6b},{0xdc,0x5c},{0xdc,0x52},
    {0xdc,0x5b},{0xdc,0x50},{0xdc,0x5a},{0xdc,0x55},{0xb6,0x6d},
    {0x00,0x00},{0xe0,0xaa},{0x00,0x00},{0xe0,0xa5},{0xe0,0xab},
    {0xe0,0xa6},{0xe0,0xa4},{0xe0,0xa7},{0xb9,0x51},{0x00,0x00},
    {0xe0,0xa9},{0x91,0xb8},{0xe0,0xa8},{0xb9,0x52},{0xbb,0xc1},
    {0xbb,0xc0},{0xe4,0x6e},{0xe4,0x71},{0xe4,0x69},{0xe4,0x6d},
    {0xbb,0xc2},{0xe4,0x6c},{0xe4,0x6a},{0xe4,0x70},{0xe4,0x6b},
    {0xe4,0x68},{0xe4,0x6f},{0x00,0x00},{0xe8,0x59},{0xbe,0x48},
    {0xf1,0x4a},{0xe8,0x56},{0xe8,0x57},{0xe8,0x55},{0xdc,0x51},
    {0xbe,0x47},{0xe8,0x5a},{0xe8,0x54},{0xbe,0x46},{0xbe,0x49},
    {0xe8,0x58},{0xeb,0xd5},{0xbf,0xf3},{0xeb,0xd6},{0xeb,0xd7},
    {0x00,0x00},{0xee,0xc4},{0xc1,0xdd},{0xf1,0x4b},{0xf1,0x4c},
    {0x00,0x00},{0x00,0x00},{0xf1,0x4d},{0xf3,0x5d},{0xf3,0x5c},
    {0xf4,0xe2},{0x00,0x00},{0xf4,0xe1},{0xf6,0x5b},{0xf6,0x5c},
    {0xf6,0x5a},{0xf7,0x66},{0xc5,0xb0},{0xa8,0xbb},{0xad,0xaa},
    {0xad,0xa9},{0xb0,0x75},{0xb0,0x74},{0xd4,0x40},{0xd4,0x41},
    {0xd3,0xfe},{0xfd,0xac},{0xb0,0x73},{0xd7,0xf5},{0x92,0xf8},
    {0xd7,0xf6},{0xd7,0xf2},{0xb3,0xa4},{0xd7,0xf3},{0xfd,0xaf},
    {0xd7,0xf4},{0x00,0x00},{0xfd,0xae},{0x8a,0x7a},{0x96,0xa8},
    {0xdc,0x5f},{0xdc,0x61},{0xdc,0x5d},{0xdc,0x60},{0xb6,0x6f},
    {0xdc,0x5e},{0xb6,0x70},{0x00,0x00},{0xfd,0xb0},{0xdd,0x73},
    {0xb9,0x55},{0xb9,0x54},{0x00,0x00},{0xb9,0x53},{0x00,0x00},
    {0xe0,0xac},{0xe0,0xad},{0x96,0xa9},{0x8b,0x4c},{0xe4,0x73},
    {0xe4,0x75},{0xbb,0xc6},{0xbb,0xc3},{0x96,0xa1},{0xbb,0xc5},
    {0xbb,0xc4},{0xe4,0x74},{0xe4,0x72},{0x00,0x00},{0xfd,0xb1},
    {0x8d,0xa6},{0x90,0xa5},{0x8d,0x5d},{0xe8,0x61},{0xe8,0x5e},
    {0xe8,0x5f},{0xbe,0x4d},{0xe8,0x60},{0xe8,0x5b},{0xe8,0x5c},
    {0xbe,0x4a},{0x00,0x00},{0xbe,0x4b},{0xe8,0x5d},{0xbe,0x4c},
    {0x96,0xaa},{0xeb,0xdb},{0xfd,0xb2},{0xeb,0xdc},{0xeb,0xd9},
    {0xeb,0xda},{0xbf,0xf4},{0xeb,0xd8},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x82,0x79},{0x00,0x00},{0xee,0xc8},{0xee,0xc5},
    {0xee,0xc7},{0xc1,0xe0},{0xee,0xcb},{0xc1,0xdf},{0xee,0xc9},
    {0xee,0xcc},{0xee,0xca},{0xee,0xc6},{0xc1,0xde},{0x82,0x66},
    {0xf1,0x4f},{0x00,0x00},{0xf1,0x50},{0xf1,0x4e},{0x9e,0x63},
    {0xf1,0x52},{0xc2,0xe5},{0xc2,0xe6},{0xf3,0x5f},{0xc3,0xe7},
    {0xf1,0x51},{0xf3,0x5e},{0xc3,0xe6},{0xf4,0xe5},{0xf4,0xe6},
    {0xc4,0xbf},{0xf4,0xe4},{0x9e,0x64},{0xf4,0xe3},{0x92,0xf1},
    {0xf6,0x5d},{0xc5,0x48},{0xfd,0xb3},{0xf8,0x49},{0xf8,0xc8},
    {0xf8,0xc7},{0x00,0x00},{0xc6,0x43},{0xc6,0x5d},{0xf8,0xc9},
    {0xf9,0x71},{0x9e,0x65},{0xc6,0x6f},{0xa8,0xbc},{0xaa,0xf6},
    {0x92,0xd8},{0xb9,0x56},{0x8c,0x5c},{0xc4,0xc0},{0xa8,0xbd},
    {0xad,0xab},{0xb3,0xa5},{0xb6,0x71},{0xc2,0xe7},{0xaa,0xf7},
    {0x00,0x00},{0xd0,0xc1},{0xd0,0xc0},{0xd4,0x42},{0x91,0xb9},
    {0xb0,0x78},{0xb0,0x76},{0xb0,0x7a},{0xd4,0x44},{0x91,0xba},
    {0xb0,0x79},{0xb0,0x77},{0x91,0xbb},{0x96,0x49},{0x00,0x00},
    {0x91,0xbc},{0xd4,0x43},{0xb3,0xa8},{0xd7,0xfc},{0x91,0xbd},
    {0xb3,0xa7},{0xb3,0xa9},{0xd8,0x42},{0xb3,0xab},{0xd7,0xfe},
    {0xd8,0x40},{0xd7,0xf7},{0xb3,0xaa},{0xd8,0x43},{0x00,0x00},
    {0x00,0x00},{0xd7,0xf9},{0x00,0x00},{0xd7,0xfa},{0xd7,0xf8},
    {0xb3,0xa6},{0x91,0xbe},{0xd8,0x41},{0xd7,0xfb},{0xd7,0xfd},
    {0x9e,0x66},{0x00,0x00},{0x91,0xbf},{0xdc,0x6d},{0xfd,0xb7},
    {0xdc,0x6c},{0xdc,0x6a},{0xdc,0x62},{0xdc,0x71},{0xdc,0x65},
    {0xdc,0x6f},{0xdc,0x76},{0xdc,0x6e},{0xb6,0x79},{0x9e,0x67},
    {0xb6,0x75},{0xdc,0x63},{0x00,0x00},{0xdc,0x69},{0xb6,0x77},
    {0x95,0x4c},{0xdc,0x68},{0xb6,0x78},{0xb6,0x7a},{0xdc,0x6b},
    {0x9e,0x68},{0xb6,0x72},{0xb6,0x73},{0xdc,0x77},{0xdc,0x75},
    {0x00,0x00},{0xdc,0x74},{0xdc,0x66},{0x00,0x00},{0xdc,0x72},
    {0x00,0x00},{0xb6,0x76},{0x00,0x00},{0x00,0x00},{0x9e,0x69},
    {0x00,0x00},{0xb6,0x74},{0xdc,0x73},{0xdc,0x64},{0xdc,0x67},
    {0xdc,0x70},{0x9e,0x6a},{0x91,0xc0},{0xfb,0x5f},{0x9e,0x6b},
    {0x91,0xc1},{0xe4,0xba},{0xe0,0xb7},{0x00,0x00},{0xe0,0xb0},
    {0xe0,0xc3},{0xe0,0xcc},{0xe0,0xb3},{0xb9,0x61},{0x9e,0x6c},
    {0xe0,0xc0},{0xb9,0x57},{0xb9,0x59},{0xb9,0x65},{0xe0,0xb1},
    {0x00,0x00},{0x9e,0x6d},{0xb9,0x5a},{0xb9,0x5c},{0xb9,0x66},
    {0xb9,0x5b},{0x9e,0x6e},{0x00,0x00},{0x00,0x00},{0x93,0x7b},
    {0xb9,0x64},{0xe0,0xb9},{0x00,0x00},{0xe0,0xae},{0xb9,0x62},
    {0xe0,0xb8},{0xb9,0x5e},{0xe0,0xca},{0xb9,0x63},{0xe0,0xc8},
    {0xe0,0xbc},{0xe0,0xc6},{0xb9,0x60},{0xe0,0xaf},{0xe0,0xc9},
    {0xe0,0xc4},{0x96,0x40},{0xe0,0xcb},{0xb9,0x58},{0x9e,0x6f},
    {0x91,0xc3},{0xb9,0x67},{0xb9,0x5d},{0x00,0x00},{0x9e,0x70},
    {0xe0,0xb5},{0x9e,0x71},{0xe0,0xbd},{0xe0,0xc1},{0x95,0xf1},
    {0xe0,0xc5},{0xb9,0x5f},{0xe0,0xb4},{0xe0,0xb2},{0xe0,0xbe},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x9e,0x72},{0xe0,0xbb},
    {0xe0,0xba},{0x9e,0x73},{0xe0,0xbf},{0xe0,0xc2},{0x92,0xc0},
    {0xe0,0xc7},{0x96,0x43},{0x8c,0xe5},{0x00,0x00},{0xe4,0x78},
    {0x91,0xc4},{0xbb,0xc7},{0xe4,0xa4},{0xe4,0x7a},{0xbb,0xcc},
    {0xbb,0xd0},{0xe4,0xad},{0xe4,0xb5},{0xe4,0xa6},{0xbb,0xc8},
    {0x9e,0x74},{0xe4,0xaa},{0xe0,0xb6},{0x9e,0x75},{0xbb,0xc9},
    {0xe4,0xb1},{0xe4,0xb6},{0xe4,0xae},{0x9e,0x76},{0xe4,0xb0},
    {0xe4,0xb9},{0xe4,0xb2},{0xe4,0x7e},{0xe4,0xa9},{0x9e,0x77},
    {0x00,0x00},{0xbb,0xd1},{0x00,0x00},{0xbb,0xcd},{0xe4,0x7c},
    {0xe4,0xab},{0xbb,0xcb},{0xe4,0xa5},{0xbb,0xca},{0xe4,0xb3},
    {0xe4,0xa2},{0xe4,0x79},{0xbb,0xce},{0xe4,0xb8},{0x00,0x00},
    {0x00,0x00},{0xe4,0x7b},{0xe4,0xaf},{0xe4,0xac},{0xe4,0xa7},
    {0xe4,0x77},{0xe4,0x76},{0xe4,0xa1},{0xe4,0xb4},{0xbb,0xcf},
    {0xe4,0xb7},{0xe4,0x7d},{0xe4,0xa3},{0xbe,0x52},{0x93,0x4b},
    {0x8d,0xa8},{0x00,0x00},{0x00,0x00},{0x9e,0x78},{0xbe,0x5a},
    {0xbe,0x55},{0xe8,0xa4},{0xe8,0xa1},{0xe8,0x67},{0xbe,0x50},
    {0x00,0x00},{0xf9,0xd7},{0x9e,0x79},{0xbe,0x4f},{0xbe,0x56},
    {0x00,0x00},{0xfd,0xb9},{0x9e,0x7a},{0xe8,0x65},{0xbe,0x54},
    {0xe8,0x71},{0xe8,0x63},{0xe8,0x64},{0xbe,0x4e},{0xe8,0xa3},
    {0xbe,0x58},{0xe8,0x74},{0xe8,0x79},{0xe8,0x73},{0xeb,0xee},
    {0xe8,0x6f},{0xe8,0x77},{0xe8,0x75},{0xe8,0x68},{0xe8,0x62},
    {0xe8,0x7d},{0xbe,0x57},{0xe8,0x7e},{0x9e,0x7b},{0xe8,0x78},
    {0x00,0x00},{0xe8,0x6d},{0xe8,0x6b},{0xe8,0x66},{0x00,0x00},
    {0x9e,0x7c},{0x00,0x00},{0xe8,0x6e},{0xe8,0x7b},{0xe8,0x6a},
    {0xe8,0x7a},{0xe8,0xa2},{0x00,0x00},{0x9e,0x7d},{0xbe,0x53},
    {0x9e,0x7e},{0xe8,0x76},{0xe8,0x7c},{0xe8,0x72},{0xe8,0x6c},
    {0xbe,0x51},{0x9e,0xa1},{0x9e,0xa2},{0x91,0xc5},{0xe4,0xa8},
    {0xe8,0x70},{0xbe,0x59},{0xe8,0x69},{0x94,0x58},{0x93,0x74},
    {0x9e,0xa3},{0x00,0x00},{0x9e,0xa4},{0xeb,0xf4},{0xbf,0xf7},
    {0xeb,0xf3},{0xeb,0xf0},{0xec,0x44},{0xbf,0xfb},{0x9e,0xa5},
    {0xec,0x41},{0xeb,0xf8},{0xec,0x43},{0xeb,0xe9},{0xeb,0xf6},
    {0x9e,0xa6},{0xbf,0xfd},{0x00,0x00},{0xeb,0xe1},{0x9e,0xa7},
    {0xeb,0xdf},{0xec,0x42},{0x00,0x00},{0xec,0x40},{0xeb,0xfe},
    {0xeb,0xed},{0xeb,0xec},{0xeb,0xe2},{0xc0,0x40},{0x00,0x00},
    {0xeb,0xe8},{0xeb,0xf2},{0xeb,0xfd},{0xc0,0x43},{0xec,0x45},
    {0x00,0x00},{0xc1,0xe8},{0xc0,0x45},{0xbf,0xfe},{0xeb,0xe6},
    {0x00,0x00},{0xeb,0xef},{0xeb,0xde},{0xeb,0xe0},{0xbf,0xf5},
    {0xc0,0x42},{0xbf,0xfa},{0xeb,0xe7},{0xeb,0xf7},{0xeb,0xf1},
    {0xc0,0x41},{0xeb,0xdd},{0xc1,0xe3},{0xeb,0xf9},{0xeb,0xfc},
    {0xbf,0xfc},{0x93,0xf3},{0xeb,0xeb},{0xc0,0x44},{0xbf,0xf9},
    {0x9e,0xa8},{0x9e,0xa9},{0x93,0xf7},{0xbf,0xf8},{0xeb,0xf5},
    {0xeb,0xfb},{0xbf,0xf6},{0x00,0x00},{0xeb,0xe4},{0xeb,0xfa},
    {0x91,0xc6},{0x94,0xdb},{0xeb,0xe5},{0x00,0x00},{0x8b,0xd6},
    {0x00,0x00},{0x9e,0xaa},{0xfe,0x7c},{0x9e,0xab},{0x9e,0xac},
    {0x97,0x55},{0x96,0x42},{0xeb,0xea},{0xee,0xd2},{0xfe,0x79},
    {0xee,0xd7},{0xc1,0xe5},{0xc1,0xe7},{0xee,0xdd},{0xc1,0xe1},
    {0xee,0xec},{0xee,0xe3},{0xee,0xd8},{0xee,0xd9},{0xee,0xe2},
    {0x00,0x00},{0xc1,0xee},{0xee,0xe1},{0xee,0xd1},{0xee,0xe0},
    {0xee,0xd4},{0xee,0xed},{0xc1,0xed},{0xc1,0xeb},{0xee,0xd5},
    {0x00,0x00},{0xee,0xe8},{0x9e,0xad},{0xee,0xda},{0xee,0xe7},
    {0x9e,0xae},{0xee,0xe9},{0xee,0xd0},{0xc1,0xe6},{0x9e,0xaf},
    {0xee,0xea},{0x9e,0xb0},{0x96,0x44},{0xee,0xde},{0xfd,0xba},
    {0xc1,0xea},{0xee,0xdb},{0xfd,0xbb},{0x00,0x00},{0xc1,0xec},
    {0xee,0xe4},{0x00,0x00},{0x9e,0xb1},{0x9e,0xb2},{0xc1,0xe4},
    {0xee,0xd6},{0xee,0xe5},{0x9e,0xb3},{0xee,0xdf},{0xeb,0xe3},
    {0xee,0xe6},{0xee,0xd3},{0x9e,0xb4},{0xc1,0xe9},{0x00,0x00},
    {0xee,0xeb},{0x9e,0xb5},{0xc1,0xe2},{0xee,0xce},{0x9e,0xb6},
    {0xfb,0x73},{0x9e,0xb7},{0x9e,0xb8},{0xf1,0x60},{0xf1,0x59},
    {0xc2,0xe9},{0x00,0x00},{0xf1,0x54},{0xf1,0x63},{0xf1,0x5b},
    {0xee,0xdc},{0x9e,0xb9},{0xf1,0x65},{0xf1,0x55},{0x00,0x00},
    {0xc2,0xe8},{0xf1,0x5f},{0xc2,0xea},{0xc2,0xf2},{0xc2,0xf0},
    {0xf1,0x61},{0xc2,0xf1},{0xf1,0x57},{0x9e,0xba},{0xf1,0x58},
    {0xf1,0x5d},{0xf1,0x62},{0x9e,0xbb},{0xee,0xcd},{0xc2,0xeb},
    {0xf1,0x6a},{0xf1,0x67},{0xf1,0x6b},{0xf1,0x5e},{0xf1,0x5a},
    {0xf1,0x68},{0xf3,0x6a},{0xf1,0x5c},{0x00,0x00},{0xc2,0xee},
    {0x97,0x56},{0xc2,0xed},{0xee,0xcf},{0xc2,0xef},{0xf1,0x64},
    {0xf1,0x66},{0xc2,0xec},{0xf1,0x69},{0xf1,0x53},{0x00,0x00},
    {0xf1,0x56},{0x9e,0xbc},{0x94,0xdc},{0xfd,0xbc},{0x9e,0xbd},
    {0x00,0x00},{0x9e,0xbe},{0x00,0x00},{0x9e,0xbf},{0xf3,0x73},
    {0x00,0x00},{0xf3,0x63},{0xc3,0xeb},{0xf3,0x71},{0x00,0x00},
    {0x97,0x57},{0xf3,0x61},{0xc3,0xec},{0x00,0x00},{0xf3,0x6c},
    {0x9e,0xc0},{0xf3,0x68},{0xc3,0xf1},{0xf3,0x72},{0xf3,0x62},
    {0xf3,0x65},{0xc3,0xe9},{0xf3,0x74},{0x9e,0xc1},{0xf3,0x6d},
    {0xf3,0x70},{0xc3,0xef},{0xc3,0xf4},{0xc3,0xf2},{0xf3,0x69},
    {0xf3,0x64},{0x9e,0xc2},{0xc3,0xed},{0xc3,0xee},{0xf3,0x60},
    {0xc3,0xea},{0x9e,0xc3},{0xc3,0xe8},{0xc3,0xf0},{0xf3,0x6f},
    {0xc3,0xf3},{0x97,0x58},{0xf3,0x6b},{0xf3,0x75},{0xc3,0xf5},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0xf3,0x67},{0x00,0x00},
    {0xf3,0x6e},{0x00,0x00},{0x9e,0xc4},{0x9e,0xc5},{0x00,0x00},
    {0x9e,0xc6},{0x9e,0xc7},{0xf4,0xf3},{0xf5,0x42},{0xf4,0xf5},
    {0xf4,0xfc},{0xf3,0x66},{0xf4,0xfa},{0xf4,0xe9},{0xf5,0x40},
    {0xc4,0xc3},{0xf4,0xed},{0xf4,0xfe},{0xf4,0xf4},{0x9e,0xc8},
    {0x00,0x00},{0xc4,0xc2},{0x9e,0xc9},{0x00,0x00},{0xf5,0x44},
    {0xf4,0xf6},{0x9e,0xca},{0xf4,0xfb},{0xf4,0xfd},{0xf4,0xe7},
    {0xf5,0x41},{0xf4,0xf2},{0xf4,0xf7},{0xf4,0xeb},{0xf4,0xef},
    {0xf5,0x43},{0xf4,0xf9},{0xf4,0xe8},{0xf4,0xec},{0xf4,0xee},
    {0xf4,0xf8},{0x9e,0xcb},{0xc4,0xc1},{0xf4,0xf1},{0x97,0x59},
    {0x9e,0xcc},{0x00,0x00},{0x9e,0xcd},{0x00,0x00},{0x00,0x00},
    {0xf4,0xea},{0x97,0x5a},{0x00,0x00},{0x00,0x00},{0x9e,0xce},
    {0x9e,0xcf},{0x9e,0xd0},{0xfd,0xbd},{0xf4,0xf0},{0xf6,0x61},
    {0xf6,0x66},{0xc5,0x4f},{0xf6,0x68},{0x9e,0xd1},{0xc5,0x49},
    {0x00,0x00},{0xf6,0x64},{0xf6,0x6a},{0xc5,0x4e},{0xc5,0x4a},
    {0x00,0x00},{0xc5,0x4b},{0xf6,0x60},{0xf6,0x67},{0xc5,0x4d},
    {0xf6,0x65},{0xc5,0x4c},{0xf6,0x5f},{0xf6,0x63},{0xf6,0x62},
    {0x97,0x5b},{0xf6,0x5e},{0xf6,0x69},{0x97,0x5c},{0x9e,0xd2},
    {0x9e,0xd3},{0xc5,0xb1},{0xf7,0x6d},{0xf7,0x70},{0xf7,0x6c},
    {0xf7,0x6e},{0xf7,0x6f},{0xf7,0x69},{0xf7,0x6a},{0xf7,0x67},
    {0x9e,0xd4},{0x00,0x00},{0xf7,0x6b},{0xf7,0x68},{0xc5,0xb2},
    {0xc5,0xb3},{0x97,0x5d},{0x9e,0xd5},{0xf8,0x4b},{0x00,0x00},
    {0xf8,0x4d},{0x9e,0xd6},{0x00,0x00},{0x97,0x5e},{0x95,0x58},
    {0x00,0x00},{0xf8,0x4c},{0xf8,0x4e},{0x00,0x00},{0xc5,0xe0},
    {0x00,0x00},{0xf8,0x4a},{0xc5,0xdf},{0xc5,0xe1},{0x9e,0xd7},
    {0x00,0x00},{0x9e,0xd8},{0xf8,0xcb},{0xf8,0xcc},{0xc6,0x44},
    {0xf8,0xca},{0x9e,0xd9},{0xf9,0x53},{0xf9,0x52},{0xf9,0x54},
    {0xc6,0x5f},{0xf9,0x55},{0xc6,0x5e},{0xf9,0x56},{0xf9,0x72},
    {0xf9,0x75},{0xf9,0x74},{0xc6,0x68},{0xf9,0x73},{0x9e,0xda},
    {0x00,0x00},{0x9e,0xdb},{0xc6,0x72},{0xc6,0x70},{0xc6,0x71},
    {0xc6,0x77},{0xf9,0xc0},{0xf9,0xc1},{0xf9,0xbf},{0xf9,0xc9},
    {0x00,0x00},{0x9c,0xf0},{0x8d,0xc1},{0x8d,0xc0},{0x83,0xe1},
    {0x83,0xe0},{0x83,0xe2},{0x83,0xe3},{0x8d,0xc7},{0x8d,0xd9},
    {0x8d,0xd6},{0x84,0xb6},{0x8d,0xd7},{0x00,0x00},{0x84,0xb7},
    {0x84,0xb5},{0x8f,0x46},{0x8d,0xd8},{0x00,0x00},{0x84,0xb4},
    {0x00,0x00},{0x85,0x73},{0x97,0x5f},{0x8d,0xf4},{0x86,0x73},
    {0x85,0x76},{0x85,0x71},{0x8c,0x5d},{0x85,0x74},{0x88,0xae},
    {0x89,0xa1},{0x85,0x78},{0x85,0x77},{0x8d,0x76},{0x84,0xe8},
    {0x85,0x75},{0x8b,0x4f},{0x86,0x6e},{0x8d,0xf7},{0x8d,0xf2},
    {0x8d,0xf3},{0x8d,0xf6},{0x85,0x72},{0x8d,0xf5},{0x8e,0x5a},
    {0x89,0x7e},{0x8e,0x5b},{0x86,0x68},{0x86,0x67},{0x84,0x73},
    {0x8e,0x5c},{0x97,0x60},{0x86,0x6a},{0x86,0x69},{0x8d,0xb2},
    {0x8d,0xa7},{0x8e,0x60},{0x8e,0x5f},{0x86,0x6b},{0x86,0x75},
    {0x86,0x6c},{0x8c,0xb2},{0x86,0x6f},{0x86,0x70},{0x8d,0x44},
    {0x86,0x6d},{0x86,0x76},{0x00,0x00},{0x8e,0x59},{0x86,0x71},
    {0x8e,0x58},{0x86,0x72},{0x8e,0x5e},{0x86,0x74},{0x8c,0xb4},
    {0x00,0x00},{0x88,0xa8},{0x8e,0xa5},{0x8e,0xa4},{0x00,0x00},
    {0x00,0x00},{0x8e,0xa6},{0x8e,0xac},{0x8e,0xd1},{0x97,0x61},
    {0x8c,0x5e},{0x00,0x00},{0x8c,0xb3},{0x87,0x66},{0x88,0xaa},
    {0x97,0x62},{0x8e,0xa7},{0x8f,0xa7},{0x8f,0x6a},{0x87,0x68},
    {0x87,0x6c},{0x8e,0xd5},{0x8e,0xad},{0x00,0x00},{0x8f,0xec},
    {0x87,0x6a},{0x8f,0xcd},{0x8e,0xaa},{0x8e,0xa8},{0x87,0x69},
    {0x87,0x67},{0x89,0xa4},{0x8e,0xa9},{0x87,0x64},{0x8e,0xa3},
    {0x85,0xb6},{0x97,0x63},{0x8f,0xe5},{0x87,0x6b},{0x87,0x65},
    {0x8e,0xab},{0x8c,0xe4},{0x8f,0xee},{0x88,0xa7},{0x00,0x00},
    {0x8f,0x42},{0x8e,0xd2},{0x8b,0xce},{0x8b,0xd5},{0x88,0xa6},
    {0x8b,0x4e},{0x88,0xaf},{0x97,0x64},{0x88,0xa9},{0x8a,0xa2},
    {0x8e,0xd6},{0x8e,0xd7},{0x8c,0x5f},{0x88,0xac},{0x8e,0xd4},
    {0x88,0xad},{0x88,0xa4},{0x8e,0x5d},{0x97,0x65},{0x97,0x66},
    {0x88,0xab},{0x88,0xa5},{0x8e,0xd0},{0x8e,0xd3},{0x8e,0xd8},
    {0x8f,0x44},{0x8f,0x40},{0x8f,0x41},{0x97,0x67},{0x89,0x7d},
    {0x8a,0x7d},{0x8f,0x43},{0x00,0x00},{0x97,0x68},{0x8f,0x45},
    {0x89,0xa7},{0x00,0x00},{0x89,0xa2},{0x89,0xa8},{0x8d,0xa9},
    {0x8a,0xa3},{0x89,0xa5},{0x89,0xa6},{0x00,0x00},{0x90,0xf1},
    {0x8e,0xfd},{0x97,0x69},{0x97,0x6a},{0x8e,0xfe},{0x89,0x7a},
    {0x8a,0x7e},{0x89,0x7b},{0x89,0x7c},{0x89,0xa9},{0x8a,0xa1},
    {0x00,0x00},{0x8f,0x69},{0x8b,0xd3},{0x8f,0x6b},{0x8a,0xa8},
    {0x8f,0x68},{0x8a,0xa5},{0x8a,0xa4},{0x8a,0xa6},{0x8f,0xa8},
    {0x00,0x00},{0x8a,0xa7},{0x97,0x6b},{0x8a,0x7b},{0x8a,0x7c},
    {0x8b,0xd4},{0x00,0x00},{0x8f,0xea},{0x97,0x6c},{0x8a,0x42},
    {0x8b,0x51},{0x00,0x00},{0x8b,0x54},{0x8d,0x7d},{0x00,0x00},
    {0x8c,0xb6},{0x8b,0x50},{0x97,0x6d},{0x8f,0xa9},{0x8b,0x52},
    {0x8b,0x4d},{0x8b,0x53},{0x8f,0xa6},{0x90,0x60},{0x00,0x00},
    {0x8b,0xd1},{0x8b,0xcf},{0x8b,0xd0},{0x8b,0xd2},{0x00,0x00},
    {0x8f,0xc9},{0x8b,0xcb},{0x8b,0xcc},{0x8b,0xcd},{0x8f,0xca},
    {0x00,0x00},{0x8f,0xe8},{0x97,0x6e},{0x8f,0xe9},{0x8f,0xed},
    {0x97,0x6f},{0x8f,0xe6},{0x90,0xa1},{0x8f,0xe7},{0x97,0x70},
    {0x8f,0xcb},{0x8f,0xeb},{0x90,0x61},{0x8c,0xb1},{0x00,0x00},
    {0x8c,0xb5},{0x8c,0xb0},{0x90,0x48},{0x97,0x71},{0x8d,0x43},
    {0x00,0x00},{0x00,0x00},{0x8c,0x7c},{0xaa,0xf8},{0x9e,0xdc},
    {0x00,0x00},{0xd8,0x44},{0xdc,0x78},{0xe8,0xa5},{0xf3,0x76},
    {0x00,0x00},{0x83,0x63},{0xaa,0xf9},{0x00,0x00},{0xad,0xac},
    {0xb0,0x7b},{0x00,0x00},{0x9e,0xdd},{0xd8,0x45},{0x97,0x72},
    {0xd8,0x46},{0xb3,0xac},{0x94,0xdd},{0xb6,0x7d},{0xdc,0x7a},
    {0xdc,0x79},{0xb6,0xa3},{0xb6,0x7c},{0xdc,0x7b},{0xb6,0x7e},
    {0xb6,0xa2},{0xb6,0xa1},{0xb6,0x7b},{0x00,0x00},{0x94,0xde},
    {0xfd,0xbe},{0xb9,0x68},{0x97,0x73},{0x00,0x00},{0xe0,0xd0},
    {0xe0,0xce},{0x00,0x00},{0xe0,0xcf},{0xe0,0xcd},{0x97,0x74},
    {0xbb,0xd2},{0x92,0x6b},{0xbb,0xd5},{0xbb,0xd7},{0xbb,0xd6},
    {0x9e,0xde},{0xfd,0xbf},{0xbb,0xd3},{0xbb,0xd4},{0x9e,0xdf},
    {0xe8,0xa7},{0xe8,0xa6},{0xbe,0x5b},{0xe8,0xa8},{0x00,0x00},
    {0xe8,0xa9},{0xbe,0x5c},{0x97,0x75},{0x00,0x00},{0x00,0x00},
    {0xec,0x4d},{0xec,0x4b},{0xee,0xf3},{0x00,0x00},{0xec,0x49},
    {0xec,0x4a},{0xc0,0x46},{0xec,0x46},{0xec,0x4e},{0xec,0x48},
    {0xec,0x4c},{0xee,0xef},{0x00,0x00},{0x00,0x00},{0xee,0xf1},
    {0x00,0x00},{0xee,0xf2},{0xc1,0xf3},{0xee,0xee},{0xc1,0xf2},
    {0xee,0xf0},{0xc1,0xef},{0xc1,0xf0},{0xc1,0xf1},{0xec,0x47},
    {0x00,0x00},{0x00,0x00},{0xc2,0xf5},{0xf1,0x6e},{0xf1,0x6c},
    {0xf1,0x6d},{0xc2,0xf3},{0xc2,0xf6},{0xc2,0xf4},{0x00,0x00},
    {0x93,0xa7},{0x00,0x00},{0xf3,0x77},{0xf3,0x78},{0xc3,0xf6},
    {0x00,0x00},{0xf5,0x45},{0xf5,0x47},{0xf5,0x46},{0xc4,0xc4},
    {0xc5,0x50},{0xf6,0x6d},{0xf6,0x6c},{0xf6,0x6b},{0x00,0x00},
    {0x00,0x00},{0x83,0x64},{0x83,0xa2},{0x83,0xe4},{0x8d,0xda},
    {0x00,0x00},{0x84,0xb8},{0x83,0xf4},{0x8b,0x56},{0x85,0x7a},
    {0x8a,0xac},{0x85,0x7c},{0x85,0x7e},{0x85,0x7d},{0x85,0x79},
    {0x8d,0xf8},{0x84,0xdd},{0x86,0x77},{0x88,0xc1},{0x87,0x6e},
    {0x87,0x47},{0x90,0x49},{0x87,0x6f},{0x88,0xb0},{0x00,0x00},
    {0x87,0x71},{0x87,0x70},{0x87,0x6d},{0x8e,0xda},{0x90,0xac},
    {0x88,0xb1},{0x8e,0xd9},{0x00,0x00},{0x8f,0x48},{0x8f,0x49},
    {0x8f,0x4a},{0x8f,0xb0},{0x8f,0x4b},{0x8f,0x4c},{0x89,0xaa},
    {0x8f,0x47},{0x8c,0x60},{0x8a,0xab},{0x8f,0x6c},{0x00,0x00},
    {0x8a,0xa9},{0x8a,0xaa},{0x8b,0x55},{0x8b,0x57},{0x00,0x00},
    {0x8b,0x58},{0x8f,0xef},{0x00,0x00},{0xaa,0xfa},{0x9c,0xf1},
    {0xc9,0xaa},{0x85,0xa1},{0xca,0x58},{0xa6,0xe9},{0xca,0x56},
    {0xca,0x59},{0xca,0x57},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0xcb,0xae},{0x00,0x00},{0xa8,0xc1},{0x00,0x00},{0xa8,0xc2},
    {0xcb,0xb0},{0xa8,0xbf},{0xcb,0xaf},{0xcb,0xad},{0xa8,0xc0},
    {0xa8,0xbe},{0x85,0xa3},{0x84,0xbb},{0x83,0xe5},{0x85,0xa2},
    {0x00,0x00},{0xfd,0xc1},{0xcd,0xd8},{0xcd,0xdb},{0xaa,0xfd},
    {0xcd,0xda},{0xcd,0xd9},{0x00,0x00},{0xaa,0xfc},{0xaa,0xfb},
    {0xfe,0x42},{0xab,0x40},{0xcd,0xdc},{0xaa,0xfe},{0x87,0x72},
    {0x84,0xba},{0x8b,0xd8},{0x84,0xb9},{0x83,0xe7},{0xd0,0xc6},
    {0xad,0xae},{0xad,0xaf},{0xad,0xb0},{0xd0,0xc7},{0xd0,0xc3},
    {0xad,0xad},{0xd0,0xc4},{0x00,0x00},{0xd0,0xc5},{0xd0,0xc2},
    {0x83,0xe6},{0x9e,0xe0},{0x00,0x00},{0xb0,0xa4},{0x00,0x00},
    {0x00,0x00},{0xb0,0xa1},{0xd4,0x45},{0xb0,0xa2},{0xb0,0xa5},
    {0xd4,0x46},{0x00,0x00},{0xb0,0x7e},{0xb0,0x7c},{0xb0,0x7d},
    {0xb0,0xa3},{0x92,0x67},{0x97,0x76},{0x8d,0xf9},{0x86,0x78},
    {0x89,0xac},{0xb3,0xad},{0xd8,0x49},{0xb3,0xb5},{0xd8,0x48},
    {0x00,0x00},{0xd8,0x4b},{0xb3,0xb1},{0xd8,0x4a},{0xb6,0xab},
    {0xb3,0xaf},{0xb3,0xb2},{0xb3,0xae},{0xb3,0xb3},{0xb3,0xb4},
    {0xb3,0xb0},{0x00,0x00},{0x92,0xb4},{0x9e,0xe1},{0xd8,0x47},
    {0xb6,0xa7},{0xdc,0x7d},{0x00,0x00},{0xdc,0xa3},{0xfd,0xc5},
    {0x00,0x00},{0xdc,0xa2},{0xb6,0xac},{0xb6,0xa8},{0xb6,0xa9},
    {0xdc,0x7c},{0xdc,0x7e},{0xdc,0xa1},{0xb6,0xa4},{0xb6,0xa6},
    {0x00,0x00},{0xb6,0xaa},{0xb6,0xa5},{0x92,0xfa},{0x8a,0xad},
    {0xe0,0xd3},{0xe0,0xd1},{0xe0,0xd2},{0xb9,0x6a},{0xb9,0x6b},
    {0xfd,0xc4},{0xe0,0xd4},{0xb9,0x69},{0xbb,0xd8},{0x00,0x00},
    {0xbb,0xda},{0xbb,0xd9},{0x97,0x77},{0xe4,0xbb},{0x00,0x00},
    {0x92,0x47},{0xe4,0xbc},{0xe8,0xab},{0x95,0xf9},{0xe8,0xaa},
    {0x9e,0xe2},{0x00,0x00},{0xc0,0x47},{0xc0,0x48},{0xec,0x4f},
    {0xc0,0x49},{0x00,0x00},{0xee,0xf6},{0x00,0x00},{0xee,0xf4},
    {0x97,0x78},{0xee,0xf5},{0xc1,0xf4},{0x97,0x79},{0xf1,0x6f},
    {0xc3,0xf7},{0x00,0x00},{0xc6,0xd7},{0x95,0xfb},{0xc1,0xf5},
    {0xab,0x41},{0x00,0x00},{0xb0,0xa6},{0xd4,0x47},{0x86,0x79},
    {0x8b,0xd9},{0xd8,0x4c},{0xb3,0xb6},{0xb6,0xad},{0xdc,0xa4},
    {0xdc,0xa6},{0xb6,0xaf},{0xb6,0xae},{0xb6,0xb0},{0xb6,0xb1},
    {0xdc,0xa5},{0xb9,0x6e},{0xb9,0x6f},{0xb9,0x6d},{0xbb,0xdb},
    {0xb9,0x6c},{0xe0,0xd5},{0x8b,0x5b},{0x00,0x00},{0x92,0xca},
    {0xbb,0xdc},{0xe8,0xac},{0xec,0x50},{0xc0,0x4a},{0xc1,0xf6},
    {0xf1,0x70},{0xf1,0x74},{0xc2,0xf9},{0xf1,0x71},{0xc2,0xfa},
    {0xc2,0xf8},{0xf1,0x75},{0xc2,0xfb},{0xf1,0x73},{0x90,0x6d},
    {0xf3,0x79},{0xc2,0xf7},{0xc3,0xf8},{0x00,0x00},{0xf8,0xcd},
    {0x00,0x00},{0x00,0x00},{0xab,0x42},{0xb3,0xb8},{0xb3,0xb7},
    {0x94,0x48},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0xb6,0xb2},
    {0xdc,0xa8},{0xdc,0xa7},{0xb6,0xb3},{0x8d,0x5e},{0x9e,0xe3},
    {0xe0,0xd9},{0xb9,0x73},{0xb9,0x70},{0xe0,0xd8},{0xb9,0x72},
    {0xe0,0xd6},{0xb9,0x71},{0x00,0x00},{0xe0,0xd7},{0x8b,0xda},
    {0xe4,0xbd},{0xbb,0xdd},{0x8c,0xe6},{0xe8,0xaf},{0xfd,0xc7},
    {0xbe,0x5d},{0xe8,0xad},{0xbe,0x5e},{0xbe,0x5f},{0xe8,0xae},
    {0xbe,0x60},{0x93,0xed},{0xec,0x51},{0x00,0x00},{0xc0,0x4e},
    {0xc0,0x4b},{0xc0,0x50},{0xec,0x53},{0xc0,0x4c},{0xec,0x52},
    {0xc0,0x4f},{0x00,0x00},{0x00,0x00},{0xc0,0x4d},{0x00,0x00},
    {0xee,0xf9},{0xee,0xfb},{0x00,0x00},{0x9e,0xe4},{0xc1,0xf7},
    {0xee,0xfa},{0xc1,0xf8},{0xee,0xf8},{0xee,0xf7},{0xfd,0xc8},
    {0xf1,0x77},{0xf1,0x76},{0xc2,0xfc},{0xf1,0x78},{0xf3,0x7e},
    {0xc3,0xfa},{0xf3,0x7d},{0xf3,0x7a},{0xc3,0xf9},{0xf3,0x7b},
    {0xf3,0x7c},{0x8d,0x60},{0xf5,0x48},{0xf5,0x49},{0xc4,0xc5},
    {0xfd,0xc9},{0xc5,0x53},{0x97,0x7a},{0x9d,0xbb},{0xf6,0x6e},
    {0x9e,0xe5},{0x00,0x00},{0xc5,0x51},{0xc5,0x52},{0xf6,0x6f},
    {0x97,0x7b},{0x00,0x00},{0xc5,0xb4},{0xc5,0xb5},{0xf7,0x71},
    {0x9e,0xe6},{0x9e,0xe7},{0xc6,0x45},{0xf8,0xcf},{0xc6,0x47},
    {0x00,0x00},{0xf8,0xce},{0xf8,0xd0},{0xc6,0x46},{0xf9,0x57},
    {0x00,0x00},{0xf9,0xad},{0x00,0x00},{0x97,0x7c},{0x00,0x00},
    {0x97,0x7d},{0x00,0x00},{0x97,0x7e},{0xab,0x43},{0x8e,0xdb},
    {0x00,0x00},{0x97,0xa1},{0xb9,0x74},{0x9e,0xe8},{0xe4,0xbe},
    {0x93,0x43},{0xe8,0xb0},{0xc0,0x51},{0xc0,0x52},{0xfe,0x6d},
    {0xab,0x44},{0xfd,0xca},{0xbe,0x61},{0xc3,0xfb},{0xad,0xb1},
    {0x00,0x00},{0x97,0xa2},{0x8d,0x45},{0xc0,0x53},{0x00,0x00},
    {0xc5,0xe2},{0xad,0xb2},{0xd8,0x4d},{0x97,0xa3},{0xdc,0xa9},
    {0x95,0xf7},{0xdc,0xab},{0x00,0x00},{0xdc,0xaa},{0x97,0xa4},
    {0xe0,0xdd},{0xe0,0xda},{0xb9,0x75},{0x00,0x00},{0xb9,0x76},
    {0xe0,0xdb},{0xe0,0xdc},{0x94,0xdf},{0xe4,0xc0},{0xe4,0xc5},
    {0xbb,0xde},{0xe4,0xbf},{0xe4,0xc1},{0xe4,0xc8},{0xe4,0xc3},
    {0xe4,0xc7},{0xe4,0xc4},{0xe4,0xc2},{0xe4,0xc6},{0xbb,0xdf},
    {0x94,0xe0},{0x9e,0xe9},{0xe8,0xb3},{0x9e,0xea},{0xe8,0xb1},
    {0xbe,0x63},{0x00,0x00},{0xbe,0x62},{0xe8,0xb2},{0xbe,0x64},
    {0x94,0xe1},{0x8c,0xe7},{0x97,0xa5},{0x00,0x00},{0xec,0x56},
    {0x00,0x00},{0x00,0x00},{0xec,0x55},{0xc0,0x54},{0xec,0x54},
    {0xee,0xfc},{0x9e,0xeb},{0xee,0xfe},{0xef,0x41},{0xef,0x40},
    {0xfd,0xcb},{0xc1,0xf9},{0xee,0xfd},{0xf1,0xa1},{0xc2,0xfd},
    {0xf1,0x7d},{0xf1,0xa2},{0xc2,0xfe},{0x00,0x00},{0xf1,0x7b},
    {0x00,0x00},{0xf1,0x7e},{0xf1,0x7c},{0xf1,0x79},{0xc3,0x40},
    {0xf1,0x7a},{0x8d,0x7e},{0x00,0x00},{0x9e,0xec},{0x97,0xa6},
    {0xf3,0xa1},{0xfd,0xcc},{0x00,0x00},{0xf3,0xa3},{0xf3,0xa2},
    {0xfd,0xcd},{0xf5,0x4a},{0xfd,0xce},{0xf5,0x4b},{0x00,0x00},
    {0x9e,0xed},{0xfd,0xcf},{0xf6,0x70},{0x9e,0xee},{0xc5,0xb7},
    {0x9e,0xef},{0xc5,0xb6},{0xf8,0x4f},{0xf8,0x50},{0xc6,0x48},
    {0xf8,0xd1},{0xfd,0xd0},{0xc6,0x69},{0x00,0x00},{0xad,0xb3},
    {0xb6,0xb4},{0xe4,0xca},{0xe4,0xc9},{0xe8,0xb5},{0xe8,0xb4},
    {0x00,0x00},{0x9e,0xf0},{0xc1,0xfa},{0xef,0x43},{0xef,0x42},
    {0xf1,0xa5},{0xf1,0xa3},{0xf1,0xa6},{0xf1,0xa4},{0x00,0x00},
    {0x00,0x00},{0xc3,0xfc},{0xf3,0xa4},{0xf3,0xa5},{0xf3,0xa6},
    {0x9e,0xf1},{0xf6,0x71},{0x00,0x00},{0xf7,0x72},{0x00,0x00},
    {0xf8,0xd2},{0x83,0xa3},{0x85,0xa4},{0x00,0x00},{0x8a,0xb0},
    {0x8f,0xab},{0x8f,0xce},{0x8b,0xdb},{0xad,0xb4},{0x95,0x61},
    {0x00,0x00},{0xec,0x57},{0xef,0x44},{0x97,0xa7},{0xad,0xb5},
    {0x00,0x00},{0x8b,0xdc},{0xbb,0xe0},{0x00,0x00},{0xec,0x58},
    {0xc3,0x41},{0xf1,0xa7},{0xc3,0xfd},{0x00,0x00},{0xf5,0x4c},
    {0xf5,0x4d},{0xc5,0x54},{0xf8,0x51},{0xad,0xb6},{0xb3,0xbb},
    {0xb3,0xbc},{0xd8,0x4e},{0xb6,0xb5},{0xb6,0xb6},{0xdc,0xac},
    {0xb6,0xb7},{0x00,0x00},{0xb9,0x7a},{0x00,0x00},{0xb9,0x7c},
    {0xe0,0xdf},{0xe0,0xe0},{0xe0,0xde},{0xb9,0x77},{0xb9,0x78},
    {0xb9,0x7b},{0xb9,0x79},{0x9e,0xf2},{0x9e,0xf3},{0xe4,0xcb},
    {0xbb,0xe1},{0xbb,0xe2},{0x00,0x00},{0x82,0x5b},{0xe8,0xbc},
    {0xbe,0x67},{0xe8,0xb7},{0xe8,0xb6},{0xfd,0xd2},{0xe8,0xbb},
    {0xbe,0x65},{0x00,0x00},{0x9e,0xf4},{0xc0,0x5b},{0x00,0x00},
    {0xe8,0xb8},{0xe8,0xbd},{0xe8,0xba},{0xe8,0xb9},{0x00,0x00},
    {0xbe,0x66},{0x82,0x7b},{0xc0,0x59},{0xfd,0xd3},{0xec,0x5a},
    {0xc0,0x55},{0x00,0x00},{0xec,0x5b},{0x9e,0xf5},{0x82,0x42},
    {0xec,0x59},{0x00,0x00},{0xc0,0x58},{0xc0,0x56},{0xc0,0x5a},
    {0x00,0x00},{0xc0,0x57},{0x93,0xdf},{0x97,0xa8},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0xef,0x45},{0x00,0x00},{0xef,0x4a},
    {0xef,0x46},{0xef,0x49},{0xc1,0xfb},{0xfd,0xd5},{0xed,0xd4},
    {0xef,0x48},{0xef,0x47},{0xfd,0xd6},{0xc3,0x44},{0xc3,0x42},
    {0xc3,0x45},{0xc3,0x43},{0xf1,0xa8},{0xf1,0xa9},{0xf1,0xaa},
    {0xc3,0x46},{0x97,0xa9},{0x92,0xb8},{0x9d,0xd2},{0xf3,0xaa},
    {0xc4,0x40},{0xf3,0xa8},{0x00,0x00},{0xc4,0x41},{0xf3,0xa7},
    {0xf3,0xa9},{0xc3,0xfe},{0xf5,0x51},{0xf5,0x4e},{0x00,0x00},
    {0xf5,0x4f},{0xf5,0x50},{0xf6,0x72},{0xc5,0x56},{0xfd,0xd7},
    {0xc5,0x55},{0x9e,0xf6},{0xf7,0x74},{0xf7,0x73},{0xc5,0xb8},
    {0xfd,0xd8},{0x00,0x00},{0x00,0x00},{0xc5,0xe3},{0xc6,0x49},
    {0xc6,0x60},{0xf9,0x58},{0xf9,0xae},{0xf9,0xaf},{0x83,0xa4},
    {0x84,0xbc},{0x84,0xbd},{0x8d,0xfa},{0x85,0xa5},{0x85,0xa6},
    {0x85,0xa7},{0x86,0x7e},{0x86,0x7c},{0x8c,0xb8},{0x86,0x7d},
    {0x8e,0x62},{0x86,0xa1},{0x86,0xa2},{0x8e,0x61},{0x86,0x7b},
    {0x8d,0x77},{0x87,0x74},{0x87,0x73},{0x89,0xb0},{0x88,0xb3},
    {0x89,0xaf},{0x00,0x00},{0x88,0xb4},{0x8e,0xba},{0x00,0x00},
    {0x8e,0xdc},{0x89,0xb5},{0x89,0xb1},{0x00,0x00},{0x89,0xb4},
    {0x89,0xb2},{0x00,0x00},{0x89,0x46},{0x8a,0xb1},{0x8b,0x5f},
    {0x00,0x00},{0x8b,0x60},{0x8b,0x61},{0x8b,0x5e},{0x8b,0x5d},
    {0x90,0xa7},{0x8f,0xf0},{0x8b,0xde},{0x8f,0xcf},{0x8c,0xb9},
    {0x00,0x00},{0x8c,0xe9},{0x97,0xaa},{0x8d,0x61},{0x90,0xa8},
    {0xad,0xb7},{0xdc,0xad},{0x94,0xe2},{0x00,0x00},{0xe0,0xe1},
    {0xe4,0xcc},{0xe4,0xcd},{0xbb,0xe3},{0x00,0x00},{0xbb,0xe4},
    {0xe8,0xbe},{0xbe,0x68},{0xfd,0xd9},{0x00,0x00},{0xc1,0xfc},
    {0x9e,0xf7},{0xf1,0xab},{0x9e,0xf8},{0xc3,0x47},{0xf3,0xad},
    {0xc4,0x42},{0xf3,0xac},{0xf3,0xae},{0xf3,0xab},{0xf6,0x75},
    {0xf5,0x52},{0xf5,0x53},{0x97,0xab},{0xc4,0xc6},{0x00,0x00},
    {0xf6,0x74},{0x9e,0xf9},{0xfb,0xb2},{0xf6,0x73},{0x9e,0xfa},
    {0xf7,0x75},{0xf9,0xb0},{0x00,0x00},{0x83,0xa5},{0x00,0x00},
    {0x00,0x00},{0x8e,0xae},{0x87,0x75},{0x8a,0xb2},{0x00,0x00},
    {0x8b,0xdf},{0x00,0x00},{0x00,0x00},{0x8c,0x61},{0x90,0x4a},
    {0x97,0xac},{0xad,0xb8},{0xfd,0xdb},{0x00,0x00},{0x83,0xa6},
    {0xad,0xb9},{0x9e,0xfb},{0x9e,0xfc},{0xb0,0xa7},{0xd4,0x48},
    {0x00,0x00},{0xd8,0x4f},{0xfd,0xdc},{0xb6,0xb8},{0x8c,0xba},
    {0xb6,0xbb},{0xb6,0xb9},{0xdc,0xae},{0x9e,0xfd},{0xb6,0xbd},
    {0x97,0xad},{0xb6,0xba},{0x00,0x00},{0x95,0xda},{0xb6,0xbc},
    {0x00,0x00},{0xb9,0x7e},{0x9e,0xfe},{0xe0,0xe2},{0x00,0x00},
    {0x00,0x00},{0xe0,0xe3},{0xe8,0xc0},{0x00,0x00},{0xb9,0x7d},
    {0xb9,0xa1},{0xb9,0xa2},{0x00,0x00},{0xe4,0xcf},{0x00,0x00},
    {0xe4,0xce},{0xbb,0xe5},{0x00,0x00},{0xbb,0xe6},{0x00,0x00},
    {0xe4,0xd0},{0xe8,0xbf},{0xbb,0xe8},{0xbe,0x69},{0x00,0x00},
    {0xbb,0xe7},{0x8d,0x47},{0x9f,0x70},{0x00,0x00},{0xc0,0x5c},
    {0xe8,0xc1},{0xbe,0x6b},{0xbe,0x6a},{0xe8,0xc2},{0xe8,0xc5},
    {0xe8,0xc3},{0xe8,0xc4},{0xbe,0x6c},{0x9f,0x71},{0xc0,0x61},
    {0xc0,0x5f},{0x9f,0x72},{0x97,0xae},{0xc0,0x5e},{0xec,0x5d},
    {0x97,0xaf},{0xc0,0x60},{0x00,0x00},{0x00,0x00},{0xec,0x5c},
    {0xef,0x4b},{0x00,0x00},{0xec,0x5e},{0xc0,0x5d},{0xec,0x5f},
    {0xef,0x4e},{0xef,0x4c},{0xef,0x4d},{0xef,0x52},{0xc3,0x4b},
    {0xef,0x51},{0xef,0x54},{0xef,0x53},{0xef,0x50},{0xef,0x4f},
    {0x00,0x00},{0xc1,0xfd},{0x00,0x00},{0x9f,0x73},{0xa0,0x44},
    {0xfd,0xde},{0xf1,0xae},{0xfd,0xdf},{0xf1,0xad},{0xc3,0x4a},
    {0xc3,0x48},{0xc3,0x49},{0xfb,0xb3},{0xf1,0xac},{0xfd,0xdd},
    {0xf3,0xb1},{0x00,0x00},{0xc4,0x43},{0x00,0x00},{0xf3,0xb0},
    {0xf3,0xaf},{0xc4,0x44},{0xfd,0xe1},{0xf5,0x58},{0xf5,0x57},
    {0xfb,0xb4},{0xf5,0x55},{0x00,0x00},{0xf5,0x54},{0xc4,0xc8},
    {0xc4,0xc7},{0xf5,0x59},{0xf7,0x76},{0xc5,0xb9},{0xf6,0x77},
    {0xc5,0x57},{0xf6,0x76},{0xf5,0x56},{0x00,0x00},{0xf7,0x77},
    {0xc5,0xe4},{0x9f,0x74},{0xc6,0x61},{0xf9,0x59},{0x00,0x00},
    {0xf9,0xb1},{0x9f,0x75},{0x97,0xb0},{0x00,0x00},{0x83,0xe8},
    {0x00,0x00},{0x8f,0x6d},{0x85,0xaa},{0x8f,0xac},{0x85,0xa8},
    {0x8d,0xfb},{0x85,0xac},{0x85,0xa9},{0x85,0xab},{0x89,0xb7},
    {0x86,0xa6},{0x86,0xa5},{0x86,0xa3},{0x00,0x00},{0x86,0xa4},
    {0x87,0x78},{0x8c,0x62},{0x87,0x79},{0x00,0x00},{0x00,0x00},
    {0x87,0x76},{0x00,0x00},{0x87,0x77},{0x8e,0xdd},{0x00,0x00},
    {0x88,0xb6},{0x97,0xb1},{0x88,0xb7},{0x00,0x00},{0x00,0x00},
    {0x89,0xb8},{0x89,0xb9},{0x89,0xb6},{0x97,0xb2},{0x8b,0x64},
    {0x00,0x00},{0x8b,0x63},{0x8d,0x78},{0x00,0x00},{0x97,0xb3},
    {0x00,0x00},{0x8b,0x62},{0x8f,0xd0},{0x8b,0xe1},{0x8b,0xe0},
    {0x97,0xb4},{0x8f,0xf1},{0x97,0xb5},{0xad,0xba},{0xd8,0x50},
    {0xef,0x55},{0xad,0xbb},{0x00,0x00},{0x9f,0x76},{0xe4,0xd2},
    {0xe4,0xd1},{0xec,0x60},{0x00,0x00},{0x00,0x00},{0xef,0x57},
    {0x00,0x00},{0xef,0x56},{0x9f,0x77},{0xc3,0x4c},{0xf3,0xb2},
    {0xf3,0xb3},{0xc4,0xc9},{0x00,0x00},{0x9f,0x78},{0xf9,0xb2},
    {0xb0,0xa8},{0xb6,0xbf},{0xb6,0xbe},{0xe0,0xe4},{0xe0,0xe6},
    {0xb9,0xa4},{0xe0,0xe5},{0xb9,0xa3},{0xb9,0xa5},{0xe0,0xe7},
    {0x00,0x00},{0x00,0x00},{0x9f,0x79},{0xe4,0xd4},{0xe4,0xd6},
    {0xe4,0xd5},{0x97,0xb6},{0xe4,0xd8},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0xbb,0xe9},{0xe4,0xd7},{0xe4,0xd3},{0x94,0x4b},
    {0x92,0x4a},{0x92,0xa3},{0xe4,0xd9},{0x97,0xb7},{0xe8,0xcc},
    {0x00,0x00},{0xe8,0xcf},{0xe8,0xd1},{0xe8,0xc7},{0xe8,0xcb},
    {0xe8,0xc8},{0xbe,0x6e},{0xbe,0x71},{0xbe,0x73},{0xe8,0xc9},
    {0xe8,0xca},{0xbe,0x72},{0xe8,0xcd},{0xe8,0xd0},{0xe8,0xce},
    {0xbe,0x74},{0xfd,0xe4},{0xbe,0x70},{0xe8,0xc6},{0xbe,0x6d},
    {0x00,0x00},{0xbe,0x6f},{0x9f,0x7a},{0x95,0xc4},{0xc0,0x63},
    {0xec,0x66},{0xec,0x64},{0xec,0x63},{0x9f,0x7b},{0xec,0x69},
    {0x00,0x00},{0xec,0x68},{0xec,0x67},{0x00,0x00},{0xec,0x62},
    {0xc0,0x62},{0xec,0x61},{0x00,0x00},{0xec,0x65},{0xc0,0x64},
    {0x97,0xb8},{0x00,0x00},{0xef,0x5a},{0x9f,0x7c},{0xef,0x5e},
    {0xef,0x5b},{0xef,0x5d},{0xef,0x5c},{0xef,0x59},{0xef,0x5f},
    {0xef,0x62},{0xef,0x60},{0xef,0x61},{0xc2,0x40},{0x00,0x00},
    {0xc1,0xfe},{0xef,0x58},{0xef,0x63},{0xf1,0xb3},{0xf1,0xb6},
    {0xf1,0xb8},{0xf1,0xb7},{0x00,0x00},{0xf1,0xb1},{0xf1,0xb5},
    {0xf1,0xb0},{0xfb,0xb5},{0xf1,0xb2},{0xc3,0x4d},{0xf1,0xaf},
    {0x95,0xe1},{0xf1,0xb4},{0x93,0x5d},{0x92,0xb9},{0xf3,0xc0},
    {0xf3,0xb5},{0xc4,0x45},{0x00,0x00},{0x00,0x00},{0xc4,0x46},
    {0xf3,0xb4},{0xf3,0xb9},{0xf3,0xbf},{0xf3,0xb7},{0xf3,0xbe},
    {0x9f,0x7d},{0xf3,0xbb},{0x9a,0xfb},{0xf3,0xba},{0xf3,0xbd},
    {0xf3,0xb8},{0xf3,0xb6},{0x9a,0xfc},{0xf3,0xbc},{0x82,0x55},
    {0xf5,0x60},{0xf5,0x5e},{0xc4,0xca},{0xf5,0x5d},{0xf5,0x63},
    {0xf5,0x61},{0x9a,0xfd},{0xc4,0xcb},{0xf5,0x5c},{0xf5,0x5a},
    {0x00,0x00},{0xf5,0x5b},{0xc4,0xcd},{0xf5,0x5f},{0xc4,0xcc},
    {0xf5,0x62},{0xf6,0x78},{0xf6,0x7e},{0x9c,0xfa},{0x9c,0xfb},
    {0xf6,0x79},{0xc5,0x5b},{0xf6,0xa1},{0xc5,0x5a},{0xf6,0x7d},
    {0xf6,0x7c},{0xc5,0x59},{0xf6,0x7b},{0xc5,0x58},{0xf6,0x7a},
    {0x00,0x00},{0xf7,0x7d},{0xf7,0xa1},{0xf7,0x7e},{0x00,0x00},
    {0xf7,0x7b},{0xc5,0xbb},{0xf7,0x78},{0xf7,0x7c},{0xf7,0xa3},
    {0x00,0x00},{0xf7,0xa2},{0xf7,0x79},{0xf7,0x7a},{0xc5,0xba},
    {0xf8,0x52},{0xc5,0xe7},{0x9c,0xfc},{0xf8,0x53},{0xc5,0xe5},
    {0xc5,0xe6},{0x9c,0xfd},{0x00,0x00},{0xf8,0xd3},{0xc6,0x4a},
    {0xf9,0x76},{0x00,0x00},{0xc6,0x6a},{0x9c,0xfe},{0xf9,0xb3},
    {0xc6,0x6b},{0xf9,0xb4},{0xf9,0xb5},{0xf9,0xc3},{0xf9,0xc2},
    {0xc6,0x7a},{0xf9,0xcd},{0x83,0xe9},{0x85,0xae},{0x86,0xa8},
    {0x86,0xa9},{0x86,0xa7},{0x8c,0xbb},{0x00,0x00},{0x87,0x7a},
    {0x8d,0xa1},{0x8e,0xde},{0x88,0xbb},{0x88,0xba},{0x88,0xbf},
    {0x88,0xbe},{0x8f,0xf2},{0x88,0xb9},{0x88,0xb8},{0x88,0xbc},
    {0x88,0xbd},{0x8d,0x49},{0x8e,0xdf},{0x8c,0xeb},{0x88,0x4c},
    {0x00,0x00},{0x8c,0xea},{0x90,0x63},{0x89,0xbc},{0x89,0xba},
    {0x89,0xbb},{0x00,0x00},{0x8d,0xaf},{0x8a,0xb3},{0x8d,0x4a},
    {0x00,0x00},{0x00,0x00},{0x8a,0xb4},{0x8f,0xad},{0x8b,0x65},
    {0x8f,0xae},{0x8f,0xaf},{0x00,0x00},{0x00,0x00},{0x90,0x4c},
    {0x8b,0xe3},{0x8f,0xf5},{0x00,0x00},{0x8c,0x66},{0x8b,0xe2},
    {0x90,0x4d},{0x8f,0xf3},{0x8c,0x64},{0x8f,0xf4},{0x8c,0xbc},
    {0x8c,0xbe},{0x90,0x4b},{0x90,0x62},{0x8d,0x62},{0x8d,0xa2},
    {0x00,0x00},{0x90,0xa9},{0xb0,0xa9},{0x00,0x00},{0x00,0x00},
    {0xe0,0xe9},{0x00,0x00},{0xe0,0xe8},{0x00,0x00},{0xbb,0xea},
    {0xbb,0xeb},{0xe4,0xda},{0x9d,0xb0},{0xe8,0xd2},{0xec,0x6c},
    {0x00,0x00},{0x97,0xb9},{0xbe,0x75},{0xc0,0x65},{0xec,0x6a},
    {0xfd,0xe6},{0xec,0x6d},{0xc0,0x66},{0xfd,0xe7},{0xef,0x64},
    {0xec,0x6b},{0xf1,0xb9},{0xc3,0x4e},{0xf3,0xc1},{0x00,0x00},
    {0x92,0xfb},{0x8c,0xbf},{0xf5,0x66},{0xf5,0x64},{0x00,0x00},
    {0x00,0x00},{0xf5,0x65},{0x8d,0x79},{0x90,0x79},{0xf6,0xa2},
    {0x00,0x00},{0xc5,0x5c},{0xf7,0xa4},{0xc5,0xea},{0xc5,0xbc},
    {0xc5,0xe8},{0xc5,0xe9},{0xf8,0xd4},{0xc6,0x62},{0xfb,0xb6},
    {0xb0,0xaa},{0x97,0xba},{0x00,0x00},{0x00,0x00},{0xf1,0xba},
    {0x00,0x00},{0x97,0xbb},{0xd4,0x49},{0x9d,0xb1},{0xb9,0xa6},
    {0xfd,0xec},{0xe4,0xdb},{0x00,0x00},{0x00,0x00},{0xbb,0xec},
    {0xe4,0xdc},{0x00,0x00},{0x00,0x00},{0x93,0xba},{0xe8,0xd4},
    {0xe8,0xd3},{0xc0,0x68},{0xbe,0x76},{0xbe,0x77},{0x00,0x00},
    {0xe8,0xd7},{0xe8,0xd6},{0xe8,0xd5},{0xfe,0x57},{0x00,0x00},
    {0xec,0x6e},{0xec,0x71},{0x00,0x00},{0xec,0x70},{0xec,0x6f},
    {0xc0,0x67},{0xef,0x68},{0xef,0x66},{0xef,0x65},{0xfd,0xee},
    {0x00,0x00},{0xef,0x67},{0xfd,0xed},{0xc3,0x4f},{0xf1,0xbc},
    {0xf1,0xbd},{0xc3,0x50},{0x00,0x00},{0xf1,0xbb},{0xfd,0xf0},
    {0xf3,0xc3},{0xf3,0xc2},{0xf3,0xc5},{0xc4,0x47},{0xf3,0xc4},
    {0x97,0xbc},{0xf5,0x67},{0xf5,0x69},{0xf5,0x68},{0x8d,0x63},
    {0x9d,0xb2},{0xf6,0xa3},{0xf6,0xa6},{0xf6,0xa4},{0xf6,0xa5},
    {0xf7,0xa5},{0xc5,0xbd},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0xf8,0x54},{0xf8,0x55},{0xf8,0x56},{0x00,0x00},{0xc6,0x4b},
    {0xc6,0x63},{0xf9,0xb6},{0xb0,0xab},{0x00,0x00},{0xbe,0x78},
    {0xc0,0x69},{0xf1,0xbe},{0xfd,0xe9},{0xf7,0xa6},{0x00,0x00},
    {0xfd,0xeb},{0xf9,0xc4},{0xd4,0x4a},{0x00,0x00},{0xc6,0x7b},
    {0xb0,0xac},{0xec,0x72},{0x9d,0xb3},{0xf1,0xbf},{0x00,0x00},
    {0xf3,0xc6},{0x00,0x00},{0x9d,0xb4},{0xf6,0xa7},{0xf7,0xa7},
    {0xb0,0xad},{0x00,0x00},{0xe4,0xdd},{0xe4,0xde},{0x9d,0xb5},
    {0xbb,0xed},{0xbb,0xee},{0xe8,0xd9},{0xbe,0x7a},{0xbe,0x79},
    {0xe8,0xd8},{0x8d,0x64},{0xef,0x69},{0x97,0xbd},{0xf1,0xc0},
    {0xf1,0xc2},{0xf1,0xc1},{0xc3,0x53},{0xc3,0x52},{0xc3,0x51},
    {0x9d,0xb6},{0xc5,0x5e},{0xf6,0xa8},{0x00,0x00},{0xc5,0x5d},
    {0xf7,0xa9},{0xf7,0xa8},{0x00,0x00},{0xc6,0x4c},{0xf8,0xd5},
    {0xb3,0xbd},{0xe0,0xea},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0xe4,0xe1},{0xe4,0xdf},{0xe4,0xe0},{0x00,0x00},{0x00,0x00},
    {0xe8,0xe2},{0x00,0x00},{0xe8,0xdd},{0xe8,0xda},{0xe8,0xe1},
    {0xfe,0xaf},{0x00,0x00},{0x00,0x00},{0xe8,0xe3},{0x00,0x00},
    {0x00,0x00},{0xbe,0x7c},{0xe8,0xe0},{0xe8,0xdc},{0x97,0xbe},
    {0x00,0x00},{0xe8,0xdb},{0xe8,0xdf},{0xe8,0xde},{0xbe,0x7b},
    {0x00,0x00},{0x00,0x00},{0xec,0x7d},{0xec,0x78},{0xec,0x76},
    {0xec,0xa1},{0xec,0x77},{0x9d,0xb7},{0xec,0x73},{0x9d,0xee},
    {0xec,0x79},{0x97,0xbf},{0x00,0x00},{0xec,0x74},{0xef,0x72},
    {0xec,0x75},{0xec,0xa2},{0x00,0x00},{0x00,0x00},{0x9d,0xef},
    {0x00,0x00},{0x9d,0xf0},{0x94,0xfe},{0xfd,0xf3},{0xec,0x7c},
    {0xc0,0x6a},{0xec,0x7b},{0xec,0x7a},{0x00,0x00},{0xec,0x7e},
    {0x94,0xe3},{0x94,0xe4},{0x00,0x00},{0x00,0x00},{0xef,0x6a},
    {0xef,0x6d},{0x00,0x00},{0xfd,0xf4},{0xef,0x6c},{0x97,0xc0},
    {0xef,0x74},{0xef,0x6f},{0xef,0x73},{0x00,0x00},{0xef,0x71},
    {0xef,0x70},{0xef,0x6e},{0x00,0x00},{0xef,0x6b},{0x00,0x00},
    {0xc2,0x43},{0xc2,0x42},{0x00,0x00},{0xc2,0x44},{0xc2,0x41},
    {0xef,0x75},{0xfd,0xf5},{0x94,0xf5},{0x00,0x00},{0x00,0x00},
    {0x94,0xe5},{0xf1,0xc8},{0xf1,0xcb},{0x00,0x00},{0xf1,0xc9},
    {0xf1,0xcd},{0x00,0x00},{0x97,0xc1},{0x00,0x00},{0xf1,0xce},
    {0x00,0x00},{0xf1,0xc6},{0xc3,0x58},{0xf1,0xc7},{0x00,0x00},
    {0xf1,0xc5},{0xf1,0xcc},{0x00,0x00},{0xf1,0xc4},{0xf1,0xc3},
    {0xc3,0x57},{0xc3,0x55},{0xc3,0x54},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x94,0xe6},{0x00,0x00},{0x94,0xe7},
    {0x94,0xe8},{0xf1,0xca},{0xf3,0xcf},{0xf3,0xd5},{0xc4,0x4a},
    {0xf3,0xd0},{0x00,0x00},{0xf3,0xd3},{0xf3,0xd7},{0xc4,0x4b},
    {0xf3,0xd2},{0x9d,0xf1},{0xf3,0xca},{0x00,0x00},{0xf3,0xc9},
    {0xf3,0xd6},{0xf3,0xcd},{0x97,0xc2},{0xf3,0xcb},{0xf3,0xd4},
    {0xf3,0xcc},{0xc4,0x49},{0xc4,0x48},{0x9d,0xf2},{0xf3,0xc7},
    {0xf3,0xc8},{0xf3,0xd1},{0x9d,0xf3},{0x00,0x00},{0x00,0x00},
    {0xf3,0xce},{0x94,0xea},{0x94,0xe9},{0x00,0x00},{0x9d,0xf4},
    {0x97,0xc3},{0x00,0x00},{0xf5,0x6c},{0xf5,0x6f},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0xc3,0x56},{0x00,0x00},
    {0xfd,0xf9},{0x97,0xc4},{0x00,0x00},{0xfe,0x50},{0x00,0x00},
    {0x97,0xc5},{0xf5,0x6d},{0xf5,0x73},{0xf5,0x71},{0xf5,0x6b},
    {0xf5,0x76},{0xfd,0xf8},{0xf5,0x6a},{0xfd,0xf6},{0xc4,0xcf},
    {0xf5,0x72},{0x00,0x00},{0x95,0xfd},{0x00,0x00},{0xf5,0x6e},
    {0xc4,0xce},{0xf5,0x75},{0xfd,0xf7},{0x00,0x00},{0xf5,0x74},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x97,0xc6},{0xf6,0xab},
    {0xf6,0xaa},{0x00,0x00},{0x9d,0xf5},{0x9d,0xf6},{0xf6,0xb1},
    {0x00,0x00},{0xf6,0xad},{0xf6,0xb0},{0xc5,0x60},{0x9d,0xf7},
    {0x00,0x00},{0xf6,0xae},{0xf6,0xaf},{0x00,0x00},{0xf6,0xa9},
    {0xf6,0xac},{0xc5,0x5f},{0xfd,0xfa},{0x94,0xf9},{0x94,0xeb},
    {0xc5,0xbf},{0xf7,0xb4},{0xf7,0xaf},{0xf7,0xb3},{0xfd,0x53},
    {0xf7,0xb6},{0xf7,0xb2},{0x00,0x00},{0xf7,0xae},{0xfc,0xcb},
    {0xc5,0xc1},{0xf7,0xb1},{0xf7,0xb5},{0xc5,0xc0},{0xf7,0xac},
    {0xf5,0x70},{0xf7,0xb0},{0x00,0x00},{0x00,0x00},{0xf7,0xad},
    {0xfd,0x70},{0xf7,0xaa},{0x94,0xec},{0xf7,0xab},{0xc5,0xbe},
    {0xf8,0x5a},{0xf8,0x5c},{0xf8,0x5f},{0xf8,0x5b},{0xf8,0x60},
    {0x9f,0x50},{0xf8,0x59},{0x00,0x00},{0xf8,0x57},{0x9d,0xf8},
    {0xc5,0xeb},{0xf8,0x5d},{0xc5,0xed},{0xc5,0xec},{0xf8,0x58},
    {0xf8,0x5e},{0x94,0xed},{0x00,0x00},{0x00,0x00},{0x9d,0xf9},
    {0xf8,0xda},{0xc6,0x4d},{0xf8,0xdb},{0x00,0x00},{0xf8,0xd9},
    {0xf8,0xd6},{0x00,0x00},{0x00,0x00},{0xf8,0xd8},{0xf8,0xd7},
    {0xf9,0x5a},{0x94,0xf6},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0xf9,0x5c},{0xf9,0x5b},{0x00,0x00},{0x00,0x00},{0xf9,0x79},
    {0xfb,0x78},{0xf9,0x78},{0xf9,0x77},{0xf9,0x7a},{0x98,0x40},
    {0xc6,0x73},{0xc6,0x74},{0xf9,0xca},{0xf9,0xce},{0x9d,0xfa},
    {0x84,0xbe},{0x00,0x00},{0x00,0x00},{0x88,0xc2},{0x00,0x00},
    {0x88,0xc3},{0x8e,0xe0},{0x00,0x00},{0x00,0x00},{0x98,0x4b},
    {0x98,0x4c},{0x98,0x4d},{0x8d,0xab},{0x00,0x00},{0x00,0x00},
    {0x98,0x4e},{0x00,0x00},{0x89,0xbf},{0x8d,0x65},{0x00,0x00},
    {0x98,0x4f},{0x8a,0xb8},{0x8f,0x6e},{0x00,0x00},{0x8a,0xb7},
    {0x8f,0x6f},{0x00,0x00},{0x90,0xf2},{0x00,0x00},{0x00,0x00},
    {0x90,0xa2},{0x8a,0xb6},{0x8a,0xb5},{0x00,0x00},{0x98,0x50},
    {0x90,0x70},{0x8f,0xb2},{0x90,0xad},{0x8c,0xed},{0x90,0x65},
    {0x8b,0x68},{0x90,0x4e},{0x90,0x66},{0x8b,0x6a},{0x8b,0x67},
    {0x8f,0xb1},{0x00,0x00},{0x8b,0x69},{0x00,0x00},{0x8b,0xe6},
    {0x98,0x51},{0x00,0x00},{0x98,0x52},{0x8f,0xd5},{0x98,0x53},
    {0x8b,0xe5},{0x98,0x54},{0x8f,0xd2},{0x8f,0xd3},{0x8b,0xe7},
    {0x8b,0xe4},{0x00,0x00},{0x98,0x55},{0x8f,0xd4},{0x98,0x56},
    {0x98,0x57},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x8c,0x67},{0x8d,0xaa},{0x8c,0x68},{0x98,0x58},
    {0x98,0x59},{0x00,0x00},{0x00,0x00},{0x98,0x5a},{0x98,0x5b},
    {0x8d,0x6a},{0x8c,0xc0},{0x90,0x4f},{0x8c,0xc1},{0x90,0x50},
    {0x00,0x00},{0x00,0x00},{0x98,0x5c},{0x8c,0xee},{0x90,0x64},
    {0x8c,0xec},{0x8c,0xef},{0x98,0x5d},{0x98,0x5e},{0x00,0x00},
    {0x00,0x00},{0x8d,0x4f},{0x8d,0x4d},{0x8d,0x4e},{0x90,0x6f},
    {0x00,0x00},{0x00,0x00},{0x98,0x5f},{0x00,0x00},{0x00,0x00},
    {0xb3,0xbe},{0xdc,0xaf},{0xe0,0xed},{0x00,0x00},{0xb9,0xa7},
    {0xe0,0xeb},{0x98,0x60},{0x98,0x61},{0xe0,0xec},{0x00,0x00},
    {0x00,0x00},{0x94,0xee},{0xe4,0xe2},{0xe4,0xe3},{0xbb,0xf1},
    {0xbb,0xef},{0xe4,0xe4},{0xbb,0xf0},{0xe8,0xe8},{0x00,0x00},
    {0xe8,0xeb},{0xe8,0xe5},{0xe8,0xec},{0xe8,0xe4},{0xe8,0xe6},
    {0x00,0x00},{0xe8,0xe7},{0xe8,0xea},{0x00,0x00},{0xfd,0x61},
    {0xbe,0xa1},{0xe8,0xef},{0xe8,0xee},{0xbe,0x7d},{0xe8,0xe9},
    {0xe8,0xed},{0xbe,0x7e},{0x00,0x00},{0x00,0x00},{0x9d,0xfb},
    {0x00,0x00},{0x82,0x48},{0x00,0x00},{0xec,0xac},{0x00,0x00},
    {0xc0,0x6f},{0x00,0x00},{0xec,0xa7},{0xc0,0x6b},{0x9d,0xfc},
    {0xec,0xa4},{0xec,0xaa},{0xec,0xad},{0x00,0x00},{0xc0,0x70},
    {0x00,0x00},{0xec,0xa9},{0xec,0xa6},{0xec,0xae},{0xec,0xa5},
    {0x9f,0x40},{0xec,0xab},{0xc0,0x6c},{0x00,0x00},{0xec,0xa3},
    {0xc0,0x6d},{0x00,0x00},{0xc0,0x6e},{0xec,0xa8},{0x98,0x62},
    {0x94,0x47},{0x82,0x47},{0xef,0xa9},{0xef,0x7a},{0xef,0x7b},
    {0xef,0x7e},{0xef,0x7c},{0x00,0x00},{0xef,0x76},{0x9f,0x41},
    {0x00,0x00},{0xef,0x79},{0xef,0xa5},{0xef,0x7d},{0x9f,0x42},
    {0x00,0x00},{0xc2,0x45},{0x00,0x00},{0xef,0xa7},{0xef,0xa4},
    {0xc2,0x46},{0xef,0xa6},{0xef,0x77},{0xef,0xa2},{0xef,0xa3},
    {0xfd,0xaa},{0xef,0xa1},{0x94,0xef},{0x94,0xf7},{0x98,0x63},
    {0x9f,0x43},{0xf1,0xd2},{0xf1,0xd4},{0xf1,0xd7},{0x00,0x00},
    {0x9f,0x44},{0xf1,0xd1},{0x98,0x64},{0xc3,0x59},{0xf1,0xd9},
    {0xf1,0xd0},{0xf1,0xda},{0x00,0x00},{0xf1,0xd6},{0xf1,0xd8},
    {0xf1,0xdc},{0xf1,0xd5},{0xf1,0xdd},{0xf1,0xd3},{0xf1,0xcf},
    {0xc3,0x5a},{0x95,0x72},{0xf1,0xdb},{0xc3,0x5b},{0xc4,0x4d},
    {0x00,0x00},{0x00,0x00},{0x94,0xf0},{0x94,0xf8},{0x00,0x00},
    {0xef,0x78},{0xf3,0xf1},{0xf3,0xe8},{0xc4,0x4f},{0xf3,0xe4},
    {0xc4,0x50},{0x9f,0x45},{0x9f,0x47},{0xf3,0xed},{0xf3,0xe7},
    {0xf3,0xdd},{0xc4,0x4e},{0xf3,0xea},{0xf3,0xe5},{0xf3,0xe6},
    {0x00,0x00},{0xf3,0xd8},{0xf3,0xdf},{0xf3,0xee},{0x98,0x65},
    {0xf3,0xeb},{0x9f,0x48},{0xf3,0xe3},{0xfc,0xc6},{0xf3,0xef},
    {0xf3,0xde},{0xf3,0xd9},{0xf3,0xec},{0x9f,0x49},{0xf3,0xdb},
    {0xf3,0xe9},{0xf3,0xe0},{0xf3,0xf0},{0xf3,0xdc},{0xc4,0x4c},
    {0xf3,0xda},{0xf3,0xe1},{0xf3,0xe2},{0x00,0x00},{0x00,0x00},
    {0x92,0xaf},{0xf5,0x7d},{0x00,0x00},{0xf5,0x7b},{0x9f,0x4a},
    {0xf5,0xa2},{0x00,0x00},{0xf5,0xae},{0xf5,0xa5},{0xf5,0x7c},
    {0xf5,0x78},{0xf5,0xa7},{0xf5,0x7e},{0xf5,0xa3},{0xf5,0x7a},
    {0xf5,0xaa},{0xf5,0x77},{0xf5,0xa1},{0xf5,0xa6},{0xf5,0xa8},
    {0xf5,0xab},{0xf5,0x79},{0x9f,0x4b},{0xf5,0xaf},{0xf5,0xb0},
    {0xf5,0xa9},{0xf5,0xad},{0xf5,0xa4},{0x94,0xf1},{0xf6,0xc1},
    {0xf6,0xc4},{0x00,0x00},{0xc5,0x61},{0x00,0x00},{0xf6,0xc3},
    {0xf6,0xc8},{0xf6,0xc6},{0xc5,0x62},{0xf6,0xbd},{0xf6,0xb3},
    {0xf6,0xb2},{0xc5,0x64},{0xf6,0xbf},{0xf6,0xc0},{0xf6,0xbc},
    {0xf6,0xb4},{0x9f,0x4d},{0xf6,0xb9},{0xf5,0xac},{0x9f,0x52},
    {0xf6,0xb5},{0xc5,0x63},{0xf6,0xbb},{0x95,0x75},{0xf6,0xba},
    {0x98,0x66},{0xf6,0xb6},{0xf6,0xc2},{0x9f,0x5e},{0xf6,0xb7},
    {0xf7,0xbb},{0xf6,0xc5},{0xf6,0xc7},{0xf6,0xbe},{0xf6,0xb8},
    {0xf7,0xbc},{0xf7,0xbe},{0xf7,0xb8},{0xc5,0xc2},{0x9f,0x5f},
    {0xf7,0xc5},{0xf7,0xc3},{0xc5,0xc3},{0xf7,0xc2},{0xf7,0xc1},
    {0xf7,0xba},{0xf7,0xb7},{0xf7,0xbd},{0xf7,0xc6},{0xf7,0xb9},
    {0xf7,0xbf},{0x00,0x00},{0xf8,0x69},{0xf8,0x6e},{0xf8,0x64},
    {0xf8,0x67},{0xc5,0xee},{0xf8,0x6b},{0x00,0x00},{0xf8,0x72},
    {0xf7,0xc0},{0x00,0x00},{0xf8,0x65},{0xf8,0x6f},{0xf8,0x73},
    {0xf8,0x6a},{0xf8,0x63},{0xf8,0x6d},{0x00,0x00},{0xf8,0x6c},
    {0xf8,0x71},{0xf8,0x70},{0xf7,0xc4},{0xf8,0x68},{0xf8,0x62},
    {0xf8,0x66},{0xc6,0x4e},{0xc6,0x4f},{0xf8,0x61},{0x9f,0x60},
    {0xf8,0xe6},{0xf8,0xdd},{0xf8,0xe5},{0xf8,0xe2},{0xf8,0xe3},
    {0xf8,0xdc},{0xf8,0xdf},{0xf8,0xe7},{0xf8,0xe1},{0xf8,0xe0},
    {0xf8,0xde},{0x00,0x00},{0xf8,0xe4},{0x9f,0x61},{0xf9,0x5d},
    {0x9f,0x62},{0xf9,0x5e},{0x9f,0x63},{0xf9,0x60},{0xf9,0x5f},
    {0xf9,0x62},{0xf9,0x61},{0xf9,0x7c},{0xf9,0x7b},{0xf9,0xb7},
    {0x00,0x00},{0xf9,0xb8},{0x9f,0x64},{0xf9,0xc5},{0xc6,0x78},
    {0xc6,0x7c},{0xfd,0x4a},{0xf9,0xcf},{0xc6,0x7d},{0x84,0xbf},
    {0x86,0xaa},{0x8b,0x5c},{0x87,0x7e},{0x87,0x7d},{0x00,0x00},
    {0x8c,0xf1},{0x88,0xc5},{0x00,0x00},{0x8e,0xe1},{0x88,0xc4},
    {0x89,0xc1},{0x8f,0xd7},{0x90,0xaa},{0x89,0xc3},{0x00,0x00},
    {0x89,0xc2},{0x00,0x00},{0x8f,0x4e},{0x8f,0x4d},{0x89,0xc4},
    {0x00,0x00},{0x89,0xc0},{0x8d,0x50},{0x90,0x68},{0x8f,0x70},
    {0x8f,0x71},{0x8f,0x72},{0x00,0x00},{0x00,0x00},{0x8a,0xba},
    {0x8d,0xb1},{0x8a,0xb9},{0x00,0x00},{0x8f,0xb4},{0x90,0xae},
    {0x8b,0x6b},{0x8b,0x6d},{0x8b,0x6c},{0x8f,0xb5},{0x90,0x75},
    {0x8f,0xb3},{0x8b,0xe9},{0x8b,0xea},{0x98,0x67},{0x8b,0xeb},
    {0x00,0x00},{0x8f,0xd6},{0x8b,0xec},{0x00,0x00},{0x8b,0xe8},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x98,0x68},{0x00,0x00},
    {0x8f,0xf6},{0x90,0x52},{0x00,0x00},{0x8f,0xf7},{0x98,0x69},
    {0x8f,0xf8},{0x00,0x00},{0x8c,0xc4},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x90,0x51},{0x8c,0xc3},{0x00,0x00},
    {0x8d,0xae},{0x8c,0xf0},{0x90,0x67},{0x90,0x71},{0x90,0x73},
    {0x90,0x74},{0x90,0x72},{0x8d,0x67},{0x00,0x00},{0x00,0x00},
    {0x8d,0x66},{0x98,0x6a},{0x00,0x00},{0x8d,0xb0},{0x00,0x00},
    {0xb3,0xbf},{0x00,0x00},{0x00,0x00},{0x82,0x5e},{0xc4,0xd0},
    {0xf6,0xc9},{0x9f,0x65},{0xc6,0x50},{0xc6,0x51},{0x90,0x53},
    {0xb3,0xc0},{0xe0,0xee},{0xfc,0xfd},{0xb9,0xa8},{0xe8,0xf0},
    {0xfb,0x5e},{0x9f,0x66},{0xec,0xb0},{0xec,0xb1},{0xec,0xaf},
    {0xef,0xab},{0xef,0xaa},{0xc2,0x47},{0xf1,0xdf},{0xef,0xac},
    {0xf1,0xde},{0x00,0x00},{0x9f,0x51},{0xf3,0xf3},{0xc4,0x51},
    {0xc4,0x53},{0xf3,0xf2},{0xfc,0xf4},{0xfb,0x7c},{0xc4,0x52},
    {0xfb,0xb7},{0xf5,0xb1},{0xf5,0xb3},{0xf5,0xb2},{0xf6,0xca},
    {0xc5,0x65},{0xfd,0x48},{0xc5,0xef},{0xf8,0xe8},{0xf9,0x63},
    {0x9f,0x67},{0x00,0x00},{0xf9,0xd2},{0xb3,0xc1},{0x84,0xc1},
    {0xe4,0xe5},{0xfd,0xb4},{0xbe,0xa2},{0x98,0x6b},{0xfb,0xa2},
    {0x9f,0x68},{0xec,0xb3},{0xec,0xb2},{0x95,0x73},{0xef,0xad},
    {0x9f,0x69},{0x00,0x00},{0x00,0x00},{0xc4,0x54},{0xc4,0xd1},
    {0xf7,0xc7},{0xf9,0xcb},{0x88,0xc6},{0x82,0x60},{0x82,0x61},
    {0xb3,0xc2},{0xbb,0xf2},{0x98,0x6c},{0xbe,0xa3},{0x94,0xfa},
    {0xf3,0xf4},{0x9f,0x6a},{0xf8,0x74},{0xb6,0xc0},{0x98,0x6d},
    {0x00,0x00},{0x9f,0x6b},{0x9f,0x6c},{0xef,0xae},{0x8d,0x7a},
    {0x00,0x00},{0x00,0x00},{0xc6,0x64},{0xb6,0xc1},{0xbe,0xa4},
    {0xc2,0x48},{0xf8,0x75},{0xb6,0xc2},{0x92,0xc3},{0xe8,0xf1},
    {0xc0,0x72},{0xec,0xb4},{0xec,0xb5},{0x00,0x00},{0xc0,0x71},
    {0x93,0xd4},{0xef,0xaf},{0xc2,0x4c},{0xc2,0x4a},{0xc2,0x4b},
    {0xc2,0x49},{0xf1,0xe0},{0xc3,0x5c},{0x00,0x00},{0x98,0x6e},
    {0x00,0x00},{0xf5,0xb5},{0xf5,0xb4},{0xf5,0xb7},{0xf5,0xb6},
    {0xc4,0xd2},{0x8d,0xac},{0x98,0x6f},{0xf6,0xcb},{0x00,0x00},
    {0xf6,0xcd},{0xf6,0xcc},{0xc5,0x66},{0xf7,0xc8},{0x9f,0x6d},
    {0xf8,0x76},{0xf8,0x77},{0xc5,0xf0},{0xf9,0x64},{0xf9,0x7d},
    {0xc6,0x75},{0x9f,0x6e},{0xdc,0xb0},{0xec,0xb6},{0xef,0xb0},
    {0xf3,0xf5},{0xe0,0xef},{0x8e,0x64},{0xef,0xb1},{0xf1,0xe2},
    {0xf1,0xe1},{0xfd,0xe8},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0xf8,0x78},{0xc6,0x52},{0x98,0x70},{0xf9,0x65},{0xf9,0x7e},
    {0x98,0x71},{0x00,0x00},{0x98,0x72},{0xb9,0xa9},{0xe8,0xf2},
    {0xe8,0xf3},{0x00,0x00},{0xec,0xb7},{0xb9,0xaa},{0x00,0x00},
    {0xc3,0x5d},{0xf1,0xe3},{0xfc,0xdb},{0xf6,0xcf},{0xc5,0x67},
    {0xf6,0xd0},{0xf6,0xce},{0xf8,0x79},{0x00,0x00},{0xf8,0xe9},
    {0x00,0x00},{0xb9,0xab},{0x98,0x73},{0xef,0xb4},{0xef,0xb3},
    {0xef,0xb2},{0xf1,0xe4},{0xfb,0xb8},{0x9f,0x6f},{0xf1,0xe8},
    {0xf1,0xe7},{0xf1,0xe6},{0xf1,0xe5},{0xc3,0x5e},{0xf3,0xf6},
    {0xf5,0xb9},{0xc4,0xd3},{0xf5,0xb8},{0xf6,0xd1},{0xf7,0xcb},
    {0xf7,0xca},{0xc5,0xc4},{0xf7,0xc9},{0xf8,0x7c},{0xf8,0x7b},
    {0xf8,0x7a},{0x8c,0xf2},{0x00,0x00},{0xbb,0xf3},{0x00,0x00},
    {0xec,0xb8},{0xc2,0x4d},{0x00,0x00},{0xf3,0xf7},{0xf3,0xf8},
    {0xf7,0xcc},{0xf8,0x7d},{0x98,0x74},{0xfd,0xe2},{0xf8,0xea},
    {0xf9,0x66},{0xf9,0xb9},{0xf9,0xd4},{0xbb,0xf4},{0xc2,0x4e},
    {0xf1,0xe9},{0xf3,0xf9},{0xf6,0xd2},{0xf8,0x7e},{0x87,0xa2},
    {0x98,0x75},{0xbe,0xa6},{0xfd,0xe0},{0xef,0xb5},{0xf1,0xea},
    {0xf3,0xfa},{0xf3,0xfb},{0xf3,0xfc},{0xf5,0xbe},{0xfd,0xda},
    {0xf5,0xba},{0xc5,0x68},{0xf5,0xbd},{0xf5,0xbc},{0xc4,0xd4},
    {0xf5,0xbb},{0xc4,0xd6},{0x93,0xee},{0xc4,0xd5},{0xf6,0xd4},
    {0xf6,0xd3},{0xc5,0x69},{0xc5,0x6a},{0x00,0x00},{0xfd,0x62},
    {0xc5,0xc6},{0xf7,0xcd},{0xc5,0xc5},{0x00,0x00},{0xf8,0xa3},
    {0xf8,0xa4},{0xf8,0xa2},{0xf8,0xa1},{0xc6,0x54},{0x00,0x00},
    {0xf8,0xeb},{0xf8,0xec},{0xf8,0xed},{0xc6,0x53},{0xf9,0x67},
    {0xf9,0x6a},{0xf9,0x69},{0xf9,0x68},{0x00,0x00},{0x00,0x00},
    {0xf9,0xd3},{0x88,0xc7},{0x8f,0x73},{0x00,0x00},{0x00,0x00},
    {0x8c,0x6a},{0x8c,0x6b},{0x8f,0xfa},{0x8f,0xf9},{0x8c,0xc5},
    {0x8c,0xc6},{0x8c,0xf3},{0x8c,0xf4},{0x8d,0x6c},{0x8d,0x6b},
    {0xc0,0x73},{0xfb,0xd8},{0x00,0x00},{0xc3,0x65},{0xf5,0xbf},
    {0xf6,0xd5},{0x00,0x00},{0xc5,0xc7},{0xf7,0xce},{0x00,0x00},
    {0x00,0x00},{0xf9,0xd5},{0x89,0xc5},{0x8c,0xf5},{0x90,0x69},
    {0xc0,0x74},{0x98,0x76},{0x00,0x00},{0x89,0xc6},{0xef,0xb6},
    {0x00,0x00},{0xf7,0xcf},{0x00,0x00},{0xf9,0xa1},{0xfd,0xd4},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0xc8,0xa1},{0xc8,0xa3},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0xfa,0x40},
    {0xfa,0x41},{0xfa,0x42},{0xfa,0x43},{0xfa,0x44},{0xfa,0x45},
    {0xfa,0x46},{0xfa,0x47},{0xfa,0x48},{0xfa,0x49},{0xfa,0x4a},
    {0xfa,0x4b},{0xfa,0x4c},{0xfa,0x4d},{0xfa,0x4e},{0xfa,0x4f},
    {0xfa,0x50},{0xfa,0x51},{0xfa,0x52},{0xfa,0x53},{0xfa,0x54},
    {0xfa,0x55},{0xfa,0x56},{0xfa,0x57},{0xfa,0x58},{0xfa,0x59},
    {0xfa,0x5a},{0xfa,0x5b},{0xfa,0x5c},{0xfa,0x5d},{0xfa,0x5e},
    {0xfa,0x5f},{0xfa,0x60},{0xfa,0x61},{0xfa,0x62},{0xfa,0x63},
    {0xfa,0x64},{0xfa,0x65},{0xfa,0x66},{0xfa,0x67},{0xfa,0x68},
    {0xfa,0x69},{0xfa,0x6a},{0xfa,0x6b},{0xfa,0x6c},{0xfa,0x6d},
    {0xfa,0x6e},{0xfa,0x6f},{0xfa,0x70},{0xfa,0x71},{0xfa,0x72},
    {0xfa,0x73},{0xfa,0x74},{0xfa,0x75},{0xfa,0x76},{0xfa,0x77},
    {0xfa,0x78},{0xfa,0x79},{0xfa,0x7a},{0xfa,0x7b},{0xfa,0x7c},
    {0xfa,0x7d},{0xfa,0x7e},{0xfa,0xa1},{0xfa,0xa2},{0xfa,0xa3},
    {0xfa,0xa4},{0xfa,0xa5},{0xfa,0xa6},{0xfa,0xa7},{0xfa,0xa8},
    {0xfa,0xa9},{0xfa,0xaa},{0xfa,0xab},{0xfa,0xac},{0xfa,0xad},
    {0xfa,0xae},{0xfa,0xaf},{0xfa,0xb0},{0xfa,0xb1},{0xfa,0xb2},
    {0xfa,0xb3},{0xfa,0xb4},{0xfa,0xb5},{0xfa,0xb6},{0xfa,0xb7},
    {0xfa,0xb8},{0xfa,0xb9},{0xfa,0xba},{0xfa,0xbb},{0xfa,0xbc},
    {0xfa,0xbd},{0xfa,0xbe},{0xfa,0xbf},{0xfa,0xc0},{0xfa,0xc1},
    {0xfa,0xc2},{0xfa,0xc3},{0xfa,0xc4},{0xfa,0xc5},{0xfa,0xc6},
    {0xfa,0xc7},{0xfa,0xc8},{0xfa,0xc9},{0xfa,0xca},{0xfa,0xcb},
    {0xfa,0xcc},{0xfa,0xcd},{0xfa,0xce},{0xfa,0xcf},{0xfa,0xd0},
    {0xfa,0xd1},{0xfa,0xd2},{0xfa,0xd3},{0xfa,0xd4},{0xfa,0xd5},
    {0xfa,0xd6},{0xfa,0xd7},{0xfa,0xd8},{0xfa,0xd9},{0xfa,0xda},
    {0xfa,0xdb},{0xfa,0xdc},{0xfa,0xdd},{0xfa,0xde},{0xfa,0xdf},
    {0xfa,0xe0},{0xfa,0xe1},{0xfa,0xe2},{0xfa,0xe3},{0xfa,0xe4},
    {0xfa,0xe5},{0xfa,0xe6},{0xfa,0xe7},{0xfa,0xe8},{0xfa,0xe9},
    {0xfa,0xea},{0xfa,0xeb},{0xfa,0xec},{0xfa,0xed},{0xfa,0xee},
    {0xfa,0xef},{0xfa,0xf0},{0xfa,0xf1},{0xfa,0xf2},{0xfa,0xf3},
    {0xfa,0xf4},{0xfa,0xf5},{0xfa,0xf6},{0xfa,0xf7},{0xfa,0xf8},
    {0xfa,0xf9},{0xfa,0xfa},{0xfa,0xfb},{0xfa,0xfc},{0xfa,0xfd},
    {0xfa,0xfe},{0xfb,0x40},{0xfb,0x41},{0xfb,0x42},{0xfb,0x43},
    {0xfb,0x44},{0xfb,0x45},{0xfb,0x46},{0xfb,0x47},{0xfb,0x48},
    {0xfb,0x49},{0xfb,0x4a},{0xfb,0x4b},{0xfb,0x4c},{0xfb,0x4d},
    {0xfb,0x4e},{0xfb,0x4f},{0xfb,0x50},{0xfb,0x51},{0xfb,0x52},
    {0xfb,0x53},{0xfb,0x54},{0xfb,0x55},{0xfb,0x56},{0xfb,0x57},
    {0xfb,0x58},{0xfb,0x59},{0xfb,0x5a},{0xfb,0x5b},{0xfb,0x5c},
    {0xfb,0x5d},{0xfb,0x5e},{0xfb,0x5f},{0xfb,0x60},{0xfb,0x61},
    {0xfb,0x62},{0xfb,0x63},{0xfb,0x64},{0xfb,0x65},{0xfb,0x66},
    {0xfb,0x67},{0xfb,0x68},{0xfb,0x69},{0xfb,0x6a},{0xfb,0x6b},
    {0xfb,0x6c},{0xfb,0x6d},{0xfb,0x6e},{0xfb,0x6f},{0xfb,0x70},
    {0xfb,0x71},{0xfb,0x72},{0xfb,0x73},{0xfb,0x74},{0xfb,0x75},
    {0xfb,0x76},{0xfb,0x77},{0xfb,0x78},{0xfb,0x79},{0xfb,0x7a},
    {0xfb,0x7b},{0xfb,0x7c},{0xfb,0x7d},{0xfb,0x7e},{0xfb,0xa1},
    {0xfb,0xa2},{0xfb,0xa3},{0xfb,0xa4},{0xfb,0xa5},{0xfb,0xa6},
    {0xfb,0xa7},{0xfb,0xa8},{0xfb,0xa9},{0xfb,0xaa},{0xfb,0xab},
    {0xfb,0xac},{0xfb,0xad},{0xfb,0xae},{0xfb,0xaf},{0xfb,0xb0},
    {0xfb,0xb1},{0xfb,0xb2},{0xfb,0xb3},{0xfb,0xb4},{0xfb,0xb5},
    {0xfb,0xb6},{0xfb,0xb7},{0xfb,0xb8},{0xfb,0xb9},{0xfb,0xba},
    {0xfb,0xbb},{0xfb,0xbc},{0xfb,0xbd},{0xfb,0xbe},{0xfb,0xbf},
    {0xfb,0xc0},{0xfb,0xc1},{0xfb,0xc2},{0xfb,0xc3},{0xfb,0xc4},
    {0xfb,0xc5},{0xfb,0xc6},{0xfb,0xc7},{0xfb,0xc8},{0xfb,0xc9},
    {0xfb,0xca},{0xfb,0xcb},{0xfb,0xcc},{0xfb,0xcd},{0xfb,0xce},
    {0xfb,0xcf},{0xfb,0xd0},{0xfb,0xd1},{0xfb,0xd2},{0xfb,0xd3},
    {0xfb,0xd4},{0xfb,0xd5},{0xfb,0xd6},{0xfb,0xd7},{0xfb,0xd8},
    {0xfb,0xd9},{0xfb,0xda},{0xfb,0xdb},{0xfb,0xdc},{0xfb,0xdd},
    {0xfb,0xde},{0xfb,0xdf},{0xfb,0xe0},{0xfb,0xe1},{0xfb,0xe2},
    {0xfb,0xe3},{0xfb,0xe4},{0xfb,0xe5},{0xfb,0xe6},{0xfb,0xe7},
    {0xfb,0xe8},{0xfb,0xe9},{0xfb,0xea},{0xfb,0xeb},{0xfb,0xec},
    {0xfb,0xed},{0xfb,0xee},{0xfb,0xef},{0xfb,0xf0},{0xfb,0xf1},
    {0xfb,0xf2},{0xfb,0xf3},{0xfb,0xf4},{0xfb,0xf5},{0xfb,0xf6},
    {0xfb,0xf7},{0xfb,0xf8},{0xfb,0xf9},{0xfb,0xfa},{0xfb,0xfb},
    {0xfb,0xfc},{0xfb,0xfd},{0xfb,0xfe},{0xfc,0x40},{0xfc,0x41},
    {0xfc,0x42},{0xfc,0x43},{0xfc,0x44},{0xfc,0x45},{0xfc,0x46},
    {0xfc,0x47},{0xfc,0x48},{0xfc,0x49},{0xfc,0x4a},{0xfc,0x4b},
    {0xfc,0x4c},{0xfc,0x4d},{0xfc,0x4e},{0xfc,0x4f},{0xfc,0x50},
    {0xfc,0x51},{0xfc,0x52},{0xfc,0x53},{0xfc,0x54},{0xfc,0x55},
    {0xfc,0x56},{0xfc,0x57},{0xfc,0x58},{0xfc,0x59},{0xfc,0x5a},
    {0xfc,0x5b},{0xfc,0x5c},{0xfc,0x5d},{0xfc,0x5e},{0xfc,0x5f},
    {0xfc,0x60},{0xfc,0x61},{0xfc,0x62},{0xfc,0x63},{0xfc,0x64},
    {0xfc,0x65},{0xfc,0x66},{0xfc,0x67},{0xfc,0x68},{0xfc,0x69},
    {0xfc,0x6a},{0xfc,0x6b},{0xfc,0x6c},{0xfc,0x6d},{0xfc,0x6e},
    {0xfc,0x6f},{0xfc,0x70},{0xfc,0x71},{0xfc,0x72},{0xfc,0x73},
    {0xfc,0x74},{0xfc,0x75},{0xfc,0x76},{0xfc,0x77},{0xfc,0x78},
    {0xfc,0x79},{0xfc,0x7a},{0xfc,0x7b},{0xfc,0x7c},{0xfc,0x7d},
    {0xfc,0x7e},{0xfc,0xa1},{0xfc,0xa2},{0xfc,0xa3},{0xfc,0xa4},
    {0xfc,0xa5},{0xfc,0xa6},{0xfc,0xa7},{0xfc,0xa8},{0xfc,0xa9},
    {0xfc,0xaa},{0xfc,0xab},{0xfc,0xac},{0xfc,0xad},{0xfc,0xae},
    {0xfc,0xaf},{0xfc,0xb0},{0xfc,0xb1},{0xfc,0xb2},{0xfc,0xb3},
    {0xfc,0xb4},{0xfc,0xb5},{0xfc,0xb6},{0xfc,0xb7},{0xfc,0xb8},
    {0xfc,0xb9},{0xfc,0xba},{0xfc,0xbb},{0xfc,0xbc},{0xfc,0xbd},
    {0xfc,0xbe},{0xfc,0xbf},{0xfc,0xc0},{0xfc,0xc1},{0xfc,0xc2},
    {0xfc,0xc3},{0xfc,0xc4},{0xfc,0xc5},{0xfc,0xc6},{0xfc,0xc7},
    {0xfc,0xc8},{0xfc,0xc9},{0xfc,0xca},{0xfc,0xcb},{0xfc,0xcc},
    {0xfc,0xcd},{0xfc,0xce},{0xfc,0xcf},{0xfc,0xd0},{0xfc,0xd1},
    {0xfc,0xd2},{0xfc,0xd3},{0xfc,0xd4},{0xfc,0xd5},{0xfc,0xd6},
    {0xfc,0xd7},{0xfc,0xd8},{0xfc,0xd9},{0xfc,0xda},{0xfc,0xdb},
    {0xfc,0xdc},{0xfc,0xdd},{0xfc,0xde},{0xfc,0xdf},{0xfc,0xe0},
    {0xfc,0xe1},{0xfc,0xe2},{0xfc,0xe3},{0xfc,0xe4},{0xfc,0xe5},
    {0xfc,0xe6},{0xfc,0xe7},{0xfc,0xe8},{0xfc,0xe9},{0xfc,0xea},
    {0xfc,0xeb},{0xfc,0xec},{0xfc,0xed},{0xfc,0xee},{0xfc,0xef},
    {0xfc,0xf0},{0xfc,0xf1},{0xfc,0xf2},{0xfc,0xf3},{0xfc,0xf4},
    {0xfc,0xf5},{0xfc,0xf6},{0xfc,0xf7},{0xfc,0xf8},{0xfc,0xf9},
    {0xfc,0xfa},{0xfc,0xfb},{0xfc,0xfc},{0xfc,0xfd},{0xfc,0xfe},
    {0xfd,0x40},{0xfd,0x41},{0xfd,0x42},{0xfd,0x43},{0xfd,0x44},
    {0xfd,0x45},{0xfd,0x46},{0xfd,0x47},{0xfd,0x48},{0xfd,0x49},
    {0xfd,0x4a},{0xfd,0x4b},{0xfd,0x4c},{0xfd,0x4d},{0xfd,0x4e},
    {0xfd,0x4f},{0xfd,0x50},{0xfd,0x51},{0xfd,0x52},{0xfd,0x53},
    {0xfd,0x54},{0xfd,0x55},{0xfd,0x56},{0xfd,0x57},{0xfd,0x58},
    {0xfd,0x59},{0xfd,0x5a},{0xfd,0x5b},{0xfd,0x5c},{0xfd,0x5d},
    {0xfd,0x5e},{0xfd,0x5f},{0xfd,0x60},{0xfd,0x61},{0xfd,0x62},
    {0xfd,0x63},{0xfd,0x64},{0xfd,0x65},{0xfd,0x66},{0xfd,0x67},
    {0xfd,0x68},{0xfd,0x69},{0xfd,0x6a},{0xfd,0x6b},{0xfd,0x6c},
    {0xfd,0x6d},{0xfd,0x6e},{0xfd,0x6f},{0xfd,0x70},{0xfd,0x71},
    {0xfd,0x72},{0xfd,0x73},{0xfd,0x74},{0xfd,0x75},{0xfd,0x76},
    {0xfd,0x77},{0xfd,0x78},{0xfd,0x79},{0xfd,0x7a},{0xfd,0x7b},
    {0xfd,0x7c},{0xfd,0x7d},{0xfd,0x7e},{0xfd,0xa1},{0xfd,0xa2},
    {0xfd,0xa3},{0xfd,0xa4},{0xfd,0xa5},{0xfd,0xa6},{0xfd,0xa7},
    {0xfd,0xa8},{0xfd,0xa9},{0xfd,0xaa},{0xfd,0xab},{0xfd,0xac},
    {0xfd,0xad},{0xfd,0xae},{0xfd,0xaf},{0xfd,0xb0},{0xfd,0xb1},
    {0xfd,0xb2},{0xfd,0xb3},{0xfd,0xb4},{0xfd,0xb5},{0xfd,0xb6},
    {0xfd,0xb7},{0xfd,0xb8},{0xfd,0xb9},{0xfd,0xba},{0xfd,0xbb},
    {0xfd,0xbc},{0xfd,0xbd},{0xfd,0xbe},{0xfd,0xbf},{0xfd,0xc0},
    {0xfd,0xc1},{0xfd,0xc2},{0xfd,0xc3},{0xfd,0xc4},{0xfd,0xc5},
    {0xfd,0xc6},{0xfd,0xc7},{0xfd,0xc8},{0xfd,0xc9},{0xfd,0xca},
    {0xfd,0xcb},{0xfd,0xcc},{0xfd,0xcd},{0xfd,0xce},{0xfd,0xcf},
    {0xfd,0xd0},{0xfd,0xd1},{0xfd,0xd2},{0xfd,0xd3},{0xfd,0xd4},
    {0xfd,0xd5},{0xfd,0xd6},{0xfd,0xd7},{0xfd,0xd8},{0xfd,0xd9},
    {0xfd,0xda},{0xfd,0xdb},{0xfd,0xdc},{0xfd,0xdd},{0xfd,0xde},
    {0xfd,0xdf},{0xfd,0xe0},{0xfd,0xe1},{0xfd,0xe2},{0xfd,0xe3},
    {0xfd,0xe4},{0xfd,0xe5},{0xfd,0xe6},{0xfd,0xe7},{0xfd,0xe8},
    {0xfd,0xe9},{0xfd,0xea},{0xfd,0xeb},{0xfd,0xec},{0xfd,0xed},
    {0xfd,0xee},{0xfd,0xef},{0xfd,0xf0},{0xfd,0xf1},{0xfd,0xf2},
    {0xfd,0xf3},{0xfd,0xf4},{0xfd,0xf5},{0xfd,0xf6},{0xfd,0xf7},
    {0xfd,0xf8},{0xfd,0xf9},{0xfd,0xfa},{0xfd,0xfb},{0xfd,0xfc},
    {0xfd,0xfd},{0xfd,0xfe},{0xfe,0x40},{0xfe,0x41},{0xfe,0x42},
    {0xfe,0x43},{0xfe,0x44},{0xfe,0x45},{0xfe,0x46},{0xfe,0x47},
    {0xfe,0x48},{0xfe,0x49},{0xfe,0x4a},{0xfe,0x4b},{0xfe,0x4c},
    {0xfe,0x4d},{0xfe,0x4e},{0xfe,0x4f},{0xfe,0x50},{0xfe,0x51},
    {0xfe,0x52},{0xfe,0x53},{0xfe,0x54},{0xfe,0x55},{0xfe,0x56},
    {0xfe,0x57},{0xfe,0x58},{0xfe,0x59},{0xfe,0x5a},{0xfe,0x5b},
    {0xfe,0x5c},{0xfe,0x5d},{0xfe,0x5e},{0xfe,0x5f},{0xfe,0x60},
    {0xfe,0x61},{0xfe,0x62},{0xfe,0x63},{0xfe,0x64},{0xfe,0x65},
    {0xfe,0x66},{0xfe,0x67},{0xfe,0x68},{0xfe,0x69},{0xfe,0x6a},
    {0xfe,0x6b},{0xfe,0x6c},{0xfe,0x6d},{0xfe,0x6e},{0xfe,0x6f},
    {0xfe,0x70},{0xfe,0x71},{0xfe,0x72},{0xfe,0x73},{0xfe,0x74},
    {0xfe,0x75},{0xfe,0x76},{0xfe,0x77},{0xfe,0x78},{0xfe,0x79},
    {0xfe,0x7a},{0xfe,0x7b},{0xfe,0x7c},{0xfe,0x7d},{0xfe,0x7e},
    {0xfe,0xa1},{0xfe,0xa2},{0xfe,0xa3},{0xfe,0xa4},{0xfe,0xa5},
    {0xfe,0xa6},{0xfe,0xa7},{0xfe,0xa8},{0xfe,0xa9},{0xfe,0xaa},
    {0xfe,0xab},{0xfe,0xac},{0xfe,0xad},{0xfe,0xae},{0xfe,0xaf},
    {0xfe,0xb0},{0xfe,0xb1},{0xfe,0xb2},{0xfe,0xb3},{0xfe,0xb4},
    {0xfe,0xb5},{0xfe,0xb6},{0xfe,0xb7},{0xfe,0xb8},{0xfe,0xb9},
    {0xfe,0xba},{0xfe,0xbb},{0xfe,0xbc},{0xfe,0xbd},{0xfe,0xbe},
    {0xfe,0xbf},{0xfe,0xc0},{0xfe,0xc1},{0xfe,0xc2},{0xfe,0xc3},
    {0xfe,0xc4},{0xfe,0xc5},{0xfe,0xc6},{0xfe,0xc7},{0xfe,0xc8},
    {0xfe,0xc9},{0xfe,0xca},{0xfe,0xcb},{0xfe,0xcc},{0xfe,0xcd},
    {0xfe,0xce},{0xfe,0xcf},{0xfe,0xd0},{0xfe,0xd1},{0xfe,0xd2},
    {0xfe,0xd3},{0xfe,0xd4},{0xfe,0xd5},{0xfe,0xd6},{0xfe,0xd7},
    {0xfe,0xd8},{0xfe,0xd9},{0xfe,0xda},{0xfe,0xdb},{0xfe,0xdc},
    {0xfe,0xdd},{0xfe,0xde},{0xfe,0xdf},{0xfe,0xe0},{0xfe,0xe1},
    {0xfe,0xe2},{0xfe,0xe3},{0xfe,0xe4},{0xfe,0xe5},{0xfe,0xe6},
    {0xfe,0xe7},{0xfe,0xe8},{0xfe,0xe9},{0xfe,0xea},{0xfe,0xeb},
    {0xfe,0xec},{0xfe,0xed},{0xfe,0xee},{0xfe,0xef},{0xfe,0xf0},
    {0xfe,0xf1},{0xfe,0xf2},{0xfe,0xf3},{0xfe,0xf4},{0xfe,0xf5},
    {0xfe,0xf6},{0xfe,0xf7},{0xfe,0xf8},{0xfe,0xf9},{0xfe,0xfa},
    {0xfe,0xfb},{0xfe,0xfc},{0xfe,0xfd},{0xfe,0xfe},{0x8e,0x40},
    {0x8e,0x41},{0x8e,0x42},{0x8e,0x43},{0x8e,0x44},{0x8e,0x45},
    {0x8e,0x46},{0x8e,0x47},{0x8e,0x48},{0x8e,0x49},{0x8e,0x4a},
    {0x8e,0x4b},{0x8e,0x4c},{0x8e,0x4d},{0x8e,0x4e},{0x8e,0x4f},
    {0x8e,0x50},{0x8e,0x51},{0x8e,0x52},{0x8e,0x53},{0x8e,0x54},
    {0x8e,0x55},{0x8e,0x56},{0x8e,0x57},{0x8e,0x58},{0x8e,0x59},
    {0x8e,0x5a},{0x8e,0x5b},{0x8e,0x5c},{0x8e,0x5d},{0x8e,0x5e},
    {0x8e,0x5f},{0x8e,0x60},{0x8e,0x61},{0x8e,0x62},{0x8e,0x63},
    {0x8e,0x64},{0x8e,0x65},{0x8e,0x66},{0x8e,0x67},{0x8e,0x68},
    {0x8e,0x69},{0x8e,0x6a},{0x8e,0x6b},{0x8e,0x6c},{0x8e,0x6d},
    {0x8e,0x6e},{0x8e,0x6f},{0x8e,0x70},{0x8e,0x71},{0x8e,0x72},
    {0x8e,0x73},{0x8e,0x74},{0x8e,0x75},{0x8e,0x76},{0x8e,0x77},
    {0x8e,0x78},{0x8e,0x79},{0x8e,0x7a},{0x8e,0x7b},{0x8e,0x7c},
    {0x8e,0x7d},{0x8e,0x7e},{0x8e,0xa1},{0x8e,0xa2},{0x8e,0xa3},
    {0x8e,0xa4},{0x8e,0xa5},{0x8e,0xa6},{0x8e,0xa7},{0x8e,0xa8},
    {0x8e,0xa9},{0x8e,0xaa},{0x8e,0xab},{0x8e,0xac},{0x8e,0xad},
    {0x8e,0xae},{0x8e,0xaf},{0x8e,0xb0},{0x8e,0xb1},{0x8e,0xb2},
    {0x8e,0xb3},{0x8e,0xb4},{0x8e,0xb5},{0x8e,0xb6},{0x8e,0xb7},
    {0x8e,0xb8},{0x8e,0xb9},{0x8e,0xba},{0x8e,0xbb},{0x8e,0xbc},
    {0x8e,0xbd},{0x8e,0xbe},{0x8e,0xbf},{0x8e,0xc0},{0x8e,0xc1},
    {0x8e,0xc2},{0x8e,0xc3},{0x8e,0xc4},{0x8e,0xc5},{0x8e,0xc6},
    {0x8e,0xc7},{0x8e,0xc8},{0x8e,0xc9},{0x8e,0xca},{0x8e,0xcb},
    {0x8e,0xcc},{0x8e,0xcd},{0x8e,0xce},{0x8e,0xcf},{0x8e,0xd0},
    {0x8e,0xd1},{0x8e,0xd2},{0x8e,0xd3},{0x8e,0xd4},{0x8e,0xd5},
    {0x8e,0xd6},{0x8e,0xd7},{0x8e,0xd8},{0x8e,0xd9},{0x8e,0xda},
    {0x8e,0xdb},{0x8e,0xdc},{0x8e,0xdd},{0x8e,0xde},{0x8e,0xdf},
    {0x8e,0xe0},{0x8e,0xe1},{0x8e,0xe2},{0x8e,0xe3},{0x8e,0xe4},
    {0x8e,0xe5},{0x8e,0xe6},{0x8e,0xe7},{0x8e,0xe8},{0x8e,0xe9},
    {0x8e,0xea},{0x8e,0xeb},{0x8e,0xec},{0x8e,0xed},{0x8e,0xee},
    {0x8e,0xef},{0x8e,0xf0},{0x8e,0xf1},{0x8e,0xf2},{0x8e,0xf3},
    {0x8e,0xf4},{0x8e,0xf5},{0x8e,0xf6},{0x8e,0xf7},{0x8e,0xf8},
    {0x8e,0xf9},{0x8e,0xfa},{0x8e,0xfb},{0x8e,0xfc},{0x8e,0xfd},
    {0x8e,0xfe},{0x8f,0x40},{0x8f,0x41},{0x8f,0x42},{0x8f,0x43},
    {0x8f,0x44},{0x8f,0x45},{0x8f,0x46},{0x8f,0x47},{0x8f,0x48},
    {0x8f,0x49},{0x8f,0x4a},{0x8f,0x4b},{0x8f,0x4c},{0x8f,0x4d},
    {0x8f,0x4e},{0x8f,0x4f},{0x8f,0x50},{0x8f,0x51},{0x8f,0x52},
    {0x8f,0x53},{0x8f,0x54},{0x8f,0x55},{0x8f,0x56},{0x8f,0x57},
    {0x8f,0x58},{0x8f,0x59},{0x8f,0x5a},{0x8f,0x5b},{0x8f,0x5c},
    {0x8f,0x5d},{0x8f,0x5e},{0x8f,0x5f},{0x8f,0x60},{0x8f,0x61},
    {0x8f,0x62},{0x8f,0x63},{0x8f,0x64},{0x8f,0x65},{0x8f,0x66},
    {0x8f,0x67},{0x8f,0x68},{0x8f,0x69},{0x8f,0x6a},{0x8f,0x6b},
    {0x8f,0x6c},{0x8f,0x6d},{0x8f,0x6e},{0x8f,0x6f},{0x8f,0x70},
    {0x8f,0x71},{0x8f,0x72},{0x8f,0x73},{0x8f,0x74},{0x8f,0x75},
    {0x8f,0x76},{0x8f,0x77},{0x8f,0x78},{0x8f,0x79},{0x8f,0x7a},
    {0x8f,0x7b},{0x8f,0x7c},{0x8f,0x7d},{0x8f,0x7e},{0x8f,0xa1},
    {0x8f,0xa2},{0x8f,0xa3},{0x8f,0xa4},{0x8f,0xa5},{0x8f,0xa6},
    {0x8f,0xa7},{0x8f,0xa8},{0x8f,0xa9},{0x8f,0xaa},{0x8f,0xab},
    {0x8f,0xac},{0x8f,0xad},{0x8f,0xae},{0x8f,0xaf},{0x8f,0xb0},
    {0x8f,0xb1},{0x8f,0xb2},{0x8f,0xb3},{0x8f,0xb4},{0x8f,0xb5},
    {0x8f,0xb6},{0x8f,0xb7},{0x8f,0xb8},{0x8f,0xb9},{0x8f,0xba},
    {0x8f,0xbb},{0x8f,0xbc},{0x8f,0xbd},{0x8f,0xbe},{0x8f,0xbf},
    {0x8f,0xc0},{0x8f,0xc1},{0x8f,0xc2},{0x8f,0xc3},{0x8f,0xc4},
    {0x8f,0xc5},{0x8f,0xc6},{0x8f,0xc7},{0x8f,0xc8},{0x8f,0xc9},
    {0x8f,0xca},{0x8f,0xcb},{0x8f,0xcc},{0x8f,0xcd},{0x8f,0xce},
    {0x8f,0xcf},{0x8f,0xd0},{0x8f,0xd1},{0x8f,0xd2},{0x8f,0xd3},
    {0x8f,0xd4},{0x8f,0xd5},{0x8f,0xd6},{0x8f,0xd7},{0x8f,0xd8},
    {0x8f,0xd9},{0x8f,0xda},{0x8f,0xdb},{0x8f,0xdc},{0x8f,0xdd},
    {0x8f,0xde},{0x8f,0xdf},{0x8f,0xe0},{0x8f,0xe1},{0x8f,0xe2},
    {0x8f,0xe3},{0x8f,0xe4},{0x8f,0xe5},{0x8f,0xe6},{0x8f,0xe7},
    {0x8f,0xe8},{0x8f,0xe9},{0x8f,0xea},{0x8f,0xeb},{0x8f,0xec},
    {0x8f,0xed},{0x8f,0xee},{0x8f,0xef},{0x8f,0xf0},{0x8f,0xf1},
    {0x8f,0xf2},{0x8f,0xf3},{0x8f,0xf4},{0x8f,0xf5},{0x8f,0xf6},
    {0x8f,0xf7},{0x8f,0xf8},{0x8f,0xf9},{0x8f,0xfa},{0x8f,0xfb},
    {0x8f,0xfc},{0x8f,0xfd},{0x8f,0xfe},{0x90,0x40},{0x90,0x41},
    {0x90,0x42},{0x90,0x43},{0x90,0x44},{0x90,0x45},{0x90,0x46},
    {0x90,0x47},{0x90,0x48},{0x90,0x49},{0x90,0x4a},{0x90,0x4b},
    {0x90,0x4c},{0x90,0x4d},{0x90,0x4e},{0x90,0x4f},{0x90,0x50},
    {0x90,0x51},{0x90,0x52},{0x90,0x53},{0x90,0x54},{0x90,0x55},
    {0x90,0x56},{0x90,0x57},{0x90,0x58},{0x90,0x59},{0x90,0x5a},
    {0x90,0x5b},{0x90,0x5c},{0x90,0x5d},{0x90,0x5e},{0x90,0x5f},
    {0x90,0x60},{0x90,0x61},{0x90,0x62},{0x90,0x63},{0x90,0x64},
    {0x90,0x65},{0x90,0x66},{0x90,0x67},{0x90,0x68},{0x90,0x69},
    {0x90,0x6a},{0x90,0x6b},{0x90,0x6c},{0x90,0x6d},{0x90,0x6e},
    {0x90,0x6f},{0x90,0x70},{0x90,0x71},{0x90,0x72},{0x90,0x73},
    {0x90,0x74},{0x90,0x75},{0x90,0x76},{0x90,0x77},{0x90,0x78},
    {0x90,0x79},{0x90,0x7a},{0x90,0x7b},{0x90,0x7c},{0x90,0x7d},
    {0x90,0x7e},{0x90,0xa1},{0x90,0xa2},{0x90,0xa3},{0x90,0xa4},
    {0x90,0xa5},{0x90,0xa6},{0x90,0xa7},{0x90,0xa8},{0x90,0xa9},
    {0x90,0xaa},{0x90,0xab},{0x90,0xac},{0x90,0xad},{0x90,0xae},
    {0x90,0xaf},{0x90,0xb0},{0x90,0xb1},{0x90,0xb2},{0x90,0xb3},
    {0x90,0xb4},{0x90,0xb5},{0x90,0xb6},{0x90,0xb7},{0x90,0xb8},
    {0x90,0xb9},{0x90,0xba},{0x90,0xbb},{0x90,0xbc},{0x90,0xbd},
    {0x90,0xbe},{0x90,0xbf},{0x90,0xc0},{0x90,0xc1},{0x90,0xc2},
    {0x90,0xc3},{0x90,0xc4},{0x90,0xc5},{0x90,0xc6},{0x90,0xc7},
    {0x90,0xc8},{0x90,0xc9},{0x90,0xca},{0x90,0xcb},{0x90,0xcc},
    {0x90,0xcd},{0x90,0xce},{0x90,0xcf},{0x90,0xd0},{0x90,0xd1},
    {0x90,0xd2},{0x90,0xd3},{0x90,0xd4},{0x90,0xd5},{0x90,0xd6},
    {0x90,0xd7},{0x90,0xd8},{0x90,0xd9},{0x90,0xda},{0x90,0xdb},
    {0x90,0xdc},{0x90,0xdd},{0x90,0xde},{0x90,0xdf},{0x90,0xe0},
    {0x90,0xe1},{0x90,0xe2},{0x90,0xe3},{0x90,0xe4},{0x90,0xe5},
    {0x90,0xe6},{0x90,0xe7},{0x90,0xe8},{0x90,0xe9},{0x90,0xea},
    {0x90,0xeb},{0x90,0xec},{0x90,0xed},{0x90,0xee},{0x90,0xef},
    {0x90,0xf0},{0x90,0xf1},{0x90,0xf2},{0x90,0xf3},{0x90,0xf4},
    {0x90,0xf5},{0x90,0xf6},{0x90,0xf7},{0x90,0xf8},{0x90,0xf9},
    {0x90,0xfa},{0x90,0xfb},{0x90,0xfc},{0x90,0xfd},{0x90,0xfe},
    {0x91,0x40},{0x91,0x41},{0x91,0x42},{0x91,0x43},{0x91,0x44},
    {0x91,0x45},{0x91,0x46},{0x91,0x47},{0x91,0x48},{0x91,0x49},
    {0x91,0x4a},{0x91,0x4b},{0x91,0x4c},{0x91,0x4d},{0x91,0x4e},
    {0x91,0x4f},{0x91,0x50},{0x91,0x51},{0x91,0x52},{0x91,0x53},
    {0x91,0x54},{0x91,0x55},{0x91,0x56},{0x91,0x57},{0x91,0x58},
    {0x91,0x59},{0x91,0x5a},{0x91,0x5b},{0x91,0x5c},{0x91,0x5d},
    {0x91,0x5e},{0x91,0x5f},{0x91,0x60},{0x91,0x61},{0x91,0x62},
    {0x91,0x63},{0x91,0x64},{0x91,0x65},{0x91,0x66},{0x91,0x67},
    {0x91,0x68},{0x91,0x69},{0x91,0x6a},{0x91,0x6b},{0x91,0x6c},
    {0x91,0x6d},{0x91,0x6e},{0x91,0x6f},{0x91,0x70},{0x91,0x71},
    {0x91,0x72},{0x91,0x73},{0x91,0x74},{0x91,0x75},{0x91,0x76},
    {0x91,0x77},{0x91,0x78},{0x91,0x79},{0x91,0x7a},{0x91,0x7b},
    {0x91,0x7c},{0x91,0x7d},{0x91,0x7e},{0x91,0xa1},{0x91,0xa2},
    {0x91,0xa3},{0x91,0xa4},{0x91,0xa5},{0x91,0xa6},{0x91,0xa7},
    {0x91,0xa8},{0x91,0xa9},{0x91,0xaa},{0x91,0xab},{0x91,0xac},
    {0x91,0xad},{0x91,0xae},{0x91,0xaf},{0x91,0xb0},{0x91,0xb1},
    {0x91,0xb2},{0x91,0xb3},{0x91,0xb4},{0x91,0xb5},{0x91,0xb6},
    {0x91,0xb7},{0x91,0xb8},{0x91,0xb9},{0x91,0xba},{0x91,0xbb},
    {0x91,0xbc},{0x91,0xbd},{0x91,0xbe},{0x91,0xbf},{0x91,0xc0},
    {0x91,0xc1},{0x91,0xc2},{0x91,0xc3},{0x91,0xc4},{0x91,0xc5},
    {0x91,0xc6},{0x91,0xc7},{0x91,0xc8},{0x91,0xc9},{0x91,0xca},
    {0x91,0xcb},{0x91,0xcc},{0x91,0xcd},{0x91,0xce},{0x91,0xcf},
    {0x91,0xd0},{0x91,0xd1},{0x91,0xd2},{0x91,0xd3},{0x91,0xd4},
    {0x91,0xd5},{0x91,0xd6},{0x91,0xd7},{0x91,0xd8},{0x91,0xd9},
    {0x91,0xda},{0x91,0xdb},{0x91,0xdc},{0x91,0xdd},{0x91,0xde},
    {0x91,0xdf},{0x91,0xe0},{0x91,0xe1},{0x91,0xe2},{0x91,0xe3},
    {0x91,0xe4},{0x91,0xe5},{0x91,0xe6},{0x91,0xe7},{0x91,0xe8},
    {0x91,0xe9},{0x91,0xea},{0x91,0xeb},{0x91,0xec},{0x91,0xed},
    {0x91,0xee},{0x91,0xef},{0x91,0xf0},{0x91,0xf1},{0x91,0xf2},
    {0x91,0xf3},{0x91,0xf4},{0x91,0xf5},{0x91,0xf6},{0x91,0xf7},
    {0x91,0xf8},{0x91,0xf9},{0x91,0xfa},{0x91,0xfb},{0x91,0xfc},
    {0x91,0xfd},{0x91,0xfe},{0x92,0x40},{0x92,0x41},{0x92,0x42},
    {0x92,0x43},{0x92,0x44},{0x92,0x45},{0x92,0x46},{0x92,0x47},
    {0x92,0x48},{0x92,0x49},{0x92,0x4a},{0x92,0x4b},{0x92,0x4c},
    {0x92,0x4d},{0x92,0x4e},{0x92,0x4f},{0x92,0x50},{0x92,0x51},
    {0x92,0x52},{0x92,0x53},{0x92,0x54},{0x92,0x55},{0x92,0x56},
    {0x92,0x57},{0x92,0x58},{0x92,0x59},{0x92,0x5a},{0x92,0x5b},
    {0x92,0x5c},{0x92,0x5d},{0x92,0x5e},{0x92,0x5f},{0x92,0x60},
    {0x92,0x61},{0x92,0x62},{0x92,0x63},{0x92,0x64},{0x92,0x65},
    {0x92,0x66},{0x92,0x67},{0x92,0x68},{0x92,0x69},{0x92,0x6a},
    {0x92,0x6b},{0x92,0x6c},{0x92,0x6d},{0x92,0x6e},{0x92,0x6f},
    {0x92,0x70},{0x92,0x71},{0x92,0x72},{0x92,0x73},{0x92,0x74},
    {0x92,0x75},{0x92,0x76},{0x92,0x77},{0x92,0x78},{0x92,0x79},
    {0x92,0x7a},{0x92,0x7b},{0x92,0x7c},{0x92,0x7d},{0x92,0x7e},
    {0x92,0xa1},{0x92,0xa2},{0x92,0xa3},{0x92,0xa4},{0x92,0xa5},
    {0x92,0xa6},{0x92,0xa7},{0x92,0xa8},{0x92,0xa9},{0x92,0xaa},
    {0x92,0xab},{0x92,0xac},{0x92,0xad},{0x92,0xae},{0x92,0xaf},
    {0x92,0xb0},{0x92,0xb1},{0x92,0xb2},{0x92,0xb3},{0x92,0xb4},
    {0x92,0xb5},{0x92,0xb6},{0x92,0xb7},{0x92,0xb8},{0x92,0xb9},
    {0x92,0xba},{0x92,0xbb},{0x92,0xbc},{0x92,0xbd},{0x92,0xbe},
    {0x92,0xbf},{0x92,0xc0},{0x92,0xc1},{0x92,0xc2},{0x92,0xc3},
    {0x92,0xc4},{0x92,0xc5},{0x92,0xc6},{0x92,0xc7},{0x92,0xc8},
    {0x92,0xc9},{0x92,0xca},{0x92,0xcb},{0x92,0xcc},{0x92,0xcd},
    {0x92,0xce},{0x92,0xcf},{0x92,0xd0},{0x92,0xd1},{0x92,0xd2},
    {0x92,0xd3},{0x92,0xd4},{0x92,0xd5},{0x92,0xd6},{0x92,0xd7},
    {0x92,0xd8},{0x92,0xd9},{0x92,0xda},{0x92,0xdb},{0x92,0xdc},
    {0x92,0xdd},{0x92,0xde},{0x92,0xdf},{0x92,0xe0},{0x92,0xe1},
    {0x92,0xe2},{0x92,0xe3},{0x92,0xe4},{0x92,0xe5},{0x92,0xe6},
    {0x92,0xe7},{0x92,0xe8},{0x92,0xe9},{0x92,0xea},{0x92,0xeb},
    {0x92,0xec},{0x92,0xed},{0x92,0xee},{0x92,0xef},{0x92,0xf0},
    {0x92,0xf1},{0x92,0xf2},{0x92,0xf3},{0x92,0xf4},{0x92,0xf5},
    {0x92,0xf6},{0x92,0xf7},{0x92,0xf8},{0x92,0xf9},{0x92,0xfa},
    {0x92,0xfb},{0x92,0xfc},{0x92,0xfd},{0x92,0xfe},{0x93,0x40},
    {0x93,0x41},{0x93,0x42},{0x93,0x43},{0x93,0x44},{0x93,0x45},
    {0x93,0x46},{0x93,0x47},{0x93,0x48},{0x93,0x49},{0x93,0x4a},
    {0x93,0x4b},{0x93,0x4c},{0x93,0x4d},{0x93,0x4e},{0x93,0x4f},
    {0x93,0x50},{0x93,0x51},{0x93,0x52},{0x93,0x53},{0x93,0x54},
    {0x93,0x55},{0x93,0x56},{0x93,0x57},{0x93,0x58},{0x93,0x59},
    {0x93,0x5a},{0x93,0x5b},{0x93,0x5c},{0x93,0x5d},{0x93,0x5e},
    {0x93,0x5f},{0x93,0x60},{0x93,0x61},{0x93,0x62},{0x93,0x63},
    {0x93,0x64},{0x93,0x65},{0x93,0x66},{0x93,0x67},{0x93,0x68},
    {0x93,0x69},{0x93,0x6a},{0x93,0x6b},{0x93,0x6c},{0x93,0x6d},
    {0x93,0x6e},{0x93,0x6f},{0x93,0x70},{0x93,0x71},{0x93,0x72},
    {0x93,0x73},{0x93,0x74},{0x93,0x75},{0x93,0x76},{0x93,0x77},
    {0x93,0x78},{0x93,0x79},{0x93,0x7a},{0x93,0x7b},{0x93,0x7c},
    {0x93,0x7d},{0x93,0x7e},{0x93,0xa1},{0x93,0xa2},{0x93,0xa3},
    {0x93,0xa4},{0x93,0xa5},{0x93,0xa6},{0x93,0xa7},{0x93,0xa8},
    {0x93,0xa9},{0x93,0xaa},{0x93,0xab},{0x93,0xac},{0x93,0xad},
    {0x93,0xae},{0x93,0xaf},{0x93,0xb0},{0x93,0xb1},{0x93,0xb2},
    {0x93,0xb3},{0x93,0xb4},{0x93,0xb5},{0x93,0xb6},{0x93,0xb7},
    {0x93,0xb8},{0x93,0xb9},{0x93,0xba},{0x93,0xbb},{0x93,0xbc},
    {0x93,0xbd},{0x93,0xbe},{0x93,0xbf},{0x93,0xc0},{0x93,0xc1},
    {0x93,0xc2},{0x93,0xc3},{0x93,0xc4},{0x93,0xc5},{0x93,0xc6},
    {0x93,0xc7},{0x93,0xc8},{0x93,0xc9},{0x93,0xca},{0x93,0xcb},
    {0x93,0xcc},{0x93,0xcd},{0x93,0xce},{0x93,0xcf},{0x93,0xd0},
    {0x93,0xd1},{0x93,0xd2},{0x93,0xd3},{0x93,0xd4},{0x93,0xd5},
    {0x93,0xd6},{0x93,0xd7},{0x93,0xd8},{0x93,0xd9},{0x93,0xda},
    {0x93,0xdb},{0x93,0xdc},{0x93,0xdd},{0x93,0xde},{0x93,0xdf},
    {0x93,0xe0},{0x93,0xe1},{0x93,0xe2},{0x93,0xe3},{0x93,0xe4},
    {0x93,0xe5},{0x93,0xe6},{0x93,0xe7},{0x93,0xe8},{0x93,0xe9},
    {0x93,0xea},{0x93,0xeb},{0x93,0xec},{0x93,0xed},{0x93,0xee},
    {0x93,0xef},{0x93,0xf0},{0x93,0xf1},{0x93,0xf2},{0x93,0xf3},
    {0x93,0xf4},{0x93,0xf5},{0x93,0xf6},{0x93,0xf7},{0x93,0xf8},
    {0x93,0xf9},{0x93,0xfa},{0x93,0xfb},{0x93,0xfc},{0x93,0xfd},
    {0x93,0xfe},{0x94,0x40},{0x94,0x41},{0x94,0x42},{0x94,0x43},
    {0x94,0x44},{0x94,0x45},{0x94,0x46},{0x94,0x47},{0x94,0x48},
    {0x94,0x49},{0x94,0x4a},{0x94,0x4b},{0x94,0x4c},{0x94,0x4d},
    {0x94,0x4e},{0x94,0x4f},{0x94,0x50},{0x94,0x51},{0x94,0x52},
    {0x94,0x53},{0x94,0x54},{0x94,0x55},{0x94,0x56},{0x94,0x57},
    {0x94,0x58},{0x94,0x59},{0x94,0x5a},{0x94,0x5b},{0x94,0x5c},
    {0x94,0x5d},{0x94,0x5e},{0x94,0x5f},{0x94,0x60},{0x94,0x61},
    {0x94,0x62},{0x94,0x63},{0x94,0x64},{0x94,0x65},{0x94,0x66},
    {0x94,0x67},{0x94,0x68},{0x94,0x69},{0x94,0x6a},{0x94,0x6b},
    {0x94,0x6c},{0x94,0x6d},{0x94,0x6e},{0x94,0x6f},{0x94,0x70},
    {0x94,0x71},{0x94,0x72},{0x94,0x73},{0x94,0x74},{0x94,0x75},
    {0x94,0x76},{0x94,0x77},{0x94,0x78},{0x94,0x79},{0x94,0x7a},
    {0x94,0x7b},{0x94,0x7c},{0x94,0x7d},{0x94,0x7e},{0x94,0xa1},
    {0x94,0xa2},{0x94,0xa3},{0x94,0xa4},{0x94,0xa5},{0x94,0xa6},
    {0x94,0xa7},{0x94,0xa8},{0x94,0xa9},{0x94,0xaa},{0x94,0xab},
    {0x94,0xac},{0x94,0xad},{0x94,0xae},{0x94,0xaf},{0x94,0xb0},
    {0x94,0xb1},{0x94,0xb2},{0x94,0xb3},{0x94,0xb4},{0x94,0xb5},
    {0x94,0xb6},{0x94,0xb7},{0x94,0xb8},{0x94,0xb9},{0x94,0xba},
    {0x94,0xbb},{0x94,0xbc},{0x94,0xbd},{0x94,0xbe},{0x94,0xbf},
    {0x94,0xc0},{0x94,0xc1},{0x94,0xc2},{0x94,0xc3},{0x94,0xc4},
    {0x94,0xc5},{0x94,0xc6},{0x94,0xc7},{0x94,0xc8},{0x94,0xc9},
    {0x94,0xca},{0x94,0xcb},{0x94,0xcc},{0x94,0xcd},{0x94,0xce},
    {0x94,0xcf},{0x94,0xd0},{0x94,0xd1},{0x94,0xd2},{0x94,0xd3},
    {0x94,0xd4},{0x94,0xd5},{0x94,0xd6},{0x94,0xd7},{0x94,0xd8},
    {0x94,0xd9},{0x94,0xda},{0x94,0xdb},{0x94,0xdc},{0x94,0xdd},
    {0x94,0xde},{0x94,0xdf},{0x94,0xe0},{0x94,0xe1},{0x94,0xe2},
    {0x94,0xe3},{0x94,0xe4},{0x94,0xe5},{0x94,0xe6},{0x94,0xe7},
    {0x94,0xe8},{0x94,0xe9},{0x94,0xea},{0x94,0xeb},{0x94,0xec},
    {0x94,0xed},{0x94,0xee},{0x94,0xef},{0x94,0xf0},{0x94,0xf1},
    {0x94,0xf2},{0x94,0xf3},{0x94,0xf4},{0x94,0xf5},{0x94,0xf6},
    {0x94,0xf7},{0x94,0xf8},{0x94,0xf9},{0x94,0xfa},{0x94,0xfb},
    {0x94,0xfc},{0x94,0xfd},{0x94,0xfe},{0x95,0x40},{0x95,0x41},
    {0x95,0x42},{0x95,0x43},{0x95,0x44},{0x95,0x45},{0x95,0x46},
    {0x95,0x47},{0x95,0x48},{0x95,0x49},{0x95,0x4a},{0x95,0x4b},
    {0x95,0x4c},{0x95,0x4d},{0x95,0x4e},{0x95,0x4f},{0x95,0x50},
    {0x95,0x51},{0x95,0x52},{0x95,0x53},{0x95,0x54},{0x95,0x55},
    {0x95,0x56},{0x95,0x57},{0x95,0x58},{0x95,0x59},{0x95,0x5a},
    {0x95,0x5b},{0x95,0x5c},{0x95,0x5d},{0x95,0x5e},{0x95,0x5f},
    {0x95,0x60},{0x95,0x61},{0x95,0x62},{0x95,0x63},{0x95,0x64},
    {0x95,0x65},{0x95,0x66},{0x95,0x67},{0x95,0x68},{0x95,0x69},
    {0x95,0x6a},{0x95,0x6b},{0x95,0x6c},{0x95,0x6d},{0x95,0x6e},
    {0x95,0x6f},{0x95,0x70},{0x95,0x71},{0x95,0x72},{0x95,0x73},
    {0x95,0x74},{0x95,0x75},{0x95,0x76},{0x95,0x77},{0x95,0x78},
    {0x95,0x79},{0x95,0x7a},{0x95,0x7b},{0x95,0x7c},{0x95,0x7d},
    {0x95,0x7e},{0x95,0xa1},{0x95,0xa2},{0x95,0xa3},{0x95,0xa4},
    {0x95,0xa5},{0x95,0xa6},{0x95,0xa7},{0x95,0xa8},{0x95,0xa9},
    {0x95,0xaa},{0x95,0xab},{0x95,0xac},{0x95,0xad},{0x95,0xae},
    {0x95,0xaf},{0x95,0xb0},{0x95,0xb1},{0x95,0xb2},{0x95,0xb3},
    {0x95,0xb4},{0x95,0xb5},{0x95,0xb6},{0x95,0xb7},{0x95,0xb8},
    {0x95,0xb9},{0x95,0xba},{0x95,0xbb},{0x95,0xbc},{0x95,0xbd},
    {0x95,0xbe},{0x95,0xbf},{0x95,0xc0},{0x95,0xc1},{0x95,0xc2},
    {0x95,0xc3},{0x95,0xc4},{0x95,0xc5},{0x95,0xc6},{0x95,0xc7},
    {0x95,0xc8},{0x95,0xc9},{0x95,0xca},{0x95,0xcb},{0x95,0xcc},
    {0x95,0xcd},{0x95,0xce},{0x95,0xcf},{0x95,0xd0},{0x95,0xd1},
    {0x95,0xd2},{0x95,0xd3},{0x95,0xd4},{0x95,0xd5},{0x95,0xd6},
    {0x95,0xd7},{0x95,0xd8},{0x95,0xd9},{0x95,0xda},{0x95,0xdb},
    {0x95,0xdc},{0x95,0xdd},{0x95,0xde},{0x95,0xdf},{0x95,0xe0},
    {0x95,0xe1},{0x95,0xe2},{0x95,0xe3},{0x95,0xe4},{0x95,0xe5},
    {0x95,0xe6},{0x95,0xe7},{0x95,0xe8},{0x95,0xe9},{0x95,0xea},
    {0x95,0xeb},{0x95,0xec},{0x95,0xed},{0x95,0xee},{0x95,0xef},
    {0x95,0xf0},{0x95,0xf1},{0x95,0xf2},{0x95,0xf3},{0x95,0xf4},
    {0x95,0xf5},{0x95,0xf6},{0x95,0xf7},{0x95,0xf8},{0x95,0xf9},
    {0x95,0xfa},{0x95,0xfb},{0x95,0xfc},{0x95,0xfd},{0x95,0xfe},
    {0x96,0x40},{0x96,0x41},{0x96,0x42},{0x96,0x43},{0x96,0x44},
    {0x96,0x45},{0x96,0x46},{0x96,0x47},{0x96,0x48},{0x96,0x49},
    {0x96,0x4a},{0x96,0x4b},{0x96,0x4c},{0x96,0x4d},{0x96,0x4e},
    {0x96,0x4f},{0x96,0x50},{0x96,0x51},{0x96,0x52},{0x96,0x53},
    {0x96,0x54},{0x96,0x55},{0x96,0x56},{0x96,0x57},{0x96,0x58},
    {0x96,0x59},{0x96,0x5a},{0x96,0x5b},{0x96,0x5c},{0x96,0x5d},
    {0x96,0x5e},{0x96,0x5f},{0x96,0x60},{0x96,0x61},{0x96,0x62},
    {0x96,0x63},{0x96,0x64},{0x96,0x65},{0x96,0x66},{0x96,0x67},
    {0x96,0x68},{0x96,0x69},{0x96,0x6a},{0x96,0x6b},{0x96,0x6c},
    {0x96,0x6d},{0x96,0x6e},{0x96,0x6f},{0x96,0x70},{0x96,0x71},
    {0x96,0x72},{0x96,0x73},{0x96,0x74},{0x96,0x75},{0x96,0x76},
    {0x96,0x77},{0x96,0x78},{0x96,0x79},{0x96,0x7a},{0x96,0x7b},
    {0x96,0x7c},{0x96,0x7d},{0x96,0x7e},{0x96,0xa1},{0x96,0xa2},
    {0x96,0xa3},{0x96,0xa4},{0x96,0xa5},{0x96,0xa6},{0x96,0xa7},
    {0x96,0xa8},{0x96,0xa9},{0x96,0xaa},{0x96,0xab},{0x96,0xac},
    {0x96,0xad},{0x96,0xae},{0x96,0xaf},{0x96,0xb0},{0x96,0xb1},
    {0x96,0xb2},{0x96,0xb3},{0x96,0xb4},{0x96,0xb5},{0x96,0xb6},
    {0x96,0xb7},{0x96,0xb8},{0x96,0xb9},{0x96,0xba},{0x96,0xbb},
    {0x96,0xbc},{0x96,0xbd},{0x96,0xbe},{0x96,0xbf},{0x96,0xc0},
    {0x96,0xc1},{0x96,0xc2},{0x96,0xc3},{0x96,0xc4},{0x96,0xc5},
    {0x96,0xc6},{0x96,0xc7},{0x96,0xc8},{0x96,0xc9},{0x96,0xca},
    {0x96,0xcb},{0x96,0xcc},{0x96,0xcd},{0x96,0xce},{0x96,0xcf},
    {0x96,0xd0},{0x96,0xd1},{0x96,0xd2},{0x96,0xd3},{0x96,0xd4},
    {0x96,0xd5},{0x96,0xd6},{0x96,0xd7},{0x96,0xd8},{0x96,0xd9},
    {0x96,0xda},{0x96,0xdb},{0x96,0xdc},{0x96,0xdd},{0x96,0xde},
    {0x96,0xdf},{0x96,0xe0},{0x96,0xe1},{0x96,0xe2},{0x96,0xe3},
    {0x96,0xe4},{0x96,0xe5},{0x96,0xe6},{0x96,0xe7},{0x96,0xe8},
    {0x96,0xe9},{0x96,0xea},{0x96,0xeb},{0x96,0xec},{0x96,0xed},
    {0x96,0xee},{0x96,0xef},{0x96,0xf0},{0x96,0xf1},{0x96,0xf2},
    {0x96,0xf3},{0x96,0xf4},{0x96,0xf5},{0x96,0xf6},{0x96,0xf7},
    {0x96,0xf8},{0x96,0xf9},{0x96,0xfa},{0x96,0xfb},{0x96,0xfc},
    {0x96,0xfd},{0x96,0xfe},{0x97,0x40},{0x97,0x41},{0x97,0x42},
    {0x97,0x43},{0x97,0x44},{0x97,0x45},{0x97,0x46},{0x97,0x47},
    {0x97,0x48},{0x97,0x49},{0x97,0x4a},{0x97,0x4b},{0x97,0x4c},
    {0x97,0x4d},{0x97,0x4e},{0x97,0x4f},{0x97,0x50},{0x97,0x51},
    {0x97,0x52},{0x97,0x53},{0x97,0x54},{0x97,0x55},{0x97,0x56},
    {0x97,0x57},{0x97,0x58},{0x97,0x59},{0x97,0x5a},{0x97,0x5b},
    {0x97,0x5c},{0x97,0x5d},{0x97,0x5e},{0x97,0x5f},{0x97,0x60},
    {0x97,0x61},{0x97,0x62},{0x97,0x63},{0x97,0x64},{0x97,0x65},
    {0x97,0x66},{0x97,0x67},{0x97,0x68},{0x97,0x69},{0x97,0x6a},
    {0x97,0x6b},{0x97,0x6c},{0x97,0x6d},{0x97,0x6e},{0x97,0x6f},
    {0x97,0x70},{0x97,0x71},{0x97,0x72},{0x97,0x73},{0x97,0x74},
    {0x97,0x75},{0x97,0x76},{0x97,0x77},{0x97,0x78},{0x97,0x79},
    {0x97,0x7a},{0x97,0x7b},{0x97,0x7c},{0x97,0x7d},{0x97,0x7e},
    {0x97,0xa1},{0x97,0xa2},{0x97,0xa3},{0x97,0xa4},{0x97,0xa5},
    {0x97,0xa6},{0x97,0xa7},{0x97,0xa8},{0x97,0xa9},{0x97,0xaa},
    {0x97,0xab},{0x97,0xac},{0x97,0xad},{0x97,0xae},{0x97,0xaf},
    {0x97,0xb0},{0x97,0xb1},{0x97,0xb2},{0x97,0xb3},{0x97,0xb4},
    {0x97,0xb5},{0x97,0xb6},{0x97,0xb7},{0x97,0xb8},{0x97,0xb9},
    {0x97,0xba},{0x97,0xbb},{0x97,0xbc},{0x97,0xbd},{0x97,0xbe},
    {0x97,0xbf},{0x97,0xc0},{0x97,0xc1},{0x97,0xc2},{0x97,0xc3},
    {0x97,0xc4},{0x97,0xc5},{0x97,0xc6},{0x97,0xc7},{0x97,0xc8},
    {0x97,0xc9},{0x97,0xca},{0x97,0xcb},{0x97,0xcc},{0x97,0xcd},
    {0x97,0xce},{0x97,0xcf},{0x97,0xd0},{0x97,0xd1},{0x97,0xd2},
    {0x97,0xd3},{0x97,0xd4},{0x97,0xd5},{0x97,0xd6},{0x97,0xd7},
    {0x97,0xd8},{0x97,0xd9},{0x97,0xda},{0x97,0xdb},{0x97,0xdc},
    {0x97,0xdd},{0x97,0xde},{0x97,0xdf},{0x97,0xe0},{0x97,0xe1},
    {0x97,0xe2},{0x97,0xe3},{0x97,0xe4},{0x97,0xe5},{0x97,0xe6},
    {0x97,0xe7},{0x97,0xe8},{0x97,0xe9},{0x97,0xea},{0x97,0xeb},
    {0x97,0xec},{0x97,0xed},{0x97,0xee},{0x97,0xef},{0x97,0xf0},
    {0x97,0xf1},{0x97,0xf2},{0x97,0xf3},{0x97,0xf4},{0x97,0xf5},
    {0x97,0xf6},{0x97,0xf7},{0x97,0xf8},{0x97,0xf9},{0x97,0xfa},
    {0x97,0xfb},{0x97,0xfc},{0x97,0xfd},{0x97,0xfe},{0x98,0x40},
    {0x98,0x41},{0x98,0x42},{0x98,0x43},{0x98,0x44},{0x98,0x45},
    {0x98,0x46},{0x98,0x47},{0x98,0x48},{0x98,0x49},{0x98,0x4a},
    {0x98,0x4b},{0x98,0x4c},{0x98,0x4d},{0x98,0x4e},{0x98,0x4f},
    {0x98,0x50},{0x98,0x51},{0x98,0x52},{0x98,0x53},{0x98,0x54},
    {0x98,0x55},{0x98,0x56},{0x98,0x57},{0x98,0x58},{0x98,0x59},
    {0x98,0x5a},{0x98,0x5b},{0x98,0x5c},{0x98,0x5d},{0x98,0x5e},
    {0x98,0x5f},{0x98,0x60},{0x98,0x61},{0x98,0x62},{0x98,0x63},
    {0x98,0x64},{0x98,0x65},{0x98,0x66},{0x98,0x67},{0x98,0x68},
    {0x98,0x69},{0x98,0x6a},{0x98,0x6b},{0x98,0x6c},{0x98,0x6d},
    {0x98,0x6e},{0x98,0x6f},{0x98,0x70},{0x98,0x71},{0x98,0x72},
    {0x98,0x73},{0x98,0x74},{0x98,0x75},{0x98,0x76},{0x98,0x77},
    {0x98,0x78},{0x98,0x79},{0x98,0x7a},{0x98,0x7b},{0x98,0x7c},
    {0x98,0x7d},{0x98,0x7e},{0x98,0xa1},{0x98,0xa2},{0x98,0xa3},
    {0x98,0xa4},{0x98,0xa5},{0x98,0xa6},{0x98,0xa7},{0x98,0xa8},
    {0x98,0xa9},{0x98,0xaa},{0x98,0xab},{0x98,0xac},{0x98,0xad},
    {0x98,0xae},{0x98,0xaf},{0x98,0xb0},{0x98,0xb1},{0x98,0xb2},
    {0x98,0xb3},{0x98,0xb4},{0x98,0xb5},{0x98,0xb6},{0x98,0xb7},
    {0x98,0xb8},{0x98,0xb9},{0x98,0xba},{0x98,0xbb},{0x98,0xbc},
    {0x98,0xbd},{0x98,0xbe},{0x98,0xbf},{0x98,0xc0},{0x98,0xc1},
    {0x98,0xc2},{0x98,0xc3},{0x98,0xc4},{0x98,0xc5},{0x98,0xc6},
    {0x98,0xc7},{0x98,0xc8},{0x98,0xc9},{0x98,0xca},{0x98,0xcb},
    {0x98,0xcc},{0x98,0xcd},{0x98,0xce},{0x98,0xcf},{0x98,0xd0},
    {0x98,0xd1},{0x98,0xd2},{0x98,0xd3},{0x98,0xd4},{0x98,0xd5},
    {0x98,0xd6},{0x98,0xd7},{0x98,0xd8},{0x98,0xd9},{0x98,0xda},
    {0x98,0xdb},{0x98,0xdc},{0x98,0xdd},{0x98,0xde},{0x98,0xdf},
    {0x98,0xe0},{0x98,0xe1},{0x98,0xe2},{0x98,0xe3},{0x98,0xe4},
    {0x98,0xe5},{0x98,0xe6},{0x98,0xe7},{0x98,0xe8},{0x98,0xe9},
    {0x98,0xea},{0x98,0xeb},{0x98,0xec},{0x98,0xed},{0x98,0xee},
    {0x98,0xef},{0x98,0xf0},{0x98,0xf1},{0x98,0xf2},{0x98,0xf3},
    {0x98,0xf4},{0x98,0xf5},{0x98,0xf6},{0x98,0xf7},{0x98,0xf8},
    {0x98,0xf9},{0x98,0xfa},{0x98,0xfb},{0x98,0xfc},{0x98,0xfd},
    {0x98,0xfe},{0x99,0x40},{0x99,0x41},{0x99,0x42},{0x99,0x43},
    {0x99,0x44},{0x99,0x45},{0x99,0x46},{0x99,0x47},{0x99,0x48},
    {0x99,0x49},{0x99,0x4a},{0x99,0x4b},{0x99,0x4c},{0x99,0x4d},
    {0x99,0x4e},{0x99,0x4f},{0x99,0x50},{0x99,0x51},{0x99,0x52},
    {0x99,0x53},{0x99,0x54},{0x99,0x55},{0x99,0x56},{0x99,0x57},
    {0x99,0x58},{0x99,0x59},{0x99,0x5a},{0x99,0x5b},{0x99,0x5c},
    {0x99,0x5d},{0x99,0x5e},{0x99,0x5f},{0x99,0x60},{0x99,0x61},
    {0x99,0x62},{0x99,0x63},{0x99,0x64},{0x99,0x65},{0x99,0x66},
    {0x99,0x67},{0x99,0x68},{0x99,0x69},{0x99,0x6a},{0x99,0x6b},
    {0x99,0x6c},{0x99,0x6d},{0x99,0x6e},{0x99,0x6f},{0x99,0x70},
    {0x99,0x71},{0x99,0x72},{0x99,0x73},{0x99,0x74},{0x99,0x75},
    {0x99,0x76},{0x99,0x77},{0x99,0x78},{0x99,0x79},{0x99,0x7a},
    {0x99,0x7b},{0x99,0x7c},{0x99,0x7d},{0x99,0x7e},{0x99,0xa1},
    {0x99,0xa2},{0x99,0xa3},{0x99,0xa4},{0x99,0xa5},{0x99,0xa6},
    {0x99,0xa7},{0x99,0xa8},{0x99,0xa9},{0x99,0xaa},{0x99,0xab},
    {0x99,0xac},{0x99,0xad},{0x99,0xae},{0x99,0xaf},{0x99,0xb0},
    {0x99,0xb1},{0x99,0xb2},{0x99,0xb3},{0x99,0xb4},{0x99,0xb5},
    {0x99,0xb6},{0x99,0xb7},{0x99,0xb8},{0x99,0xb9},{0x99,0xba},
    {0x99,0xbb},{0x99,0xbc},{0x99,0xbd},{0x99,0xbe},{0x99,0xbf},
    {0x99,0xc0},{0x99,0xc1},{0x99,0xc2},{0x99,0xc3},{0x99,0xc4},
    {0x99,0xc5},{0x99,0xc6},{0x99,0xc7},{0x99,0xc8},{0x99,0xc9},
    {0x99,0xca},{0x99,0xcb},{0x99,0xcc},{0x99,0xcd},{0x99,0xce},
    {0x99,0xcf},{0x99,0xd0},{0x99,0xd1},{0x99,0xd2},{0x99,0xd3},
    {0x99,0xd4},{0x99,0xd5},{0x99,0xd6},{0x99,0xd7},{0x99,0xd8},
    {0x99,0xd9},{0x99,0xda},{0x99,0xdb},{0x99,0xdc},{0x99,0xdd},
    {0x99,0xde},{0x99,0xdf},{0x99,0xe0},{0x99,0xe1},{0x99,0xe2},
    {0x99,0xe3},{0x99,0xe4},{0x99,0xe5},{0x99,0xe6},{0x99,0xe7},
    {0x99,0xe8},{0x99,0xe9},{0x99,0xea},{0x99,0xeb},{0x99,0xec},
    {0x99,0xed},{0x99,0xee},{0x99,0xef},{0x99,0xf0},{0x99,0xf1},
    {0x99,0xf2},{0x99,0xf3},{0x99,0xf4},{0x99,0xf5},{0x99,0xf6},
    {0x99,0xf7},{0x99,0xf8},{0x99,0xf9},{0x99,0xfa},{0x99,0xfb},
    {0x99,0xfc},{0x99,0xfd},{0x99,0xfe},{0x9a,0x40},{0x9a,0x41},
    {0x9a,0x42},{0x9a,0x43},{0x9a,0x44},{0x9a,0x45},{0x9a,0x46},
    {0x9a,0x47},{0x9a,0x48},{0x9a,0x49},{0x9a,0x4a},{0x9a,0x4b},
    {0x9a,0x4c},{0x9a,0x4d},{0x9a,0x4e},{0x9a,0x4f},{0x9a,0x50},
    {0x9a,0x51},{0x9a,0x52},{0x9a,0x53},{0x9a,0x54},{0x9a,0x55},
    {0x9a,0x56},{0x9a,0x57},{0x9a,0x58},{0x9a,0x59},{0x9a,0x5a},
    {0x9a,0x5b},{0x9a,0x5c},{0x9a,0x5d},{0x9a,0x5e},{0x9a,0x5f},
    {0x9a,0x60},{0x9a,0x61},{0x9a,0x62},{0x9a,0x63},{0x9a,0x64},
    {0x9a,0x65},{0x9a,0x66},{0x9a,0x67},{0x9a,0x68},{0x9a,0x69},
    {0x9a,0x6a},{0x9a,0x6b},{0x9a,0x6c},{0x9a,0x6d},{0x9a,0x6e},
    {0x9a,0x6f},{0x9a,0x70},{0x9a,0x71},{0x9a,0x72},{0x9a,0x73},
    {0x9a,0x74},{0x9a,0x75},{0x9a,0x76},{0x9a,0x77},{0x9a,0x78},
    {0x9a,0x79},{0x9a,0x7a},{0x9a,0x7b},{0x9a,0x7c},{0x9a,0x7d},
    {0x9a,0x7e},{0x9a,0xa1},{0x9a,0xa2},{0x9a,0xa3},{0x9a,0xa4},
    {0x9a,0xa5},{0x9a,0xa6},{0x9a,0xa7},{0x9a,0xa8},{0x9a,0xa9},
    {0x9a,0xaa},{0x9a,0xab},{0x9a,0xac},{0x9a,0xad},{0x9a,0xae},
    {0x9a,0xaf},{0x9a,0xb0},{0x9a,0xb1},{0x9a,0xb2},{0x9a,0xb3},
    {0x9a,0xb4},{0x9a,0xb5},{0x9a,0xb6},{0x9a,0xb7},{0x9a,0xb8},
    {0x9a,0xb9},{0x9a,0xba},{0x9a,0xbb},{0x9a,0xbc},{0x9a,0xbd},
    {0x9a,0xbe},{0x9a,0xbf},{0x9a,0xc0},{0x9a,0xc1},{0x9a,0xc2},
    {0x9a,0xc3},{0x9a,0xc4},{0x9a,0xc5},{0x9a,0xc6},{0x9a,0xc7},
    {0x9a,0xc8},{0x9a,0xc9},{0x9a,0xca},{0x9a,0xcb},{0x9a,0xcc},
    {0x9a,0xcd},{0x9a,0xce},{0x9a,0xcf},{0x9a,0xd0},{0x9a,0xd1},
    {0x9a,0xd2},{0x9a,0xd3},{0x9a,0xd4},{0x9a,0xd5},{0x9a,0xd6},
    {0x9a,0xd7},{0x9a,0xd8},{0x9a,0xd9},{0x9a,0xda},{0x9a,0xdb},
    {0x9a,0xdc},{0x9a,0xdd},{0x9a,0xde},{0x9a,0xdf},{0x9a,0xe0},
    {0x9a,0xe1},{0x9a,0xe2},{0x9a,0xe3},{0x9a,0xe4},{0x9a,0xe5},
    {0x9a,0xe6},{0x9a,0xe7},{0x9a,0xe8},{0x9a,0xe9},{0x9a,0xea},
    {0x9a,0xeb},{0x9a,0xec},{0x9a,0xed},{0x9a,0xee},{0x9a,0xef},
    {0x9a,0xf0},{0x9a,0xf1},{0x9a,0xf2},{0x9a,0xf3},{0x9a,0xf4},
    {0x9a,0xf5},{0x9a,0xf6},{0x9a,0xf7},{0x9a,0xf8},{0x9a,0xf9},
    {0x9a,0xfa},{0x9a,0xfb},{0x9a,0xfc},{0x9a,0xfd},{0x9a,0xfe},
    {0x9b,0x40},{0x9b,0x41},{0x9b,0x42},{0x9b,0x43},{0x9b,0x44},
    {0x9b,0x45},{0x9b,0x46},{0x9b,0x47},{0x9b,0x48},{0x9b,0x49},
    {0x9b,0x4a},{0x9b,0x4b},{0x9b,0x4c},{0x9b,0x4d},{0x9b,0x4e},
    {0x9b,0x4f},{0x9b,0x50},{0x9b,0x51},{0x9b,0x52},{0x9b,0x53},
    {0x9b,0x54},{0x9b,0x55},{0x9b,0x56},{0x9b,0x57},{0x9b,0x58},
    {0x9b,0x59},{0x9b,0x5a},{0x9b,0x5b},{0x9b,0x5c},{0x9b,0x5d},
    {0x9b,0x5e},{0x9b,0x5f},{0x9b,0x60},{0x9b,0x61},{0x9b,0x62},
    {0x9b,0x63},{0x9b,0x64},{0x9b,0x65},{0x9b,0x66},{0x9b,0x67},
    {0x9b,0x68},{0x9b,0x69},{0x9b,0x6a},{0x9b,0x6b},{0x9b,0x6c},
    {0x9b,0x6d},{0x9b,0x6e},{0x9b,0x6f},{0x9b,0x70},{0x9b,0x71},
    {0x9b,0x72},{0x9b,0x73},{0x9b,0x74},{0x9b,0x75},{0x9b,0x76},
    {0x9b,0x77},{0x9b,0x78},{0x9b,0x79},{0x9b,0x7a},{0x9b,0x7b},
    {0x9b,0x7c},{0x9b,0x7d},{0x9b,0x7e},{0x9b,0xa1},{0x9b,0xa2},
    {0x9b,0xa3},{0x9b,0xa4},{0x9b,0xa5},{0x9b,0xa6},{0x9b,0xa7},
    {0x9b,0xa8},{0x9b,0xa9},{0x9b,0xaa},{0x9b,0xab},{0x9b,0xac},
    {0x9b,0xad},{0x9b,0xae},{0x9b,0xaf},{0x9b,0xb0},{0x9b,0xb1},
    {0x9b,0xb2},{0x9b,0xb3},{0x9b,0xb4},{0x9b,0xb5},{0x9b,0xb6},
    {0x9b,0xb7},{0x9b,0xb8},{0x9b,0xb9},{0x9b,0xba},{0x9b,0xbb},
    {0x9b,0xbc},{0x9b,0xbd},{0x9b,0xbe},{0x9b,0xbf},{0x9b,0xc0},
    {0x9b,0xc1},{0x9b,0xc2},{0x9b,0xc3},{0x9b,0xc4},{0x9b,0xc5},
    {0x9b,0xc6},{0x9b,0xc7},{0x9b,0xc8},{0x9b,0xc9},{0x9b,0xca},
    {0x9b,0xcb},{0x9b,0xcc},{0x9b,0xcd},{0x9b,0xce},{0x9b,0xcf},
    {0x9b,0xd0},{0x9b,0xd1},{0x9b,0xd2},{0x9b,0xd3},{0x9b,0xd4},
    {0x9b,0xd5},{0x9b,0xd6},{0x9b,0xd7},{0x9b,0xd8},{0x9b,0xd9},
    {0x9b,0xda},{0x9b,0xdb},{0x9b,0xdc},{0x9b,0xdd},{0x9b,0xde},
    {0x9b,0xdf},{0x9b,0xe0},{0x9b,0xe1},{0x9b,0xe2},{0x9b,0xe3},
    {0x9b,0xe4},{0x9b,0xe5},{0x9b,0xe6},{0x9b,0xe7},{0x9b,0xe8},
    {0x9b,0xe9},{0x9b,0xea},{0x9b,0xeb},{0x9b,0xec},{0x9b,0xed},
    {0x9b,0xee},{0x9b,0xef},{0x9b,0xf0},{0x9b,0xf1},{0x9b,0xf2},
    {0x9b,0xf3},{0x9b,0xf4},{0x9b,0xf5},{0x9b,0xf6},{0x9b,0xf7},
    {0x9b,0xf8},{0x9b,0xf9},{0x9b,0xfa},{0x9b,0xfb},{0x9b,0xfc},
    {0x9b,0xfd},{0x9b,0xfe},{0x9c,0x40},{0x9c,0x41},{0x9c,0x42},
    {0x9c,0x43},{0x9c,0x44},{0x9c,0x45},{0x9c,0x46},{0x9c,0x47},
    {0x9c,0x48},{0x9c,0x49},{0x9c,0x4a},{0x9c,0x4b},{0x9c,0x4c},
    {0x9c,0x4d},{0x9c,0x4e},{0x9c,0x4f},{0x9c,0x50},{0x9c,0x51},
    {0x9c,0x52},{0x9c,0x53},{0x9c,0x54},{0x9c,0x55},{0x9c,0x56},
    {0x9c,0x57},{0x9c,0x58},{0x9c,0x59},{0x9c,0x5a},{0x9c,0x5b},
    {0x9c,0x5c},{0x9c,0x5d},{0x9c,0x5e},{0x9c,0x5f},{0x9c,0x60},
    {0x9c,0x61},{0x9c,0x62},{0x9c,0x63},{0x9c,0x64},{0x9c,0x65},
    {0x9c,0x66},{0x9c,0x67},{0x9c,0x68},{0x9c,0x69},{0x9c,0x6a},
    {0x9c,0x6b},{0x9c,0x6c},{0x9c,0x6d},{0x9c,0x6e},{0x9c,0x6f},
    {0x9c,0x70},{0x9c,0x71},{0x9c,0x72},{0x9c,0x73},{0x9c,0x74},
    {0x9c,0x75},{0x9c,0x76},{0x9c,0x77},{0x9c,0x78},{0x9c,0x79},
    {0x9c,0x7a},{0x9c,0x7b},{0x9c,0x7c},{0x9c,0x7d},{0x9c,0x7e},
    {0x9c,0xa1},{0x9c,0xa2},{0x9c,0xa3},{0x9c,0xa4},{0x9c,0xa5},
    {0x9c,0xa6},{0x9c,0xa7},{0x9c,0xa8},{0x9c,0xa9},{0x9c,0xaa},
    {0x9c,0xab},{0x9c,0xac},{0x9c,0xad},{0x9c,0xae},{0x9c,0xaf},
    {0x9c,0xb0},{0x9c,0xb1},{0x9c,0xb2},{0x9c,0xb3},{0x9c,0xb4},
    {0x9c,0xb5},{0x9c,0xb6},{0x9c,0xb7},{0x9c,0xb8},{0x9c,0xb9},
    {0x9c,0xba},{0x9c,0xbb},{0x9c,0xbc},{0x9c,0xbd},{0x9c,0xbe},
    {0x9c,0xbf},{0x9c,0xc0},{0x9c,0xc1},{0x9c,0xc2},{0x9c,0xc3},
    {0x9c,0xc4},{0x9c,0xc5},{0x9c,0xc6},{0x9c,0xc7},{0x9c,0xc8},
    {0x9c,0xc9},{0x9c,0xca},{0x9c,0xcb},{0x9c,0xcc},{0x9c,0xcd},
    {0x9c,0xce},{0x9c,0xcf},{0x9c,0xd0},{0x9c,0xd1},{0x9c,0xd2},
    {0x9c,0xd3},{0x9c,0xd4},{0x9c,0xd5},{0x9c,0xd6},{0x9c,0xd7},
    {0x9c,0xd8},{0x9c,0xd9},{0x9c,0xda},{0x9c,0xdb},{0x9c,0xdc},
    {0x9c,0xdd},{0x9c,0xde},{0x9c,0xdf},{0x9c,0xe0},{0x9c,0xe1},
    {0x9c,0xe2},{0x9c,0xe3},{0x9c,0xe4},{0x9c,0xe5},{0x9c,0xe6},
    {0x9c,0xe7},{0x9c,0xe8},{0x9c,0xe9},{0x9c,0xea},{0x9c,0xeb},
    {0x9c,0xec},{0x9c,0xed},{0x9c,0xee},{0x9c,0xef},{0x9c,0xf0},
    {0x9c,0xf1},{0x9c,0xf2},{0x9c,0xf3},{0x9c,0xf4},{0x9c,0xf5},
    {0x9c,0xf6},{0x9c,0xf7},{0x9c,0xf8},{0x9c,0xf9},{0x9c,0xfa},
    {0x9c,0xfb},{0x9c,0xfc},{0x9c,0xfd},{0x9c,0xfe},{0x9d,0x40},
    {0x9d,0x41},{0x9d,0x42},{0x9d,0x43},{0x9d,0x44},{0x9d,0x45},
    {0x9d,0x46},{0x9d,0x47},{0x9d,0x48},{0x9d,0x49},{0x9d,0x4a},
    {0x9d,0x4b},{0x9d,0x4c},{0x9d,0x4d},{0x9d,0x4e},{0x9d,0x4f},
    {0x9d,0x50},{0x9d,0x51},{0x9d,0x52},{0x9d,0x53},{0x9d,0x54},
    {0x9d,0x55},{0x9d,0x56},{0x9d,0x57},{0x9d,0x58},{0x9d,0x59},
    {0x9d,0x5a},{0x9d,0x5b},{0x9d,0x5c},{0x9d,0x5d},{0x9d,0x5e},
    {0x9d,0x5f},{0x9d,0x60},{0x9d,0x61},{0x9d,0x62},{0x9d,0x63},
    {0x9d,0x64},{0x9d,0x65},{0x9d,0x66},{0x9d,0x67},{0x9d,0x68},
    {0x9d,0x69},{0x9d,0x6a},{0x9d,0x6b},{0x9d,0x6c},{0x9d,0x6d},
    {0x9d,0x6e},{0x9d,0x6f},{0x9d,0x70},{0x9d,0x71},{0x9d,0x72},
    {0x9d,0x73},{0x9d,0x74},{0x9d,0x75},{0x9d,0x76},{0x9d,0x77},
    {0x9d,0x78},{0x9d,0x79},{0x9d,0x7a},{0x9d,0x7b},{0x9d,0x7c},
    {0x9d,0x7d},{0x9d,0x7e},{0x9d,0xa1},{0x9d,0xa2},{0x9d,0xa3},
    {0x9d,0xa4},{0x9d,0xa5},{0x9d,0xa6},{0x9d,0xa7},{0x9d,0xa8},
    {0x9d,0xa9},{0x9d,0xaa},{0x9d,0xab},{0x9d,0xac},{0x9d,0xad},
    {0x9d,0xae},{0x9d,0xaf},{0x9d,0xb0},{0x9d,0xb1},{0x9d,0xb2},
    {0x9d,0xb3},{0x9d,0xb4},{0x9d,0xb5},{0x9d,0xb6},{0x9d,0xb7},
    {0x9d,0xb8},{0x9d,0xb9},{0x9d,0xba},{0x9d,0xbb},{0x9d,0xbc},
    {0x9d,0xbd},{0x9d,0xbe},{0x9d,0xbf},{0x9d,0xc0},{0x9d,0xc1},
    {0x9d,0xc2},{0x9d,0xc3},{0x9d,0xc4},{0x9d,0xc5},{0x9d,0xc6},
    {0x9d,0xc7},{0x9d,0xc8},{0x9d,0xc9},{0x9d,0xca},{0x9d,0xcb},
    {0x9d,0xcc},{0x9d,0xcd},{0x9d,0xce},{0x9d,0xcf},{0x9d,0xd0},
    {0x9d,0xd1},{0x9d,0xd2},{0x9d,0xd3},{0x9d,0xd4},{0x9d,0xd5},
    {0x9d,0xd6},{0x9d,0xd7},{0x9d,0xd8},{0x9d,0xd9},{0x9d,0xda},
    {0x9d,0xdb},{0x9d,0xdc},{0x9d,0xdd},{0x9d,0xde},{0x9d,0xdf},
    {0x9d,0xe0},{0x9d,0xe1},{0x9d,0xe2},{0x9d,0xe3},{0x9d,0xe4},
    {0x9d,0xe5},{0x9d,0xe6},{0x9d,0xe7},{0x9d,0xe8},{0x9d,0xe9},
    {0x9d,0xea},{0x9d,0xeb},{0x9d,0xec},{0x9d,0xed},{0x9d,0xee},
    {0x9d,0xef},{0x9d,0xf0},{0x9d,0xf1},{0x9d,0xf2},{0x9d,0xf3},
    {0x9d,0xf4},{0x9d,0xf5},{0x9d,0xf6},{0x9d,0xf7},{0x9d,0xf8},
    {0x9d,0xf9},{0x9d,0xfa},{0x9d,0xfb},{0x9d,0xfc},{0x9d,0xfd},
    {0x9d,0xfe},{0x9e,0x40},{0x9e,0x41},{0x9e,0x42},{0x9e,0x43},
    {0x9e,0x44},{0x9e,0x45},{0x9e,0x46},{0x9e,0x47},{0x9e,0x48},
    {0x9e,0x49},{0x9e,0x4a},{0x9e,0x4b},{0x9e,0x4c},{0x9e,0x4d},
    {0x9e,0x4e},{0x9e,0x4f},{0x9e,0x50},{0x9e,0x51},{0x9e,0x52},
    {0x9e,0x53},{0x9e,0x54},{0x9e,0x55},{0x9e,0x56},{0x9e,0x57},
    {0x9e,0x58},{0x9e,0x59},{0x9e,0x5a},{0x9e,0x5b},{0x9e,0x5c},
    {0x9e,0x5d},{0x9e,0x5e},{0x9e,0x5f},{0x9e,0x60},{0x9e,0x61},
    {0x9e,0x62},{0x9e,0x63},{0x9e,0x64},{0x9e,0x65},{0x9e,0x66},
    {0x9e,0x67},{0x9e,0x68},{0x9e,0x69},{0x9e,0x6a},{0x9e,0x6b},
    {0x9e,0x6c},{0x9e,0x6d},{0x9e,0x6e},{0x9e,0x6f},{0x9e,0x70},
    {0x9e,0x71},{0x9e,0x72},{0x9e,0x73},{0x9e,0x74},{0x9e,0x75},
    {0x9e,0x76},{0x9e,0x77},{0x9e,0x78},{0x9e,0x79},{0x9e,0x7a},
    {0x9e,0x7b},{0x9e,0x7c},{0x9e,0x7d},{0x9e,0x7e},{0x9e,0xa1},
    {0x9e,0xa2},{0x9e,0xa3},{0x9e,0xa4},{0x9e,0xa5},{0x9e,0xa6},
    {0x9e,0xa7},{0x9e,0xa8},{0x9e,0xa9},{0x9e,0xaa},{0x9e,0xab},
    {0x9e,0xac},{0x9e,0xad},{0x9e,0xae},{0x9e,0xaf},{0x9e,0xb0},
    {0x9e,0xb1},{0x9e,0xb2},{0x9e,0xb3},{0x9e,0xb4},{0x9e,0xb5},
    {0x9e,0xb6},{0x9e,0xb7},{0x9e,0xb8},{0x9e,0xb9},{0x9e,0xba},
    {0x9e,0xbb},{0x9e,0xbc},{0x9e,0xbd},{0x9e,0xbe},{0x9e,0xbf},
    {0x9e,0xc0},{0x9e,0xc1},{0x9e,0xc2},{0x9e,0xc3},{0x9e,0xc4},
    {0x9e,0xc5},{0x9e,0xc6},{0x9e,0xc7},{0x9e,0xc8},{0x9e,0xc9},
    {0x9e,0xca},{0x9e,0xcb},{0x9e,0xcc},{0x9e,0xcd},{0x9e,0xce},
    {0x9e,0xcf},{0x9e,0xd0},{0x9e,0xd1},{0x9e,0xd2},{0x9e,0xd3},
    {0x9e,0xd4},{0x9e,0xd5},{0x9e,0xd6},{0x9e,0xd7},{0x9e,0xd8},
    {0x9e,0xd9},{0x9e,0xda},{0x9e,0xdb},{0x9e,0xdc},{0x9e,0xdd},
    {0x9e,0xde},{0x9e,0xdf},{0x9e,0xe0},{0x9e,0xe1},{0x9e,0xe2},
    {0x9e,0xe3},{0x9e,0xe4},{0x9e,0xe5},{0x9e,0xe6},{0x9e,0xe7},
    {0x9e,0xe8},{0x9e,0xe9},{0x9e,0xea},{0x9e,0xeb},{0x9e,0xec},
    {0x9e,0xed},{0x9e,0xee},{0x9e,0xef},{0x9e,0xf0},{0x9e,0xf1},
    {0x9e,0xf2},{0x9e,0xf3},{0x9e,0xf4},{0x9e,0xf5},{0x9e,0xf6},
    {0x9e,0xf7},{0x9e,0xf8},{0x9e,0xf9},{0x9e,0xfa},{0x9e,0xfb},
    {0x9e,0xfc},{0x9e,0xfd},{0x9e,0xfe},{0x9f,0x40},{0x9f,0x41},
    {0x9f,0x42},{0x9f,0x43},{0x9f,0x44},{0x9f,0x45},{0x9f,0x46},
    {0x9f,0x47},{0x9f,0x48},{0x9f,0x49},{0x9f,0x4a},{0x9f,0x4b},
    {0x9f,0x4c},{0x9f,0x4d},{0x9f,0x4e},{0x9f,0x4f},{0x9f,0x50},
    {0x9f,0x51},{0x9f,0x52},{0x9f,0x53},{0x9f,0x54},{0x9f,0x55},
    {0x9f,0x56},{0x9f,0x57},{0x9f,0x58},{0x9f,0x59},{0x9f,0x5a},
    {0x9f,0x5b},{0x9f,0x5c},{0x9f,0x5d},{0x9f,0x5e},{0x9f,0x5f},
    {0x9f,0x60},{0x9f,0x61},{0x9f,0x62},{0x9f,0x63},{0x9f,0x64},
    {0x9f,0x65},{0x9f,0x66},{0x9f,0x67},{0x9f,0x68},{0x9f,0x69},
    {0x9f,0x6a},{0x9f,0x6b},{0x9f,0x6c},{0x9f,0x6d},{0x9f,0x6e},
    {0x9f,0x6f},{0x9f,0x70},{0x9f,0x71},{0x9f,0x72},{0x9f,0x73},
    {0x9f,0x74},{0x9f,0x75},{0x9f,0x76},{0x9f,0x77},{0x9f,0x78},
    {0x9f,0x79},{0x9f,0x7a},{0x9f,0x7b},{0x9f,0x7c},{0x9f,0x7d},
    {0x9f,0x7e},{0x9f,0xa1},{0x9f,0xa2},{0x9f,0xa3},{0x9f,0xa4},
    {0x9f,0xa5},{0x9f,0xa6},{0x9f,0xa7},{0x9f,0xa8},{0x9f,0xa9},
    {0x9f,0xaa},{0x9f,0xab},{0x9f,0xac},{0x9f,0xad},{0x9f,0xae},
    {0x9f,0xaf},{0x9f,0xb0},{0x9f,0xb1},{0x9f,0xb2},{0x9f,0xb3},
    {0x9f,0xb4},{0x9f,0xb5},{0x9f,0xb6},{0x9f,0xb7},{0x9f,0xb8},
    {0x9f,0xb9},{0x9f,0xba},{0x9f,0xbb},{0x9f,0xbc},{0x9f,0xbd},
    {0x9f,0xbe},{0x9f,0xbf},{0x9f,0xc0},{0x9f,0xc1},{0x9f,0xc2},
    {0x9f,0xc3},{0x9f,0xc4},{0x9f,0xc5},{0x9f,0xc6},{0x9f,0xc7},
    {0x9f,0xc8},{0x9f,0xc9},{0x9f,0xca},{0x9f,0xcb},{0x9f,0xcc},
    {0x9f,0xcd},{0x9f,0xce},{0x9f,0xcf},{0x9f,0xd0},{0x9f,0xd1},
    {0x9f,0xd2},{0x9f,0xd3},{0x9f,0xd4},{0x9f,0xd5},{0x9f,0xd6},
    {0x9f,0xd7},{0x9f,0xd8},{0x9f,0xd9},{0x9f,0xda},{0x9f,0xdb},
    {0x9f,0xdc},{0x9f,0xdd},{0x9f,0xde},{0x9f,0xdf},{0x9f,0xe0},
    {0x9f,0xe1},{0x9f,0xe2},{0x9f,0xe3},{0x9f,0xe4},{0x9f,0xe5},
    {0x9f,0xe6},{0x9f,0xe7},{0x9f,0xe8},{0x9f,0xe9},{0x9f,0xea},
    {0x9f,0xeb},{0x9f,0xec},{0x9f,0xed},{0x9f,0xee},{0x9f,0xef},
    {0x9f,0xf0},{0x9f,0xf1},{0x9f,0xf2},{0x9f,0xf3},{0x9f,0xf4},
    {0x9f,0xf5},{0x9f,0xf6},{0x9f,0xf7},{0x9f,0xf8},{0x9f,0xf9},
    {0x9f,0xfa},{0x9f,0xfb},{0x9f,0xfc},{0x9f,0xfd},{0x9f,0xfe},
    {0xa0,0x40},{0xa0,0x41},{0xa0,0x42},{0xa0,0x43},{0xa0,0x44},
    {0xa0,0x45},{0xa0,0x46},{0xa0,0x47},{0xa0,0x48},{0xa0,0x49},
    {0xa0,0x4a},{0xa0,0x4b},{0xa0,0x4c},{0xa0,0x4d},{0xa0,0x4e},
    {0xa0,0x4f},{0xa0,0x50},{0xa0,0x51},{0xa0,0x52},{0xa0,0x53},
    {0xa0,0x54},{0xa0,0x55},{0xa0,0x56},{0xa0,0x57},{0xa0,0x58},
    {0xa0,0x59},{0xa0,0x5a},{0xa0,0x5b},{0xa0,0x5c},{0xa0,0x5d},
    {0xa0,0x5e},{0xa0,0x5f},{0xa0,0x60},{0xa0,0x61},{0xa0,0x62},
    {0xa0,0x63},{0xa0,0x64},{0xa0,0x65},{0xa0,0x66},{0xa0,0x67},
    {0xa0,0x68},{0xa0,0x69},{0xa0,0x6a},{0xa0,0x6b},{0xa0,0x6c},
    {0xa0,0x6d},{0xa0,0x6e},{0xa0,0x6f},{0xa0,0x70},{0xa0,0x71},
    {0xa0,0x72},{0xa0,0x73},{0xa0,0x74},{0xa0,0x75},{0xa0,0x76},
    {0xa0,0x77},{0xa0,0x78},{0xa0,0x79},{0xa0,0x7a},{0xa0,0x7b},
    {0xa0,0x7c},{0xa0,0x7d},{0xa0,0x7e},{0xa0,0xa1},{0xa0,0xa2},
    {0xa0,0xa3},{0xa0,0xa4},{0xa0,0xa5},{0xa0,0xa6},{0xa0,0xa7},
    {0xa0,0xa8},{0xa0,0xa9},{0xa0,0xaa},{0xa0,0xab},{0xa0,0xac},
    {0xa0,0xad},{0xa0,0xae},{0xa0,0xaf},{0xa0,0xb0},{0xa0,0xb1},
    {0xa0,0xb2},{0xa0,0xb3},{0xa0,0xb4},{0xa0,0xb5},{0xa0,0xb6},
    {0xa0,0xb7},{0xa0,0xb8},{0xa0,0xb9},{0xa0,0xba},{0xa0,0xbb},
    {0xa0,0xbc},{0xa0,0xbd},{0xa0,0xbe},{0xa0,0xbf},{0xa0,0xc0},
    {0xa0,0xc1},{0xa0,0xc2},{0xa0,0xc3},{0xa0,0xc4},{0xa0,0xc5},
    {0xa0,0xc6},{0xa0,0xc7},{0xa0,0xc8},{0xa0,0xc9},{0xa0,0xca},
    {0xa0,0xcb},{0xa0,0xcc},{0xa0,0xcd},{0xa0,0xce},{0xa0,0xcf},
    {0xa0,0xd0},{0xa0,0xd1},{0xa0,0xd2},{0xa0,0xd3},{0xa0,0xd4},
    {0xa0,0xd5},{0xa0,0xd6},{0xa0,0xd7},{0xa0,0xd8},{0xa0,0xd9},
    {0xa0,0xda},{0xa0,0xdb},{0xa0,0xdc},{0xa0,0xdd},{0xa0,0xde},
    {0xa0,0xdf},{0xa0,0xe0},{0xa0,0xe1},{0xa0,0xe2},{0xa0,0xe3},
    {0xa0,0xe4},{0xa0,0xe5},{0xa0,0xe6},{0xa0,0xe7},{0xa0,0xe8},
    {0xa0,0xe9},{0xa0,0xea},{0xa0,0xeb},{0xa0,0xec},{0xa0,0xed},
    {0xa0,0xee},{0xa0,0xef},{0xa0,0xf0},{0xa0,0xf1},{0xa0,0xf2},
    {0xa0,0xf3},{0xa0,0xf4},{0xa0,0xf5},{0xa0,0xf6},{0xa0,0xf7},
    {0xa0,0xf8},{0xa0,0xf9},{0xa0,0xfa},{0xa0,0xfb},{0xa0,0xfc},
    {0xa0,0xfd},{0xa0,0xfe},{0x81,0x40},{0x81,0x41},{0x81,0x42},
    {0x81,0x43},{0x81,0x44},{0x81,0x45},{0x81,0x46},{0x81,0x47},
    {0x81,0x48},{0x81,0x49},{0x81,0x4a},{0x81,0x4b},{0x81,0x4c},
    {0x81,0x4d},{0x81,0x4e},{0x81,0x4f},{0x81,0x50},{0x81,0x51},
    {0x81,0x52},{0x81,0x53},{0x81,0x54},{0x81,0x55},{0x81,0x56},
    {0x81,0x57},{0x81,0x58},{0x81,0x59},{0x81,0x5a},{0x81,0x5b},
    {0x81,0x5c},{0x81,0x5d},{0x81,0x5e},{0x81,0x5f},{0x81,0x60},
    {0x81,0x61},{0x81,0x62},{0x81,0x63},{0x81,0x64},{0x81,0x65},
    {0x81,0x66},{0x81,0x67},{0x81,0x68},{0x81,0x69},{0x81,0x6a},
    {0x81,0x6b},{0x81,0x6c},{0x81,0x6d},{0x81,0x6e},{0x81,0x6f},
    {0x81,0x70},{0x81,0x71},{0x81,0x72},{0x81,0x73},{0x81,0x74},
    {0x81,0x75},{0x81,0x76},{0x81,0x77},{0x81,0x78},{0x81,0x79},
    {0x81,0x7a},{0x81,0x7b},{0x81,0x7c},{0x81,0x7d},{0x81,0x7e},
    {0x81,0xa1},{0x81,0xa2},{0x81,0xa3},{0x81,0xa4},{0x81,0xa5},
    {0x81,0xa6},{0x81,0xa7},{0x81,0xa8},{0x81,0xa9},{0x81,0xaa},
    {0x81,0xab},{0x81,0xac},{0x81,0xad},{0x81,0xae},{0x81,0xaf},
    {0x81,0xb0},{0x81,0xb1},{0x81,0xb2},{0x81,0xb3},{0x81,0xb4},
    {0x81,0xb5},{0x81,0xb6},{0x81,0xb7},{0x81,0xb8},{0x81,0xb9},
    {0x81,0xba},{0x81,0xbb},{0x81,0xbc},{0x81,0xbd},{0x81,0xbe},
    {0x81,0xbf},{0x81,0xc0},{0x81,0xc1},{0x81,0xc2},{0x81,0xc3},
    {0x81,0xc4},{0x81,0xc5},{0x81,0xc6},{0x81,0xc7},{0x81,0xc8},
    {0x81,0xc9},{0x81,0xca},{0x81,0xcb},{0x81,0xcc},{0x81,0xcd},
    {0x81,0xce},{0x81,0xcf},{0x81,0xd0},{0x81,0xd1},{0x81,0xd2},
    {0x81,0xd3},{0x81,0xd4},{0x81,0xd5},{0x81,0xd6},{0x81,0xd7},
    {0x81,0xd8},{0x81,0xd9},{0x81,0xda},{0x81,0xdb},{0x81,0xdc},
    {0x81,0xdd},{0x81,0xde},{0x81,0xdf},{0x81,0xe0},{0x81,0xe1},
    {0x81,0xe2},{0x81,0xe3},{0x81,0xe4},{0x81,0xe5},{0x81,0xe6},
    {0x81,0xe7},{0x81,0xe8},{0x81,0xe9},{0x81,0xea},{0x81,0xeb},
    {0x81,0xec},{0x81,0xed},{0x81,0xee},{0x81,0xef},{0x81,0xf0},
    {0x81,0xf1},{0x81,0xf2},{0x81,0xf3},{0x81,0xf4},{0x81,0xf5},
    {0x81,0xf6},{0x81,0xf7},{0x81,0xf8},{0x81,0xf9},{0x81,0xfa},
    {0x81,0xfb},{0x81,0xfc},{0x81,0xfd},{0x81,0xfe},{0x82,0x40},
    {0x82,0x41},{0x82,0x42},{0x82,0x43},{0x82,0x44},{0x82,0x45},
    {0x82,0x46},{0x82,0x47},{0x82,0x48},{0x82,0x49},{0x82,0x4a},
    {0x82,0x4b},{0x82,0x4c},{0x82,0x4d},{0x82,0x4e},{0x82,0x4f},
    {0x82,0x50},{0x82,0x51},{0x82,0x52},{0x82,0x53},{0x82,0x54},
    {0x82,0x55},{0x82,0x56},{0x82,0x57},{0x82,0x58},{0x82,0x59},
    {0x82,0x5a},{0x82,0x5b},{0x82,0x5c},{0x82,0x5d},{0x82,0x5e},
    {0x82,0x5f},{0x82,0x60},{0x82,0x61},{0x82,0x62},{0x82,0x63},
    {0x82,0x64},{0x82,0x65},{0x82,0x66},{0x82,0x67},{0x82,0x68},
    {0x82,0x69},{0x82,0x6a},{0x82,0x6b},{0x82,0x6c},{0x82,0x6d},
    {0x82,0x6e},{0x82,0x6f},{0x82,0x70},{0x82,0x71},{0x82,0x72},
    {0x82,0x73},{0x82,0x74},{0x82,0x75},{0x82,0x76},{0x82,0x77},
    {0x82,0x78},{0x82,0x79},{0x82,0x7a},{0x82,0x7b},{0x82,0x7c},
    {0x82,0x7d},{0x82,0x7e},{0x82,0xa1},{0x82,0xa2},{0x82,0xa3},
    {0x82,0xa4},{0x82,0xa5},{0x82,0xa6},{0x82,0xa7},{0x82,0xa8},
    {0x82,0xa9},{0x82,0xaa},{0x82,0xab},{0x82,0xac},{0x82,0xad},
    {0x82,0xae},{0x82,0xaf},{0x82,0xb0},{0x82,0xb1},{0x82,0xb2},
    {0x82,0xb3},{0x82,0xb4},{0x82,0xb5},{0x82,0xb6},{0x82,0xb7},
    {0x82,0xb8},{0x82,0xb9},{0x82,0xba},{0x82,0xbb},{0x82,0xbc},
    {0x82,0xbd},{0x82,0xbe},{0x82,0xbf},{0x82,0xc0},{0x82,0xc1},
    {0x82,0xc2},{0x82,0xc3},{0x82,0xc4},{0x82,0xc5},{0x82,0xc6},
    {0x82,0xc7},{0x82,0xc8},{0x82,0xc9},{0x82,0xca},{0x82,0xcb},
    {0x82,0xcc},{0x82,0xcd},{0x82,0xce},{0x82,0xcf},{0x82,0xd0},
    {0x82,0xd1},{0x82,0xd2},{0x82,0xd3},{0x82,0xd4},{0x82,0xd5},
    {0x82,0xd6},{0x82,0xd7},{0x82,0xd8},{0x82,0xd9},{0x82,0xda},
    {0x82,0xdb},{0x82,0xdc},{0x82,0xdd},{0x82,0xde},{0x82,0xdf},
    {0x82,0xe0},{0x82,0xe1},{0x82,0xe2},{0x82,0xe3},{0x82,0xe4},
    {0x82,0xe5},{0x82,0xe6},{0x82,0xe7},{0x82,0xe8},{0x82,0xe9},
    {0x82,0xea},{0x82,0xeb},{0x82,0xec},{0x82,0xed},{0x82,0xee},
    {0x82,0xef},{0x82,0xf0},{0x82,0xf1},{0x82,0xf2},{0x82,0xf3},
    {0x82,0xf4},{0x82,0xf5},{0x82,0xf6},{0x82,0xf7},{0x82,0xf8},
    {0x82,0xf9},{0x82,0xfa},{0x82,0xfb},{0x82,0xfc},{0x82,0xfd},
    {0x82,0xfe},{0x83,0x40},{0x83,0x41},{0x83,0x42},{0x83,0x43},
    {0x83,0x44},{0x83,0x45},{0x83,0x46},{0x83,0x47},{0x83,0x48},
    {0x83,0x49},{0x83,0x4a},{0x83,0x4b},{0x83,0x4c},{0x83,0x4d},
    {0x83,0x4e},{0x83,0x4f},{0x83,0x50},{0x83,0x51},{0x83,0x52},
    {0x83,0x53},{0x83,0x54},{0x83,0x55},{0x83,0x56},{0x83,0x57},
    {0x83,0x58},{0x83,0x59},{0x83,0x5a},{0x83,0x5b},{0x83,0x5c},
    {0x83,0x5d},{0x83,0x5e},{0x83,0x5f},{0x83,0x60},{0x83,0x61},
    {0x83,0x62},{0x83,0x63},{0x83,0x64},{0x83,0x65},{0x83,0x66},
    {0x83,0x67},{0x83,0x68},{0x83,0x69},{0x83,0x6a},{0x83,0x6b},
    {0x83,0x6c},{0x83,0x6d},{0x83,0x6e},{0x83,0x6f},{0x83,0x70},
    {0x83,0x71},{0x83,0x72},{0x83,0x73},{0x83,0x74},{0x83,0x75},
    {0x83,0x76},{0x83,0x77},{0x83,0x78},{0x83,0x79},{0x83,0x7a},
    {0x83,0x7b},{0x83,0x7c},{0x83,0x7d},{0x83,0x7e},{0x83,0xa1},
    {0x83,0xa2},{0x83,0xa3},{0x83,0xa4},{0x83,0xa5},{0x83,0xa6},
    {0x83,0xa7},{0x83,0xa8},{0x83,0xa9},{0x83,0xaa},{0x83,0xab},
    {0x83,0xac},{0x83,0xad},{0x83,0xae},{0x83,0xaf},{0x83,0xb0},
    {0x83,0xb1},{0x83,0xb2},{0x83,0xb3},{0x83,0xb4},{0x83,0xb5},
    {0x83,0xb6},{0x83,0xb7},{0x83,0xb8},{0x83,0xb9},{0x83,0xba},
    {0x83,0xbb},{0x83,0xbc},{0x83,0xbd},{0x83,0xbe},{0x83,0xbf},
    {0x83,0xc0},{0x83,0xc1},{0x83,0xc2},{0x83,0xc3},{0x83,0xc4},
    {0x83,0xc5},{0x83,0xc6},{0x83,0xc7},{0x83,0xc8},{0x83,0xc9},
    {0x83,0xca},{0x83,0xcb},{0x83,0xcc},{0x83,0xcd},{0x83,0xce},
    {0x83,0xcf},{0x83,0xd0},{0x83,0xd1},{0x83,0xd2},{0x83,0xd3},
    {0x83,0xd4},{0x83,0xd5},{0x83,0xd6},{0x83,0xd7},{0x83,0xd8},
    {0x83,0xd9},{0x83,0xda},{0x83,0xdb},{0x83,0xdc},{0x83,0xdd},
    {0x83,0xde},{0x83,0xdf},{0x83,0xe0},{0x83,0xe1},{0x83,0xe2},
    {0x83,0xe3},{0x83,0xe4},{0x83,0xe5},{0x83,0xe6},{0x83,0xe7},
    {0x83,0xe8},{0x83,0xe9},{0x83,0xea},{0x83,0xeb},{0x83,0xec},
    {0x83,0xed},{0x83,0xee},{0x83,0xef},{0x83,0xf0},{0x83,0xf1},
    {0x83,0xf2},{0x83,0xf3},{0x83,0xf4},{0x83,0xf5},{0x83,0xf6},
    {0x83,0xf7},{0x83,0xf8},{0x83,0xf9},{0x83,0xfa},{0x83,0xfb},
    {0x83,0xfc},{0x83,0xfd},{0x83,0xfe},{0x84,0x40},{0x84,0x41},
    {0x84,0x42},{0x84,0x43},{0x84,0x44},{0x84,0x45},{0x84,0x46},
    {0x84,0x47},{0x84,0x48},{0x84,0x49},{0x84,0x4a},{0x84,0x4b},
    {0x84,0x4c},{0x84,0x4d},{0x84,0x4e},{0x84,0x4f},{0x84,0x50},
    {0x84,0x51},{0x84,0x52},{0x84,0x53},{0x84,0x54},{0x84,0x55},
    {0x84,0x56},{0x84,0x57},{0x84,0x58},{0x84,0x59},{0x84,0x5a},
    {0x84,0x5b},{0x84,0x5c},{0x84,0x5d},{0x84,0x5e},{0x84,0x5f},
    {0x84,0x60},{0x84,0x61},{0x84,0x62},{0x84,0x63},{0x84,0x64},
    {0x84,0x65},{0x84,0x66},{0x84,0x67},{0x84,0x68},{0x84,0x69},
    {0x84,0x6a},{0x84,0x6b},{0x84,0x6c},{0x84,0x6d},{0x84,0x6e},
    {0x84,0x6f},{0x84,0x70},{0x84,0x71},{0x84,0x72},{0x84,0x73},
    {0x84,0x74},{0x84,0x75},{0x84,0x76},{0x84,0x77},{0x84,0x78},
    {0x84,0x79},{0x84,0x7a},{0x84,0x7b},{0x84,0x7c},{0x84,0x7d},
    {0x84,0x7e},{0x84,0xa1},{0x84,0xa2},{0x84,0xa3},{0x84,0xa4},
    {0x84,0xa5},{0x84,0xa6},{0x84,0xa7},{0x84,0xa8},{0x84,0xa9},
    {0x84,0xaa},{0x84,0xab},{0x84,0xac},{0x84,0xad},{0x84,0xae},
    {0x84,0xaf},{0x84,0xb0},{0x84,0xb1},{0x84,0xb2},{0x84,0xb3},
    {0x84,0xb4},{0x84,0xb5},{0x84,0xb6},{0x84,0xb7},{0x84,0xb8},
    {0x84,0xb9},{0x84,0xba},{0x84,0xbb},{0x84,0xbc},{0x84,0xbd},
    {0x84,0xbe},{0x84,0xbf},{0x84,0xc0},{0x84,0xc1},{0x84,0xc2},
    {0x84,0xc3},{0x84,0xc4},{0x84,0xc5},{0x84,0xc6},{0x84,0xc7},
    {0x84,0xc8},{0x84,0xc9},{0x84,0xca},{0x84,0xcb},{0x84,0xcc},
    {0x84,0xcd},{0x84,0xce},{0x84,0xcf},{0x84,0xd0},{0x84,0xd1},
    {0x84,0xd2},{0x84,0xd3},{0x84,0xd4},{0x84,0xd5},{0x84,0xd6},
    {0x84,0xd7},{0x84,0xd8},{0x84,0xd9},{0x84,0xda},{0x84,0xdb},
    {0x84,0xdc},{0x84,0xdd},{0x84,0xde},{0x84,0xdf},{0x84,0xe0},
    {0x84,0xe1},{0x84,0xe2},{0x84,0xe3},{0x84,0xe4},{0x84,0xe5},
    {0x84,0xe6},{0x84,0xe7},{0x84,0xe8},{0x84,0xe9},{0x84,0xea},
    {0x84,0xeb},{0x84,0xec},{0x84,0xed},{0x84,0xee},{0x84,0xef},
    {0x84,0xf0},{0x84,0xf1},{0x84,0xf2},{0x84,0xf3},{0x84,0xf4},
    {0x84,0xf5},{0x84,0xf6},{0x84,0xf7},{0x84,0xf8},{0x84,0xf9},
    {0x84,0xfa},{0x84,0xfb},{0x84,0xfc},{0x84,0xfd},{0x84,0xfe},
    {0x85,0x40},{0x85,0x41},{0x85,0x42},{0x85,0x43},{0x85,0x44},
    {0x85,0x45},{0x85,0x46},{0x85,0x47},{0x85,0x48},{0x85,0x49},
    {0x85,0x4a},{0x85,0x4b},{0x85,0x4c},{0x85,0x4d},{0x85,0x4e},
    {0x85,0x4f},{0x85,0x50},{0x85,0x51},{0x85,0x52},{0x85,0x53},
    {0x85,0x54},{0x85,0x55},{0x85,0x56},{0x85,0x57},{0x85,0x58},
    {0x85,0x59},{0x85,0x5a},{0x85,0x5b},{0x85,0x5c},{0x85,0x5d},
    {0x85,0x5e},{0x85,0x5f},{0x85,0x60},{0x85,0x61},{0x85,0x62},
    {0x85,0x63},{0x85,0x64},{0x85,0x65},{0x85,0x66},{0x85,0x67},
    {0x85,0x68},{0x85,0x69},{0x85,0x6a},{0x85,0x6b},{0x85,0x6c},
    {0x85,0x6d},{0x85,0x6e},{0x85,0x6f},{0x85,0x70},{0x85,0x71},
    {0x85,0x72},{0x85,0x73},{0x85,0x74},{0x85,0x75},{0x85,0x76},
    {0x85,0x77},{0x85,0x78},{0x85,0x79},{0x85,0x7a},{0x85,0x7b},
    {0x85,0x7c},{0x85,0x7d},{0x85,0x7e},{0x85,0xa1},{0x85,0xa2},
    {0x85,0xa3},{0x85,0xa4},{0x85,0xa5},{0x85,0xa6},{0x85,0xa7},
    {0x85,0xa8},{0x85,0xa9},{0x85,0xaa},{0x85,0xab},{0x85,0xac},
    {0x85,0xad},{0x85,0xae},{0x85,0xaf},{0x85,0xb0},{0x85,0xb1},
    {0x85,0xb2},{0x85,0xb3},{0x85,0xb4},{0x85,0xb5},{0x85,0xb6},
    {0x85,0xb7},{0x85,0xb8},{0x85,0xb9},{0x85,0xba},{0x85,0xbb},
    {0x85,0xbc},{0x85,0xbd},{0x85,0xbe},{0x85,0xbf},{0x85,0xc0},
    {0x85,0xc1},{0x85,0xc2},{0x85,0xc3},{0x85,0xc4},{0x85,0xc5},
    {0x85,0xc6},{0x85,0xc7},{0x85,0xc8},{0x85,0xc9},{0x85,0xca},
    {0x85,0xcb},{0x85,0xcc},{0x85,0xcd},{0x85,0xce},{0x85,0xcf},
    {0x85,0xd0},{0x85,0xd1},{0x85,0xd2},{0x85,0xd3},{0x85,0xd4},
    {0x85,0xd5},{0x85,0xd6},{0x85,0xd7},{0x85,0xd8},{0x85,0xd9},
    {0x85,0xda},{0x85,0xdb},{0x85,0xdc},{0x85,0xdd},{0x85,0xde},
    {0x85,0xdf},{0x85,0xe0},{0x85,0xe1},{0x85,0xe2},{0x85,0xe3},
    {0x85,0xe4},{0x85,0xe5},{0x85,0xe6},{0x85,0xe7},{0x85,0xe8},
    {0x85,0xe9},{0x85,0xea},{0x85,0xeb},{0x85,0xec},{0x85,0xed},
    {0x85,0xee},{0x85,0xef},{0x85,0xf0},{0x85,0xf1},{0x85,0xf2},
    {0x85,0xf3},{0x85,0xf4},{0x85,0xf5},{0x85,0xf6},{0x85,0xf7},
    {0x85,0xf8},{0x85,0xf9},{0x85,0xfa},{0x85,0xfb},{0x85,0xfc},
    {0x85,0xfd},{0x85,0xfe},{0x86,0x40},{0x86,0x41},{0x86,0x42},
    {0x86,0x43},{0x86,0x44},{0x86,0x45},{0x86,0x46},{0x86,0x47},
    {0x86,0x48},{0x86,0x49},{0x86,0x4a},{0x86,0x4b},{0x86,0x4c},
    {0x86,0x4d},{0x86,0x4e},{0x86,0x4f},{0x86,0x50},{0x86,0x51},
    {0x86,0x52},{0x86,0x53},{0x86,0x54},{0x86,0x55},{0x86,0x56},
    {0x86,0x57},{0x86,0x58},{0x86,0x59},{0x86,0x5a},{0x86,0x5b},
    {0x86,0x5c},{0x86,0x5d},{0x86,0x5e},{0x86,0x5f},{0x86,0x60},
    {0x86,0x61},{0x86,0x62},{0x86,0x63},{0x86,0x64},{0x86,0x65},
    {0x86,0x66},{0x86,0x67},{0x86,0x68},{0x86,0x69},{0x86,0x6a},
    {0x86,0x6b},{0x86,0x6c},{0x86,0x6d},{0x86,0x6e},{0x86,0x6f},
    {0x86,0x70},{0x86,0x71},{0x86,0x72},{0x86,0x73},{0x86,0x74},
    {0x86,0x75},{0x86,0x76},{0x86,0x77},{0x86,0x78},{0x86,0x79},
    {0x86,0x7a},{0x86,0x7b},{0x86,0x7c},{0x86,0x7d},{0x86,0x7e},
    {0x86,0xa1},{0x86,0xa2},{0x86,0xa3},{0x86,0xa4},{0x86,0xa5},
    {0x86,0xa6},{0x86,0xa7},{0x86,0xa8},{0x86,0xa9},{0x86,0xaa},
    {0x86,0xab},{0x86,0xac},{0x86,0xad},{0x86,0xae},{0x86,0xaf},
    {0x86,0xb0},{0x86,0xb1},{0x86,0xb2},{0x86,0xb3},{0x86,0xb4},
    {0x86,0xb5},{0x86,0xb6},{0x86,0xb7},{0x86,0xb8},{0x86,0xb9},
    {0x86,0xba},{0x86,0xbb},{0x86,0xbc},{0x86,0xbd},{0x86,0xbe},
    {0x86,0xbf},{0x86,0xc0},{0x86,0xc1},{0x86,0xc2},{0x86,0xc3},
    {0x86,0xc4},{0x86,0xc5},{0x86,0xc6},{0x86,0xc7},{0x86,0xc8},
    {0x86,0xc9},{0x86,0xca},{0x86,0xcb},{0x86,0xcc},{0x86,0xcd},
    {0x86,0xce},{0x86,0xcf},{0x86,0xd0},{0x86,0xd1},{0x86,0xd2},
    {0x86,0xd3},{0x86,0xd4},{0x86,0xd5},{0x86,0xd6},{0x86,0xd7},
    {0x86,0xd8},{0x86,0xd9},{0x86,0xda},{0x86,0xdb},{0x86,0xdc},
    {0x86,0xdd},{0x86,0xde},{0x86,0xdf},{0x86,0xe0},{0x86,0xe1},
    {0x86,0xe2},{0x86,0xe3},{0x86,0xe4},{0x86,0xe5},{0x86,0xe6},
    {0x86,0xe7},{0x86,0xe8},{0x86,0xe9},{0x86,0xea},{0x86,0xeb},
    {0x86,0xec},{0x86,0xed},{0x86,0xee},{0x86,0xef},{0x86,0xf0},
    {0x86,0xf1},{0x86,0xf2},{0x86,0xf3},{0x86,0xf4},{0x86,0xf5},
    {0x86,0xf6},{0x86,0xf7},{0x86,0xf8},{0x86,0xf9},{0x86,0xfa},
    {0x86,0xfb},{0x86,0xfc},{0x86,0xfd},{0x86,0xfe},{0x87,0x40},
    {0x87,0x41},{0x87,0x42},{0x87,0x43},{0x87,0x44},{0x87,0x45},
    {0x87,0x46},{0x87,0x47},{0x87,0x48},{0x87,0x49},{0x87,0x4a},
    {0x87,0x4b},{0x87,0x4c},{0x87,0x4d},{0x87,0x4e},{0x87,0x4f},
    {0x87,0x50},{0x87,0x51},{0x87,0x52},{0x87,0x53},{0x87,0x54},
    {0x87,0x55},{0x87,0x56},{0x87,0x57},{0x87,0x58},{0x87,0x59},
    {0x87,0x5a},{0x87,0x5b},{0x87,0x5c},{0x87,0x5d},{0x87,0x5e},
    {0x87,0x5f},{0x87,0x60},{0x87,0x61},{0x87,0x62},{0x87,0x63},
    {0x87,0x64},{0x87,0x65},{0x87,0x66},{0x87,0x67},{0x87,0x68},
    {0x87,0x69},{0x87,0x6a},{0x87,0x6b},{0x87,0x6c},{0x87,0x6d},
    {0x87,0x6e},{0x87,0x6f},{0x87,0x70},{0x87,0x71},{0x87,0x72},
    {0x87,0x73},{0x87,0x74},{0x87,0x75},{0x87,0x76},{0x87,0x77},
    {0x87,0x78},{0x87,0x79},{0x87,0x7a},{0x87,0x7b},{0x87,0x7c},
    {0x87,0x7d},{0x87,0x7e},{0x87,0xa1},{0x87,0xa2},{0x87,0xa3},
    {0x87,0xa4},{0x87,0xa5},{0x87,0xa6},{0x87,0xa7},{0x87,0xa8},
    {0x87,0xa9},{0x87,0xaa},{0x87,0xab},{0x87,0xac},{0x87,0xad},
    {0x87,0xae},{0x87,0xaf},{0x87,0xb0},{0x87,0xb1},{0x87,0xb2},
    {0x87,0xb3},{0x87,0xb4},{0x87,0xb5},{0x87,0xb6},{0x87,0xb7},
    {0x87,0xb8},{0x87,0xb9},{0x87,0xba},{0x87,0xbb},{0x87,0xbc},
    {0x87,0xbd},{0x87,0xbe},{0x87,0xbf},{0x87,0xc0},{0x87,0xc1},
    {0x87,0xc2},{0x87,0xc3},{0x87,0xc4},{0x87,0xc5},{0x87,0xc6},
    {0x87,0xc7},{0x87,0xc8},{0x87,0xc9},{0x87,0xca},{0x87,0xcb},
    {0x87,0xcc},{0x87,0xcd},{0x87,0xce},{0x87,0xcf},{0x87,0xd0},
    {0x87,0xd1},{0x87,0xd2},{0x87,0xd3},{0x87,0xd4},{0x87,0xd5},
    {0x87,0xd6},{0x87,0xd7},{0x87,0xd8},{0x87,0xd9},{0x87,0xda},
    {0x87,0xdb},{0x87,0xdc},{0x87,0xdd},{0x87,0xde},{0x87,0xdf},
    {0x87,0xe0},{0x87,0xe1},{0x87,0xe2},{0x87,0xe3},{0x87,0xe4},
    {0x87,0xe5},{0x87,0xe6},{0x87,0xe7},{0x87,0xe8},{0x87,0xe9},
    {0x87,0xea},{0x87,0xeb},{0x87,0xec},{0x87,0xed},{0x87,0xee},
    {0x87,0xef},{0x87,0xf0},{0x87,0xf1},{0x87,0xf2},{0x87,0xf3},
    {0x87,0xf4},{0x87,0xf5},{0x87,0xf6},{0x87,0xf7},{0x87,0xf8},
    {0x87,0xf9},{0x87,0xfa},{0x87,0xfb},{0x87,0xfc},{0x87,0xfd},
    {0x87,0xfe},{0x88,0x40},{0x88,0x41},{0x88,0x42},{0x88,0x43},
    {0x88,0x44},{0x88,0x45},{0x88,0x46},{0x88,0x47},{0x88,0x48},
    {0x88,0x49},{0x88,0x4a},{0x88,0x4b},{0x88,0x4c},{0x88,0x4d},
    {0x88,0x4e},{0x88,0x4f},{0x88,0x50},{0x88,0x51},{0x88,0x52},
    {0x88,0x53},{0x88,0x54},{0x88,0x55},{0x88,0x56},{0x88,0x57},
    {0x88,0x58},{0x88,0x59},{0x88,0x5a},{0x88,0x5b},{0x88,0x5c},
    {0x88,0x5d},{0x88,0x5e},{0x88,0x5f},{0x88,0x60},{0x88,0x61},
    {0x88,0x62},{0x88,0x63},{0x88,0x64},{0x88,0x65},{0x88,0x66},
    {0x88,0x67},{0x88,0x68},{0x88,0x69},{0x88,0x6a},{0x88,0x6b},
    {0x88,0x6c},{0x88,0x6d},{0x88,0x6e},{0x88,0x6f},{0x88,0x70},
    {0x88,0x71},{0x88,0x72},{0x88,0x73},{0x88,0x74},{0x88,0x75},
    {0x88,0x76},{0x88,0x77},{0x88,0x78},{0x88,0x79},{0x88,0x7a},
    {0x88,0x7b},{0x88,0x7c},{0x88,0x7d},{0x88,0x7e},{0x88,0xa1},
    {0x88,0xa2},{0x88,0xa3},{0x88,0xa4},{0x88,0xa5},{0x88,0xa6},
    {0x88,0xa7},{0x88,0xa8},{0x88,0xa9},{0x88,0xaa},{0x88,0xab},
    {0x88,0xac},{0x88,0xad},{0x88,0xae},{0x88,0xaf},{0x88,0xb0},
    {0x88,0xb1},{0x88,0xb2},{0x88,0xb3},{0x88,0xb4},{0x88,0xb5},
    {0x88,0xb6},{0x88,0xb7},{0x88,0xb8},{0x88,0xb9},{0x88,0xba},
    {0x88,0xbb},{0x88,0xbc},{0x88,0xbd},{0x88,0xbe},{0x88,0xbf},
    {0x88,0xc0},{0x88,0xc1},{0x88,0xc2},{0x88,0xc3},{0x88,0xc4},
    {0x88,0xc5},{0x88,0xc6},{0x88,0xc7},{0x88,0xc8},{0x88,0xc9},
    {0x88,0xca},{0x88,0xcb},{0x88,0xcc},{0x88,0xcd},{0x88,0xce},
    {0x88,0xcf},{0x88,0xd0},{0x88,0xd1},{0x88,0xd2},{0x88,0xd3},
    {0x88,0xd4},{0x88,0xd5},{0x88,0xd6},{0x88,0xd7},{0x88,0xd8},
    {0x88,0xd9},{0x88,0xda},{0x88,0xdb},{0x88,0xdc},{0x88,0xdd},
    {0x88,0xde},{0x88,0xdf},{0x88,0xe0},{0x88,0xe1},{0x88,0xe2},
    {0x88,0xe3},{0x88,0xe4},{0x88,0xe5},{0x88,0xe6},{0x88,0xe7},
    {0x88,0xe8},{0x88,0xe9},{0x88,0xea},{0x88,0xeb},{0x88,0xec},
    {0x88,0xed},{0x88,0xee},{0x88,0xef},{0x88,0xf0},{0x88,0xf1},
    {0x88,0xf2},{0x88,0xf3},{0x88,0xf4},{0x88,0xf5},{0x88,0xf6},
    {0x88,0xf7},{0x88,0xf8},{0x88,0xf9},{0x88,0xfa},{0x88,0xfb},
    {0x88,0xfc},{0x88,0xfd},{0x88,0xfe},{0x89,0x40},{0x89,0x41},
    {0x89,0x42},{0x89,0x43},{0x89,0x44},{0x89,0x45},{0x89,0x46},
    {0x89,0x47},{0x89,0x48},{0x89,0x49},{0x89,0x4a},{0x89,0x4b},
    {0x89,0x4c},{0x89,0x4d},{0x89,0x4e},{0x89,0x4f},{0x89,0x50},
    {0x89,0x51},{0x89,0x52},{0x89,0x53},{0x89,0x54},{0x89,0x55},
    {0x89,0x56},{0x89,0x57},{0x89,0x58},{0x89,0x59},{0x89,0x5a},
    {0x89,0x5b},{0x89,0x5c},{0x89,0x5d},{0x89,0x5e},{0x89,0x5f},
    {0x89,0x60},{0x89,0x61},{0x89,0x62},{0x89,0x63},{0x89,0x64},
    {0x89,0x65},{0x89,0x66},{0x89,0x67},{0x89,0x68},{0x89,0x69},
    {0x89,0x6a},{0x89,0x6b},{0x89,0x6c},{0x89,0x6d},{0x89,0x6e},
    {0x89,0x6f},{0x89,0x70},{0x89,0x71},{0x89,0x72},{0x89,0x73},
    {0x89,0x74},{0x89,0x75},{0x89,0x76},{0x89,0x77},{0x89,0x78},
    {0x89,0x79},{0x89,0x7a},{0x89,0x7b},{0x89,0x7c},{0x89,0x7d},
    {0x89,0x7e},{0x89,0xa1},{0x89,0xa2},{0x89,0xa3},{0x89,0xa4},
    {0x89,0xa5},{0x89,0xa6},{0x89,0xa7},{0x89,0xa8},{0x89,0xa9},
    {0x89,0xaa},{0x89,0xab},{0x89,0xac},{0x89,0xad},{0x89,0xae},
    {0x89,0xaf},{0x89,0xb0},{0x89,0xb1},{0x89,0xb2},{0x89,0xb3},
    {0x89,0xb4},{0x89,0xb5},{0x89,0xb6},{0x89,0xb7},{0x89,0xb8},
    {0x89,0xb9},{0x89,0xba},{0x89,0xbb},{0x89,0xbc},{0x89,0xbd},
    {0x89,0xbe},{0x89,0xbf},{0x89,0xc0},{0x89,0xc1},{0x89,0xc2},
    {0x89,0xc3},{0x89,0xc4},{0x89,0xc5},{0x89,0xc6},{0x89,0xc7},
    {0x89,0xc8},{0x89,0xc9},{0x89,0xca},{0x89,0xcb},{0x89,0xcc},
    {0x89,0xcd},{0x89,0xce},{0x89,0xcf},{0x89,0xd0},{0x89,0xd1},
    {0x89,0xd2},{0x89,0xd3},{0x89,0xd4},{0x89,0xd5},{0x89,0xd6},
    {0x89,0xd7},{0x89,0xd8},{0x89,0xd9},{0x89,0xda},{0x89,0xdb},
    {0x89,0xdc},{0x89,0xdd},{0x89,0xde},{0x89,0xdf},{0x89,0xe0},
    {0x89,0xe1},{0x89,0xe2},{0x89,0xe3},{0x89,0xe4},{0x89,0xe5},
    {0x89,0xe6},{0x89,0xe7},{0x89,0xe8},{0x89,0xe9},{0x89,0xea},
    {0x89,0xeb},{0x89,0xec},{0x89,0xed},{0x89,0xee},{0x89,0xef},
    {0x89,0xf0},{0x89,0xf1},{0x89,0xf2},{0x89,0xf3},{0x89,0xf4},
    {0x89,0xf5},{0x89,0xf6},{0x89,0xf7},{0x89,0xf8},{0x89,0xf9},
    {0x89,0xfa},{0x89,0xfb},{0x89,0xfc},{0x89,0xfd},{0x89,0xfe},
    {0x8a,0x40},{0x8a,0x41},{0x8a,0x42},{0x8a,0x43},{0x8a,0x44},
    {0x8a,0x45},{0x8a,0x46},{0x8a,0x47},{0x8a,0x48},{0x8a,0x49},
    {0x8a,0x4a},{0x8a,0x4b},{0x8a,0x4c},{0x8a,0x4d},{0x8a,0x4e},
    {0x8a,0x4f},{0x8a,0x50},{0x8a,0x51},{0x8a,0x52},{0x8a,0x53},
    {0x8a,0x54},{0x8a,0x55},{0x8a,0x56},{0x8a,0x57},{0x8a,0x58},
    {0x8a,0x59},{0x8a,0x5a},{0x8a,0x5b},{0x8a,0x5c},{0x8a,0x5d},
    {0x8a,0x5e},{0x8a,0x5f},{0x8a,0x60},{0x8a,0x61},{0x8a,0x62},
    {0x8a,0x63},{0x8a,0x64},{0x8a,0x65},{0x8a,0x66},{0x8a,0x67},
    {0x8a,0x68},{0x8a,0x69},{0x8a,0x6a},{0x8a,0x6b},{0x8a,0x6c},
    {0x8a,0x6d},{0x8a,0x6e},{0x8a,0x6f},{0x8a,0x70},{0x8a,0x71},
    {0x8a,0x72},{0x8a,0x73},{0x8a,0x74},{0x8a,0x75},{0x8a,0x76},
    {0x8a,0x77},{0x8a,0x78},{0x8a,0x79},{0x8a,0x7a},{0x8a,0x7b},
    {0x8a,0x7c},{0x8a,0x7d},{0x8a,0x7e},{0x8a,0xa1},{0x8a,0xa2},
    {0x8a,0xa3},{0x8a,0xa4},{0x8a,0xa5},{0x8a,0xa6},{0x8a,0xa7},
    {0x8a,0xa8},{0x8a,0xa9},{0x8a,0xaa},{0x8a,0xab},{0x8a,0xac},
    {0x8a,0xad},{0x8a,0xae},{0x8a,0xaf},{0x8a,0xb0},{0x8a,0xb1},
    {0x8a,0xb2},{0x8a,0xb3},{0x8a,0xb4},{0x8a,0xb5},{0x8a,0xb6},
    {0x8a,0xb7},{0x8a,0xb8},{0x8a,0xb9},{0x8a,0xba},{0x8a,0xbb},
    {0x8a,0xbc},{0x8a,0xbd},{0x8a,0xbe},{0x8a,0xbf},{0x8a,0xc0},
    {0x8a,0xc1},{0x8a,0xc2},{0x8a,0xc3},{0x8a,0xc4},{0x8a,0xc5},
    {0x8a,0xc6},{0x8a,0xc7},{0x8a,0xc8},{0x8a,0xc9},{0x8a,0xca},
    {0x8a,0xcb},{0x8a,0xcc},{0x8a,0xcd},{0x8a,0xce},{0x8a,0xcf},
    {0x8a,0xd0},{0x8a,0xd1},{0x8a,0xd2},{0x8a,0xd3},{0x8a,0xd4},
    {0x8a,0xd5},{0x8a,0xd6},{0x8a,0xd7},{0x8a,0xd8},{0x8a,0xd9},
    {0x8a,0xda},{0x8a,0xdb},{0x8a,0xdc},{0x8a,0xdd},{0x8a,0xde},
    {0x8a,0xdf},{0x8a,0xe0},{0x8a,0xe1},{0x8a,0xe2},{0x8a,0xe3},
    {0x8a,0xe4},{0x8a,0xe5},{0x8a,0xe6},{0x8a,0xe7},{0x8a,0xe8},
    {0x8a,0xe9},{0x8a,0xea},{0x8a,0xeb},{0x8a,0xec},{0x8a,0xed},
    {0x8a,0xee},{0x8a,0xef},{0x8a,0xf0},{0x8a,0xf1},{0x8a,0xf2},
    {0x8a,0xf3},{0x8a,0xf4},{0x8a,0xf5},{0x8a,0xf6},{0x8a,0xf7},
    {0x8a,0xf8},{0x8a,0xf9},{0x8a,0xfa},{0x8a,0xfb},{0x8a,0xfc},
    {0x8a,0xfd},{0x8a,0xfe},{0x8b,0x40},{0x8b,0x41},{0x8b,0x42},
    {0x8b,0x43},{0x8b,0x44},{0x8b,0x45},{0x8b,0x46},{0x8b,0x47},
    {0x8b,0x48},{0x8b,0x49},{0x8b,0x4a},{0x8b,0x4b},{0x8b,0x4c},
    {0x8b,0x4d},{0x8b,0x4e},{0x8b,0x4f},{0x8b,0x50},{0x8b,0x51},
    {0x8b,0x52},{0x8b,0x53},{0x8b,0x54},{0x8b,0x55},{0x8b,0x56},
    {0x8b,0x57},{0x8b,0x58},{0x8b,0x59},{0x8b,0x5a},{0x8b,0x5b},
    {0x8b,0x5c},{0x8b,0x5d},{0x8b,0x5e},{0x8b,0x5f},{0x8b,0x60},
    {0x8b,0x61},{0x8b,0x62},{0x8b,0x63},{0x8b,0x64},{0x8b,0x65},
    {0x8b,0x66},{0x8b,0x67},{0x8b,0x68},{0x8b,0x69},{0x8b,0x6a},
    {0x8b,0x6b},{0x8b,0x6c},{0x8b,0x6d},{0x8b,0x6e},{0x8b,0x6f},
    {0x8b,0x70},{0x8b,0x71},{0x8b,0x72},{0x8b,0x73},{0x8b,0x74},
    {0x8b,0x75},{0x8b,0x76},{0x8b,0x77},{0x8b,0x78},{0x8b,0x79},
    {0x8b,0x7a},{0x8b,0x7b},{0x8b,0x7c},{0x8b,0x7d},{0x8b,0x7e},
    {0x8b,0xa1},{0x8b,0xa2},{0x8b,0xa3},{0x8b,0xa4},{0x8b,0xa5},
    {0x8b,0xa6},{0x8b,0xa7},{0x8b,0xa8},{0x8b,0xa9},{0x8b,0xaa},
    {0x8b,0xab},{0x8b,0xac},{0x8b,0xad},{0x8b,0xae},{0x8b,0xaf},
    {0x8b,0xb0},{0x8b,0xb1},{0x8b,0xb2},{0x8b,0xb3},{0x8b,0xb4},
    {0x8b,0xb5},{0x8b,0xb6},{0x8b,0xb7},{0x8b,0xb8},{0x8b,0xb9},
    {0x8b,0xba},{0x8b,0xbb},{0x8b,0xbc},{0x8b,0xbd},{0x8b,0xbe},
    {0x8b,0xbf},{0x8b,0xc0},{0x8b,0xc1},{0x8b,0xc2},{0x8b,0xc3},
    {0x8b,0xc4},{0x8b,0xc5},{0x8b,0xc6},{0x8b,0xc7},{0x8b,0xc8},
    {0x8b,0xc9},{0x8b,0xca},{0x8b,0xcb},{0x8b,0xcc},{0x8b,0xcd},
    {0x8b,0xce},{0x8b,0xcf},{0x8b,0xd0},{0x8b,0xd1},{0x8b,0xd2},
    {0x8b,0xd3},{0x8b,0xd4},{0x8b,0xd5},{0x8b,0xd6},{0x8b,0xd7},
    {0x8b,0xd8},{0x8b,0xd9},{0x8b,0xda},{0x8b,0xdb},{0x8b,0xdc},
    {0x8b,0xdd},{0x8b,0xde},{0x8b,0xdf},{0x8b,0xe0},{0x8b,0xe1},
    {0x8b,0xe2},{0x8b,0xe3},{0x8b,0xe4},{0x8b,0xe5},{0x8b,0xe6},
    {0x8b,0xe7},{0x8b,0xe8},{0x8b,0xe9},{0x8b,0xea},{0x8b,0xeb},
    {0x8b,0xec},{0x8b,0xed},{0x8b,0xee},{0x8b,0xef},{0x8b,0xf0},
    {0x8b,0xf1},{0x8b,0xf2},{0x8b,0xf3},{0x8b,0xf4},{0x8b,0xf5},
    {0x8b,0xf6},{0x8b,0xf7},{0x8b,0xf8},{0x8b,0xf9},{0x8b,0xfa},
    {0x8b,0xfb},{0x8b,0xfc},{0x8b,0xfd},{0x8b,0xfe},{0x8c,0x40},
    {0x8c,0x41},{0x8c,0x42},{0x8c,0x43},{0x8c,0x44},{0x8c,0x45},
    {0x8c,0x46},{0x8c,0x47},{0x8c,0x48},{0x8c,0x49},{0x8c,0x4a},
    {0x8c,0x4b},{0x8c,0x4c},{0x8c,0x4d},{0x8c,0x4e},{0x8c,0x4f},
    {0x8c,0x50},{0x8c,0x51},{0x8c,0x52},{0x8c,0x53},{0x8c,0x54},
    {0x8c,0x55},{0x8c,0x56},{0x8c,0x57},{0x8c,0x58},{0x8c,0x59},
    {0x8c,0x5a},{0x8c,0x5b},{0x8c,0x5c},{0x8c,0x5d},{0x8c,0x5e},
    {0x8c,0x5f},{0x8c,0x60},{0x8c,0x61},{0x8c,0x62},{0x8c,0x63},
    {0x8c,0x64},{0x8c,0x65},{0x8c,0x66},{0x8c,0x67},{0x8c,0x68},
    {0x8c,0x69},{0x8c,0x6a},{0x8c,0x6b},{0x8c,0x6c},{0x8c,0x6d},
    {0x8c,0x6e},{0x8c,0x6f},{0x8c,0x70},{0x8c,0x71},{0x8c,0x72},
    {0x8c,0x73},{0x8c,0x74},{0x8c,0x75},{0x8c,0x76},{0x8c,0x77},
    {0x8c,0x78},{0x8c,0x79},{0x8c,0x7a},{0x8c,0x7b},{0x8c,0x7c},
    {0x8c,0x7d},{0x8c,0x7e},{0x8c,0xa1},{0x8c,0xa2},{0x8c,0xa3},
    {0x8c,0xa4},{0x8c,0xa5},{0x8c,0xa6},{0x8c,0xa7},{0x8c,0xa8},
    {0x8c,0xa9},{0x8c,0xaa},{0x8c,0xab},{0x8c,0xac},{0x8c,0xad},
    {0x8c,0xae},{0x8c,0xaf},{0x8c,0xb0},{0x8c,0xb1},{0x8c,0xb2},
    {0x8c,0xb3},{0x8c,0xb4},{0x8c,0xb5},{0x8c,0xb6},{0x8c,0xb7},
    {0x8c,0xb8},{0x8c,0xb9},{0x8c,0xba},{0x8c,0xbb},{0x8c,0xbc},
    {0x8c,0xbd},{0x8c,0xbe},{0x8c,0xbf},{0x8c,0xc0},{0x8c,0xc1},
    {0x8c,0xc2},{0x8c,0xc3},{0x8c,0xc4},{0x8c,0xc5},{0x8c,0xc6},
    {0x8c,0xc7},{0x8c,0xc8},{0x8c,0xc9},{0x8c,0xca},{0x8c,0xcb},
    {0x8c,0xcc},{0x8c,0xcd},{0x8c,0xce},{0x8c,0xcf},{0x8c,0xd0},
    {0x8c,0xd1},{0x8c,0xd2},{0x8c,0xd3},{0x8c,0xd4},{0x8c,0xd5},
    {0x8c,0xd6},{0x8c,0xd7},{0x8c,0xd8},{0x8c,0xd9},{0x8c,0xda},
    {0x8c,0xdb},{0x8c,0xdc},{0x8c,0xdd},{0x8c,0xde},{0x8c,0xdf},
    {0x8c,0xe0},{0x8c,0xe1},{0x8c,0xe2},{0x8c,0xe3},{0x8c,0xe4},
    {0x8c,0xe5},{0x8c,0xe6},{0x8c,0xe7},{0x8c,0xe8},{0x8c,0xe9},
    {0x8c,0xea},{0x8c,0xeb},{0x8c,0xec},{0x8c,0xed},{0x8c,0xee},
    {0x8c,0xef},{0x8c,0xf0},{0x8c,0xf1},{0x8c,0xf2},{0x8c,0xf3},
    {0x8c,0xf4},{0x8c,0xf5},{0x8c,0xf6},{0x8c,0xf7},{0x8c,0xf8},
    {0x8c,0xf9},{0x8c,0xfa},{0x8c,0xfb},{0x8c,0xfc},{0x8c,0xfd},
    {0x8c,0xfe},{0x8d,0x40},{0x8d,0x41},{0x8d,0x42},{0x8d,0x43},
    {0x8d,0x44},{0x8d,0x45},{0x8d,0x46},{0x8d,0x47},{0x8d,0x48},
    {0x8d,0x49},{0x8d,0x4a},{0x8d,0x4b},{0x8d,0x4c},{0x8d,0x4d},
    {0x8d,0x4e},{0x8d,0x4f},{0x8d,0x50},{0x8d,0x51},{0x8d,0x52},
    {0x8d,0x53},{0x8d,0x54},{0x8d,0x55},{0x8d,0x56},{0x8d,0x57},
    {0x8d,0x58},{0x8d,0x59},{0x8d,0x5a},{0x8d,0x5b},{0x8d,0x5c},
    {0x8d,0x5d},{0x8d,0x5e},{0x8d,0x5f},{0x8d,0x60},{0x8d,0x61},
    {0x8d,0x62},{0x8d,0x63},{0x8d,0x64},{0x8d,0x65},{0x8d,0x66},
    {0x8d,0x67},{0x8d,0x68},{0x8d,0x69},{0x8d,0x6a},{0x8d,0x6b},
    {0x8d,0x6c},{0x8d,0x6d},{0x8d,0x6e},{0x8d,0x6f},{0x8d,0x70},
    {0x8d,0x71},{0x8d,0x72},{0x8d,0x73},{0x8d,0x74},{0x8d,0x75},
    {0x8d,0x76},{0x8d,0x77},{0x8d,0x78},{0x8d,0x79},{0x8d,0x7a},
    {0x8d,0x7b},{0x8d,0x7c},{0x8d,0x7d},{0x8d,0x7e},{0x8d,0xa1},
    {0x8d,0xa2},{0x8d,0xa3},{0x8d,0xa4},{0x8d,0xa5},{0x8d,0xa6},
    {0x8d,0xa7},{0x8d,0xa8},{0x8d,0xa9},{0x8d,0xaa},{0x8d,0xab},
    {0x8d,0xac},{0x8d,0xad},{0x8d,0xae},{0x8d,0xaf},{0x8d,0xb0},
    {0x8d,0xb1},{0x8d,0xb2},{0x8d,0xb3},{0x8d,0xb4},{0x8d,0xb5},
    {0x8d,0xb6},{0x8d,0xb7},{0x8d,0xb8},{0x8d,0xb9},{0x8d,0xba},
    {0x8d,0xbb},{0x8d,0xbc},{0x8d,0xbd},{0x8d,0xbe},{0x8d,0xbf},
    {0x8d,0xc0},{0x8d,0xc1},{0x8d,0xc2},{0x8d,0xc3},{0x8d,0xc4},
    {0x8d,0xc5},{0x8d,0xc6},{0x8d,0xc7},{0x8d,0xc8},{0x8d,0xc9},
    {0x8d,0xca},{0x8d,0xcb},{0x8d,0xcc},{0x8d,0xcd},{0x8d,0xce},
    {0x8d,0xcf},{0x8d,0xd0},{0x8d,0xd1},{0x8d,0xd2},{0x8d,0xd3},
    {0x8d,0xd4},{0x8d,0xd5},{0x8d,0xd6},{0x8d,0xd7},{0x8d,0xd8},
    {0x8d,0xd9},{0x8d,0xda},{0x8d,0xdb},{0x8d,0xdc},{0x8d,0xdd},
    {0x8d,0xde},{0x8d,0xdf},{0x8d,0xe0},{0x8d,0xe1},{0x8d,0xe2},
    {0x8d,0xe3},{0x8d,0xe4},{0x8d,0xe5},{0x8d,0xe6},{0x8d,0xe7},
    {0x8d,0xe8},{0x8d,0xe9},{0x8d,0xea},{0x8d,0xeb},{0x8d,0xec},
    {0x8d,0xed},{0x8d,0xee},{0x8d,0xef},{0x8d,0xf0},{0x8d,0xf1},
    {0x8d,0xf2},{0x8d,0xf3},{0x8d,0xf4},{0x8d,0xf5},{0x8d,0xf6},
    {0x8d,0xf7},{0x8d,0xf8},{0x8d,0xf9},{0x8d,0xfa},{0x8d,0xfb},
    {0x8d,0xfc},{0x8d,0xfd},{0x8d,0xfe},{0xc6,0xa1},{0xc6,0xa2},
    {0xc6,0xa3},{0xc6,0xa4},{0xc6,0xa5},{0xc6,0xa6},{0xc6,0xa7},
    {0xc6,0xa8},{0xc6,0xa9},{0xc6,0xaa},{0xc6,0xab},{0xc6,0xac},
    {0xc6,0xad},{0xc6,0xae},{0xc6,0xaf},{0xc6,0xb0},{0xc6,0xb1},
    {0xc6,0xb2},{0xc6,0xb3},{0xc6,0xb4},{0xc6,0xb5},{0xc6,0xb6},
    {0xc6,0xb7},{0xc6,0xb8},{0xc6,0xb9},{0xc6,0xba},{0xc6,0xbb},
    {0xc6,0xbc},{0xc6,0xbd},{0xc6,0xbe},{0xc6,0xbf},{0xc6,0xc0},
    {0xc6,0xc1},{0xc6,0xc2},{0xc6,0xc3},{0xc6,0xc4},{0xc6,0xc5},
    {0xc6,0xc6},{0xc6,0xc7},{0xc6,0xc8},{0xc6,0xc9},{0xc6,0xca},
    {0xc6,0xcb},{0xc6,0xcc},{0xc6,0xcd},{0xc6,0xce},{0xc6,0xcf},
    {0xc6,0xd0},{0xc6,0xd1},{0xc6,0xd2},{0xc6,0xd3},{0xc6,0xd4},
    {0xc6,0xd5},{0xc6,0xd6},{0xc6,0xd7},{0xc6,0xd8},{0xc6,0xd9},
    {0xc6,0xda},{0xc6,0xdb},{0xc6,0xdc},{0xc6,0xdd},{0xc6,0xde},
    {0xc6,0xdf},{0xc6,0xe0},{0xc6,0xe1},{0xc6,0xe2},{0xc6,0xe3},
    {0xc6,0xe4},{0xc6,0xe5},{0xc6,0xe6},{0xc6,0xe7},{0xc6,0xe8},
    {0xc6,0xe9},{0xc6,0xea},{0xc6,0xeb},{0xc6,0xec},{0xc6,0xed},
    {0xc6,0xee},{0xc6,0xef},{0xc6,0xf0},{0xc6,0xf1},{0xc6,0xf2},
    {0xc6,0xf3},{0xc6,0xf4},{0xc6,0xf5},{0xc6,0xf6},{0xc6,0xf7},
    {0xc6,0xf8},{0xc6,0xf9},{0xc6,0xfa},{0xc6,0xfb},{0xc6,0xfc},
    {0xc6,0xfd},{0xc6,0xfe},{0xc7,0x40},{0xc7,0x41},{0xc7,0x42},
    {0xc7,0x43},{0xc7,0x44},{0xc7,0x45},{0xc7,0x46},{0xc7,0x47},
    {0xc7,0x48},{0xc7,0x49},{0xc7,0x4a},{0xc7,0x4b},{0xc7,0x4c},
    {0xc7,0x4d},{0xc7,0x4e},{0xc7,0x4f},{0xc7,0x50},{0xc7,0x51},
    {0xc7,0x52},{0xc7,0x53},{0xc7,0x54},{0xc7,0x55},{0xc7,0x56},
    {0xc7,0x57},{0xc7,0x58},{0xc7,0x59},{0xc7,0x5a},{0xc7,0x5b},
    {0xc7,0x5c},{0xc7,0x5d},{0xc7,0x5e},{0xc7,0x5f},{0xc7,0x60},
    {0xc7,0x61},{0xc7,0x62},{0xc7,0x63},{0xc7,0x64},{0xc7,0x65},
    {0xc7,0x66},{0xc7,0x67},{0xc7,0x68},{0xc7,0x69},{0xc7,0x6a},
    {0xc7,0x6b},{0xc7,0x6c},{0xc7,0x6d},{0xc7,0x6e},{0xc7,0x6f},
    {0xc7,0x70},{0xc7,0x71},{0xc7,0x72},{0xc7,0x73},{0xc7,0x74},
    {0xc7,0x75},{0xc7,0x76},{0xc7,0x77},{0xc7,0x78},{0xc7,0x79},
    {0xc7,0x7a},{0xc7,0x7b},{0xc7,0x7c},{0xc7,0x7d},{0xc7,0x7e},
    {0xc7,0xa1},{0xc7,0xa2},{0xc7,0xa3},{0xc7,0xa4},{0xc7,0xa5},
    {0xc7,0xa6},{0xc7,0xa7},{0xc7,0xa8},{0xc7,0xa9},{0xc7,0xaa},
    {0xc7,0xab},{0xc7,0xac},{0xc7,0xad},{0xc7,0xae},{0xc7,0xaf},
    {0xc7,0xb0},{0xc7,0xb1},{0xc7,0xb2},{0xc7,0xb3},{0xc7,0xb4},
    {0xc7,0xb5},{0xc7,0xb6},{0xc7,0xb7},{0xc7,0xb8},{0xc7,0xb9},
    {0xc7,0xba},{0xc7,0xbb},{0xc7,0xbc},{0xc7,0xbd},{0xc7,0xbe},
    {0xc7,0xbf},{0xc7,0xc0},{0xc7,0xc1},{0xc7,0xc2},{0xc7,0xc3},
    {0xc7,0xc4},{0xc7,0xc5},{0xc7,0xc6},{0xc7,0xc7},{0xc7,0xc8},
    {0xc7,0xc9},{0xc7,0xca},{0xc7,0xcb},{0xc7,0xcc},{0xc7,0xcd},
    {0xc7,0xce},{0xc7,0xcf},{0xc7,0xd0},{0xc7,0xd1},{0xc7,0xd2},
    {0xc7,0xd3},{0xc7,0xd4},{0xc7,0xd5},{0xc7,0xd6},{0xc7,0xd7},
    {0xc7,0xd8},{0xc7,0xd9},{0xc7,0xda},{0xc7,0xdb},{0xc7,0xdc},
    {0xc7,0xdd},{0xc7,0xde},{0xc7,0xdf},{0xc7,0xe0},{0xc7,0xe1},
    {0xc7,0xe2},{0xc7,0xe3},{0xc7,0xe4},{0xc7,0xe5},{0xc7,0xe6},
    {0xc7,0xe7},{0xc7,0xe8},{0xc7,0xe9},{0xc7,0xea},{0xc7,0xeb},
    {0xc7,0xec},{0xc7,0xed},{0xc7,0xee},{0xc7,0xef},{0xc7,0xf0},
    {0xc7,0xf1},{0xc7,0xf2},{0xc7,0xf3},{0xc7,0xf4},{0xc7,0xf5},
    {0xc7,0xf6},{0xc7,0xf7},{0xc7,0xf8},{0xc7,0xf9},{0xc7,0xfa},
    {0xc7,0xfb},{0xc7,0xfc},{0xc7,0xfd},{0xc7,0xfe},{0xc8,0x40},
    {0xc8,0x41},{0xc8,0x42},{0xc8,0x43},{0xc8,0x44},{0xc8,0x45},
    {0xc8,0x46},{0xc8,0x47},{0xc8,0x48},{0xc8,0x49},{0xc8,0x4a},
    {0xc8,0x4b},{0xc8,0x4c},{0xc8,0x4d},{0xc8,0x4e},{0xc8,0x4f},
    {0xc8,0x50},{0xc8,0x51},{0xc8,0x52},{0xc8,0x53},{0xc8,0x54},
    {0xc8,0x55},{0xc8,0x56},{0xc8,0x57},{0xc8,0x58},{0xc8,0x59},
    {0xc8,0x5a},{0xc8,0x5b},{0xc8,0x5c},{0xc8,0x5d},{0xc8,0x5e},
    {0xc8,0x5f},{0xc8,0x60},{0xc8,0x61},{0xc8,0x62},{0xc8,0x63},
    {0xc8,0x64},{0xc8,0x65},{0xc8,0x66},{0xc8,0x67},{0xc8,0x68},
    {0xc8,0x69},{0xc8,0x6a},{0xc8,0x6b},{0xc8,0x6c},{0xc8,0x6d},
    {0xc8,0x6e},{0xc8,0x6f},{0xc8,0x70},{0xc8,0x71},{0xc8,0x72},
    {0xc8,0x73},{0xc8,0x74},{0xc8,0x75},{0xc8,0x76},{0xc8,0x77},
    {0xc8,0x78},{0xc8,0x79},{0xc8,0x7a},{0xc8,0x7b},{0xc8,0x7c},
    {0xc8,0x7d},{0xc8,0x7e},{0xc8,0xa1},{0xc8,0xa2},{0xc8,0xa3},
    {0xc8,0xa4},{0xc8,0xa5},{0xc8,0xa6},{0xc8,0xa7},{0xc8,0xa8},
    {0xc8,0xa9},{0xc8,0xaa},{0xc8,0xab},{0xc8,0xac},{0xc8,0xad},
    {0xc8,0xae},{0xc8,0xaf},{0xc8,0xb0},{0xc8,0xb1},{0xc8,0xb2},
    {0xc8,0xb3},{0xc8,0xb4},{0xc8,0xb5},{0xc8,0xb6},{0xc8,0xb7},
    {0xc8,0xb8},{0xc8,0xb9},{0xc8,0xba},{0xc8,0xbb},{0xc8,0xbc},
    {0xc8,0xbd},{0xc8,0xbe},{0xc8,0xbf},{0xc8,0xc0},{0xc8,0xc1},
    {0xc8,0xc2},{0xc8,0xc3},{0xc8,0xc4},{0xc8,0xc5},{0xc8,0xc6},
    {0xc8,0xc7},{0xc8,0xc8},{0xc8,0xc9},{0xc8,0xca},{0xc8,0xcb},
    {0xc8,0xcc},{0xc8,0xcd},{0xc8,0xce},{0xc8,0xcf},{0xc8,0xd0},
    {0xc8,0xd1},{0xc8,0xd2},{0xc8,0xd3},{0xc8,0xd4},{0xc8,0xd5},
    {0xc8,0xd6},{0xc8,0xd7},{0xc8,0xd8},{0xc8,0xd9},{0xc8,0xda},
    {0xc8,0xdb},{0xc8,0xdc},{0xc8,0xdd},{0xc8,0xde},{0xc8,0xdf},
    {0xc8,0xe0},{0xc8,0xe1},{0xc8,0xe2},{0xc8,0xe3},{0xc8,0xe4},
    {0xc8,0xe5},{0xc8,0xe6},{0xc8,0xe7},{0xc8,0xe8},{0xc8,0xe9},
    {0xc8,0xea},{0xc8,0xeb},{0xc8,0xec},{0xc8,0xed},{0xc8,0xee},
    {0xc8,0xef},{0xc8,0xf0},{0xc8,0xf1},{0xc8,0xf2},{0xc8,0xf3},
    {0xc8,0xf4},{0xc8,0xf5},{0xc8,0xf6},{0xc8,0xf7},{0xc8,0xf8},
    {0xc8,0xf9},{0xc8,0xfa},{0xc8,0xfb},{0xc8,0xfc},{0xc8,0xfd},
    {0xc8,0xfe},{0xa3,0xe2},{0xa3,0xe3},{0xa3,0xe4},{0xa3,0xe5},
    {0xa3,0xe6},{0xa3,0xe7},{0xa3,0xe8},{0xa3,0xe9},{0xa3,0xea},
    {0xa3,0xeb},{0xa3,0xec},{0xa3,0xed},{0xa3,0xee},{0xa3,0xef},
    {0xa3,0xf0},{0xa3,0xf1},{0xa3,0xf2},{0xa3,0xf3},{0xa3,0xf4},
    {0xa3,0xf5},{0xa3,0xf6},{0xa3,0xf7},{0xa3,0xf8},{0xa3,0xf9},
    {0xa3,0xfa},{0xa3,0xfb},{0xa3,0xfc},{0xa3,0xfd},{0xa3,0xfe},
    {0xc6,0xde},{0xc6,0xdf},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0xff},{0x00,0x00},{0x00,0x00},{0x00,0x00},
    {0x00,0x00},{0x00,0x00},{0x00,0x00},{0x00,0x00},{0xb0,0x5a},
    {0xa7,0xf3},{0xa8,0xae},{0xb8,0xeb},{0xb7,0xc6},{0xa6,0xea},
    {0xa5,0x79},{0xc0,0x74},{0xc0,0x74},{0xab,0xb4},{0xaa,0xf7},
    {0xb3,0xe2},{0xa9,0x60},{0xc3,0x69},{0xc4,0xee},{0xc3,0xb9},
    {0xc5,0xda},{0xc1,0xb3},{0xbb,0x72},{0xc5,0xde},{0xbc,0xd6},
    {0xac,0xa5},{0xaf,0x4f},{0xaf,0x5f},{0xb8,0xa8},{0xb9,0x54},
    {0xc0,0x64},{0xb6,0xc3},{0xa7,0x5a},{0xc4,0xe6},{0xc4,0xea},
    {0xc4,0xf5},{0xc6,0x7d},{0xb4,0x50},{0xc0,0xdd},{0xc2,0xc5},
    {0xc4,0xb0}