% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/331-extractDrugLargestChain.R
\name{extractDrugLargestChain}
\alias{extractDrugLargestChain}
\title{Descriptor that Calculates the Number of Atoms in the Largest Chain}
\usage{
extractDrugLargestChain(molecules, silent = TRUE)
}
\arguments{
\item{molecules}{Parsed molucule object.}

\item{silent}{Logical. Whether the calculating process
should be shown or not, default is \code{TRUE}.}
}
\value{
A data frame, each row represents one of the molecules,
each column represents one feature.
This function returns one column named \code{nAtomLC}.
}
\description{
Descriptor that Calculates the Number of Atoms in the Largest Chain
}
\details{
This descriptor calculates the number of atoms in the largest chain.
Note that a chain exists if there are two or more atoms.
Thus single atom molecules will return \code{0}.
}
\examples{
smi = system.file('vignettedata/FDAMDD.smi', package = 'Rcpi')
\donttest{
mol = readMolFromSmi(smi, type = 'mol')
dat = extractDrugLargestChain(mol)
head(dat)}
}
\author{
Nan Xiao <\url{https://nanx.me}>
}
\keyword{Chain}
\keyword{Largest}
\keyword{extractDrugLargestChain}
