% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reshape_iterations.R
\name{reshape_iterations}
\alias{reshape_iterations}
\alias{reshape_draws}
\title{Reshape estimations with multiple iterations (draws) to long format}
\usage{
reshape_iterations(x, prefix = c("draw", "iter", "iteration", "sim"))

reshape_draws(x, prefix = c("draw", "iter", "iteration", "sim"))
}
\arguments{
\item{x}{A data.frame containing posterior draws obtained from
\code{estimate_response} or \code{estimate_link}.}

\item{prefix}{The prefix of the draws (for instance, \code{"iter_"} for columns
named as \verb{iter_1, iter_2, iter_3}). If more than one are provided, will
search for the first one that matches.}
}
\value{
Data frame of reshaped draws in long format.
}
\description{
Reshape a wide data.frame of iterations (such as posterior draws or
bootsrapped samples) as columns to long format. Instead of having all
iterations as columns (e.g., \verb{iter_1, iter_2, ...}), will return 3 columns
with the \verb{\\*_index} (the previous index of the row), the \verb{\\*_group} (the
iteration number) and the \verb{\\*_value} (the value of said iteration).
}
\examples{
\donttest{
if (require("rstanarm")) {
  model <- stan_glm(mpg ~ am, data = mtcars, refresh = 0)
  draws <- insight::get_predicted(model)
  long_format <- reshape_iterations(draws)
  head(long_format)
}
}
}
