% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bold_trace.R
\name{bold_trace}
\alias{bold_trace}
\alias{print.boldtrace}
\alias{read_trace}
\alias{bold_read_trace}
\title{Get BOLD trace files}
\usage{
bold_trace(
  taxon = NULL,
  ids = NULL,
  bin = NULL,
  container = NULL,
  institutions = NULL,
  researchers = NULL,
  geo = NULL,
  marker = NULL,
  dest = NULL,
  overwrite = TRUE,
  progress = TRUE,
  ...
)

\method{print}{boldtrace}(x, ...)

read_trace(x)

bold_read_trace(x)
}
\arguments{
\item{taxon}{(character) One or more taxonomic name. Optional.}

\item{ids}{(character|integer|numeric) One or more IDs. Optional. IDs
include Sample IDs, Process IDs, Museum IDs and Field IDs.}

\item{bin}{(character) One or more Barcode Index Number URI. Optional.}

\item{container}{(character) One or more project codes or dataset codes.
Optional.}

\item{institutions}{(character) One or more institution's name. Optional.
Institutions are the Specimen Storing Site.}

\item{researchers}{(character) One or more researcher names. Optional.
Include collectors and specimen identifiers.}

\item{geo}{(character) One or more geographic sites.
Includes countries and province/states.}

\item{marker}{(character) Returns all records containing matching
marker codes.}

\item{dest}{(character) A directory to write the files to}

\item{overwrite}{(logical) Overwrite existing directory and file?}

\item{progress}{(logical) Print progress or not. NOT AVAILABLE FOR NOW.
HOPEFULLY WILL RETURN SOON.}

\item{...}{Further args passed on to \code{\link[crul]{verb-GET}}}

\item{x}{(list or character) Either the boldtrace object returned from
\code{\link[bold]{bold_trace}} or the path(s) of bold trace file(s).}
}
\description{
Get BOLD trace files
}
\examples{
\dontrun{
# Use a specific destination directory
bold_trace(taxon = "Bombus ignitus", geo = "Japan", dest = "~/mytarfiles")

# Another example
# bold_trace(ids='ACRJP618-11', dest="~/mytarfiles")
# bold_trace(ids=c('ACRJP618-11','ACRJP619-11'), dest="~/mytarfiles")

# read file in
x <- bold_trace(ids=c('ACRJP618-11','ACRJP619-11'), dest="~/mytarfiles")
(res <- read_trace(x$ab1[2]))
# read all files in
(res <- read_trace(x))

# The progress dialog is pretty verbose, so quiet=TRUE is a nice touch,
# but not by default
# Beware, this one take a while
# x <- bold_trace(taxon='Osmia', quiet=TRUE)

if (requireNamespace("sangerseqR", quietly = TRUE)) {
 library("sangerseqR")
 primarySeq(res)
 secondarySeq(res)
 head(traceMatrix(res))
}
}
}
\references{
http://v4.boldsystems.org/index.php/resources/api?type=webservices
}
