% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coxpath.R
\name{get_cox_lambda_max}
\alias{get_cox_lambda_max}
\title{Get lambda max for Cox regression model}
\usage{
get_cox_lambda_max(
  x,
  y,
  alpha,
  weights = rep(1, nrow(x)),
  offset = rep(0, nrow(x)),
  exclude = c(),
  vp = rep(1, ncol(x))
)
}
\arguments{
\item{x}{Input matrix, of dimension \code{nobs x nvars}; each row is an
observation vector. If it is a sparse matrix, it is assumed to be unstandardized.
It should have attributes \code{xm} and \code{xs}, where \code{xm(j)} and
\code{xs(j)} are the centering and scaling factors for variable j respsectively.
If it is not a sparse matrix, it is assumed to be standardized.}

\item{y}{Survival response variable, must be a \code{Surv} or
\code{stratifySurv} object.}

\item{alpha}{The elasticnet mixing parameter, with \eqn{0 \le \alpha \le 1}.}

\item{weights}{Observation weights.}

\item{offset}{Offset for the model. Default is a zero vector of length
\code{nrow(y)}.}

\item{exclude}{Indices of variables to be excluded from the model.}

\item{vp}{Separate penalty factors can be applied to each coefficient.}
}
\description{
Return the lambda max value for Cox regression model, used for computing
initial lambda values. For internal use only.
}
\details{
This function is called by \code{cox.path} for the value of lambda max.

When \code{x} is not sparse, it is expected to already by centered and scaled.
When \code{x} is sparse, the function will get its attributes \code{xm} and
\code{xs} for its centering and scaling factors. The value of
\code{lambda_max} changes depending on whether \code{x} is centered and
scaled or not, so we need \code{xm} and \code{xs} to get the correct value.
}
