% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iterators.R
\name{union.igraph.es}
\alias{union.igraph.es}
\title{Union of edge sequences}
\usage{
\method{union}{igraph.es}(...)
}
\arguments{
\item{...}{The edge sequences to take the union of.}
}
\value{
An edge sequence that contains all edges in the given
sequences, exactly once.
}
\description{
Union of edge sequences
}
\details{
They must belong to the same graph. Note that this function has
\sQuote{set} semantics and the multiplicity of edges is lost in the
result. (This is to match the behavior of the based \code{unique}
function.)
}
\examples{
g <- make_(ring(10), with_vertex_(name = LETTERS[1:10]))
union(E(g)[1:6], E(g)[5:9], E(g)['A|J'])
}
\seealso{
Other vertex and edge sequence operations: \code{\link{c.igraph.es}},
  \code{\link{c.igraph.vs}},
  \code{\link{difference.igraph.es}},
  \code{\link{difference.igraph.vs}},
  \code{\link{igraph-es-indexing2}},
  \code{\link{igraph-es-indexing}},
  \code{\link{igraph-vs-indexing2}},
  \code{\link{igraph-vs-indexing}},
  \code{\link{intersection.igraph.es}},
  \code{\link{intersection.igraph.vs}},
  \code{\link{rev.igraph.es}}, \code{\link{rev.igraph.vs}},
  \code{\link{union.igraph.vs}},
  \code{\link{unique.igraph.es}},
  \code{\link{unique.igraph.vs}}
}
\concept{vertex and edge sequence operations}
