% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quo.R
\name{as_quosure}
\alias{as_quosure}
\alias{new_quosure}
\title{Coerce object to quosure}
\usage{
as_quosure(x, env = caller_env())

new_quosure(expr, env = caller_env())
}
\arguments{
\item{x}{An object to convert. Either an \link[=is_expression]{expression} or a
formula.}

\item{env}{The original context of the context expression.}

\item{expr}{The expression wrapped by the quosure.}
}
\description{
While \code{new_quosure()} wraps any R object (including expressions,
formulas, or other quosures) into a quosure, \code{as_quosure()}
converts formulas and quosures and does not double-wrap.
}
\section{Life cycle}{

\itemize{
\item Like the rest of the rlang package, \code{new_quosure()} and
\code{as_quosure()} are maturing.
\item \code{as_quosureish()} is deprecated as of rlang 0.2.0. This function
assumes that quosures are formulas which is currently true but
might not be in the future.
}
}

\examples{
# as_quosure() converts expressions or any R object to a validly
# scoped quosure:
as_quosure(quote(expr), base_env())
as_quosure(10L, base_env())


# Sometimes you get unscoped formulas because of quotation:
f <- ~~expr
inner_f <- f_rhs(f)
str(inner_f)

# In that case testing for a scoped formula returns FALSE:
is_formula(inner_f, scoped = TRUE)

# With as_quosure() you ensure that this kind of unscoped formulas
# will be granted a default environment:
as_quosure(inner_f, base_env())
}
\seealso{
\code{\link[=quo]{quo()}}, \code{\link[=is_quosure]{is_quosure()}}
}
