% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/attr.R
\name{set_names}
\alias{set_names}
\title{Set names of a vector}
\usage{
set_names(x, nm = x, ...)
}
\arguments{
\item{x}{Vector to name.}

\item{nm, ...}{Vector of names, the same length as \code{x}. If length 1,
\code{nm} is recycled to the length of \code{x} following the recycling
rules of the tidyverse..

You can specify names in the following ways:
\itemize{
\item If not supplied, \code{x} will be named to \code{as.character(x)}.
\item If \code{x} already has names, you can provide a function or formula
to transform the existing names. In that case, \code{...} is passed
to the function.
\item Otherwise if \code{...} is supplied, \code{x} is named to \code{c(nm, ...)}.
\item If \code{nm} is \code{NULL}, the names are removed (if present).
}}
}
\description{
This is equivalent to \code{\link[stats:setNames]{stats::setNames()}}, with more features and
stricter argument checking.
}
\section{Life cycle}{


\code{set_names()} is stable and exported in purrr.
}

\examples{
set_names(1:4, c("a", "b", "c", "d"))
set_names(1:4, letters[1:4])
set_names(1:4, "a", "b", "c", "d")

# If the second argument is ommitted a vector is named with itself
set_names(letters[1:5])

# Alternatively you can supply a function
set_names(1:10, ~ letters[seq_along(.)])
set_names(head(mtcars), toupper)

# If the input vector is unnamed, it is first named after itself
# before the function is applied:
set_names(letters, toupper)

# `...` is passed to the function:
set_names(head(mtcars), paste0, "_foo")

# If length 1, the second argument is recycled to the length of the first:
set_names(1:3, "foo")
set_names(list(), "")
}
