%  file sn/man/frontier.Rd  
%  This file is a component of the package 'sn' for R
%  copyright (C) 1998 Adelchi Azzalini
%---------------------
\name{frontier}
\alias{frontier}
\title{Simulated sample from a skew-normal distribution}
\usage{data(frontier)}
\description{
  A sample simulated from the SN(0,1,5) distribution with sample
  coefficient of skewness inside the admissible range 
  (-0.9952719, 0.9952719) for the skew-normal family but
  maximum likelihood estimate on the frontier of the parameter space.
}

\format{A vector of length 50.}

\source{Generated by a run of \code{rsn(50, 0, 1, 5)}.}

\examples{
data(frontier, package="sn")
fit <- selm(frontier ~ 1)
plot(fit, which=2)
#
fit.p <- selm(frontier ~ 1, method="MPLE")
plot(fit.p, which=2)
}
\keyword{datasets}
