#ifndef _RHEO_FORM_DIAG_MANIP_H
#define _RHEO_FORM_DIAG_MANIP_H
///
/// This file is part of Rheolef.
///
/// Copyright (C) 2000-2009 Pierre Saramito <Pierre.Saramito@imag.fr>
///
/// Rheolef is free software; you can redistribute it and/or modify
/// it under the terms of the GNU General Public License as published by
/// the Free Software Foundation; either version 2 of the License, or
/// (at your option) any later version.
///
/// Rheolef is distributed in the hope that it will be useful,
/// but WITHOUT ANY WARRANTY; without even the implied warranty of
/// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
/// GNU General Public License for more details.
///
/// You should have received a copy of the GNU General Public License
/// along with Rheolef; if not, write to the Free Software
/// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
/// 
/// =========================================================================

/*Class:form_diag_manip
NAME: @code{form_diag_manip} - concatenation on a product space
DESCRIPTION: 
  build a form_diag on a product space.
EXAMPLE:
  The following example builds a 3-blocks diagonal form:
  @example
    geo g("toto.geo");
    space V(g,"P1");
    space T = V*V*V;
    form_diag Iv(V) ;
    form_diag I(T) ;
    form_manip I_manip;
    I_manip << size(3) << Iv << Iv << Iv;
    I_manip >> I;
  @end example
METHODS: @form_diag_manip
SEE ALSO: 
  "space"(3), "form_diag"(3), "form_manip"(3)
DATE:   15 sept 1997
AUTHOR: Pierre.Saramito@imag.fr
End:
*/

#include "rheolef/form_diag.h"
namespace rheolef { 

//<form_diag_manip:  
class form_diag_manip {
public:

// typedefs:

    typedef form_diag::size_type size_type;

// constructors/destructors:

    form_diag_manip();

// accessors:

    size_type nbloc() const;
    size_type nform() const;
    form_diag& bloc(size_type i);
    const form_diag& bloc(size_type i) const;

// manipulators:
  
    form_diag_manip& operator << (const form_diag& a);
    form_diag_manip& operator >> (form_diag& a);
    friend form_diag_manip& verbose (form_diag_manip &fm);
    friend form_diag_manip& noverbose (form_diag_manip &fm);
    form_diag_manip& operator<< (form_diag_manip& (*pf)(form_diag_manip&));

// implementation:

    friend class sized;
    friend form_diag_manip& operator << (form_diag_manip &fm, const class sized& s);

protected:
    bool              _verbose;
    size_type         _nform;
    size_type         _nbloc;
    std::vector<form_diag> _a;
};
//>form_diag_manip:
class sized
{
public:
  typedef form_diag_manip::size_type size_type;
  sized (size_type nbloc = 0);
  friend form_diag_manip& operator << (form_diag_manip &fm, const sized& s);
protected:
  size_type _nbloc;
};
}// namespace rheolef
#endif // _RHEO_FORM_DIAG_MANIP_H
