/*  RipOff - Plugin based CD Ripper
 *  Copyright (C) 2006 Bobby Ryan Newberry
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public Licensse as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
#ifndef RIPOFFTRACK_H
#define RIPOFFTRACK_H
#include "RipOff.h"
#include <stdlib.h>
#include <string.h>

/* Data Structure passed to plugins for music file header information*/
struct RipOffTrack_
{
	gchar *album_title_string;
	gchar *artist_string;
	gchar *genre_string;
	gchar *year_string;
	gchar *track_title;
	gint track_number;
	gint total_tracks;
};
typedef struct RipOffTrack_ * RipOffTrack;

/* returns new RipOffTrack object */
RipOffTrack ripoff_track_new();

/* returns new RipOffTrack object whose fields are set to the values of the corresponding
   parameter */
RipOffTrack ripoff_track_new_params(gchar *album, gchar *artist, gchar *genre, gchar *year, 
				    gint track, gint total);

/* Get methods. All strings returned should be freed*/
gchar* ripoff_track_get_album_title(RipOffTrack track);
gchar* ripoff_track_get_artist(RipOffTrack track);
gchar* ripoff_track_get_genre(RipOffTrack track);
gchar* ripoff_track_get_year(RipOffTrack track);
gchar* ripoff_track_get_track_title(RipOffTrack track);
gchar* ripoff_track_get_track_num_string(RipOffTrack track, gboolean leading_zero);
gint ripoff_track_get_track_num(RipOffTrack track);
gint ripoff_track_get_total_tracks(RipOffTrack track);

/* Set methods. All string functions make copies of the passed in strings. Copies can/must 
be freed */
void ripoff_track_set_album_title(RipOffTrack track, gchar *album_string);
void ripoff_track_set_artist(RipOffTrack track, gchar *artist_string);
void ripoff_track_set_genre(RipOffTrack track, gchar *genre_string);
void ripoff_track_set_year(RipOffTrack track, gchar *year_string);
void ripoff_track_set_track_title(RipOffTrack track, gchar *track_string);
void ripoff_track_set_track_num(RipOffTrack track, gint track_number);
void ripoff_track_set_total_tracks(RipOffTrack track, gint total_tracks);

/* destroys the RipOffTrack object */
void ripoff_track_destroy(RipOffTrack track);

#endif
