---
layout: guide
doc_stub: false
search: true
section: GraphQL Pro
title: Privacy
desc: Privacy Policy for GraphQL::Pro
index: 7
---

The following statement describes what data GraphQL::Pro collects during normal operation and how that data is used.

## What Data We Collect And How It's Used

GraphQL::Pro collects the following kinds of data:

Kind of Data | Use
------ | -----
Cookies | User authentication
HTTP traffic information, such as IP address and bundler credential | Authentication, system operation
User-provided profile information, such as contact email address and company name | Business communications, newsletter delivery (if signed up)
Billing information | Recurring payment for GraphQL::Pro license

The `graphql-pro` Ruby gem collects no data and never "phones home" for any purpose.

GraphQL::Pro is not directed at children under the age of 13. If you are under age 13, please do not use GraphQL::Pro.

## Third-Party Services

Use of GraphQL::Pro includes the following third-party services:

Name of Service | Use
------|------
GitHub Pages | Website Hosting
Digital Ocean | Cloud Application Hosting
Heroku | Cloud Application Hosting
Bugsnag | Application Monitoring
New Relic APM | Application Monitoring
Papertrail | Application Monitoring
Stripe | Payment Processing
Buttondown | Newsletter Management
Google Apps | Company Infrastructure

## Data Security

GraphQL::Pro does not collect ["Sensitive Personal Information"](https://gdpr-info.eu/art-9-gdpr/). GraphQL::Pro's systems are secured with strong, unique passwords and two-factor authentication is enabled wherever possible.

You are responsible for using a strong, unique password to log into https://billing.graphql.pro.

## More Information

This document is managed [on GitHub](https://github.com/rmosolgo/graphql-ruby/blob/master/guides/pro/privacy.md). You can use a GitHub account to watch for changes or subscribe to a [public RSS feed](https://github.com/rmosolgo/graphql-ruby/commits/master.atom).

For questions, comments, or requests regarding this policy, please contact [info@graphql.pro](mailto:info@graphql.pro)
