# Security policy
**Do not report security vulnerabilities through public GitHub issues.**

Instead, you can report them using [our security page](https://github.com/memorysafety/sudo-rs/security). Alternatively, you can also send them
by email to security+sudo@tweedegolf.com. You can encrypt your email using GnuPG if you want. Use the GPG key with fingerprint
[C2E4 CAC4 B122 25DE 1C3B  B1C9 289D 0820 03D0 1E95](https://keys.openpgp.org/search?q=C2E4CAC4B12225DE1C3BB1C9289D082003D01E95).

Include as much of the following information:

 * Type of issue (e.g. buffer overflow, privilege escalation, etc).
 * The location of the affected source code (tag/branch/commit or direct URL).
 * Any special configuration required to reproduce the issue.
 * The Linux distribution affected.
 * Step-by-step instructions to reproduce the issue.
 * Impact of the issue, including how an attacker might exploit the issue.

If you have found a bug that also exists in the original sudo (which, although unlikely, means it is a very serious issue), you **must**
also follow the steps at https://www.sudo.ws/security/policy/

## Preferred Languages
We prefer to receive reports in English. If necessary, we also understand Spanish, German and Dutch.

## Disclosure Policy
Like original sudo, we adhere to the principle of [Coordinated Vulnerability Disclosure](https://vuls.cert.org/confluence/display/CVD/Executive+Summary).

# Security Advisories
Security advisories will be published [on GitHub](https://github.com/memorysafety/sudo-rs/security/advisories) and possibly through other channels.
