/* ====================================================================
 * Copyright (c) 2009       Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#ifndef _TEXTSTATUSFILTER_H
#define _TEXTSTATUSFILTER_H

// sc
#include "StatusId.h"

// sys
#include <set>

class TextStatusFilter
{
public:
  bool test( StatusId statusId ) const;
  void set( StatusId statusId );
  void clear( StatusId statusId );
  bool isDefault() const;

  const std::set<StatusId>& getStatusIds() const;
  static TextStatusFilter getDefaultFilter();

private:
  std::set<StatusId> _filter;
};

#endif // _TEXTSTATUSFILTER_H
