/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.texparserlib.latex.fontenc;

import com.dickimawbooks.texparserlib.FontEncoding;
import com.dickimawbooks.texparserlib.TeXSettings;
import com.dickimawbooks.texparserlib.latex.KeyValList;
import com.dickimawbooks.texparserlib.latex.LaTeXParserListener;
import com.dickimawbooks.texparserlib.latex.LaTeXSty;
import com.dickimawbooks.texparserlib.latex.fontenc.FontEncodingCs;
import com.dickimawbooks.texparserlib.latex.fontenc.T2AEncoding;
import com.dickimawbooks.texparserlib.latex.fontenc.T2BEncoding;
import com.dickimawbooks.texparserlib.latex.fontenc.T2CEncoding;
import java.io.IOException;
import java.util.HashMap;

public class FontEncSty
extends LaTeXSty {
    private HashMap<String, FontEncoding> encodings;

    public FontEncSty(KeyValList keyValList, LaTeXParserListener laTeXParserListener) throws IOException {
        this(keyValList, "fontenc", laTeXParserListener);
    }

    public FontEncSty(KeyValList keyValList, String string, LaTeXParserListener laTeXParserListener) throws IOException {
        super(keyValList, string, laTeXParserListener);
    }

    @Override
    public void addDefinitions() {
        LaTeXParserListener laTeXParserListener = this.getListener();
        this.registerControlSequence(new FontEncodingCs(this));
    }

    @Override
    public void processOption(String string) throws IOException {
        FontEncoding fontEncoding = this.getEncoding(string);
        LaTeXParserListener laTeXParserListener = this.getListener();
        TeXSettings teXSettings = laTeXParserListener.getParser().getSettings();
        teXSettings.setFontEncoding(fontEncoding);
    }

    @Override
    protected void preOptions() throws IOException {
        this.registerEncoding(new T2AEncoding());
        this.registerEncoding(new T2BEncoding());
        this.registerEncoding(new T2CEncoding());
    }

    public FontEncoding getEncoding(String string) {
        if (this.encodings == null) {
            return null;
        }
        return this.encodings.get(string);
    }

    public void registerEncoding(FontEncoding fontEncoding) {
        this.registerEncoding(fontEncoding.getName(), fontEncoding);
    }

    public void registerEncoding(String string, FontEncoding fontEncoding) {
        if (this.encodings == null) {
            this.encodings = new HashMap();
        }
        this.encodings.put(string, fontEncoding);
    }
}

