Version: 1.04
Maintainer: Aditya Kolachana

# Shobhika 
## A Devanāgarī font for scholars

Shobhika is a free, open source, Unicode compliant, OpenType font with support for Devanāgarī, Latin, and Cyrillic scripts. It is available in two weights—regular and bold. The font is designed with over 1600 Devanāgarī glyphs, including support for over 1100 conjunct consonants, as well as vedic accents. The Latin component of the font not only supports a wide range of characters required for Roman transliteration of Sanskrit, but also provides a subset of regularly used mathematical symbols for scholars working with scientific and technical documents. The project has been launched under the auspices of the Science and Heritage Initiative (SandHI) at [IIT Bombay](www.iitb.ac.in), and builds upon the following two fonts for its Devanāgarī and Latin components respectively: (i) [Yashomudra](https://github.com/RajyaMarathiVikasSanstha/Yashomudra) by [Rājya Marāṭhī Vikās Saṃsthā](https://rmvs.maharashtra.gov.in), and (ii) [PT Serif](https://fonts.google.com/specimen/PT+Serif) by [ParaType](http://www.paratype.com). We would like to thank both these organisations for releasing their fonts under the SIL Open Font Licence, which has enabled us to create Shobhika. 

--------------

## Highlights of the font

The following are the main features of the Shobhika font:

* **Outstanding support for Devanāgarī conjuncts:** Building upon the Yashomudra font, Shobhika ships with support for over 1100 Devanāgarī conjunct characters found in Sanskrit texts, and also includes support for some common conjuncts found in Marathi, Urdu, and English. The ि and ी *mātrās* have been designed in multiple widths to ensure that they sit properly on conjunct characters of various widths. Marks like the *repha*, *bindu*, and *chandrabindu* have been designed to render properly together with various *mātrās*.

* **Support for vedic accents:** Shobhika supports the *svarita*, *dīrgha-svarita*, and the *anudātta*, as well as a number of other vedic accents and nasalisation marks required for the proper typesetting of *ṛgveda* and *yajurveda*.

* **Availability in two weights:** Shobhika is available in regular and **bold** weights.

* **Good quality companion Latin font:** Building upon the PT Serif font, Shobhika ships with additional glyphs required for English transliteration of Devanāgarī, and also inherits the base font's support for the Cyrillic script. Additional mathematical symbols have been added to cater to a wider range of scholarly requirements. 

## License

Shobhika is licensed under the [SIL Open Font License v1.1](http://scripts.sil.org/OFL)

To view the copyright and specific terms and conditions please refer to [OFL.txt](OFL.txt)
 
## People & Organizations involved

The font was developed at IIT Bombay under the guidance and supervision of [Prof K. Ramasubramanian](http://www.iitb.ac.in/en/employee/prof-k-ramasubramanian) and [Prof. Girish Dalvi](http://www.idc.iitb.ac.in/~girish), belonging to the Cell for Indian Science and Technology in Sanskrit (CISTS), and the [Industrial Design Centre (IDC)](http://www.idc.iitb.ac.in) respectively. The project was conceptualised and led by Aditya Kolachana at the CISTS. Design of the extensive set of Devanāgarī conjunct characters (based upon the characters of the original Yashomudra font), as well as additional Latin and mathematical characters (based upon the characters of PT Serif), was carried out by [Yashodeep Gholap](http://www.yashodeepgholap.com). The code to run the font was written by Vishvendra Singh Poonia and Abhishek Sharma, with help from Rohit Saluja. Faculty and friends from IIT Bombay and outside also contributed with advice and helped in testing the font. Rājya Marāṭhī Vikās Samsthā graciously re-released the Yashomudra font under the SIL Open Font License to enable the project to proceed and greatly encouraged us. ParaType designed the original PT Serif font.

