/*
 * Copyright 2023 KylinSoft Co., Ltd.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef BRIGHTNESSNODE_H
#define BRIGHTNESSNODE_H

#include <QObject>

#include "upmpreprocessor.h"

#define BRIGHTNESS_NODE_PATH "/sys/class/backlight/"
#define RESERVE_BRIGHTNESS_PERCENT    3

class BrightnessNode : public QObject
{
    Q_OBJECT
public:
    explicit BrightnessNode(int percent, QObject *parent = nullptr);
    ~BrightnessNode();

private:
    bool m_hasEffectiveNode;
    int m_maxbrightness;
    int m_effectiveMaxbrightness;
    int m_brightnessPercent;

    QStringList m_nodeDirs;
    QString m_effectiveNodePath;

    void initBrightnessNodeInfo();
    void initBrightnessPercent(int percent);
    QString getBrightnessNodeFileContent(const QString &strNodePath, const QString &strNodeFile);
    bool getEffectiveBrightnessNode(const QStringList &nodesType, const QString &type);
    bool compatibleBrightnessNode();

    void setCurrentBrightness(int brightness);
    int getCurrentBrightness();

public:
    bool canSetBrightness();
    void setBrightnessPercent(int);
    int getBrightnessPercent();
    int getMaxBrightness();
    void setReduceMaxBrightness(bool);
};

#endif // BRIGHTNESSNODE_H
