/*
 * Copyright (C) 2013 Canonical, Ltd.
 *
 * This program is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 3, as published
 * by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranties of
 * MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR
 * PURPOSE.  See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Author: Pawel Stolowski <pawel.stolowski@canonical.com>
 */

#ifndef SMARTSCOPESPARSER_H
#define SMARTSCOPESPARSER_H

#include <QString>
#include <QVariantMap>
#include <functional>
#include <memory>

#include <glib.h>

struct SmartScopesResult
{
    QString uri;
    QString title;
    QString comment;
    QString mimetype;
    QString icon_hint;
    QString dnd_uri;
    unsigned int category;
    unsigned int resultType;
    QVariantHash metadata;

    GVariant* toGVariant() const;
};

typedef std::function<void(const QString&, std::shared_ptr<SmartScopesResult> result)> ResultHandler;
typedef std::function<void(const QString &)> RecommendationsHandler;

class SmartScopesParser
{
public:
    void parseLine(const QString& text, const ResultHandler& resultHandler, const RecommendationsHandler &recommendationsHandler);

private:
    void handleResults(const QJsonObject& root, const ResultHandler& resultHandler);
    void handleRecommendations(const QJsonObject& root, const RecommendationsHandler &recommendationsHandler);
};

#endif
